# coding: utf-8

"""
    FINBOURNE Workflows API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.1.25
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from lusid_workflows.configuration import Configuration


class Workflow(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
      required_map (dict): The key is attribute name
                           and the value is whether it is 'required' or 'optional'.
    """
    openapi_types = {
        'description': 'str',
        'code': 'str',
        'latest_version': 'int'
    }

    attribute_map = {
        'description': 'description',
        'code': 'code',
        'latest_version': 'latestVersion'
    }

    required_map = {
        'description': 'optional',
        'code': 'optional',
        'latest_version': 'optional'
    }

    def __init__(self, description=None, code=None, latest_version=None, local_vars_configuration=None):  # noqa: E501
        """Workflow - a model defined in OpenAPI"
        
        :param description:  Workflow Description.
        :type description: str
        :param code:  Friendly workflow code for example IssueWorkflow, PortfolioCreatedWorkflow, TradeBookingWorkflow etc
        :type code: str
        :param latest_version:  Latest workflow definition version. This version increments when workflow definition changes.
        :type latest_version: int

        """  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._description = None
        self._code = None
        self._latest_version = None
        self.discriminator = None

        self.description = description
        self.code = code
        if latest_version is not None:
            self.latest_version = latest_version

    @property
    def description(self):
        """Gets the description of this Workflow.  # noqa: E501

        Workflow Description.  # noqa: E501

        :return: The description of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Workflow.

        Workflow Description.  # noqa: E501

        :param description: The description of this Workflow.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def code(self):
        """Gets the code of this Workflow.  # noqa: E501

        Friendly workflow code for example IssueWorkflow, PortfolioCreatedWorkflow, TradeBookingWorkflow etc  # noqa: E501

        :return: The code of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this Workflow.

        Friendly workflow code for example IssueWorkflow, PortfolioCreatedWorkflow, TradeBookingWorkflow etc  # noqa: E501

        :param code: The code of this Workflow.  # noqa: E501
        :type code: str
        """

        self._code = code

    @property
    def latest_version(self):
        """Gets the latest_version of this Workflow.  # noqa: E501

        Latest workflow definition version. This version increments when workflow definition changes.  # noqa: E501

        :return: The latest_version of this Workflow.  # noqa: E501
        :rtype: int
        """
        return self._latest_version

    @latest_version.setter
    def latest_version(self, latest_version):
        """Sets the latest_version of this Workflow.

        Latest workflow definition version. This version increments when workflow definition changes.  # noqa: E501

        :param latest_version: The latest_version of this Workflow.  # noqa: E501
        :type latest_version: int
        """

        self._latest_version = latest_version

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Workflow):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Workflow):
            return True

        return self.to_dict() != other.to_dict()
