"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosSlbBinding = exports.RosNamespace = exports.RosApplication = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosApplicationProps`
 *
 * @param properties - the TypeScript properties of a `RosApplicationProps`
 *
 * @returns the result of the validation.
 */
function RosApplicationPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('timezone', ros.validateString)(properties.timezone));
    if (properties.appDescription && (Array.isArray(properties.appDescription) || (typeof properties.appDescription) === 'string')) {
        errors.collect(ros.propertyValidator('appDescription', ros.validateLength)({
            data: properties.appDescription.length,
            min: undefined,
            max: 1024,
        }));
    }
    errors.collect(ros.propertyValidator('appDescription', ros.validateString)(properties.appDescription));
    errors.collect(ros.propertyValidator('mountDesc', ros.validateString)(properties.mountDesc));
    errors.collect(ros.propertyValidator('nasId', ros.validateString)(properties.nasId));
    errors.collect(ros.propertyValidator('warStartOptions', ros.validateString)(properties.warStartOptions));
    errors.collect(ros.propertyValidator('liveness', ros.validateString)(properties.liveness));
    errors.collect(ros.propertyValidator('memory', ros.requiredValidator)(properties.memory));
    if (properties.memory && (typeof properties.memory) !== 'object') {
        errors.collect(ros.propertyValidator('memory', ros.validateRange)({
            data: properties.memory,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('memory', ros.validateNumber)(properties.memory));
    errors.collect(ros.propertyValidator('webContainer', ros.validateString)(properties.webContainer));
    errors.collect(ros.propertyValidator('slsConfigs', ros.validateString)(properties.slsConfigs));
    errors.collect(ros.propertyValidator('cpu', ros.requiredValidator)(properties.cpu));
    if (properties.cpu && (typeof properties.cpu) !== 'object') {
        errors.collect(ros.propertyValidator('cpu', ros.validateRange)({
            data: properties.cpu,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('cpu', ros.validateNumber)(properties.cpu));
    errors.collect(ros.propertyValidator('deploy', ros.validateBoolean)(properties.deploy));
    errors.collect(ros.propertyValidator('packageVersion', ros.validateString)(properties.packageVersion));
    errors.collect(ros.propertyValidator('appName', ros.requiredValidator)(properties.appName));
    errors.collect(ros.propertyValidator('appName', ros.validateString)(properties.appName));
    errors.collect(ros.propertyValidator('jdk', ros.validateString)(properties.jdk));
    errors.collect(ros.propertyValidator('jarStartArgs', ros.validateString)(properties.jarStartArgs));
    errors.collect(ros.propertyValidator('preStop', ros.validateString)(properties.preStop));
    errors.collect(ros.propertyValidator('readiness', ros.validateString)(properties.readiness));
    errors.collect(ros.propertyValidator('packageType', ros.requiredValidator)(properties.packageType));
    errors.collect(ros.propertyValidator('packageType', ros.validateString)(properties.packageType));
    errors.collect(ros.propertyValidator('commandArgs', ros.validateString)(properties.commandArgs));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('envs', ros.validateString)(properties.envs));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('imageUrl', ros.validateString)(properties.imageUrl));
    errors.collect(ros.propertyValidator('postStart', ros.validateString)(properties.postStart));
    errors.collect(ros.propertyValidator('jarStartOptions', ros.validateString)(properties.jarStartOptions));
    errors.collect(ros.propertyValidator('mountHost', ros.validateString)(properties.mountHost));
    errors.collect(ros.propertyValidator('replicas', ros.requiredValidator)(properties.replicas));
    errors.collect(ros.propertyValidator('replicas', ros.validateNumber)(properties.replicas));
    errors.collect(ros.propertyValidator('customHostAlias', ros.validateString)(properties.customHostAlias));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('command', ros.validateString)(properties.command));
    errors.collect(ros.propertyValidator('edasContainerVersion', ros.validateString)(properties.edasContainerVersion));
    errors.collect(ros.propertyValidator('packageUrl', ros.validateString)(properties.packageUrl));
    errors.collect(ros.propertyValidator('namespaceId', ros.requiredValidator)(properties.namespaceId));
    errors.collect(ros.propertyValidator('namespaceId', ros.validateString)(properties.namespaceId));
    return errors.wrap('supplied properties not correct for "RosApplicationProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::SAE::Application` resource
 *
 * @param properties - the TypeScript properties of a `RosApplicationProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::SAE::Application` resource.
 */
// @ts-ignore TS6133
function rosApplicationPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosApplicationPropsValidator(properties).assertSuccess();
    }
    return {
        AppName: ros.stringToRosTemplate(properties.appName),
        Cpu: ros.numberToRosTemplate(properties.cpu),
        Memory: ros.numberToRosTemplate(properties.memory),
        NamespaceId: ros.stringToRosTemplate(properties.namespaceId),
        PackageType: ros.stringToRosTemplate(properties.packageType),
        Replicas: ros.numberToRosTemplate(properties.replicas),
        AppDescription: ros.stringToRosTemplate(properties.appDescription),
        Command: ros.stringToRosTemplate(properties.command),
        CommandArgs: ros.stringToRosTemplate(properties.commandArgs),
        CustomHostAlias: ros.stringToRosTemplate(properties.customHostAlias),
        Deploy: ros.booleanToRosTemplate(properties.deploy),
        EdasContainerVersion: ros.stringToRosTemplate(properties.edasContainerVersion),
        Envs: ros.stringToRosTemplate(properties.envs),
        ImageUrl: ros.stringToRosTemplate(properties.imageUrl),
        JarStartArgs: ros.stringToRosTemplate(properties.jarStartArgs),
        JarStartOptions: ros.stringToRosTemplate(properties.jarStartOptions),
        Jdk: ros.stringToRosTemplate(properties.jdk),
        Liveness: ros.stringToRosTemplate(properties.liveness),
        MountDesc: ros.stringToRosTemplate(properties.mountDesc),
        MountHost: ros.stringToRosTemplate(properties.mountHost),
        NasId: ros.stringToRosTemplate(properties.nasId),
        PackageUrl: ros.stringToRosTemplate(properties.packageUrl),
        PackageVersion: ros.stringToRosTemplate(properties.packageVersion),
        PostStart: ros.stringToRosTemplate(properties.postStart),
        PreStop: ros.stringToRosTemplate(properties.preStop),
        Readiness: ros.stringToRosTemplate(properties.readiness),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        SlsConfigs: ros.stringToRosTemplate(properties.slsConfigs),
        Timezone: ros.stringToRosTemplate(properties.timezone),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        WarStartOptions: ros.stringToRosTemplate(properties.warStartOptions),
        WebContainer: ros.stringToRosTemplate(properties.webContainer),
    };
}
/**
 * A ROS template type:  `ALIYUN::SAE::Application`
 */
class RosApplication extends ros.RosResource {
    /**
     * Create a new `ALIYUN::SAE::Application`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosApplication.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAppId = ros.Token.asString(this.getAtt('AppId'));
        this.attrChangeOrderId = ros.Token.asString(this.getAtt('ChangeOrderId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.appName = props.appName;
        this.cpu = props.cpu;
        this.memory = props.memory;
        this.namespaceId = props.namespaceId;
        this.packageType = props.packageType;
        this.replicas = props.replicas;
        this.appDescription = props.appDescription;
        this.command = props.command;
        this.commandArgs = props.commandArgs;
        this.customHostAlias = props.customHostAlias;
        this.deploy = props.deploy;
        this.edasContainerVersion = props.edasContainerVersion;
        this.envs = props.envs;
        this.imageUrl = props.imageUrl;
        this.jarStartArgs = props.jarStartArgs;
        this.jarStartOptions = props.jarStartOptions;
        this.jdk = props.jdk;
        this.liveness = props.liveness;
        this.mountDesc = props.mountDesc;
        this.mountHost = props.mountHost;
        this.nasId = props.nasId;
        this.packageUrl = props.packageUrl;
        this.packageVersion = props.packageVersion;
        this.postStart = props.postStart;
        this.preStop = props.preStop;
        this.readiness = props.readiness;
        this.securityGroupId = props.securityGroupId;
        this.slsConfigs = props.slsConfigs;
        this.timezone = props.timezone;
        this.vpcId = props.vpcId;
        this.vSwitchId = props.vSwitchId;
        this.warStartOptions = props.warStartOptions;
        this.webContainer = props.webContainer;
    }
    get rosProperties() {
        return {
            appName: this.appName,
            cpu: this.cpu,
            memory: this.memory,
            namespaceId: this.namespaceId,
            packageType: this.packageType,
            replicas: this.replicas,
            appDescription: this.appDescription,
            command: this.command,
            commandArgs: this.commandArgs,
            customHostAlias: this.customHostAlias,
            deploy: this.deploy,
            edasContainerVersion: this.edasContainerVersion,
            envs: this.envs,
            imageUrl: this.imageUrl,
            jarStartArgs: this.jarStartArgs,
            jarStartOptions: this.jarStartOptions,
            jdk: this.jdk,
            liveness: this.liveness,
            mountDesc: this.mountDesc,
            mountHost: this.mountHost,
            nasId: this.nasId,
            packageUrl: this.packageUrl,
            packageVersion: this.packageVersion,
            postStart: this.postStart,
            preStop: this.preStop,
            readiness: this.readiness,
            securityGroupId: this.securityGroupId,
            slsConfigs: this.slsConfigs,
            timezone: this.timezone,
            vpcId: this.vpcId,
            vSwitchId: this.vSwitchId,
            warStartOptions: this.warStartOptions,
            webContainer: this.webContainer,
        };
    }
    renderProperties(props) {
        return rosApplicationPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosApplication = RosApplication;
/**
 * The resource type name for this resource class.
 */
RosApplication.ROS_RESOURCE_TYPE_NAME = "ALIYUN::SAE::Application";
/**
 * Determine whether the given properties match those of a `RosNamespaceProps`
 *
 * @param properties - the TypeScript properties of a `RosNamespaceProps`
 *
 * @returns the result of the validation.
 */
function RosNamespacePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('namespaceName', ros.requiredValidator)(properties.namespaceName));
    errors.collect(ros.propertyValidator('namespaceName', ros.validateString)(properties.namespaceName));
    errors.collect(ros.propertyValidator('namespaceId', ros.requiredValidator)(properties.namespaceId));
    errors.collect(ros.propertyValidator('namespaceId', ros.validateString)(properties.namespaceId));
    errors.collect(ros.propertyValidator('namespaceDescription', ros.validateString)(properties.namespaceDescription));
    return errors.wrap('supplied properties not correct for "RosNamespaceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::SAE::Namespace` resource
 *
 * @param properties - the TypeScript properties of a `RosNamespaceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::SAE::Namespace` resource.
 */
// @ts-ignore TS6133
function rosNamespacePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosNamespacePropsValidator(properties).assertSuccess();
    }
    return {
        NamespaceId: ros.stringToRosTemplate(properties.namespaceId),
        NamespaceName: ros.stringToRosTemplate(properties.namespaceName),
        NamespaceDescription: ros.stringToRosTemplate(properties.namespaceDescription),
    };
}
/**
 * A ROS template type:  `ALIYUN::SAE::Namespace`
 */
class RosNamespace extends ros.RosResource {
    /**
     * Create a new `ALIYUN::SAE::Namespace`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosNamespace.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrNamespaceId = ros.Token.asString(this.getAtt('NamespaceId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.namespaceId = props.namespaceId;
        this.namespaceName = props.namespaceName;
        this.namespaceDescription = props.namespaceDescription;
    }
    get rosProperties() {
        return {
            namespaceId: this.namespaceId,
            namespaceName: this.namespaceName,
            namespaceDescription: this.namespaceDescription,
        };
    }
    renderProperties(props) {
        return rosNamespacePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosNamespace = RosNamespace;
/**
 * The resource type name for this resource class.
 */
RosNamespace.ROS_RESOURCE_TYPE_NAME = "ALIYUN::SAE::Namespace";
/**
 * Determine whether the given properties match those of a `RosSlbBindingProps`
 *
 * @param properties - the TypeScript properties of a `RosSlbBindingProps`
 *
 * @returns the result of the validation.
 */
function RosSlbBindingPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('internetSlbId', ros.validateString)(properties.internetSlbId));
    errors.collect(ros.propertyValidator('appId', ros.requiredValidator)(properties.appId));
    errors.collect(ros.propertyValidator('appId', ros.validateString)(properties.appId));
    errors.collect(ros.propertyValidator('intranet', ros.validateString)(properties.intranet));
    errors.collect(ros.propertyValidator('intranetSlbId', ros.validateString)(properties.intranetSlbId));
    errors.collect(ros.propertyValidator('internet', ros.validateString)(properties.internet));
    return errors.wrap('supplied properties not correct for "RosSlbBindingProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::SAE::SlbBinding` resource
 *
 * @param properties - the TypeScript properties of a `RosSlbBindingProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::SAE::SlbBinding` resource.
 */
// @ts-ignore TS6133
function rosSlbBindingPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSlbBindingPropsValidator(properties).assertSuccess();
    }
    return {
        AppId: ros.stringToRosTemplate(properties.appId),
        Internet: ros.stringToRosTemplate(properties.internet),
        InternetSlbId: ros.stringToRosTemplate(properties.internetSlbId),
        Intranet: ros.stringToRosTemplate(properties.intranet),
        IntranetSlbId: ros.stringToRosTemplate(properties.intranetSlbId),
    };
}
/**
 * A ROS template type:  `ALIYUN::SAE::SlbBinding`
 */
class RosSlbBinding extends ros.RosResource {
    /**
     * Create a new `ALIYUN::SAE::SlbBinding`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSlbBinding.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAppId = ros.Token.asString(this.getAtt('AppId'));
        this.attrChangeOrderId = ros.Token.asString(this.getAtt('ChangeOrderId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.appId = props.appId;
        this.internet = props.internet;
        this.internetSlbId = props.internetSlbId;
        this.intranet = props.intranet;
        this.intranetSlbId = props.intranetSlbId;
    }
    get rosProperties() {
        return {
            appId: this.appId,
            internet: this.internet,
            internetSlbId: this.internetSlbId,
            intranet: this.intranet,
            intranetSlbId: this.intranetSlbId,
        };
    }
    renderProperties(props) {
        return rosSlbBindingPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSlbBinding = RosSlbBinding;
/**
 * The resource type name for this resource class.
 */
RosSlbBinding.ROS_RESOURCE_TYPE_NAME = "ALIYUN::SAE::SlbBinding";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2FlLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNhZS5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHlEQUF5RDs7O0FBRXpELDhDQUE4QztBQWdMOUM7Ozs7OztHQU1HO0FBQ0gsU0FBUyw0QkFBNEIsQ0FBQyxVQUFlO0lBQ2pELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsSUFBRyxVQUFVLENBQUMsY0FBYyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxjQUFjLENBQUMsS0FBSyxRQUFRLENBQUMsRUFBRTtRQUMzSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUM7WUFDdkUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxjQUFjLENBQUMsTUFBTTtZQUN0QyxHQUFHLEVBQUUsU0FBUztZQUNkLEdBQUcsRUFBRSxJQUFJO1NBQ1YsQ0FBQyxDQUFDLENBQUM7S0FDVDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDckYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQ3pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzFGLElBQUcsVUFBVSxDQUFDLE1BQU0sSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLE1BQU0sQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUM3RCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBQzlELElBQUksRUFBRSxVQUFVLENBQUMsTUFBTTtZQUN2QixHQUFHLEVBQUUsQ0FBQztZQUNOLEdBQUcsRUFBRSxTQUFTO1NBQ2YsQ0FBQyxDQUFDLENBQUM7S0FDVDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDdkYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNwRixJQUFHLFVBQVUsQ0FBQyxHQUFHLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxHQUFHLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDdkQsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUMzRCxJQUFJLEVBQUUsVUFBVSxDQUFDLEdBQUc7WUFDcEIsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsU0FBUztTQUNmLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDeEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUM1RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDN0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNqRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNuRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM3RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM3RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ25ILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJEQUEyRCxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGdDQUFnQyxDQUFDLFVBQWUsRUFBRSxnQ0FBeUM7SUFDaEcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELElBQUcsZ0NBQWdDLEVBQUU7UUFDakMsNEJBQTRCLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7S0FDNUQ7SUFDRCxPQUFPO1FBQ0wsT0FBTyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3BELEdBQUcsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUM1QyxNQUFNLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUM7UUFDbEQsV0FBVyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQzVELFdBQVcsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUM1RCxRQUFRLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDdEQsY0FBYyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ2xFLE9BQU8sRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUNwRCxXQUFXLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDNUQsZUFBZSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3BFLE1BQU0sRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQztRQUNuRCxvQkFBb0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQzlFLElBQUksRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUM5QyxRQUFRLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDdEQsWUFBWSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQzlELGVBQWUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUNwRSxHQUFHLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7UUFDNUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3RELFNBQVMsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUN4RCxTQUFTLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDeEQsS0FBSyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDO1FBQ2hELFVBQVUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUMxRCxjQUFjLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDbEUsU0FBUyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQ3hELE9BQU8sRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUNwRCxTQUFTLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDeEQsZUFBZSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3BFLFVBQVUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUMxRCxRQUFRLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDdEQsS0FBSyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDO1FBQ2hELFNBQVMsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUN4RCxlQUFlLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDcEUsWUFBWSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO0tBQy9ELENBQUM7QUFDTixDQUFDO0FBRUQ7O0dBRUc7QUFDSCxNQUFhLGNBQWUsU0FBUSxHQUFHLENBQUMsV0FBVztJQWdNL0M7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUEwQixFQUFFLGdDQUF5QztRQUMvRyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxjQUFjLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7UUFDckYsSUFBSSxDQUFDLFNBQVMsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7UUFDMUQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztRQUUxRSxJQUFJLENBQUMsZ0NBQWdDLEdBQUcsZ0NBQWdDLENBQUM7UUFDekUsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztRQUNyQixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7UUFDM0IsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUNyQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztRQUN2QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQyxHQUFHLENBQUM7UUFDckIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO0lBQzNDLENBQUM7SUFHRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQixHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7WUFDYixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07WUFDbkIsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3JDLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtZQUNuQixvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQy9DLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNmLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3JDLEdBQUcsRUFBRSxJQUFJLENBQUMsR0FBRztZQUNiLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztZQUNqQixVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztZQUNqQixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3JDLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtTQUNsQyxDQUFDO0lBQ04sQ0FBQztJQUNTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sZ0NBQWdDLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQzFGLENBQUM7O0FBeFJMLHdDQXlSQztBQXhSRzs7R0FFRztBQUNvQixxQ0FBc0IsR0FBRywwQkFBMEIsQ0FBQztBQTRTL0U7Ozs7OztHQU1HO0FBQ0gsU0FBUywwQkFBMEIsQ0FBQyxVQUFlO0lBQy9DLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztJQUN4RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3JHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNwRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ25ILE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyx5REFBeUQsQ0FBQyxDQUFDO0FBQ2xGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw4QkFBOEIsQ0FBQyxVQUFlLEVBQUUsZ0NBQXlDO0lBQzlGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxJQUFHLGdDQUFnQyxFQUFFO1FBQ2pDLDBCQUEwQixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0tBQzFEO0lBQ0QsT0FBTztRQUNMLFdBQVcsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUM1RCxhQUFhLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDaEUsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztLQUMvRSxDQUFDO0FBQ04sQ0FBQztBQUVEOztHQUVHO0FBQ0gsTUFBYSxZQUFhLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFrQzdDOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBd0IsRUFBRSxnQ0FBeUM7UUFDN0csS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsWUFBWSxDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ25GLElBQUksQ0FBQyxlQUFlLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO1FBRXRFLElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxnQ0FBZ0MsQ0FBQztRQUN6RSxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7SUFDM0QsQ0FBQztJQUdELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1NBQ2xELENBQUM7SUFDTixDQUFDO0lBQ1MsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyw4QkFBOEIsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDeEYsQ0FBQzs7QUE3REwsb0NBOERDO0FBN0RHOztHQUVHO0FBQ29CLG1DQUFzQixHQUFHLHdCQUF3QixDQUFDO0FBMkY3RTs7Ozs7O0dBTUc7QUFDSCxTQUFTLDJCQUEyQixDQUFDLFVBQWU7SUFDaEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztJQUNyRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDeEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDckcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsMERBQTBELENBQUMsQ0FBQztBQUNuRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsK0JBQStCLENBQUMsVUFBZSxFQUFFLGdDQUF5QztJQUMvRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsSUFBRyxnQ0FBZ0MsRUFBRTtRQUNqQywyQkFBMkIsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztLQUMzRDtJQUNELE9BQU87UUFDTCxLQUFLLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7UUFDaEQsUUFBUSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3RELGFBQWEsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUNoRSxRQUFRLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDdEQsYUFBYSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO0tBQ2pFLENBQUM7QUFDTixDQUFDO0FBRUQ7O0dBRUc7QUFDSCxNQUFhLGFBQWMsU0FBUSxHQUFHLENBQUMsV0FBVztJQWlEOUM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUF5QixFQUFFLGdDQUF5QztRQUM5RyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxhQUFhLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFNBQVMsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7UUFDMUQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztRQUUxRSxJQUFJLENBQUMsZ0NBQWdDLEdBQUcsZ0NBQWdDLENBQUM7UUFDekUsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFDekMsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztJQUM3QyxDQUFDO0lBR0QsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDakIsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1NBQ3BDLENBQUM7SUFDTixDQUFDO0lBQ1MsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTywrQkFBK0IsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDekYsQ0FBQzs7QUFqRkwsc0NBa0ZDO0FBakZHOztHQUVHO0FBQ29CLG9DQUFzQixHQUFHLHlCQUF5QixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXHJcblxyXG5pbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XHJcblxyXG4vKipcclxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQUxJWVVOOjpTQUU6OkFwcGxpY2F0aW9uYFxyXG4gKi9cclxuZXhwb3J0IGludGVyZmFjZSBSb3NBcHBsaWNhdGlvblByb3BzIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhcHBOYW1lOiBBcHBsaWNhdGlvbiBOYW1lLiBBbGxvd2VkIG51bWJlcnMsIGxldHRlcnMgYW5kIHVuZGVybGluZWQgY29tYmluYXRpb25zIHRoZXJlb2YuIFdlIG11c3QgYmVnaW4gd2l0aCB0aGUgbGV0dGVycywgdGhlIG1heGltdW0gbGVuZ3RoIG9mIDM2IGNoYXJhY3RlcnMuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGFwcE5hbWU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBjcHU6IEVhY2ggaW5zdGFuY2Ugb2YgdGhlIENQVSByZXF1aXJlZCwgaW4gdW5pdHMgb2YgbWlsbGkgY29yZSwgY2FuIG5vdCBiZSB6ZXJvLiBDdXJyZW50bHkgb25seSBzdXBwb3J0cyBmaXhlZCBzcGVjaWZpY2F0aW9ucyBpbnN0YW5jZSB0eXBlLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBjcHU6IG51bWJlcjtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBtZW1vcnk6IEVhY2ggaW5zdGFuY2Ugb2YgdGhlIHJlcXVpcmVkIG1lbW9yeSwgaW4gdW5pdHMgb2YgTUIsIGNhbiBub3QgYmUgemVyby4gQ3VycmVudGx5IG9ubHkgc3VwcG9ydHMgZml4ZWQgc3BlY2lmaWNhdGlvbnMgaW5zdGFuY2UgdHlwZS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgbWVtb3J5OiBudW1iZXI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgbmFtZXNwYWNlSWQ6IEVEQVMgbmFtZXNwYWNlIGNvcnJlc3BvbmRpbmcgdG8gSUQuIENhbmFkYSBzdXBwb3J0cyBvbmx5IHRoZSBuYW1lIG9mIHRoZSBzY3JpYmUgbG93ZXJjYXNlIG5hbWVzcGFjZSBtdXN0IGJlZ2luIHdpdGggYSBsZXR0ZXIuXHJcbiAgICAgKiBOYW1lc3BhY2UgY2FuIGludGVyZmFjZSB0byBvYnRhaW4gZnJvbSBEZXNjcmliZU5hbWVzcGFjZUxpc3QuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IG5hbWVzcGFjZUlkOiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgcGFja2FnZVR5cGU6IEFwcGxpY2F0aW9uIHBhY2thZ2UgdHlwZS4gU3VwcG9ydCBGYXRKYXIsIFdhciwgSW1hZ2UuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHBhY2thZ2VUeXBlOiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgcmVwbGljYXM6IFRoZSBpbml0aWFsIG51bWJlciBvZiBpbnN0YW5jZXMuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHJlcGxpY2FzOiBudW1iZXI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgYXBwRGVzY3JpcHRpb246IEFwcGxpY2F0aW9uIGRlc2NyaXB0aW9uLiBObyBtb3JlIHRoYW4gMTAyNCBjaGFyYWN0ZXJzLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBhcHBEZXNjcmlwdGlvbj86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBjb21tYW5kOiBNaXJyb3JpbmcgdGhlIHN0YXJ0IGNvbW1hbmQuIFRoZSBjb21tYW5kIG9iamVjdCBpbiBtZW1vcnkgZXhlY3V0YWJsZSBjb250YWluZXIgbXVzdCBiZS4gRm9yIGV4YW1wbGU6IHNsZWVwLiBUaGlzIGNvbW1hbmQgd2lsbCBjYXVzZSB0aGUgaW1hZ2UgdG8gc2V0IHRoZSBvcmlnaW5hbCBzdGFydHVwIGNvbW1hbmQgZmFpbHVyZS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgY29tbWFuZD86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBjb21tYW5kQXJnczogTWlycm9yaW5nIHRoZSBzdGFydCBjb21tYW5kIHBhcmFtZXRlcnMuIFBhcmFtZXRlcnMgcmVxdWlyZWQgZm9yIHRoZSBzdGFydC1jb21tYW5kLiBGb3IgZXhhbXBsZTogWyBcIjFkXCJdXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGNvbW1hbmRBcmdzPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGN1c3RvbUhvc3RBbGlhczogQ3VzdG9tIG1hcHBpbmcgaG9zdCB2ZXNzZWwuIEZvciBleGFtcGxlOiBbeyBcImhvc3ROYW1lXCI6IFwic2FtcGxlaG9zdFwiLCBcImlwXCI6IFwiMTI3LjAuMC4xXCJ9XVxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBjdXN0b21Ib3N0QWxpYXM/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZGVwbG95OiBXaGV0aGVyIGRlcGxveWVkIGltbWVkaWF0ZWx5IHRha2UgZWZmZWN0LCB0aGUgZGVmYXVsdCBpcyBmYWxzZS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgZGVwbG95PzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBlZGFzQ29udGFpbmVyVmVyc2lvbjogRURBUyBwYW5kb3JhIHJ1bnRpbWUgZW52aXJvbm1lbnQgdXNlZCBieSB0aGUgYXBwbGljYXRpb24uXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGVkYXNDb250YWluZXJWZXJzaW9uPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGVudnM6IENvbnRhaW5lciBlbnZpcm9ubWVudCB2YXJpYWJsZSBwYXJhbWV0ZXJzLiBGb3IgZXhhbXBsZTogW3sgXCJuYW1lXCI6IFwiZW52dG1wXCIsIFwidmFsdWVcIjogXCIwXCJ9XVxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBlbnZzPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGltYWdlVXJsOiBNaXJyb3JpbmcgYWRkcmVzcy4gSW1hZ2Ugb25seSB0eXBlIG9mIGFwcGxpY2F0aW9uIGNhbiBiZSBjb25maWd1cmVkIHRvIG1pcnJvciBhZGRyZXNzLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBpbWFnZVVybD86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBqYXJTdGFydEFyZ3M6IEphciBwYWNrYWdlIHN0YXJ0dXAgYXBwbGljYXRpb24gcGFyYW1ldGVycy4gQXBwbHkgdGhlIGRlZmF1bHQgc3RhcnR1cCBjb21tYW5kOiAkIEpBVkFfSE9NRSAvIGJpbiAvIGphdmEgJCBKYXJTdGFydE9wdGlvbnMgLWphciAkIENBVEFMSU5BX09QVFMgXCIkIHBhY2thZ2VfcGF0aFwiXHJcbiAgICAgKiAkIEphclN0YXJ0QXJnc1xyXG4gICAgICovXHJcbiAgICByZWFkb25seSBqYXJTdGFydEFyZ3M/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgamFyU3RhcnRPcHRpb25zOiBKYXIgc3RhcnQgdGhlIGFwcGxpY2F0aW9uIHBhY2thZ2Ugb3B0aW9uLiBBcHBseSB0aGUgZGVmYXVsdCBzdGFydHVwIGNvbW1hbmQ6ICQgSkFWQV9IT01FIC8gYmluIC8gamF2YSAkIEphclN0YXJ0T3B0aW9ucyAtamFyICQgQ0FUQUxJTkFfT1BUUyBcIiQgcGFja2FnZV9wYXRoXCJcclxuICAgICAqICQgSmFyU3RhcnRBcmdzXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGphclN0YXJ0T3B0aW9ucz86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBqZGs6IERlcGxveW1lbnQgb2YgSkRLIHZlcnNpb24gb2YgdGhlIHBhY2thZ2UgZGVwZW5kcyBvbi4gTWlycm9yaW5nIG5vdCBzdXBwb3J0ZWQuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGpkaz86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBsaXZlbmVzczogQ29udGFpbmVyIGhlYWx0aCBjaGVjaywgaGVhbHRoIGNoZWNrIGZhaWxzIGNvbnRhaW5lciB3aWxsIGJlIGtpbGxlZCBhbmQgcmVjb3ZlcnkuIEN1cnJlbnRseSBvbmx5IHN1cHBvcnRzIG1vZGUgY29tbWFuZCBpc3N1ZWQgaW4gdGhlIGNvbnRhaW5lci4gVGhlIGNvbHVtbnM6IHsgXCJleGVjXCI6IHsgXCJjb21tYW5kXCI6IFsgXCJzbGVlcFwiLCBcIjVzXCJdfSwgXCJpbml0aWFsRGVsYXlTZWNvbmRzXCI6IDEwLCBcInRpbWVvdXRTZWNvbmRzXCI6IDExfVxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBsaXZlbmVzcz86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBtb3VudERlc2M6IE1vdW50IERlc2NyaXB0aW9uXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IG1vdW50RGVzYz86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBtb3VudEhvc3Q6IG5hcyBtb3VudCBwb2ludCBpbiB0aGUgYXBwbGljYXRpb24gb2YgdnBjLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBtb3VudEhvc3Q/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgbmFzSWQ6IE1vdW50IHRoZSBOQVMgSUQsIHlvdSBtdXN0IGJlIGluIHRoZSBzYW1lIHJlZ2lvbiBhbmQgY2x1c3Rlci4gSXQgbXVzdCBiZSBhdmFpbGFibGUgdG8gY3JlYXRlIGEgbW91bnQgcG9pbnQgbGltaXQsIG9yIHN3aXRjaCBvbiBpdHMgbW91bnQgcG9pbnQgYWxyZWFkeSBpbiB0aGUgVlBDLiBJZiB5b3UgZG8gbm90IGZpbGwsIGFuZCB0aGVyZSBtb3VudERlc2NzIGZpZWxkLCB0aGUgZGVmYXVsdCB3aWxsIGF1dG9tYXRpY2FsbHkgcHVyY2hhc2UgYSBOQVMgYW5kIG1vdW50IGl0IG9udG8gdGhlIHN3aXRjaCB3aXRoaW4gdGhlIFZQQy5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgbmFzSWQ/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgcGFja2FnZVVybDogRGVwbG95bWVudCBwYWNrYWdlcyBhZGRyZXNzLiBPbmx5IEZhdEphciBXYXIgb3IgdGhlIHR5cGUgb2YgYXBwbGljYXRpb24gY2FuIGJlIGNvbmZpZ3VyZWQgdG8gZGVwbG95IHBhY2tldCBhZGRyZXNzLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBwYWNrYWdlVXJsPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHBhY2thZ2VWZXJzaW9uOiBUaGUgdmVyc2lvbiBudW1iZXIgb2YgdGhlIGRlcGxveWVkIHBhY2thZ2UsIFdhciBGYXRKYXIgdHlwZSByZXF1aXJlZC4gUGxlYXNlIGN1c3RvbWl6ZSBpdCBtZWFuaW5nLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBwYWNrYWdlVmVyc2lvbj86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBwb3N0U3RhcnQ6IEV4ZWN1dGluZyB0aGUgc2NyaXB0LCBzdWNoIGFzIGFmdGVyIHN0YXJ0aW5nIHRoZSBmb3JtYXQ6IHsgXCJleGVjXCI6IHsgXCJjb21tYW5kXCI6IFwiY2F0XCIsIFwiLyBldGMgLyBncm91cFwifX1cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgcG9zdFN0YXJ0Pzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHByZVN0b3A6IFNjcmlwdCBpcyBleGVjdXRlZCBiZWZvcmUgc3RvcHBpbmcgdGhlIGZvcm1hdCBhczogeyBcImV4ZWNcIjogeyBcImNvbW1hbmRcIjogXCJjYXRcIiwgXCIvIGV0YyAvIGdyb3VwXCJ9fVxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBwcmVTdG9wPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHJlYWRpbmVzczogQXBwbGljYXRpb24gbGF1bmNoIHN0YXR1cyBjaGVjaywgaGVhbHRoIGNoZWNrIGZhaWxzIHJlcGVhdGVkbHkgY29udGFpbmVyIHdpbGwgYmUga2lsbGVkIGFuZCByZXN0YXJ0ZWQuIERvIG5vdCBwYXNzIGhlYWx0aCBjaGVjayBvZiB0aGUgdmVzc2VsIHdpbGwgbm90IGhhdmUgdG8gZW50ZXIgU0xCIHRyYWZmaWMuIEZvciBleGFtcGxlOiB7IFwiZXhlY1wiOiB7IFwiY29tbWFuZFwiOiBbIFwic2xlZXBcIiwgXCI2c1wiXX0sIFwiaW5pdGlhbERlbGF5U2Vjb25kc1wiOiAxNSwgXCJ0aW1lb3V0U2Vjb25kc1wiOiAxMn1cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgcmVhZGluZXNzPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHNlY3VyaXR5R3JvdXBJZDogU2VjdXJpdHkgZ3JvdXAgSUQuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBJZD86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBzbHNDb25maWdzOiBMb2cgY29sbGVjdGlvbiBjb25maWd1cmF0aW9uIGZpbGVcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgc2xzQ29uZmlncz86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSB0aW1lem9uZTogQXBwbGljYXRpb24gdGltZSB6b25lLiBEZWZhdWx0IEFzaWEvU2hhbmdoYWkuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHRpbWV6b25lPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZwY0lkOiBFREFTIG5hbWVzcGFjZSBjb3JyZXNwb25kaW5nIFZQQy4gSW4gU2VydmVybGVzcyBpbiBhIGNvcnJlc3BvbmRpbmcgb25lIG9mIHRoZSBWUEMgbmFtZXNwYWNlIG9ubHksIGFuZCBjYW4gbm90IGJlIG1vZGlmaWVkLiBTZXJ2ZXJsZXNzIGZpcnN0IGNyZWF0ZWQgaW4gdGhlIGFwcGxpY2F0aW9uIG5hbWUgc3BhY2Ugd2lsbCBmb3JtIGEgYmluZGluZyByZWxhdGlvbnNoaXAuIFlvdSBtYXkgY29ycmVzcG9uZCB0byBhIHBsdXJhbGl0eSBvZiBuYW1lc3BhY2VzIFZQQy4gRG8gbm90IGZpbGwgd2FzIFZwY0lkIG5hbWVzcGFjZSBiaW5kaW5nLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSB2cGNJZD86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSB2U3dpdGNoSWQ6IEFwcGxpY2F0aW9uIGV4YW1wbGVzIHdoZXJlIHRoZSBlbGFzdGljIGNhcmQgdmlydHVhbCBzd2l0Y2guIFRoZSBzd2l0Y2ggbXVzdCBiZSBsb2NhdGVkIGFib3ZlIHRoZSBWUEMuIFRoZSBzYW1lIHN3aXRjaCB3aXRoIEVEQVMgbmFtZXNwYWNlIGJpbmRpbmcgcmVsYXRpb25zaGlwLiBEbyBub3QgZmlsbCB3YXMgVlN3aXRjaElkIG5hbWVzcGFjZSBiaW5kaW5nLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSB2U3dpdGNoSWQ/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgd2FyU3RhcnRPcHRpb25zOiBXYXIgU3RhcnQgdGhlIGFwcGxpY2F0aW9uIHBhY2thZ2Ugb3B0aW9uLiBBcHBseSB0aGUgZGVmYXVsdCBzdGFydHVwIGNvbW1hbmQ6IGphdmEgJCBKQVZBX09QVFMgJCBDQVRBTElOQV9PUFRTIC1PcHRpb25zIG9yZy5hcGFjaGUuY2F0YWxpbmEuc3RhcnR1cC5Cb290c3RyYXAgXCIkIEBcIiBzdGFydFxyXG4gICAgICovXHJcbiAgICByZWFkb25seSB3YXJTdGFydE9wdGlvbnM/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgd2ViQ29udGFpbmVyOiBUb21jYXQgZGVwbG95bWVudCBvZiB0aGUgcGFja2FnZSBkZXBlbmRzIG9uIHRoZSB2ZXJzaW9uLiBNaXJyb3Jpbmcgbm90IHN1cHBvcnRlZC5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgd2ViQ29udGFpbmVyPzogc3RyaW5nO1xyXG59XHJcblxyXG4vKipcclxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUm9zQXBwbGljYXRpb25Qcm9wc2BcclxuICpcclxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFJvc0FwcGxpY2F0aW9uUHJvcHNgXHJcbiAqXHJcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXHJcbiAqL1xyXG5mdW5jdGlvbiBSb3NBcHBsaWNhdGlvblByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcclxuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHJvcy5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cclxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyByb3MuVmFsaWRhdGlvblJlc3VsdHMoKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndGltZXpvbmUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudGltZXpvbmUpKTtcclxuICAgIGlmKHByb3BlcnRpZXMuYXBwRGVzY3JpcHRpb24gJiYgKEFycmF5LmlzQXJyYXkocHJvcGVydGllcy5hcHBEZXNjcmlwdGlvbikgfHwgKHR5cGVvZiBwcm9wZXJ0aWVzLmFwcERlc2NyaXB0aW9uKSA9PT0gJ3N0cmluZycpKSB7XHJcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdhcHBEZXNjcmlwdGlvbicsIHJvcy52YWxpZGF0ZUxlbmd0aCkoe1xyXG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmFwcERlc2NyaXB0aW9uLmxlbmd0aCxcclxuICAgICAgICAgICAgbWluOiB1bmRlZmluZWQsXHJcbiAgICAgICAgICAgIG1heDogMTAyNCxcclxuICAgICAgICAgIH0pKTtcclxuICAgIH1cclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXBwRGVzY3JpcHRpb24nLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYXBwRGVzY3JpcHRpb24pKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbW91bnREZXNjJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm1vdW50RGVzYykpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCduYXNJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYXNJZCkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd3YXJTdGFydE9wdGlvbnMnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMud2FyU3RhcnRPcHRpb25zKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2xpdmVuZXNzJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmxpdmVuZXNzKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ21lbW9yeScsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5tZW1vcnkpKTtcclxuICAgIGlmKHByb3BlcnRpZXMubWVtb3J5ICYmICh0eXBlb2YgcHJvcGVydGllcy5tZW1vcnkpICE9PSAnb2JqZWN0Jykge1xyXG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbWVtb3J5Jywgcm9zLnZhbGlkYXRlUmFuZ2UpKHtcclxuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5tZW1vcnksXHJcbiAgICAgICAgICAgIG1pbjogMSxcclxuICAgICAgICAgICAgbWF4OiB1bmRlZmluZWQsXHJcbiAgICAgICAgICB9KSk7XHJcbiAgICB9XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ21lbW9yeScsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tZW1vcnkpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignd2ViQ29udGFpbmVyJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLndlYkNvbnRhaW5lcikpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzbHNDb25maWdzJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNsc0NvbmZpZ3MpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY3B1Jywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmNwdSkpO1xyXG4gICAgaWYocHJvcGVydGllcy5jcHUgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLmNwdSkgIT09ICdvYmplY3QnKSB7XHJcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdjcHUnLCByb3MudmFsaWRhdGVSYW5nZSkoe1xyXG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmNwdSxcclxuICAgICAgICAgICAgbWluOiAxLFxyXG4gICAgICAgICAgICBtYXg6IHVuZGVmaW5lZCxcclxuICAgICAgICAgIH0pKTtcclxuICAgIH1cclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY3B1Jywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmNwdSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkZXBsb3knLCByb3MudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLmRlcGxveSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdwYWNrYWdlVmVyc2lvbicsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wYWNrYWdlVmVyc2lvbikpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdhcHBOYW1lJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmFwcE5hbWUpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXBwTmFtZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5hcHBOYW1lKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2pkaycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5qZGspKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignamFyU3RhcnRBcmdzJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmphclN0YXJ0QXJncykpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdwcmVTdG9wJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnByZVN0b3ApKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncmVhZGluZXNzJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnJlYWRpbmVzcykpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdwYWNrYWdlVHlwZScsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5wYWNrYWdlVHlwZSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdwYWNrYWdlVHlwZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wYWNrYWdlVHlwZSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdjb21tYW5kQXJncycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jb21tYW5kQXJncykpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzZWN1cml0eUdyb3VwSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc2VjdXJpdHlHcm91cElkKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2VudnMnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZW52cykpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd2U3dpdGNoSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudlN3aXRjaElkKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2ltYWdlVXJsJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmltYWdlVXJsKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3Bvc3RTdGFydCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wb3N0U3RhcnQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignamFyU3RhcnRPcHRpb25zJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmphclN0YXJ0T3B0aW9ucykpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdtb3VudEhvc3QnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubW91bnRIb3N0KSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3JlcGxpY2FzJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnJlcGxpY2FzKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3JlcGxpY2FzJywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLnJlcGxpY2FzKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2N1c3RvbUhvc3RBbGlhcycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jdXN0b21Ib3N0QWxpYXMpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndnBjSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudnBjSWQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY29tbWFuZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jb21tYW5kKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2VkYXNDb250YWluZXJWZXJzaW9uJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmVkYXNDb250YWluZXJWZXJzaW9uKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3BhY2thZ2VVcmwnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucGFja2FnZVVybCkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lc3BhY2VJZCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5uYW1lc3BhY2VJZCkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lc3BhY2VJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lc3BhY2VJZCkpO1xyXG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlJvc0FwcGxpY2F0aW9uUHJvcHNcIicpO1xyXG59XHJcblxyXG4vKipcclxuICogUmVuZGVycyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6U0FFOjpBcHBsaWNhdGlvbmAgcmVzb3VyY2VcclxuICpcclxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFJvc0FwcGxpY2F0aW9uUHJvcHNgXHJcbiAqXHJcbiAqIEByZXR1cm5zIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpTQUU6OkFwcGxpY2F0aW9uYCByZXNvdXJjZS5cclxuICovXHJcbi8vIEB0cy1pZ25vcmUgVFM2MTMzXHJcbmZ1bmN0aW9uIHJvc0FwcGxpY2F0aW9uUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pOiBhbnkge1xyXG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxyXG4gICAgaWYoZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpIHtcclxuICAgICAgICBSb3NBcHBsaWNhdGlvblByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcclxuICAgIH1cclxuICAgIHJldHVybiB7XHJcbiAgICAgIEFwcE5hbWU6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuYXBwTmFtZSksXHJcbiAgICAgIENwdTogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5jcHUpLFxyXG4gICAgICBNZW1vcnk6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubWVtb3J5KSxcclxuICAgICAgTmFtZXNwYWNlSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubmFtZXNwYWNlSWQpLFxyXG4gICAgICBQYWNrYWdlVHlwZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5wYWNrYWdlVHlwZSksXHJcbiAgICAgIFJlcGxpY2FzOiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnJlcGxpY2FzKSxcclxuICAgICAgQXBwRGVzY3JpcHRpb246IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuYXBwRGVzY3JpcHRpb24pLFxyXG4gICAgICBDb21tYW5kOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmNvbW1hbmQpLFxyXG4gICAgICBDb21tYW5kQXJnczogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5jb21tYW5kQXJncyksXHJcbiAgICAgIEN1c3RvbUhvc3RBbGlhczogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5jdXN0b21Ib3N0QWxpYXMpLFxyXG4gICAgICBEZXBsb3k6IHJvcy5ib29sZWFuVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRlcGxveSksXHJcbiAgICAgIEVkYXNDb250YWluZXJWZXJzaW9uOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmVkYXNDb250YWluZXJWZXJzaW9uKSxcclxuICAgICAgRW52czogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5lbnZzKSxcclxuICAgICAgSW1hZ2VVcmw6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuaW1hZ2VVcmwpLFxyXG4gICAgICBKYXJTdGFydEFyZ3M6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuamFyU3RhcnRBcmdzKSxcclxuICAgICAgSmFyU3RhcnRPcHRpb25zOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmphclN0YXJ0T3B0aW9ucyksXHJcbiAgICAgIEpkazogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5qZGspLFxyXG4gICAgICBMaXZlbmVzczogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5saXZlbmVzcyksXHJcbiAgICAgIE1vdW50RGVzYzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5tb3VudERlc2MpLFxyXG4gICAgICBNb3VudEhvc3Q6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubW91bnRIb3N0KSxcclxuICAgICAgTmFzSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubmFzSWQpLFxyXG4gICAgICBQYWNrYWdlVXJsOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnBhY2thZ2VVcmwpLFxyXG4gICAgICBQYWNrYWdlVmVyc2lvbjogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5wYWNrYWdlVmVyc2lvbiksXHJcbiAgICAgIFBvc3RTdGFydDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5wb3N0U3RhcnQpLFxyXG4gICAgICBQcmVTdG9wOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnByZVN0b3ApLFxyXG4gICAgICBSZWFkaW5lc3M6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucmVhZGluZXNzKSxcclxuICAgICAgU2VjdXJpdHlHcm91cElkOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnNlY3VyaXR5R3JvdXBJZCksXHJcbiAgICAgIFNsc0NvbmZpZ3M6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuc2xzQ29uZmlncyksXHJcbiAgICAgIFRpbWV6b25lOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnRpbWV6b25lKSxcclxuICAgICAgVnBjSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudnBjSWQpLFxyXG4gICAgICBWU3dpdGNoSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudlN3aXRjaElkKSxcclxuICAgICAgV2FyU3RhcnRPcHRpb25zOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLndhclN0YXJ0T3B0aW9ucyksXHJcbiAgICAgIFdlYkNvbnRhaW5lcjogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy53ZWJDb250YWluZXIpLFxyXG4gICAgfTtcclxufVxyXG5cclxuLyoqXHJcbiAqIEEgUk9TIHRlbXBsYXRlIHR5cGU6ICBgQUxJWVVOOjpTQUU6OkFwcGxpY2F0aW9uYFxyXG4gKi9cclxuZXhwb3J0IGNsYXNzIFJvc0FwcGxpY2F0aW9uIGV4dGVuZHMgcm9zLlJvc1Jlc291cmNlIHtcclxuICAgIC8qKlxyXG4gICAgICogVGhlIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cclxuICAgICAqL1xyXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBST1NfUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBTElZVU46OlNBRTo6QXBwbGljYXRpb25cIjtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcclxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UuXHJcbiAgICAgKi9cclxuXHJcbiAgICAvKipcclxuICAgICAqIEBBdHRyaWJ1dGUgQXBwSWQ6IENyZWF0aW5nIHN1Y2Nlc3NmdWwgYXBwbGljYXRpb24gSUQuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyByZWFkb25seSBhdHRyQXBwSWQ6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBBdHRyaWJ1dGUgQ2hhbmdlT3JkZXJJZDogUmV0dXJuIHRvIHJlbGVhc2UgYSBzaW5nbGUgSUQsIHVzZWQgdG8gcXVlcnkgdGFzayBleGVjdXRpb24gc3RhdHVzLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckNoYW5nZU9yZGVySWQ6IGFueTtcclxuXHJcbiAgICBwdWJsaWMgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW47XHJcblxyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGFwcE5hbWU6IEFwcGxpY2F0aW9uIE5hbWUuIEFsbG93ZWQgbnVtYmVycywgbGV0dGVycyBhbmQgdW5kZXJsaW5lZCBjb21iaW5hdGlvbnMgdGhlcmVvZi4gV2UgbXVzdCBiZWdpbiB3aXRoIHRoZSBsZXR0ZXJzLCB0aGUgbWF4aW11bSBsZW5ndGggb2YgMzYgY2hhcmFjdGVycy5cclxuICAgICAqL1xyXG4gICAgcHVibGljIGFwcE5hbWU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBjcHU6IEVhY2ggaW5zdGFuY2Ugb2YgdGhlIENQVSByZXF1aXJlZCwgaW4gdW5pdHMgb2YgbWlsbGkgY29yZSwgY2FuIG5vdCBiZSB6ZXJvLiBDdXJyZW50bHkgb25seSBzdXBwb3J0cyBmaXhlZCBzcGVjaWZpY2F0aW9ucyBpbnN0YW5jZSB0eXBlLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgY3B1OiBudW1iZXI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgbWVtb3J5OiBFYWNoIGluc3RhbmNlIG9mIHRoZSByZXF1aXJlZCBtZW1vcnksIGluIHVuaXRzIG9mIE1CLCBjYW4gbm90IGJlIHplcm8uIEN1cnJlbnRseSBvbmx5IHN1cHBvcnRzIGZpeGVkIHNwZWNpZmljYXRpb25zIGluc3RhbmNlIHR5cGUuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBtZW1vcnk6IG51bWJlcjtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBuYW1lc3BhY2VJZDogRURBUyBuYW1lc3BhY2UgY29ycmVzcG9uZGluZyB0byBJRC4gQ2FuYWRhIHN1cHBvcnRzIG9ubHkgdGhlIG5hbWUgb2YgdGhlIHNjcmliZSBsb3dlcmNhc2UgbmFtZXNwYWNlIG11c3QgYmVnaW4gd2l0aCBhIGxldHRlci5cclxuICAgICAqIE5hbWVzcGFjZSBjYW4gaW50ZXJmYWNlIHRvIG9idGFpbiBmcm9tIERlc2NyaWJlTmFtZXNwYWNlTGlzdC5cclxuICAgICAqL1xyXG4gICAgcHVibGljIG5hbWVzcGFjZUlkOiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgcGFja2FnZVR5cGU6IEFwcGxpY2F0aW9uIHBhY2thZ2UgdHlwZS4gU3VwcG9ydCBGYXRKYXIsIFdhciwgSW1hZ2UuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBwYWNrYWdlVHlwZTogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHJlcGxpY2FzOiBUaGUgaW5pdGlhbCBudW1iZXIgb2YgaW5zdGFuY2VzLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcmVwbGljYXM6IG51bWJlcjtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhcHBEZXNjcmlwdGlvbjogQXBwbGljYXRpb24gZGVzY3JpcHRpb24uIE5vIG1vcmUgdGhhbiAxMDI0IGNoYXJhY3RlcnMuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBhcHBEZXNjcmlwdGlvbjogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGNvbW1hbmQ6IE1pcnJvcmluZyB0aGUgc3RhcnQgY29tbWFuZC4gVGhlIGNvbW1hbmQgb2JqZWN0IGluIG1lbW9yeSBleGVjdXRhYmxlIGNvbnRhaW5lciBtdXN0IGJlLiBGb3IgZXhhbXBsZTogc2xlZXAuIFRoaXMgY29tbWFuZCB3aWxsIGNhdXNlIHRoZSBpbWFnZSB0byBzZXQgdGhlIG9yaWdpbmFsIHN0YXJ0dXAgY29tbWFuZCBmYWlsdXJlLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgY29tbWFuZDogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGNvbW1hbmRBcmdzOiBNaXJyb3JpbmcgdGhlIHN0YXJ0IGNvbW1hbmQgcGFyYW1ldGVycy4gUGFyYW1ldGVycyByZXF1aXJlZCBmb3IgdGhlIHN0YXJ0LWNvbW1hbmQuIEZvciBleGFtcGxlOiBbIFwiMWRcIl1cclxuICAgICAqL1xyXG4gICAgcHVibGljIGNvbW1hbmRBcmdzOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgY3VzdG9tSG9zdEFsaWFzOiBDdXN0b20gbWFwcGluZyBob3N0IHZlc3NlbC4gRm9yIGV4YW1wbGU6IFt7IFwiaG9zdE5hbWVcIjogXCJzYW1wbGVob3N0XCIsIFwiaXBcIjogXCIxMjcuMC4wLjFcIn1dXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBjdXN0b21Ib3N0QWxpYXM6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBkZXBsb3k6IFdoZXRoZXIgZGVwbG95ZWQgaW1tZWRpYXRlbHkgdGFrZSBlZmZlY3QsIHRoZSBkZWZhdWx0IGlzIGZhbHNlLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgZGVwbG95OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGVkYXNDb250YWluZXJWZXJzaW9uOiBFREFTIHBhbmRvcmEgcnVudGltZSBlbnZpcm9ubWVudCB1c2VkIGJ5IHRoZSBhcHBsaWNhdGlvbi5cclxuICAgICAqL1xyXG4gICAgcHVibGljIGVkYXNDb250YWluZXJWZXJzaW9uOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZW52czogQ29udGFpbmVyIGVudmlyb25tZW50IHZhcmlhYmxlIHBhcmFtZXRlcnMuIEZvciBleGFtcGxlOiBbeyBcIm5hbWVcIjogXCJlbnZ0bXBcIiwgXCJ2YWx1ZVwiOiBcIjBcIn1dXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBlbnZzOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgaW1hZ2VVcmw6IE1pcnJvcmluZyBhZGRyZXNzLiBJbWFnZSBvbmx5IHR5cGUgb2YgYXBwbGljYXRpb24gY2FuIGJlIGNvbmZpZ3VyZWQgdG8gbWlycm9yIGFkZHJlc3MuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBpbWFnZVVybDogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGphclN0YXJ0QXJnczogSmFyIHBhY2thZ2Ugc3RhcnR1cCBhcHBsaWNhdGlvbiBwYXJhbWV0ZXJzLiBBcHBseSB0aGUgZGVmYXVsdCBzdGFydHVwIGNvbW1hbmQ6ICQgSkFWQV9IT01FIC8gYmluIC8gamF2YSAkIEphclN0YXJ0T3B0aW9ucyAtamFyICQgQ0FUQUxJTkFfT1BUUyBcIiQgcGFja2FnZV9wYXRoXCJcclxuICAgICAqICQgSmFyU3RhcnRBcmdzXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBqYXJTdGFydEFyZ3M6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBqYXJTdGFydE9wdGlvbnM6IEphciBzdGFydCB0aGUgYXBwbGljYXRpb24gcGFja2FnZSBvcHRpb24uIEFwcGx5IHRoZSBkZWZhdWx0IHN0YXJ0dXAgY29tbWFuZDogJCBKQVZBX0hPTUUgLyBiaW4gLyBqYXZhICQgSmFyU3RhcnRPcHRpb25zIC1qYXIgJCBDQVRBTElOQV9PUFRTIFwiJCBwYWNrYWdlX3BhdGhcIlxyXG4gICAgICogJCBKYXJTdGFydEFyZ3NcclxuICAgICAqL1xyXG4gICAgcHVibGljIGphclN0YXJ0T3B0aW9uczogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGpkazogRGVwbG95bWVudCBvZiBKREsgdmVyc2lvbiBvZiB0aGUgcGFja2FnZSBkZXBlbmRzIG9uLiBNaXJyb3Jpbmcgbm90IHN1cHBvcnRlZC5cclxuICAgICAqL1xyXG4gICAgcHVibGljIGpkazogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGxpdmVuZXNzOiBDb250YWluZXIgaGVhbHRoIGNoZWNrLCBoZWFsdGggY2hlY2sgZmFpbHMgY29udGFpbmVyIHdpbGwgYmUga2lsbGVkIGFuZCByZWNvdmVyeS4gQ3VycmVudGx5IG9ubHkgc3VwcG9ydHMgbW9kZSBjb21tYW5kIGlzc3VlZCBpbiB0aGUgY29udGFpbmVyLiBUaGUgY29sdW1uczogeyBcImV4ZWNcIjogeyBcImNvbW1hbmRcIjogWyBcInNsZWVwXCIsIFwiNXNcIl19LCBcImluaXRpYWxEZWxheVNlY29uZHNcIjogMTAsIFwidGltZW91dFNlY29uZHNcIjogMTF9XHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBsaXZlbmVzczogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IG1vdW50RGVzYzogTW91bnQgRGVzY3JpcHRpb25cclxuICAgICAqL1xyXG4gICAgcHVibGljIG1vdW50RGVzYzogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IG1vdW50SG9zdDogbmFzIG1vdW50IHBvaW50IGluIHRoZSBhcHBsaWNhdGlvbiBvZiB2cGMuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBtb3VudEhvc3Q6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBuYXNJZDogTW91bnQgdGhlIE5BUyBJRCwgeW91IG11c3QgYmUgaW4gdGhlIHNhbWUgcmVnaW9uIGFuZCBjbHVzdGVyLiBJdCBtdXN0IGJlIGF2YWlsYWJsZSB0byBjcmVhdGUgYSBtb3VudCBwb2ludCBsaW1pdCwgb3Igc3dpdGNoIG9uIGl0cyBtb3VudCBwb2ludCBhbHJlYWR5IGluIHRoZSBWUEMuIElmIHlvdSBkbyBub3QgZmlsbCwgYW5kIHRoZXJlIG1vdW50RGVzY3MgZmllbGQsIHRoZSBkZWZhdWx0IHdpbGwgYXV0b21hdGljYWxseSBwdXJjaGFzZSBhIE5BUyBhbmQgbW91bnQgaXQgb250byB0aGUgc3dpdGNoIHdpdGhpbiB0aGUgVlBDLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgbmFzSWQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBwYWNrYWdlVXJsOiBEZXBsb3ltZW50IHBhY2thZ2VzIGFkZHJlc3MuIE9ubHkgRmF0SmFyIFdhciBvciB0aGUgdHlwZSBvZiBhcHBsaWNhdGlvbiBjYW4gYmUgY29uZmlndXJlZCB0byBkZXBsb3kgcGFja2V0IGFkZHJlc3MuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBwYWNrYWdlVXJsOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgcGFja2FnZVZlcnNpb246IFRoZSB2ZXJzaW9uIG51bWJlciBvZiB0aGUgZGVwbG95ZWQgcGFja2FnZSwgV2FyIEZhdEphciB0eXBlIHJlcXVpcmVkLiBQbGVhc2UgY3VzdG9taXplIGl0IG1lYW5pbmcuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBwYWNrYWdlVmVyc2lvbjogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHBvc3RTdGFydDogRXhlY3V0aW5nIHRoZSBzY3JpcHQsIHN1Y2ggYXMgYWZ0ZXIgc3RhcnRpbmcgdGhlIGZvcm1hdDogeyBcImV4ZWNcIjogeyBcImNvbW1hbmRcIjogXCJjYXRcIiwgXCIvIGV0YyAvIGdyb3VwXCJ9fVxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcG9zdFN0YXJ0OiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgcHJlU3RvcDogU2NyaXB0IGlzIGV4ZWN1dGVkIGJlZm9yZSBzdG9wcGluZyB0aGUgZm9ybWF0IGFzOiB7IFwiZXhlY1wiOiB7IFwiY29tbWFuZFwiOiBcImNhdFwiLCBcIi8gZXRjIC8gZ3JvdXBcIn19XHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBwcmVTdG9wOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgcmVhZGluZXNzOiBBcHBsaWNhdGlvbiBsYXVuY2ggc3RhdHVzIGNoZWNrLCBoZWFsdGggY2hlY2sgZmFpbHMgcmVwZWF0ZWRseSBjb250YWluZXIgd2lsbCBiZSBraWxsZWQgYW5kIHJlc3RhcnRlZC4gRG8gbm90IHBhc3MgaGVhbHRoIGNoZWNrIG9mIHRoZSB2ZXNzZWwgd2lsbCBub3QgaGF2ZSB0byBlbnRlciBTTEIgdHJhZmZpYy4gRm9yIGV4YW1wbGU6IHsgXCJleGVjXCI6IHsgXCJjb21tYW5kXCI6IFsgXCJzbGVlcFwiLCBcIjZzXCJdfSwgXCJpbml0aWFsRGVsYXlTZWNvbmRzXCI6IDE1LCBcInRpbWVvdXRTZWNvbmRzXCI6IDEyfVxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcmVhZGluZXNzOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgc2VjdXJpdHlHcm91cElkOiBTZWN1cml0eSBncm91cCBJRC5cclxuICAgICAqL1xyXG4gICAgcHVibGljIHNlY3VyaXR5R3JvdXBJZDogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHNsc0NvbmZpZ3M6IExvZyBjb2xsZWN0aW9uIGNvbmZpZ3VyYXRpb24gZmlsZVxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgc2xzQ29uZmlnczogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHRpbWV6b25lOiBBcHBsaWNhdGlvbiB0aW1lIHpvbmUuIERlZmF1bHQgQXNpYS9TaGFuZ2hhaS5cclxuICAgICAqL1xyXG4gICAgcHVibGljIHRpbWV6b25lOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgdnBjSWQ6IEVEQVMgbmFtZXNwYWNlIGNvcnJlc3BvbmRpbmcgVlBDLiBJbiBTZXJ2ZXJsZXNzIGluIGEgY29ycmVzcG9uZGluZyBvbmUgb2YgdGhlIFZQQyBuYW1lc3BhY2Ugb25seSwgYW5kIGNhbiBub3QgYmUgbW9kaWZpZWQuIFNlcnZlcmxlc3MgZmlyc3QgY3JlYXRlZCBpbiB0aGUgYXBwbGljYXRpb24gbmFtZSBzcGFjZSB3aWxsIGZvcm0gYSBiaW5kaW5nIHJlbGF0aW9uc2hpcC4gWW91IG1heSBjb3JyZXNwb25kIHRvIGEgcGx1cmFsaXR5IG9mIG5hbWVzcGFjZXMgVlBDLiBEbyBub3QgZmlsbCB3YXMgVnBjSWQgbmFtZXNwYWNlIGJpbmRpbmcuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyB2cGNJZDogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZTd2l0Y2hJZDogQXBwbGljYXRpb24gZXhhbXBsZXMgd2hlcmUgdGhlIGVsYXN0aWMgY2FyZCB2aXJ0dWFsIHN3aXRjaC4gVGhlIHN3aXRjaCBtdXN0IGJlIGxvY2F0ZWQgYWJvdmUgdGhlIFZQQy4gVGhlIHNhbWUgc3dpdGNoIHdpdGggRURBUyBuYW1lc3BhY2UgYmluZGluZyByZWxhdGlvbnNoaXAuIERvIG5vdCBmaWxsIHdhcyBWU3dpdGNoSWQgbmFtZXNwYWNlIGJpbmRpbmcuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyB2U3dpdGNoSWQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSB3YXJTdGFydE9wdGlvbnM6IFdhciBTdGFydCB0aGUgYXBwbGljYXRpb24gcGFja2FnZSBvcHRpb24uIEFwcGx5IHRoZSBkZWZhdWx0IHN0YXJ0dXAgY29tbWFuZDogamF2YSAkIEpBVkFfT1BUUyAkIENBVEFMSU5BX09QVFMgLU9wdGlvbnMgb3JnLmFwYWNoZS5jYXRhbGluYS5zdGFydHVwLkJvb3RzdHJhcCBcIiQgQFwiIHN0YXJ0XHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyB3YXJTdGFydE9wdGlvbnM6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSB3ZWJDb250YWluZXI6IFRvbWNhdCBkZXBsb3ltZW50IG9mIHRoZSBwYWNrYWdlIGRlcGVuZHMgb24gdGhlIHZlcnNpb24uIE1pcnJvcmluZyBub3Qgc3VwcG9ydGVkLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgd2ViQ29udGFpbmVyOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6U0FFOjpBcHBsaWNhdGlvbmAuXHJcbiAgICAgKlxyXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXHJcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXHJcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXHJcbiAgICAgKi9cclxuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUm9zQXBwbGljYXRpb25Qcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pIHtcclxuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogUm9zQXBwbGljYXRpb24uUk9TX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XHJcbiAgICAgICAgdGhpcy5hdHRyQXBwSWQgPSByb3MuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0FwcElkJykpO1xyXG4gICAgICAgIHRoaXMuYXR0ckNoYW5nZU9yZGVySWQgPSByb3MuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0NoYW5nZU9yZGVySWQnKSk7XHJcblxyXG4gICAgICAgIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgPSBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDtcclxuICAgICAgICB0aGlzLmFwcE5hbWUgPSBwcm9wcy5hcHBOYW1lO1xyXG4gICAgICAgIHRoaXMuY3B1ID0gcHJvcHMuY3B1O1xyXG4gICAgICAgIHRoaXMubWVtb3J5ID0gcHJvcHMubWVtb3J5O1xyXG4gICAgICAgIHRoaXMubmFtZXNwYWNlSWQgPSBwcm9wcy5uYW1lc3BhY2VJZDtcclxuICAgICAgICB0aGlzLnBhY2thZ2VUeXBlID0gcHJvcHMucGFja2FnZVR5cGU7XHJcbiAgICAgICAgdGhpcy5yZXBsaWNhcyA9IHByb3BzLnJlcGxpY2FzO1xyXG4gICAgICAgIHRoaXMuYXBwRGVzY3JpcHRpb24gPSBwcm9wcy5hcHBEZXNjcmlwdGlvbjtcclxuICAgICAgICB0aGlzLmNvbW1hbmQgPSBwcm9wcy5jb21tYW5kO1xyXG4gICAgICAgIHRoaXMuY29tbWFuZEFyZ3MgPSBwcm9wcy5jb21tYW5kQXJncztcclxuICAgICAgICB0aGlzLmN1c3RvbUhvc3RBbGlhcyA9IHByb3BzLmN1c3RvbUhvc3RBbGlhcztcclxuICAgICAgICB0aGlzLmRlcGxveSA9IHByb3BzLmRlcGxveTtcclxuICAgICAgICB0aGlzLmVkYXNDb250YWluZXJWZXJzaW9uID0gcHJvcHMuZWRhc0NvbnRhaW5lclZlcnNpb247XHJcbiAgICAgICAgdGhpcy5lbnZzID0gcHJvcHMuZW52cztcclxuICAgICAgICB0aGlzLmltYWdlVXJsID0gcHJvcHMuaW1hZ2VVcmw7XHJcbiAgICAgICAgdGhpcy5qYXJTdGFydEFyZ3MgPSBwcm9wcy5qYXJTdGFydEFyZ3M7XHJcbiAgICAgICAgdGhpcy5qYXJTdGFydE9wdGlvbnMgPSBwcm9wcy5qYXJTdGFydE9wdGlvbnM7XHJcbiAgICAgICAgdGhpcy5qZGsgPSBwcm9wcy5qZGs7XHJcbiAgICAgICAgdGhpcy5saXZlbmVzcyA9IHByb3BzLmxpdmVuZXNzO1xyXG4gICAgICAgIHRoaXMubW91bnREZXNjID0gcHJvcHMubW91bnREZXNjO1xyXG4gICAgICAgIHRoaXMubW91bnRIb3N0ID0gcHJvcHMubW91bnRIb3N0O1xyXG4gICAgICAgIHRoaXMubmFzSWQgPSBwcm9wcy5uYXNJZDtcclxuICAgICAgICB0aGlzLnBhY2thZ2VVcmwgPSBwcm9wcy5wYWNrYWdlVXJsO1xyXG4gICAgICAgIHRoaXMucGFja2FnZVZlcnNpb24gPSBwcm9wcy5wYWNrYWdlVmVyc2lvbjtcclxuICAgICAgICB0aGlzLnBvc3RTdGFydCA9IHByb3BzLnBvc3RTdGFydDtcclxuICAgICAgICB0aGlzLnByZVN0b3AgPSBwcm9wcy5wcmVTdG9wO1xyXG4gICAgICAgIHRoaXMucmVhZGluZXNzID0gcHJvcHMucmVhZGluZXNzO1xyXG4gICAgICAgIHRoaXMuc2VjdXJpdHlHcm91cElkID0gcHJvcHMuc2VjdXJpdHlHcm91cElkO1xyXG4gICAgICAgIHRoaXMuc2xzQ29uZmlncyA9IHByb3BzLnNsc0NvbmZpZ3M7XHJcbiAgICAgICAgdGhpcy50aW1lem9uZSA9IHByb3BzLnRpbWV6b25lO1xyXG4gICAgICAgIHRoaXMudnBjSWQgPSBwcm9wcy52cGNJZDtcclxuICAgICAgICB0aGlzLnZTd2l0Y2hJZCA9IHByb3BzLnZTd2l0Y2hJZDtcclxuICAgICAgICB0aGlzLndhclN0YXJ0T3B0aW9ucyA9IHByb3BzLndhclN0YXJ0T3B0aW9ucztcclxuICAgICAgICB0aGlzLndlYkNvbnRhaW5lciA9IHByb3BzLndlYkNvbnRhaW5lcjtcclxuICAgIH1cclxuXHJcblxyXG4gICAgcHJvdGVjdGVkIGdldCByb3NQcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcclxuICAgICAgICByZXR1cm4ge1xyXG4gICAgICAgICAgICBhcHBOYW1lOiB0aGlzLmFwcE5hbWUsXHJcbiAgICAgICAgICAgIGNwdTogdGhpcy5jcHUsXHJcbiAgICAgICAgICAgIG1lbW9yeTogdGhpcy5tZW1vcnksXHJcbiAgICAgICAgICAgIG5hbWVzcGFjZUlkOiB0aGlzLm5hbWVzcGFjZUlkLFxyXG4gICAgICAgICAgICBwYWNrYWdlVHlwZTogdGhpcy5wYWNrYWdlVHlwZSxcclxuICAgICAgICAgICAgcmVwbGljYXM6IHRoaXMucmVwbGljYXMsXHJcbiAgICAgICAgICAgIGFwcERlc2NyaXB0aW9uOiB0aGlzLmFwcERlc2NyaXB0aW9uLFxyXG4gICAgICAgICAgICBjb21tYW5kOiB0aGlzLmNvbW1hbmQsXHJcbiAgICAgICAgICAgIGNvbW1hbmRBcmdzOiB0aGlzLmNvbW1hbmRBcmdzLFxyXG4gICAgICAgICAgICBjdXN0b21Ib3N0QWxpYXM6IHRoaXMuY3VzdG9tSG9zdEFsaWFzLFxyXG4gICAgICAgICAgICBkZXBsb3k6IHRoaXMuZGVwbG95LFxyXG4gICAgICAgICAgICBlZGFzQ29udGFpbmVyVmVyc2lvbjogdGhpcy5lZGFzQ29udGFpbmVyVmVyc2lvbixcclxuICAgICAgICAgICAgZW52czogdGhpcy5lbnZzLFxyXG4gICAgICAgICAgICBpbWFnZVVybDogdGhpcy5pbWFnZVVybCxcclxuICAgICAgICAgICAgamFyU3RhcnRBcmdzOiB0aGlzLmphclN0YXJ0QXJncyxcclxuICAgICAgICAgICAgamFyU3RhcnRPcHRpb25zOiB0aGlzLmphclN0YXJ0T3B0aW9ucyxcclxuICAgICAgICAgICAgamRrOiB0aGlzLmpkayxcclxuICAgICAgICAgICAgbGl2ZW5lc3M6IHRoaXMubGl2ZW5lc3MsXHJcbiAgICAgICAgICAgIG1vdW50RGVzYzogdGhpcy5tb3VudERlc2MsXHJcbiAgICAgICAgICAgIG1vdW50SG9zdDogdGhpcy5tb3VudEhvc3QsXHJcbiAgICAgICAgICAgIG5hc0lkOiB0aGlzLm5hc0lkLFxyXG4gICAgICAgICAgICBwYWNrYWdlVXJsOiB0aGlzLnBhY2thZ2VVcmwsXHJcbiAgICAgICAgICAgIHBhY2thZ2VWZXJzaW9uOiB0aGlzLnBhY2thZ2VWZXJzaW9uLFxyXG4gICAgICAgICAgICBwb3N0U3RhcnQ6IHRoaXMucG9zdFN0YXJ0LFxyXG4gICAgICAgICAgICBwcmVTdG9wOiB0aGlzLnByZVN0b3AsXHJcbiAgICAgICAgICAgIHJlYWRpbmVzczogdGhpcy5yZWFkaW5lc3MsXHJcbiAgICAgICAgICAgIHNlY3VyaXR5R3JvdXBJZDogdGhpcy5zZWN1cml0eUdyb3VwSWQsXHJcbiAgICAgICAgICAgIHNsc0NvbmZpZ3M6IHRoaXMuc2xzQ29uZmlncyxcclxuICAgICAgICAgICAgdGltZXpvbmU6IHRoaXMudGltZXpvbmUsXHJcbiAgICAgICAgICAgIHZwY0lkOiB0aGlzLnZwY0lkLFxyXG4gICAgICAgICAgICB2U3dpdGNoSWQ6IHRoaXMudlN3aXRjaElkLFxyXG4gICAgICAgICAgICB3YXJTdGFydE9wdGlvbnM6IHRoaXMud2FyU3RhcnRPcHRpb25zLFxyXG4gICAgICAgICAgICB3ZWJDb250YWluZXI6IHRoaXMud2ViQ29udGFpbmVyLFxyXG4gICAgICAgIH07XHJcbiAgICB9XHJcbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XHJcbiAgICAgICAgcmV0dXJuIHJvc0FwcGxpY2F0aW9uUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BzLCB0aGlzLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcclxuICAgIH1cclxufVxyXG5cclxuLyoqXHJcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6U0FFOjpOYW1lc3BhY2VgXHJcbiAqL1xyXG5leHBvcnQgaW50ZXJmYWNlIFJvc05hbWVzcGFjZVByb3BzIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBuYW1lc3BhY2VJZDogTmFtZXNwYWNlIElELiBGb3JtYXQ6IFwicmVnaW9uSWQ6bG9naWNhbElkXCIgb3IgXCJsb2dpY2FsSWRcIlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBuYW1lc3BhY2VJZDogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IG5hbWVzcGFjZU5hbWU6IE5hbWVzcGFjZSBuYW1lXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IG5hbWVzcGFjZU5hbWU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBuYW1lc3BhY2VEZXNjcmlwdGlvbjogTmFtZXNwYWNlIGRlc2NyaXB0aW9uXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IG5hbWVzcGFjZURlc2NyaXB0aW9uPzogc3RyaW5nO1xyXG59XHJcblxyXG4vKipcclxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUm9zTmFtZXNwYWNlUHJvcHNgXHJcbiAqXHJcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSb3NOYW1lc3BhY2VQcm9wc2BcclxuICpcclxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cclxuICovXHJcbmZ1bmN0aW9uIFJvc05hbWVzcGFjZVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcclxuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHJvcy5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cclxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyByb3MuVmFsaWRhdGlvblJlc3VsdHMoKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZXNwYWNlTmFtZScsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5uYW1lc3BhY2VOYW1lKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ25hbWVzcGFjZU5hbWUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubmFtZXNwYWNlTmFtZSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lc3BhY2VJZCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5uYW1lc3BhY2VJZCkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lc3BhY2VJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lc3BhY2VJZCkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lc3BhY2VEZXNjcmlwdGlvbicsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lc3BhY2VEZXNjcmlwdGlvbikpO1xyXG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlJvc05hbWVzcGFjZVByb3BzXCInKTtcclxufVxyXG5cclxuLyoqXHJcbiAqIFJlbmRlcnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OlNBRTo6TmFtZXNwYWNlYCByZXNvdXJjZVxyXG4gKlxyXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm9zTmFtZXNwYWNlUHJvcHNgXHJcbiAqXHJcbiAqIEByZXR1cm5zIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpTQUU6Ok5hbWVzcGFjZWAgcmVzb3VyY2UuXHJcbiAqL1xyXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xyXG5mdW5jdGlvbiByb3NOYW1lc3BhY2VQcm9wc1RvUm9zVGVtcGxhdGUocHJvcGVydGllczogYW55LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDogYm9vbGVhbik6IGFueSB7XHJcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XHJcbiAgICBpZihlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCkge1xyXG4gICAgICAgIFJvc05hbWVzcGFjZVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcclxuICAgIH1cclxuICAgIHJldHVybiB7XHJcbiAgICAgIE5hbWVzcGFjZUlkOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLm5hbWVzcGFjZUlkKSxcclxuICAgICAgTmFtZXNwYWNlTmFtZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5uYW1lc3BhY2VOYW1lKSxcclxuICAgICAgTmFtZXNwYWNlRGVzY3JpcHRpb246IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubmFtZXNwYWNlRGVzY3JpcHRpb24pLFxyXG4gICAgfTtcclxufVxyXG5cclxuLyoqXHJcbiAqIEEgUk9TIHRlbXBsYXRlIHR5cGU6ICBgQUxJWVVOOjpTQUU6Ok5hbWVzcGFjZWBcclxuICovXHJcbmV4cG9ydCBjbGFzcyBSb3NOYW1lc3BhY2UgZXh0ZW5kcyByb3MuUm9zUmVzb3VyY2Uge1xyXG4gICAgLyoqXHJcbiAgICAgKiBUaGUgcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJPU19SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFMSVlVTjo6U0FFOjpOYW1lc3BhY2VcIjtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcclxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UuXHJcbiAgICAgKi9cclxuXHJcbiAgICAvKipcclxuICAgICAqIEBBdHRyaWJ1dGUgTmFtZXNwYWNlSWQ6IE5hbWVzcGFjZSBJRFxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ck5hbWVzcGFjZUlkOiBhbnk7XHJcblxyXG4gICAgcHVibGljIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xyXG5cclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBuYW1lc3BhY2VJZDogTmFtZXNwYWNlIElELiBGb3JtYXQ6IFwicmVnaW9uSWQ6bG9naWNhbElkXCIgb3IgXCJsb2dpY2FsSWRcIlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgbmFtZXNwYWNlSWQ6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBuYW1lc3BhY2VOYW1lOiBOYW1lc3BhY2UgbmFtZVxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgbmFtZXNwYWNlTmFtZTogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IG5hbWVzcGFjZURlc2NyaXB0aW9uOiBOYW1lc3BhY2UgZGVzY3JpcHRpb25cclxuICAgICAqL1xyXG4gICAgcHVibGljIG5hbWVzcGFjZURlc2NyaXB0aW9uOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6U0FFOjpOYW1lc3BhY2VgLlxyXG4gICAgICpcclxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxyXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxyXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xyXG4gICAgICovXHJcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJvc05hbWVzcGFjZVByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDogYm9vbGVhbikge1xyXG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBSb3NOYW1lc3BhY2UuUk9TX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XHJcbiAgICAgICAgdGhpcy5hdHRyTmFtZXNwYWNlSWQgPSByb3MuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ05hbWVzcGFjZUlkJykpO1xyXG5cclxuICAgICAgICB0aGlzLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ID0gZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ7XHJcbiAgICAgICAgdGhpcy5uYW1lc3BhY2VJZCA9IHByb3BzLm5hbWVzcGFjZUlkO1xyXG4gICAgICAgIHRoaXMubmFtZXNwYWNlTmFtZSA9IHByb3BzLm5hbWVzcGFjZU5hbWU7XHJcbiAgICAgICAgdGhpcy5uYW1lc3BhY2VEZXNjcmlwdGlvbiA9IHByb3BzLm5hbWVzcGFjZURlc2NyaXB0aW9uO1xyXG4gICAgfVxyXG5cclxuXHJcbiAgICBwcm90ZWN0ZWQgZ2V0IHJvc1Byb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xyXG4gICAgICAgIHJldHVybiB7XHJcbiAgICAgICAgICAgIG5hbWVzcGFjZUlkOiB0aGlzLm5hbWVzcGFjZUlkLFxyXG4gICAgICAgICAgICBuYW1lc3BhY2VOYW1lOiB0aGlzLm5hbWVzcGFjZU5hbWUsXHJcbiAgICAgICAgICAgIG5hbWVzcGFjZURlc2NyaXB0aW9uOiB0aGlzLm5hbWVzcGFjZURlc2NyaXB0aW9uLFxyXG4gICAgICAgIH07XHJcbiAgICB9XHJcbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XHJcbiAgICAgICAgcmV0dXJuIHJvc05hbWVzcGFjZVByb3BzVG9Sb3NUZW1wbGF0ZShwcm9wcywgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XHJcbiAgICB9XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OlNBRTo6U2xiQmluZGluZ2BcclxuICovXHJcbmV4cG9ydCBpbnRlcmZhY2UgUm9zU2xiQmluZGluZ1Byb3BzIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhcHBJZDogU3VjY2Vzc2Z1bCBhcHBsaWNhdGlvbiBkZXBsb3ltZW50IHRhcmdldCBJRFxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBhcHBJZDogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGludGVybmV0OiBCaW5kaW5nIHB1YmxpYyBTTEIuIEZvciBleGFtcGxlOiBbeyBcInBvcnRcIjogODAsIFwidGFyZ2V0UG9ydFwiOiA4MDgwLCBcInByb3RvY29sXCI6IFwiVENQXCJ9XSwgc2hvd3MgYSBjb250YWluZXIgcG9ydCA4MDgwIHRocm91Z2ggcG9ydCA4MCBzbGIgZXhwb3NlZCBzZXJ2aWNlLCB0aGUgcHJvdG9jb2wgaXMgVENQLCB0aGUgYmxhbmsgaXMgaWdub3JlZC5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgaW50ZXJuZXQ/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgaW50ZXJuZXRTbGJJZDogVXNlIFNMQiBwdXJjaGFzZWQgc3BlY2lmaWVkLCBjdXJyZW50bHkgb25seSBzdXBwb3J0cyBub24tc2hhcmVkIGV4YW1wbGVzXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGludGVybmV0U2xiSWQ/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgaW50cmFuZXQ6IEJpbmQgcHJpdmF0ZSBTTEIuIEZvciBleGFtcGxlOiBbeyBcInBvcnRcIjogODAsIFwidGFyZ2V0UG9ydFwiOiA4MDgwLCBcInByb3RvY29sXCI6IFwiVENQXCJ9XSwgc2hvd3MgYSBjb250YWluZXIgcG9ydCA4MDgwIHRocm91Z2ggcG9ydCA4MCBzbGIgZXhwb3NlZCBzZXJ2aWNlLCB0aGUgcHJvdG9jb2wgaXMgVENQLCB0aGUgYmxhbmsgaXMgaWdub3JlZC5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgaW50cmFuZXQ/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgaW50cmFuZXRTbGJJZDogVXNlIFNMQiBwdXJjaGFzZWQgc3BlY2lmaWVkLCBjdXJyZW50bHkgb25seSBzdXBwb3J0cyBub24tc2hhcmVkIGV4YW1wbGVzXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGludHJhbmV0U2xiSWQ/OiBzdHJpbmc7XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBSb3NTbGJCaW5kaW5nUHJvcHNgXHJcbiAqXHJcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSb3NTbGJCaW5kaW5nUHJvcHNgXHJcbiAqXHJcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXHJcbiAqL1xyXG5mdW5jdGlvbiBSb3NTbGJCaW5kaW5nUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogcm9zLlZhbGlkYXRpb25SZXN1bHQge1xyXG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcm9zLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxyXG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdpbnRlcm5ldFNsYklkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmludGVybmV0U2xiSWQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXBwSWQnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuYXBwSWQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXBwSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYXBwSWQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignaW50cmFuZXQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuaW50cmFuZXQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignaW50cmFuZXRTbGJJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5pbnRyYW5ldFNsYklkKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2ludGVybmV0Jywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmludGVybmV0KSk7XHJcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiUm9zU2xiQmluZGluZ1Byb3BzXCInKTtcclxufVxyXG5cclxuLyoqXHJcbiAqIFJlbmRlcnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OlNBRTo6U2xiQmluZGluZ2AgcmVzb3VyY2VcclxuICpcclxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFJvc1NsYkJpbmRpbmdQcm9wc2BcclxuICpcclxuICogQHJldHVybnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OlNBRTo6U2xiQmluZGluZ2AgcmVzb3VyY2UuXHJcbiAqL1xyXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xyXG5mdW5jdGlvbiByb3NTbGJCaW5kaW5nUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pOiBhbnkge1xyXG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxyXG4gICAgaWYoZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpIHtcclxuICAgICAgICBSb3NTbGJCaW5kaW5nUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xyXG4gICAgfVxyXG4gICAgcmV0dXJuIHtcclxuICAgICAgQXBwSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuYXBwSWQpLFxyXG4gICAgICBJbnRlcm5ldDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5pbnRlcm5ldCksXHJcbiAgICAgIEludGVybmV0U2xiSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuaW50ZXJuZXRTbGJJZCksXHJcbiAgICAgIEludHJhbmV0OiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmludHJhbmV0KSxcclxuICAgICAgSW50cmFuZXRTbGJJZDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5pbnRyYW5ldFNsYklkKSxcclxuICAgIH07XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBBIFJPUyB0ZW1wbGF0ZSB0eXBlOiAgYEFMSVlVTjo6U0FFOjpTbGJCaW5kaW5nYFxyXG4gKi9cclxuZXhwb3J0IGNsYXNzIFJvc1NsYkJpbmRpbmcgZXh0ZW5kcyByb3MuUm9zUmVzb3VyY2Uge1xyXG4gICAgLyoqXHJcbiAgICAgKiBUaGUgcmVzb3VyY2UgdHlwZSBuYW1lIGZvciB0aGlzIHJlc291cmNlIGNsYXNzLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJPU19SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFMSVlVTjo6U0FFOjpTbGJCaW5kaW5nXCI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XHJcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLlxyXG4gICAgICovXHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAQXR0cmlidXRlIEFwcElkOiBTdWNjZXNzZnVsIGFwcGxpY2F0aW9uIGRlcGxveW1lbnQgdGFyZ2V0IElEXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyByZWFkb25seSBhdHRyQXBwSWQ6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBBdHRyaWJ1dGUgQ2hhbmdlT3JkZXJJZDogUmV0dXJuIHRvIHJlbGVhc2UgYSBzaW5nbGUgSUQsIHVzZWQgdG8gcXVlcnkgdGFzayBleGVjdXRpb24gc3RhdHVzLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckNoYW5nZU9yZGVySWQ6IGFueTtcclxuXHJcbiAgICBwdWJsaWMgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW47XHJcblxyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGFwcElkOiBTdWNjZXNzZnVsIGFwcGxpY2F0aW9uIGRlcGxveW1lbnQgdGFyZ2V0IElEXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBhcHBJZDogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGludGVybmV0OiBCaW5kaW5nIHB1YmxpYyBTTEIuIEZvciBleGFtcGxlOiBbeyBcInBvcnRcIjogODAsIFwidGFyZ2V0UG9ydFwiOiA4MDgwLCBcInByb3RvY29sXCI6IFwiVENQXCJ9XSwgc2hvd3MgYSBjb250YWluZXIgcG9ydCA4MDgwIHRocm91Z2ggcG9ydCA4MCBzbGIgZXhwb3NlZCBzZXJ2aWNlLCB0aGUgcHJvdG9jb2wgaXMgVENQLCB0aGUgYmxhbmsgaXMgaWdub3JlZC5cclxuICAgICAqL1xyXG4gICAgcHVibGljIGludGVybmV0OiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgaW50ZXJuZXRTbGJJZDogVXNlIFNMQiBwdXJjaGFzZWQgc3BlY2lmaWVkLCBjdXJyZW50bHkgb25seSBzdXBwb3J0cyBub24tc2hhcmVkIGV4YW1wbGVzXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBpbnRlcm5ldFNsYklkOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgaW50cmFuZXQ6IEJpbmQgcHJpdmF0ZSBTTEIuIEZvciBleGFtcGxlOiBbeyBcInBvcnRcIjogODAsIFwidGFyZ2V0UG9ydFwiOiA4MDgwLCBcInByb3RvY29sXCI6IFwiVENQXCJ9XSwgc2hvd3MgYSBjb250YWluZXIgcG9ydCA4MDgwIHRocm91Z2ggcG9ydCA4MCBzbGIgZXhwb3NlZCBzZXJ2aWNlLCB0aGUgcHJvdG9jb2wgaXMgVENQLCB0aGUgYmxhbmsgaXMgaWdub3JlZC5cclxuICAgICAqL1xyXG4gICAgcHVibGljIGludHJhbmV0OiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgaW50cmFuZXRTbGJJZDogVXNlIFNMQiBwdXJjaGFzZWQgc3BlY2lmaWVkLCBjdXJyZW50bHkgb25seSBzdXBwb3J0cyBub24tc2hhcmVkIGV4YW1wbGVzXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBpbnRyYW5ldFNsYklkOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6U0FFOjpTbGJCaW5kaW5nYC5cclxuICAgICAqXHJcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcclxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcclxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcclxuICAgICAqL1xyXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSb3NTbGJCaW5kaW5nUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuKSB7XHJcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IFJvc1NsYkJpbmRpbmcuUk9TX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XHJcbiAgICAgICAgdGhpcy5hdHRyQXBwSWQgPSByb3MuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0FwcElkJykpO1xyXG4gICAgICAgIHRoaXMuYXR0ckNoYW5nZU9yZGVySWQgPSByb3MuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0NoYW5nZU9yZGVySWQnKSk7XHJcblxyXG4gICAgICAgIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgPSBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDtcclxuICAgICAgICB0aGlzLmFwcElkID0gcHJvcHMuYXBwSWQ7XHJcbiAgICAgICAgdGhpcy5pbnRlcm5ldCA9IHByb3BzLmludGVybmV0O1xyXG4gICAgICAgIHRoaXMuaW50ZXJuZXRTbGJJZCA9IHByb3BzLmludGVybmV0U2xiSWQ7XHJcbiAgICAgICAgdGhpcy5pbnRyYW5ldCA9IHByb3BzLmludHJhbmV0O1xyXG4gICAgICAgIHRoaXMuaW50cmFuZXRTbGJJZCA9IHByb3BzLmludHJhbmV0U2xiSWQ7XHJcbiAgICB9XHJcblxyXG5cclxuICAgIHByb3RlY3RlZCBnZXQgcm9zUHJvcGVydGllcygpOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XHJcbiAgICAgICAgcmV0dXJuIHtcclxuICAgICAgICAgICAgYXBwSWQ6IHRoaXMuYXBwSWQsXHJcbiAgICAgICAgICAgIGludGVybmV0OiB0aGlzLmludGVybmV0LFxyXG4gICAgICAgICAgICBpbnRlcm5ldFNsYklkOiB0aGlzLmludGVybmV0U2xiSWQsXHJcbiAgICAgICAgICAgIGludHJhbmV0OiB0aGlzLmludHJhbmV0LFxyXG4gICAgICAgICAgICBpbnRyYW5ldFNsYklkOiB0aGlzLmludHJhbmV0U2xiSWQsXHJcbiAgICAgICAgfTtcclxuICAgIH1cclxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcclxuICAgICAgICByZXR1cm4gcm9zU2xiQmluZGluZ1Byb3BzVG9Sb3NUZW1wbGF0ZShwcm9wcywgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XHJcbiAgICB9XHJcbn1cclxuIl19