 # Chaos Toolkit extension for the Gandi platform
 
[![Build Status](https://travis-ci.org/chaostoolkit-incubator/chaostoolkit-gandi.svg?branch=master)](https://travis-ci.org/chaostoolkit-incubator/chaostoolkit-gandi)
[![Python versions](https://img.shields.io/pypi/pyversions/chaostoolkit-gandi.svg)](https://www.python.org/)


This project is a collection of [actions][] and [probes][], gathered as an
extension to the [Chaos Toolkit][chaostoolkit].

[actions]: http://chaostoolkit.org/reference/api/experiment/#action
[probes]: http://chaostoolkit.org/reference/api/experiment/#probe
[chaostoolkit]: http://chaostoolkit.org

## Install

This package requires Python 3.5+

To be used from your experiment, this package must be installed in the Python
environment where [chaostoolkit][] already lives.

```
$ pip install -U chaostoolkit-gandi
```

## Usage

To use the probes and actions from this package, add the following to your
experiment file:

```json
{
    "version": "1.0.0",
    "title": "Our domains are not going expiring within a month",
    "description": "We need time to renew.",
    "secrets": {
        "gandi": {
            "apikey": {
                "type": "env",
                "key": "GANDI_API_KEY"
            }
        }
    },
    "steady-state-hypothesis": {
        "title": "Check domains are all more than 1 month away from expiring",
        "probes": [
            {
                "type": "probe",
                "name": "list-my-domains",
                "tolerance": {
                    "type": "probe",
                    "name": "validate-domain-expire-date",
                    "provider": {
                        "type": "python",
                        "secrets": ["gandi"],
                        "module": "chaosgandi.domains.tolerances",
                        "func": "domains_should_not_expire_in",
                        "arguments": {
                            "when": "1 month"
                        }
                    }
                },
                "provider": {
                    "type": "python",
                    "secrets": ["gandi"],
                    "module": "chaosgandi.domains.probes",
                    "func": "list_domains"
                }
            }
        ]
    },
    "method": []
}

```

That's it!

Set the `GANDI_API_KEY` environment variable to your Gandi API Key.

Please explore the code to see existing probes and actions.

## Contribute

If you wish to contribute more functions to this package, you are more than
welcome to do so. Please, fork this project, make your changes following the
usual [PEP 8][pep8] code style, sprinkling with tests and submit a PR for
review.

[pep8]: https://pycodestyle.readthedocs.io/en/latest/

The Chaos Toolkit projects require all contributors must sign a
[Developer Certificate of Origin][dco] on each commit they would like to merge
into the master branch of the repository. Please, make sure you can abide by
the rules of the DCO before submitting a PR.

[dco]: https://github.com/probot/dco#how-it-works

### Develop

If you wish to develop on this project, make sure to install the development
dependencies. But first, [create a virtual environment][venv] and then install
those dependencies.

[venv]: http://chaostoolkit.org/reference/usage/install/#create-a-virtual-environment

```console
$ pip install -r requirements-dev.txt -r requirements.txt
```

Then, point your environment to this directory:

```console
$ pip install -e .
```

Now, you can edit the files and they will be automatically be seen by your
environment, even when running from the `chaos` command locally.

### Test

To run the tests for the project execute the following:

```
$ pytest
```
