from typing import Optional

from wexample_config.const.types import DictConfig
from wexample_filestate_python.workdir.python_workdir import PythonWorkdir
from wexample_helpers.helpers.array import array_dict_get_by


class PythonPackageWorkdir(PythonWorkdir):
    def prepare_value(self, config: Optional[DictConfig] = None) -> DictConfig:
        from wexample_filestate.const.disk import DiskItemType
        from wexample_filestate_python.const.name_pattern import NAME_PATTERN_PYTHON_NOT_PYCACHE
        from wexample_filestate.config_option.children_file_factory_config_option import ChildrenFileFactoryConfigOption
        from wexample_filestate.const.globals import NAME_PATTERN_NO_LEADING_DOT
        from wexample_config.config_value.callback_render_config_value import CallbackRenderConfigValue

        config = super().prepare_value(config)

        # Retrieve the '.gitignore' configuration or create it if it doesn't exist
        config_gitignore = array_dict_get_by('name', '.gitignore', config["children"])
        if config_gitignore is not None:
            generic_gitignore_rules = {
                "Python artifacts": [
                    "*.egg-info",
                    "__pycache__/",
                    "*.py[cod]",
                    "*.pyo",
                ],
                "Build directories": [
                    "/build/",
                    "/dist/",
                    "/pip-wheel-metadata/",
                ],
                "Virtual environments": [
                    ".env",
                    ".venv",
                    "venv/",
                ],
                "Test and coverage artifacts": [
                    ".tox/",
                    ".mypy_cache/",
                    "pytest_cache/",
                    ".coverage",
                    "htmlcov/",
                ],
                "Editor and IDE settings": [
                    ".vscode/",
                    ".idea/",
                    "*.swp",
                    "*~",
                ],
            }

            should_contain_lines = config_gitignore.setdefault("should_contain_lines", [])
            if not isinstance(should_contain_lines, list):
                raise ValueError("'should_contain_lines' must be a list")

            for category, rules in generic_gitignore_rules.items():
                category_header = f"# {category}"
                if category_header not in should_contain_lines:
                    should_contain_lines.append(category_header)

                for rule in rules:
                    if rule not in should_contain_lines:
                        should_contain_lines.append(rule)

        config["children"].append(
            {
                'name': 'pyproject.toml',
                'type': DiskItemType.FILE,
                'should_exist': True,
            }
        )

        config["children"].append(
            {
                'name': CallbackRenderConfigValue(raw=self._create_package_name_snake),
                'type': DiskItemType.DIRECTORY,
                'should_exist': True,
                "children": [
                    ChildrenFileFactoryConfigOption(pattern={
                        "name": "__init__.py",
                        "type": DiskItemType.FILE,
                        "recursive": True,
                        "name_pattern": [NAME_PATTERN_PYTHON_NOT_PYCACHE, NAME_PATTERN_NO_LEADING_DOT],
                    })
                ]
            }
        )

        return config
