# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class SortMVA(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attr': 'str',
        'order': 'str',
        'mode': 'str'
    }

    attribute_map = {
        'attr': 'attr',
        'order': 'order',
        'mode': 'mode'
    }

    def __init__(self, attr=None, order=None, mode=None, local_vars_configuration=None):  # noqa: E501
        """SortMVA - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attr = None
        self._order = None
        self._mode = None
        self.discriminator = None

        self.attr = attr
        self.order = order
        self.mode = mode

    @property
    def attr(self):
        """Gets the attr of this SortMVA.  # noqa: E501


        :return: The attr of this SortMVA.  # noqa: E501
        :rtype: str
        """
        return self._attr
    @attr.setter
    def attr(self, attr):
        """Sets the attr of this SortMVA.


        :param attr: The attr of this SortMVA.  # noqa: E501
        :type attr: str
        """
        if self.local_vars_configuration.client_side_validation and attr is None:  # noqa: E501
            raise ValueError("Invalid value for `attr`, must not be `None`")  # noqa: E501

        self._attr = attr
        

    @property
    def order(self):
        """Gets the order of this SortMVA.  # noqa: E501


        :return: The order of this SortMVA.  # noqa: E501
        :rtype: str
        """
        return self._order
    @order.setter
    def order(self, order):
        """Sets the order of this SortMVA.


        :param order: The order of this SortMVA.  # noqa: E501
        :type order: str
        """
        if self.local_vars_configuration.client_side_validation and order is None:  # noqa: E501
            raise ValueError("Invalid value for `order`, must not be `None`")  # noqa: E501
        allowed_values = ["asc", "desc"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and order not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `order` ({0}), must be one of {1}"  # noqa: E501
                .format(order, allowed_values)
            )

        self._order = order
        

    @property
    def mode(self):
        """Gets the mode of this SortMVA.  # noqa: E501


        :return: The mode of this SortMVA.  # noqa: E501
        :rtype: str
        """
        return self._mode
    @mode.setter
    def mode(self, mode):
        """Sets the mode of this SortMVA.


        :param mode: The mode of this SortMVA.  # noqa: E501
        :type mode: str
        """
        if self.local_vars_configuration.client_side_validation and mode is None:  # noqa: E501
            raise ValueError("Invalid value for `mode`, must not be `None`")  # noqa: E501
        allowed_values = ["min", "max"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and mode not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `mode` ({0}), must be one of {1}"  # noqa: E501
                .format(mode, allowed_values)
            )

        self._mode = mode
        


    def to_dict(self):
        """Returns the model properties as a dict"""
        result = { self._attr: {'order': self._order, 'mode': self._mode} }




        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SortMVA):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SortMVA):
            return True

        return self.to_dict() != other.to_dict()
