# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class SearchResponseHits(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'max_score': 'int',
        'total': 'int',
        'total_relation': 'str',
        'hits': '[{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]'
    }

    attribute_map = {
        'max_score': 'max_score',
        'total': 'total',
        'total_relation': 'total_relation',
        'hits': 'hits'
    }

    def __init__(self, max_score=None, total=None, total_relation=None, hits=None, local_vars_configuration=None):  # noqa: E501
        """SearchResponseHits - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._max_score = None
        self._total = None
        self._total_relation = None
        self._hits = None
        self.discriminator = None

        if max_score is not None:
            self.max_score = max_score
        if total is not None:
            self.total = total
        if total_relation is not None:
            self.total_relation = total_relation
        if hits is not None:
            self.hits = hits

    @property
    def max_score(self):
        """Gets the max_score of this SearchResponseHits.  # noqa: E501


        :return: The max_score of this SearchResponseHits.  # noqa: E501
        :rtype: int
        """
        return self._max_score
    @max_score.setter
    def max_score(self, max_score):
        """Sets the max_score of this SearchResponseHits.


        :param max_score: The max_score of this SearchResponseHits.  # noqa: E501
        :type max_score: int
        """

        self._max_score = max_score
        

    @property
    def total(self):
        """Gets the total of this SearchResponseHits.  # noqa: E501


        :return: The total of this SearchResponseHits.  # noqa: E501
        :rtype: int
        """
        return self._total
    @total.setter
    def total(self, total):
        """Sets the total of this SearchResponseHits.


        :param total: The total of this SearchResponseHits.  # noqa: E501
        :type total: int
        """

        self._total = total
        

    @property
    def total_relation(self):
        """Gets the total_relation of this SearchResponseHits.  # noqa: E501


        :return: The total_relation of this SearchResponseHits.  # noqa: E501
        :rtype: str
        """
        return self._total_relation
    @total_relation.setter
    def total_relation(self, total_relation):
        """Sets the total_relation of this SearchResponseHits.


        :param total_relation: The total_relation of this SearchResponseHits.  # noqa: E501
        :type total_relation: str
        """

        self._total_relation = total_relation
        

    @property
    def hits(self):
        """Gets the hits of this SearchResponseHits.  # noqa: E501


        :return: The hits of this SearchResponseHits.  # noqa: E501
        :rtype: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """
        return self._hits
    @hits.setter
    def hits(self, hits):
        """Sets the hits of this SearchResponseHits.


        :param hits: The hits of this SearchResponseHits.  # noqa: E501
        :type hits: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """

        self._hits = hits
        


    def to_dict(self):
        """Returns the model properties as a dict"""

        result = {}		
        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value



        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchResponseHits):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SearchResponseHits):
            return True

        return self.to_dict() != other.to_dict()
