# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class SearchRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'index': 'str',
        'knn': 'SearchRequestKnn',
        'query': '{str: (bool, date, datetime, dict, float, int, list, str, none_type)}',
        'fulltext_filter': '{str: (bool, date, datetime, dict, float, int, list, str, none_type)}',
        'attr_filter': '{str: (bool, date, datetime, dict, float, int, list, str, none_type)}',
        'limit': 'int',
        'offset': 'int',
        'max_matches': 'int',
        'sort': '[{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]',
        'aggs': '{str: (Aggregation,)}',
        'expressions': '{str: (str,)}',
        'highlight': 'Highlight',
        'source': '{str: (bool, date, datetime, dict, float, int, list, str, none_type)}',
        'options': '{str: (bool, date, datetime, dict, float, int, list, str, none_type)}',
        'profile': 'bool',
        'track_scores': 'bool',
        'query_vector': 'bool, date, datetime, dict, float, int, list, str, none_type',
        'doc_id': 'bool, date, datetime, dict, float, int, list, str, none_type',
        'k': 'bool, date, datetime, dict, float, int, list, str, none_type'
    }

    attribute_map = {
        'index': 'index',
        'knn': 'knn',
        'query': 'query',
        'fulltext_filter': 'fulltext_filter',
        'attr_filter': 'attr_filter',
        'limit': 'limit',
        'offset': 'offset',
        'max_matches': 'max_matches',
        'sort': 'sort',
        'aggs': 'aggs',
        'expressions': 'expressions',
        'highlight': 'highlight',
        'source': 'source',
        'options': 'options',
        'profile': 'profile',
        'track_scores': 'track_scores',
        'query_vector': 'query_vector',
        'doc_id': 'doc_id',
        'k': 'k'
    }

    def __init__(self, index="", knn=None, query=None, fulltext_filter=None, attr_filter=None, limit=None, offset=None, max_matches=None, sort=None, aggs=None, expressions=None, highlight=None, source=None, options=None, profile=None, track_scores=None, query_vector=None, doc_id=None, k=None, local_vars_configuration=None):  # noqa: E501
        """SearchRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._index = None
        self._knn = None
        self._query = None
        self._fulltext_filter = None
        self._attr_filter = None
        self._limit = None
        self._offset = None
        self._max_matches = None
        self._sort = None
        self._aggs = None
        self._expressions = None
        self._highlight = None
        self._source = None
        self._options = None
        self._profile = None
        self._track_scores = None
        self._query_vector = None
        self._doc_id = None
        self._k = None
        self.discriminator = None

        self.index = index
        if knn is not None:
            self.knn = knn
        if query is not None:
            self.query = query
        if fulltext_filter is not None:
            self.fulltext_filter = fulltext_filter
        if attr_filter is not None:
            self.attr_filter = attr_filter
        if limit is not None:
            self.limit = limit
        if offset is not None:
            self.offset = offset
        if max_matches is not None:
            self.max_matches = max_matches
        if sort is not None:
            self.sort = sort
        if aggs is not None:
            self.aggs = aggs
        if expressions is not None:
            self.expressions = expressions
        if highlight is not None:
            self.highlight = highlight
        if source is not None:
            self.source = source
        if options is not None:
            self.options = options
        if profile is not None:
            self.profile = profile
        if track_scores is not None:
            self.track_scores = track_scores
        self.query_vector = query_vector
        self.doc_id = doc_id
        self.k = k

    @property
    def index(self):
        """Gets the index of this SearchRequest.  # noqa: E501


        :return: The index of this SearchRequest.  # noqa: E501
        :rtype: str
        """
        return self._index
    @index.setter
    def index(self, index):
        """Sets the index of this SearchRequest.


        :param index: The index of this SearchRequest.  # noqa: E501
        :type index: str
        """
        if self.local_vars_configuration.client_side_validation and index is None:  # noqa: E501
            raise ValueError("Invalid value for `index`, must not be `None`")  # noqa: E501

        self._index = index
        

    @property
    def knn(self):
        """Gets the knn of this SearchRequest.  # noqa: E501


        :return: The knn of this SearchRequest.  # noqa: E501
        :rtype: SearchRequestKnn
        """
        return self._knn
    @knn.setter
    def knn(self, knn):
        """Sets the knn of this SearchRequest.


        :param knn: The knn of this SearchRequest.  # noqa: E501
        :type knn: SearchRequestKnn
        """

        self._knn = knn
        

    @property
    def query(self):
        """Gets the query of this SearchRequest.  # noqa: E501


        :return: The query of this SearchRequest.  # noqa: E501
        :rtype: {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
        """
        return self._query
    @query.setter
    def query(self, query):
        """Sets the query of this SearchRequest.


        :param query: The query of this SearchRequest.  # noqa: E501
        :type query: {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
        """

        self._query = query
        
        if self.fulltext_filter is not None:
        	self.fulltext_filter = None;
       	if self.attr_filter is not None:
        	self.attr_filter = None;

    @property
    def fulltext_filter(self):
        """Gets the fulltext_filter of this SearchRequest.  # noqa: E501


        :return: The fulltext_filter of this SearchRequest.  # noqa: E501
        :rtype: {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
        """
        return self._fulltext_filter
    @fulltext_filter.setter
    def fulltext_filter(self, fulltext_filter):
        """Sets the fulltext_filter of this SearchRequest.


        :param fulltext_filter: The fulltext_filter of this SearchRequest.  # noqa: E501
        :type fulltext_filter: {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
        """

        self._fulltext_filter = fulltext_filter
        

    @property
    def attr_filter(self):
        """Gets the attr_filter of this SearchRequest.  # noqa: E501


        :return: The attr_filter of this SearchRequest.  # noqa: E501
        :rtype: {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
        """
        return self._attr_filter
    @attr_filter.setter
    def attr_filter(self, attr_filter):
        """Sets the attr_filter of this SearchRequest.


        :param attr_filter: The attr_filter of this SearchRequest.  # noqa: E501
        :type attr_filter: {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
        """

        self._attr_filter = attr_filter
        

    @property
    def limit(self):
        """Gets the limit of this SearchRequest.  # noqa: E501


        :return: The limit of this SearchRequest.  # noqa: E501
        :rtype: int
        """
        return self._limit
    @limit.setter
    def limit(self, limit):
        """Sets the limit of this SearchRequest.


        :param limit: The limit of this SearchRequest.  # noqa: E501
        :type limit: int
        """

        self._limit = limit
        

    @property
    def offset(self):
        """Gets the offset of this SearchRequest.  # noqa: E501


        :return: The offset of this SearchRequest.  # noqa: E501
        :rtype: int
        """
        return self._offset
    @offset.setter
    def offset(self, offset):
        """Sets the offset of this SearchRequest.


        :param offset: The offset of this SearchRequest.  # noqa: E501
        :type offset: int
        """

        self._offset = offset
        

    @property
    def max_matches(self):
        """Gets the max_matches of this SearchRequest.  # noqa: E501


        :return: The max_matches of this SearchRequest.  # noqa: E501
        :rtype: int
        """
        return self._max_matches
    @max_matches.setter
    def max_matches(self, max_matches):
        """Sets the max_matches of this SearchRequest.


        :param max_matches: The max_matches of this SearchRequest.  # noqa: E501
        :type max_matches: int
        """

        self._max_matches = max_matches
        

    @property
    def sort(self):
        """Gets the sort of this SearchRequest.  # noqa: E501


        :return: The sort of this SearchRequest.  # noqa: E501
        :rtype: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """
        return self._sort
    @sort.setter
    def sort(self, sort):
        """Sets the sort of this SearchRequest.


        :param sort: The sort of this SearchRequest.  # noqa: E501
        :type sort: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """

        self._sort = sort
        

    @property
    def aggs(self):
        """Gets the aggs of this SearchRequest.  # noqa: E501


        :return: The aggs of this SearchRequest.  # noqa: E501
        :rtype: {str: (Aggregation,)}
        """
        return self._aggs
    @aggs.setter
    def aggs(self, aggs):
        """Sets the aggs of this SearchRequest.


        :param aggs: The aggs of this SearchRequest.  # noqa: E501
        :type aggs: {str: (Aggregation,)}
        """

        self._aggs = aggs
        

    @property
    def expressions(self):
        """Gets the expressions of this SearchRequest.  # noqa: E501


        :return: The expressions of this SearchRequest.  # noqa: E501
        :rtype: {str: (str,)}
        """
        return self._expressions
    @expressions.setter
    def expressions(self, expressions):
        """Sets the expressions of this SearchRequest.


        :param expressions: The expressions of this SearchRequest.  # noqa: E501
        :type expressions: {str: (str,)}
        """

        self._expressions = expressions
        

    @property
    def highlight(self):
        """Gets the highlight of this SearchRequest.  # noqa: E501


        :return: The highlight of this SearchRequest.  # noqa: E501
        :rtype: Highlight
        """
        return self._highlight
    @highlight.setter
    def highlight(self, highlight):
        """Sets the highlight of this SearchRequest.


        :param highlight: The highlight of this SearchRequest.  # noqa: E501
        :type highlight: Highlight
        """

        self._highlight = highlight
        

    @property
    def source(self):
        """Gets the source of this SearchRequest.  # noqa: E501


        :return: The source of this SearchRequest.  # noqa: E501
        :rtype: {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
        """
        return self._source
    @source.setter
    def source(self, source):
        """Sets the source of this SearchRequest.


        :param source: The source of this SearchRequest.  # noqa: E501
        :type source: {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
        """

        self._source = source
        

    @property
    def options(self):
        """Gets the options of this SearchRequest.  # noqa: E501


        :return: The options of this SearchRequest.  # noqa: E501
        :rtype: {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
        """
        return self._options
    @options.setter
    def options(self, options):
        """Sets the options of this SearchRequest.


        :param options: The options of this SearchRequest.  # noqa: E501
        :type options: {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
        """

        self._options = options
        

    @property
    def profile(self):
        """Gets the profile of this SearchRequest.  # noqa: E501


        :return: The profile of this SearchRequest.  # noqa: E501
        :rtype: bool
        """
        return self._profile
    @profile.setter
    def profile(self, profile):
        """Sets the profile of this SearchRequest.


        :param profile: The profile of this SearchRequest.  # noqa: E501
        :type profile: bool
        """

        self._profile = profile
        

    @property
    def track_scores(self):
        """Gets the track_scores of this SearchRequest.  # noqa: E501


        :return: The track_scores of this SearchRequest.  # noqa: E501
        :rtype: bool
        """
        return self._track_scores
    @track_scores.setter
    def track_scores(self, track_scores):
        """Sets the track_scores of this SearchRequest.


        :param track_scores: The track_scores of this SearchRequest.  # noqa: E501
        :type track_scores: bool
        """

        self._track_scores = track_scores
        

    @property
    def query_vector(self):
        """Gets the query_vector of this SearchRequest.  # noqa: E501


        :return: The query_vector of this SearchRequest.  # noqa: E501
        :rtype: bool, date, datetime, dict, float, int, list, str, none_type
        """
        return self._query_vector
    @query_vector.setter
    def query_vector(self, query_vector):
        """Sets the query_vector of this SearchRequest.


        :param query_vector: The query_vector of this SearchRequest.  # noqa: E501
        :type query_vector: bool, date, datetime, dict, float, int, list, str, none_type
        """

        self._query_vector = query_vector
        

    @property
    def doc_id(self):
        """Gets the doc_id of this SearchRequest.  # noqa: E501


        :return: The doc_id of this SearchRequest.  # noqa: E501
        :rtype: bool, date, datetime, dict, float, int, list, str, none_type
        """
        return self._doc_id
    @doc_id.setter
    def doc_id(self, doc_id):
        """Sets the doc_id of this SearchRequest.


        :param doc_id: The doc_id of this SearchRequest.  # noqa: E501
        :type doc_id: bool, date, datetime, dict, float, int, list, str, none_type
        """

        self._doc_id = doc_id
        

    @property
    def k(self):
        """Gets the k of this SearchRequest.  # noqa: E501


        :return: The k of this SearchRequest.  # noqa: E501
        :rtype: bool, date, datetime, dict, float, int, list, str, none_type
        """
        return self._k
    @k.setter
    def k(self, k):
        """Sets the k of this SearchRequest.


        :param k: The k of this SearchRequest.  # noqa: E501
        :type k: bool, date, datetime, dict, float, int, list, str, none_type
        """

        self._k = k
        


    def to_dict(self):
        """Returns the model properties as a dict"""

        result = {}		
        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value


        result['_source'] = result['source']
        del result['source']
        if result['aggs'] is not None:
        	for k,v in result['aggs'].items():
        		if v['sort'] is None:
        			result['aggs'][k]['sort'] = []
        if result['highlight'] is not None:
	        if result['highlight']['fields'] is None: 	
	            result['highlight']['fields'] = result['highlight']['fieldnames']
	        result['highlight']['fieldnames'] = None
	        result['highlight'] = {k:v for k,v in result['highlight'].items() if v is not None}
        
        if result['fulltext_filter'] is not None or result['attr_filter'] is not None:
            result['query'] = {}
        if result['fulltext_filter'] is not None:
            for k,v in result['fulltext_filter'].items():
                result['query'][k] = v
            del result['fulltext_filter']
        if result['attr_filter'] is not None:
            for k,v in result['attr_filter'].items():
                result['query'][k] = v
            del result['attr_filter']


        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SearchRequest):
            return True

        return self.to_dict() != other.to_dict()
