# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class QueryFilter(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'query_string': 'str'
    }

    attribute_map = {
        'query_string': 'query_string'
    }

    def __init__(self, query_string=None, local_vars_configuration=None):  # noqa: E501
        """QueryFilter - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._query_string = None
        self.discriminator = None

        self.query_string = query_string

    @property
    def query_string(self):
        """Gets the query_string of this QueryFilter.  # noqa: E501


        :return: The query_string of this QueryFilter.  # noqa: E501
        :rtype: str
        """
        return self._query_string
    @query_string.setter
    def query_string(self, query_string):
        """Sets the query_string of this QueryFilter.


        :param query_string: The query_string of this QueryFilter.  # noqa: E501
        :type query_string: str
        """
        if self.local_vars_configuration.client_side_validation and query_string is None:  # noqa: E501
            raise ValueError("Invalid value for `query_string`, must not be `None`")  # noqa: E501

        self._query_string = query_string
        


    def to_dict(self):
        """Returns the model properties as a dict"""

        result = {}		
        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value



        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryFilter):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QueryFilter):
            return True

        return self.to_dict() != other.to_dict()
