# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class NotFilterBoolean(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'filter_field': 'str',
        'operation': 'str',
        'filter_value': 'bool'
    }

    attribute_map = {
        'filter_field': 'filter_field',
        'operation': 'operation',
        'filter_value': 'filter_value'
    }

    def __init__(self, filter_field=None, operation=None, filter_value=None, local_vars_configuration=None):  # noqa: E501
        """NotFilterBoolean - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._filter_field = None
        self._operation = None
        self._filter_value = None
        self.discriminator = None

        self.filter_field = filter_field
        self.operation = operation
        self.filter_value = filter_value

    @property
    def filter_field(self):
        """Gets the filter_field of this NotFilterBoolean.  # noqa: E501


        :return: The filter_field of this NotFilterBoolean.  # noqa: E501
        :rtype: str
        """
        return self._filter_field
    @filter_field.setter
    def filter_field(self, filter_field):
        """Sets the filter_field of this NotFilterBoolean.


        :param filter_field: The filter_field of this NotFilterBoolean.  # noqa: E501
        :type filter_field: str
        """
        if self.local_vars_configuration.client_side_validation and filter_field is None:  # noqa: E501
            raise ValueError("Invalid value for `filter_field`, must not be `None`")  # noqa: E501

        self._filter_field = filter_field
        

    @property
    def operation(self):
        """Gets the operation of this NotFilterBoolean.  # noqa: E501


        :return: The operation of this NotFilterBoolean.  # noqa: E501
        :rtype: str
        """
        return self._operation
    @operation.setter
    def operation(self, operation):
        """Sets the operation of this NotFilterBoolean.


        :param operation: The operation of this NotFilterBoolean.  # noqa: E501
        :type operation: str
        """
        if self.local_vars_configuration.client_side_validation and operation is None:  # noqa: E501
            raise ValueError("Invalid value for `operation`, must not be `None`")  # noqa: E501

        self._operation = operation
        

    @property
    def filter_value(self):
        """Gets the filter_value of this NotFilterBoolean.  # noqa: E501


        :return: The filter_value of this NotFilterBoolean.  # noqa: E501
        :rtype: bool
        """
        return self._filter_value
    @filter_value.setter
    def filter_value(self, filter_value):
        """Sets the filter_value of this NotFilterBoolean.


        :param filter_value: The filter_value of this NotFilterBoolean.  # noqa: E501
        :type filter_value: bool
        """
        if self.local_vars_configuration.client_side_validation and filter_value is None:  # noqa: E501
            raise ValueError("Invalid value for `filter_value`, must not be `None`")  # noqa: E501

        self._filter_value = filter_value
        


    def to_dict(self):
        """Returns the model properties as a dict"""

        result = {}		
        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value



        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NotFilterBoolean):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NotFilterBoolean):
            return True

        return self.to_dict() != other.to_dict()
