# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class MatchPhraseFilter(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'query_phrase': 'str',
        'query_fields': 'str'
    }

    attribute_map = {
        'query_phrase': 'query_phrase',
        'query_fields': 'query_fields'
    }

    def __init__(self, query_phrase=None, query_fields=None, local_vars_configuration=None):  # noqa: E501
        """MatchPhraseFilter - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._query_phrase = None
        self._query_fields = None
        self.discriminator = None

        self.query_phrase = query_phrase
        self.query_fields = query_fields

    @property
    def query_phrase(self):
        """Gets the query_phrase of this MatchPhraseFilter.  # noqa: E501


        :return: The query_phrase of this MatchPhraseFilter.  # noqa: E501
        :rtype: str
        """
        return self._query_phrase
    @query_phrase.setter
    def query_phrase(self, query_phrase):
        """Sets the query_phrase of this MatchPhraseFilter.


        :param query_phrase: The query_phrase of this MatchPhraseFilter.  # noqa: E501
        :type query_phrase: str
        """
        if self.local_vars_configuration.client_side_validation and query_phrase is None:  # noqa: E501
            raise ValueError("Invalid value for `query_phrase`, must not be `None`")  # noqa: E501

        self._query_phrase = query_phrase
        

    @property
    def query_fields(self):
        """Gets the query_fields of this MatchPhraseFilter.  # noqa: E501


        :return: The query_fields of this MatchPhraseFilter.  # noqa: E501
        :rtype: str
        """
        return self._query_fields
    @query_fields.setter
    def query_fields(self, query_fields):
        """Sets the query_fields of this MatchPhraseFilter.


        :param query_fields: The query_fields of this MatchPhraseFilter.  # noqa: E501
        :type query_fields: str
        """
        if self.local_vars_configuration.client_side_validation and query_fields is None:  # noqa: E501
            raise ValueError("Invalid value for `query_fields`, must not be `None`")  # noqa: E501

        self._query_fields = query_fields
        


    def to_dict(self):
        """Returns the model properties as a dict"""
        result = { 'match_phrase': {self._query_fields: self._query_phrase} }




        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MatchPhraseFilter):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MatchPhraseFilter):
            return True

        return self.to_dict() != other.to_dict()
