# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class InFilter(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'field': 'str',
        'values': '[{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]'
    }

    attribute_map = {
        'field': 'field',
        'values': 'values'
    }

    def __init__(self, field=None, values=None, local_vars_configuration=None):  # noqa: E501
        """InFilter - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._field = None
        self._values = None
        self.discriminator = None

        self.field = field
        self.values = values

    @property
    def field(self):
        """Gets the field of this InFilter.  # noqa: E501


        :return: The field of this InFilter.  # noqa: E501
        :rtype: str
        """
        return self._field
    @field.setter
    def field(self, field):
        """Sets the field of this InFilter.


        :param field: The field of this InFilter.  # noqa: E501
        :type field: str
        """
        if self.local_vars_configuration.client_side_validation and field is None:  # noqa: E501
            raise ValueError("Invalid value for `field`, must not be `None`")  # noqa: E501

        self._field = field
        

    @property
    def values(self):
        """Gets the values of this InFilter.  # noqa: E501


        :return: The values of this InFilter.  # noqa: E501
        :rtype: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """
        return self._values
    @values.setter
    def values(self, values):
        """Sets the values of this InFilter.


        :param values: The values of this InFilter.  # noqa: E501
        :type values: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """
        if self.local_vars_configuration.client_side_validation and values is None:  # noqa: E501
            raise ValueError("Invalid value for `values`, must not be `None`")  # noqa: E501

        self._values = values
        


    def to_dict(self):
        """Returns the model properties as a dict"""
        result = { 'in': {self._field: self._values } }




        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InFilter):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InFilter):
            return True

        return self.to_dict() != other.to_dict()
