# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class HighlightField(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'limit': 'int',
        'limit_words': 'int',
        'limit_snippets': 'int'
    }

    attribute_map = {
        'name': 'name',
        'limit': 'limit',
        'limit_words': 'limit_words',
        'limit_snippets': 'limit_snippets'
    }

    def __init__(self, name=None, limit=256, limit_words=0, limit_snippets=0, local_vars_configuration=None):  # noqa: E501
        """HighlightField - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._limit = None
        self._limit_words = None
        self._limit_snippets = None
        self.discriminator = None

        self.name = name
        if limit is not None:
            self.limit = limit
        if limit_words is not None:
            self.limit_words = limit_words
        if limit_snippets is not None:
            self.limit_snippets = limit_snippets

    @property
    def name(self):
        """Gets the name of this HighlightField.  # noqa: E501


        :return: The name of this HighlightField.  # noqa: E501
        :rtype: str
        """
        return self._name
    @name.setter
    def name(self, name):
        """Sets the name of this HighlightField.


        :param name: The name of this HighlightField.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name
        

    @property
    def limit(self):
        """Gets the limit of this HighlightField.  # noqa: E501


        :return: The limit of this HighlightField.  # noqa: E501
        :rtype: int
        """
        return self._limit
    @limit.setter
    def limit(self, limit):
        """Sets the limit of this HighlightField.


        :param limit: The limit of this HighlightField.  # noqa: E501
        :type limit: int
        """

        self._limit = limit
        

    @property
    def limit_words(self):
        """Gets the limit_words of this HighlightField.  # noqa: E501


        :return: The limit_words of this HighlightField.  # noqa: E501
        :rtype: int
        """
        return self._limit_words
    @limit_words.setter
    def limit_words(self, limit_words):
        """Sets the limit_words of this HighlightField.


        :param limit_words: The limit_words of this HighlightField.  # noqa: E501
        :type limit_words: int
        """

        self._limit_words = limit_words
        

    @property
    def limit_snippets(self):
        """Gets the limit_snippets of this HighlightField.  # noqa: E501


        :return: The limit_snippets of this HighlightField.  # noqa: E501
        :rtype: int
        """
        return self._limit_snippets
    @limit_snippets.setter
    def limit_snippets(self, limit_snippets):
        """Sets the limit_snippets of this HighlightField.


        :param limit_snippets: The limit_snippets of this HighlightField.  # noqa: E501
        :type limit_snippets: int
        """

        self._limit_snippets = limit_snippets
        


    def to_dict(self):
        """Returns the model properties as a dict"""

        result = {}		
        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        result = { result['name']: {k:v for k,v in result.items() if k != 'name' and v is not None} }


        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HighlightField):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HighlightField):
            return True

        return self.to_dict() != other.to_dict()
