# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class GeoDistanceFilter(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'location_anchor': 'GeoDistanceFilterLocationAnchor',
        'location_source': 'str',
        'distance_type': 'str',
        'distance': 'str'
    }

    attribute_map = {
        'location_anchor': 'location_anchor',
        'location_source': 'location_source',
        'distance_type': 'distance_type',
        'distance': 'distance'
    }

    def __init__(self, location_anchor=None, location_source=None, distance_type=None, distance=None, local_vars_configuration=None):  # noqa: E501
        """GeoDistanceFilter - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._location_anchor = None
        self._location_source = None
        self._distance_type = None
        self._distance = None
        self.discriminator = None

        if location_anchor is not None:
            self.location_anchor = location_anchor
        if location_source is not None:
            self.location_source = location_source
        if distance_type is not None:
            self.distance_type = distance_type
        if distance is not None:
            self.distance = distance

    @property
    def location_anchor(self):
        """Gets the location_anchor of this GeoDistanceFilter.  # noqa: E501


        :return: The location_anchor of this GeoDistanceFilter.  # noqa: E501
        :rtype: GeoDistanceFilterLocationAnchor
        """
        return self._location_anchor
    @location_anchor.setter
    def location_anchor(self, location_anchor):
        """Sets the location_anchor of this GeoDistanceFilter.


        :param location_anchor: The location_anchor of this GeoDistanceFilter.  # noqa: E501
        :type location_anchor: GeoDistanceFilterLocationAnchor
        """

        self._location_anchor = location_anchor
        

    @property
    def location_source(self):
        """Gets the location_source of this GeoDistanceFilter.  # noqa: E501

        Attribute containing latitude and longitude data  # noqa: E501

        :return: The location_source of this GeoDistanceFilter.  # noqa: E501
        :rtype: str
        """
        return self._location_source
    @location_source.setter
    def location_source(self, location_source):
        """Sets the location_source of this GeoDistanceFilter.

        Attribute containing latitude and longitude data  # noqa: E501

        :param location_source: The location_source of this GeoDistanceFilter.  # noqa: E501
        :type location_source: str
        """

        self._location_source = location_source
        

    @property
    def distance_type(self):
        """Gets the distance_type of this GeoDistanceFilter.  # noqa: E501


        :return: The distance_type of this GeoDistanceFilter.  # noqa: E501
        :rtype: str
        """
        return self._distance_type
    @distance_type.setter
    def distance_type(self, distance_type):
        """Sets the distance_type of this GeoDistanceFilter.


        :param distance_type: The distance_type of this GeoDistanceFilter.  # noqa: E501
        :type distance_type: str
        """
        allowed_values = ["adaptive", "haversine"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and distance_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `distance_type` ({0}), must be one of {1}"  # noqa: E501
                .format(distance_type, allowed_values)
            )

        self._distance_type = distance_type
        

    @property
    def distance(self):
        """Gets the distance of this GeoDistanceFilter.  # noqa: E501


        :return: The distance of this GeoDistanceFilter.  # noqa: E501
        :rtype: str
        """
        return self._distance
    @distance.setter
    def distance(self, distance):
        """Sets the distance of this GeoDistanceFilter.


        :param distance: The distance of this GeoDistanceFilter.  # noqa: E501
        :type distance: str
        """

        self._distance = distance
        


    def to_dict(self):
        """Returns the model properties as a dict"""

        result = {}		
        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        result = { 'geo_distance': result }


        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GeoDistanceFilter):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GeoDistanceFilter):
            return True

        return self.to_dict() != other.to_dict()
