# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class Facet(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attr': 'str',
        'alias': 'str',
        'limit': 'int'
    }

    attribute_map = {
        'attr': 'attr',
        'alias': 'alias',
        'limit': 'limit'
    }

    def __init__(self, attr=None, alias=None, limit=None, local_vars_configuration=None):  # noqa: E501
        """Facet - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attr = None
        self._alias = None
        self._limit = None
        self.discriminator = None

        self.attr = attr
        if alias is not None:
            self.alias = alias
        if limit is not None:
            self.limit = limit

    @property
    def attr(self):
        """Gets the attr of this Facet.  # noqa: E501

        The name of an attribute to facet  # noqa: E501

        :return: The attr of this Facet.  # noqa: E501
        :rtype: str
        """
        return self._attr
    @attr.setter
    def attr(self, attr):
        """Sets the attr of this Facet.

        The name of an attribute to facet  # noqa: E501

        :param attr: The attr of this Facet.  # noqa: E501
        :type attr: str
        """
        if self.local_vars_configuration.client_side_validation and attr is None:  # noqa: E501
            raise ValueError("Invalid value for `attr`, must not be `None`")  # noqa: E501

        self._attr = attr
        

    @property
    def alias(self):
        """Gets the alias of this Facet.  # noqa: E501

        Facet alias  # noqa: E501

        :return: The alias of this Facet.  # noqa: E501
        :rtype: str
        """
        return self._alias
    @alias.setter
    def alias(self, alias):
        """Sets the alias of this Facet.

        Facet alias  # noqa: E501

        :param alias: The alias of this Facet.  # noqa: E501
        :type alias: str
        """

        self._alias = alias
        

    @property
    def limit(self):
        """Gets the limit of this Facet.  # noqa: E501

        The number of facet values to return  # noqa: E501

        :return: The limit of this Facet.  # noqa: E501
        :rtype: int
        """
        return self._limit
    @limit.setter
    def limit(self, limit):
        """Sets the limit of this Facet.

        The number of facet values to return  # noqa: E501

        :param limit: The limit of this Facet.  # noqa: E501
        :type limit: int
        """

        self._limit = limit
        


    def to_dict(self):
        """Returns the model properties as a dict"""

        result = {}		
        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value



        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Facet):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Facet):
            return True

        return self.to_dict() != other.to_dict()
