# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class BoolFilter(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'should': '[{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]',
        'must': '[{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]',
        'must_not': '[{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]'
    }

    attribute_map = {
        'should': 'should',
        'must': 'must',
        'must_not': 'must_not'
    }

    def __init__(self, should=None, must=None, must_not=None, local_vars_configuration=None):  # noqa: E501
        """BoolFilter - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._should = None
        self._must = None
        self._must_not = None
        self.discriminator = None

        if should is not None:
            self.should = should
        if must is not None:
            self.must = must
        if must_not is not None:
            self.must_not = must_not

    @property
    def should(self):
        """Gets the should of this BoolFilter.  # noqa: E501


        :return: The should of this BoolFilter.  # noqa: E501
        :rtype: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """
        return self._should
    @should.setter
    def should(self, should):
        """Sets the should of this BoolFilter.


        :param should: The should of this BoolFilter.  # noqa: E501
        :type should: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """

        self._should = should
        

    @property
    def must(self):
        """Gets the must of this BoolFilter.  # noqa: E501


        :return: The must of this BoolFilter.  # noqa: E501
        :rtype: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """
        return self._must
    @must.setter
    def must(self, must):
        """Sets the must of this BoolFilter.


        :param must: The must of this BoolFilter.  # noqa: E501
        :type must: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """

        self._must = must
        

    @property
    def must_not(self):
        """Gets the must_not of this BoolFilter.  # noqa: E501


        :return: The must_not of this BoolFilter.  # noqa: E501
        :rtype: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """
        return self._must_not
    @must_not.setter
    def must_not(self, must_not):
        """Sets the must_not of this BoolFilter.


        :param must_not: The must_not of this BoolFilter.  # noqa: E501
        :type must_not: [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
        """

        self._must_not = must_not
        


    def to_dict(self):
        """Returns the model properties as a dict"""

        result = {}		
        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        result = { "bool": {k:v for k,v in result.items() if v is not None } }


        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BoolFilter):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BoolFilter):
            return True

        return self.to_dict() != other.to_dict()
