# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class AggregationTerms(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'field': 'str',
        'size': 'int'
    }

    attribute_map = {
        'field': 'field',
        'size': 'size'
    }

    def __init__(self, field=None, size=None, local_vars_configuration=None):  # noqa: E501
        """AggregationTerms - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._field = None
        self._size = None
        self.discriminator = None

        if field is not None:
            self.field = field
        if size is not None:
            self.size = size

    @property
    def field(self):
        """Gets the field of this AggregationTerms.  # noqa: E501

        Attribute Name to Aggregate  # noqa: E501

        :return: The field of this AggregationTerms.  # noqa: E501
        :rtype: str
        """
        return self._field
    @field.setter
    def field(self, field):
        """Sets the field of this AggregationTerms.

        Attribute Name to Aggregate  # noqa: E501

        :param field: The field of this AggregationTerms.  # noqa: E501
        :type field: str
        """

        self._field = field
        

    @property
    def size(self):
        """Gets the size of this AggregationTerms.  # noqa: E501

        Maximum Number of Buckets in the Result  # noqa: E501

        :return: The size of this AggregationTerms.  # noqa: E501
        :rtype: int
        """
        return self._size
    @size.setter
    def size(self, size):
        """Sets the size of this AggregationTerms.

        Maximum Number of Buckets in the Result  # noqa: E501

        :param size: The size of this AggregationTerms.  # noqa: E501
        :type size: int
        """

        self._size = size
        


    def to_dict(self):
        """Returns the model properties as a dict"""

        result = {}		
        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value



        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AggregationTerms):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AggregationTerms):
            return True

        return self.to_dict() != other.to_dict()
