# coding: utf-8

# Manticore Search Client
# Copyright (c) 2020-2021, Manticore Software LTD (https://manticoresearch.com)
# 
# All rights reserved
#



import pprint
import re  # noqa: F401

import six

from manticoresearch.configuration import Configuration

class Aggregation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'terms': 'AggregationTerms',
        'sort': '[{str: (AggregationSortInnerValue,)}]'
    }

    attribute_map = {
        'terms': 'terms',
        'sort': 'sort'
    }

    def __init__(self, terms=None, sort=None, local_vars_configuration=None):  # noqa: E501
        """Aggregation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._terms = None
        self._sort = None
        self.discriminator = None

        if terms is not None:
            self.terms = terms
        if sort is not None:
            self.sort = sort

    @property
    def terms(self):
        """Gets the terms of this Aggregation.  # noqa: E501


        :return: The terms of this Aggregation.  # noqa: E501
        :rtype: AggregationTerms
        """
        return self._terms
    @terms.setter
    def terms(self, terms):
        """Sets the terms of this Aggregation.


        :param terms: The terms of this Aggregation.  # noqa: E501
        :type terms: AggregationTerms
        """

        self._terms = terms
        

    @property
    def sort(self):
        """Gets the sort of this Aggregation.  # noqa: E501


        :return: The sort of this Aggregation.  # noqa: E501
        :rtype: [{str: (AggregationSortInnerValue,)}]
        """
        return self._sort
    @sort.setter
    def sort(self, sort):
        """Sets the sort of this Aggregation.


        :param sort: The sort of this Aggregation.  # noqa: E501
        :type sort: [{str: (AggregationSortInnerValue,)}]
        """

        self._sort = sort
        


    def to_dict(self):
        """Returns the model properties as a dict"""

        result = {}		
        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value



        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Aggregation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Aggregation):
            return True

        return self.to_dict() != other.to_dict()
