# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['convex']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.28.1,<3.0.0']

setup_kwargs = {
    'name': 'convex',
    'version': '0.1.0',
    'description': 'Python client for the reactive backend-as-a-service Convex.',
    'long_description': '# Convex\n\nThe official Python client for the [Convex](https://convex.dev/), the reactive\nbackend-as-a-service for web developers. The Python client can write and read\ndata from a Convex backend with queries and mutations and run actions. If you\nwant to create a new Convex backend to communicate with you can get up and\nrunning at [docs.convex.dev](https://docs.convex.dev/introduction/).\n\nInstallation:\n\n    pip install convex\n\nBasic usage:\n\n```python\n>>> from convex import ConvexClient\n>>> client = ConvexClient(\'https://example-lion-123.convex.cloud\')\n>>> messages = client.query("listMessages")\n>>> from pprint import pprint\n>>> pprint(messages)\n[{\'_creationTime\': 1668107495676.2854,\n  \'_id\': Id(table_name=\'messages\', id=\'c09S884lW4kTLdQMtu2ravf\'),\n  \'author\': \'Tom\',\n  \'body\': \'Have you tried Convex?\'},\n {\'_creationTime\': 1668107497732.2295,\n  \'_id\': Id(table_name=\'messages\', id=\'G3m0cCQp65GQDfUjUDnTPEj\'),\n  \'author\': \'Sarah\',\n  \'body\': "Yeah, it\'s working pretty well for me."}]\n>>> client.mutation("sendMessage")\n```\n\nTo find the url of your convex backend, open the deployment you want to work\nwith in the appropriate project in the\n[Convex dashboard](https://dashboard.convex.dev) and click "Settings" where the\nDeployment URL should be visible. To find out which queries, mutations, and\nactions are available check the Functions pane in the Dashboard\n\nTo see logs emitted from Convex functions, set the debug mode to True.\n\n```python\n>>> client.set_debug(True)\n```\n\nTo provide authentication for function execution, call `set_auth()`.\n\n```python\n>>> client.set_auth("token-from-authetication-flow")\n```\n\n[Join us on Discord](https://www.convex.dev/community) to get your questions\nanswered or share what you\'re doing with Convex. If you\'re just getting started,\nsee https://docs.convex.dev to see how to quickly spin up a backend that does\neverything you need in the Convex cloud.\n\n# Convex types\n\nConvex backend functions are written in JavaScript, so arguments passed to\nConvex RPC functions in Python are serialized, sent over the network, and\ndeserialized into JavaScript objects. To learn about Convex\'s supported types\nsee https://docs.convex.dev/using/types.\n\nIn order to call a function that expects a JavaScript type, use the\ncorresponding Python type or any other type that coerces to it. Values returned\nfrom Convex will be of the corresponding Python type.\n\n| JavaScript Type                                                                                             | Python Type                                                             | Example                           | Other Python Types that Convert     |\n| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------- | --------------------------------- | ----------------------------------- |\n| [Id](/api/classes/values.GenericId)                                                                         | Id (see below)                                                          | `Id(tableName, id)`               |                                     |\n| [null](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures#null_type)                   | [None](https://docs.python.org/3/library/stdtypes.html#the-null-object) | `None`                            |                                     |\n| [bigint](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures#bigint_type)               | [int](https://docs.python.org/3/library/functions.html#int)             | `3`                               |                                     |\n| [number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures#number_type)               | [float](https://docs.python.org/3/library/functions.html#float)         | `3.1`                             |                                     |\n| [boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures#boolean_type)             | [bool](https://docs.python.org/3/library/functions.html#bool)           | `True`, `False`                   |                                     |\n| [string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures#string_type)               | [str](https://docs.python.org/3/library/stdtypes.html#str)              | `\'abc\'`                           |                                     |\n| [ArrayBuffer](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/ArrayBuffer) | [bytes](https://docs.python.org/3/library/stdtypes.html#bytes)          | `b\'abc\'`                          | ArrayBuffer                         |\n| [Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)             | [list](https://docs.python.org/3/library/stdtypes.html#list)            | `[1, 3.2, "abc"]`                 | tuple, collections.abc.Sequence     |\n| [Set](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Set)                 | ConvexSet (see below)                                                   | `ConvexSet([1,2])`                | set, frozenset, collections.abc.Set |\n| [Map](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map)                 | ConvexMap (see below)                                                   | `ConvexMap([(\'a\', 1), (\'b\', 2)])` |                                     |\n| [object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures#objects)                   | [dict](https://docs.python.org/3/library/stdtypes.html#dict)            | `{a: "abc"}`                      | collections.abc.Mapping             |\n\n### Id\n\nId objects represent references to Convex documents. They contain a `table_name`\nstring specifying a Convex table (tables can be viewed in\n[the dashboard](https://dashboard.convex.dev)) and a globably unique `id`\nstring. If you\'d like to learn more about the `id` string\'s format, see\n[our docs](https://docs.convex.dev/api/classes/values.GenericId).\n\n### ConvexSet\n\nSimilar to a Python set, but any Convex values can be items.\n\nConvexSets are returned from Convex cloud function calls that return JavaScript\nSets.\n\nGenerally when calling Convex functions from Python, a Python builtin set can be\nused instead of a ConvexSet. But for representing unusual types like sets\ncontaining objects, you\'ll have to use a ConvexSet:\n\n```python\n>>> set([{\'a\': 1}])\nTraceback (most recent call last):\n    ...\nTypeError: unhashable type: \'dict\'\n>>> ConvexSet([{\'a\': 1}])\nConvexSet([{\'a\': 1}])\n```\n\nConvexSet instances are immutable so must be fully populated when being\nconstructed. In order to store mutable items, ConvexSets store snapshots of data\nwhen it was added.\n\n```python\n>>> mutable_dict = {\'a\': 1}\n>>> s = ConvexSet([mutable_dict, \'hello\', 1])\n>>> mutable_dict in s\nTrue\n>>> mutable_dict[\'b\'] = 2\n>>> mutable_dict in s\nFalse\n>>> s\nConvexSet([{\'a\': 1}, \'hello\', 1])\n```\n\nConvexSets perform a copy of each inserted item, so they require more memory\nthan Python\'s builtin sets.\n\n### ConvexMap\n\nSimilar to a Python map, but any Convex values can be keys.\n\nConvexMaps are returned from Convex cloud function calls that return JavaScript\nMaps.\n\nConvexMaps are useful when calling Convex functions that expect a Map because\ndictionaries correspond to JavaScript objects, not Maps.\n\nConvexMap instances are immutable so must be fully populated when being\nconstructed. In order to store mutable items, ConvexMaps store snapshots of data\nwhen it was added.\n\n```python\n>>> mutable_dict = {\'a\': 1}\n>>> s = ConvexMap([(mutable_dict, 123), (\'b\', 456)])\n>>> mutable_dict in s\nTrue\n>>> mutable_dict[\'b\'] = 2\n>>> mutable_dict in s\nFalse\n>>> s\nConvexMap([({\'a\': 1}, 123), (\'b\', 456)])\n```\n\nConvexMaps perform a copy of each inserted key/value pair, so they require more\nmemory than Python\'s builtin dictionaries.\n',
    'author': 'Convex, Inc.',
    'author_email': 'support@convex.dev',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
