# Generated by Django 3.1.5 on 2021-04-26 14:15

from django.db import migrations


def reverse_move_permissions(apps, schema_editor):
    pass


def move_permissions(apps, schema_editor):
    Permission = apps.get_model('auth', 'Permission')
    Group = apps.get_model('auth', 'Group')
    User = apps.get_model('auth', 'User')

    try: 
        old_transmitter_approve = Permission.objects.get(codename='approve',
                                                         content_type__model='transmittersuggestion')
        new_transmitter_approve = Permission.objects.get(codename='approve_transmittersuggestion')
        groups_with_old_transmitter_approve = Group.objects.filter(permissions=old_transmitter_approve)
        for group in groups_with_old_transmitter_approve:
            group.permissions.remove(old_transmitter_approve)
            group.permissions.add(new_transmitter_approve)
        users_with_old_transmitter_approve = User.objects.filter(user_permissions=old_transmitter_approve)
        for user in users_with_old_transmitter_approve:
            user.user_permissions.remove(old_transmitter_approve)
            user.user_permissions.add(new_transmitter_approve)
    except Permission.DoesNotExist:
        pass


    try: 
        old_satellite_approve = Permission.objects.get(codename='approve',
                                                       content_type__model='satellitesuggestion')
        new_satellite_approve = Permission.objects.get(codename='approve_satellitesuggestion')
        groups_with_old_satellite_approve = Group.objects.filter(permissions=old_satellite_approve)
        for group in groups_with_old_satellite_approve:
            group.permissions.remove(old_satellite_approve)
            group.permissions.add(new_satellite_approve)
        users_with_old_satellite_approve = User.objects.filter(user_permissions=old_satellite_approve)
        for user in users_with_old_satellite_approve:
            user.user_permissions.remove(old_satellite_approve)
            user.user_permissions.add(new_satellite_approve)
    except Permission.DoesNotExist:
        pass

    Permission.objects.filter(codename='approve').delete()

class Migration(migrations.Migration):

    dependencies = [
        ('base', '0045_split_approve_permission_for_satellite_and_transmitter_suggestions'),
    ]

    operations = [
        migrations.RunPython(move_permissions, reverse_move_permissions),
    ]
