# Generated by Django 3.1.8 on 2021-04-15 01:56

import db.base.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


def initialize_satellites(apps, schema_editor):
    SatelliteEntry = apps.get_model('base', 'SatelliteEntry')
    SatelliteIdentifier = apps.get_model('base', 'SatelliteIdentifier')
    Satellite = apps.get_model('base', 'Satellite')
    satellite_entries = SatelliteEntry.objects.all()
    for satellite_entry in satellite_entries:
        satellite_identifier = SatelliteIdentifier.objects.create()
        created = django.utils.timezone.now()
        satellite_entry.satellite_identifier = satellite_identifier
        satellite_entry.created = created 
        satellite_entry.reviewed = created
        satellite_entry.approved = True
        satellite_entry.save()
        Satellite.objects.create(satellite_identifier=satellite_identifier, satellite_entry=satellite_entry)


def reverse_initialize_satellites(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('base', '0039_rename_transmitter_satellite_field_to_satellite_entry'),
    ]

    operations = [
        migrations.CreateModel(
            name='SatelliteIdentifier',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sat_id', models.CharField(default=db.base.models.generate_sat_id, max_length=24, unique=True, validators=[db.base.models.validate_sat_id])),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='SatelliteSuggestion',
            fields=[
            ],
            options={
                'permissions': (('approve', 'Can approve/reject satellite suggestions'),),
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('base.satelliteentry',),
        ),
        migrations.AddField(
            model_name='satelliteentry',
            name='approved',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='satelliteentry',
            name='citation',
            field=models.CharField(default='CITATION NEEDED - https://xkcd.com/285/', help_text='A reference (preferrably URL) for this entry or edit', max_length=512),
        ),
        migrations.AddField(
            model_name='satelliteentry',
            name='created',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text='Timestamp of creation/edit'),
        ),
        migrations.AddField(
            model_name='satelliteentry',
            name='created_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_satellites', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='satelliteentry',
            name='reviewed',
            field=models.DateTimeField(blank=True, help_text='Timestamp of review', null=True),
        ),
        migrations.AddField(
            model_name='satelliteentry',
            name='reviewer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reviewed_satellites', to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='Satellite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('associated_satellite', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='associated_with', to='base.satellite')),
                ('satellite_entry', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='base.satelliteentry')),
                ('satellite_identifier', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='satellite', to='base.satelliteidentifier')),
            ],
        ),
        migrations.AddField(
            model_name='satelliteentry',
            name='satellite_identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='satellite_entries', to='base.satelliteidentifier'),
        ),
        migrations.AlterUniqueTogether(
            name='satelliteentry',
            unique_together={('satellite_identifier', 'reviewed')},
        ),
        migrations.RunPython(initialize_satellites, reverse_initialize_satellites),
    ]
