[![github](https://img.shields.io/badge/GitHub-gw_eccentricity-blue.svg)](https://github.com/vijayvarma392/gw_eccentricity)
[![PyPI version](https://badge.fury.io/py/gw_eccentricity.svg)](https://pypi.org/project/gw_eccentricity)
[![license](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/vijayvarma392/gw_eccentricity/blob/main/LICENSE)
[![Build Status](https://github.com/vijayvarma392/gw_eccentricity/actions/workflows/test.yml/badge.svg)](https://github.com/vijayvarma392/gw_eccentricity/actions/workflows/test.yml)


# Welcome to gw_eccentricity
**gw_eccentricity** provides methods to measure eccentricity and mean anomaly
from gravitational wave signals.

These fits are described in the following paper: <br/>
[1] FIXME.

If you find this package useful in your work, please cite reference [1] and
this package.

This package lives on
[GitHub](https://github.com/vijayvarma392/gw_eccentricity), is compatible with
python3, and is tested every week. You can see the current build status of the
main branch at the top of this page.


## Installation

### PyPI
**gw_eccentricity** is available through [PyPI](https://pypi.org/project/gw_eccentricity/):

```shell
pip install gw_eccentricity
```

### From source

```shell
git clone git@github.com:vijayvarma392/gw_eccentricity.git
cd gw_eccentricity
python setup.py install
```

If you do not have root permissions, replace the last step with
`python setup.py install --user`


## Dependencies

**FIXME Arif**    
All of these can be installed through pip or conda.
* [numpy](https://docs.scipy.org/doc/numpy/user/install.html)
* [scipy](https://www.scipy.org/install.html)
* [h5py](http://docs.h5py.org/en/latest/build.html)
* [lalsuite](https://pypi.org/project/lalsuite)


## Usage
We provide ipython examples for usage of different methods.   
**FIXME Arif**    


## Making contributions
See this
[README](https://github.com/vijayvarma392/gw_eccentricity/blob/main/README_developers.md)
for instructions on how to make contributions to this package.

## Credits
The main contributors to this code are [Arif Shaik](https://md-arif-shaikh.github.io/about/), [Vijay
Varma](https://vijayvarma.com), and [Harald Pfeiffer](https://www.aei.mpg.de/person/54205/2784). You can find the full list of contributors
[here](https://github.com/vijayvarma392/gw_eccentricity/graphs/contributors).
Please report bugs by raising an issue on our
[GitHub](https://github.com/vijayvarma392/gw_eccentricity) repository.

## Eventually remove
For quick access to the paper: [![Latest build](https://img.shields.io/badge/PDF-latest-orange.svg?style=flat)](https://github.com/vijayvarma392/measure_eccentricity_paper/blob/pdflatex/paper.pdf)
