import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type logzio::autoDeploymentLogzio::CloudWatch::MODULE
 *
 * @schema CfnCloudWatchModuleProps
 */
export interface CfnCloudWatchModuleProps {
    /**
     * @schema CfnCloudWatchModuleProps#Parameters
     */
    readonly parameters?: CfnCloudWatchModulePropsParameters;
    /**
     * @schema CfnCloudWatchModuleProps#Resources
     */
    readonly resources?: CfnCloudWatchModulePropsResources;
}
/**
 * Converts an object of type 'CfnCloudWatchModuleProps' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModuleProps(obj: CfnCloudWatchModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudWatchModulePropsParameters
 */
export interface CfnCloudWatchModulePropsParameters {
    /**
     * The Logz.io listener URL for your region. You can find explanations here: https://docs.logz.io/user-guide/accounts/account-region.html
     *
     * @schema CfnCloudWatchModulePropsParameters#LogzioListenerUrl
     */
    readonly logzioListenerUrl?: CfnCloudWatchModulePropsParametersLogzioListenerUrl;
    /**
     * Logz.io account token.
     *
     * @schema CfnCloudWatchModulePropsParameters#LogzioToken
     */
    readonly logzioToken?: CfnCloudWatchModulePropsParametersLogzioToken;
    /**
     * The log type you'll use with this Lambda. Please note that you should create a new Lambda for each log type you use. This can be a built-in log type, or your custom log type
     *
     * @schema CfnCloudWatchModulePropsParameters#LogzioType
     */
    readonly logzioType?: CfnCloudWatchModulePropsParametersLogzioType;
    /**
     * JSON or text. If json, the lambda function will attempt to parse the message field as JSON and populate the event data with the parsed fields.
     *
     * @schema CfnCloudWatchModulePropsParameters#LogzioFormat
     */
    readonly logzioFormat?: CfnCloudWatchModulePropsParametersLogzioFormat;
    /**
     * If true, the Lambda will send compressed logs. If false, the Lambda will send uncompressed logs.
     *
     * @schema CfnCloudWatchModulePropsParameters#LogzioCompress
     */
    readonly logzioCompress?: CfnCloudWatchModulePropsParametersLogzioCompress;
    /**
     * By default, we do not send logs of type START, END, REPORT. Choose true to send all log types.
     *
     * @schema CfnCloudWatchModulePropsParameters#LogzioSendAll
     */
    readonly logzioSendAll?: CfnCloudWatchModulePropsParametersLogzioSendAll;
    /**
     * Enriches the CloudWatch events with custom properties at ship time. The format is `key1=value1;key2=value2`. By default is empty.
     *
     * @schema CfnCloudWatchModulePropsParameters#LogzioEnrich
     */
    readonly logzioEnrich?: CfnCloudWatchModulePropsParametersLogzioEnrich;
    /**
     * CloudWatch Log Group name from where you want to send logs.
     *
     * @schema CfnCloudWatchModulePropsParameters#LogGroup
     */
    readonly logGroup?: CfnCloudWatchModulePropsParametersLogGroup;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsParameters(obj: CfnCloudWatchModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudWatchModulePropsResources
 */
export interface CfnCloudWatchModulePropsResources {
    /**
     * @schema CfnCloudWatchModulePropsResources#LambdaPermission
     */
    readonly lambdaPermission?: CfnCloudWatchModulePropsResourcesLambdaPermission;
    /**
     * @schema CfnCloudWatchModulePropsResources#LogzioSubscriptionFilter
     */
    readonly logzioSubscriptionFilter?: CfnCloudWatchModulePropsResourcesLogzioSubscriptionFilter;
    /**
     * @schema CfnCloudWatchModulePropsResources#lambdaIamRole
     */
    readonly lambdaIamRole?: CfnCloudWatchModulePropsResourcesLambdaIamRole;
    /**
     * @schema CfnCloudWatchModulePropsResources#LogzioCloudwatchLogsLambda
     */
    readonly logzioCloudwatchLogsLambda?: CfnCloudWatchModulePropsResourcesLogzioCloudwatchLogsLambda;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsResources(obj: CfnCloudWatchModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The Logz.io listener URL for your region. You can find explanations here: https://docs.logz.io/user-guide/accounts/account-region.html
 *
 * @schema CfnCloudWatchModulePropsParametersLogzioListenerUrl
 */
export interface CfnCloudWatchModulePropsParametersLogzioListenerUrl {
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioListenerUrl#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioListenerUrl#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsParametersLogzioListenerUrl' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsParametersLogzioListenerUrl(obj: CfnCloudWatchModulePropsParametersLogzioListenerUrl | undefined): Record<string, any> | undefined;
/**
 * Logz.io account token.
 *
 * @schema CfnCloudWatchModulePropsParametersLogzioToken
 */
export interface CfnCloudWatchModulePropsParametersLogzioToken {
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioToken#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioToken#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsParametersLogzioToken' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsParametersLogzioToken(obj: CfnCloudWatchModulePropsParametersLogzioToken | undefined): Record<string, any> | undefined;
/**
 * The log type you'll use with this Lambda. Please note that you should create a new Lambda for each log type you use. This can be a built-in log type, or your custom log type
 *
 * @schema CfnCloudWatchModulePropsParametersLogzioType
 */
export interface CfnCloudWatchModulePropsParametersLogzioType {
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioType#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsParametersLogzioType' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsParametersLogzioType(obj: CfnCloudWatchModulePropsParametersLogzioType | undefined): Record<string, any> | undefined;
/**
 * JSON or text. If json, the lambda function will attempt to parse the message field as JSON and populate the event data with the parsed fields.
 *
 * @schema CfnCloudWatchModulePropsParametersLogzioFormat
 */
export interface CfnCloudWatchModulePropsParametersLogzioFormat {
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioFormat#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioFormat#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsParametersLogzioFormat' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsParametersLogzioFormat(obj: CfnCloudWatchModulePropsParametersLogzioFormat | undefined): Record<string, any> | undefined;
/**
 * If true, the Lambda will send compressed logs. If false, the Lambda will send uncompressed logs.
 *
 * @schema CfnCloudWatchModulePropsParametersLogzioCompress
 */
export interface CfnCloudWatchModulePropsParametersLogzioCompress {
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioCompress#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioCompress#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsParametersLogzioCompress' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsParametersLogzioCompress(obj: CfnCloudWatchModulePropsParametersLogzioCompress | undefined): Record<string, any> | undefined;
/**
 * By default, we do not send logs of type START, END, REPORT. Choose true to send all log types.
 *
 * @schema CfnCloudWatchModulePropsParametersLogzioSendAll
 */
export interface CfnCloudWatchModulePropsParametersLogzioSendAll {
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioSendAll#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioSendAll#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsParametersLogzioSendAll' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsParametersLogzioSendAll(obj: CfnCloudWatchModulePropsParametersLogzioSendAll | undefined): Record<string, any> | undefined;
/**
 * Enriches the CloudWatch events with custom properties at ship time. The format is `key1=value1;key2=value2`. By default is empty.
 *
 * @schema CfnCloudWatchModulePropsParametersLogzioEnrich
 */
export interface CfnCloudWatchModulePropsParametersLogzioEnrich {
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioEnrich#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudWatchModulePropsParametersLogzioEnrich#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsParametersLogzioEnrich' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsParametersLogzioEnrich(obj: CfnCloudWatchModulePropsParametersLogzioEnrich | undefined): Record<string, any> | undefined;
/**
 * CloudWatch Log Group name from where you want to send logs.
 *
 * @schema CfnCloudWatchModulePropsParametersLogGroup
 */
export interface CfnCloudWatchModulePropsParametersLogGroup {
    /**
     * @schema CfnCloudWatchModulePropsParametersLogGroup#Type
     */
    readonly type: string;
    /**
     * @schema CfnCloudWatchModulePropsParametersLogGroup#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsParametersLogGroup' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsParametersLogGroup(obj: CfnCloudWatchModulePropsParametersLogGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudWatchModulePropsResourcesLambdaPermission
 */
export interface CfnCloudWatchModulePropsResourcesLambdaPermission {
    /**
     * @schema CfnCloudWatchModulePropsResourcesLambdaPermission#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudWatchModulePropsResourcesLambdaPermission#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsResourcesLambdaPermission' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsResourcesLambdaPermission(obj: CfnCloudWatchModulePropsResourcesLambdaPermission | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudWatchModulePropsResourcesLogzioSubscriptionFilter
 */
export interface CfnCloudWatchModulePropsResourcesLogzioSubscriptionFilter {
    /**
     * @schema CfnCloudWatchModulePropsResourcesLogzioSubscriptionFilter#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudWatchModulePropsResourcesLogzioSubscriptionFilter#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsResourcesLogzioSubscriptionFilter' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsResourcesLogzioSubscriptionFilter(obj: CfnCloudWatchModulePropsResourcesLogzioSubscriptionFilter | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudWatchModulePropsResourcesLambdaIamRole
 */
export interface CfnCloudWatchModulePropsResourcesLambdaIamRole {
    /**
     * @schema CfnCloudWatchModulePropsResourcesLambdaIamRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudWatchModulePropsResourcesLambdaIamRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsResourcesLambdaIamRole' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsResourcesLambdaIamRole(obj: CfnCloudWatchModulePropsResourcesLambdaIamRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudWatchModulePropsResourcesLogzioCloudwatchLogsLambda
 */
export interface CfnCloudWatchModulePropsResourcesLogzioCloudwatchLogsLambda {
    /**
     * @schema CfnCloudWatchModulePropsResourcesLogzioCloudwatchLogsLambda#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudWatchModulePropsResourcesLogzioCloudwatchLogsLambda#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudWatchModulePropsResourcesLogzioCloudwatchLogsLambda' to JSON representation.
 */
export declare function toJson_CfnCloudWatchModulePropsResourcesLogzioCloudwatchLogsLambda(obj: CfnCloudWatchModulePropsResourcesLogzioCloudwatchLogsLambda | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `logzio::autoDeploymentLogzio::CloudWatch::MODULE`
 *
 * @cloudformationResource logzio::autoDeploymentLogzio::CloudWatch::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnCloudWatchModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "logzio::autoDeploymentLogzio::CloudWatch::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnCloudWatchModuleProps;
    /**
     * Create a new `logzio::autoDeploymentLogzio::CloudWatch::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnCloudWatchModuleProps);
}
