# testgear_api_client.TestPointsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**api_v2_test_points_id_test_runs_get**](TestPointsApi.md#api_v2_test_points_id_test_runs_get) | **GET** /api/v2/testPoints/{id}/testRuns | Get all test runs which use test point
[**api_v2_test_points_id_work_item_get**](TestPointsApi.md#api_v2_test_points_id_work_item_get) | **GET** /api/v2/testPoints/{id}/workItem | Get work item represented by test point
[**api_v2_test_points_search_id_post**](TestPointsApi.md#api_v2_test_points_search_id_post) | **POST** /api/v2/testPoints/search/id | Search for test points and extract IDs only
[**api_v2_test_points_search_post**](TestPointsApi.md#api_v2_test_points_search_post) | **POST** /api/v2/testPoints/search | Search for test points


# **api_v2_test_points_id_test_runs_get**
> [TestRunModel] api_v2_test_points_id_test_runs_get(id)

Get all test runs which use test point

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import test_points_api
from testgear_api_client.model.problem_details import ProblemDetails
from testgear_api_client.model.test_run_model import TestRunModel
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = test_points_api.TestPointsApi(api_client)
    id = "id_example" # str | Test point unique ID

    # example passing only required values which don't have defaults set
    try:
        # Get all test runs which use test point
        api_response = api_instance.api_v2_test_points_id_test_runs_get(id)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling TestPointsApi->api_v2_test_points_id_test_runs_get: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**| Test point unique ID |

### Return type

[**[TestRunModel]**](TestRunModel.md)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**403** | Read permission for test points is required |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **api_v2_test_points_id_work_item_get**
> WorkItemModel api_v2_test_points_id_work_item_get(id)

Get work item represented by test point

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import test_points_api
from testgear_api_client.model.problem_details import ProblemDetails
from testgear_api_client.model.work_item_model import WorkItemModel
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = test_points_api.TestPointsApi(api_client)
    id = "id_example" # str | Test point unique ID

    # example passing only required values which don't have defaults set
    try:
        # Get work item represented by test point
        api_response = api_instance.api_v2_test_points_id_work_item_get(id)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling TestPointsApi->api_v2_test_points_id_work_item_get: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**| Test point unique ID |

### Return type

[**WorkItemModel**](WorkItemModel.md)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**403** | Read permission for test points is required |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **api_v2_test_points_search_id_post**
> [str] api_v2_test_points_search_id_post()

Search for test points and extract IDs only

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import test_points_api
from testgear_api_client.model.problem_details import ProblemDetails
from testgear_api_client.model.test_point_filter_model import TestPointFilterModel
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = test_points_api.TestPointsApi(api_client)
    skip = 1 # int | Amount of items to be skipped (offset) (optional)
    take = 1 # int | Amount of items to be taken (limit) (optional)
    order_by = "OrderBy_example" # str | SQL-like  ORDER BY statement (column1 ASC|DESC , column2 ASC|DESC) (optional)
    search_field = "SearchField_example" # str | Property name for searching (optional)
    search_value = "SearchValue_example" # str | Value for searching (optional)
    test_point_filter_model = TestPointFilterModel(
        test_suite_ids=[
            "test_suite_ids_example",
        ],
        work_item_global_ids=[
            1,
        ],
        statuses=[
            TestPointStatus("InProgress"),
        ],
        priorities=[
            WorkItemPriorityModel("Lowest"),
        ],
        is_automated=True,
        name="name_example",
        configuration_ids=[
            "configuration_ids_example",
        ],
        tester_ids=[
            "tester_ids_example",
        ],
        duration=Int64RangeSelectorModel(
            _from=1,
            to=1,
        ),
        section_ids=[
            "section_ids_example",
        ],
        created_date=DateTimeRangeSelectorModel(
            _from=dateutil_parser('1970-01-01T00:00:00.00Z'),
            to=dateutil_parser('1970-01-01T00:00:00.00Z'),
        ),
        created_by_ids=[
            "created_by_ids_example",
        ],
        modified_date=DateTimeRangeSelectorModel(
            _from=dateutil_parser('1970-01-01T00:00:00.00Z'),
            to=dateutil_parser('1970-01-01T00:00:00.00Z'),
        ),
        modified_by_ids=[
            "modified_by_ids_example",
        ],
        tags=[
            "tags_example",
        ],
        attributes={
            "key": [
                "key_example",
            ],
        },
    ) # TestPointFilterModel |  (optional)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        # Search for test points and extract IDs only
        api_response = api_instance.api_v2_test_points_search_id_post(skip=skip, take=take, order_by=order_by, search_field=search_field, search_value=search_value, test_point_filter_model=test_point_filter_model)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling TestPointsApi->api_v2_test_points_search_id_post: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **skip** | **int**| Amount of items to be skipped (offset) | [optional]
 **take** | **int**| Amount of items to be taken (limit) | [optional]
 **order_by** | **str**| SQL-like  ORDER BY statement (column1 ASC|DESC , column2 ASC|DESC) | [optional]
 **search_field** | **str**| Property name for searching | [optional]
 **search_value** | **str**| Value for searching | [optional]
 **test_point_filter_model** | [**TestPointFilterModel**](TestPointFilterModel.md)|  | [optional]

### Return type

**[str]**

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  * Pagination-Skip - Skipped amount of items <br>  * Pagination-Take - Taken items <br>  * Pagination-Pages - Expected number of pages <br>  * Pagination-Total-Items - Total count of items <br>  |
**403** | Read permission for all requested test plans is required |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **api_v2_test_points_search_post**
> [TestPointShortGetModel] api_v2_test_points_search_post()

Search for test points

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import test_points_api
from testgear_api_client.model.problem_details import ProblemDetails
from testgear_api_client.model.test_point_short_get_model import TestPointShortGetModel
from testgear_api_client.model.test_point_filter_model import TestPointFilterModel
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = test_points_api.TestPointsApi(api_client)
    skip = 1 # int | Amount of items to be skipped (offset) (optional)
    take = 1 # int | Amount of items to be taken (limit) (optional)
    order_by = "OrderBy_example" # str | SQL-like  ORDER BY statement (column1 ASC|DESC , column2 ASC|DESC) (optional)
    search_field = "SearchField_example" # str | Property name for searching (optional)
    search_value = "SearchValue_example" # str | Value for searching (optional)
    test_point_filter_model = TestPointFilterModel(
        test_suite_ids=[
            "test_suite_ids_example",
        ],
        work_item_global_ids=[
            1,
        ],
        statuses=[
            TestPointStatus("InProgress"),
        ],
        priorities=[
            WorkItemPriorityModel("Lowest"),
        ],
        is_automated=True,
        name="name_example",
        configuration_ids=[
            "configuration_ids_example",
        ],
        tester_ids=[
            "tester_ids_example",
        ],
        duration=Int64RangeSelectorModel(
            _from=1,
            to=1,
        ),
        section_ids=[
            "section_ids_example",
        ],
        created_date=DateTimeRangeSelectorModel(
            _from=dateutil_parser('1970-01-01T00:00:00.00Z'),
            to=dateutil_parser('1970-01-01T00:00:00.00Z'),
        ),
        created_by_ids=[
            "created_by_ids_example",
        ],
        modified_date=DateTimeRangeSelectorModel(
            _from=dateutil_parser('1970-01-01T00:00:00.00Z'),
            to=dateutil_parser('1970-01-01T00:00:00.00Z'),
        ),
        modified_by_ids=[
            "modified_by_ids_example",
        ],
        tags=[
            "tags_example",
        ],
        attributes={
            "key": [
                "key_example",
            ],
        },
    ) # TestPointFilterModel |  (optional)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        # Search for test points
        api_response = api_instance.api_v2_test_points_search_post(skip=skip, take=take, order_by=order_by, search_field=search_field, search_value=search_value, test_point_filter_model=test_point_filter_model)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling TestPointsApi->api_v2_test_points_search_post: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **skip** | **int**| Amount of items to be skipped (offset) | [optional]
 **take** | **int**| Amount of items to be taken (limit) | [optional]
 **order_by** | **str**| SQL-like  ORDER BY statement (column1 ASC|DESC , column2 ASC|DESC) | [optional]
 **search_field** | **str**| Property name for searching | [optional]
 **search_value** | **str**| Value for searching | [optional]
 **test_point_filter_model** | [**TestPointFilterModel**](TestPointFilterModel.md)|  | [optional]

### Return type

[**[TestPointShortGetModel]**](TestPointShortGetModel.md)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  * Pagination-Skip - Skipped amount of items <br>  * Pagination-Take - Taken items <br>  * Pagination-Pages - Expected number of pages <br>  * Pagination-Total-Items - Total count of items <br>  |
**403** | Read permission for all requested test plans is required |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

