# testgear_api_client.ParametersApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**api_v2_parameters_bulk_post**](ParametersApi.md#api_v2_parameters_bulk_post) | **POST** /api/v2/parameters/bulk | Create multiple parameters
[**api_v2_parameters_bulk_put**](ParametersApi.md#api_v2_parameters_bulk_put) | **PUT** /api/v2/parameters/bulk | Update multiple parameters
[**api_v2_parameters_groups_get**](ParametersApi.md#api_v2_parameters_groups_get) | **GET** /api/v2/parameters/groups | Get parameters as group
[**api_v2_parameters_key_name_name_exists_get**](ParametersApi.md#api_v2_parameters_key_name_name_exists_get) | **GET** /api/v2/parameters/key/name/{name}/exists | Check existence parameter key in system
[**api_v2_parameters_key_values_get**](ParametersApi.md#api_v2_parameters_key_values_get) | **GET** /api/v2/parameters/{key}/values | Get all parameter key values
[**api_v2_parameters_keys_get**](ParametersApi.md#api_v2_parameters_keys_get) | **GET** /api/v2/parameters/keys | Get all parameter keys
[**create_parameter**](ParametersApi.md#create_parameter) | **POST** /api/v2/parameters | Create parameter
[**delete_by_name**](ParametersApi.md#delete_by_name) | **DELETE** /api/v2/parameters/name/{name} | Delete parameter by name
[**delete_by_parameter_key_id**](ParametersApi.md#delete_by_parameter_key_id) | **DELETE** /api/v2/parameters/keyId/{keyId} | Delete parameters by parameter key identifier
[**delete_parameter**](ParametersApi.md#delete_parameter) | **DELETE** /api/v2/parameters/{id} | Delete parameter
[**get_all_parameters**](ParametersApi.md#get_all_parameters) | **GET** /api/v2/parameters | Get all parameters
[**get_parameter_by_id**](ParametersApi.md#get_parameter_by_id) | **GET** /api/v2/parameters/{id} | Get parameter by ID
[**obsolete_delete_by_name**](ParametersApi.md#obsolete_delete_by_name) | **POST** /api/v2/parameters/deleteByName | 
[**update_parameter**](ParametersApi.md#update_parameter) | **PUT** /api/v2/parameters | Update parameter


# **api_v2_parameters_bulk_post**
> [ParameterModel] api_v2_parameters_bulk_post()

Create multiple parameters

<br>Use case  <br>User sets list of parameter model (listed in the request example)  <br>User runs method execution  <br>System creates parameters  <br>System returns list of parameter model (listed in the response example)

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.parameter_model import ParameterModel
from testgear_api_client.model.validation_problem_details import ValidationProblemDetails
from testgear_api_client.model.parameter_post_model import ParameterPostModel
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    parameter_post_model = [
        ParameterPostModel(
            value="value_example",
            name="name_example",
        ),
    ] # [ParameterPostModel] |  (optional)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        # Create multiple parameters
        api_response = api_instance.api_v2_parameters_bulk_post(parameter_post_model=parameter_post_model)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->api_v2_parameters_bulk_post: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **parameter_post_model** | [**[ParameterPostModel]**](ParameterPostModel.md)|  | [optional]

### Return type

[**[ParameterModel]**](ParameterModel.md)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Created |  -  |
**400** | &lt;br&gt;- Parameter model is not valid |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **api_v2_parameters_bulk_put**
> api_v2_parameters_bulk_put()

Update multiple parameters

<br>Use case  <br>User sets list of parameter model (listed in the request example)  <br>User runs method execution  <br>System updates parameters

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.problem_details import ProblemDetails
from testgear_api_client.model.parameter_put_model import ParameterPutModel
from testgear_api_client.model.validation_problem_details import ValidationProblemDetails
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    parameter_put_model = [
        ParameterPutModel(
            id="ab0f4e0e-441c-40a0-8c59-4e5cd37bcc16",
            value="value_example",
            name="name_example",
        ),
    ] # [ParameterPutModel] |  (optional)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        # Update multiple parameters
        api_instance.api_v2_parameters_bulk_put(parameter_put_model=parameter_put_model)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->api_v2_parameters_bulk_put: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **parameter_put_model** | [**[ParameterPutModel]**](ParameterPutModel.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**403** | Invalid user permissions |  -  |
**422** | Client Error |  -  |
**204** | No Content |  -  |
**400** | &lt;br&gt;- Parameter model is not valid |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **api_v2_parameters_groups_get**
> [ParameterGroupModel] api_v2_parameters_groups_get()

Get parameters as group

<br>Use case  <br>User runs method execution  <br>System search parameters  <br>System returns parameters models as groups (listed in the response example)

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.parameter_group_model import ParameterGroupModel
from testgear_api_client.model.problem_details import ProblemDetails
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    is_deleted = True # bool |  (optional)
    parameter_key_ids = [
        "parameterKeyIds_example",
    ] # [str] |  (optional)
    skip = 1 # int | Amount of items to be skipped (offset) (optional)
    take = 1 # int | Amount of items to be taken (limit) (optional)
    order_by = "OrderBy_example" # str | SQL-like  ORDER BY statement (column1 ASC|DESC , column2 ASC|DESC) (optional)
    search_field = "SearchField_example" # str | Property name for searching (optional)
    search_value = "SearchValue_example" # str | Value for searching (optional)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        # Get parameters as group
        api_response = api_instance.api_v2_parameters_groups_get(is_deleted=is_deleted, parameter_key_ids=parameter_key_ids, skip=skip, take=take, order_by=order_by, search_field=search_field, search_value=search_value)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->api_v2_parameters_groups_get: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **is_deleted** | **bool**|  | [optional]
 **parameter_key_ids** | **[str]**|  | [optional]
 **skip** | **int**| Amount of items to be skipped (offset) | [optional]
 **take** | **int**| Amount of items to be taken (limit) | [optional]
 **order_by** | **str**| SQL-like  ORDER BY statement (column1 ASC|DESC , column2 ASC|DESC) | [optional]
 **search_field** | **str**| Property name for searching | [optional]
 **search_value** | **str**| Value for searching | [optional]

### Return type

[**[ParameterGroupModel]**](ParameterGroupModel.md)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**401** | Unauthorized |  -  |
**200** | Success |  * Pagination-Skip - Skipped amount of items <br>  * Pagination-Take - Taken items <br>  * Pagination-Pages - Expected number of pages <br>  * Pagination-Total-Items - Total count of items <br>  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **api_v2_parameters_key_name_name_exists_get**
> bool api_v2_parameters_key_name_name_exists_get(name)

Check existence parameter key in system

<br>Use case  <br>User sets name of parameter key  <br>User runs method execution  <br>System search parameter key  <br>System returns the flag for the existence of the parameter key in the system

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.validation_problem_details import ValidationProblemDetails
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    name = "name_example" # str | 

    # example passing only required values which don't have defaults set
    try:
        # Check existence parameter key in system
        api_response = api_instance.api_v2_parameters_key_name_name_exists_get(name)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->api_v2_parameters_key_name_name_exists_get: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **str**|  |

### Return type

**bool**

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **api_v2_parameters_key_values_get**
> [str] api_v2_parameters_key_values_get(key)

Get all parameter key values

<br>Use case  <br>User sets parameter key (string format)  <br>User runs method execution  <br>System search parameter values using the key  <br>System returns parameter

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    key = "SomeKey" # str | Parameter key (string format)

    # example passing only required values which don't have defaults set
    try:
        # Get all parameter key values
        api_response = api_instance.api_v2_parameters_key_values_get(key)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->api_v2_parameters_key_values_get: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **str**| Parameter key (string format) |

### Return type

**[str]**

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful operation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **api_v2_parameters_keys_get**
> [str] api_v2_parameters_keys_get()

Get all parameter keys

<br>Use case  <br>User runs method execution  <br>System search all parameter keys  <br>System returns parameter keys

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)

    # example, this endpoint has no required or optional parameters
    try:
        # Get all parameter keys
        api_response = api_instance.api_v2_parameters_keys_get()
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->api_v2_parameters_keys_get: %s\n" % e)
```


### Parameters
This endpoint does not need any parameter.

### Return type

**[str]**

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful operation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_parameter**
> ParameterModel create_parameter()

Create parameter

<br>Use case  <br>User sets parameter model (listed in the request example)  <br>User runs method execution  <br>System creates parameter  <br>System returns parameter model

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.parameter_model import ParameterModel
from testgear_api_client.model.validation_problem_details import ValidationProblemDetails
from testgear_api_client.model.parameter_post_model import ParameterPostModel
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    parameter_post_model = ParameterPostModel(
        value="value_example",
        name="name_example",
    ) # ParameterPostModel |  (optional)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        # Create parameter
        api_response = api_instance.create_parameter(parameter_post_model=parameter_post_model)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->create_parameter: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **parameter_post_model** | [**ParameterPostModel**](ParameterPostModel.md)|  | [optional]

### Return type

[**ParameterModel**](ParameterModel.md)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**400** | Bad Request |  -  |
**201** | Created |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_by_name**
> delete_by_name(name)

Delete parameter by name

Deletes parameter and all it's values

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.problem_details import ProblemDetails
from testgear_api_client.model.validation_problem_details import ValidationProblemDetails
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    name = "name_example" # str | Name of the parameter

    # example passing only required values which don't have defaults set
    try:
        # Delete parameter by name
        api_instance.delete_by_name(name)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->delete_by_name: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **str**| Name of the parameter |

### Return type

void (empty response body)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**400** | Provided name either is empty or contains only white spaces |  -  |
**422** | Parameter is in use in iterations |  -  |
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_by_parameter_key_id**
> delete_by_parameter_key_id(key_id)

Delete parameters by parameter key identifier

Deletes parameter and all it's values by parameter key identifier

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.problem_details import ProblemDetails
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    key_id = "keyId_example" # str | 

    # example passing only required values which don't have defaults set
    try:
        # Delete parameters by parameter key identifier
        api_instance.delete_by_parameter_key_id(key_id)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->delete_by_parameter_key_id: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key_id** | **str**|  |

### Return type

void (empty response body)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**422** | Parameter is in use in iterations |  -  |
**403** | Invalid user permissions |  -  |
**204** | No Content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_parameter**
> delete_parameter(id)

Delete parameter

<br>Use case  <br>User sets parameter internal (guid format) identifier  <br>System search and delete parameter  <br>System returns deleted parameter

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.problem_details import ProblemDetails
from testgear_api_client.model.validation_problem_details import ValidationProblemDetails
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    id = "id_example" # str | Parameter internal (UUID) identifier

    # example passing only required values which don't have defaults set
    try:
        # Delete parameter
        api_instance.delete_parameter(id)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->delete_parameter: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**| Parameter internal (UUID) identifier |

### Return type

void (empty response body)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**400** | &lt;br&gt;- ID is not valid  &lt;br&gt;- DTO is not valid |  -  |
**422** | Parameter is in use in iterations |  -  |
**200** | Success |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_all_parameters**
> ParameterModel get_all_parameters()

Get all parameters

<br>Use case  <br>[Optional] User sets isDeleted field value  <br>[Optional] If User sets isDeleted field value as true, System search all deleted parameters  <br>[Optional] If User sets isDeleted field value as false, System search all parameters which are not deleted  <br>If User did not set isDeleted field value, System search all parameters  <br>System returns array of all found parameters(listed in response model)

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.parameter_model import ParameterModel
from testgear_api_client.model.problem_details import ProblemDetails
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    is_deleted = True # bool | If result must consist of only actual/deleted parameters (optional)
    skip = 1 # int | Amount of items to be skipped (offset) (optional)
    take = 1 # int | Amount of items to be taken (limit) (optional)
    order_by = "OrderBy_example" # str | SQL-like  ORDER BY statement (column1 ASC|DESC , column2 ASC|DESC) (optional)
    search_field = "SearchField_example" # str | Property name for searching (optional)
    search_value = "SearchValue_example" # str | Value for searching (optional)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        # Get all parameters
        api_response = api_instance.get_all_parameters(is_deleted=is_deleted, skip=skip, take=take, order_by=order_by, search_field=search_field, search_value=search_value)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->get_all_parameters: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **is_deleted** | **bool**| If result must consist of only actual/deleted parameters | [optional]
 **skip** | **int**| Amount of items to be skipped (offset) | [optional]
 **take** | **int**| Amount of items to be taken (limit) | [optional]
 **order_by** | **str**| SQL-like  ORDER BY statement (column1 ASC|DESC , column2 ASC|DESC) | [optional]
 **search_field** | **str**| Property name for searching | [optional]
 **search_value** | **str**| Value for searching | [optional]

### Return type

[**ParameterModel**](ParameterModel.md)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Created |  -  |
**403** | Invalid user permissions |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_parameter_by_id**
> ParameterModel get_parameter_by_id(id)

Get parameter by ID

<br>Use case  <br>User sets parameter internal (guid format) identifier  <br>User runs method execution  <br>System search parameter using the identifier  <br>System returns parameter

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.parameter_model import ParameterModel
from testgear_api_client.model.problem_details import ProblemDetails
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    id = "id_example" # str | Parameter internal (UUID) identifier

    # example passing only required values which don't have defaults set
    try:
        # Get parameter by ID
        api_response = api_instance.get_parameter_by_id(id)
        pprint(api_response)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->get_parameter_by_id: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**| Parameter internal (UUID) identifier |

### Return type

[**ParameterModel**](ParameterModel.md)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**404** | Parameter with provided ID was not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **obsolete_delete_by_name**
> obsolete_delete_by_name()



### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    name = "name_example" # str |  (optional)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_instance.obsolete_delete_by_name(name=name)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->obsolete_delete_by_name: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **str**|  | [optional]

### Return type

void (empty response body)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_parameter**
> update_parameter()

Update parameter

<br>Use case  <br>User sets parameter updated properties(listed in the request example)  <br>User runs method execution  <br>System updated parameter using updated properties  <br>System returns no content response

### Example

* Api Key Authentication (Bearer or PrivateToken):

```python
import time
import testgear_api_client
from testgear_api_client.api import parameters_api
from testgear_api_client.model.problem_details import ProblemDetails
from testgear_api_client.model.parameter_put_model import ParameterPutModel
from testgear_api_client.model.validation_problem_details import ValidationProblemDetails
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = testgear_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer or PrivateToken
configuration.api_key['Bearer or PrivateToken'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Bearer or PrivateToken'] = 'Bearer'

# Enter a context with an instance of the API client
with testgear_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = parameters_api.ParametersApi(api_client)
    parameter_put_model = ParameterPutModel(
        id="ab0f4e0e-441c-40a0-8c59-4e5cd37bcc16",
        value="value_example",
        name="name_example",
    ) # ParameterPutModel |  (optional)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        # Update parameter
        api_instance.update_parameter(parameter_put_model=parameter_put_model)
    except testgear_api_client.ApiException as e:
        print("Exception when calling ParametersApi->update_parameter: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **parameter_put_model** | [**ParameterPutModel**](ParameterPutModel.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[Bearer or PrivateToken](../README.md#Bearer or PrivateToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**400** | &lt;br&gt;- ID is not valid  &lt;br&gt;- DTO is not valid |  -  |
**404** | Parameter with provided ID was not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

