"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeFunction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * A Step Functions Task to invoke a Lambda function.
 *
 * The Lambda function Arn is defined as Resource in the state machine definition.
 *
 * OUTPUT: the output of this task is the return value of the Lambda Function.
 *
 * @deprecated Use `LambdaInvoke`
 */
class InvokeFunction {
    constructor(lambdaFunction, props = {}) {
        this.lambdaFunction = lambdaFunction;
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.InvokeFunction", "Use `LambdaInvoke`");
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_InvokeFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(_task) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.InvokeFunction#bind", "Use `LambdaInvoke`");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            resourceArn: this.lambdaFunction.functionArn,
            policyStatements: [new iam.PolicyStatement({
                    resources: this.lambdaFunction.resourceArnsForGrantInvoke,
                    actions: ['lambda:InvokeFunction'],
                })],
            metricPrefixSingular: 'LambdaFunction',
            metricPrefixPlural: 'LambdaFunctions',
            metricDimensions: { LambdaFunctionArn: this.lambdaFunction.functionArn },
            parameters: this.props.payload,
        };
    }
}
exports.InvokeFunction = InvokeFunction;
_a = JSII_RTTI_SYMBOL_1;
InvokeFunction[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.InvokeFunction", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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