"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrModifyInstanceGroupByName = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
const cluster_utils_1 = require("./private/cluster-utils");
/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 */
class EmrModifyInstanceGroupByName extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EmrModifyInstanceGroupByNameProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: [
                    'elasticmapreduce:ModifyInstanceGroups',
                    'elasticmapreduce:ListInstanceGroups',
                ],
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'elasticmapreduce',
                        resource: 'cluster',
                        resourceName: '*',
                    }),
                ],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('elasticmapreduce', 'modifyInstanceGroupByName', sfn.IntegrationPattern.REQUEST_RESPONSE),
            Parameters: sfn.FieldUtils.renderObject({
                ClusterId: this.props.clusterId,
                InstanceGroupName: this.props.instanceGroupName,
                InstanceGroup: cluster_utils_1.InstanceGroupModifyConfigPropertyToJson(this.props.instanceGroup),
            }),
        };
    }
}
exports.EmrModifyInstanceGroupByName = EmrModifyInstanceGroupByName;
_a = JSII_RTTI_SYMBOL_1;
EmrModifyInstanceGroupByName[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EmrModifyInstanceGroupByName", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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