"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoUpdateItem = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
/**
 * A StepFunctions task to call DynamoUpdateItem
 */
class DynamoUpdateItem extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_DynamoUpdateItemProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'dynamodb',
                        resource: 'table',
                        resourceName: props.table.tableName,
                    }),
                ],
                actions: [`dynamodb:${utils_1.DynamoMethod.UPDATE}Item`],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: utils_1.getDynamoResourceArn(utils_1.DynamoMethod.UPDATE),
            Parameters: sfn.FieldUtils.renderObject({
                Key: utils_1.transformAttributeValueMap(this.props.key),
                TableName: this.props.table.tableName,
                ConditionExpression: this.props.conditionExpression,
                ExpressionAttributeNames: this.props.expressionAttributeNames,
                ExpressionAttributeValues: utils_1.transformAttributeValueMap(this.props.expressionAttributeValues),
                ReturnConsumedCapacity: this.props.returnConsumedCapacity,
                ReturnItemCollectionMetrics: this.props.returnItemCollectionMetrics,
                ReturnValues: this.props.returnValues,
                UpdateExpression: this.props.updateExpression,
            }),
        };
    }
}
exports.DynamoUpdateItem = DynamoUpdateItem;
_a = JSII_RTTI_SYMBOL_1;
DynamoUpdateItem[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.DynamoUpdateItem", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXBkYXRlLWl0ZW0uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1cGRhdGUtaXRlbS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSx3Q0FBd0M7QUFDeEMsa0RBQWtEO0FBQ2xELHdDQUFzQztBQUV0QywyQ0FBaUc7QUF5RmpHOztHQUVHO0FBQ0gsTUFBYSxnQkFBaUIsU0FBUSxHQUFHLENBQUMsYUFBYTtJQUlyRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFtQixLQUE0QjtRQUNyRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQURpQyxVQUFLLEdBQUwsS0FBSyxDQUF1Qjs7Ozs7Ozs7OztRQUdyRixJQUFJLENBQUMsWUFBWSxHQUFHO1lBQ2xCLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztnQkFDdEIsU0FBUyxFQUFFO29CQUNULFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO3dCQUN2QixPQUFPLEVBQUUsVUFBVTt3QkFDbkIsUUFBUSxFQUFFLE9BQU87d0JBQ2pCLFlBQVksRUFBRSxLQUFLLENBQUMsS0FBSyxDQUFDLFNBQVM7cUJBQ3BDLENBQUM7aUJBQ0g7Z0JBQ0QsT0FBTyxFQUFFLENBQUMsWUFBWSxvQkFBWSxDQUFDLE1BQU0sTUFBTSxDQUFDO2FBQ2pELENBQUM7U0FDSCxDQUFDO0tBQ0g7SUFFRDs7T0FFRztJQUNPLFdBQVc7UUFDbkIsT0FBTztZQUNMLFFBQVEsRUFBRSw0QkFBb0IsQ0FBQyxvQkFBWSxDQUFDLE1BQU0sQ0FBQztZQUNuRCxVQUFVLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7Z0JBQ3RDLEdBQUcsRUFBRSxrQ0FBMEIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQztnQkFDL0MsU0FBUyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLFNBQVM7Z0JBQ3JDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsbUJBQW1CO2dCQUNuRCx3QkFBd0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLHdCQUF3QjtnQkFDN0QseUJBQXlCLEVBQUUsa0NBQTBCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQztnQkFDM0Ysc0JBQXNCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxzQkFBc0I7Z0JBQ3pELDJCQUEyQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsMkJBQTJCO2dCQUNuRSxZQUFZLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZO2dCQUNyQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQjthQUM5QyxDQUFDO1NBQ0gsQ0FBQztLQUNIOztBQXZDSCw0Q0F3Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBkZGIgZnJvbSAnQGF3cy1jZGsvYXdzLWR5bmFtb2RiJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCAqIGFzIHNmbiBmcm9tICdAYXdzLWNkay9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgeyBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBEeW5hbW9NZXRob2QsIGdldER5bmFtb1Jlc291cmNlQXJuLCB0cmFuc2Zvcm1BdHRyaWJ1dGVWYWx1ZU1hcCB9IGZyb20gJy4vcHJpdmF0ZS91dGlscyc7XG5pbXBvcnQgeyBEeW5hbW9BdHRyaWJ1dGVWYWx1ZSwgRHluYW1vQ29uc3VtZWRDYXBhY2l0eSwgRHluYW1vSXRlbUNvbGxlY3Rpb25NZXRyaWNzLCBEeW5hbW9SZXR1cm5WYWx1ZXMgfSBmcm9tICcuL3NoYXJlZC10eXBlcyc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgRHluYW1vVXBkYXRlSXRlbSBUYXNrXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRHluYW1vVXBkYXRlSXRlbVByb3BzIGV4dGVuZHMgc2ZuLlRhc2tTdGF0ZUJhc2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgdGFibGUgY29udGFpbmluZyB0aGUgcmVxdWVzdGVkIGl0ZW0uXG4gICAqL1xuICByZWFkb25seSB0YWJsZTogZGRiLklUYWJsZTtcblxuICAvKipcbiAgICogUHJpbWFyeSBrZXkgb2YgdGhlIGl0ZW0gdG8gcmV0cmlldmUuXG4gICAqXG4gICAqIEZvciB0aGUgcHJpbWFyeSBrZXksIHlvdSBtdXN0IHByb3ZpZGUgYWxsIG9mIHRoZSBhdHRyaWJ1dGVzLlxuICAgKiBGb3IgZXhhbXBsZSwgd2l0aCBhIHNpbXBsZSBwcmltYXJ5IGtleSwgeW91IG9ubHkgbmVlZCB0byBwcm92aWRlIGEgdmFsdWUgZm9yIHRoZSBwYXJ0aXRpb24ga2V5LlxuICAgKiBGb3IgYSBjb21wb3NpdGUgcHJpbWFyeSBrZXksIHlvdSBtdXN0IHByb3ZpZGUgdmFsdWVzIGZvciBib3RoIHRoZSBwYXJ0aXRpb24ga2V5IGFuZCB0aGUgc29ydCBrZXkuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FtYXpvbmR5bmFtb2RiL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEl0ZW0uaHRtbCNEREItR2V0SXRlbS1yZXF1ZXN0LUtleVxuICAgKi9cbiAgcmVhZG9ubHkga2V5OiB7IFtrZXk6IHN0cmluZ106IER5bmFtb0F0dHJpYnV0ZVZhbHVlIH07XG5cbiAgLyoqXG4gICAqIEEgY29uZGl0aW9uIHRoYXQgbXVzdCBiZSBzYXRpc2ZpZWQgaW4gb3JkZXIgZm9yIGEgY29uZGl0aW9uYWwgRGVsZXRlSXRlbSB0byBzdWNjZWVkLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hbWF6b25keW5hbW9kYi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVJdGVtLmh0bWwjRERCLVVwZGF0ZUl0ZW0tcmVxdWVzdC1Db25kaXRpb25FeHByZXNzaW9uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gY29uZGl0aW9uIGV4cHJlc3Npb25cbiAgICovXG4gIHJlYWRvbmx5IGNvbmRpdGlvbkV4cHJlc3Npb24/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIE9uZSBvciBtb3JlIHN1YnN0aXR1dGlvbiB0b2tlbnMgZm9yIGF0dHJpYnV0ZSBuYW1lcyBpbiBhbiBleHByZXNzaW9uXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FtYXpvbmR5bmFtb2RiL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUl0ZW0uaHRtbCNEREItVXBkYXRlSXRlbS1yZXF1ZXN0LUV4cHJlc3Npb25BdHRyaWJ1dGVOYW1lc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGV4cHJlc3Npb24gYXR0cmlidXRlIG5hbWVzXG4gICAqL1xuICByZWFkb25seSBleHByZXNzaW9uQXR0cmlidXRlTmFtZXM/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuXG4gIC8qKlxuICAgKiBPbmUgb3IgbW9yZSB2YWx1ZXMgdGhhdCBjYW4gYmUgc3Vic3RpdHV0ZWQgaW4gYW4gZXhwcmVzc2lvbi5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYW1hem9uZHluYW1vZGIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlSXRlbS5odG1sI0REQi1VcGRhdGVJdGVtLXJlcXVlc3QtRXhwcmVzc2lvbkF0dHJpYnV0ZVZhbHVlc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGV4cHJlc3Npb24gYXR0cmlidXRlIHZhbHVlc1xuICAgKi9cbiAgcmVhZG9ubHkgZXhwcmVzc2lvbkF0dHJpYnV0ZVZhbHVlcz86IHsgW2tleTogc3RyaW5nXTogRHluYW1vQXR0cmlidXRlVmFsdWUgfTtcblxuICAvKipcbiAgICogRGV0ZXJtaW5lcyB0aGUgbGV2ZWwgb2YgZGV0YWlsIGFib3V0IHByb3Zpc2lvbmVkIHRocm91Z2hwdXQgY29uc3VtcHRpb24gdGhhdCBpcyByZXR1cm5lZCBpbiB0aGUgcmVzcG9uc2VcbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYW1hem9uZHluYW1vZGIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlSXRlbS5odG1sI0REQi1VcGRhdGVJdGVtLXJlcXVlc3QtUmV0dXJuQ29uc3VtZWRDYXBhY2l0eVxuICAgKlxuICAgKiBAZGVmYXVsdCBEeW5hbW9Db25zdW1lZENhcGFjaXR5Lk5PTkVcbiAgICovXG4gIHJlYWRvbmx5IHJldHVybkNvbnN1bWVkQ2FwYWNpdHk/OiBEeW5hbW9Db25zdW1lZENhcGFjaXR5O1xuXG4gIC8qKlxuICAgKiBEZXRlcm1pbmVzIHdoZXRoZXIgaXRlbSBjb2xsZWN0aW9uIG1ldHJpY3MgYXJlIHJldHVybmVkLlxuICAgKiBJZiBzZXQgdG8gU0laRSwgdGhlIHJlc3BvbnNlIGluY2x1ZGVzIHN0YXRpc3RpY3MgYWJvdXQgaXRlbSBjb2xsZWN0aW9ucywgaWYgYW55LFxuICAgKiB0aGF0IHdlcmUgbW9kaWZpZWQgZHVyaW5nIHRoZSBvcGVyYXRpb24gYXJlIHJldHVybmVkIGluIHRoZSByZXNwb25zZS5cbiAgICogSWYgc2V0IHRvIE5PTkUgKHRoZSBkZWZhdWx0KSwgbm8gc3RhdGlzdGljcyBhcmUgcmV0dXJuZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IER5bmFtb0l0ZW1Db2xsZWN0aW9uTWV0cmljcy5OT05FXG4gICAqL1xuICByZWFkb25seSByZXR1cm5JdGVtQ29sbGVjdGlvbk1ldHJpY3M/OiBEeW5hbW9JdGVtQ29sbGVjdGlvbk1ldHJpY3M7XG5cbiAgLyoqXG4gICAqIFVzZSBSZXR1cm5WYWx1ZXMgaWYgeW91IHdhbnQgdG8gZ2V0IHRoZSBpdGVtIGF0dHJpYnV0ZXMgYXMgdGhleSBhcHBlYXJlZCBiZWZvcmUgdGhleSB3ZXJlIGRlbGV0ZWQuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FtYXpvbmR5bmFtb2RiL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUl0ZW0uaHRtbCNEREItVXBkYXRlSXRlbS1yZXF1ZXN0LVJldHVyblZhbHVlc1xuICAgKlxuICAgKiBAZGVmYXVsdCBEeW5hbW9SZXR1cm5WYWx1ZXMuTk9ORVxuICAgKi9cbiAgcmVhZG9ubHkgcmV0dXJuVmFsdWVzPzogRHluYW1vUmV0dXJuVmFsdWVzO1xuXG4gIC8qKlxuICAgKiBBbiBleHByZXNzaW9uIHRoYXQgZGVmaW5lcyBvbmUgb3IgbW9yZSBhdHRyaWJ1dGVzIHRvIGJlIHVwZGF0ZWQsXG4gICAqIHRoZSBhY3Rpb24gdG8gYmUgcGVyZm9ybWVkIG9uIHRoZW0sIGFuZCBuZXcgdmFsdWVzIGZvciB0aGVtLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hbWF6b25keW5hbW9kYi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVJdGVtLmh0bWwjRERCLVVwZGF0ZUl0ZW0tcmVxdWVzdC1VcGRhdGVFeHByZXNzaW9uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gdXBkYXRlIGV4cHJlc3Npb25cbiAgICovXG4gIHJlYWRvbmx5IHVwZGF0ZUV4cHJlc3Npb24/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogQSBTdGVwRnVuY3Rpb25zIHRhc2sgdG8gY2FsbCBEeW5hbW9VcGRhdGVJdGVtXG4gKi9cbmV4cG9ydCBjbGFzcyBEeW5hbW9VcGRhdGVJdGVtIGV4dGVuZHMgc2ZuLlRhc2tTdGF0ZUJhc2Uge1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgdGFza01ldHJpY3M/OiBzZm4uVGFza01ldHJpY3NDb25maWc7XG4gIHByb3RlY3RlZCByZWFkb25seSB0YXNrUG9saWNpZXM/OiBpYW0uUG9saWN5U3RhdGVtZW50W107XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBwcm9wczogRHluYW1vVXBkYXRlSXRlbVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICB0aGlzLnRhc2tQb2xpY2llcyA9IFtcbiAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgcmVzb3VyY2VzOiBbXG4gICAgICAgICAgU3RhY2sub2YodGhpcykuZm9ybWF0QXJuKHtcbiAgICAgICAgICAgIHNlcnZpY2U6ICdkeW5hbW9kYicsXG4gICAgICAgICAgICByZXNvdXJjZTogJ3RhYmxlJyxcbiAgICAgICAgICAgIHJlc291cmNlTmFtZTogcHJvcHMudGFibGUudGFibGVOYW1lLFxuICAgICAgICAgIH0pLFxuICAgICAgICBdLFxuICAgICAgICBhY3Rpb25zOiBbYGR5bmFtb2RiOiR7RHluYW1vTWV0aG9kLlVQREFURX1JdGVtYF0sXG4gICAgICB9KSxcbiAgICBdO1xuICB9XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHJvdGVjdGVkIF9yZW5kZXJUYXNrKCk6IGFueSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIFJlc291cmNlOiBnZXREeW5hbW9SZXNvdXJjZUFybihEeW5hbW9NZXRob2QuVVBEQVRFKSxcbiAgICAgIFBhcmFtZXRlcnM6IHNmbi5GaWVsZFV0aWxzLnJlbmRlck9iamVjdCh7XG4gICAgICAgIEtleTogdHJhbnNmb3JtQXR0cmlidXRlVmFsdWVNYXAodGhpcy5wcm9wcy5rZXkpLFxuICAgICAgICBUYWJsZU5hbWU6IHRoaXMucHJvcHMudGFibGUudGFibGVOYW1lLFxuICAgICAgICBDb25kaXRpb25FeHByZXNzaW9uOiB0aGlzLnByb3BzLmNvbmRpdGlvbkV4cHJlc3Npb24sXG4gICAgICAgIEV4cHJlc3Npb25BdHRyaWJ1dGVOYW1lczogdGhpcy5wcm9wcy5leHByZXNzaW9uQXR0cmlidXRlTmFtZXMsXG4gICAgICAgIEV4cHJlc3Npb25BdHRyaWJ1dGVWYWx1ZXM6IHRyYW5zZm9ybUF0dHJpYnV0ZVZhbHVlTWFwKHRoaXMucHJvcHMuZXhwcmVzc2lvbkF0dHJpYnV0ZVZhbHVlcyksXG4gICAgICAgIFJldHVybkNvbnN1bWVkQ2FwYWNpdHk6IHRoaXMucHJvcHMucmV0dXJuQ29uc3VtZWRDYXBhY2l0eSxcbiAgICAgICAgUmV0dXJuSXRlbUNvbGxlY3Rpb25NZXRyaWNzOiB0aGlzLnByb3BzLnJldHVybkl0ZW1Db2xsZWN0aW9uTWV0cmljcyxcbiAgICAgICAgUmV0dXJuVmFsdWVzOiB0aGlzLnByb3BzLnJldHVyblZhbHVlcyxcbiAgICAgICAgVXBkYXRlRXhwcmVzc2lvbjogdGhpcy5wcm9wcy51cGRhdGVFeHByZXNzaW9uLFxuICAgICAgfSksXG4gICAgfTtcbiAgfVxufVxuIl19