"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptionOption = exports.AthenaStartQueryExecution = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * Start an Athena Query as a Task
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 */
class AthenaStartQueryExecution extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_AthenaStartQueryExecutionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.integrationPattern = (_b = props.integrationPattern) !== null && _b !== void 0 ? _b : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    createPolicyStatements() {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
        const policyStatements = [
            new iam.PolicyStatement({
                resources: [
                    cdk.Stack.of(this).formatArn({
                        service: 'athena',
                        resource: 'datacatalog',
                        resourceName: (_c = (_b = this.props.queryExecutionContext) === null || _b === void 0 ? void 0 : _b.catalogName) !== null && _c !== void 0 ? _c : 'AwsDataCatalog',
                    }),
                    cdk.Stack.of(this).formatArn({
                        service: 'athena',
                        resource: 'workgroup',
                        resourceName: (_d = this.props.workGroup) !== null && _d !== void 0 ? _d : 'primary',
                    }),
                ],
                actions: ['athena:getDataCatalog', 'athena:startQueryExecution', 'athena:getQueryExecution'],
            }),
        ];
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:CreateBucket',
                's3:ListBucket',
                's3:GetBucketLocation',
                's3:GetObject'],
            resources: ['*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:AbortMultipartUpload',
                's3:ListBucketMultipartUploads',
                's3:ListMultipartUploadParts',
                's3:PutObject'],
            resources: [((_f = (_e = this.props.resultConfiguration) === null || _e === void 0 ? void 0 : _e.outputLocation) === null || _f === void 0 ? void 0 : _f.bucketName) ? `arn:aws:s3:::${(_h = (_g = this.props.resultConfiguration) === null || _g === void 0 ? void 0 : _g.outputLocation) === null || _h === void 0 ? void 0 : _h.bucketName}/${(_k = (_j = this.props.resultConfiguration) === null || _j === void 0 ? void 0 : _j.outputLocation) === null || _k === void 0 ? void 0 : _k.objectKey}/*` : '*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['lakeformation:GetDataAccess'],
            resources: ['*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['glue:BatchCreatePartition',
                'glue:BatchDeletePartition',
                'glue:BatchDeleteTable',
                'glue:BatchGetPartition',
                'glue:CreateDatabase',
                'glue:CreatePartition',
                'glue:CreateTable',
                'glue:DeleteDatabase',
                'glue:DeletePartition',
                'glue:DeleteTable',
                'glue:GetDatabase',
                'glue:GetDatabases',
                'glue:GetPartition',
                'glue:GetPartitions',
                'glue:GetTable',
                'glue:GetTables',
                'glue:UpdateDatabase',
                'glue:UpdatePartition',
                'glue:UpdateTable'],
            resources: [
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'catalog',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'database',
                    resourceName: (_m = (_l = this.props.queryExecutionContext) === null || _l === void 0 ? void 0 : _l.databaseName) !== null && _m !== void 0 ? _m : 'default',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'table',
                    resourceName: ((_p = (_o = this.props.queryExecutionContext) === null || _o === void 0 ? void 0 : _o.databaseName) !== null && _p !== void 0 ? _p : 'default') + '/*',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'userDefinedFunction',
                    resourceName: ((_r = (_q = this.props.queryExecutionContext) === null || _q === void 0 ? void 0 : _q.databaseName) !== null && _r !== void 0 ? _r : 'default') + '/*',
                }),
            ],
        }));
        return policyStatements;
    }
    renderEncryption() {
        var _b;
        const encryptionConfiguration = ((_b = this.props.resultConfiguration) === null || _b === void 0 ? void 0 : _b.encryptionConfiguration) !== undefined
            ? {
                EncryptionOption: this.props.resultConfiguration.encryptionConfiguration.encryptionOption,
                KmsKey: this.props.resultConfiguration.encryptionConfiguration.encryptionKey,
            }
            : undefined;
        return encryptionConfiguration;
    }
    /**
     * Provides the Athena start query execution service integration task configuration
     */
    /**
     * @internal
     */
    _renderTask() {
        var _b, _c, _d, _e, _f, _g;
        return {
            Resource: task_utils_1.integrationResourceArn('athena', 'startQueryExecution', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                QueryString: this.props.queryString,
                ClientRequestToken: this.props.clientRequestToken,
                QueryExecutionContext: (((_b = this.props.queryExecutionContext) === null || _b === void 0 ? void 0 : _b.catalogName) || ((_c = this.props.queryExecutionContext) === null || _c === void 0 ? void 0 : _c.databaseName)) ? {
                    Catalog: (_d = this.props.queryExecutionContext) === null || _d === void 0 ? void 0 : _d.catalogName,
                    Database: (_e = this.props.queryExecutionContext) === null || _e === void 0 ? void 0 : _e.databaseName,
                } : undefined,
                ResultConfiguration: {
                    EncryptionConfiguration: this.renderEncryption(),
                    OutputLocation: ((_f = this.props.resultConfiguration) === null || _f === void 0 ? void 0 : _f.outputLocation) ? `s3://${this.props.resultConfiguration.outputLocation.bucketName}/${this.props.resultConfiguration.outputLocation.objectKey}/` : undefined,
                },
                WorkGroup: (_g = this.props) === null || _g === void 0 ? void 0 : _g.workGroup,
            }),
        };
    }
}
exports.AthenaStartQueryExecution = AthenaStartQueryExecution;
_a = JSII_RTTI_SYMBOL_1;
AthenaStartQueryExecution[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.AthenaStartQueryExecution", version: "1.159.0" };
AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.RUN_JOB,
];
/**
 * Encryption Options of the S3 bucket
 *
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption
 */
var EncryptionOption;
(function (EncryptionOption) {
    /**
     * Server side encryption (SSE) with an Amazon S3-managed key.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html
     */
    EncryptionOption["S3_MANAGED"] = "SSE_S3";
    /**
     * Server-side encryption (SSE) with an AWS KMS key managed by the account owner.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html
     */
    EncryptionOption["KMS"] = "SSE_KMS";
    /**
     * Client-side encryption (CSE) with an AWS KMS key managed by the account owner.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html
     */
    EncryptionOption["CLIENT_SIDE_KMS"] = "CSE_KMS";
})(EncryptionOption = exports.EncryptionOption || (exports.EncryptionOption = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhcnQtcXVlcnktZXhlY3V0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3RhcnQtcXVlcnktZXhlY3V0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHdDQUF3QztBQUd4QyxrREFBa0Q7QUFDbEQscUNBQXFDO0FBRXJDLHNEQUF5RjtBQXdDekY7Ozs7R0FJRztBQUNILE1BQWEseUJBQTBCLFNBQVEsR0FBRyxDQUFDLGFBQWE7SUFZOUQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBbUIsS0FBcUM7O1FBQzlGLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRGlDLFVBQUssR0FBTCxLQUFLLENBQWdDOzs7Ozs7Ozs7O1FBRTlGLElBQUksQ0FBQyxrQkFBa0IsU0FBRyxLQUFLLENBQUMsa0JBQWtCLG1DQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQztRQUU5RixxQ0FBd0IsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLEVBQUUseUJBQXlCLENBQUMsOEJBQThCLENBQUMsQ0FBQztRQUU1RyxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxzQkFBc0IsRUFBRSxDQUFDO0tBQ25EO0lBRU8sc0JBQXNCOztRQUM1QixNQUFNLGdCQUFnQixHQUFHO1lBQ3ZCLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztnQkFDdEIsU0FBUyxFQUFFO29CQUNULEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFNBQVMsQ0FBQzt3QkFDM0IsT0FBTyxFQUFFLFFBQVE7d0JBQ2pCLFFBQVEsRUFBRSxhQUFhO3dCQUN2QixZQUFZLGNBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsMENBQUUsV0FBVyxtQ0FBSSxnQkFBZ0I7cUJBQ2hGLENBQUM7b0JBQ0YsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO3dCQUMzQixPQUFPLEVBQUUsUUFBUTt3QkFDakIsUUFBUSxFQUFFLFdBQVc7d0JBQ3JCLFlBQVksUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsbUNBQUksU0FBUztxQkFDaEQsQ0FBQztpQkFFSDtnQkFDRCxPQUFPLEVBQUUsQ0FBQyx1QkFBdUIsRUFBRSw0QkFBNEIsRUFBRSwwQkFBMEIsQ0FBQzthQUM3RixDQUFDO1NBQ0gsQ0FBQztRQUVGLGdCQUFnQixDQUFDLElBQUksQ0FDbkIsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1lBQ3RCLE9BQU8sRUFBRSxDQUFDLGlCQUFpQjtnQkFDekIsZUFBZTtnQkFDZixzQkFBc0I7Z0JBQ3RCLGNBQWMsQ0FBQztZQUNqQixTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7U0FDakIsQ0FBQyxDQUNILENBQUM7UUFFRixnQkFBZ0IsQ0FBQyxJQUFJLENBQ25CLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUN0QixPQUFPLEVBQUUsQ0FBQyx5QkFBeUI7Z0JBQ2pDLCtCQUErQjtnQkFDL0IsNkJBQTZCO2dCQUM3QixjQUFjLENBQUM7WUFDakIsU0FBUyxFQUFFLENBQUMsYUFBQSxJQUFJLENBQUMsS0FBSyxDQUFDLG1CQUFtQiwwQ0FBRSxjQUFjLDBDQUFFLFVBQVUsRUFBQyxDQUFDLENBQUMsZ0JBQWdCLFlBQUEsSUFBSSxDQUFDLEtBQUssQ0FBQyxtQkFBbUIsMENBQUUsY0FBYywwQ0FBRSxVQUFVLElBQUksWUFBQSxJQUFJLENBQUMsS0FBSyxDQUFDLG1CQUFtQiwwQ0FBRSxjQUFjLDBDQUFFLFNBQVMsSUFBSSxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUM7U0FDNU4sQ0FBQyxDQUNILENBQUM7UUFFRixnQkFBZ0IsQ0FBQyxJQUFJLENBQ25CLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUN0QixPQUFPLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQztZQUN4QyxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7U0FDakIsQ0FBQyxDQUNILENBQUM7UUFFRixnQkFBZ0IsQ0FBQyxJQUFJLENBQ25CLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUN0QixPQUFPLEVBQUUsQ0FBQywyQkFBMkI7Z0JBQ25DLDJCQUEyQjtnQkFDM0IsdUJBQXVCO2dCQUN2Qix3QkFBd0I7Z0JBQ3hCLHFCQUFxQjtnQkFDckIsc0JBQXNCO2dCQUN0QixrQkFBa0I7Z0JBQ2xCLHFCQUFxQjtnQkFDckIsc0JBQXNCO2dCQUN0QixrQkFBa0I7Z0JBQ2xCLGtCQUFrQjtnQkFDbEIsbUJBQW1CO2dCQUNuQixtQkFBbUI7Z0JBQ25CLG9CQUFvQjtnQkFDcEIsZUFBZTtnQkFDZixnQkFBZ0I7Z0JBQ2hCLHFCQUFxQjtnQkFDckIsc0JBQXNCO2dCQUN0QixrQkFBa0IsQ0FBQztZQUNyQixTQUFTLEVBQUU7Z0JBQ1QsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO29CQUMzQixPQUFPLEVBQUUsTUFBTTtvQkFDZixRQUFRLEVBQUUsU0FBUztpQkFDcEIsQ0FBQztnQkFDRixHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUM7b0JBQzNCLE9BQU8sRUFBRSxNQUFNO29CQUNmLFFBQVEsRUFBRSxVQUFVO29CQUNwQixZQUFZLGNBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsMENBQUUsWUFBWSxtQ0FBSSxTQUFTO2lCQUMxRSxDQUFDO2dCQUNGLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFNBQVMsQ0FBQztvQkFDM0IsT0FBTyxFQUFFLE1BQU07b0JBQ2YsUUFBUSxFQUFFLE9BQU87b0JBQ2pCLFlBQVksRUFBRSxhQUFDLElBQUksQ0FBQyxLQUFLLENBQUMscUJBQXFCLDBDQUFFLFlBQVksbUNBQUksU0FBUyxDQUFDLEdBQUcsSUFBSTtpQkFDbkYsQ0FBQztnQkFDRixHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUM7b0JBQzNCLE9BQU8sRUFBRSxNQUFNO29CQUNmLFFBQVEsRUFBRSxxQkFBcUI7b0JBQy9CLFlBQVksRUFBRSxhQUFDLElBQUksQ0FBQyxLQUFLLENBQUMscUJBQXFCLDBDQUFFLFlBQVksbUNBQUksU0FBUyxDQUFDLEdBQUcsSUFBSTtpQkFDbkYsQ0FBQzthQUNIO1NBQ0YsQ0FBQyxDQUNILENBQUM7UUFFRixPQUFPLGdCQUFnQixDQUFDO0tBQ3pCO0lBRU8sZ0JBQWdCOztRQUN0QixNQUFNLHVCQUF1QixHQUFHLE9BQUEsSUFBSSxDQUFDLEtBQUssQ0FBQyxtQkFBbUIsMENBQUUsdUJBQXVCLE1BQUssU0FBUztZQUNuRyxDQUFDLENBQUM7Z0JBQ0EsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyx1QkFBdUIsQ0FBQyxnQkFBZ0I7Z0JBQ3pGLE1BQU0sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLG1CQUFtQixDQUFDLHVCQUF1QixDQUFDLGFBQWE7YUFDN0U7WUFDRCxDQUFDLENBQUMsU0FBUyxDQUFDO1FBRWQsT0FBTyx1QkFBdUIsQ0FBQztLQUNoQztJQUVEOztPQUVHO0lBQ0g7O09BRUc7SUFDTyxXQUFXOztRQUNuQixPQUFPO1lBQ0wsUUFBUSxFQUFFLG1DQUFzQixDQUFDLFFBQVEsRUFBRSxxQkFBcUIsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUM7WUFDMUYsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO2dCQUN0QyxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXO2dCQUNuQyxrQkFBa0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQjtnQkFDakQscUJBQXFCLEVBQUUsQ0FBQyxPQUFBLElBQUksQ0FBQyxLQUFLLENBQUMscUJBQXFCLDBDQUFFLFdBQVcsWUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLHFCQUFxQiwwQ0FBRSxZQUFZLENBQUEsQ0FBQyxDQUFDLENBQUMsQ0FBQztvQkFDekgsT0FBTyxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMscUJBQXFCLDBDQUFFLFdBQVc7b0JBQ3RELFFBQVEsUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLHFCQUFxQiwwQ0FBRSxZQUFZO2lCQUN6RCxDQUFDLENBQUMsQ0FBQyxTQUFTO2dCQUNiLG1CQUFtQixFQUFFO29CQUNuQix1QkFBdUIsRUFBRSxJQUFJLENBQUMsZ0JBQWdCLEVBQUU7b0JBQ2hELGNBQWMsRUFBRSxPQUFBLElBQUksQ0FBQyxLQUFLLENBQUMsbUJBQW1CLDBDQUFFLGNBQWMsRUFBQyxDQUFDLENBQUMsUUFBUSxJQUFJLENBQUMsS0FBSyxDQUFDLG1CQUFtQixDQUFDLGNBQWMsQ0FBQyxVQUFVLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyxjQUFjLENBQUMsU0FBUyxHQUFHLENBQUMsQ0FBQyxDQUFDLFNBQVM7aUJBQzVNO2dCQUNELFNBQVMsUUFBRSxJQUFJLENBQUMsS0FBSywwQ0FBRSxTQUFTO2FBQ2pDLENBQUM7U0FDSCxDQUFDO0tBQ0g7O0FBdEpILDhEQXVKQzs7O0FBckp5Qix3REFBOEIsR0FBNkI7SUFDakYsR0FBRyxDQUFDLGtCQUFrQixDQUFDLGdCQUFnQjtJQUN2QyxHQUFHLENBQUMsa0JBQWtCLENBQUMsT0FBTztDQUMvQixDQUFDO0FBa01KOzs7O0dBSUc7QUFDSCxJQUFZLGdCQXFCWDtBQXJCRCxXQUFZLGdCQUFnQjtJQUMxQjs7OztPQUlHO0lBQ0gseUNBQXFCLENBQUE7SUFFckI7Ozs7T0FJRztJQUNILG1DQUFlLENBQUE7SUFFZjs7OztPQUlHO0lBQ0gsK0NBQTJCLENBQUE7QUFDN0IsQ0FBQyxFQXJCVyxnQkFBZ0IsR0FBaEIsd0JBQWdCLEtBQWhCLHdCQUFnQixRQXFCM0IiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBrbXMgZnJvbSAnQGF3cy1jZGsvYXdzLWttcyc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0ICogYXMgc2ZuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zdGVwZnVuY3Rpb25zJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgaW50ZWdyYXRpb25SZXNvdXJjZUFybiwgdmFsaWRhdGVQYXR0ZXJuU3VwcG9ydGVkIH0gZnJvbSAnLi4vcHJpdmF0ZS90YXNrLXV0aWxzJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBzdGFydGluZyBhIFF1ZXJ5IEV4ZWN1dGlvblxuICovXG5leHBvcnQgaW50ZXJmYWNlIEF0aGVuYVN0YXJ0UXVlcnlFeGVjdXRpb25Qcm9wcyBleHRlbmRzIHNmbi5UYXNrU3RhdGVCYXNlUHJvcHMge1xuICAvKipcbiAgICogUXVlcnkgdGhhdCB3aWxsIGJlIHN0YXJ0ZWRcbiAgICovXG4gIHJlYWRvbmx5IHF1ZXJ5U3RyaW5nOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFVuaXF1ZSBzdHJpbmcgc3RyaW5nIHRvIGVuc3VyZSBpZGVtcG90ZW5jZVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGNsaWVudCByZXF1ZXN0IHRva2VuXG4gICAqL1xuICByZWFkb25seSBjbGllbnRSZXF1ZXN0VG9rZW4/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIERhdGFiYXNlIHdpdGhpbiB3aGljaCBxdWVyeSBleGVjdXRlc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIHF1ZXJ5IGV4ZWN1dGlvbiBjb250ZXh0XG4gICAqL1xuICByZWFkb25seSBxdWVyeUV4ZWN1dGlvbkNvbnRleHQ/OiBRdWVyeUV4ZWN1dGlvbkNvbnRleHQ7XG5cbiAgLyoqXG4gICAqIENvbmZpZ3VyYXRpb24gb24gaG93IGFuZCB3aGVyZSB0byBzYXZlIHF1ZXJ5XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gcmVzdWx0IGNvbmZpZ3VyYXRpb25cbiAgICovXG4gIHJlYWRvbmx5IHJlc3VsdENvbmZpZ3VyYXRpb24/OiBSZXN1bHRDb25maWd1cmF0aW9uO1xuXG4gIC8qKlxuICAgKiBDb25maWd1cmF0aW9uIG9uIGhvdyBhbmQgd2hlcmUgdG8gc2F2ZSBxdWVyeVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIHdvcmsgZ3JvdXBcbiAgICovXG4gIHJlYWRvbmx5IHdvcmtHcm91cD86IHN0cmluZztcbn1cblxuLyoqXG4gKiBTdGFydCBhbiBBdGhlbmEgUXVlcnkgYXMgYSBUYXNrXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc3RlcC1mdW5jdGlvbnMvbGF0ZXN0L2RnL2Nvbm5lY3QtYXRoZW5hLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIEF0aGVuYVN0YXJ0UXVlcnlFeGVjdXRpb24gZXh0ZW5kcyBzZm4uVGFza1N0YXRlQmFzZSB7XG5cbiAgcHJpdmF0ZSBzdGF0aWMgcmVhZG9ubHkgU1VQUE9SVEVEX0lOVEVHUkFUSU9OX1BBVFRFUk5TOiBzZm4uSW50ZWdyYXRpb25QYXR0ZXJuW10gPSBbXG4gICAgc2ZuLkludGVncmF0aW9uUGF0dGVybi5SRVFVRVNUX1JFU1BPTlNFLFxuICAgIHNmbi5JbnRlZ3JhdGlvblBhdHRlcm4uUlVOX0pPQixcbiAgXTtcblxuICBwcm90ZWN0ZWQgcmVhZG9ubHkgdGFza01ldHJpY3M/OiBzZm4uVGFza01ldHJpY3NDb25maWc7XG4gIHByb3RlY3RlZCByZWFkb25seSB0YXNrUG9saWNpZXM/OiBpYW0uUG9saWN5U3RhdGVtZW50W107XG5cbiAgcHJpdmF0ZSByZWFkb25seSBpbnRlZ3JhdGlvblBhdHRlcm46IHNmbi5JbnRlZ3JhdGlvblBhdHRlcm47XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBwcm9wczogQXRoZW5hU3RhcnRRdWVyeUV4ZWN1dGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgdGhpcy5pbnRlZ3JhdGlvblBhdHRlcm4gPSBwcm9wcy5pbnRlZ3JhdGlvblBhdHRlcm4gPz8gc2ZuLkludGVncmF0aW9uUGF0dGVybi5SRVFVRVNUX1JFU1BPTlNFO1xuXG4gICAgdmFsaWRhdGVQYXR0ZXJuU3VwcG9ydGVkKHRoaXMuaW50ZWdyYXRpb25QYXR0ZXJuLCBBdGhlbmFTdGFydFF1ZXJ5RXhlY3V0aW9uLlNVUFBPUlRFRF9JTlRFR1JBVElPTl9QQVRURVJOUyk7XG5cbiAgICB0aGlzLnRhc2tQb2xpY2llcyA9IHRoaXMuY3JlYXRlUG9saWN5U3RhdGVtZW50cygpO1xuICB9XG5cbiAgcHJpdmF0ZSBjcmVhdGVQb2xpY3lTdGF0ZW1lbnRzKCk6IGlhbS5Qb2xpY3lTdGF0ZW1lbnRbXSB7XG4gICAgY29uc3QgcG9saWN5U3RhdGVtZW50cyA9IFtcbiAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgcmVzb3VyY2VzOiBbXG4gICAgICAgICAgY2RrLlN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICAgICAgICBzZXJ2aWNlOiAnYXRoZW5hJyxcbiAgICAgICAgICAgIHJlc291cmNlOiAnZGF0YWNhdGFsb2cnLFxuICAgICAgICAgICAgcmVzb3VyY2VOYW1lOiB0aGlzLnByb3BzLnF1ZXJ5RXhlY3V0aW9uQ29udGV4dD8uY2F0YWxvZ05hbWUgPz8gJ0F3c0RhdGFDYXRhbG9nJyxcbiAgICAgICAgICB9KSxcbiAgICAgICAgICBjZGsuU3RhY2sub2YodGhpcykuZm9ybWF0QXJuKHtcbiAgICAgICAgICAgIHNlcnZpY2U6ICdhdGhlbmEnLFxuICAgICAgICAgICAgcmVzb3VyY2U6ICd3b3JrZ3JvdXAnLFxuICAgICAgICAgICAgcmVzb3VyY2VOYW1lOiB0aGlzLnByb3BzLndvcmtHcm91cCA/PyAncHJpbWFyeScsXG4gICAgICAgICAgfSksXG5cbiAgICAgICAgXSxcbiAgICAgICAgYWN0aW9uczogWydhdGhlbmE6Z2V0RGF0YUNhdGFsb2cnLCAnYXRoZW5hOnN0YXJ0UXVlcnlFeGVjdXRpb24nLCAnYXRoZW5hOmdldFF1ZXJ5RXhlY3V0aW9uJ10sXG4gICAgICB9KSxcbiAgICBdO1xuXG4gICAgcG9saWN5U3RhdGVtZW50cy5wdXNoKFxuICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICBhY3Rpb25zOiBbJ3MzOkNyZWF0ZUJ1Y2tldCcsXG4gICAgICAgICAgJ3MzOkxpc3RCdWNrZXQnLFxuICAgICAgICAgICdzMzpHZXRCdWNrZXRMb2NhdGlvbicsXG4gICAgICAgICAgJ3MzOkdldE9iamVjdCddLFxuICAgICAgICByZXNvdXJjZXM6IFsnKiddLCAvLyBOZWVkICogcGVybWlzc2lvbnMgdG8gY3JlYXRlIG5ldyBvdXRwdXQgbG9jYXRpb24gaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F0aGVuYS9sYXRlc3QvdWcvc2VjdXJpdHktaWFtLWF0aGVuYS5odG1sXG4gICAgICB9KSxcbiAgICApO1xuXG4gICAgcG9saWN5U3RhdGVtZW50cy5wdXNoKFxuICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICBhY3Rpb25zOiBbJ3MzOkFib3J0TXVsdGlwYXJ0VXBsb2FkJyxcbiAgICAgICAgICAnczM6TGlzdEJ1Y2tldE11bHRpcGFydFVwbG9hZHMnLFxuICAgICAgICAgICdzMzpMaXN0TXVsdGlwYXJ0VXBsb2FkUGFydHMnLFxuICAgICAgICAgICdzMzpQdXRPYmplY3QnXSxcbiAgICAgICAgcmVzb3VyY2VzOiBbdGhpcy5wcm9wcy5yZXN1bHRDb25maWd1cmF0aW9uPy5vdXRwdXRMb2NhdGlvbj8uYnVja2V0TmFtZSA/IGBhcm46YXdzOnMzOjo6JHt0aGlzLnByb3BzLnJlc3VsdENvbmZpZ3VyYXRpb24/Lm91dHB1dExvY2F0aW9uPy5idWNrZXROYW1lfS8ke3RoaXMucHJvcHMucmVzdWx0Q29uZmlndXJhdGlvbj8ub3V0cHV0TG9jYXRpb24/Lm9iamVjdEtleX0vKmAgOiAnKiddLCAvLyBOZWVkIFMzIGxvY2F0aW9uIHdoZXJlIGRhdGEgaXMgc3RvcmVkIG9yIEF0aGVuYSB0aHJvd3MgYW4gVW5hYmxlIHRvIHZlcmlmeS9jcmVhdGUgb3V0cHV0IGJ1Y2tldCBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXRoZW5hL2xhdGVzdC91Zy9zZWN1cml0eS1pYW0tYXRoZW5hLmh0bWxcbiAgICAgIH0pLFxuICAgICk7XG5cbiAgICBwb2xpY3lTdGF0ZW1lbnRzLnB1c2goXG4gICAgICBuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIGFjdGlvbnM6IFsnbGFrZWZvcm1hdGlvbjpHZXREYXRhQWNjZXNzJ10sXG4gICAgICAgIHJlc291cmNlczogWycqJ10sIC8vIFN0YXRlIG1hY2hpbmVzIHNjb3BlZCB0byBvdXRwdXQgbG9jYXRpb24gZmFpbCBhbmQgKiBwZXJtaXNzaW9ucyBhcmUgcmVxdWlyZWQgYXMgcGVyIGRvY3VtZW50YXRpb24gaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xha2UtZm9ybWF0aW9uL2xhdGVzdC9kZy9wZXJtaXNzaW9ucy1yZWZlcmVuY2UuaHRtbFxuICAgICAgfSksXG4gICAgKTtcblxuICAgIHBvbGljeVN0YXRlbWVudHMucHVzaChcbiAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgYWN0aW9uczogWydnbHVlOkJhdGNoQ3JlYXRlUGFydGl0aW9uJyxcbiAgICAgICAgICAnZ2x1ZTpCYXRjaERlbGV0ZVBhcnRpdGlvbicsXG4gICAgICAgICAgJ2dsdWU6QmF0Y2hEZWxldGVUYWJsZScsXG4gICAgICAgICAgJ2dsdWU6QmF0Y2hHZXRQYXJ0aXRpb24nLFxuICAgICAgICAgICdnbHVlOkNyZWF0ZURhdGFiYXNlJyxcbiAgICAgICAgICAnZ2x1ZTpDcmVhdGVQYXJ0aXRpb24nLFxuICAgICAgICAgICdnbHVlOkNyZWF0ZVRhYmxlJyxcbiAgICAgICAgICAnZ2x1ZTpEZWxldGVEYXRhYmFzZScsXG4gICAgICAgICAgJ2dsdWU6RGVsZXRlUGFydGl0aW9uJyxcbiAgICAgICAgICAnZ2x1ZTpEZWxldGVUYWJsZScsXG4gICAgICAgICAgJ2dsdWU6R2V0RGF0YWJhc2UnLFxuICAgICAgICAgICdnbHVlOkdldERhdGFiYXNlcycsXG4gICAgICAgICAgJ2dsdWU6R2V0UGFydGl0aW9uJyxcbiAgICAgICAgICAnZ2x1ZTpHZXRQYXJ0aXRpb25zJyxcbiAgICAgICAgICAnZ2x1ZTpHZXRUYWJsZScsXG4gICAgICAgICAgJ2dsdWU6R2V0VGFibGVzJyxcbiAgICAgICAgICAnZ2x1ZTpVcGRhdGVEYXRhYmFzZScsXG4gICAgICAgICAgJ2dsdWU6VXBkYXRlUGFydGl0aW9uJyxcbiAgICAgICAgICAnZ2x1ZTpVcGRhdGVUYWJsZSddLFxuICAgICAgICByZXNvdXJjZXM6IFtcbiAgICAgICAgICBjZGsuU3RhY2sub2YodGhpcykuZm9ybWF0QXJuKHtcbiAgICAgICAgICAgIHNlcnZpY2U6ICdnbHVlJyxcbiAgICAgICAgICAgIHJlc291cmNlOiAnY2F0YWxvZycsXG4gICAgICAgICAgfSksXG4gICAgICAgICAgY2RrLlN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICAgICAgICBzZXJ2aWNlOiAnZ2x1ZScsXG4gICAgICAgICAgICByZXNvdXJjZTogJ2RhdGFiYXNlJyxcbiAgICAgICAgICAgIHJlc291cmNlTmFtZTogdGhpcy5wcm9wcy5xdWVyeUV4ZWN1dGlvbkNvbnRleHQ/LmRhdGFiYXNlTmFtZSA/PyAnZGVmYXVsdCcsXG4gICAgICAgICAgfSksXG4gICAgICAgICAgY2RrLlN0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICAgICAgICBzZXJ2aWNlOiAnZ2x1ZScsXG4gICAgICAgICAgICByZXNvdXJjZTogJ3RhYmxlJyxcbiAgICAgICAgICAgIHJlc291cmNlTmFtZTogKHRoaXMucHJvcHMucXVlcnlFeGVjdXRpb25Db250ZXh0Py5kYXRhYmFzZU5hbWUgPz8gJ2RlZmF1bHQnKSArICcvKicsIC8vIGdyYW50IGFjY2VzcyB0byBhbGwgdGFibGVzIGluIHRoZSBzcGVjaWZpZWQgb3IgZGVmYXVsdCBkYXRhYmFzZSB0byBwcmV2ZW50IGNyb3NzIGRhdGFiYXNlIGFjY2VzcyBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvbGlzdF9hd3NnbHVlLmh0bWxcbiAgICAgICAgICB9KSxcbiAgICAgICAgICBjZGsuU3RhY2sub2YodGhpcykuZm9ybWF0QXJuKHtcbiAgICAgICAgICAgIHNlcnZpY2U6ICdnbHVlJyxcbiAgICAgICAgICAgIHJlc291cmNlOiAndXNlckRlZmluZWRGdW5jdGlvbicsXG4gICAgICAgICAgICByZXNvdXJjZU5hbWU6ICh0aGlzLnByb3BzLnF1ZXJ5RXhlY3V0aW9uQ29udGV4dD8uZGF0YWJhc2VOYW1lID8/ICdkZWZhdWx0JykgKyAnLyonLCAvLyBncmFudCBhY2Nlc3MgdG8gZ2V0IGFsbCB1c2VyIGRlZmluZWQgZnVuY3Rpb25zIGZvciB0aGUgcGFydGljdWxhciBkYXRhYmFzZSBpbiB0aGUgcmVxdWVzdCBvciB0aGUgZGVmYXVsdCBkYXRhYmFzZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvbGlzdF9hd3NnbHVlLmh0bWxcbiAgICAgICAgICB9KSxcbiAgICAgICAgXSxcbiAgICAgIH0pLFxuICAgICk7XG5cbiAgICByZXR1cm4gcG9saWN5U3RhdGVtZW50cztcbiAgfVxuXG4gIHByaXZhdGUgcmVuZGVyRW5jcnlwdGlvbigpOiBhbnkge1xuICAgIGNvbnN0IGVuY3J5cHRpb25Db25maWd1cmF0aW9uID0gdGhpcy5wcm9wcy5yZXN1bHRDb25maWd1cmF0aW9uPy5lbmNyeXB0aW9uQ29uZmlndXJhdGlvbiAhPT0gdW5kZWZpbmVkXG4gICAgICA/IHtcbiAgICAgICAgRW5jcnlwdGlvbk9wdGlvbjogdGhpcy5wcm9wcy5yZXN1bHRDb25maWd1cmF0aW9uLmVuY3J5cHRpb25Db25maWd1cmF0aW9uLmVuY3J5cHRpb25PcHRpb24sXG4gICAgICAgIEttc0tleTogdGhpcy5wcm9wcy5yZXN1bHRDb25maWd1cmF0aW9uLmVuY3J5cHRpb25Db25maWd1cmF0aW9uLmVuY3J5cHRpb25LZXksXG4gICAgICB9XG4gICAgICA6IHVuZGVmaW5lZDtcblxuICAgIHJldHVybiBlbmNyeXB0aW9uQ29uZmlndXJhdGlvbjtcbiAgfVxuXG4gIC8qKlxuICAgKiBQcm92aWRlcyB0aGUgQXRoZW5hIHN0YXJ0IHF1ZXJ5IGV4ZWN1dGlvbiBzZXJ2aWNlIGludGVncmF0aW9uIHRhc2sgY29uZmlndXJhdGlvblxuICAgKi9cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHJvdGVjdGVkIF9yZW5kZXJUYXNrKCk6IGFueSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIFJlc291cmNlOiBpbnRlZ3JhdGlvblJlc291cmNlQXJuKCdhdGhlbmEnLCAnc3RhcnRRdWVyeUV4ZWN1dGlvbicsIHRoaXMuaW50ZWdyYXRpb25QYXR0ZXJuKSxcbiAgICAgIFBhcmFtZXRlcnM6IHNmbi5GaWVsZFV0aWxzLnJlbmRlck9iamVjdCh7XG4gICAgICAgIFF1ZXJ5U3RyaW5nOiB0aGlzLnByb3BzLnF1ZXJ5U3RyaW5nLFxuICAgICAgICBDbGllbnRSZXF1ZXN0VG9rZW46IHRoaXMucHJvcHMuY2xpZW50UmVxdWVzdFRva2VuLFxuICAgICAgICBRdWVyeUV4ZWN1dGlvbkNvbnRleHQ6ICh0aGlzLnByb3BzLnF1ZXJ5RXhlY3V0aW9uQ29udGV4dD8uY2F0YWxvZ05hbWUgfHwgdGhpcy5wcm9wcy5xdWVyeUV4ZWN1dGlvbkNvbnRleHQ/LmRhdGFiYXNlTmFtZSkgPyB7XG4gICAgICAgICAgQ2F0YWxvZzogdGhpcy5wcm9wcy5xdWVyeUV4ZWN1dGlvbkNvbnRleHQ/LmNhdGFsb2dOYW1lLFxuICAgICAgICAgIERhdGFiYXNlOiB0aGlzLnByb3BzLnF1ZXJ5RXhlY3V0aW9uQ29udGV4dD8uZGF0YWJhc2VOYW1lLFxuICAgICAgICB9IDogdW5kZWZpbmVkLFxuICAgICAgICBSZXN1bHRDb25maWd1cmF0aW9uOiB7XG4gICAgICAgICAgRW5jcnlwdGlvbkNvbmZpZ3VyYXRpb246IHRoaXMucmVuZGVyRW5jcnlwdGlvbigpLFxuICAgICAgICAgIE91dHB1dExvY2F0aW9uOiB0aGlzLnByb3BzLnJlc3VsdENvbmZpZ3VyYXRpb24/Lm91dHB1dExvY2F0aW9uID8gYHMzOi8vJHt0aGlzLnByb3BzLnJlc3VsdENvbmZpZ3VyYXRpb24ub3V0cHV0TG9jYXRpb24uYnVja2V0TmFtZX0vJHt0aGlzLnByb3BzLnJlc3VsdENvbmZpZ3VyYXRpb24ub3V0cHV0TG9jYXRpb24ub2JqZWN0S2V5fS9gIDogdW5kZWZpbmVkLFxuICAgICAgICB9LFxuICAgICAgICBXb3JrR3JvdXA6IHRoaXMucHJvcHM/LndvcmtHcm91cCxcbiAgICAgIH0pLFxuICAgIH07XG4gIH1cbn1cblxuLyoqXG4gKiBMb2NhdGlvbiBvZiBxdWVyeSByZXN1bHQgYWxvbmcgd2l0aCBTMyBidWNrZXQgY29uZmlndXJhdGlvblxuICpcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F0aGVuYS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9SZXN1bHRDb25maWd1cmF0aW9uLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBSZXN1bHRDb25maWd1cmF0aW9uIHtcblxuICAvKipcbiAgICogUzMgcGF0aCBvZiBxdWVyeSByZXN1bHRzXG4gICAqXG4gICAqIEV4YW1wbGUgdmFsdWU6IGBzMzovL3F1ZXJ5LXJlc3VsdHMtYnVja2V0L2ZvbGRlci9gXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gUXVlcnkgUmVzdWx0IExvY2F0aW9uIHNldCBpbiBBdGhlbmEgc2V0dGluZ3MgZm9yIHRoaXMgd29ya2dyb3VwXG4gICovXG4gIHJlYWRvbmx5IG91dHB1dExvY2F0aW9uPzogczMuTG9jYXRpb247XG5cbiAgLyoqXG4gICAqIEVuY3J5cHRpb24gb3B0aW9uIHVzZWQgaWYgZW5hYmxlZCBpbiBTM1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIFNTRV9TMyBlbmNycHl0aW9uIGlzIGVuYWJsZWQgd2l0aCBkZWZhdWx0IGVuY3J5cHRpb24ga2V5XG4gICAqL1xuICByZWFkb25seSBlbmNyeXB0aW9uQ29uZmlndXJhdGlvbj86IEVuY3J5cHRpb25Db25maWd1cmF0aW9uXG59XG5cbi8qKlxuICogRW5jcnlwdGlvbiBDb25maWd1cmF0aW9uIG9mIHRoZSBTMyBidWNrZXRcbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdGhlbmEvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRW5jcnlwdGlvbkNvbmZpZ3VyYXRpb24uaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEVuY3J5cHRpb25Db25maWd1cmF0aW9uIHtcblxuICAvKipcbiAgICogVHlwZSBvZiBTMyBzZXJ2ZXItc2lkZSBlbmNyeXB0aW9uIGVuYWJsZWRcbiAgICpcbiAgICogQGRlZmF1bHQgRW5jcnlwdGlvbk9wdGlvbi5TM19NQU5BR0VEXG4gICAqL1xuICByZWFkb25seSBlbmNyeXB0aW9uT3B0aW9uOiBFbmNyeXB0aW9uT3B0aW9uO1xuXG4gIC8qKlxuICAgKiBLTVMga2V5IEFSTiBvciBJRFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIEtNUyBrZXkgZm9yIEVuY3J5cHRpb24gT3B0aW9uIFNTRV9TMyBhbmQgZGVmYXVsdCBtYXN0ZXIga2V5IGZvciBFbmNyeXB0aW9uIE9wdGlvbiBTU0VfS01TIGFuZCBDU0VfS01TXG4gICAqL1xuICByZWFkb25seSBlbmNyeXB0aW9uS2V5Pzoga21zLklLZXk7XG59XG5cbi8qKlxuICogRW5jcnlwdGlvbiBPcHRpb25zIG9mIHRoZSBTMyBidWNrZXRcbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdGhlbmEvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRW5jcnlwdGlvbkNvbmZpZ3VyYXRpb24uaHRtbCNhdGhlbmEtVHlwZS1FbmNyeXB0aW9uQ29uZmlndXJhdGlvbi1FbmNyeXB0aW9uT3B0aW9uXG4gKi9cbmV4cG9ydCBlbnVtIEVuY3J5cHRpb25PcHRpb24ge1xuICAvKipcbiAgICogU2VydmVyIHNpZGUgZW5jcnlwdGlvbiAoU1NFKSB3aXRoIGFuIEFtYXpvbiBTMy1tYW5hZ2VkIGtleS5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uUzMvbGF0ZXN0L2Rldi9Vc2luZ1NlcnZlclNpZGVFbmNyeXB0aW9uLmh0bWxcbiAgICovXG4gIFMzX01BTkFHRUQgPSAnU1NFX1MzJyxcblxuICAvKipcbiAgICogU2VydmVyLXNpZGUgZW5jcnlwdGlvbiAoU1NFKSB3aXRoIGFuIEFXUyBLTVMga2V5IG1hbmFnZWQgYnkgdGhlIGFjY291bnQgb3duZXIuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvblMzL2xhdGVzdC9kZXYvVXNpbmdLTVNFbmNyeXB0aW9uLmh0bWxcbiAgICovXG4gIEtNUyA9ICdTU0VfS01TJyxcblxuICAvKipcbiAgICogQ2xpZW50LXNpZGUgZW5jcnlwdGlvbiAoQ1NFKSB3aXRoIGFuIEFXUyBLTVMga2V5IG1hbmFnZWQgYnkgdGhlIGFjY291bnQgb3duZXIuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvblMzL2xhdGVzdC9kZXYvVXNpbmdDbGllbnRTaWRlRW5jcnlwdGlvbi5odG1sXG4gICAqL1xuICBDTElFTlRfU0lERV9LTVMgPSAnQ1NFX0tNUydcbn1cblxuLyoqXG4gKiBEYXRhYmFzZSBhbmQgZGF0YSBjYXRhbG9nIGNvbnRleHQgaW4gd2hpY2ggdGhlIHF1ZXJ5IGV4ZWN1dGlvbiBvY2N1cnNcbiAqXG4gKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hdGhlbmEvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfUXVlcnlFeGVjdXRpb25Db250ZXh0Lmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBRdWVyeUV4ZWN1dGlvbkNvbnRleHQge1xuXG4gIC8qKlxuICAgKiBOYW1lIG9mIGNhdGFsb2cgdXNlZCBpbiBxdWVyeSBleGVjdXRpb25cbiAgICpcbiAgICogQGRlZmF1bHQgLSBObyBjYXRhbG9nXG4gICAqL1xuICByZWFkb25seSBjYXRhbG9nTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogTmFtZSBvZiBkYXRhYmFzZSB1c2VkIGluIHF1ZXJ5IGV4ZWN1dGlvblxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGRhdGFiYXNlXG4gICAqL1xuICByZWFkb25seSBkYXRhYmFzZU5hbWU/OiBzdHJpbmc7XG59XG4iXX0=