# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['acpype']

package_data = \
{'': ['*'],
 'acpype': ['amber21-11_linux/*',
            'amber21-11_linux/bin/*',
            'amber21-11_linux/bin/wrapped_progs/*',
            'amber21-11_linux/dat/antechamber/*',
            'amber21-11_linux/dat/chamber/*',
            'amber21-11_linux/dat/leap/cmd/*',
            'amber21-11_linux/dat/leap/cmd/oldff/*',
            'amber21-11_linux/dat/leap/lib/*',
            'amber21-11_linux/dat/leap/lib/oldff/*',
            'amber21-11_linux/dat/leap/parm/*',
            'amber21-11_linux/dat/leap/prep/*',
            'amber21-11_linux/dat/leap/prep/oldff/*',
            'amber21-11_linux/dat/leap/prep/protonated_nucleic/*',
            'amber21-11_linux/lib/*',
            'amber21-11_os/*',
            'amber21-11_os/bin/*',
            'amber21-11_os/bin/wrapped_progs/*',
            'amber21-11_os/lib/*']}

entry_points = \
{'console_scripts': ['acpype = acpype.cli:init_main']}

setup_kwargs = {
    'name': 'acpype',
    'version': '2021.12.25',
    'description': 'ACPYPE - AnteChamber PYthon Parser interfacE',
    'long_description': '# ACPYPE\n\n[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg?style=plastic)](https://GitHub.com/alanwilter/acpype/graphs/commit-activity)<!-- [![Open Source Love](https://badges.frapsoft.com/os/v2/open-source.svg?v=103&style=plastic)](https://github.com/ellerbrock/open-source-badges/) -->\n[![GitHub](https://img.shields.io/github/license/alanwilter/acpype?style=plastic)](https://github.com/alanwilter/acpype)\n[![python](https://img.shields.io/badge/python-3.6%2E%2E%2E3.10-blue.svg?style=plastic&logo=python)](https://github.com/alanwilter/acpype)\n[![GitHub release (latest by date)](https://img.shields.io/github/v/release/alanwilter/acpype?display_name=tag&logo=github&style=plastic)](https://github.com/alanwilter/acpype)\n[![GitHub Release](https://img.shields.io/github/release-date/alanwilter/acpype?style=plastic&logo=github)](https://github.com/alanwilter/acpype)<!-- ![GitHub All Releases](https://img.shields.io/github/downloads/alanwilter/acpype/total?style=plastic) -->\n[![Docker Pulls](https://img.shields.io/docker/pulls/acpype/acpype?style=plastic&logo=docker)](https://hub.docker.com/r/acpype/acpype)\n[![Docker Image Size (tag)](https://img.shields.io/docker/image-size/acpype/acpype/latest?style=plastic&logo=docker)](https://hub.docker.com/r/acpype/acpype/tags)\n[![Conda Version](https://img.shields.io/conda/vn/conda-forge/acpype.svg?style=plastic&logo=conda-forge)](https://anaconda.org/conda-forge/acpype)\n[![Conda Downloads](https://img.shields.io/conda/dn/conda-forge/acpype.svg?style=plastic&logo=conda-forge)](https://anaconda.org/conda-forge/acpype/files)<!-- ![Conda](https://img.shields.io/conda/pn/conda-forge/acpype?logo=conda-forge&style=plastic) -->\n[![PyPI](https://img.shields.io/pypi/v/acpype?style=plastic&logo=pypi)](https://pypi.org/project/acpype/)\n[![PyPI - Downloads](https://img.shields.io/pypi/dm/acpype?style=plastic&logo=pypi)](https://pypi.org/project/acpype/#files)\n[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/alanwilter/acpype/check_acpype?style=plastic)](https://github.com/alanwilter/acpype)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white&style=plastic)](https://github.com/pre-commit/pre-commit)\n[![Commits since release](https://img.shields.io/github/commits-since/alanwilter/acpype/2021.12.24/master?style=plastic)](https://github.com/alanwilter/acpype/commits/master)\n[![Codecov](https://img.shields.io/codecov/c/github/alanwilter/acpype?style=plastic)](https://app.codecov.io/gh/alanwilter/acpype)\n\n<!-- [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5601736.svg)](https://doi.org/10.1186/1756-0500-5-367)\n![DOI](https://doi.org/10.1186/1756-0500-5-367) -->\n<!-- ![Scrutinizer code quality (GitHub/Bitbucket)](https://img.shields.io/scrutinizer/quality/g/alanwilter/acpype) -->\n<!-- ![Scrutinizer coverage (GitHub/BitBucket)](https://img.shields.io/scrutinizer/coverage/g/alanwilter/acpype) -->\n\n## AnteChamber PYthon Parser interfacE\n\nA tool based in **Python** to use **Antechamber** to generate topologies for chemical\ncompounds and to interface with others python applications like CCPN and ARIA.\n\n`acpype` is pronounced as _**ace + pipe**_\n\nTopologies files to be generated so far: CNS/XPLOR, GROMACS, CHARMM and AMBER.\n\n**NB:** Topologies generated by `acpype/Antechamber` are based on General Amber Force\nField (GAFF) and should be used only with compatible forcefields like AMBER and\nits variant.\n\nSeveral flavours of AMBER FF are ported already for GROMACS (see [ffamber](http://ffamber.cnsm.csulb.edu/)) as well as to XPLOR/CNS (see [`xplor-nih`](http://ambermd.org/xplor-nih.html)) and [CHARMM](https://www.charmm.org/).\n\nThis code is released under **[GNU General Public License V3](https://www.gnu.org/licenses/gpl-3.0.en.html)**.\n\n### **NO WARRANTY AT ALL**\n\nIt was inspired by:\n\n- `amb2gmx.pl` (Eric Sorin, David Mobley and John Chodera)\n  and depends on `Antechamber` and `OpenBabel`\n\n- [YASARA Autosmiles](http://www.yasara.org/autosmiles.htm) (Elmar Krieger)\n\n- `topolbuild` (Bruce Ray)\n\n- `xplo2d` (G.J. Kleywegt)\n\nFor Non-uniform 1-4 scale factor conversion (e.g. if using **GLYCAM06**), please cite:\n\n> BERNARDI, A., FALLER, R., REITH, D., and KIRSCHNER, K. N. ACPYPE update for\nnonuniform 1–4 scale factors: Conversion of the GLYCAM06 force field from AMBER\nto GROMACS. SoftwareX 10 (2019), 100241. doi: [10.1016/j.softx.2019.100241](https://doi.org/10.1016/j.softx.2019.100241)\n\nFor `Antechamber`, please cite:\n>\n> 1. WANG, J., WANG, W., KOLLMAN, P. A., and CASE, D. A. Automatic atom type and\n     bond type perception in molecular mechanical calculations. Journal of Molecular\n     Graphics and Modelling 25, 2 (2006), 247–260. doi: [10.1016/j.jmgm.2005.12.005](https://doi.org/10.1016/j.jmgm.2005.12.005)\n> 2. WANG, J., WOLF, R. M., CALDWELL, J. W., KOLLMAN, P. A., and CASE, D. A.\n     Development and testing of a General Amber Force Field. Journal of Computational\n     Chemistry 25, 9 (2004), 1157–1174. doi: [10.1002/jcc.20035](https://doi.org/10.1002/jcc.20035)\n\nIf you use this code, I am glad if you cite:\n\n> SOUSA DA SILVA, A. W. & VRANKEN, W. F.\nACPYPE - AnteChamber PYthon Parser interfacE.\nBMC Research Notes 5 (2012), 367 doi: [10.1186/1756-0500-5-367](https://doi.org/10.1186/1756-0500-5-367)\n\nand (optionally)\n\n> BATISTA, P. R.; WILTER, A.; DURHAM, E. H. A. B. & PASCUTTI, P. G. Molecular\nDynamics Simulations Applied to the Study of Subtypes of HIV-1 Protease.\nCell Biochemistry and Biophysics 44 (2006), 395-404. doi: [10.1385/CBB:44:3:395](https://doi.org/10.1385/CBB:44:3:395)\n\nAlan Silva, D.Sc.\n\nalanwilter _at_ gmail _dot_ com\n\n#### How To Use ACPYPE\n\n##### Introduction\n\nWe now have an up to date *webservice* at **[Bio2Byte](http://bio2byte.be/acpype/)** (but it **does not** have the `amb2gmx` functionality).\n\nTo run `acpype`, locally, with its all functionalities, you need **ANTECHAMBER** from package\n[AmberTools](http://ambermd.org/) and\n[Open Babel](http://openbabel.org/wiki/Main_Page) if your input files are of PDB\nformat.\n\nHowever, if one wants `acpype` just to emulate *amb2gmx.pl*, one needs nothing\nat all but *[Python](http://www.python.org)*.\n\nThere are several ways of obtaining `acpype`:\n\n1. Via **[CONDA](https://anaconda.org/search?q=acpype)**:\n\n   *(It should be wholesome, fully functional, all batteries included)*\n\n   ```bash\n   conda install -c conda-forge acpype\n   ```\n\n2. Via **[PyPI](https://pypi.org/project/acpype/)**:\n\n   *(Make sure you  have `AmberTools` and, optionally but highly recommended, `OpenBabel` )*\n\n   ```bash\n   # You can use conda to get the needed 3rd parties for example\n   conda create -n acpype --channel conda-forge ambertools openbabel\n\n   # Or for Ubuntu 20:\n   apt-get install -y openbabel python3-openbabel libarpack++2-dev libgfortran5\n\n   pip install acpype\n\n   # or if you feel daring\n\n   pip install git+https://github.com/alanwilter/acpype.git\n   ```\n\n   **NB:** If using OpenBabel python module, it\'s really ***CRITICAL*** to have it installed in the same `Python` environment of `acpype`.\n\n3. By downloading it via `git`:\n\n   *(Make sure you  have `AmberTools` and, optionally but highly recommended, `OpenBabel` )*\n\n   ```bash\n   # You can use conda to get the needed 3rd parties for example\n   conda create -n acpype --channel conda-forge ambertools openbabel\n\n   # Or for Ubuntu 20:\n   apt-get install -y openbabel python3-openbabel libarpack++2-dev libgfortran5\n\n   git clone https://github.com/alanwilter/acpype.git\n   ```\n\n   **NB:** Using this mode, CHARMM topology files will not be generated.\n\n4. Via **[Docker](https://hub.docker.com/repository/docker/acpype/acpype/)**:\n\n   *(It should be wholesome, fully functional, all batteries included)*\n\n   If you have Docker installed, you can run `acpype_docker.sh` by:\n\n   NOTE: first time may take some time as it pulls the `acpype` docker image.\n\n   On Linux / MacOS:\n\n   ```bash\n   ln -fsv "$PWD/acpype_docker.sh" /usr/local/bin/acpype_docker\n\n   ```\n\n   On Windows:\n   Using Command Prompt:\n\n    In the directory where the `acpype_docker.bat` file is found:\n\n   ```bash\n   setx /M path "%path%;%cd%"\n   ```\n\n   Commands:\n\n   ```bash\n   acpype_docker -i CCCC\n\n   acpype_docker -i tests/DDD.pdb -c gas\n   ```\n\n**NB:**\n\n- By installing via `conda` or using via `docker` you get `AmberTools v.21.11` and `OpenBabel v3.1.1`. Our `AmberTools v.21.11` is a stripped version from the original containing only the necessary binaries and libraries and comes with the `charmmgen` binary from `AmberTools17` in order to generate CHARMM topologies.\n- By installing via `pip` you get `AmberTools` (as described above) embedded. However, the included binaries may not work in your system (library dependencies issues) and with only provide binaries for Linux (Ubuntu20) and macOS (Intel).\n\n##### To Test, if doing via `git`\n\nAt folder `acpype/`, type:\n\n```bash\n./run_acpype.py -i tests/FFF.pdb\n```\n\nIt\'ll create a folder called *FFF.acpype*, and inside it one may find topology\nfiles for GROMACS and CNS/XPLOR.\n\nor using a molecule in [SMILES](https://archive.epa.gov/med/med_archive_03/web/html/smiles.html) notation:\n\n```bash\n./run_acpype.py -i CCCC # smiles for C4H6 1,3-Butadiene compound\n```\n\nIt\'ll create a folder called *smiles_molecule.acpype*.\n\nTo get help and more information, type:\n\n```bash\n./run_acpype.py -h\n```\n\n##### To Install\n\nAt folder `acpype/`, type:\n\n```bash\n  ln -fsv "$PWD/run_acpype.py" /usr/local/bin/acpype\n```\n\nThen re-login or start another shell session.\n\nIf via `conda` or `pip`, `acpype` should be in your `$PATH`.\n\n##### To Verify with GMX\n\nGROMACS < v.5.0\n\n```bash\ncd FFF.acpype/\ngrompp -c FFF_GMX.gro -p FFF_GMX.top -f em.mdp -o em.tpr\nmdrun -v -deffnm em\n# And if you have VMD\nvmd em.gro em.trr\n```\n\nGROMACS > v.5.0\n\n```bash\ncd FFF.acpype/\ngmx grompp -c FFF_GMX.gro -p FFF_GMX.top -f em.mdp -o em.tpr\ngmx mdrun -v -deffnm em\n# And if you have VMD\nvmd em.gro em.trr\n```\n\n##### For MD, do\n\nGROMACS < v.5.0\n\n```bash\ngrompp -c em.gro -p FFF_GMX.top -f md.mdp -o md.tpr\nmdrun -v -deffnm md\nvmd md.gro md.trr\n```\n\nGROMACS > v.5.0\n\n```bash\ngmx grompp -c em.gro -p FFF_GMX.top -f md.mdp -o md.tpr\ngmx mdrun -v -deffnm md\nvmd md.gro md.trr\n```\n\n#### To Emulate `amb2gmx.pl`\n\nFor any given *prmtop* and *inpcrd* files (outputs from AMBER LEaP), type:\n\n```bash\nacpype -p FFF_AC.prmtop -x FFF_AC.inpcrd\n```\n\nThe output files `FFF_GMX.gro` and `FFF_GMX.top` will be generated inside folder *FFF_GMX.amb2gmx*\n\n#### To Verify with CNS/XPLOR\n\nAt folder *FFF.acpype*, type:\n\n```bash\ncns < FFF_CNS.inp\n```\n\n#### To Verify with NAMD\n\n- see [TutorialNAMD](../../wiki/Tutorial-NAMD)\n',
    'author': 'Alan Silva',
    'author_email': 'alanwilter@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://alanwilter.github.io/acpype/',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.6.2,<4.0',
}


setup(**setup_kwargs)
