# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['horus', 'horus.compiler']

package_data = \
{'': ['*'], 'horus': ['scripts/*']}

install_requires = \
['cairo-lang==0.10.1',
 'eth-utils>=1.2.0,<2.0.0',
 'lark>=1.1.4,<2.0.0',
 'marshmallow-dataclass>=7.1.0,<8.5.4',
 'marshmallow>=3.15.0,<4.0.0',
 'z3-solver>=4.8.15,<5.0.0']

entry_points = \
{'console_scripts': ['horus-compile = horus.compiler.horus_compile:run']}

setup_kwargs = {
    'name': 'horus-compile',
    'version': '0.0.6.12',
    'description': 'Use formally verified annotations in your Cairo code',
    'long_description': 'This is the compiler for the Horus formal verification tool. See the [main\nrepository](https://github.com/NethermindEth/horus-checker) for full\ndocumentation.\n\n## Disclaimer\nKindly note, Horus is a tool consisting of two separate components: Horus-Check, released under the AGPLv3 license, and Horus-Compile, released under the Cairo Toolkit License. When "Horus" is referenced, the reference is to the two components jointly.\n\nHorus is currently in the alpha stage and no guarantee is being given as to the accuracy and/or completeness of any of the outputs the tool may generate. The tool is provided on an \'as is\' basis, without warranties or conditions of any kind, either express or implied, including without limitation as to the outputs of the verification process and the security of any system verified using Horus. As per the relevant licenses, to the fullest extent permitted by the law, Nethermind disclaims any liability in connection with your use of Horus and/or any of its outputs.\n\nPlease also note that the terminology used by Horus, including but not limited to words such as \'guarantee\', should be interpreted strictly within the remit of formal verification terminology. These words are not intended to, and shall not be construed as having legal significance of any kind.\n\nFor the avoidance of doubt, the outputs generated by Horus and/or your usage thereof shall not be considered or relied upon as any form of financial, investment, tax, legal, regulatory, or other advice.\n\nHorus-Check is licensed under AGPLv3 (Copyright (C) 2023 Nethermind). For more information on the dependencies, please see [here](https://github.com/NethermindEth/horus-checker/blob/master/LICENSE).\n\nHorus-Compile is licensed under the Cairo Toolkit License (Copyright (C) 2023 Nethermind), pursuant to an exception granted to Nethermind by Starkware Industries Ltd. For more information on the dependencies please see [here](https://github.com/NethermindEth/horus-compile/blob/master/LICENSE).',
    'author': 'Nethermind',
    'author_email': 'hello@nethermind.io',
    'maintainer': 'Ganesh Tiwari',
    'maintainer_email': 'ganesh@nethermind.io',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.10',
}


setup(**setup_kwargs)
