# coding: utf-8

"""
    IONOS DBaaS MongoDB REST API

    With IONOS Cloud Database as a Service, you have the ability to quickly set up and manage a MongoDB database. You can also delete clusters, manage backups and users via the API.  MongoDB is an open source, cross-platform, document-oriented database program. Classified as a NoSQL database program, it uses JSON-like documents with optional schemas.  The MongoDB API allows you to create additional database clusters or modify existing ones. Both tools, the Data Center Designer (DCD) and the API use the same concepts consistently and are well suited for smooth and intuitive use.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud_dbaas_mongo.configuration import Configuration


class SnapshotProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'version': 'str',

        'size': 'int',

        'creation_time': 'datetime',
    }

    attribute_map = {

        'version': 'version',

        'size': 'size',

        'creation_time': 'creationTime',
    }

    def __init__(self, version=None, size=None, creation_time=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._version = None
        self._size = None
        self._creation_time = None
        self.discriminator = None

        if version is not None:
            self.version = version
        if size is not None:
            self.size = size
        if creation_time is not None:
            self.creation_time = creation_time


    @property
    def version(self):
        """Gets the version of this SnapshotProperties.  # noqa: E501

        The MongoDB version this backup was created from.  # noqa: E501

        :return: The version of this SnapshotProperties.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this SnapshotProperties.

        The MongoDB version this backup was created from.  # noqa: E501

        :param version: The version of this SnapshotProperties.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def size(self):
        """Gets the size of this SnapshotProperties.  # noqa: E501

        The size of the snapshot in Mebibytes.  # noqa: E501

        :return: The size of this SnapshotProperties.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this SnapshotProperties.

        The size of the snapshot in Mebibytes.  # noqa: E501

        :param size: The size of this SnapshotProperties.  # noqa: E501
        :type size: int
        """

        self._size = size

    @property
    def creation_time(self):
        """Gets the creation_time of this SnapshotProperties.  # noqa: E501

        The date the resource was created.  # noqa: E501

        :return: The creation_time of this SnapshotProperties.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this SnapshotProperties.

        The date the resource was created.  # noqa: E501

        :param creation_time: The creation_time of this SnapshotProperties.  # noqa: E501
        :type creation_time: datetime
        """

        self._creation_time = creation_time
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotProperties):
            return True

        return self.to_dict() != other.to_dict()
