"""
This file was autogenerated by genproperties.py

LINSTOR - management of distributed storage/DRBD9 resources
Copyright (C) 2017 - 2021  LINBIT HA-Solutions GmbH
Author: Rene Peinthor, Gabor Hernadi

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
import linstor.sharedconsts as consts
properties = \
{   'controller': [   {   'info': 'Range for auto-allocation of resource TCP '
                                  'ports',
                          'key': consts.KEY_TCP_PORT_AUTO_RANGE,
                          'type': 'regex',
                          'value': '[0-9]+-[0-9]+'},
                      {   'info': 'Range for auto-allocation of volume minor '
                                  'numbers',
                          'key': consts.KEY_MINOR_NR_AUTO_RANGE,
                          'type': 'regex',
                          'value': '[0-9]+-[0-9]+'},
                      {   'info': 'DRBD peer slots to allocate for newly '
                                  'created resources (default 7), the number '
                                  'of peer slots cannot be changed once the '
                                  'resource is created, so allow sufficient '
                                  'slots to increase redundancy in the future',
                          'key': consts.KEY_PEER_SLOTS_NEW_RESOURCE,
                          'max': 31,
                          'min': 1,
                          'type': 'range'},
                      {   'info': 'Enable dmstats on lvm create',
                          'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_DMSTATS,
                          'type': 'boolean_true_false'},
                      {   'info': 'Disable Prometheus /metrics on HTTP, if '
                                  'HTTPS is enabled',
                          'internal': False,
                          'key': consts.NAMESPC_REST + '/' + consts.KEY_DISABLE_HTTP_METRICS,
                          'type': 'boolean_true_false'},
                      {   'default': 60,
                          'info': 'Time a node can be offline before it is '
                                  'declared EVICTED in minutes',
                          'internal': False,
                          'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_AUTO_EVICT_AFTER_TIME,
                          'type': 'long'},
                      {   'default': 34,
                          'info': 'Percentage(0-100) of nodes that can '
                                  'disconnect at the same time without the '
                                  'controller stopping the max_offline_time '
                                  'timer',
                          'internal': False,
                          'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_AUTO_EVICT_MAX_DISCONNECTED_NODES,
                          'max': 100,
                          'min': 0,
                          'type': 'range'},
                      {   'default': 'The place count set for the resource '
                                     'group',
                          'info': 'The minimum amount of replicas that should '
                                  'be present for a resource at all times.',
                          'internal': False,
                          'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_AUTO_EVICT_MIN_REPLICA_COUNT,
                          'type': 'long'},
                      {   'default': 'true',
                          'info': 'If set to true on a node, it cannot be '
                                  'evicted anymore',
                          'internal': False,
                          'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_AUTO_EVICT_ALLOW_EVICTION,
                          'type': 'boolean_true_false'},
                      {   'default': 'rdma',
                          'info': 'NVMe transportation type',
                          'internal': False,
                          'key': consts.NAMESPC_NVME + '/' + consts.KEY_TR_TYPE,
                          'type': 'symbol',
                          'values': ['rdma', 'tcp']},
                      {   'info': 'NVMe port',
                          'internal': False,
                          'key': consts.NAMESPC_NVME + '/' + consts.KEY_PORT,
                          'max': 65535,
                          'min': 1,
                          'type': 'range'},
                      {   'info': 'Preferred network interface to use',
                          'internal': False,
                          'key': consts.NAMESPC_NVME + '/' + consts.KEY_PREF_NIC,
                          'type': 'regex',
                          'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                      {   'internal': True,
                          'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_WAIT_TIMEOUT_AFTER_CREATE,
                          'type': 'regex',
                          'value': '[0-9]+'},
                      {   'info': 'Sets the '
                                  '/sys/fs/cgroup/blkio/blkio.throttle.read_bps_device',
                          'internal': False,
                          'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ,
                          'type': 'long'},
                      {   'info': 'Sets the '
                                  '/sys/fs/cgroup/blkio/blkio.throttle.write_bps_device',
                          'internal': False,
                          'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE,
                          'type': 'long'},
                      {   'info': 'Sets the '
                                  '/sys/fs/cgroup/blkio/blkio.throttle.read_iops_device',
                          'internal': False,
                          'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ_IOPS,
                          'type': 'long'},
                      {   'info': 'Sets the '
                                  '/sys/fs/cgroup/blkio/blkio.throttle.write_iops_device',
                          'internal': False,
                          'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE_IOPS,
                          'type': 'long'},
                      {   'info': 'Search domain node names, if no FQDN is '
                                  'given.',
                          'internal': False,
                          'key': consts.KEY_SEARCH_DOMAIN,
                          'type': 'string'},
                      {   'info': 'Wait timeout for an external command in '
                                  'milliseconds',
                          'internal': False,
                          'key': consts.KEY_EXT_CMD_WAIT_TO,
                          'type': 'long'},
                      {   'info': "Enables automatic setting of the 'quorum' "
                                  "and 'on-no-quorum' property",
                          'internal': False,
                          'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_QUORUM,
                          'type': 'symbol',
                          'values': ['io-error', 'suspend-io', 'disabled']},
                      {   'info': 'Enables automatic management (creation and '
                                  'deletion) of tie breaking resource',
                          'internal': False,
                          'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_ADD_QUORUM_TIEBREAKER,
                          'type': 'boolean_true_false'},
                      {   'info': 'Makes a resource diskful if it was '
                                  'continuously diskless primary for X minutes',
                          'internal': False,
                          'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_DISKFUL,
                          'type': 'long'},
                      {   'info': 'Allows this resource to be cleaned up after '
                                  'toggle-disk + resync is finished',
                          'internal': False,
                          'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_DISKFUL_ALLOW_CLEANUP,
                          'type': 'boolean_true_false'},
                      {   'info': 'If set to true it will disable automatic '
                                  'setting of DRBD verify algorithm',
                          'internal': False,
                          'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_DISABLE_AUTO_VERIFY_ALGO,
                          'type': 'boolean_true_false'},
                      {   'info': 'A list of verify algorithms allowed by '
                                  'user, semicolon separated',
                          'internal': False,
                          'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_VERIFY_ALGO_ALLOWED_USER,
                          'type': 'string'},
                      {   'info': 'Linstor storage pool name for writecache',
                          'key': consts.NAMESPC_WRITECACHE + '/' + consts.KEY_WRITECACHE_POOL_NAME,
                          'type': 'regex',
                          'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                      {   'info': 'Size of the writecache in % (0-100) or KiB '
                                  'otherwise',
                          'key': consts.NAMESPC_WRITECACHE + '/' + consts.KEY_WRITECACHE_SIZE,
                          'type': 'regex',
                          'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                      {   'default': '0',
                          'info': 'offset from the start of cache device in '
                                  '512-byte sectors',
                          'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_START_SECTOR,
                          'type': 'long'},
                      {   'default': '50',
                          'info': 'start writeback when the number of used '
                                  'blocks reach this watermark',
                          'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_HIGH_WATERMARK,
                          'type': 'long'},
                      {   'default': '45',
                          'info': 'stop writeback when the number of used '
                                  'blocks drops below this watermark',
                          'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_LOW_WATERMARK,
                          'type': 'long'},
                      {   'default': 'unlimited',
                          'info': 'limit the number of blocks that are in '
                                  'flight during writeback. Setting this value '
                                  'reduces writeback throughput, but it may '
                                  'improve latency of read requests',
                          'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_WRITEBACK_JOBS,
                          'type': 'long'},
                      {   'default': '64 for pmem, 65536 for ssd',
                          'info': 'when the application writes this amount of '
                                  'blocks without issuing the FLUSH request, '
                                  'the blocks are automatically committed',
                          'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_AUTOCOMMIT_BLOCKS,
                          'type': 'long'},
                      {   'default': '1000',
                          'info': 'autocommit time in milliseconds. The data '
                                  'is automatically committed if this time '
                                  'passes and no FLUSH request is received',
                          'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_AUTOCOMMIT_TIME,
                          'type': 'long'},
                      {   'default': 'On',
                          'info': '"On" results in "fua" as argument, whereas '
                                  'the value "Off" results in "nofua" argument',
                          'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_FUA,
                          'type': 'symbol',
                          'values': ['On', 'Off']},
                      {   'info': 'Additional arguments passed through',
                          'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_ADDITIONAL,
                          'type': 'string'},
                      {   'default': 'writethrough',
                          'info': 'Operation mode',
                          'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_OPERATING_MODE,
                          'type': 'symbol',
                          'values': [   'writeback',
                                        'writethrough',
                                        'passthrough']},
                      {   'info': 'Name of the storage pool used for the cache '
                                  'metadata. If not specified, this will '
                                  'default to the CachePool property',
                          'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_META_POOL_NAME,
                          'type': 'regex',
                          'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                      {   'default': '12288',
                          'info': 'Size of the cache in % (0-100) or KiB '
                                  'otherwise.',
                          'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_META_SIZE,
                          'type': 'regex',
                          'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                      {   'info': 'Name of the storage pool used for the cache '
                                  'cache device',
                          'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_CACHE_POOL_NAME,
                          'type': 'regex',
                          'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                      {   'default': '5%',
                          'info': 'Size of the cache in % (0-100) or KiB '
                                  'otherwise.',
                          'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_CACHE_SIZE,
                          'type': 'regex',
                          'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                      {   'default': '4096',
                          'info': 'Block size',
                          'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_BLOCK_SIZE,
                          'type': 'long'},
                      {   'default': 'smq',
                          'info': 'Replacement policy',
                          'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_POLICY,
                          'type': 'symbol',
                          'values': ['mq', 'smq', 'cleaner']},
                      {   'info': 'Additional parameters added to every '
                                  "'lvcreate ... ' command",
                          'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_LVCREATE_OPTIONS,
                          'type': 'regex',
                          'value': '.*'},
                      {   'info': "Additional parameters added to every 'zfs "
                                  "create ... ' command",
                          'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_ZFS_CREATE_OPTIONS,
                          'type': 'regex',
                          'value': '.*'},
                      {   'info': 'Openflex API host name',
                          'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_API_HOST,
                          'type': 'regex',
                          'value': '.+'},
                      {   'info': 'Openflex API port',
                          'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_API_PORT,
                          'type': 'regex',
                          'value': '[0-9]+'},
                      {   'info': 'Openflex user name',
                          'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_USER_NAME,
                          'type': 'regex',
                          'value': '.+'},
                      {   'info': 'Openflex password',
                          'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_USER_PW,
                          'type': 'regex',
                          'value': '.+'},
                      {   'info': 'Delay in milliseconds linstor waits between '
                                  'fetching the job status',
                          'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_JOB_WAIT_DELAY,
                          'type': 'regex',
                          'value': '[0-9]+'},
                      {   'info': 'Maximum retries with wait delay until '
                                  'openflex fails',
                          'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_JOB_WAIT_MAX_COUNT,
                          'type': 'regex',
                          'value': '[0-9]+'},
                      {   'info': 'linear: Volumes are created from Disk '
                                  'Groups (vdisks), virtual: Volumes are '
                                  'created from Pools which is a set of Disk '
                                  'Groups (vdisks)',
                          'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_VLM_TYPE,
                          'type': 'symbol',
                          'values': ['linear', 'virtual']},
                      {   'info': 'Any additional parameters appended to '
                                  '/create/volume/pool/${poolName}/size/${size}KiB/${vlmName}',
                          'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_CREATE_VOLUME_OPTIONS,
                          'type': 'string'},
                      {   'default': '1.0',
                          'info': "Weight of 'MaxFreeSpace' "
                                  'autoplacer-strategy',
                          'key': consts.NAMESPC_AUTOPLACER_WEIGHTS + '/' + consts.KEY_AUTOPLACE_STRAT_WEIGHT_MAX_FREESPACE,
                          'type': 'regex',
                          'value': '^[0-9]+([.][0-9]+)?'},
                      {   'default': '0.0',
                          'info': "Weight of 'MinReservedSpace' "
                                  'autoplacer-strategy',
                          'key': consts.NAMESPC_AUTOPLACER_WEIGHTS + '/' + consts.KEY_AUTOPLACE_STRAT_WEIGHT_MIN_RESERVED_SPACE,
                          'type': 'regex',
                          'value': '^[0-9]+([.][0-9]+)?'},
                      {   'default': '0.0',
                          'info': "Weight of 'MinRscCount' autoplacer-strategy",
                          'key': consts.NAMESPC_AUTOPLACER_WEIGHTS + '/' + consts.KEY_AUTOPLACE_STRAT_WEIGHT_MIN_RSC_COUNT,
                          'type': 'regex',
                          'value': '^[0-9]+([.][0-9]+)?'},
                      {   'default': '0.0',
                          'info': "Weight of 'MaxThroughput' "
                                  'autoplacer-strategy',
                          'key': consts.NAMESPC_AUTOPLACER_WEIGHTS + '/' + consts.KEY_AUTOPLACE_MAX_THROUGHPUT,
                          'type': 'regex',
                          'value': '^[0-9]+([.][0-9]+)?'},
                      {   'info': 'Filename of the preselection script. File '
                                  'must be in /etc/linstor/selector/',
                          'key': consts.NAMESPC_AUTOPLACER + '/' + consts.KEY_AUTOPLACE_PRE_SELECT_FILE_NAME,
                          'type': 'string'},
                      {   'default': '5000',
                          'info': 'Timeout in ms Linstor waits for the script '
                                  'to run.',
                          'key': consts.NAMESPC_AUTOPLACER + '/' + consts.KEY_AUTOPLACE_PRE_SELECT_SCRIPT_TIMEOUT,
                          'type': 'long'},
                      {   'info': 'The maximum throughput the given storage '
                                  'pool is capable of.',
                          'key': consts.NAMESPC_AUTOPLACER + '/' + consts.KEY_AUTOPLACE_MAX_THROUGHPUT,
                          'type': 'long'},
                      {   'default': 'false',
                          'internal': True,
                          'key': consts.NAMESPC_DRBD_PROXY + '/' + consts.KEY_DRBD_PROXY_AUTO_ENABLE,
                          'type': 'boolean_true_false'},
                      {   'internal': True,
                          'key': consts.KEY_SITE,
                          'type': 'string'},
                      {   'default': '180',
                          'info': 'Interval for space cache background updates '
                                  'in seconds',
                          'key': consts.KEY_UPDATE_CACHE_INTERVAL,
                          'type': 'long'},
                      {   'info': 'Range for allocation of snapshot shipping '
                                  'TCP ports',
                          'key': consts.NAMESPC_SNAPSHOT_SHIPPING + '/' + consts.KEY_TCP_PORT_RANGE,
                          'type': 'regex',
                          'value': '[0-9]+-[0-9]+'},
                      {   'drbd_option_name': 'on-io-error',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/on-io-error",
                          'type': 'symbol',
                          'values': [   'pass_on',
                                        'call-local-io-error',
                                        'detach']},
                      {   'default': False,
                          'drbd_option_name': 'disk-barrier',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/disk-barrier",
                          'type': 'boolean'},
                      {   'default': True,
                          'drbd_option_name': 'disk-flushes',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/disk-flushes",
                          'type': 'boolean'},
                      {   'default': True,
                          'drbd_option_name': 'disk-drain',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/disk-drain",
                          'type': 'boolean'},
                      {   'default': True,
                          'drbd_option_name': 'md-flushes',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/md-flushes",
                          'type': 'boolean'},
                      {   'drbd_option_name': 'resync-after',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/resync-after",
                          'type': 'string'},
                      {   'default': 1237,
                          'drbd_option_name': 'al-extents',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/al-extents",
                          'max': 65534,
                          'min': 67,
                          'type': 'range',
                          'unit_prefix': '1'},
                      {   'default': True,
                          'drbd_option_name': 'al-updates',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/al-updates",
                          'type': 'boolean'},
                      {   'default': True,
                          'drbd_option_name': 'discard-zeroes-if-aligned',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/discard-zeroes-if-aligned",
                          'type': 'boolean'},
                      {   'default': False,
                          'drbd_option_name': 'disable-write-same',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/disable-write-same",
                          'type': 'boolean'},
                      {   'default': 0,
                          'drbd_option_name': 'disk-timeout',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/disk-timeout",
                          'max': 6000,
                          'min': 0,
                          'type': 'range',
                          'unit': '1/10 seconds',
                          'unit_prefix': '1'},
                      {   'drbd_option_name': 'read-balancing',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/read-balancing",
                          'type': 'symbol',
                          'values': [   'prefer-local',
                                        'prefer-remote',
                                        'round-robin',
                                        'least-pending',
                                        'when-congested-remote',
                                        '32K-striping',
                                        '64K-striping',
                                        '128K-striping',
                                        '256K-striping',
                                        '512K-striping',
                                        '1M-striping']},
                      {   'default': 0,
                          'drbd_option_name': 'rs-discard-granularity',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/Disk/rs-discard-granularity",
                          'max': 1048576,
                          'min': 0,
                          'type': 'range',
                          'unit': 'bytes',
                          'unit_prefix': '1'},
                      {   'default': 250,
                          'drbd_option_name': 'resync-rate',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/PeerDevice/resync-rate",
                          'max': 8388608,
                          'min': 1,
                          'type': 'range',
                          'unit': 'bytes/second',
                          'unit_prefix': 'k'},
                      {   'default': 20,
                          'drbd_option_name': 'c-plan-ahead',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/PeerDevice/c-plan-ahead",
                          'max': 300,
                          'min': 0,
                          'type': 'range',
                          'unit': '1/10 seconds',
                          'unit_prefix': '1'},
                      {   'default': 10,
                          'drbd_option_name': 'c-delay-target',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/PeerDevice/c-delay-target",
                          'max': 100,
                          'min': 1,
                          'type': 'range',
                          'unit': '1/10 seconds',
                          'unit_prefix': '1'},
                      {   'default': 100,
                          'drbd_option_name': 'c-fill-target',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/PeerDevice/c-fill-target",
                          'max': 1048576,
                          'min': 0,
                          'type': 'range',
                          'unit': 'bytes',
                          'unit_prefix': 's'},
                      {   'default': 102400,
                          'drbd_option_name': 'c-max-rate',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/PeerDevice/c-max-rate",
                          'max': 4194304,
                          'min': 0,
                          'type': 'range',
                          'unit': 'bytes/second',
                          'unit_prefix': 'k'},
                      {   'default': 250,
                          'drbd_option_name': 'c-min-rate',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/PeerDevice/c-min-rate",
                          'max': 4194304,
                          'min': 0,
                          'type': 'range',
                          'unit': 'bytes/second',
                          'unit_prefix': 'k'},
                      {   'default': True,
                          'drbd_option_name': 'bitmap',
                          'drbd_res_file_section': 'disk',
                          'internal': True,
                          'key': "DrbdOptions/PeerDevice/bitmap",
                          'type': 'boolean'},
                      {   'drbd_option_name': 'cpu-mask',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/cpu-mask",
                          'type': 'string'},
                      {   'drbd_option_name': 'on-no-data-accessible',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/on-no-data-accessible",
                          'type': 'symbol',
                          'values': ['io-error', 'suspend-io']},
                      {   'default': True,
                          'drbd_option_name': 'auto-promote',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/auto-promote",
                          'type': 'boolean'},
                      {   'default': 4096,
                          'drbd_option_name': 'peer-ack-window',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/peer-ack-window",
                          'max': 204800,
                          'min': 2048,
                          'type': 'range',
                          'unit': 'bytes',
                          'unit_prefix': 's'},
                      {   'default': 100,
                          'drbd_option_name': 'peer-ack-delay',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/peer-ack-delay",
                          'max': 10000,
                          'min': 1,
                          'type': 'range',
                          'unit': 'milliseconds',
                          'unit_prefix': '1'},
                      {   'default': 300,
                          'drbd_option_name': 'twopc-timeout',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/twopc-timeout",
                          'max': 600,
                          'min': 50,
                          'type': 'range',
                          'unit': '1/10 seconds',
                          'unit_prefix': '1'},
                      {   'default': 1,
                          'drbd_option_name': 'twopc-retry-timeout',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/twopc-retry-timeout",
                          'max': 50,
                          'min': 1,
                          'type': 'range',
                          'unit': '1/10 seconds',
                          'unit_prefix': '1'},
                      {   'default': 20,
                          'drbd_option_name': 'auto-promote-timeout',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/auto-promote-timeout",
                          'max': 600,
                          'min': 0,
                          'type': 'range',
                          'unit': '1/10 seconds',
                          'unit_prefix': '1'},
                      {   'default': 8000,
                          'drbd_option_name': 'max-io-depth',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/max-io-depth",
                          'max': 4294967295,
                          'min': 4,
                          'type': 'range',
                          'unit_prefix': '1'},
                      {   'drbd_option_name': 'quorum',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/quorum",
                          'max': '32',
                          'min': '1',
                          'type': 'numeric-or-symbol',
                          'values': ['off', 'majority', 'all']},
                      {   'drbd_option_name': 'on-no-quorum',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/on-no-quorum",
                          'type': 'symbol',
                          'values': ['io-error', 'suspend-io']},
                      {   'drbd_option_name': 'quorum-minimum-redundancy',
                          'drbd_res_file_section': 'options',
                          'internal': True,
                          'key': "DrbdOptions/Resource/quorum-minimum-redundancy",
                          'max': '32',
                          'min': '1',
                          'type': 'numeric-or-symbol',
                          'values': ['off', 'majority', 'all']},
                      {   'drbd_option_name': 'transport',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/transport",
                          'type': 'string'},
                      {   'drbd_option_name': 'protocol',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/protocol",
                          'type': 'symbol',
                          'values': ['A', 'B', 'C']},
                      {   'default': 60,
                          'drbd_option_name': 'timeout',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/timeout",
                          'max': 600,
                          'min': 1,
                          'type': 'range',
                          'unit': '1/10 seconds',
                          'unit_prefix': '1'},
                      {   'default': 2048,
                          'drbd_option_name': 'max-epoch-size',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/max-epoch-size",
                          'max': 20000,
                          'min': 1,
                          'type': 'range',
                          'unit_prefix': '1'},
                      {   'default': 10,
                          'drbd_option_name': 'connect-int',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/connect-int",
                          'max': 120,
                          'min': 1,
                          'type': 'range',
                          'unit': 'seconds',
                          'unit_prefix': '1'},
                      {   'default': 10,
                          'drbd_option_name': 'ping-int',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/ping-int",
                          'max': 120,
                          'min': 1,
                          'type': 'range',
                          'unit': 'seconds',
                          'unit_prefix': '1'},
                      {   'default': 0,
                          'drbd_option_name': 'sndbuf-size',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/sndbuf-size",
                          'max': 10485760,
                          'min': 0,
                          'type': 'range',
                          'unit': 'bytes',
                          'unit_prefix': '1'},
                      {   'default': 0,
                          'drbd_option_name': 'rcvbuf-size',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/rcvbuf-size",
                          'max': 10485760,
                          'min': 0,
                          'type': 'range',
                          'unit': 'bytes',
                          'unit_prefix': '1'},
                      {   'default': 7,
                          'drbd_option_name': 'ko-count',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/ko-count",
                          'max': 200,
                          'min': 0,
                          'type': 'range',
                          'unit_prefix': '1'},
                      {   'default': False,
                          'drbd_option_name': 'allow-two-primaries',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/allow-two-primaries",
                          'type': 'boolean'},
                      {   'drbd_option_name': 'cram-hmac-alg',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/cram-hmac-alg",
                          'type': 'string'},
                      {   'drbd_option_name': 'shared-secret',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/shared-secret",
                          'type': 'string'},
                      {   'drbd_option_name': 'after-sb-0pri',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/after-sb-0pri",
                          'type': 'symbol',
                          'values': [   'disconnect',
                                        'discard-younger-primary',
                                        'discard-older-primary',
                                        'discard-zero-changes',
                                        'discard-least-changes',
                                        'discard-local',
                                        'discard-remote']},
                      {   'drbd_option_name': 'after-sb-1pri',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/after-sb-1pri",
                          'type': 'symbol',
                          'values': [   'disconnect',
                                        'consensus',
                                        'discard-secondary',
                                        'call-pri-lost-after-sb',
                                        'violently-as0p']},
                      {   'drbd_option_name': 'after-sb-2pri',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/after-sb-2pri",
                          'type': 'symbol',
                          'values': [   'disconnect',
                                        'call-pri-lost-after-sb',
                                        'violently-as0p']},
                      {   'default': False,
                          'drbd_option_name': 'always-asbp',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/always-asbp",
                          'type': 'boolean'},
                      {   'drbd_option_name': 'rr-conflict',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/rr-conflict",
                          'type': 'symbol',
                          'values': [   'disconnect',
                                        'call-pri-lost',
                                        'violently',
                                        'retry-connect']},
                      {   'default': 5,
                          'drbd_option_name': 'ping-timeout',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/ping-timeout",
                          'max': 300,
                          'min': 1,
                          'type': 'range',
                          'unit': '1/10 seconds',
                          'unit_prefix': '1'},
                      {   'drbd_option_name': 'data-integrity-alg',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/data-integrity-alg",
                          'type': 'string'},
                      {   'default': True,
                          'drbd_option_name': 'tcp-cork',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/tcp-cork",
                          'type': 'boolean'},
                      {   'drbd_option_name': 'on-congestion',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/on-congestion",
                          'type': 'symbol',
                          'values': ['block', 'pull-ahead', 'disconnect']},
                      {   'default': 0,
                          'drbd_option_name': 'congestion-fill',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/congestion-fill",
                          'max': 20971520,
                          'min': 0,
                          'type': 'range',
                          'unit': 'bytes',
                          'unit_prefix': 's'},
                      {   'default': 1237,
                          'drbd_option_name': 'congestion-extents',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/congestion-extents",
                          'max': 65534,
                          'min': 67,
                          'type': 'range',
                          'unit_prefix': '1'},
                      {   'drbd_option_name': 'csums-alg',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/csums-alg",
                          'type': 'string'},
                      {   'default': False,
                          'drbd_option_name': 'csums-after-crash-only',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/csums-after-crash-only",
                          'type': 'boolean'},
                      {   'drbd_option_name': 'verify-alg',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/verify-alg",
                          'type': 'string'},
                      {   'default': True,
                          'drbd_option_name': 'use-rle',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/use-rle",
                          'type': 'boolean'},
                      {   'default': 0,
                          'drbd_option_name': 'socket-check-timeout',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/socket-check-timeout",
                          'max': 300,
                          'min': 0,
                          'type': 'range',
                          'unit_prefix': '1'},
                      {   'drbd_option_name': 'fencing',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/fencing",
                          'type': 'symbol',
                          'values': [   'dont-care',
                                        'resource-only',
                                        'resource-and-stonith']},
                      {   'default': 2048,
                          'drbd_option_name': 'max-buffers',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/max-buffers",
                          'max': 131072,
                          'min': 32,
                          'type': 'range',
                          'unit_prefix': '1'},
                      {   'default': True,
                          'drbd_option_name': 'allow-remote-read',
                          'drbd_res_file_section': 'net',
                          'internal': True,
                          'key': "DrbdOptions/Net/allow-remote-read",
                          'type': 'boolean'},
                      {   'drbd_option_name': 'after-resync-target',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/after-resync-target",
                          'type': 'string'},
                      {   'drbd_option_name': 'before-resync-target',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/before-resync-target",
                          'type': 'string'},
                      {   'drbd_option_name': 'before-resync-source',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/before-resync-source",
                          'type': 'string'},
                      {   'drbd_option_name': 'out-of-sync',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/out-of-sync",
                          'type': 'string'},
                      {   'drbd_option_name': 'quorum-lost',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/quorum-lost",
                          'type': 'string'},
                      {   'drbd_option_name': 'fence-peer',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/fence-peer",
                          'type': 'string'},
                      {   'drbd_option_name': 'unfence-peer',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/unfence-peer",
                          'type': 'string'},
                      {   'drbd_option_name': 'initial-split-brain',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/initial-split-brain",
                          'type': 'string'},
                      {   'drbd_option_name': 'local-io-error',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/local-io-error",
                          'type': 'string'},
                      {   'drbd_option_name': 'pri-lost',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/pri-lost",
                          'type': 'string'},
                      {   'drbd_option_name': 'pri-lost-after-sb',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/pri-lost-after-sb",
                          'type': 'string'},
                      {   'drbd_option_name': 'pri-on-incon-degr',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/pri-on-incon-degr",
                          'type': 'string'},
                      {   'drbd_option_name': 'split-brain',
                          'drbd_res_file_section': 'handlers',
                          'internal': True,
                          'key': "DrbdOptions/Handlers/split-brain",
                          'type': 'string'}],
    'drbd-proxy': [   {   'default': 16777216,
                          'drbd_option_name': 'memlimit',
                          'internal': True,
                          'key': "DrbdOptions/Proxy/memlimit",
                          'max': 9223372036854775807,
                          'min': 16777216,
                          'type': 'range',
                          'unit': 'bytes',
                          'unit_prefix': '1'},
                      {   'default': 0,
                          'drbd_option_name': 'read-loops',
                          'internal': True,
                          'key': "DrbdOptions/Proxy/read-loops",
                          'max': 2147483647,
                          'min': 0,
                          'type': 'range',
                          'unit_prefix': '1'},
                      {   'default': 0,
                          'drbd_option_name': 'sndbuf-size',
                          'internal': True,
                          'key': "DrbdOptions/Proxy/sndbuf-size",
                          'max': 10485760,
                          'min': 0,
                          'type': 'range',
                          'unit': 'bytes',
                          'unit_prefix': '1'},
                      {   'default': 0,
                          'drbd_option_name': 'rcvbuf-size',
                          'internal': True,
                          'key': "DrbdOptions/Proxy/rcvbuf-size",
                          'max': 10485760,
                          'min': 0,
                          'type': 'range',
                          'unit': 'bytes',
                          'unit_prefix': '1'},
                      {   'default': 200,
                          'drbd_option_name': 'ping-timeout',
                          'internal': True,
                          'key': "DrbdOptions/Proxy/ping-timeout",
                          'max': 300,
                          'min': 1,
                          'type': 'range',
                          'unit': '1/10 seconds',
                          'unit_prefix': '1'}],
    'drbd-proxy-lzma': [   {   'default': 32768,
                               'drbd_option_name': 'dict-size',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/dict-size",
                               'max': 1610612736,
                               'min': 4096,
                               'type': 'range'},
                           {   'default': 3,
                               'drbd_option_name': 'lc',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/lc",
                               'max': 4,
                               'min': 0,
                               'type': 'range'},
                           {   'default': 0,
                               'drbd_option_name': 'lp',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/lp",
                               'max': 4,
                               'min': 0,
                               'type': 'range'},
                           {   'default': 2,
                               'drbd_option_name': 'pb',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/pb",
                               'max': 4,
                               'min': 0,
                               'type': 'range'},
                           {   'default': 273,
                               'drbd_option_name': 'nice-len',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/nice-len",
                               'max': 273,
                               'min': 0,
                               'type': 'range'},
                           {   'default': 'hc3',
                               'drbd_option_name': 'mf',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/mf",
                               'type': 'symbol',
                               'values': ['hc4', 'hc3', 'bt2', 'bt3', 'bt4']},
                           {   'default': 'fast',
                               'drbd_option_name': 'mode',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/mode",
                               'type': 'symbol',
                               'values': ['fast', 'normal']},
                           {   'default': 0,
                               'drbd_option_name': 'depth',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/depth",
                               'max': 1000,
                               'min': 0,
                               'type': 'range'},
                           {   'default': 4,
                               'drbd_option_name': 'level',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/level",
                               'max': 9,
                               'min': 1,
                               'type': 'range'},
                           {   'default': 'thread count',
                               'drbd_option_name': 'contexts',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/contexts",
                               'max': 253,
                               'min': 1,
                               'type': 'range'},
                           {   'default': 'off',
                               'drbd_option_name': 'fallback-to-zlib',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/fallback-to-zlib",
                               'type': 'symbol',
                               'values': ['off', 'on']},
                           {   'default': 0,
                               'drbd_option_name': 'numa-threshold',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/numa-threshold",
                               'max': 253,
                               'min': 0,
                               'type': 'range'}],
    'drbd-proxy-zlib': [   {   'default': 2,
                               'drbd_option_name': 'level',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/level",
                               'max': 9,
                               'min': 1,
                               'type': 'range'}],
    'drbd-proxy-zstd': [   {   'default': 3,
                               'drbd_option_name': 'level',
                               'internal': True,
                               'key': "DrbdOptions/ProxyCompression/level",
                               'max': 22,
                               'min': 1,
                               'type': 'range'}],
    'node': [   {   'info': 'Preferred network interface to use',
                    'key': consts.KEY_STOR_POOL_PREF_NIC,
                    'type': 'regex',
                    'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                {   'info': 'Linstor storage pool name to use.',
                    'key': consts.KEY_STOR_POOL_NAME,
                    'type': 'regex',
                    'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                {   'info': 'Linstor storage pool name to use for external '
                            'metadata.',
                    'key': consts.KEY_STOR_POOL_DRBD_META_NAME,
                    'type': 'regex',
                    'value': '^|.internal|[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                {   'info': 'Sets the '
                            '/sys/fs/cgroup/blkio/blkio.throttle.read_bps_device',
                    'internal': False,
                    'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ,
                    'type': 'long'},
                {   'info': 'Sets the '
                            '/sys/fs/cgroup/blkio/blkio.throttle.write_bps_device',
                    'internal': False,
                    'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE,
                    'type': 'long'},
                {   'info': 'Sets the '
                            '/sys/fs/cgroup/blkio/blkio.throttle.read_iops_device',
                    'internal': False,
                    'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ_IOPS,
                    'type': 'long'},
                {   'info': 'Sets the '
                            '/sys/fs/cgroup/blkio/blkio.throttle.write_iops_device',
                    'internal': False,
                    'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE_IOPS,
                    'type': 'long'},
                {   'default': 60,
                    'info': 'Time a node can be offline before it is declared '
                            'EVICTED in minutes',
                    'internal': False,
                    'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_AUTO_EVICT_AFTER_TIME,
                    'type': 'long'},
                {   'default': 'true',
                    'info': 'If set to true on a node, it cannot be evicted '
                            'anymore',
                    'internal': False,
                    'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_AUTO_EVICT_ALLOW_EVICTION,
                    'type': 'boolean_true_false'},
                {   'info': 'Linstor storage pool name for writecache',
                    'key': consts.NAMESPC_WRITECACHE + '/' + consts.KEY_WRITECACHE_POOL_NAME,
                    'type': 'regex',
                    'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                {   'info': 'Size of the writecache in % (0-100) or KiB '
                            'otherwise',
                    'key': consts.NAMESPC_WRITECACHE + '/' + consts.KEY_WRITECACHE_SIZE,
                    'type': 'regex',
                    'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                {   'default': '0',
                    'info': 'offset from the start of cache device in 512-byte '
                            'sectors',
                    'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_START_SECTOR,
                    'type': 'long'},
                {   'default': '50',
                    'info': 'start writeback when the number of used blocks '
                            'reach this watermark',
                    'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_HIGH_WATERMARK,
                    'type': 'long'},
                {   'default': '45',
                    'info': 'stop writeback when the number of used blocks '
                            'drops below this watermark',
                    'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_LOW_WATERMARK,
                    'type': 'long'},
                {   'default': 'unlimited',
                    'info': 'limit the number of blocks that are in flight '
                            'during writeback. Setting this value reduces '
                            'writeback throughput, but it may improve latency '
                            'of read requests',
                    'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_WRITEBACK_JOBS,
                    'type': 'long'},
                {   'default': '64 for pmem, 65536 for ssd',
                    'info': 'when the application writes this amount of blocks '
                            'without issuing the FLUSH request, the blocks are '
                            'automatically committed',
                    'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_AUTOCOMMIT_BLOCKS,
                    'type': 'long'},
                {   'default': '1000',
                    'info': 'autocommit time in milliseconds. The data is '
                            'automatically committed if this time passes and '
                            'no FLUSH request is received',
                    'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_AUTOCOMMIT_TIME,
                    'type': 'long'},
                {   'default': 'On',
                    'info': '"On" results in "fua" as argument, whereas the '
                            'value "Off" results in "nofua" argument',
                    'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_FUA,
                    'type': 'symbol',
                    'values': ['On', 'Off']},
                {   'info': 'Additional arguments passed through',
                    'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_ADDITIONAL,
                    'type': 'string'},
                {   'default': 'writethrough',
                    'info': 'Operation mode',
                    'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_OPERATING_MODE,
                    'type': 'symbol',
                    'values': ['writeback', 'writethrough', 'passthrough']},
                {   'info': 'Name of the storage pool used for the cache '
                            'metadata. If not specified, this will default to '
                            'the CachePool property',
                    'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_META_POOL_NAME,
                    'type': 'regex',
                    'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                {   'default': '12288',
                    'info': 'Size of the cache in % (0-100) or KiB otherwise.',
                    'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_META_SIZE,
                    'type': 'regex',
                    'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                {   'info': 'Name of the storage pool used for the cache cache '
                            'device',
                    'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_CACHE_POOL_NAME,
                    'type': 'regex',
                    'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                {   'default': '5%',
                    'info': 'Size of the cache in % (0-100) or KiB otherwise.',
                    'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_CACHE_SIZE,
                    'type': 'regex',
                    'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                {   'default': '4096',
                    'info': 'Block size',
                    'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_BLOCK_SIZE,
                    'type': 'long'},
                {   'default': 'smq',
                    'info': 'Replacement policy',
                    'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_POLICY,
                    'type': 'symbol',
                    'values': ['mq', 'smq', 'cleaner']},
                {   'info': "Additional parameters added to every 'lvcreate "
                            "... ' command",
                    'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_LVCREATE_OPTIONS,
                    'type': 'regex',
                    'value': '.*'},
                {   'info': "Additional parameters added to every 'zfs create "
                            "... ' command",
                    'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_ZFS_CREATE_OPTIONS,
                    'type': 'regex',
                    'value': '.*'},
                {   'info': 'Openflex API host name',
                    'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_API_HOST,
                    'type': 'regex',
                    'value': '.+'},
                {   'info': 'Openflex API port',
                    'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_API_PORT,
                    'type': 'regex',
                    'value': '[0-9]+'},
                {   'info': 'Openflex user name',
                    'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_USER_NAME,
                    'type': 'regex',
                    'value': '.+'},
                {   'info': 'Openflex password',
                    'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_USER_PW,
                    'type': 'regex',
                    'value': '.+'},
                {   'info': 'Openflex storage device',
                    'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_STOR_DEV,
                    'type': 'regex',
                    'value': '.+'},
                {   'info': 'Openflex storage device host',
                    'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_STOR_DEV_HOST,
                    'type': 'regex',
                    'value': '.+'},
                {   'info': 'Delay in milliseconds linstor waits between '
                            'fetching the job status',
                    'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_JOB_WAIT_DELAY,
                    'type': 'regex',
                    'value': '[0-9]+'},
                {   'info': 'Maximum retries with wait delay until openflex '
                            'fails',
                    'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_JOB_WAIT_MAX_COUNT,
                    'type': 'regex',
                    'value': '[0-9]+'},
                {   'info': 'linear: Volumes are created from Disk Groups '
                            '(vdisks), virtual: Volumes are created from Pools '
                            'which is a set of Disk Groups (vdisks)',
                    'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_VLM_TYPE,
                    'type': 'symbol',
                    'values': ['linear', 'virtual']},
                {   'info': 'Any additional parameters appended to '
                            '/create/volume/pool/${poolName}/size/${size}KiB/${vlmName}',
                    'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_CREATE_VOLUME_OPTIONS,
                    'type': 'string'},
                {   'info': 'The maximum throughput the given storage pool is '
                            'capable of.',
                    'key': consts.NAMESPC_AUTOPLACER + '/' + consts.KEY_AUTOPLACE_MAX_THROUGHPUT,
                    'type': 'long'},
                {   'default': 'false',
                    'internal': True,
                    'key': consts.NAMESPC_DRBD_PROXY + '/' + consts.KEY_DRBD_PROXY_AUTO_ENABLE,
                    'type': 'boolean_true_false'},
                {'internal': True, 'key': consts.KEY_SITE, 'type': 'string'},
                {   'info': 'Allows this resource to be cleaned up after '
                            'toggle-disk + resync is finished',
                    'internal': False,
                    'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_DISKFUL_ALLOW_CLEANUP,
                    'type': 'boolean_true_false'}],
    'resource': [   {   'info': 'Linstor storage pool name to use.',
                        'key': consts.KEY_STOR_POOL_NAME,
                        'type': 'regex',
                        'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                    {   'info': 'Linstor storage pool name to use for external '
                                'metadata.',
                        'key': consts.KEY_STOR_POOL_DRBD_META_NAME,
                        'type': 'regex',
                        'value': '^|.internal|[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                    {   'info': 'Preferred network interface to use',
                        'key': consts.KEY_STOR_POOL_PREF_NIC,
                        'type': 'regex',
                        'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                    {   'info': 'DRBD peer slots present on resource',
                        'internal': True,
                        'key': consts.KEY_PEER_SLOTS,
                        'max': 31,
                        'min': 1,
                        'type': 'range'},
                    {   'info': 'File system type to use',
                        'internal': False,
                        'key': consts.NAMESPC_FILESYSTEM + '/' + consts.KEY_FS_TYPE,
                        'type': 'symbol',
                        'values': ['ext4', 'xfs']},
                    {   'info': 'Additional parameters for the mkfs command',
                        'internal': False,
                        'key': consts.NAMESPC_FILESYSTEM + '/' + consts.KEY_FS_MKFSPARAMETERS,
                        'type': 'string'},
                    {   'info': 'Preferred network interface to use',
                        'internal': False,
                        'key': consts.NAMESPC_NVME + '/' + consts.KEY_PREF_NIC,
                        'type': 'regex',
                        'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                    {   'info': 'Sets the '
                                '/sys/fs/cgroup/blkio/blkio.throttle.read_bps_device',
                        'internal': False,
                        'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ,
                        'type': 'long'},
                    {   'info': 'Sets the '
                                '/sys/fs/cgroup/blkio/blkio.throttle.write_bps_device',
                        'internal': False,
                        'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE,
                        'type': 'long'},
                    {   'info': 'Sets the '
                                '/sys/fs/cgroup/blkio/blkio.throttle.read_iops_device',
                        'internal': False,
                        'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ_IOPS,
                        'type': 'long'},
                    {   'info': 'Sets the '
                                '/sys/fs/cgroup/blkio/blkio.throttle.write_iops_device',
                        'internal': False,
                        'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE_IOPS,
                        'type': 'long'},
                    {   'info': 'Allows this resource to be cleaned up after '
                                'toggle-disk + resync is finished',
                        'internal': False,
                        'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_DISKFUL_ALLOW_CLEANUP,
                        'type': 'boolean_true_false'},
                    {   'info': 'Any additional parameters appended to '
                                '/create/volume/pool/${poolName}/size/${size}KiB/${vlmName}',
                        'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_CREATE_VOLUME_OPTIONS,
                        'type': 'string'}],
    'resource-definition': [   {   'info': 'Linstor storage pool name to use.',
                                   'key': consts.KEY_STOR_POOL_NAME,
                                   'type': 'regex',
                                   'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                               {   'info': 'Linstor storage pool name to use '
                                           'for external metadata.',
                                   'key': consts.KEY_STOR_POOL_DRBD_META_NAME,
                                   'type': 'regex',
                                   'value': '^|.internal|[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                               {   'info': 'DRBD peer slots to allocate for '
                                           'newly created resources (default '
                                           '7), the number of peer slots '
                                           'cannot be changed once the '
                                           'resource is created, so allow '
                                           'sufficient slots to increase '
                                           'redundancy in the future',
                                   'key': consts.KEY_PEER_SLOTS_NEW_RESOURCE,
                                   'max': 31,
                                   'min': 1,
                                   'type': 'range'},
                               {   'internal': True,
                                   'key': consts.NAMESPC_DRBD_PROXY + '/' + consts.KEY_DRBD_PROXY_COMPRESSION_TYPE,
                                   'type': 'symbol',
                                   'values': ['zlib', 'lzma', 'lz4', 'zstd']},
                               {   'default': 'The place count set for the '
                                              'resource group',
                                   'info': 'The minimum amount of replicas '
                                           'that should be present for a '
                                           'resource at all times.',
                                   'internal': False,
                                   'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_AUTO_EVICT_MIN_REPLICA_COUNT,
                                   'type': 'long'},
                               {   'info': 'File system type to use',
                                   'internal': False,
                                   'key': consts.NAMESPC_FILESYSTEM + '/' + consts.KEY_FS_TYPE,
                                   'type': 'symbol',
                                   'values': ['ext4', 'xfs']},
                               {   'info': 'Additional parameters for the mkfs '
                                           'command',
                                   'internal': False,
                                   'key': consts.NAMESPC_FILESYSTEM + '/' + consts.KEY_FS_MKFSPARAMETERS,
                                   'type': 'string'},
                               {   'default': 'rdma',
                                   'info': 'NVMe transportation type',
                                   'internal': False,
                                   'key': consts.NAMESPC_NVME + '/' + consts.KEY_TR_TYPE,
                                   'type': 'symbol',
                                   'values': ['rdma', 'tcp']},
                               {   'info': 'NVMe port',
                                   'internal': False,
                                   'key': consts.NAMESPC_NVME + '/' + consts.KEY_PORT,
                                   'max': 65535,
                                   'min': 1,
                                   'type': 'range'},
                               {   'default': 'linear',
                                   'internal': True,
                                   'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_LVCREATE_TYPE,
                                   'type': 'symbol',
                                   'values': [   'linear',
                                                 'striped',
                                                 'mirror',
                                                 'raid0',
                                                 'raid1',
                                                 'raid4',
                                                 'raid5',
                                                 'raid6',
                                                 'raid10',
                                                 'lzma',
                                                 'lz4']},
                               {   'info': 'Additional parameters added to '
                                           "every 'lvcreate ... ' command",
                                   'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_LVCREATE_OPTIONS,
                                   'type': 'regex',
                                   'value': '.*'},
                               {   'info': 'Additional parameters added to '
                                           "every 'zfs create ... ' command",
                                   'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_ZFS_CREATE_OPTIONS,
                                   'type': 'regex',
                                   'value': '.*'},
                               {   'info': 'Sets the '
                                           '/sys/fs/cgroup/blkio/blkio.throttle.read_bps_device',
                                   'internal': False,
                                   'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ,
                                   'type': 'long'},
                               {   'info': 'Sets the '
                                           '/sys/fs/cgroup/blkio/blkio.throttle.write_bps_device',
                                   'internal': False,
                                   'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE,
                                   'type': 'long'},
                               {   'info': 'Sets the '
                                           '/sys/fs/cgroup/blkio/blkio.throttle.read_iops_device',
                                   'internal': False,
                                   'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ_IOPS,
                                   'type': 'long'},
                               {   'info': 'Sets the '
                                           '/sys/fs/cgroup/blkio/blkio.throttle.write_iops_device',
                                   'internal': False,
                                   'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE_IOPS,
                                   'type': 'long'},
                               {   'info': 'Enables automatic setting of the '
                                           "'quorum' and 'on-no-quorum' "
                                           'property',
                                   'internal': False,
                                   'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_QUORUM,
                                   'type': 'symbol',
                                   'values': [   'io-error',
                                                 'suspend-io',
                                                 'disabled']},
                               {   'info': 'Enables automatic management '
                                           '(creation and deletion) of tie '
                                           'breaking resource',
                                   'internal': False,
                                   'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_ADD_QUORUM_TIEBREAKER,
                                   'type': 'boolean_true_false'},
                               {   'info': 'Makes a resource diskful if it was '
                                           'continuously diskless primary for '
                                           'X minutes',
                                   'internal': False,
                                   'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_DISKFUL,
                                   'type': 'long'},
                               {   'info': 'Allows this resource to be cleaned '
                                           'up after toggle-disk + resync is '
                                           'finished',
                                   'internal': False,
                                   'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_AUTO_DISKFUL_ALLOW_CLEANUP,
                                   'type': 'boolean_true_false'},
                               {   'info': 'If set to true it will disable '
                                           'automatic setting of DRBD verify '
                                           'algorithm',
                                   'internal': False,
                                   'key': consts.NAMESPC_DRBD_OPTIONS + '/' + consts.KEY_DRBD_DISABLE_AUTO_VERIFY_ALGO,
                                   'type': 'boolean_true_false'},
                               {   'info': 'Linstor storage pool name for '
                                           'writecache',
                                   'key': consts.NAMESPC_WRITECACHE + '/' + consts.KEY_WRITECACHE_POOL_NAME,
                                   'type': 'regex',
                                   'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                               {   'info': 'Size of the writecache in % '
                                           '(0-100) or KiB otherwise',
                                   'key': consts.NAMESPC_WRITECACHE + '/' + consts.KEY_WRITECACHE_SIZE,
                                   'type': 'regex',
                                   'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                               {   'default': '0',
                                   'info': 'offset from the start of cache '
                                           'device in 512-byte sectors',
                                   'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_START_SECTOR,
                                   'type': 'long'},
                               {   'default': '50',
                                   'info': 'start writeback when the number of '
                                           'used blocks reach this watermark',
                                   'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_HIGH_WATERMARK,
                                   'type': 'long'},
                               {   'default': '45',
                                   'info': 'stop writeback when the number of '
                                           'used blocks drops below this '
                                           'watermark',
                                   'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_LOW_WATERMARK,
                                   'type': 'long'},
                               {   'default': 'unlimited',
                                   'info': 'limit the number of blocks that '
                                           'are in flight during writeback. '
                                           'Setting this value reduces '
                                           'writeback throughput, but it may '
                                           'improve latency of read requests',
                                   'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_WRITEBACK_JOBS,
                                   'type': 'long'},
                               {   'default': '64 for pmem, 65536 for ssd',
                                   'info': 'when the application writes this '
                                           'amount of blocks without issuing '
                                           'the FLUSH request, the blocks are '
                                           'automatically committed',
                                   'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_AUTOCOMMIT_BLOCKS,
                                   'type': 'long'},
                               {   'default': '1000',
                                   'info': 'autocommit time in milliseconds. '
                                           'The data is automatically '
                                           'committed if this time passes and '
                                           'no FLUSH request is received',
                                   'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_AUTOCOMMIT_TIME,
                                   'type': 'long'},
                               {   'default': 'On',
                                   'info': '"On" results in "fua" as argument, '
                                           'whereas the value "Off" results in '
                                           '"nofua" argument',
                                   'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_FUA,
                                   'type': 'symbol',
                                   'values': ['On', 'Off']},
                               {   'info': 'Additional arguments passed '
                                           'through',
                                   'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_ADDITIONAL,
                                   'type': 'string'},
                               {   'default': 'writethrough',
                                   'info': 'Operation mode',
                                   'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_OPERATING_MODE,
                                   'type': 'symbol',
                                   'values': [   'writeback',
                                                 'writethrough',
                                                 'passthrough']},
                               {   'info': 'Name of the storage pool used for '
                                           'the cache metadata. If not '
                                           'specified, this will default to '
                                           'the CachePool property',
                                   'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_META_POOL_NAME,
                                   'type': 'regex',
                                   'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                               {   'default': '12288',
                                   'info': 'Size of the cache in % (0-100) or '
                                           'KiB otherwise.',
                                   'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_META_SIZE,
                                   'type': 'regex',
                                   'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                               {   'info': 'Name of the storage pool used for '
                                           'the cache cache device',
                                   'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_CACHE_POOL_NAME,
                                   'type': 'regex',
                                   'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                               {   'default': '5%',
                                   'info': 'Size of the cache in % (0-100) or '
                                           'KiB otherwise.',
                                   'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_CACHE_SIZE,
                                   'type': 'regex',
                                   'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                               {   'default': '4096',
                                   'info': 'Block size',
                                   'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_BLOCK_SIZE,
                                   'type': 'long'},
                               {   'default': 'smq',
                                   'info': 'Replacement policy',
                                   'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_POLICY,
                                   'type': 'symbol',
                                   'values': ['mq', 'smq', 'cleaner']},
                               {   'info': 'Node name of the snapshot shipping '
                                           'source',
                                   'key': consts.NAMESPC_SNAPSHOT_SHIPPING + '/' + consts.KEY_SOURCE_NODE,
                                   'type': 'string'},
                               {   'info': 'Node name of the snapshot shipping '
                                           'target',
                                   'key': consts.NAMESPC_SNAPSHOT_SHIPPING + '/' + consts.KEY_TARGET_NODE,
                                   'type': 'string'},
                               {   'info': 'Runs every X minutes an '
                                           'auto-snapshot-shipping unless the '
                                           'current snapshot-shipping is still '
                                           'running. In this case a new one '
                                           'will be started asap.',
                                   'key': consts.NAMESPC_SNAPSHOT_SHIPPING + '/' + consts.KEY_RUN_EVERY,
                                   'type': 'long'},
                               {   'default': '10',
                                   'info': 'Keeps the last X sihpped '
                                           'snapshots. Removing this property '
                                           'or having a value <= 0 disables '
                                           'auto-cleanup, all auto-snapshots '
                                           'will be kept',
                                   'key': consts.NAMESPC_SNAPSHOT_SHIPPING + '/' + consts.KEY_KEEP,
                                   'type': 'long'},
                               {   'info': 'Runs every X minutes an '
                                           'snapshot-creation. Removing this '
                                           'property or having a value <= 0 '
                                           'disables auto-snapshotting.',
                                   'key': consts.NAMESPC_AUTO_SNAPSHOT + '/' + consts.KEY_RUN_EVERY,
                                   'type': 'long'},
                               {   'default': '10',
                                   'info': 'Keeps the last X auto-snapshots. '
                                           'Removing this property or having a '
                                           'value <= 0 disables auto-cleanup, '
                                           'all auto-snapshots will be kept',
                                   'key': consts.NAMESPC_AUTO_SNAPSHOT + '/' + consts.KEY_KEEP,
                                   'type': 'long'},
                               {   'info': 'The next ID to try for '
                                           'auto-snapshots',
                                   'key': consts.NAMESPC_AUTO_SNAPSHOT + '/' + consts.KEY_AUTO_SNAPSHOT_NEXT_ID,
                                   'type': 'long'},
                               {   'info': 'linear: Volumes are created from '
                                           'Disk Groups (vdisks), virtual: '
                                           'Volumes are created from Pools '
                                           'which is a set of Disk Groups '
                                           '(vdisks)',
                                   'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_VLM_TYPE,
                                   'type': 'symbol',
                                   'values': ['linear', 'virtual']},
                               {   'info': 'Any additional parameters appended '
                                           'to '
                                           '/create/volume/pool/${poolName}/size/${size}KiB/${vlmName}',
                                   'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_CREATE_VOLUME_OPTIONS,
                                   'type': 'string'},
                               {   'info': 'Preferred network interface to use',
                                   'key': consts.KEY_STOR_POOL_PREF_NIC,
                                   'type': 'regex',
                                   'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                               {   'drbd_option_name': 'on-io-error',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/on-io-error",
                                   'type': 'symbol',
                                   'values': [   'pass_on',
                                                 'call-local-io-error',
                                                 'detach']},
                               {   'default': False,
                                   'drbd_option_name': 'disk-barrier',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/disk-barrier",
                                   'type': 'boolean'},
                               {   'default': True,
                                   'drbd_option_name': 'disk-flushes',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/disk-flushes",
                                   'type': 'boolean'},
                               {   'default': True,
                                   'drbd_option_name': 'disk-drain',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/disk-drain",
                                   'type': 'boolean'},
                               {   'default': True,
                                   'drbd_option_name': 'md-flushes',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/md-flushes",
                                   'type': 'boolean'},
                               {   'drbd_option_name': 'resync-after',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/resync-after",
                                   'type': 'string'},
                               {   'default': 1237,
                                   'drbd_option_name': 'al-extents',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/al-extents",
                                   'max': 65534,
                                   'min': 67,
                                   'type': 'range',
                                   'unit_prefix': '1'},
                               {   'default': True,
                                   'drbd_option_name': 'al-updates',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/al-updates",
                                   'type': 'boolean'},
                               {   'default': True,
                                   'drbd_option_name': 'discard-zeroes-if-aligned',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/discard-zeroes-if-aligned",
                                   'type': 'boolean'},
                               {   'default': False,
                                   'drbd_option_name': 'disable-write-same',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/disable-write-same",
                                   'type': 'boolean'},
                               {   'default': 0,
                                   'drbd_option_name': 'disk-timeout',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/disk-timeout",
                                   'max': 6000,
                                   'min': 0,
                                   'type': 'range',
                                   'unit': '1/10 seconds',
                                   'unit_prefix': '1'},
                               {   'drbd_option_name': 'read-balancing',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/read-balancing",
                                   'type': 'symbol',
                                   'values': [   'prefer-local',
                                                 'prefer-remote',
                                                 'round-robin',
                                                 'least-pending',
                                                 'when-congested-remote',
                                                 '32K-striping',
                                                 '64K-striping',
                                                 '128K-striping',
                                                 '256K-striping',
                                                 '512K-striping',
                                                 '1M-striping']},
                               {   'default': 0,
                                   'drbd_option_name': 'rs-discard-granularity',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/Disk/rs-discard-granularity",
                                   'max': 1048576,
                                   'min': 0,
                                   'type': 'range',
                                   'unit': 'bytes',
                                   'unit_prefix': '1'},
                               {   'default': 250,
                                   'drbd_option_name': 'resync-rate',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/PeerDevice/resync-rate",
                                   'max': 8388608,
                                   'min': 1,
                                   'type': 'range',
                                   'unit': 'bytes/second',
                                   'unit_prefix': 'k'},
                               {   'default': 20,
                                   'drbd_option_name': 'c-plan-ahead',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/PeerDevice/c-plan-ahead",
                                   'max': 300,
                                   'min': 0,
                                   'type': 'range',
                                   'unit': '1/10 seconds',
                                   'unit_prefix': '1'},
                               {   'default': 10,
                                   'drbd_option_name': 'c-delay-target',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/PeerDevice/c-delay-target",
                                   'max': 100,
                                   'min': 1,
                                   'type': 'range',
                                   'unit': '1/10 seconds',
                                   'unit_prefix': '1'},
                               {   'default': 100,
                                   'drbd_option_name': 'c-fill-target',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/PeerDevice/c-fill-target",
                                   'max': 1048576,
                                   'min': 0,
                                   'type': 'range',
                                   'unit': 'bytes',
                                   'unit_prefix': 's'},
                               {   'default': 102400,
                                   'drbd_option_name': 'c-max-rate',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/PeerDevice/c-max-rate",
                                   'max': 4194304,
                                   'min': 0,
                                   'type': 'range',
                                   'unit': 'bytes/second',
                                   'unit_prefix': 'k'},
                               {   'default': 250,
                                   'drbd_option_name': 'c-min-rate',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/PeerDevice/c-min-rate",
                                   'max': 4194304,
                                   'min': 0,
                                   'type': 'range',
                                   'unit': 'bytes/second',
                                   'unit_prefix': 'k'},
                               {   'default': True,
                                   'drbd_option_name': 'bitmap',
                                   'drbd_res_file_section': 'disk',
                                   'internal': True,
                                   'key': "DrbdOptions/PeerDevice/bitmap",
                                   'type': 'boolean'},
                               {   'drbd_option_name': 'cpu-mask',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/cpu-mask",
                                   'type': 'string'},
                               {   'drbd_option_name': 'on-no-data-accessible',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/on-no-data-accessible",
                                   'type': 'symbol',
                                   'values': ['io-error', 'suspend-io']},
                               {   'default': True,
                                   'drbd_option_name': 'auto-promote',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/auto-promote",
                                   'type': 'boolean'},
                               {   'default': 4096,
                                   'drbd_option_name': 'peer-ack-window',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/peer-ack-window",
                                   'max': 204800,
                                   'min': 2048,
                                   'type': 'range',
                                   'unit': 'bytes',
                                   'unit_prefix': 's'},
                               {   'default': 100,
                                   'drbd_option_name': 'peer-ack-delay',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/peer-ack-delay",
                                   'max': 10000,
                                   'min': 1,
                                   'type': 'range',
                                   'unit': 'milliseconds',
                                   'unit_prefix': '1'},
                               {   'default': 300,
                                   'drbd_option_name': 'twopc-timeout',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/twopc-timeout",
                                   'max': 600,
                                   'min': 50,
                                   'type': 'range',
                                   'unit': '1/10 seconds',
                                   'unit_prefix': '1'},
                               {   'default': 1,
                                   'drbd_option_name': 'twopc-retry-timeout',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/twopc-retry-timeout",
                                   'max': 50,
                                   'min': 1,
                                   'type': 'range',
                                   'unit': '1/10 seconds',
                                   'unit_prefix': '1'},
                               {   'default': 20,
                                   'drbd_option_name': 'auto-promote-timeout',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/auto-promote-timeout",
                                   'max': 600,
                                   'min': 0,
                                   'type': 'range',
                                   'unit': '1/10 seconds',
                                   'unit_prefix': '1'},
                               {   'default': 8000,
                                   'drbd_option_name': 'max-io-depth',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/max-io-depth",
                                   'max': 4294967295,
                                   'min': 4,
                                   'type': 'range',
                                   'unit_prefix': '1'},
                               {   'drbd_option_name': 'quorum',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/quorum",
                                   'max': '32',
                                   'min': '1',
                                   'type': 'numeric-or-symbol',
                                   'values': ['off', 'majority', 'all']},
                               {   'drbd_option_name': 'on-no-quorum',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/on-no-quorum",
                                   'type': 'symbol',
                                   'values': ['io-error', 'suspend-io']},
                               {   'drbd_option_name': 'quorum-minimum-redundancy',
                                   'drbd_res_file_section': 'options',
                                   'internal': True,
                                   'key': "DrbdOptions/Resource/quorum-minimum-redundancy",
                                   'max': '32',
                                   'min': '1',
                                   'type': 'numeric-or-symbol',
                                   'values': ['off', 'majority', 'all']},
                               {   'drbd_option_name': 'transport',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/transport",
                                   'type': 'string'},
                               {   'drbd_option_name': 'protocol',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/protocol",
                                   'type': 'symbol',
                                   'values': ['A', 'B', 'C']},
                               {   'default': 60,
                                   'drbd_option_name': 'timeout',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/timeout",
                                   'max': 600,
                                   'min': 1,
                                   'type': 'range',
                                   'unit': '1/10 seconds',
                                   'unit_prefix': '1'},
                               {   'default': 2048,
                                   'drbd_option_name': 'max-epoch-size',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/max-epoch-size",
                                   'max': 20000,
                                   'min': 1,
                                   'type': 'range',
                                   'unit_prefix': '1'},
                               {   'default': 10,
                                   'drbd_option_name': 'connect-int',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/connect-int",
                                   'max': 120,
                                   'min': 1,
                                   'type': 'range',
                                   'unit': 'seconds',
                                   'unit_prefix': '1'},
                               {   'default': 10,
                                   'drbd_option_name': 'ping-int',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/ping-int",
                                   'max': 120,
                                   'min': 1,
                                   'type': 'range',
                                   'unit': 'seconds',
                                   'unit_prefix': '1'},
                               {   'default': 0,
                                   'drbd_option_name': 'sndbuf-size',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/sndbuf-size",
                                   'max': 10485760,
                                   'min': 0,
                                   'type': 'range',
                                   'unit': 'bytes',
                                   'unit_prefix': '1'},
                               {   'default': 0,
                                   'drbd_option_name': 'rcvbuf-size',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/rcvbuf-size",
                                   'max': 10485760,
                                   'min': 0,
                                   'type': 'range',
                                   'unit': 'bytes',
                                   'unit_prefix': '1'},
                               {   'default': 7,
                                   'drbd_option_name': 'ko-count',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/ko-count",
                                   'max': 200,
                                   'min': 0,
                                   'type': 'range',
                                   'unit_prefix': '1'},
                               {   'default': False,
                                   'drbd_option_name': 'allow-two-primaries',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/allow-two-primaries",
                                   'type': 'boolean'},
                               {   'drbd_option_name': 'cram-hmac-alg',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/cram-hmac-alg",
                                   'type': 'string'},
                               {   'drbd_option_name': 'shared-secret',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/shared-secret",
                                   'type': 'string'},
                               {   'drbd_option_name': 'after-sb-0pri',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/after-sb-0pri",
                                   'type': 'symbol',
                                   'values': [   'disconnect',
                                                 'discard-younger-primary',
                                                 'discard-older-primary',
                                                 'discard-zero-changes',
                                                 'discard-least-changes',
                                                 'discard-local',
                                                 'discard-remote']},
                               {   'drbd_option_name': 'after-sb-1pri',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/after-sb-1pri",
                                   'type': 'symbol',
                                   'values': [   'disconnect',
                                                 'consensus',
                                                 'discard-secondary',
                                                 'call-pri-lost-after-sb',
                                                 'violently-as0p']},
                               {   'drbd_option_name': 'after-sb-2pri',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/after-sb-2pri",
                                   'type': 'symbol',
                                   'values': [   'disconnect',
                                                 'call-pri-lost-after-sb',
                                                 'violently-as0p']},
                               {   'default': False,
                                   'drbd_option_name': 'always-asbp',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/always-asbp",
                                   'type': 'boolean'},
                               {   'drbd_option_name': 'rr-conflict',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/rr-conflict",
                                   'type': 'symbol',
                                   'values': [   'disconnect',
                                                 'call-pri-lost',
                                                 'violently',
                                                 'retry-connect']},
                               {   'default': 5,
                                   'drbd_option_name': 'ping-timeout',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/ping-timeout",
                                   'max': 300,
                                   'min': 1,
                                   'type': 'range',
                                   'unit': '1/10 seconds',
                                   'unit_prefix': '1'},
                               {   'drbd_option_name': 'data-integrity-alg',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/data-integrity-alg",
                                   'type': 'string'},
                               {   'default': True,
                                   'drbd_option_name': 'tcp-cork',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/tcp-cork",
                                   'type': 'boolean'},
                               {   'drbd_option_name': 'on-congestion',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/on-congestion",
                                   'type': 'symbol',
                                   'values': [   'block',
                                                 'pull-ahead',
                                                 'disconnect']},
                               {   'default': 0,
                                   'drbd_option_name': 'congestion-fill',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/congestion-fill",
                                   'max': 20971520,
                                   'min': 0,
                                   'type': 'range',
                                   'unit': 'bytes',
                                   'unit_prefix': 's'},
                               {   'default': 1237,
                                   'drbd_option_name': 'congestion-extents',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/congestion-extents",
                                   'max': 65534,
                                   'min': 67,
                                   'type': 'range',
                                   'unit_prefix': '1'},
                               {   'drbd_option_name': 'csums-alg',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/csums-alg",
                                   'type': 'string'},
                               {   'default': False,
                                   'drbd_option_name': 'csums-after-crash-only',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/csums-after-crash-only",
                                   'type': 'boolean'},
                               {   'drbd_option_name': 'verify-alg',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/verify-alg",
                                   'type': 'string'},
                               {   'default': True,
                                   'drbd_option_name': 'use-rle',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/use-rle",
                                   'type': 'boolean'},
                               {   'default': 0,
                                   'drbd_option_name': 'socket-check-timeout',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/socket-check-timeout",
                                   'max': 300,
                                   'min': 0,
                                   'type': 'range',
                                   'unit_prefix': '1'},
                               {   'drbd_option_name': 'fencing',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/fencing",
                                   'type': 'symbol',
                                   'values': [   'dont-care',
                                                 'resource-only',
                                                 'resource-and-stonith']},
                               {   'default': 2048,
                                   'drbd_option_name': 'max-buffers',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/max-buffers",
                                   'max': 131072,
                                   'min': 32,
                                   'type': 'range',
                                   'unit_prefix': '1'},
                               {   'default': True,
                                   'drbd_option_name': 'allow-remote-read',
                                   'drbd_res_file_section': 'net',
                                   'internal': True,
                                   'key': "DrbdOptions/Net/allow-remote-read",
                                   'type': 'boolean'},
                               {   'drbd_option_name': 'after-resync-target',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/after-resync-target",
                                   'type': 'string'},
                               {   'drbd_option_name': 'before-resync-target',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/before-resync-target",
                                   'type': 'string'},
                               {   'drbd_option_name': 'before-resync-source',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/before-resync-source",
                                   'type': 'string'},
                               {   'drbd_option_name': 'out-of-sync',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/out-of-sync",
                                   'type': 'string'},
                               {   'drbd_option_name': 'quorum-lost',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/quorum-lost",
                                   'type': 'string'},
                               {   'drbd_option_name': 'fence-peer',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/fence-peer",
                                   'type': 'string'},
                               {   'drbd_option_name': 'unfence-peer',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/unfence-peer",
                                   'type': 'string'},
                               {   'drbd_option_name': 'initial-split-brain',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/initial-split-brain",
                                   'type': 'string'},
                               {   'drbd_option_name': 'local-io-error',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/local-io-error",
                                   'type': 'string'},
                               {   'drbd_option_name': 'pri-lost',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/pri-lost",
                                   'type': 'string'},
                               {   'drbd_option_name': 'pri-lost-after-sb',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/pri-lost-after-sb",
                                   'type': 'string'},
                               {   'drbd_option_name': 'pri-on-incon-degr',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/pri-on-incon-degr",
                                   'type': 'string'},
                               {   'drbd_option_name': 'split-brain',
                                   'drbd_res_file_section': 'handlers',
                                   'internal': True,
                                   'key': "DrbdOptions/Handlers/split-brain",
                                   'type': 'string'}],
    'rsc-conn': [   {   'default': 250,
                        'drbd_option_name': 'resync-rate',
                        'drbd_res_file_section': 'disk',
                        'internal': True,
                        'key': "DrbdOptions/PeerDevice/resync-rate",
                        'max': 8388608,
                        'min': 1,
                        'type': 'range',
                        'unit': 'bytes/second',
                        'unit_prefix': 'k'},
                    {   'default': 20,
                        'drbd_option_name': 'c-plan-ahead',
                        'drbd_res_file_section': 'disk',
                        'internal': True,
                        'key': "DrbdOptions/PeerDevice/c-plan-ahead",
                        'max': 300,
                        'min': 0,
                        'type': 'range',
                        'unit': '1/10 seconds',
                        'unit_prefix': '1'},
                    {   'default': 10,
                        'drbd_option_name': 'c-delay-target',
                        'drbd_res_file_section': 'disk',
                        'internal': True,
                        'key': "DrbdOptions/PeerDevice/c-delay-target",
                        'max': 100,
                        'min': 1,
                        'type': 'range',
                        'unit': '1/10 seconds',
                        'unit_prefix': '1'},
                    {   'default': 100,
                        'drbd_option_name': 'c-fill-target',
                        'drbd_res_file_section': 'disk',
                        'internal': True,
                        'key': "DrbdOptions/PeerDevice/c-fill-target",
                        'max': 1048576,
                        'min': 0,
                        'type': 'range',
                        'unit': 'bytes',
                        'unit_prefix': 's'},
                    {   'default': 102400,
                        'drbd_option_name': 'c-max-rate',
                        'drbd_res_file_section': 'disk',
                        'internal': True,
                        'key': "DrbdOptions/PeerDevice/c-max-rate",
                        'max': 4194304,
                        'min': 0,
                        'type': 'range',
                        'unit': 'bytes/second',
                        'unit_prefix': 'k'},
                    {   'default': 250,
                        'drbd_option_name': 'c-min-rate',
                        'drbd_res_file_section': 'disk',
                        'internal': True,
                        'key': "DrbdOptions/PeerDevice/c-min-rate",
                        'max': 4194304,
                        'min': 0,
                        'type': 'range',
                        'unit': 'bytes/second',
                        'unit_prefix': 'k'},
                    {   'default': True,
                        'drbd_option_name': 'bitmap',
                        'drbd_res_file_section': 'disk',
                        'internal': True,
                        'key': "DrbdOptions/PeerDevice/bitmap",
                        'type': 'boolean'},
                    {   'drbd_option_name': 'transport',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/transport",
                        'type': 'string'},
                    {   'drbd_option_name': 'protocol',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/protocol",
                        'type': 'symbol',
                        'values': ['A', 'B', 'C']},
                    {   'default': 60,
                        'drbd_option_name': 'timeout',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/timeout",
                        'max': 600,
                        'min': 1,
                        'type': 'range',
                        'unit': '1/10 seconds',
                        'unit_prefix': '1'},
                    {   'default': 2048,
                        'drbd_option_name': 'max-epoch-size',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/max-epoch-size",
                        'max': 20000,
                        'min': 1,
                        'type': 'range',
                        'unit_prefix': '1'},
                    {   'default': 10,
                        'drbd_option_name': 'connect-int',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/connect-int",
                        'max': 120,
                        'min': 1,
                        'type': 'range',
                        'unit': 'seconds',
                        'unit_prefix': '1'},
                    {   'default': 10,
                        'drbd_option_name': 'ping-int',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/ping-int",
                        'max': 120,
                        'min': 1,
                        'type': 'range',
                        'unit': 'seconds',
                        'unit_prefix': '1'},
                    {   'default': 0,
                        'drbd_option_name': 'sndbuf-size',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/sndbuf-size",
                        'max': 10485760,
                        'min': 0,
                        'type': 'range',
                        'unit': 'bytes',
                        'unit_prefix': '1'},
                    {   'default': 0,
                        'drbd_option_name': 'rcvbuf-size',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/rcvbuf-size",
                        'max': 10485760,
                        'min': 0,
                        'type': 'range',
                        'unit': 'bytes',
                        'unit_prefix': '1'},
                    {   'default': 7,
                        'drbd_option_name': 'ko-count',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/ko-count",
                        'max': 200,
                        'min': 0,
                        'type': 'range',
                        'unit_prefix': '1'},
                    {   'default': False,
                        'drbd_option_name': 'allow-two-primaries',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/allow-two-primaries",
                        'type': 'boolean'},
                    {   'drbd_option_name': 'cram-hmac-alg',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/cram-hmac-alg",
                        'type': 'string'},
                    {   'drbd_option_name': 'shared-secret',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/shared-secret",
                        'type': 'string'},
                    {   'drbd_option_name': 'after-sb-0pri',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/after-sb-0pri",
                        'type': 'symbol',
                        'values': [   'disconnect',
                                      'discard-younger-primary',
                                      'discard-older-primary',
                                      'discard-zero-changes',
                                      'discard-least-changes',
                                      'discard-local',
                                      'discard-remote']},
                    {   'drbd_option_name': 'after-sb-1pri',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/after-sb-1pri",
                        'type': 'symbol',
                        'values': [   'disconnect',
                                      'consensus',
                                      'discard-secondary',
                                      'call-pri-lost-after-sb',
                                      'violently-as0p']},
                    {   'drbd_option_name': 'after-sb-2pri',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/after-sb-2pri",
                        'type': 'symbol',
                        'values': [   'disconnect',
                                      'call-pri-lost-after-sb',
                                      'violently-as0p']},
                    {   'default': False,
                        'drbd_option_name': 'always-asbp',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/always-asbp",
                        'type': 'boolean'},
                    {   'drbd_option_name': 'rr-conflict',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/rr-conflict",
                        'type': 'symbol',
                        'values': [   'disconnect',
                                      'call-pri-lost',
                                      'violently',
                                      'retry-connect']},
                    {   'default': 5,
                        'drbd_option_name': 'ping-timeout',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/ping-timeout",
                        'max': 300,
                        'min': 1,
                        'type': 'range',
                        'unit': '1/10 seconds',
                        'unit_prefix': '1'},
                    {   'drbd_option_name': 'data-integrity-alg',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/data-integrity-alg",
                        'type': 'string'},
                    {   'default': True,
                        'drbd_option_name': 'tcp-cork',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/tcp-cork",
                        'type': 'boolean'},
                    {   'drbd_option_name': 'on-congestion',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/on-congestion",
                        'type': 'symbol',
                        'values': ['block', 'pull-ahead', 'disconnect']},
                    {   'default': 0,
                        'drbd_option_name': 'congestion-fill',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/congestion-fill",
                        'max': 20971520,
                        'min': 0,
                        'type': 'range',
                        'unit': 'bytes',
                        'unit_prefix': 's'},
                    {   'default': 1237,
                        'drbd_option_name': 'congestion-extents',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/congestion-extents",
                        'max': 65534,
                        'min': 67,
                        'type': 'range',
                        'unit_prefix': '1'},
                    {   'drbd_option_name': 'csums-alg',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/csums-alg",
                        'type': 'string'},
                    {   'default': False,
                        'drbd_option_name': 'csums-after-crash-only',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/csums-after-crash-only",
                        'type': 'boolean'},
                    {   'drbd_option_name': 'verify-alg',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/verify-alg",
                        'type': 'string'},
                    {   'default': True,
                        'drbd_option_name': 'use-rle',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/use-rle",
                        'type': 'boolean'},
                    {   'default': 0,
                        'drbd_option_name': 'socket-check-timeout',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/socket-check-timeout",
                        'max': 300,
                        'min': 0,
                        'type': 'range',
                        'unit_prefix': '1'},
                    {   'drbd_option_name': 'fencing',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/fencing",
                        'type': 'symbol',
                        'values': [   'dont-care',
                                      'resource-only',
                                      'resource-and-stonith']},
                    {   'default': 2048,
                        'drbd_option_name': 'max-buffers',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/max-buffers",
                        'max': 131072,
                        'min': 32,
                        'type': 'range',
                        'unit_prefix': '1'},
                    {   'default': True,
                        'drbd_option_name': 'allow-remote-read',
                        'drbd_res_file_section': 'net',
                        'internal': True,
                        'key': "DrbdOptions/Net/allow-remote-read",
                        'type': 'boolean'}],
    'storagepool': [   {   'internal': True,
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_NAME,
                           'type': 'regex',
                           'value': '[a-zA-Z0-9_/-]+'},
                       {   'internal': True,
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_VOLUME_GROUP,
                           'type': 'regex',
                           'value': '[a-zA-Z0-9_-]+'},
                       {   'internal': True,
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_THIN_POOL,
                           'type': 'regex',
                           'value': '[a-zA-Z0-9_-]+'},
                       {   'internal': True,
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_ZPOOL,
                           'type': 'regex',
                           'value': '[a-zA-Z0-9_/-]+'},
                       {   'internal': True,
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_ZPOOLTHIN,
                           'type': 'regex',
                           'value': '[a-zA-Z0-9_/-]+'},
                       {   'internal': True,
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_FILE_DIRECTORY,
                           'type': 'regex',
                           'value': '.*'},
                       {   'info': 'Preferred network interface to use',
                           'key': consts.KEY_STOR_POOL_PREF_NIC,
                           'type': 'regex',
                           'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                       {   'info': 'Preferred network interface to use',
                           'internal': False,
                           'key': consts.NAMESPC_NVME + '/' + consts.KEY_PREF_NIC,
                           'type': 'regex',
                           'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                       {   'default': 'linear',
                           'internal': True,
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_LVCREATE_TYPE,
                           'type': 'symbol',
                           'values': [   'linear',
                                         'striped',
                                         'mirror',
                                         'raid0',
                                         'raid1',
                                         'raid4',
                                         'raid5',
                                         'raid6',
                                         'raid10',
                                         'lzma',
                                         'lz4']},
                       {   'info': 'Additional parameters added to every '
                                   "'lvcreate ... ' command",
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_LVCREATE_OPTIONS,
                           'type': 'regex',
                           'value': '.*'},
                       {   'info': "Additional parameters added to every 'zfs "
                                   "create ... ' command",
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_ZFS_CREATE_OPTIONS,
                           'type': 'regex',
                           'value': '.*'},
                       {   'internal': True,
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_WAIT_TIMEOUT_AFTER_CREATE,
                           'type': 'regex',
                           'value': '[0-9]+'},
                       {   'info': 'Sets the '
                                   '/sys/fs/cgroup/blkio/blkio.throttle.read_bps_device',
                           'internal': False,
                           'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ,
                           'type': 'long'},
                       {   'info': 'Sets the '
                                   '/sys/fs/cgroup/blkio/blkio.throttle.write_bps_device',
                           'internal': False,
                           'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE,
                           'type': 'long'},
                       {   'info': 'Sets the '
                                   '/sys/fs/cgroup/blkio/blkio.throttle.read_iops_device',
                           'internal': False,
                           'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ_IOPS,
                           'type': 'long'},
                       {   'info': 'Sets the '
                                   '/sys/fs/cgroup/blkio/blkio.throttle.write_iops_device',
                           'internal': False,
                           'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE_IOPS,
                           'type': 'long'},
                       {   'info': 'Openflex API host name',
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_API_HOST,
                           'type': 'regex',
                           'value': '.+'},
                       {   'info': 'Openflex API port',
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_API_PORT,
                           'type': 'regex',
                           'value': '[0-9]+'},
                       {   'info': 'Openflex user name',
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_USER_NAME,
                           'type': 'regex',
                           'value': '.+'},
                       {   'info': 'Openflex password',
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_USER_PW,
                           'type': 'regex',
                           'value': '.+'},
                       {   'info': 'Openflex storage device',
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_STOR_DEV,
                           'type': 'regex',
                           'value': '.+'},
                       {   'info': 'Openflex storage device host',
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_STOR_DEV_HOST,
                           'type': 'regex',
                           'value': '.+'},
                       {   'info': 'Openflex storage pool name',
                           'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_OPENFLEX_STOR_POOL,
                           'type': 'regex',
                           'value': '[0-9]+'},
                       {   'info': 'linear: Volumes are created from Disk '
                                   'Groups (vdisks), virtual: Volumes are '
                                   'created from Pools which is a set of Disk '
                                   'Groups (vdisks)',
                           'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_VLM_TYPE,
                           'type': 'symbol',
                           'values': ['linear', 'virtual']},
                       {   'info': 'Any additional parameters appended to '
                                   '/create/volume/pool/${poolName}/size/${size}KiB/${vlmName}',
                           'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_CREATE_VOLUME_OPTIONS,
                           'type': 'string'},
                       {   'info': 'Name of the Exos enclosure',
                           'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_ENCLOSURE,
                           'type': 'string'},
                       {   'info': 'Serial number of the Exos pool',
                           'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_POOL_SN,
                           'type': 'string'},
                       {   'info': 'The maximum throughput the given storage '
                                   'pool is capable of.',
                           'key': consts.NAMESPC_AUTOPLACER + '/' + consts.KEY_AUTOPLACE_MAX_THROUGHPUT,
                           'type': 'long'}],
    'storagepool-definition': [   {   'info': 'Maximum allowed ratio of the '
                                              'sum of volume sizes in a thin '
                                              'pool to the total capacity of '
                                              'the pool (default 20)',
                                      'key': consts.KEY_STOR_POOL_DFN_MAX_OVERSUBSCRIPTION_RATIO,
                                      'max': 1000,
                                      'min': 1,
                                      'type': 'range'},
                                  {   'info': 'Sets the '
                                              '/sys/fs/cgroup/blkio/blkio.throttle.read_bps_device',
                                      'internal': False,
                                      'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ,
                                      'type': 'long'},
                                  {   'info': 'Sets the '
                                              '/sys/fs/cgroup/blkio/blkio.throttle.write_bps_device',
                                      'internal': False,
                                      'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE,
                                      'type': 'long'},
                                  {   'info': 'Sets the '
                                              '/sys/fs/cgroup/blkio/blkio.throttle.read_iops_device',
                                      'internal': False,
                                      'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ_IOPS,
                                      'type': 'long'},
                                  {   'info': 'Sets the '
                                              '/sys/fs/cgroup/blkio/blkio.throttle.write_iops_device',
                                      'internal': False,
                                      'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE_IOPS,
                                      'type': 'long'}],
    'volume': [   {   'info': 'Linstor storage pool name to use.',
                      'key': consts.KEY_STOR_POOL_NAME,
                      'type': 'regex',
                      'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                  {   'info': 'Linstor storage pool name to use for external '
                              'metadata.',
                      'key': consts.KEY_STOR_POOL_DRBD_META_NAME,
                      'type': 'regex',
                      'value': '^|.internal|[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                  {   'info': 'Sets the '
                              '/sys/fs/cgroup/blkio/blkio.throttle.read_bps_device',
                      'internal': False,
                      'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ,
                      'type': 'long'},
                  {   'info': 'Sets the '
                              '/sys/fs/cgroup/blkio/blkio.throttle.write_bps_device',
                      'internal': False,
                      'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE,
                      'type': 'long'},
                  {   'info': 'Sets the '
                              '/sys/fs/cgroup/blkio/blkio.throttle.read_iops_device',
                      'internal': False,
                      'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ_IOPS,
                      'type': 'long'},
                  {   'info': 'Sets the '
                              '/sys/fs/cgroup/blkio/blkio.throttle.write_iops_device',
                      'internal': False,
                      'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE_IOPS,
                      'type': 'long'}],
    'volume-definition': [   {   'info': 'Linstor storage pool name to use.',
                                 'key': consts.KEY_STOR_POOL_NAME,
                                 'type': 'regex',
                                 'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                             {   'info': 'Linstor storage pool name to use for '
                                         'external metadata.',
                                 'key': consts.KEY_STOR_POOL_DRBD_META_NAME,
                                 'type': 'regex',
                                 'value': '^|.internal|[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                             {   'info': 'Overwrites the generated '
                                         "'<resource-name>_<5 digit volume "
                                         "number>' volume name for migration "
                                         'purposes',
                                 'key': consts.KEY_STOR_POOL_OVERRIDE_VLM_ID,
                                 'type': 'regex',
                                 'value': '.*'},
                             {   'info': 'File system type to use',
                                 'internal': False,
                                 'key': consts.NAMESPC_FILESYSTEM + '/' + consts.KEY_FS_TYPE,
                                 'type': 'symbol',
                                 'values': ['ext4', 'xfs']},
                             {   'info': 'Additional parameters for the mkfs '
                                         'command',
                                 'internal': False,
                                 'key': consts.NAMESPC_FILESYSTEM + '/' + consts.KEY_FS_MKFSPARAMETERS,
                                 'type': 'string'},
                             {   'default': 'linear',
                                 'internal': True,
                                 'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_LVCREATE_TYPE,
                                 'type': 'symbol',
                                 'values': [   'linear',
                                               'striped',
                                               'mirror',
                                               'raid0',
                                               'raid1',
                                               'raid4',
                                               'raid5',
                                               'raid6',
                                               'raid10',
                                               'lzma',
                                               'lz4']},
                             {   'info': 'Additional parameters added to every '
                                         "'lvcreate ... ' command",
                                 'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_LVCREATE_OPTIONS,
                                 'type': 'regex',
                                 'value': '.*'},
                             {   'info': 'Additional parameters added to every '
                                         "'zfs create ... ' command",
                                 'key': consts.NAMESPC_STORAGE_DRIVER + '/' + consts.KEY_STOR_POOL_ZFS_CREATE_OPTIONS,
                                 'type': 'regex',
                                 'value': '.*'},
                             {   'info': 'Initial DRBD generation id, if '
                                         'initial sync is skipped, this ID '
                                         'will be set',
                                 'internal': False,
                                 'key': consts.KEY_DRBD_CURRENT_GI,
                                 'type': 'regex',
                                 'value': '[a-fA-F0-9]{16}'},
                             {   'info': 'Sets the '
                                         '/sys/fs/cgroup/blkio/blkio.throttle.read_bps_device',
                                 'internal': False,
                                 'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ,
                                 'type': 'long'},
                             {   'info': 'Sets the '
                                         '/sys/fs/cgroup/blkio/blkio.throttle.write_bps_device',
                                 'internal': False,
                                 'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE,
                                 'type': 'long'},
                             {   'info': 'Sets the '
                                         '/sys/fs/cgroup/blkio/blkio.throttle.read_iops_device',
                                 'internal': False,
                                 'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_READ_IOPS,
                                 'type': 'long'},
                             {   'info': 'Sets the '
                                         '/sys/fs/cgroup/blkio/blkio.throttle.write_iops_device',
                                 'internal': False,
                                 'key': consts.NAMESPC_SYS_FS + '/' + consts.KEY_SYS_FS_BLKIO_THROTTLE_WRITE_IOPS,
                                 'type': 'long'},
                             {   'info': 'Linstor storage pool name for '
                                         'writecache',
                                 'key': consts.NAMESPC_WRITECACHE + '/' + consts.KEY_WRITECACHE_POOL_NAME,
                                 'type': 'regex',
                                 'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                             {   'info': 'Size of the writecache in % (0-100) '
                                         'or KiB otherwise',
                                 'key': consts.NAMESPC_WRITECACHE + '/' + consts.KEY_WRITECACHE_SIZE,
                                 'type': 'regex',
                                 'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                             {   'default': '0',
                                 'info': 'offset from the start of cache '
                                         'device in 512-byte sectors',
                                 'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_START_SECTOR,
                                 'type': 'long'},
                             {   'default': '50',
                                 'info': 'start writeback when the number of '
                                         'used blocks reach this watermark',
                                 'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_HIGH_WATERMARK,
                                 'type': 'long'},
                             {   'default': '45',
                                 'info': 'stop writeback when the number of '
                                         'used blocks drops below this '
                                         'watermark',
                                 'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_LOW_WATERMARK,
                                 'type': 'long'},
                             {   'default': 'unlimited',
                                 'info': 'limit the number of blocks that are '
                                         'in flight during writeback. Setting '
                                         'this value reduces writeback '
                                         'throughput, but it may improve '
                                         'latency of read requests',
                                 'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_WRITEBACK_JOBS,
                                 'type': 'long'},
                             {   'default': '64 for pmem, 65536 for ssd',
                                 'info': 'when the application writes this '
                                         'amount of blocks without issuing the '
                                         'FLUSH request, the blocks are '
                                         'automatically committed',
                                 'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_AUTOCOMMIT_BLOCKS,
                                 'type': 'long'},
                             {   'default': '1000',
                                 'info': 'autocommit time in milliseconds. The '
                                         'data is automatically committed if '
                                         'this time passes and no FLUSH '
                                         'request is received',
                                 'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_AUTOCOMMIT_TIME,
                                 'type': 'long'},
                             {   'default': 'On',
                                 'info': '"On" results in "fua" as argument, '
                                         'whereas the value "Off" results in '
                                         '"nofua" argument',
                                 'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_FUA,
                                 'type': 'symbol',
                                 'values': ['On', 'Off']},
                             {   'info': 'Additional arguments passed through',
                                 'key': consts.NAMESPC_WRITECACHE_OPTIONS + '/' + consts.KEY_WRITECACHE_OPTION_ADDITIONAL,
                                 'type': 'string'},
                             {   'default': 'writethrough',
                                 'info': 'Operation mode',
                                 'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_OPERATING_MODE,
                                 'type': 'symbol',
                                 'values': [   'writeback',
                                               'writethrough',
                                               'passthrough']},
                             {   'info': 'Name of the storage pool used for '
                                         'the cache metadata. If not '
                                         'specified, this will default to the '
                                         'CachePool property',
                                 'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_META_POOL_NAME,
                                 'type': 'regex',
                                 'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                             {   'default': '12288',
                                 'info': 'Size of the cache in % (0-100) or '
                                         'KiB otherwise.',
                                 'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_META_SIZE,
                                 'type': 'regex',
                                 'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                             {   'info': 'Name of the storage pool used for '
                                         'the cache cache device',
                                 'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_CACHE_POOL_NAME,
                                 'type': 'regex',
                                 'value': '^[a-zA-Z0-9_][a-zA-Z0-9_-]{2,47}$'},
                             {   'default': '5%',
                                 'info': 'Size of the cache in % (0-100) or '
                                         'KiB otherwise.',
                                 'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_CACHE_SIZE,
                                 'type': 'regex',
                                 'value': '^100%|[0-9]{1,2}([.][0-9]*)?%|[1-9][0-9]{2,}$'},
                             {   'default': '4096',
                                 'info': 'Block size',
                                 'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_BLOCK_SIZE,
                                 'type': 'long'},
                             {   'default': 'smq',
                                 'info': 'Replacement policy',
                                 'key': consts.NAMESPC_CACHE + '/' + consts.KEY_CACHE_POLICY,
                                 'type': 'symbol',
                                 'values': ['mq', 'smq', 'cleaner']},
                             {   'info': 'linear: Volumes are created from '
                                         'Disk Groups (vdisks), virtual: '
                                         'Volumes are created from Pools which '
                                         'is a set of Disk Groups (vdisks)',
                                 'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_VLM_TYPE,
                                 'type': 'symbol',
                                 'values': ['linear', 'virtual']},
                             {   'info': 'Any additional parameters appended '
                                         'to '
                                         '/create/volume/pool/${poolName}/size/${size}KiB/${vlmName}',
                                 'key': consts.NAMESPC_EXOS + '/' + consts.KEY_STOR_POOL_EXOS_CREATE_VOLUME_OPTIONS,
                                 'type': 'string'},
                             {   'drbd_option_name': 'on-io-error',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/on-io-error",
                                 'type': 'symbol',
                                 'values': [   'pass_on',
                                               'call-local-io-error',
                                               'detach']},
                             {   'default': False,
                                 'drbd_option_name': 'disk-barrier',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/disk-barrier",
                                 'type': 'boolean'},
                             {   'default': True,
                                 'drbd_option_name': 'disk-flushes',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/disk-flushes",
                                 'type': 'boolean'},
                             {   'default': True,
                                 'drbd_option_name': 'disk-drain',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/disk-drain",
                                 'type': 'boolean'},
                             {   'default': True,
                                 'drbd_option_name': 'md-flushes',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/md-flushes",
                                 'type': 'boolean'},
                             {   'drbd_option_name': 'resync-after',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/resync-after",
                                 'type': 'string'},
                             {   'default': 1237,
                                 'drbd_option_name': 'al-extents',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/al-extents",
                                 'max': 65534,
                                 'min': 67,
                                 'type': 'range',
                                 'unit_prefix': '1'},
                             {   'default': True,
                                 'drbd_option_name': 'al-updates',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/al-updates",
                                 'type': 'boolean'},
                             {   'default': True,
                                 'drbd_option_name': 'discard-zeroes-if-aligned',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/discard-zeroes-if-aligned",
                                 'type': 'boolean'},
                             {   'default': False,
                                 'drbd_option_name': 'disable-write-same',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/disable-write-same",
                                 'type': 'boolean'},
                             {   'default': 0,
                                 'drbd_option_name': 'disk-timeout',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/disk-timeout",
                                 'max': 6000,
                                 'min': 0,
                                 'type': 'range',
                                 'unit': '1/10 seconds',
                                 'unit_prefix': '1'},
                             {   'drbd_option_name': 'read-balancing',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/read-balancing",
                                 'type': 'symbol',
                                 'values': [   'prefer-local',
                                               'prefer-remote',
                                               'round-robin',
                                               'least-pending',
                                               'when-congested-remote',
                                               '32K-striping',
                                               '64K-striping',
                                               '128K-striping',
                                               '256K-striping',
                                               '512K-striping',
                                               '1M-striping']},
                             {   'default': 0,
                                 'drbd_option_name': 'rs-discard-granularity',
                                 'drbd_res_file_section': 'disk',
                                 'internal': True,
                                 'key': "DrbdOptions/Disk/rs-discard-granularity",
                                 'max': 1048576,
                                 'min': 0,
                                 'type': 'range',
                                 'unit': 'bytes',
                                 'unit_prefix': '1'}]}
