import * as cdk from '@aws-cdk/core';
/**
 * Fetches data from a kubernetes cluster using jsonpath expressions.
 *
 * @schema CfnGetProps
 */
export interface CfnGetProps {
    /**
     * Name of the EKS cluster to query.
     *
     * @schema CfnGetProps#ClusterName
     */
    readonly clusterName: string;
    /**
     * Name of the kubernetes resource to query, should contain kind.
     *
     * Eg.: pod/nginx
     *
     * @schema CfnGetProps#Name
     */
    readonly name: string;
    /**
     * Kubernetes namespace containing the resource.
     *
     * @schema CfnGetProps#Namespace
     */
    readonly namespace: string;
    /**
     * Jsonpath expression to filter the output.
     *
     * @schema CfnGetProps#JsonPath
     */
    readonly jsonPath: string;
    /**
     * How many times to retry a request.
     *
     * This provides a mechanism to wait for resources to be created before proceeding. Interval between retries is 60 seconds.
     *
     * @schema CfnGetProps#Retries
     */
    readonly retries?: number;
}
/**
 * Converts an object of type 'CfnGetProps' to JSON representation.
 */
export declare function toJson_CfnGetProps(obj: CfnGetProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AWSQS::Kubernetes::Get`.
 *
 * @external
 * @cloudformationResource AWSQS::Kubernetes::Get
 * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
 */
export declare class CfnGet extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWSQS::Kubernetes::Get";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnGetProps;
    /**
     * Attribute `AWSQS::Kubernetes::Get.Response`.
     *
     * @external
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
     */
    readonly attrResponse: string;
    /**
     * Attribute `AWSQS::Kubernetes::Get.Id`.
     *
     * @external
     * @link https://github.com/aws-quickstart/quickstart-amazon-eks.git
     */
    readonly attrId: string;
    /**
     * Create a new `AWSQS::Kubernetes::Get`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGetProps);
}
