# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetRobotApplicationResult',
    'AwaitableGetRobotApplicationResult',
    'get_robot_application',
    'get_robot_application_output',
]

@pulumi.output_type
class GetRobotApplicationResult:
    def __init__(__self__, arn=None, current_revision_id=None, environment=None, robot_software_suite=None, sources=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if current_revision_id and not isinstance(current_revision_id, str):
            raise TypeError("Expected argument 'current_revision_id' to be a str")
        pulumi.set(__self__, "current_revision_id", current_revision_id)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if robot_software_suite and not isinstance(robot_software_suite, dict):
            raise TypeError("Expected argument 'robot_software_suite' to be a dict")
        pulumi.set(__self__, "robot_software_suite", robot_software_suite)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="currentRevisionId")
    def current_revision_id(self) -> Optional[str]:
        """
        The revision ID of robot application.
        """
        return pulumi.get(self, "current_revision_id")

    @property
    @pulumi.getter
    def environment(self) -> Optional[str]:
        """
        The URI of the Docker image for the robot application.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="robotSoftwareSuite")
    def robot_software_suite(self) -> Optional['outputs.RobotApplicationRobotSoftwareSuite']:
        return pulumi.get(self, "robot_software_suite")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.RobotApplicationSourceConfig']]:
        """
        The sources of the robot application.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def tags(self) -> Optional['outputs.RobotApplicationTags']:
        return pulumi.get(self, "tags")


class AwaitableGetRobotApplicationResult(GetRobotApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRobotApplicationResult(
            arn=self.arn,
            current_revision_id=self.current_revision_id,
            environment=self.environment,
            robot_software_suite=self.robot_software_suite,
            sources=self.sources,
            tags=self.tags)


def get_robot_application(arn: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRobotApplicationResult:
    """
    AWS::RoboMaker::RobotApplication resource creates an AWS RoboMaker RobotApplication. Robot application can be used in AWS RoboMaker Simulation Jobs.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:robomaker:getRobotApplication', __args__, opts=opts, typ=GetRobotApplicationResult).value

    return AwaitableGetRobotApplicationResult(
        arn=__ret__.arn,
        current_revision_id=__ret__.current_revision_id,
        environment=__ret__.environment,
        robot_software_suite=__ret__.robot_software_suite,
        sources=__ret__.sources,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_robot_application)
def get_robot_application_output(arn: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRobotApplicationResult]:
    """
    AWS::RoboMaker::RobotApplication resource creates an AWS RoboMaker RobotApplication. Robot application can be used in AWS RoboMaker Simulation Jobs.
    """
    ...
