# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DBClusterArgs', 'DBCluster']

@pulumi.input_type
class DBClusterArgs:
    def __init__(__self__, *,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DBClusterRoleArgs']]]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backtrack_window: Optional[pulumi.Input[int]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 d_b_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 d_b_cluster_instance_class: Optional[pulumi.Input[str]] = None,
                 d_b_cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 d_b_instance_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 d_b_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[str]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_http_endpoint: Optional[pulumi.Input[bool]] = None,
                 enable_iam_database_authentication: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_mode: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_user_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 read_endpoint: Optional[pulumi.Input['DBClusterReadEndpointArgs']] = None,
                 replication_source_identifier: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 scaling_configuration: Optional[pulumi.Input['DBClusterScalingConfigurationArgs']] = None,
                 serverless_v2_scaling_configuration: Optional[pulumi.Input['DBClusterServerlessV2ScalingConfigurationArgs']] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 source_region: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DBClusterTagArgs']]]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[bool]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a DBCluster resource.
        :param pulumi.Input[int] allocated_storage: The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
        :param pulumi.Input[Sequence[pulumi.Input['DBClusterRoleArgs']]] associated_roles: Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.
        :param pulumi.Input[bool] auto_minor_version_upgrade: A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on AWS Regions and Availability Zones, see Choosing the Regions and Availability Zones in the Amazon Aurora User Guide.
        :param pulumi.Input[int] backtrack_window: The target backtrack window, in seconds. To disable backtracking, set this value to 0.
        :param pulumi.Input[int] backup_retention_period: The number of days for which automated backups are retained.
        :param pulumi.Input[bool] copy_tags_to_snapshot: A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
        :param pulumi.Input[str] d_b_cluster_identifier: The DB cluster identifier. This parameter is stored as a lowercase string.
        :param pulumi.Input[str] d_b_cluster_instance_class: The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge.
        :param pulumi.Input[str] d_b_cluster_parameter_group_name: The name of the DB cluster parameter group to associate with this DB cluster.
        :param pulumi.Input[str] d_b_instance_parameter_group_name: The name of the DB parameter group to apply to all instances of the DB cluster.
        :param pulumi.Input[str] d_b_subnet_group_name: A DB subnet group that you want to associate with this DB cluster.
        :param pulumi.Input[str] database_name: The name of your database. If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see Naming Constraints in the Amazon RDS User Guide.
        :param pulumi.Input[bool] deletion_protection: A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
        :param pulumi.Input[str] domain: The Active Directory directory ID to create the DB cluster in.
        :param pulumi.Input[str] domain_iam_role_name: Specify the name of the IAM role to be used when making API calls to the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enable_cloudwatch_logs_exports: The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
        :param pulumi.Input[bool] enable_http_endpoint: A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint is disabled.
        :param pulumi.Input[bool] enable_iam_database_authentication: A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
        :param pulumi.Input[str] engine: The name of the database engine to be used for this DB cluster. Valid Values: aurora (for MySQL 5.6-compatible Aurora), aurora-mysql (for MySQL 5.7-compatible Aurora), and aurora-postgresql
        :param pulumi.Input[str] engine_mode: The DB engine mode of the DB cluster, either provisioned, serverless, parallelquery, global, or multimaster.
        :param pulumi.Input[str] engine_version: The version number of the database engine to use.
        :param pulumi.Input[str] global_cluster_identifier: If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster. To define the primary database cluster of the global cluster, use the AWS::RDS::GlobalCluster resource.
               
               If you aren't configuring a global database cluster, don't specify this property.
        :param pulumi.Input[int] iops: The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
        :param pulumi.Input[str] kms_key_id: The Amazon Resource Name (ARN) of the AWS Key Management Service master key that is used to encrypt the database instances in the DB cluster, such as arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef. If you enable the StorageEncrypted property but don't specify this property, the default master key is used. If you specify this property, you must set the StorageEncrypted property to true.
        :param pulumi.Input[str] master_user_password: The master password for the DB instance.
        :param pulumi.Input[str] master_username: The name of the master user for the DB cluster. You must specify MasterUsername, unless you specify SnapshotIdentifier. In that case, don't specify MasterUsername.
        :param pulumi.Input[int] monitoring_interval: The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.
        :param pulumi.Input[str] monitoring_role_arn: The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
        :param pulumi.Input[str] network_type: The network type of the DB cluster.
        :param pulumi.Input[bool] performance_insights_enabled: A value that indicates whether to turn on Performance Insights for the DB cluster.
        :param pulumi.Input[str] performance_insights_kms_key_id: The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
        :param pulumi.Input[int] performance_insights_retention_period: The amount of time, in days, to retain Performance Insights data.
        :param pulumi.Input[int] port: The port number on which the instances in the DB cluster accept connections. Default: 3306 if engine is set as aurora or 5432 if set to aurora-postgresql.
        :param pulumi.Input[str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see the time blocks available, see Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
        :param pulumi.Input[bool] publicly_accessible: A value that indicates whether the DB cluster is publicly accessible.
        :param pulumi.Input[str] replication_source_identifier: The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.
        :param pulumi.Input[str] restore_type: The type of restore to be performed. You can specify one of the following values:
               full-copy - The new DB cluster is restored as a full copy of the source DB cluster.
               copy-on-write - The new DB cluster is restored as a clone of the source DB cluster.
        :param pulumi.Input['DBClusterScalingConfigurationArgs'] scaling_configuration: The ScalingConfiguration property type specifies the scaling configuration of an Aurora Serverless DB cluster.
        :param pulumi.Input['DBClusterServerlessV2ScalingConfigurationArgs'] serverless_v2_scaling_configuration: Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
        :param pulumi.Input[str] snapshot_identifier: The identifier for the DB snapshot or DB cluster snapshot to restore from.
               You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
               After you restore a DB cluster with a SnapshotIdentifier property, you must specify the same SnapshotIdentifier property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the SnapshotIdentifier property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the specified SnapshotIdentifier property, and the original DB cluster is deleted.
        :param pulumi.Input[str] source_db_cluster_identifier: The identifier of the source DB cluster from which to restore.
        :param pulumi.Input[str] source_region: The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, us-east-1.
        :param pulumi.Input[bool] storage_encrypted: Indicates whether the DB instance is encrypted.
               If you specify the DBClusterIdentifier, SnapshotIdentifier, or SourceDBInstanceIdentifier property, don't specify this property. The value is inherited from the cluster, snapshot, or source DB instance.
        :param pulumi.Input[str] storage_type: Specifies the storage type to be associated with the DB cluster.
        :param pulumi.Input[Sequence[pulumi.Input['DBClusterTagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[bool] use_latest_restorable_time: A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster is not restored to the latest restorable backup time.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of EC2 VPC security groups to associate with this DB cluster.
        """
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if associated_roles is not None:
            pulumi.set(__self__, "associated_roles", associated_roles)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if backtrack_window is not None:
            pulumi.set(__self__, "backtrack_window", backtrack_window)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if copy_tags_to_snapshot is not None:
            pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if d_b_cluster_identifier is not None:
            pulumi.set(__self__, "d_b_cluster_identifier", d_b_cluster_identifier)
        if d_b_cluster_instance_class is not None:
            pulumi.set(__self__, "d_b_cluster_instance_class", d_b_cluster_instance_class)
        if d_b_cluster_parameter_group_name is not None:
            pulumi.set(__self__, "d_b_cluster_parameter_group_name", d_b_cluster_parameter_group_name)
        if d_b_instance_parameter_group_name is not None:
            pulumi.set(__self__, "d_b_instance_parameter_group_name", d_b_instance_parameter_group_name)
        if d_b_subnet_group_name is not None:
            pulumi.set(__self__, "d_b_subnet_group_name", d_b_subnet_group_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_iam_role_name is not None:
            pulumi.set(__self__, "domain_iam_role_name", domain_iam_role_name)
        if enable_cloudwatch_logs_exports is not None:
            pulumi.set(__self__, "enable_cloudwatch_logs_exports", enable_cloudwatch_logs_exports)
        if enable_http_endpoint is not None:
            pulumi.set(__self__, "enable_http_endpoint", enable_http_endpoint)
        if enable_iam_database_authentication is not None:
            pulumi.set(__self__, "enable_iam_database_authentication", enable_iam_database_authentication)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_mode is not None:
            pulumi.set(__self__, "engine_mode", engine_mode)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if global_cluster_identifier is not None:
            pulumi.set(__self__, "global_cluster_identifier", global_cluster_identifier)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if master_user_password is not None:
            pulumi.set(__self__, "master_user_password", master_user_password)
        if master_username is not None:
            pulumi.set(__self__, "master_username", master_username)
        if monitoring_interval is not None:
            pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_role_arn is not None:
            pulumi.set(__self__, "monitoring_role_arn", monitoring_role_arn)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if performance_insights_enabled is not None:
            pulumi.set(__self__, "performance_insights_enabled", performance_insights_enabled)
        if performance_insights_kms_key_id is not None:
            pulumi.set(__self__, "performance_insights_kms_key_id", performance_insights_kms_key_id)
        if performance_insights_retention_period is not None:
            pulumi.set(__self__, "performance_insights_retention_period", performance_insights_retention_period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if read_endpoint is not None:
            pulumi.set(__self__, "read_endpoint", read_endpoint)
        if replication_source_identifier is not None:
            pulumi.set(__self__, "replication_source_identifier", replication_source_identifier)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if scaling_configuration is not None:
            pulumi.set(__self__, "scaling_configuration", scaling_configuration)
        if serverless_v2_scaling_configuration is not None:
            pulumi.set(__self__, "serverless_v2_scaling_configuration", serverless_v2_scaling_configuration)
        if snapshot_identifier is not None:
            pulumi.set(__self__, "snapshot_identifier", snapshot_identifier)
        if source_db_cluster_identifier is not None:
            pulumi.set(__self__, "source_db_cluster_identifier", source_db_cluster_identifier)
        if source_region is not None:
            pulumi.set(__self__, "source_region", source_region)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter(name="associatedRoles")
    def associated_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DBClusterRoleArgs']]]]:
        """
        Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.
        """
        return pulumi.get(self, "associated_roles")

    @associated_roles.setter
    def associated_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DBClusterRoleArgs']]]]):
        pulumi.set(self, "associated_roles", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on AWS Regions and Availability Zones, see Choosing the Regions and Availability Zones in the Amazon Aurora User Guide.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="backtrackWindow")
    def backtrack_window(self) -> Optional[pulumi.Input[int]]:
        """
        The target backtrack window, in seconds. To disable backtracking, set this value to 0.
        """
        return pulumi.get(self, "backtrack_window")

    @backtrack_window.setter
    def backtrack_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backtrack_window", value)

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days for which automated backups are retained.
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retention_period", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @copy_tags_to_snapshot.setter
    def copy_tags_to_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshot", value)

    @property
    @pulumi.getter(name="dBClusterIdentifier")
    def d_b_cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The DB cluster identifier. This parameter is stored as a lowercase string.
        """
        return pulumi.get(self, "d_b_cluster_identifier")

    @d_b_cluster_identifier.setter
    def d_b_cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "d_b_cluster_identifier", value)

    @property
    @pulumi.getter(name="dBClusterInstanceClass")
    def d_b_cluster_instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge.
        """
        return pulumi.get(self, "d_b_cluster_instance_class")

    @d_b_cluster_instance_class.setter
    def d_b_cluster_instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "d_b_cluster_instance_class", value)

    @property
    @pulumi.getter(name="dBClusterParameterGroupName")
    def d_b_cluster_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DB cluster parameter group to associate with this DB cluster.
        """
        return pulumi.get(self, "d_b_cluster_parameter_group_name")

    @d_b_cluster_parameter_group_name.setter
    def d_b_cluster_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "d_b_cluster_parameter_group_name", value)

    @property
    @pulumi.getter(name="dBInstanceParameterGroupName")
    def d_b_instance_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DB parameter group to apply to all instances of the DB cluster.
        """
        return pulumi.get(self, "d_b_instance_parameter_group_name")

    @d_b_instance_parameter_group_name.setter
    def d_b_instance_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "d_b_instance_parameter_group_name", value)

    @property
    @pulumi.getter(name="dBSubnetGroupName")
    def d_b_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        A DB subnet group that you want to associate with this DB cluster.
        """
        return pulumi.get(self, "d_b_subnet_group_name")

    @d_b_subnet_group_name.setter
    def d_b_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "d_b_subnet_group_name", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of your database. If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see Naming Constraints in the Amazon RDS User Guide.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The Active Directory directory ID to create the DB cluster in.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="domainIAMRoleName")
    def domain_iam_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the name of the IAM role to be used when making API calls to the Directory Service.
        """
        return pulumi.get(self, "domain_iam_role_name")

    @domain_iam_role_name.setter
    def domain_iam_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_iam_role_name", value)

    @property
    @pulumi.getter(name="enableCloudwatchLogsExports")
    def enable_cloudwatch_logs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
        """
        return pulumi.get(self, "enable_cloudwatch_logs_exports")

    @enable_cloudwatch_logs_exports.setter
    def enable_cloudwatch_logs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enable_cloudwatch_logs_exports", value)

    @property
    @pulumi.getter(name="enableHttpEndpoint")
    def enable_http_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint is disabled.
        """
        return pulumi.get(self, "enable_http_endpoint")

    @enable_http_endpoint.setter
    def enable_http_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_http_endpoint", value)

    @property
    @pulumi.getter(name="enableIAMDatabaseAuthentication")
    def enable_iam_database_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
        """
        return pulumi.get(self, "enable_iam_database_authentication")

    @enable_iam_database_authentication.setter
    def enable_iam_database_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_iam_database_authentication", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database engine to be used for this DB cluster. Valid Values: aurora (for MySQL 5.6-compatible Aurora), aurora-mysql (for MySQL 5.7-compatible Aurora), and aurora-postgresql
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineMode")
    def engine_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The DB engine mode of the DB cluster, either provisioned, serverless, parallelquery, global, or multimaster.
        """
        return pulumi.get(self, "engine_mode")

    @engine_mode.setter
    def engine_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_mode", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version number of the database engine to use.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="globalClusterIdentifier")
    def global_cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster. To define the primary database cluster of the global cluster, use the AWS::RDS::GlobalCluster resource.

        If you aren't configuring a global database cluster, don't specify this property.
        """
        return pulumi.get(self, "global_cluster_identifier")

    @global_cluster_identifier.setter
    def global_cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_cluster_identifier", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS Key Management Service master key that is used to encrypt the database instances in the DB cluster, such as arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef. If you enable the StorageEncrypted property but don't specify this property, the default master key is used. If you specify this property, you must set the StorageEncrypted property to true.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        The master password for the DB instance.
        """
        return pulumi.get(self, "master_user_password")

    @master_user_password.setter
    def master_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_user_password", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the master user for the DB cluster. You must specify MasterUsername, unless you specify SnapshotIdentifier. In that case, don't specify MasterUsername.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.
        """
        return pulumi.get(self, "monitoring_interval")

    @monitoring_interval.setter
    def monitoring_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "monitoring_interval", value)

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @monitoring_role_arn.setter
    def monitoring_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitoring_role_arn", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The network type of the DB cluster.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="performanceInsightsEnabled")
    def performance_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether to turn on Performance Insights for the DB cluster.
        """
        return pulumi.get(self, "performance_insights_enabled")

    @performance_insights_enabled.setter
    def performance_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "performance_insights_enabled", value)

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @performance_insights_kms_key_id.setter
    def performance_insights_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_insights_kms_key_id", value)

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in days, to retain Performance Insights data.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @performance_insights_retention_period.setter
    def performance_insights_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "performance_insights_retention_period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number on which the instances in the DB cluster accept connections. Default: 3306 if engine is set as aurora or 5432 if set to aurora-postgresql.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[str]]:
        """
        The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see the time blocks available, see Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether the DB cluster is publicly accessible.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="readEndpoint")
    def read_endpoint(self) -> Optional[pulumi.Input['DBClusterReadEndpointArgs']]:
        return pulumi.get(self, "read_endpoint")

    @read_endpoint.setter
    def read_endpoint(self, value: Optional[pulumi.Input['DBClusterReadEndpointArgs']]):
        pulumi.set(self, "read_endpoint", value)

    @property
    @pulumi.getter(name="replicationSourceIdentifier")
    def replication_source_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.
        """
        return pulumi.get(self, "replication_source_identifier")

    @replication_source_identifier.setter
    def replication_source_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_source_identifier", value)

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of restore to be performed. You can specify one of the following values:
        full-copy - The new DB cluster is restored as a full copy of the source DB cluster.
        copy-on-write - The new DB cluster is restored as a clone of the source DB cluster.
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_type", value)

    @property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> Optional[pulumi.Input['DBClusterScalingConfigurationArgs']]:
        """
        The ScalingConfiguration property type specifies the scaling configuration of an Aurora Serverless DB cluster.
        """
        return pulumi.get(self, "scaling_configuration")

    @scaling_configuration.setter
    def scaling_configuration(self, value: Optional[pulumi.Input['DBClusterScalingConfigurationArgs']]):
        pulumi.set(self, "scaling_configuration", value)

    @property
    @pulumi.getter(name="serverlessV2ScalingConfiguration")
    def serverless_v2_scaling_configuration(self) -> Optional[pulumi.Input['DBClusterServerlessV2ScalingConfigurationArgs']]:
        """
        Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
        """
        return pulumi.get(self, "serverless_v2_scaling_configuration")

    @serverless_v2_scaling_configuration.setter
    def serverless_v2_scaling_configuration(self, value: Optional[pulumi.Input['DBClusterServerlessV2ScalingConfigurationArgs']]):
        pulumi.set(self, "serverless_v2_scaling_configuration", value)

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the DB snapshot or DB cluster snapshot to restore from.
        You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
        After you restore a DB cluster with a SnapshotIdentifier property, you must specify the same SnapshotIdentifier property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the SnapshotIdentifier property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the specified SnapshotIdentifier property, and the original DB cluster is deleted.
        """
        return pulumi.get(self, "snapshot_identifier")

    @snapshot_identifier.setter
    def snapshot_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_identifier", value)

    @property
    @pulumi.getter(name="sourceDBClusterIdentifier")
    def source_db_cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the source DB cluster from which to restore.
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @source_db_cluster_identifier.setter
    def source_db_cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_cluster_identifier", value)

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, us-east-1.
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_region", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the DB instance is encrypted.
        If you specify the DBClusterIdentifier, SnapshotIdentifier, or SourceDBInstanceIdentifier property, don't specify this property. The value is inherited from the cluster, snapshot, or source DB instance.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage type to be associated with the DB cluster.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DBClusterTagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DBClusterTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[pulumi.Input[bool]]:
        """
        A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster is not restored to the latest restorable backup time.
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @use_latest_restorable_time.setter
    def use_latest_restorable_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_latest_restorable_time", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of EC2 VPC security groups to associate with this DB cluster.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


class DBCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DBClusterRoleArgs']]]]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backtrack_window: Optional[pulumi.Input[int]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 d_b_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 d_b_cluster_instance_class: Optional[pulumi.Input[str]] = None,
                 d_b_cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 d_b_instance_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 d_b_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[str]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_http_endpoint: Optional[pulumi.Input[bool]] = None,
                 enable_iam_database_authentication: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_mode: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_user_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 read_endpoint: Optional[pulumi.Input[pulumi.InputType['DBClusterReadEndpointArgs']]] = None,
                 replication_source_identifier: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 scaling_configuration: Optional[pulumi.Input[pulumi.InputType['DBClusterScalingConfigurationArgs']]] = None,
                 serverless_v2_scaling_configuration: Optional[pulumi.Input[pulumi.InputType['DBClusterServerlessV2ScalingConfigurationArgs']]] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 source_region: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DBClusterTagArgs']]]]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[bool]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The AWS::RDS::DBCluster resource creates an Amazon Aurora DB cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] allocated_storage: The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DBClusterRoleArgs']]]] associated_roles: Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.
        :param pulumi.Input[bool] auto_minor_version_upgrade: A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on AWS Regions and Availability Zones, see Choosing the Regions and Availability Zones in the Amazon Aurora User Guide.
        :param pulumi.Input[int] backtrack_window: The target backtrack window, in seconds. To disable backtracking, set this value to 0.
        :param pulumi.Input[int] backup_retention_period: The number of days for which automated backups are retained.
        :param pulumi.Input[bool] copy_tags_to_snapshot: A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
        :param pulumi.Input[str] d_b_cluster_identifier: The DB cluster identifier. This parameter is stored as a lowercase string.
        :param pulumi.Input[str] d_b_cluster_instance_class: The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge.
        :param pulumi.Input[str] d_b_cluster_parameter_group_name: The name of the DB cluster parameter group to associate with this DB cluster.
        :param pulumi.Input[str] d_b_instance_parameter_group_name: The name of the DB parameter group to apply to all instances of the DB cluster.
        :param pulumi.Input[str] d_b_subnet_group_name: A DB subnet group that you want to associate with this DB cluster.
        :param pulumi.Input[str] database_name: The name of your database. If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see Naming Constraints in the Amazon RDS User Guide.
        :param pulumi.Input[bool] deletion_protection: A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
        :param pulumi.Input[str] domain: The Active Directory directory ID to create the DB cluster in.
        :param pulumi.Input[str] domain_iam_role_name: Specify the name of the IAM role to be used when making API calls to the Directory Service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enable_cloudwatch_logs_exports: The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
        :param pulumi.Input[bool] enable_http_endpoint: A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint is disabled.
        :param pulumi.Input[bool] enable_iam_database_authentication: A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
        :param pulumi.Input[str] engine: The name of the database engine to be used for this DB cluster. Valid Values: aurora (for MySQL 5.6-compatible Aurora), aurora-mysql (for MySQL 5.7-compatible Aurora), and aurora-postgresql
        :param pulumi.Input[str] engine_mode: The DB engine mode of the DB cluster, either provisioned, serverless, parallelquery, global, or multimaster.
        :param pulumi.Input[str] engine_version: The version number of the database engine to use.
        :param pulumi.Input[str] global_cluster_identifier: If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster. To define the primary database cluster of the global cluster, use the AWS::RDS::GlobalCluster resource.
               
               If you aren't configuring a global database cluster, don't specify this property.
        :param pulumi.Input[int] iops: The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
        :param pulumi.Input[str] kms_key_id: The Amazon Resource Name (ARN) of the AWS Key Management Service master key that is used to encrypt the database instances in the DB cluster, such as arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef. If you enable the StorageEncrypted property but don't specify this property, the default master key is used. If you specify this property, you must set the StorageEncrypted property to true.
        :param pulumi.Input[str] master_user_password: The master password for the DB instance.
        :param pulumi.Input[str] master_username: The name of the master user for the DB cluster. You must specify MasterUsername, unless you specify SnapshotIdentifier. In that case, don't specify MasterUsername.
        :param pulumi.Input[int] monitoring_interval: The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.
        :param pulumi.Input[str] monitoring_role_arn: The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
        :param pulumi.Input[str] network_type: The network type of the DB cluster.
        :param pulumi.Input[bool] performance_insights_enabled: A value that indicates whether to turn on Performance Insights for the DB cluster.
        :param pulumi.Input[str] performance_insights_kms_key_id: The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
        :param pulumi.Input[int] performance_insights_retention_period: The amount of time, in days, to retain Performance Insights data.
        :param pulumi.Input[int] port: The port number on which the instances in the DB cluster accept connections. Default: 3306 if engine is set as aurora or 5432 if set to aurora-postgresql.
        :param pulumi.Input[str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see the time blocks available, see Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
        :param pulumi.Input[bool] publicly_accessible: A value that indicates whether the DB cluster is publicly accessible.
        :param pulumi.Input[str] replication_source_identifier: The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.
        :param pulumi.Input[str] restore_type: The type of restore to be performed. You can specify one of the following values:
               full-copy - The new DB cluster is restored as a full copy of the source DB cluster.
               copy-on-write - The new DB cluster is restored as a clone of the source DB cluster.
        :param pulumi.Input[pulumi.InputType['DBClusterScalingConfigurationArgs']] scaling_configuration: The ScalingConfiguration property type specifies the scaling configuration of an Aurora Serverless DB cluster.
        :param pulumi.Input[pulumi.InputType['DBClusterServerlessV2ScalingConfigurationArgs']] serverless_v2_scaling_configuration: Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
        :param pulumi.Input[str] snapshot_identifier: The identifier for the DB snapshot or DB cluster snapshot to restore from.
               You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
               After you restore a DB cluster with a SnapshotIdentifier property, you must specify the same SnapshotIdentifier property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the SnapshotIdentifier property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the specified SnapshotIdentifier property, and the original DB cluster is deleted.
        :param pulumi.Input[str] source_db_cluster_identifier: The identifier of the source DB cluster from which to restore.
        :param pulumi.Input[str] source_region: The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, us-east-1.
        :param pulumi.Input[bool] storage_encrypted: Indicates whether the DB instance is encrypted.
               If you specify the DBClusterIdentifier, SnapshotIdentifier, or SourceDBInstanceIdentifier property, don't specify this property. The value is inherited from the cluster, snapshot, or source DB instance.
        :param pulumi.Input[str] storage_type: Specifies the storage type to be associated with the DB cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DBClusterTagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[bool] use_latest_restorable_time: A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster is not restored to the latest restorable backup time.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of EC2 VPC security groups to associate with this DB cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DBClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::RDS::DBCluster resource creates an Amazon Aurora DB cluster.

        :param str resource_name: The name of the resource.
        :param DBClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DBClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DBClusterRoleArgs']]]]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backtrack_window: Optional[pulumi.Input[int]] = None,
                 backup_retention_period: Optional[pulumi.Input[int]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 d_b_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 d_b_cluster_instance_class: Optional[pulumi.Input[str]] = None,
                 d_b_cluster_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 d_b_instance_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 d_b_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[str]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_http_endpoint: Optional[pulumi.Input[bool]] = None,
                 enable_iam_database_authentication: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_mode: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 iops: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 master_user_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 read_endpoint: Optional[pulumi.Input[pulumi.InputType['DBClusterReadEndpointArgs']]] = None,
                 replication_source_identifier: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 scaling_configuration: Optional[pulumi.Input[pulumi.InputType['DBClusterScalingConfigurationArgs']]] = None,
                 serverless_v2_scaling_configuration: Optional[pulumi.Input[pulumi.InputType['DBClusterServerlessV2ScalingConfigurationArgs']]] = None,
                 snapshot_identifier: Optional[pulumi.Input[str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[str]] = None,
                 source_region: Optional[pulumi.Input[str]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DBClusterTagArgs']]]]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[bool]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DBClusterArgs.__new__(DBClusterArgs)

            __props__.__dict__["allocated_storage"] = allocated_storage
            __props__.__dict__["associated_roles"] = associated_roles
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["backtrack_window"] = backtrack_window
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            __props__.__dict__["copy_tags_to_snapshot"] = copy_tags_to_snapshot
            __props__.__dict__["d_b_cluster_identifier"] = d_b_cluster_identifier
            __props__.__dict__["d_b_cluster_instance_class"] = d_b_cluster_instance_class
            __props__.__dict__["d_b_cluster_parameter_group_name"] = d_b_cluster_parameter_group_name
            __props__.__dict__["d_b_instance_parameter_group_name"] = d_b_instance_parameter_group_name
            __props__.__dict__["d_b_subnet_group_name"] = d_b_subnet_group_name
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["domain"] = domain
            __props__.__dict__["domain_iam_role_name"] = domain_iam_role_name
            __props__.__dict__["enable_cloudwatch_logs_exports"] = enable_cloudwatch_logs_exports
            __props__.__dict__["enable_http_endpoint"] = enable_http_endpoint
            __props__.__dict__["enable_iam_database_authentication"] = enable_iam_database_authentication
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_mode"] = engine_mode
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["global_cluster_identifier"] = global_cluster_identifier
            __props__.__dict__["iops"] = iops
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["master_user_password"] = master_user_password
            __props__.__dict__["master_username"] = master_username
            __props__.__dict__["monitoring_interval"] = monitoring_interval
            __props__.__dict__["monitoring_role_arn"] = monitoring_role_arn
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["performance_insights_enabled"] = performance_insights_enabled
            __props__.__dict__["performance_insights_kms_key_id"] = performance_insights_kms_key_id
            __props__.__dict__["performance_insights_retention_period"] = performance_insights_retention_period
            __props__.__dict__["port"] = port
            __props__.__dict__["preferred_backup_window"] = preferred_backup_window
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["read_endpoint"] = read_endpoint
            __props__.__dict__["replication_source_identifier"] = replication_source_identifier
            __props__.__dict__["restore_type"] = restore_type
            __props__.__dict__["scaling_configuration"] = scaling_configuration
            __props__.__dict__["serverless_v2_scaling_configuration"] = serverless_v2_scaling_configuration
            __props__.__dict__["snapshot_identifier"] = snapshot_identifier
            __props__.__dict__["source_db_cluster_identifier"] = source_db_cluster_identifier
            __props__.__dict__["source_region"] = source_region
            __props__.__dict__["storage_encrypted"] = storage_encrypted
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_latest_restorable_time"] = use_latest_restorable_time
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["d_b_cluster_arn"] = None
            __props__.__dict__["d_b_cluster_resource_id"] = None
            __props__.__dict__["endpoint"] = None
        super(DBCluster, __self__).__init__(
            'aws-native:rds:DBCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DBCluster':
        """
        Get an existing DBCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DBClusterArgs.__new__(DBClusterArgs)

        __props__.__dict__["allocated_storage"] = None
        __props__.__dict__["associated_roles"] = None
        __props__.__dict__["auto_minor_version_upgrade"] = None
        __props__.__dict__["availability_zones"] = None
        __props__.__dict__["backtrack_window"] = None
        __props__.__dict__["backup_retention_period"] = None
        __props__.__dict__["copy_tags_to_snapshot"] = None
        __props__.__dict__["d_b_cluster_arn"] = None
        __props__.__dict__["d_b_cluster_identifier"] = None
        __props__.__dict__["d_b_cluster_instance_class"] = None
        __props__.__dict__["d_b_cluster_parameter_group_name"] = None
        __props__.__dict__["d_b_cluster_resource_id"] = None
        __props__.__dict__["d_b_instance_parameter_group_name"] = None
        __props__.__dict__["d_b_subnet_group_name"] = None
        __props__.__dict__["database_name"] = None
        __props__.__dict__["deletion_protection"] = None
        __props__.__dict__["domain"] = None
        __props__.__dict__["domain_iam_role_name"] = None
        __props__.__dict__["enable_cloudwatch_logs_exports"] = None
        __props__.__dict__["enable_http_endpoint"] = None
        __props__.__dict__["enable_iam_database_authentication"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["engine_mode"] = None
        __props__.__dict__["engine_version"] = None
        __props__.__dict__["global_cluster_identifier"] = None
        __props__.__dict__["iops"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["master_user_password"] = None
        __props__.__dict__["master_username"] = None
        __props__.__dict__["monitoring_interval"] = None
        __props__.__dict__["monitoring_role_arn"] = None
        __props__.__dict__["network_type"] = None
        __props__.__dict__["performance_insights_enabled"] = None
        __props__.__dict__["performance_insights_kms_key_id"] = None
        __props__.__dict__["performance_insights_retention_period"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["preferred_backup_window"] = None
        __props__.__dict__["preferred_maintenance_window"] = None
        __props__.__dict__["publicly_accessible"] = None
        __props__.__dict__["read_endpoint"] = None
        __props__.__dict__["replication_source_identifier"] = None
        __props__.__dict__["restore_type"] = None
        __props__.__dict__["scaling_configuration"] = None
        __props__.__dict__["serverless_v2_scaling_configuration"] = None
        __props__.__dict__["snapshot_identifier"] = None
        __props__.__dict__["source_db_cluster_identifier"] = None
        __props__.__dict__["source_region"] = None
        __props__.__dict__["storage_encrypted"] = None
        __props__.__dict__["storage_type"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["use_latest_restorable_time"] = None
        __props__.__dict__["vpc_security_group_ids"] = None
        return DBCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
        """
        return pulumi.get(self, "allocated_storage")

    @property
    @pulumi.getter(name="associatedRoles")
    def associated_roles(self) -> pulumi.Output[Optional[Sequence['outputs.DBClusterRole']]]:
        """
        Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf.
        """
        return pulumi.get(self, "associated_roles")

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on AWS Regions and Availability Zones, see Choosing the Regions and Availability Zones in the Amazon Aurora User Guide.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="backtrackWindow")
    def backtrack_window(self) -> pulumi.Output[Optional[int]]:
        """
        The target backtrack window, in seconds. To disable backtracking, set this value to 0.
        """
        return pulumi.get(self, "backtrack_window")

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        The number of days for which automated backups are retained.
        """
        return pulumi.get(self, "backup_retention_period")

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @property
    @pulumi.getter(name="dBClusterArn")
    def d_b_cluster_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for the DB cluster.
        """
        return pulumi.get(self, "d_b_cluster_arn")

    @property
    @pulumi.getter(name="dBClusterIdentifier")
    def d_b_cluster_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The DB cluster identifier. This parameter is stored as a lowercase string.
        """
        return pulumi.get(self, "d_b_cluster_identifier")

    @property
    @pulumi.getter(name="dBClusterInstanceClass")
    def d_b_cluster_instance_class(self) -> pulumi.Output[Optional[str]]:
        """
        The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge.
        """
        return pulumi.get(self, "d_b_cluster_instance_class")

    @property
    @pulumi.getter(name="dBClusterParameterGroupName")
    def d_b_cluster_parameter_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the DB cluster parameter group to associate with this DB cluster.
        """
        return pulumi.get(self, "d_b_cluster_parameter_group_name")

    @property
    @pulumi.getter(name="dBClusterResourceId")
    def d_b_cluster_resource_id(self) -> pulumi.Output[str]:
        """
        The AWS Region-unique, immutable identifier for the DB cluster.
        """
        return pulumi.get(self, "d_b_cluster_resource_id")

    @property
    @pulumi.getter(name="dBInstanceParameterGroupName")
    def d_b_instance_parameter_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the DB parameter group to apply to all instances of the DB cluster.
        """
        return pulumi.get(self, "d_b_instance_parameter_group_name")

    @property
    @pulumi.getter(name="dBSubnetGroupName")
    def d_b_subnet_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        A DB subnet group that you want to associate with this DB cluster.
        """
        return pulumi.get(self, "d_b_subnet_group_name")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of your database. If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see Naming Constraints in the Amazon RDS User Guide.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[str]]:
        """
        The Active Directory directory ID to create the DB cluster in.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainIAMRoleName")
    def domain_iam_role_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specify the name of the IAM role to be used when making API calls to the Directory Service.
        """
        return pulumi.get(self, "domain_iam_role_name")

    @property
    @pulumi.getter(name="enableCloudwatchLogsExports")
    def enable_cloudwatch_logs_exports(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
        """
        return pulumi.get(self, "enable_cloudwatch_logs_exports")

    @property
    @pulumi.getter(name="enableHttpEndpoint")
    def enable_http_endpoint(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint is disabled.
        """
        return pulumi.get(self, "enable_http_endpoint")

    @property
    @pulumi.getter(name="enableIAMDatabaseAuthentication")
    def enable_iam_database_authentication(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
        """
        return pulumi.get(self, "enable_iam_database_authentication")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output['outputs.DBClusterEndpoint']:
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the database engine to be used for this DB cluster. Valid Values: aurora (for MySQL 5.6-compatible Aurora), aurora-mysql (for MySQL 5.7-compatible Aurora), and aurora-postgresql
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineMode")
    def engine_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The DB engine mode of the DB cluster, either provisioned, serverless, parallelquery, global, or multimaster.
        """
        return pulumi.get(self, "engine_mode")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[str]]:
        """
        The version number of the database engine to use.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="globalClusterIdentifier")
    def global_cluster_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster. To define the primary database cluster of the global cluster, use the AWS::RDS::GlobalCluster resource.

        If you aren't configuring a global database cluster, don't specify this property.
        """
        return pulumi.get(self, "global_cluster_identifier")

    @property
    @pulumi.getter
    def iops(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS Key Management Service master key that is used to encrypt the database instances in the DB cluster, such as arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef. If you enable the StorageEncrypted property but don't specify this property, the default master key is used. If you specify this property, you must set the StorageEncrypted property to true.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> pulumi.Output[Optional[str]]:
        """
        The master password for the DB instance.
        """
        return pulumi.get(self, "master_user_password")

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the master user for the DB cluster. You must specify MasterUsername, unless you specify SnapshotIdentifier. In that case, don't specify MasterUsername.
        """
        return pulumi.get(self, "master_username")

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> pulumi.Output[Optional[int]]:
        """
        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.
        """
        return pulumi.get(self, "monitoring_interval")

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[Optional[str]]:
        """
        The network type of the DB cluster.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="performanceInsightsEnabled")
    def performance_insights_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that indicates whether to turn on Performance Insights for the DB cluster.
        """
        return pulumi.get(self, "performance_insights_enabled")

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of time, in days, to retain Performance Insights data.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        The port number on which the instances in the DB cluster accept connections. Default: 3306 if engine is set as aurora or 5432 if set to aurora-postgresql.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> pulumi.Output[Optional[str]]:
        """
        The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. To see the time blocks available, see Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
        """
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[Optional[str]]:
        """
        The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that indicates whether the DB cluster is publicly accessible.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="readEndpoint")
    def read_endpoint(self) -> pulumi.Output[Optional['outputs.DBClusterReadEndpoint']]:
        return pulumi.get(self, "read_endpoint")

    @property
    @pulumi.getter(name="replicationSourceIdentifier")
    def replication_source_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.
        """
        return pulumi.get(self, "replication_source_identifier")

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of restore to be performed. You can specify one of the following values:
        full-copy - The new DB cluster is restored as a full copy of the source DB cluster.
        copy-on-write - The new DB cluster is restored as a clone of the source DB cluster.
        """
        return pulumi.get(self, "restore_type")

    @property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> pulumi.Output[Optional['outputs.DBClusterScalingConfiguration']]:
        """
        The ScalingConfiguration property type specifies the scaling configuration of an Aurora Serverless DB cluster.
        """
        return pulumi.get(self, "scaling_configuration")

    @property
    @pulumi.getter(name="serverlessV2ScalingConfiguration")
    def serverless_v2_scaling_configuration(self) -> pulumi.Output[Optional['outputs.DBClusterServerlessV2ScalingConfiguration']]:
        """
        Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
        """
        return pulumi.get(self, "serverless_v2_scaling_configuration")

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the DB snapshot or DB cluster snapshot to restore from.
        You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
        After you restore a DB cluster with a SnapshotIdentifier property, you must specify the same SnapshotIdentifier property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the SnapshotIdentifier property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, the DB cluster is restored from the specified SnapshotIdentifier property, and the original DB cluster is deleted.
        """
        return pulumi.get(self, "snapshot_identifier")

    @property
    @pulumi.getter(name="sourceDBClusterIdentifier")
    def source_db_cluster_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier of the source DB cluster from which to restore.
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> pulumi.Output[Optional[str]]:
        """
        The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, us-east-1.
        """
        return pulumi.get(self, "source_region")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the DB instance is encrypted.
        If you specify the DBClusterIdentifier, SnapshotIdentifier, or SourceDBInstanceIdentifier property, don't specify this property. The value is inherited from the cluster, snapshot, or source DB instance.
        """
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the storage type to be associated with the DB cluster.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.DBClusterTag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> pulumi.Output[Optional[bool]]:
        """
        A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster is not restored to the latest restorable backup time.
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of EC2 VPC security groups to associate with this DB cluster.
        """
        return pulumi.get(self, "vpc_security_group_ids")

