# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SchemaVersionMetadataArgs', 'SchemaVersionMetadata']

@pulumi.input_type
class SchemaVersionMetadataArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 schema_version_id: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        The set of arguments for constructing a SchemaVersionMetadata resource.
        :param pulumi.Input[str] key: Metadata key
        :param pulumi.Input[str] schema_version_id: Represents the version ID associated with the schema version.
        :param pulumi.Input[str] value: Metadata value
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "schema_version_id", schema_version_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Metadata key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="schemaVersionId")
    def schema_version_id(self) -> pulumi.Input[str]:
        """
        Represents the version ID associated with the schema version.
        """
        return pulumi.get(self, "schema_version_id")

    @schema_version_id.setter
    def schema_version_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema_version_id", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Metadata value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


class SchemaVersionMetadata(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 schema_version_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource adds Key-Value metadata to a Schema version of Glue Schema Registry.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: Metadata key
        :param pulumi.Input[str] schema_version_id: Represents the version ID associated with the schema version.
        :param pulumi.Input[str] value: Metadata value
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchemaVersionMetadataArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource adds Key-Value metadata to a Schema version of Glue Schema Registry.

        :param str resource_name: The name of the resource.
        :param SchemaVersionMetadataArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchemaVersionMetadataArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 schema_version_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchemaVersionMetadataArgs.__new__(SchemaVersionMetadataArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if schema_version_id is None and not opts.urn:
                raise TypeError("Missing required property 'schema_version_id'")
            __props__.__dict__["schema_version_id"] = schema_version_id
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(SchemaVersionMetadata, __self__).__init__(
            'aws-native:glue:SchemaVersionMetadata',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SchemaVersionMetadata':
        """
        Get an existing SchemaVersionMetadata resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SchemaVersionMetadataArgs.__new__(SchemaVersionMetadataArgs)

        __props__.__dict__["key"] = None
        __props__.__dict__["schema_version_id"] = None
        __props__.__dict__["value"] = None
        return SchemaVersionMetadata(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        Metadata key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="schemaVersionId")
    def schema_version_id(self) -> pulumi.Output[str]:
        """
        Represents the version ID associated with the schema version.
        """
        return pulumi.get(self, "schema_version_id")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        Metadata value
        """
        return pulumi.get(self, "value")

