# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SetPdfFormFieldsRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'field_values': 'list[SetFormFieldValue]',
        'input_file_bytes': 'str'
    }

    attribute_map = {
        'field_values': 'FieldValues',
        'input_file_bytes': 'InputFileBytes'
    }

    def __init__(self, field_values=None, input_file_bytes=None):  # noqa: E501
        """SetPdfFormFieldsRequest - a model defined in Swagger"""  # noqa: E501

        self._field_values = None
        self._input_file_bytes = None
        self.discriminator = None

        if field_values is not None:
            self.field_values = field_values
        if input_file_bytes is not None:
            self.input_file_bytes = input_file_bytes

    @property
    def field_values(self):
        """Gets the field_values of this SetPdfFormFieldsRequest.  # noqa: E501

        Field values to set  # noqa: E501

        :return: The field_values of this SetPdfFormFieldsRequest.  # noqa: E501
        :rtype: list[SetFormFieldValue]
        """
        return self._field_values

    @field_values.setter
    def field_values(self, field_values):
        """Sets the field_values of this SetPdfFormFieldsRequest.

        Field values to set  # noqa: E501

        :param field_values: The field_values of this SetPdfFormFieldsRequest.  # noqa: E501
        :type: list[SetFormFieldValue]
        """

        self._field_values = field_values

    @property
    def input_file_bytes(self):
        """Gets the input_file_bytes of this SetPdfFormFieldsRequest.  # noqa: E501

        Contents of the input file to set the fields on  # noqa: E501

        :return: The input_file_bytes of this SetPdfFormFieldsRequest.  # noqa: E501
        :rtype: str
        """
        return self._input_file_bytes

    @input_file_bytes.setter
    def input_file_bytes(self, input_file_bytes):
        """Sets the input_file_bytes of this SetPdfFormFieldsRequest.

        Contents of the input file to set the fields on  # noqa: E501

        :param input_file_bytes: The input_file_bytes of this SetPdfFormFieldsRequest.  # noqa: E501
        :type: str
        """
        if input_file_bytes is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', input_file_bytes):  # noqa: E501
            raise ValueError(r"Invalid value for `input_file_bytes`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._input_file_bytes = input_file_bytes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SetPdfFormFieldsRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SetPdfFormFieldsRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
