# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class AddPdfAnnotationRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'input_file_bytes': 'str',
        'annotations_to_add': 'list[PdfAnnotation]'
    }

    attribute_map = {
        'input_file_bytes': 'InputFileBytes',
        'annotations_to_add': 'AnnotationsToAdd'
    }

    def __init__(self, input_file_bytes=None, annotations_to_add=None):  # noqa: E501
        """AddPdfAnnotationRequest - a model defined in Swagger"""  # noqa: E501

        self._input_file_bytes = None
        self._annotations_to_add = None
        self.discriminator = None

        if input_file_bytes is not None:
            self.input_file_bytes = input_file_bytes
        if annotations_to_add is not None:
            self.annotations_to_add = annotations_to_add

    @property
    def input_file_bytes(self):
        """Gets the input_file_bytes of this AddPdfAnnotationRequest.  # noqa: E501

        Input file contents bytes for the file to modify  # noqa: E501

        :return: The input_file_bytes of this AddPdfAnnotationRequest.  # noqa: E501
        :rtype: str
        """
        return self._input_file_bytes

    @input_file_bytes.setter
    def input_file_bytes(self, input_file_bytes):
        """Sets the input_file_bytes of this AddPdfAnnotationRequest.

        Input file contents bytes for the file to modify  # noqa: E501

        :param input_file_bytes: The input_file_bytes of this AddPdfAnnotationRequest.  # noqa: E501
        :type: str
        """
        if input_file_bytes is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', input_file_bytes):  # noqa: E501
            raise ValueError(r"Invalid value for `input_file_bytes`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._input_file_bytes = input_file_bytes

    @property
    def annotations_to_add(self):
        """Gets the annotations_to_add of this AddPdfAnnotationRequest.  # noqa: E501

        Annotations to add to the PDF file  # noqa: E501

        :return: The annotations_to_add of this AddPdfAnnotationRequest.  # noqa: E501
        :rtype: list[PdfAnnotation]
        """
        return self._annotations_to_add

    @annotations_to_add.setter
    def annotations_to_add(self, annotations_to_add):
        """Sets the annotations_to_add of this AddPdfAnnotationRequest.

        Annotations to add to the PDF file  # noqa: E501

        :param annotations_to_add: The annotations_to_add of this AddPdfAnnotationRequest.  # noqa: E501
        :type: list[PdfAnnotation]
        """

        self._annotations_to_add = annotations_to_add

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AddPdfAnnotationRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddPdfAnnotationRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
