# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudmersive_convert_api_client.api_client import ApiClient


class EditHtmlApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def edit_html_html_append_header_tag(self, html_tag, **kwargs):  # noqa: E501
        """Append an HTML tag to the HEAD section of an HTML Document  # noqa: E501

        Appends an HTML tag to the HEAD section of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_append_header_tag(html_tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str html_tag: The HTML tag to append. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_append_header_tag_with_http_info(html_tag, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_append_header_tag_with_http_info(html_tag, **kwargs)  # noqa: E501
            return data

    def edit_html_html_append_header_tag_with_http_info(self, html_tag, **kwargs):  # noqa: E501
        """Append an HTML tag to the HEAD section of an HTML Document  # noqa: E501

        Appends an HTML tag to the HEAD section of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_append_header_tag_with_http_info(html_tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str html_tag: The HTML tag to append. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['html_tag', 'input_file', 'input_file_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_append_header_tag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'html_tag' is set
        if ('html_tag' not in params or
                params['html_tag'] is None):
            raise ValueError("Missing the required parameter `html_tag` when calling `edit_html_html_append_header_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501
        if 'html_tag' in params:
            header_params['htmlTag'] = params['html_tag']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/head/append/tag', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_append_heading(self, heading_text, **kwargs):  # noqa: E501
        """Append a Heading to an HTML Document  # noqa: E501

        Appends a heading to the end of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_append_heading(heading_text, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str heading_text: The text content to be used in the header. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :param int heading_size: Optional: The heading size number. Default is 1. Accepts values between 1 and 6.
        :param str css_style: Optional: The CSS style for the heading.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_append_heading_with_http_info(heading_text, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_append_heading_with_http_info(heading_text, **kwargs)  # noqa: E501
            return data

    def edit_html_html_append_heading_with_http_info(self, heading_text, **kwargs):  # noqa: E501
        """Append a Heading to an HTML Document  # noqa: E501

        Appends a heading to the end of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_append_heading_with_http_info(heading_text, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str heading_text: The text content to be used in the header. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :param int heading_size: Optional: The heading size number. Default is 1. Accepts values between 1 and 6.
        :param str css_style: Optional: The CSS style for the heading.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['heading_text', 'input_file', 'input_file_url', 'heading_size', 'css_style']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_append_heading" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'heading_text' is set
        if ('heading_text' not in params or
                params['heading_text'] is None):
            raise ValueError("Missing the required parameter `heading_text` when calling `edit_html_html_append_heading`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501
        if 'heading_text' in params:
            header_params['headingText'] = params['heading_text']  # noqa: E501
        if 'heading_size' in params:
            header_params['headingSize'] = params['heading_size']  # noqa: E501
        if 'css_style' in params:
            header_params['cssStyle'] = params['css_style']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/append/heading', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_append_image_from_url(self, image_url, **kwargs):  # noqa: E501
        """Append an Image to an HTML Document from a URL  # noqa: E501

        Appends an image to the end of an HTML document using a URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_append_image_from_url(image_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_url: The URL for the image. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :param str css_style: Optional: CSS style for the image.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_append_image_from_url_with_http_info(image_url, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_append_image_from_url_with_http_info(image_url, **kwargs)  # noqa: E501
            return data

    def edit_html_html_append_image_from_url_with_http_info(self, image_url, **kwargs):  # noqa: E501
        """Append an Image to an HTML Document from a URL  # noqa: E501

        Appends an image to the end of an HTML document using a URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_append_image_from_url_with_http_info(image_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_url: The URL for the image. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :param str css_style: Optional: CSS style for the image.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_url', 'input_file', 'input_file_url', 'css_style']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_append_image_from_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_url' is set
        if ('image_url' not in params or
                params['image_url'] is None):
            raise ValueError("Missing the required parameter `image_url` when calling `edit_html_html_append_image_from_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501
        if 'image_url' in params:
            header_params['imageUrl'] = params['image_url']  # noqa: E501
        if 'css_style' in params:
            header_params['cssStyle'] = params['css_style']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/append/image/from-url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_append_image_inline(self, **kwargs):  # noqa: E501
        """Append a Base64 Inline Image to an HTML Document  # noqa: E501

        Appends a base64 inline image to the end of an HTML document from an input file or URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_append_image_inline(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :param file image_file: Optional: Image file to be appended as base64 inline image.
        :param str image_url: Optional: Image URL to be appended as base64 inline image.
        :param str css_style: Optional: CSS style for the image.
        :param str image_extension: Optional: The extension (JPG, PNG, GIF, etc.) of the image file. Recommended if uploading an imageFile directly, instead of using imageUrl. If no extension can be determined, will default to JPG.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_append_image_inline_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_append_image_inline_with_http_info(**kwargs)  # noqa: E501
            return data

    def edit_html_html_append_image_inline_with_http_info(self, **kwargs):  # noqa: E501
        """Append a Base64 Inline Image to an HTML Document  # noqa: E501

        Appends a base64 inline image to the end of an HTML document from an input file or URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_append_image_inline_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :param file image_file: Optional: Image file to be appended as base64 inline image.
        :param str image_url: Optional: Image URL to be appended as base64 inline image.
        :param str css_style: Optional: CSS style for the image.
        :param str image_extension: Optional: The extension (JPG, PNG, GIF, etc.) of the image file. Recommended if uploading an imageFile directly, instead of using imageUrl. If no extension can be determined, will default to JPG.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'input_file_url', 'image_file', 'image_url', 'css_style', 'image_extension']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_append_image_inline" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501
        if 'image_url' in params:
            header_params['imageUrl'] = params['image_url']  # noqa: E501
        if 'css_style' in params:
            header_params['cssStyle'] = params['css_style']  # noqa: E501
        if 'image_extension' in params:
            header_params['imageExtension'] = params['image_extension']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501
        if 'image_file' in params:
            local_var_files['imageFile'] = params['image_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/append/image/inline', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_append_paragraph(self, paragraph_text, **kwargs):  # noqa: E501
        """Append a Paragraph to an HTML Document  # noqa: E501

        Appends a paragraph to the end of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_append_paragraph(paragraph_text, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str paragraph_text: The text content to be used in the paragraph. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :param str css_style: Optional: The CSS style for the paragraph.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_append_paragraph_with_http_info(paragraph_text, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_append_paragraph_with_http_info(paragraph_text, **kwargs)  # noqa: E501
            return data

    def edit_html_html_append_paragraph_with_http_info(self, paragraph_text, **kwargs):  # noqa: E501
        """Append a Paragraph to an HTML Document  # noqa: E501

        Appends a paragraph to the end of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_append_paragraph_with_http_info(paragraph_text, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str paragraph_text: The text content to be used in the paragraph. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :param str css_style: Optional: The CSS style for the paragraph.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['paragraph_text', 'input_file', 'input_file_url', 'css_style']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_append_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'paragraph_text' is set
        if ('paragraph_text' not in params or
                params['paragraph_text'] is None):
            raise ValueError("Missing the required parameter `paragraph_text` when calling `edit_html_html_append_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501
        if 'paragraph_text' in params:
            header_params['paragraphText'] = params['paragraph_text']  # noqa: E501
        if 'css_style' in params:
            header_params['cssStyle'] = params['css_style']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/append/paragraph', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_create_blank_document(self, **kwargs):  # noqa: E501
        """Create a Blank HTML Document  # noqa: E501

        Returns a blank HTML Document format file.  The file is blank, with no contents by default.  Use the optional input parameters to add various starting elements.  Use additional editing commands such as Append Header, Append Paragraph or Append Image from URL to populate the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_create_blank_document(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str title: Optional: The title of the HTML document
        :param str css_url: Optional: A CSS style URL to be added to the document.
        :param str css_inline: Optional: An inline CSS style to be added to the document.
        :param str javascript_url: Optional: Javascript URL to be added to the document.
        :param str javascript_inline: Optional: Inline Javascript to be added to the document.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_create_blank_document_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_create_blank_document_with_http_info(**kwargs)  # noqa: E501
            return data

    def edit_html_html_create_blank_document_with_http_info(self, **kwargs):  # noqa: E501
        """Create a Blank HTML Document  # noqa: E501

        Returns a blank HTML Document format file.  The file is blank, with no contents by default.  Use the optional input parameters to add various starting elements.  Use additional editing commands such as Append Header, Append Paragraph or Append Image from URL to populate the document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_create_blank_document_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str title: Optional: The title of the HTML document
        :param str css_url: Optional: A CSS style URL to be added to the document.
        :param str css_inline: Optional: An inline CSS style to be added to the document.
        :param str javascript_url: Optional: Javascript URL to be added to the document.
        :param str javascript_inline: Optional: Inline Javascript to be added to the document.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['title', 'css_url', 'css_inline', 'javascript_url', 'javascript_inline']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_create_blank_document" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'title' in params:
            header_params['title'] = params['title']  # noqa: E501
        if 'css_url' in params:
            header_params['cssUrl'] = params['css_url']  # noqa: E501
        if 'css_inline' in params:
            header_params['cssInline'] = params['css_inline']  # noqa: E501
        if 'javascript_url' in params:
            header_params['javascriptUrl'] = params['javascript_url']  # noqa: E501
        if 'javascript_inline' in params:
            header_params['javascriptInline'] = params['javascript_inline']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/create/blank', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_get_language(self, **kwargs):  # noqa: E501
        """Gets the language for the HTML document  # noqa: E501

        Retrieves the language code (e.g. \"en\" or \"de\") of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_get_language(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: HtmlGetLanguageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_get_language_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_get_language_with_http_info(**kwargs)  # noqa: E501
            return data

    def edit_html_html_get_language_with_http_info(self, **kwargs):  # noqa: E501
        """Gets the language for the HTML document  # noqa: E501

        Retrieves the language code (e.g. \"en\" or \"de\") of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_get_language_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: HtmlGetLanguageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'input_file_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_get_language" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/head/get/language', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HtmlGetLanguageResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_get_links(self, **kwargs):  # noqa: E501
        """Extract resolved link URLs from HTML File  # noqa: E501

        Extracts the resolved link URLs, fully-qualified if possible, from an input HTML file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_get_links(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :param str base_url: Optional: Base URL of the page, such as https://mydomain.com
        :return: HtmlGetLinksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_get_links_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_get_links_with_http_info(**kwargs)  # noqa: E501
            return data

    def edit_html_html_get_links_with_http_info(self, **kwargs):  # noqa: E501
        """Extract resolved link URLs from HTML File  # noqa: E501

        Extracts the resolved link URLs, fully-qualified if possible, from an input HTML file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_get_links_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :param str base_url: Optional: Base URL of the page, such as https://mydomain.com
        :return: HtmlGetLinksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'input_file_url', 'base_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_get_links" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501
        if 'base_url' in params:
            header_params['baseUrl'] = params['base_url']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/extract/links', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HtmlGetLinksResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_get_rel_canonical(self, **kwargs):  # noqa: E501
        """Gets the rel canonical URL for the HTML document  # noqa: E501

        Gets the rel canonical URL of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_get_rel_canonical(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: HtmlGetRelCanonicalUrlResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_get_rel_canonical_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_get_rel_canonical_with_http_info(**kwargs)  # noqa: E501
            return data

    def edit_html_html_get_rel_canonical_with_http_info(self, **kwargs):  # noqa: E501
        """Gets the rel canonical URL for the HTML document  # noqa: E501

        Gets the rel canonical URL of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_get_rel_canonical_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: HtmlGetRelCanonicalUrlResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'input_file_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_get_rel_canonical" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/head/get/rel-canonical-url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HtmlGetRelCanonicalUrlResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_get_sitemap(self, **kwargs):  # noqa: E501
        """Gets the sitemap URL for the HTML document  # noqa: E501

        Gets the sitemap link URL of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_get_sitemap(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: HtmlGetSitemapUrlResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_get_sitemap_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_get_sitemap_with_http_info(**kwargs)  # noqa: E501
            return data

    def edit_html_html_get_sitemap_with_http_info(self, **kwargs):  # noqa: E501
        """Gets the sitemap URL for the HTML document  # noqa: E501

        Gets the sitemap link URL of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_get_sitemap_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: HtmlGetSitemapUrlResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['input_file', 'input_file_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_get_sitemap" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/head/get/sitemap-url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HtmlGetSitemapUrlResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_set_language(self, language_code, **kwargs):  # noqa: E501
        """Sets the language for the HTML document  # noqa: E501

        Sets the language code of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_set_language(language_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str language_code: The HTML langauge code to set. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_set_language_with_http_info(language_code, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_set_language_with_http_info(language_code, **kwargs)  # noqa: E501
            return data

    def edit_html_html_set_language_with_http_info(self, language_code, **kwargs):  # noqa: E501
        """Sets the language for the HTML document  # noqa: E501

        Sets the language code of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_set_language_with_http_info(language_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str language_code: The HTML langauge code to set. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['language_code', 'input_file', 'input_file_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_set_language" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params or
                params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `edit_html_html_set_language`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501
        if 'language_code' in params:
            header_params['languageCode'] = params['language_code']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/head/set/language', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_set_rel_canonical(self, canonical_url, **kwargs):  # noqa: E501
        """Sets the rel canonical URL for the HTML document  # noqa: E501

        Sets the rel canonical URL of an HTML document.  This is useful for telling search engines and other indexers which pages are duplicates of eachother; any pages with the rel=canonical tag will be treated as duplicates of the canonical URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_set_rel_canonical(canonical_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str canonical_url: The HTML canonical URL to set. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_set_rel_canonical_with_http_info(canonical_url, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_set_rel_canonical_with_http_info(canonical_url, **kwargs)  # noqa: E501
            return data

    def edit_html_html_set_rel_canonical_with_http_info(self, canonical_url, **kwargs):  # noqa: E501
        """Sets the rel canonical URL for the HTML document  # noqa: E501

        Sets the rel canonical URL of an HTML document.  This is useful for telling search engines and other indexers which pages are duplicates of eachother; any pages with the rel=canonical tag will be treated as duplicates of the canonical URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_set_rel_canonical_with_http_info(canonical_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str canonical_url: The HTML canonical URL to set. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['canonical_url', 'input_file', 'input_file_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_set_rel_canonical" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'canonical_url' is set
        if ('canonical_url' not in params or
                params['canonical_url'] is None):
            raise ValueError("Missing the required parameter `canonical_url` when calling `edit_html_html_set_rel_canonical`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501
        if 'canonical_url' in params:
            header_params['canonicalUrl'] = params['canonical_url']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/head/set/rel-canonical-url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_html_html_set_sitemap_url(self, sitemap_url, **kwargs):  # noqa: E501
        """Sets the sitemap URL for the HTML document  # noqa: E501

        Sets the sitemap URL of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_set_sitemap_url(sitemap_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sitemap_url: The HTML sitemap URL to set. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_html_html_set_sitemap_url_with_http_info(sitemap_url, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_html_html_set_sitemap_url_with_http_info(sitemap_url, **kwargs)  # noqa: E501
            return data

    def edit_html_html_set_sitemap_url_with_http_info(self, sitemap_url, **kwargs):  # noqa: E501
        """Sets the sitemap URL for the HTML document  # noqa: E501

        Sets the sitemap URL of an HTML document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_html_html_set_sitemap_url_with_http_info(sitemap_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str sitemap_url: The HTML sitemap URL to set. (required)
        :param file input_file: Optional: Input file to perform the operation on.
        :param str input_file_url: Optional: URL of a file to operate on as input.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sitemap_url', 'input_file', 'input_file_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_html_html_set_sitemap_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sitemap_url' is set
        if ('sitemap_url' not in params or
                params['sitemap_url'] is None):
            raise ValueError("Missing the required parameter `sitemap_url` when calling `edit_html_html_set_sitemap_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'input_file_url' in params:
            header_params['inputFileUrl'] = params['input_file_url']  # noqa: E501
        if 'sitemap_url' in params:
            header_params['sitemapUrl'] = params['sitemap_url']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'input_file' in params:
            local_var_files['inputFile'] = params['input_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json', 'application/xml', 'text/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Apikey']  # noqa: E501

        return self.api_client.call_api(
            '/convert/edit/html/head/set/sitemap-url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
