"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const amqp_generated_1 = require("./amqp.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return amqp_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::AMQP::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::AMQP::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new amqp_generated_1.RosInstance(this, id, {
            maxTps: props.maxTps,
            maxEipTps: props.maxEipTps,
            supportEip: props.supportEip,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            storageSize: props.storageSize,
            payType: props.payType === undefined || props.payType === null ? 'Subscription' : props.payType,
            queueCapacity: props.queueCapacity,
            tracingStorageTime: props.tracingStorageTime,
            instanceName: props.instanceName,
            orderNum: props.orderNum === undefined || props.orderNum === null ? 1 : props.orderNum,
            supportTracing: props.supportTracing,
            instanceType: props.instanceType,
            periodUnit: props.periodUnit === undefined || props.periodUnit === null ? 'Month' : props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrInstanceId = rosInstance.attrInstanceId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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