"""Functions used to configure GraphDB client.

Will handle authenticated instances of GraphDB where user and password is given in environment
variables ("GRAPHDB_USER" & "GRAPHDB_USER_PASSWD").

"""


def service(repo: str | None = None, server: str = "127.0.0.1:7200", protocol: str = "https", path: str = "") -> str:
    """Service url for GraphdDBClient.

    Args:
       repo: Repo on server
       server: server ip/name
       protocol: http or https
       path: to repository
    """
    url = f"{protocol}://{server}/{path}repositories"
    if repo:
        url += f"/{repo}"
    return url


def service_blazegraph(server: str, repo: str, protocol: str = "https") -> str:
    return f"{protocol}://{server}/{repo}/sparql"
