/*!
 * Wiki Monkey - MediaWiki bot and editor-assistant user script
 * Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
 *
 * This file is part of Wiki Monkey.
 *
 * Wiki Monkey is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Wiki Monkey is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 22122:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ _extends)
/* harmony export */ });
function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

/***/ }),

/***/ 31901:
/***/ ((module) => {

"use strict";


// Generated by CoffeeScript 2.5.1
// JavaScript auxiliary library
// Copyright (C) 2012 Dario Giovannetti <dev@dariogiovannetti.net>
// This file is part of JavaScript auxiliary library.
// JavaScript auxiliary library is free software: you can redistribute it
// and/or modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation, either version 3
// of the License, or (at your option) any later version.
// JavaScript auxiliary library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with JavaScript auxiliary library.
// If not, see <http://www.gnu.org/licenses/>.
module.exports.executeAsync = function (functions, id) {
  var _this = this;

  var callContinue, fid;
  id++;

  if (functions[id]) {
    fid = functions[id];

    callContinue = function callContinue() {
      return _this.executeAsync(functions, id);
    };

    return fid[0](fid[1], callContinue);
  }
};

module.exports.recurseTreeAsync = function (params) {
  var parent; // params = {
  //   node: ,
  //   parentIndex: ,
  //   siblingIndex: ,
  //   ancestors: ,
  //   children: ,
  //   callChildren: ,
  //   callNode: ,
  //   callEnd: ,
  //   callArgs: ,
  //   stage: ,
  //   nodesList:
  // }
  // nodesList: [
  //   {
  //     node: ,
  //     parentIndex: ,
  //     siblingIndex: ,
  //     ancestors: [...],
  //     children: [...]
  //   },
  //   {...}
  // ]
  // Example:
  // recurseTreeAsync({
  //   node: ,
  //   callChildren: ,
  //   callNode: ,
  //   callEnd: ,
  //   callArgs:
  // });
  // callChildren(params) {
  //   params.children = ;
  //   recurseTreeAsync(params);
  // }
  // callNode(params) {
  //   recurseTreeAsync(params);
  // }
  // callEnd(params) {}

  switch (params.stage) {
    case void 0:
      params.parentIndex = null;
      params.siblingIndex = 0;
      params.ancestors = [];
      params.children = [];
      params.nodesList = [];
      params.stage = 1;
      return this.recurseTreeAsync(params);

    case 1:
      params.stage = 2; // Prevent infinite loops

      if (params.ancestors.indexOf(params.node) === -1) {
        return params.callChildren(params);
      } else {
        params.children = "loop";
        return this.recurseTreeAsync(params);
      }

      break;

    case 2:
      params.nodesList.push({
        node: params.node,
        parentIndex: params.parentIndex,
        siblingIndex: params.siblingIndex,
        ancestors: params.ancestors.slice(0),
        children: params.children.slice(0)
      });
      params.stage = 3;
      return params.callNode(params);

    case 3:
      if (params.children.length && params.children !== "loop") {
        // Go to the first child
        params.ancestors.push(params.node);
        params.node = params.children[0];
        params.parentIndex = params.nodesList.length - 1;
        params.siblingIndex = 0;
        params.children = [];
        params.stage = 1;
        return this.recurseTreeAsync(params);
      } else if (params.parentIndex !== null) {
        // Go to the next sibling
        parent = params.nodesList[params.parentIndex];
        params.siblingIndex++;
        params.node = parent.children[params.siblingIndex];
        params.children = [];

        if (params.node) {
          params.stage = 1;
        } else {
          // There are no more siblings
          params.node = parent.node;
          params.parentIndex = parent.parentIndex;
          params.siblingIndex = parent.siblingIndex;
          params.ancestors = parent.ancestors.slice(0);
          params.stage = 3;
        }

        return this.recurseTreeAsync(params);
      } else {
        // End of recursion
        return params.callEnd(params);
      }

  }
};

/***/ }),

/***/ 25565:
/***/ ((module) => {

"use strict";


// Generated by CoffeeScript 2.5.1
// JavaScript auxiliary library
// Copyright (C) 2012 Dario Giovannetti <dev@dariogiovannetti.net>
// This file is part of JavaScript auxiliary library.
// JavaScript auxiliary library is free software: you can redistribute it
// and/or modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation, either version 3
// of the License, or (at your option) any later version.
// JavaScript auxiliary library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with JavaScript auxiliary library.
// If not, see <http://www.gnu.org/licenses/>.
module.exports.escapePattern = function (string) {
  // Escaping any other characters is not necessary, references:
  // - https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions
  // - http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
  // - http://stackoverflow.com/questions/2593637/how-to-escape-regular-expression-in-javascript
  // - http://stackoverflow.com/questions/494035/how-do-you-pass-a-variable-to-a-regular-expression-javascript
  // - http://stackoverflow.com/questions/3446170/escape-string-for-use-in-javascript-regex
  // - http://stackoverflow.com/questions/399078/what-special-characters-must-be-escaped-in-regular-expressions
  // Note for Wiki Monkey: do *not* escape '\s' here so that it will be
  // safe to use prepareRegexpWhitespace in WM.Parser
  return string.replace(/[-[\]{}()^$*+?.|\\]/g, "\\$&");
};

module.exports.matchAll = function (source, regExp) {
  var L, match, result;
  result = [];

  while (true) {
    match = regExp.exec(source);

    if (match) {
      L = match[0].length;
      result.push({
        "match": match,
        "index": regExp.lastIndex - L,
        "length": L
      });
    } else {
      break;
    }
  }

  return result;
};

module.exports.matchAllConditional = function (source, regExp, test) {
  var L, match, result;
  result = [];

  while (true) {
    match = regExp.exec(source);

    if (match && test(match)) {
      L = match[0].length;
      result.push({
        "match": match,
        "index": regExp.lastIndex - L,
        "length": L
      });
    } else {
      break;
    }
  }

  return result;
};

/***/ }),

/***/ 6368:
/***/ ((module) => {

"use strict";


// Generated by CoffeeScript 2.5.1
// JavaScript auxiliary library
// Copyright (C) 2012 Dario Giovannetti <dev@dariogiovannetti.net>
// This file is part of JavaScript auxiliary library.
// JavaScript auxiliary library is free software: you can redistribute it
// and/or modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation, either version 3
// of the License, or (at your option) any later version.
// JavaScript auxiliary library is distributed in the hope that it will be
// useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with JavaScript auxiliary library.
// If not, see <http://www.gnu.org/licenses/>.
module.exports.insert = function (string, newString, id) {
  if (id == null) {
    id = 0;
  }

  return string.substring(0, id) + newString + string.substr(id);
};

module.exports.overwriteFor = function (string, newString, id, length) {
  if (id == null) {
    id = 0;
  }

  if (!length || length < 0) {
    length = 0;
  }

  return string.substring(0, id) + newString + string.substr(id + length);
};

module.exports.overwriteAt = function (string, newString, id) {
  return module.exports.overwriteFor(string, newString, id, newString.length);
};

module.exports.overwriteBetween = function (string, newString, id1, id2) {
  var tempid;

  if (id1 == null) {
    id1 = 0;
  }

  if (id2 == null) {
    id2 = id1;
  }

  if (id1 > id2) {
    tempid = id2;
    id2 = id1;
    id1 = tempid;
  }

  return string.substring(0, id1) + newString + string.substr(id2);
};

module.exports.removeFor = function (string, id, length) {
  return module.exports.overwriteFor(string, "", id, length);
};

module.exports.removeBetween = function (string, id1, id2) {
  return module.exports.overwriteBetween(string, "", id1, id2);
};

module.exports.padLeft = function (string, filler, length) {
  while (string.length < length) {
    string = filler + string;
  }

  return string;
};

module.exports.padRight = function (string, filler, length) {
  while (string.length < length) {
    string += filler;
  }

  return string;
};

module.exports.findSimpleEnclosures = function (string, openTag, openLength, closeTag, closeLength) {
  var cIndex, cIndexRel, oIndex, oIndexRel, results, searchIndex; // openTag and closeTag can be strings or regular expressions
  // If the string is "<<>>" and the tags are "<" and ">", the result is
  //   [[0, 2], ]
  // Results are guaranteed to be in order of appearance in the original
  //   text

  results = [];
  searchIndex = 0;
  oIndexRel = string.search(openTag);

  while (true) {
    if (oIndexRel > -1) {
      oIndex = searchIndex + oIndexRel;
      cIndexRel = string.substr(oIndex + openLength).search(closeTag);

      if (cIndexRel > -1) {
        cIndex = oIndex + openLength + cIndexRel;
        results.push([oIndex, cIndex]);
        searchIndex = cIndex + closeLength;

        if (searchIndex < string.length) {
          oIndexRel = string.substr(searchIndex).search(openTag);
          continue;
        } else {
          break;
        }
      } else {
        // A tag is left open (no closing tag is found)
        // Let each implementation decide what to do in this case
        //   (either consider the tag working until the end of text
        //   or not)
        results.push([oIndex, false]);
        break;
      }
    } else {
      break;
    }
  }

  return results;
};

module.exports.findNestedEnclosures = function (string, openTag, closeTag, maskChar) {
  var cIndex, cIndexRel, closeLength, maskLength, maskedString, maskedString1, maskedString2, maskedString3, oIndex, oIndexRel, openLength, results, searchIndex; // openTag and closeTag must be strings, *not* regular expressions,
  //   unlike this.findSimpleEnclosures
  // maskChar must be a *1*-character string and must *not* be part of
  //   neither openTag nor closeTag
  // If the string is "<<>>" and the tags are "<" and ">", the result is
  //   [[1, 2], [0, 3]]

  openLength = openTag.length;
  closeLength = closeTag.length;
  results = [];
  searchIndex = 0;
  cIndexRel = string.indexOf(closeTag);
  maskedString = string;

  while (true) {
    if (cIndexRel > -1) {
      cIndex = searchIndex + cIndexRel;
      oIndexRel = maskedString.substring(searchIndex, cIndex).lastIndexOf(openTag);

      if (oIndexRel > -1) {
        oIndex = searchIndex + oIndexRel;
        results.push([oIndex, cIndex]);
        maskedString1 = maskedString.substring(0, oIndex);
        maskLength = cIndex - oIndex + closeLength;
        maskedString2 = module.exports.padRight("", maskChar, maskLength);
        maskedString3 = maskedString.substring(cIndex + closeLength);
        maskedString = maskedString1 + maskedString2 + maskedString3;
      } else {
        // Do *not* increment searchIndex in this case, in fact in
        //   we don't know yet whether there are more openTags
        //   before the one found
        searchIndex = cIndex + closeLength;
      }

      cIndexRel = maskedString.substring(searchIndex).indexOf(closeTag);
      continue;
    } else {
      break;
    }
  }

  return [results, maskedString];
};

module.exports.findInnermostEnclosures = function (string, openTag, closeTag) {
  var cIndex, cIndexRel, closeLength, oIndex, oIndexRel, openLength, results, searchIndex; // openTag and closeTag must be strings, *not* regular expressions,
  //   unlike this.findSimpleEnclosures
  // If the string is "<<>>" and the tags are "<" and ">", the result is
  //   [[1, 2], ]

  openLength = openTag.length;
  closeLength = closeTag.length;
  results = [];
  searchIndex = 0;

  while (true) {
    cIndexRel = string.substring(searchIndex).indexOf(closeTag);

    if (cIndexRel > -1) {
      cIndex = searchIndex + cIndexRel;
      oIndexRel = string.substring(searchIndex, cIndex).lastIndexOf(openTag);

      if (oIndexRel > -1) {
        oIndex = searchIndex + oIndexRel;
        results.push([oIndex, cIndex]);
      }

      searchIndex = cIndex + closeLength;
      continue;
    } else {
      break;
    }
  }

  return results;
};

/***/ }),

/***/ 75079:
/***/ ((module) => {

"use strict";


// Generated by CoffeeScript 2.1.1
(function () {
  // This file is part of vue-styled-jss
  // Copyright (C) 2018-present Dario Giovannetti <dev@dariogiovannetti.net>
  // Licensed under MIT
  // https://github.com/kynikos/vue-styled-jss/blob/master/LICENSE

  // TODO: Verify the tag names against html-tag-names in tests like in
  //       hyperscript-helpers
  //       Also include the SVG tags?
  // See https://github.com/ohanhi/hyperscript-helpers/issues/34 for the reason
  // why the tags aren't simply required from html-tag-names
  var HTML_TAG_NAMES;

  HTML_TAG_NAMES = ['a', 'abbr', 'acronym', 'address', 'applet', 'area', 'article', 'aside', 'audio', 'b', 'base', 'basefont', 'bdi', 'bdo', 'bgsound', 'big', 'blink', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'center', 'cite', 'code', 'col', 'colgroup', 'command', 'content', 'data', 'datalist', 'dd', 'del', 'details', 'dfn', 'dialog', 'dir', 'div', 'dl', 'dt', 'element', 'em', 'embed', 'fieldset', 'figcaption', 'figure', 'font', 'footer', 'form', 'frame', 'frameset', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'iframe', 'image', 'img', 'input', 'ins', 'isindex', 'kbd', 'keygen', 'label', 'legend', 'li', 'link', 'listing', 'main', 'map', 'mark', 'marquee', 'math', 'menu', 'menuitem', 'meta', 'meter', 'multicol', 'nav', 'nextid', 'nobr', 'noembed', 'noframes', 'noscript', 'object', 'ol', 'optgroup', 'option', 'output', 'p', 'param', 'picture', 'plaintext', 'pre', 'progress', 'q', 'rb', 'rbc', 'rp', 'rt', 'rtc', 'ruby', 's', 'samp', 'script', 'section', 'select', 'shadow', 'slot', 'small', 'source', 'spacer', 'span', 'strike', 'strong', 'style', 'sub', 'summary', 'sup', 'svg', 'table', 'tbody', 'td', 'template', 'textarea', 'tfoot', 'th', 'thead', 'time', 'title', 'tr', 'track', 'tt', 'u', 'ul', 'var', 'video', 'wbr', 'xmp'];

  module.exports = function (jss, options) {
    var i, len, styled, tagName;
    styled = function styled(tagName, style) {
      var className, styleobj;
      // TODO: Find a way to support composition, i.e. passing a component
      //       instead of a tagName string

      // TODO: Support dynamic styles based on the passed component's props
      styleobj = {};
      styleobj[tagName] = style;
      className = jss.createStyleSheet(styleobj, options).attach().classes[tagName];
      return {
        functional: true,
        render: function render(h, context) {
          if (Array.isArray(context.data.class)) {
            context.data.class.push(className);
          } else {
            context.data.class = [context.data.class, className];
          }
          return h(tagName, context.data, context.children);
        }
      };
    };
    styled.factory = function (tagName) {
      return function (style) {
        return styled(tagName, style);
      };
    };
    for (i = 0, len = HTML_TAG_NAMES.length; i < len; i++) {
      tagName = HTML_TAG_NAMES[i];
      styled[tagName] = styled.factory(tagName);
      styled[tagName.charAt(0).toUpperCase() + tagName.slice(1)] = styled.factory(tagName);
    }
    return styled;
  };
}).call(undefined);

/***/ }),

/***/ 88214:
/***/ ((module) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports.AutoLaunch = {
  name: 'AutoLaunch',
  data: function data() {
    return {
      noAuto: localStorage.getItem('wikiMonkeyNoAuto') === 'true'
    };
  },
  methods: {
    enableAutoLaunch: function enableAutoLaunch() {
      this.noAuto = false;
      localStorage.removeItem('wikiMonkeyNoAuto');
    },
    disableAutoLaunch: function disableAutoLaunch() {
      this.noAuto = true;
      localStorage.setItem('wikiMonkeyNoAuto', 'true');
    }
  },
  render: function render(h) {
    var _this = this;

    return h('li', ['Automatic launch is ', this.noAuto ? h('a', {
      attrs: {
        href: '#enable-auto-launch',
        title: 'Launch Wiki Monkey automatically on page load.'
      },
      on: {
        click: function click(event) {
          event.preventDefault();

          _this.enableAutoLaunch();
        }
      }
    }, ['disabled']) : h('a', {
      attrs: {
        href: '#disable-auto-launch',
        title: 'Instead of launching Wiki Monkey automatically on page \
load, only install a link at the top of pages to launch it manually.'
      },
      on: {
        click: function click(event) {
          event.preventDefault();

          _this.disableAutoLaunch();
        }
      }
    }, ['enabled'])]);
  }
};

/***/ }),

/***/ 5074:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(88092),
    blobLink = _require.blobLink;

var _require2 = __webpack_require__(44828),
    ConfigServer = _require2.ConfigServer;

var _require3 = __webpack_require__(63437),
    ConfigLocal = _require3.ConfigLocal;

var _require4 = __webpack_require__(51033),
    ConfigComputed = _require4.ConfigComputed;

module.exports.Config = {
  name: 'Config',
  data: function data() {
    return {
      expanded: true
    };
  },
  methods: {
    expand: function expand() {
      this.expanded = true;
    },
    collapse: function collapse() {
      this.expanded = false;
    }
  },
  render: function render(h) {
    var _this = this;

    return h('li', [h('a', {
      attrs: {
        href: '#configuration',
        title: this.expanded ? 'Hide configuration menu.' : 'Show configuration menu.'
      },
      on: {
        click: function click(event) {
          event.preventDefault();
          _this.expanded ? _this.collapse() : _this.expand();
        }
      }
    }, ['Configuration'])].concat(_toConsumableArray(this.expanded && [' (in cascading order)', h('ul', [h('li', ['Defaults [ ', h('a', {
      attrs: {
        href: 'https://github.com/kynikos/wiki-monkey/wiki'
      }
    }, 'wiki'), ' | ', h('a', {
      attrs: {
        href: 'https://github.com/kynikos/wiki-monkey'
      }
    }, 'source'), ' ]']), h(ConfigServer), h(ConfigLocal), h('li', [h('a', {
      attrs: {
        href: 'https://www.mediawiki.org/wiki/Manual:Interface/JavaScript#Personal_scripts'
      }
    }, 'User script'), ' [ '].concat(_toConsumableArray(function () {
      var userName = mw.config.get('wgUserName');
      var skin = mw.config.get('skin');
      var commonJs = new mw.Title("User:".concat(userName, "/common.js"));
      var skinJs = new mw.Title("User:".concat(userName, "/").concat(skin, ".js"));
      return [h('a', {
        attrs: {
          href: commonJs.getUrl()
        }
      }, 'common.js'), ' | ', h('a', {
        attrs: {
          href: skinJs.getUrl()
        }
      }, "".concat(skin, ".js"))];
    }()), [' ]'])), h(ConfigComputed), Object.values(WM.unknownConfig).some(function (userConfig) {
      return !$.isEmptyObject(userConfig);
    }) && h('li', [h(blobLink, {
      props: {
        href: '#view-server-downloaded-uknown-config',
        title: 'View the configuration options that were not \
understood by this version of Wiki Monkey.',
        content: JSON.stringify(WM.unknownConfig, null, 2),
        mimeType: 'application/json'
      }
    }, ['Unknown options'])])])])));
  }
};

/***/ }),

/***/ 51033:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(88092),
    blobLink = _require.blobLink;

module.exports.ConfigComputed = {
  name: 'ConfigComputed',
  render: function render(h) {
    return h('li', ['Final computed [ ', h(blobLink, {
      props: {
        href: '#view-computed-config',
        title: 'View the configuration options (in JSON format) in the \
final, used form, as they are computed after parsing all the progressively \
overriding configuration sources.',
        content: JSON.stringify(WM.makeComputedConfig(), null, 2),
        mimeType: 'application/json'
      }
    }, ['view']), ' | ', h(blobLink, {
      props: {
        href: '#view-computed-config',
        title: 'Download the configuration options (in JSON format) in \
the final, used form, as they are computed after parsing all the \
progressively overriding configuration sources.',
        content: JSON.stringify(WM.makeComputedConfig(), null, 2),
        mimeType: 'application/json',
        downloadName: 'WikiMonkeyConfig.json'
      }
    }, ['download']), ' ]']);
  }
};

/***/ }),

/***/ 93071:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports.ConfigImport = {
  name: 'ConfigImport',
  render: function render(h) {
    var _this = this;

    return h('span', [h('a', {
      attrs: {
        href: '#import-local-config',
        title: "Import configuration options (in JSON format) into the \
browser's localStorage; these options override the default ones, but may be \
in turn overridden by any more options specified in the User's common.js \
page; note that the configuration object must have a #default or username \
keys at its root level: it is recommended to export the current local user \
configuration and use it as a template."
      },
      on: {
        click: function click(event) {
          event.preventDefault();

          _this.$refs.input.click();
        }
      }
    }, ['import']), h('input', {
      ref: 'input',
      attrs: {
        type: 'file'
      },
      style: {
        display: 'none'
      },
      on: {
        change: function change(event) {
          var _event$currentTarget$ = _slicedToArray(event.currentTarget.files, 1),
              file = _event$currentTarget$[0];

          var freader = new FileReader();

          freader.onload = function (fileLoadedEvent) {
            var inFile = fileLoadedEvent.target.result;
            var json;

            try {
              json = JSON.parse(inFile);
            } catch (error) {
              console.error(error);
              return mw.notification.notify(["The loaded file could not be parsed as JSON (see the \
detailed error in the browser's console)."], {
                autoHide: false,
                tag: 'WikiMonkey-config-import',
                title: 'Wiki Monkey import configuration.',
                type: 'error'
              });
            }

            WM.importLocalConfig(json);
          };

          freader.readAsText(file, 'UTF-8');
        }
      }
    })]);
  }
};

/***/ }),

/***/ 63437:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(88092),
    blobLink = _require.blobLink;

var _require2 = __webpack_require__(93071),
    ConfigImport = _require2.ConfigImport;

module.exports.ConfigLocal = {
  name: 'ConfigLocal',
  render: function render(h) {
    return h('li', ['localStorage [ ', h(blobLink, {
      props: {
        href: '#view-local-config',
        title: "View the configuration options (in JSON format) that may \
have been imported and saved in the browser's localStorage.",
        content: JSON.stringify(WM.makeLocalConfig(), null, 2),
        mimeType: 'application/json'
      }
    }, ['view']), ' | ', h(blobLink, {
      props: {
        href: '#view-local-config',
        title: "Download the configuration options (in JSON format) that \
may have been imported and saved in the browser's localStorage.",
        content: JSON.stringify(WM.makeLocalConfig(), null, 2),
        mimeType: 'application/json',
        downloadName: 'WikiMonkeyConfig.json'
      }
    }, ['download']), ' | ', h(ConfigImport), ' ]']);
  }
};

/***/ }),

/***/ 44828:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(88092),
    blobLink = _require.blobLink;

module.exports.ConfigServer = {
  name: 'ConfigServer',
  render: function render(h) {
    if (!WM.serverUrl) return null;
    return h('li', ['From server [ ', h(blobLink, {
      props: {
        href: '#view-server-downloaded-config',
        title: 'View the configuration options (in JSON format) that may \
have been downloaded from the server.',
        content: JSON.stringify(WM.makeServerConfig(), null, 2),
        mimeType: 'application/json'
      }
    }, ['view']), ' | ', h(blobLink, {
      props: {
        href: '#view-server-downloaded-config',
        title: 'Download the configuration options (in JSON format) that \
have been downloaded from the server.',
        content: JSON.stringify(WM.makeServerConfig(), null, 2),
        mimeType: 'application/json',
        downloadName: 'WikiMonkeyConfig.json'
      }
    }, ['download']), ' ]']);
  }
};

/***/ }),

/***/ 96851:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var colors = __webpack_require__(12590);

module.exports.Plugins = {
  name: 'Plugins',
  data: function data() {
    return {
      listShown: false
    };
  },
  methods: {
    showList: function showList() {
      this.listShown = true;
    },
    hideList: function hideList() {
      this.listShown = false;
    }
  },
  render: function render(h) {
    var _this = this;

    return h('li', [h('a', {
      attrs: {
        href: '#list-installed-plugins',
        title: 'List the installed Wiki Monkey plugins and show whether \
they are enabled or disabled.'
      },
      on: {
        click: function click(event) {
          event.preventDefault();
          _this.listShown ? _this.hideList() : _this.showList();
        }
      }
    }, ['Installed plugins']), this.listShown && h('ul', [h('li', [h('span', {
      style: {
        color: colors.greenText
      }
    }, ['enabled']), h('ul', [WM.enabledPlugins.map(function (plugin) {
      return h('li', [plugin.constructor.pluginName]);
    })])]), h('li', [h('span', {
      style: {
        color: colors.redText
      }
    }, ['disabled']), h('ul', [WM.disabledPlugins.map(function (plugin) {
      return h('li', [plugin.pluginName, plugin.requiresServer && h('span', {
        style: {
          color: colors.greyText
        }
      }, [' (requires server)'])]);
    })])])])]);
  }
};

/***/ }),

/***/ 70220:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(47969),
    asciiSpinner = _require.asciiSpinner;

var _require2 = __webpack_require__(53706),
    ServerUpgrade = _require2.ServerUpgrade;

module.exports.ServerInfo = {
  name: 'ServerInfo',
  data: function data() {
    return {
      databaseRevision: null
    };
  },
  methods: {
    getInfo: function getInfo() {
      var _this = this;

      // Show the spinner in place of the current value
      this.databaseRevision = null;
      return WM.DB.get('maintenance/info').done(function (data) {
        _this.databaseRevision = data.database_revision;
      });
    },
    setDatabaseRevision: function setDatabaseRevision(databaseRevision) {
      this.databaseRevision = databaseRevision;
    }
  },
  created: function created() {
    WM.serverUrl && this.getInfo();
  },
  render: function render(h) {
    return WM.serverUrl ? h('li', ['Database revision: ', this.databaseRevision ? [this.databaseRevision, ' (', // For the moment it's pointless to also offer a refresh link
    // h('a', {
    //   attrs: {
    //     href: '#server-info-refresh',
    //     title: 'Refresh server and database metadata.',
    //   },
    //   on: {
    //     click: (event) => {
    //       event.preventDefault()
    //       this.getInfo()
    //     },
    //   },
    // }, ['refresh']),
    h(ServerUpgrade, {
      props: {
        setDatabaseRevision: this.setDatabaseRevision
      }
    }), ')'] : [h(asciiSpinner)]]) : null;
  }
};

/***/ }),

/***/ 53706:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(78635),
    hh = _require.h;

module.exports.ServerUpgrade = {
  name: 'ServerUpgrade',
  props: {
    setDatabaseRevision: {
      type: Function,
      required: true
    }
  },
  render: function render(h) {
    var _this = this;

    return h('a', {
      attrs: {
        href: '#force-upgrade-database',
        title: 'Force trying to upgrade the database to the latest revision, \
if needed; this safely does nothing if the database is already at the latest \
revision.'
      },
      on: {
        click: function click(event) {
          event.preventDefault(); // Setting the revision to null shows the spinner while the query is
          // executed

          _this.setDatabaseRevision(null);

          WM.DB.post('maintenance/upgrade_database').done(function (data) {
            var content;
            var notificationType;

            if (!data.success) {
              content = [hh('p', 'An error happened during the upgrade.')];
              notificationType = 'error';
            } else if (data.noop) {
              content = [hh('p', "The database was already at the latest revision\n(".concat(data.new_revision, ")."))];
            } else {
              content = [hh('p', 'Database successfully upgraded.'), hh('p', {
                style: {
                  'white-space': 'nowrap'
                }
              }, "Old revision: ".concat(data.old_revision)), hh('p', {
                style: {
                  'white-space': 'nowrap'
                }
              }, "New revision: ".concat(data.new_revision))];
            }

            mw.notification.notify(content, {
              autoHide: false,
              tag: 'WikiMonkey-database-upgrade',
              title: 'Wiki Monkey database upgrade.',
              type: notificationType
            });
            return _this.setDatabaseRevision(data.new_revision);
          });
        }
      }
    }, ['force upgrade']);
  }
};

/***/ }),

/***/ 6227:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(60306),
    version = _require.version;

var _require2 = __webpack_require__(87839),
    upgradeNow = _require2.upgradeNow;

var _require3 = __webpack_require__(47969),
    asciiSpinner = _require3.asciiSpinner;

module.exports.Version = {
  name: 'Version',
  data: function data() {
    return {
      checking: false
    };
  },
  methods: {
    setChecking: function setChecking(checking) {
      this.checking = checking;
    }
  },
  render: function render(h) {
    var _this = this;

    return h('li', ['Version: ', version, WM.serverUrl ? null : ' (standalone)', ' (', h('a', {
      attrs: {
        href: '#force-check-updates',
        title: 'Force checking for Wiki Monkey updates and possibly \
prompt to install them (Wiki Monkey checks for updates regularly as specified \
in its configuration).'
      },
      on: {
        click: function () {
          var _click = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(event) {
            return regeneratorRuntime.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    event.preventDefault();

                    _this.setChecking(true);

                    _context.next = 4;
                    return upgradeNow();

                  case 4:
                    _this.setChecking(false);

                  case 5:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee);
          }));

          function click(_x) {
            return _click.apply(this, arguments);
          }

          return click;
        }()
      }
    }, [this.checking ? h(asciiSpinner) : 'check updates']), ')']);
  }
};

/***/ }),

/***/ 53102:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(6227),
    Version = _require.Version;

var _require2 = __webpack_require__(96851),
    Plugins = _require2.Plugins;

var _require3 = __webpack_require__(5074),
    Config = _require3.Config;

var _require4 = __webpack_require__(88214),
    AutoLaunch = _require4.AutoLaunch;

var _require5 = __webpack_require__(70220),
    ServerInfo = _require5.ServerInfo;

module.exports = {
  name: 'About',
  render: function render(h) {
    return h('div', [h('p', ['Wiki Monkey is distributed under the ', h('a', {
      attrs: {
        href: 'https://www.gnu.org/licenses/gpl-3.0.en.html'
      }
    }, ['GNU General Public License version 3']), '.']), h('ul', [h(Version), h(ServerInfo), h('li', [h('a', {
      attrs: {
        href: 'https://github.com/kynikos/wiki-monkey/wiki'
      }
    }, ['Documentation'])]), h('li', ['GitHub: ', h('a', {
      attrs: {
        href: 'https://github.com/kynikos/wiki-monkey'
      }
    }, 'client'), ', ', h('a', {
      attrs: {
        href: 'https://github.com/kynikos/wiki-monkey-server'
      }
    }, 'server')]), h(Plugins), h(Config), h(AutoLaunch)])]);
  }
};

/***/ }),

/***/ 47969:
/***/ ((module) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports.asciiSpinner = {
  name: 'asciiSpinner',
  data: function data() {
    return {
      "char": '+'
    };
  },
  methods: {
    changeCharacter: function changeCharacter() {
      this["char"] = {
        '+': '×',
        '×': '+'
      }[this["char"]];
    }
  },
  mounted: function mounted() {
    setInterval(this.changeCharacter, 250);
  },
  render: function render(h) {
    return h('span', this["char"]);
  }
};

/***/ }),

/***/ 88092:
/***/ ((module) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports.blobLink = {
  name: 'blobLink',
  props: {
    href: {
      type: String,
      required: true
    },
    title: {
      type: String,
      required: true
    },
    content: {
      required: true
    },
    mimeType: {
      type: String,
      required: true
    },
    downloadName: {
      type: String,
      required: false
    }
  },
  render: function render(h) {
    var _this = this;

    return h('a', {
      attrs: {
        href: this.href,
        title: this.title
      },
      on: {
        click: function click(event) {
          event.preventDefault();
          var blob = new Blob([_this.content], {
            type: _this.mimeType
          });
          var link = document.createElement('a');
          var url = window.URL.createObjectURL(blob);
          link.href = url; // If link.download is not set, the browser may open the link in
          // another tab, which for e.g. JSON files is good

          if (_this.downloadName) {
            link.download = 'WikiMonkeyConfig.json';
          }

          link.style = 'display:none;';
          document.body.appendChild(link);
          link.click(); // https://stackoverflow.com/a/48968694/645498

          setTimeout(function () {
            window.URL.revokeObjectURL(url);
            document.body.removeChild(link);
          }, 0);
        }
      }
    }, [this.$slots["default"]]);
  }
};

/***/ }),

/***/ 82719:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex;

var Log = __webpack_require__(3790);

module.exports = {
  name: 'Fieldset',
  computed: Vuex.mapState('fieldset', ['display']),
  methods: _objectSpread({}, Vuex.mapMutations('fieldset', ['toggle'])),
  render: function render(h) {
    var _this = this;

    var wmmain = h('div', [this.$slots["default"], h(Log)]);
    var legend = h('legend', ['Wiki Monkey [ ', h('a', {
      attrs: {
        href: '#'
      },
      on: {
        click: function click(event) {
          event.preventDefault();

          _this.toggle();
        }
      }
    }, this.display && 'hide' || 'show'), ' ]']);
    return h('fieldset', {
      attrs: {
        id: 'WikiMonkey'
      }
    }, [legend, this.display && wmmain]);
  }
};

/***/ }),

/***/ 84762:
/***/ ((module) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports = {
  namespaced: true,
  state: {
    display: true
  },
  mutations: {
    show: function show(state, _show) {
      state.display = _show == null ? true : _show;
    },
    hide: function hide(state) {
      state.display = false;
    },
    toggle: function toggle(state) {
      state.display = !state.display;
    }
  }
};

/***/ }),

/***/ 30733:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex,
    moment = _require.moment;

module.exports = {
  name: 'Export',
  methods: Vuex.mapGetters('log', ['composeSaveLogText']),
  render: function render(h) {
    var _this = this;

    return h('a', {
      domProps: {
        href: '#',
        download: 'WikiMonkey.log'
      },
      on: {
        click: function click(event) {
          event.target.href = _this.composeSaveLogText();
          event.target.download = "WikiMonkey-".concat(moment().format('YYYYMMDDTHHmmssZZ'), ".log");
        }
      }
    }, 'save log');
  }
};

/***/ }),

/***/ 57157:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex;

module.exports = {
  name: 'LogFilter',
  computed: Vuex.mapState('log', ['minLevel']),
  methods: Vuex.mapMutations('log', ['toggleMinLevel']),
  render: function render(h) {
    var _this = this;

    return h('a', {
      attrs: {
        href: '#'
      },
      on: {
        click: function click(event) {
          event.preventDefault();
          return _this.toggleMinLevel();
        }
      }
    }, this.minLevel > 10 && 'show info messages' || 'hide info messages');
  }
};

/***/ }),

/***/ 65845:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    jssc = _require.jssc,
    styled = _require.styled,
    moment = _require.moment;

var _require2 = __webpack_require__(51504),
    Flex = _require2.Flex;

var colors = __webpack_require__(12590);

var LEVEL_TO_CLASS = {
  5: 'hidden',
  8: 'json',
  10: 'debug',
  20: 'info',
  30: 'warning',
  40: 'error'
};
var divmixin = {
  fontFamily: 'monospace',
  color: colors.whiteText
};
var Timestamp = styled.div(_objectSpread(_objectSpread({}, divmixin), {}, {
  marginRight: '1em',
  whiteSpace: 'nowrap'
}));
var Text = styled.div(_objectSpread(_objectSpread({}, divmixin), {}, {
  '& a': {
    color: 'inherit',
    textDecoration: 'underline'
  }
}));

var _jssc = jssc({
  hidden: {},
  json: {},
  debug: {
    color: colors.blueText
  },
  info: {},
  warning: {
    color: colors.yellowText
  },
  error: {
    color: colors.redText
  }
}),
    classes = _jssc.classes;

module.exports = {
  name: 'Message',
  props: {
    index: {
      type: Number,
      required: true
    },
    text: {
      type: String,
      required: true
    },
    level: {
      type: Number,
      required: true,
      validator: function validator(level) {
        return level in LEVEL_TO_CLASS;
      }
    },
    tstamp: {
      type: Date,
      required: true
    }
  },
  render: function render(h) {
    return h(Flex, {
      key: this.index
    }, [h(Timestamp, moment(this.tstamp).format('HH:mm:ss')), h(Text, {
      "class": classes[LEVEL_TO_CLASS[this.level]],
      // The message could contain links or other HTML
      domProps: {
        innerHTML: this.text || ''
      }
    })]);
  }
};

/***/ }),

/***/ 88275:
/***/ ((module) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports.PageLink = function (url, anchor) {
  // Must return a string, not a DOM element
  return "<a href=\"".concat(url, "\">").concat(anchor, "</a>");
};

/***/ }),

/***/ 30910:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports.WikiLink = function (title, anchor) {
  // Must return a string, not a DOM element
  // Use an absolute (full) URL so it will be usable in the downloadable
  //   version of the log
  // Do *not* use encodeURIComponent(title) because the passed title may
  //   have a fragment or a query string that would then be encoded
  //   MediaWiki should be able to correctly resolve the title anyway
  var wikiUrls = WM.MW.getWikiUrls();
  return "<a href=\"".concat(wikiUrls["short"]).concat(title, "\">").concat(anchor, "</a>");
};

/***/ }),

/***/ 3790:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex,
    styled = _require.styled;

var colors = __webpack_require__(12590);

var LogFilter = __webpack_require__(57157);

var Export = __webpack_require__(30733);

var Message = __webpack_require__(65845);

var MessageContainer = styled.div({
  height: '10em',
  border: "2px solid ".concat(colors.blueBorder),
  padding: '0.5em',
  overflow: 'auto',
  resize: 'vertical',
  backgroundColor: colors.blackBackground
});
module.exports = {
  name: 'Log',
  computed: Vuex.mapState('log', ['display', 'minLevel', 'messages']),
  render: function render(h) {
    var _this = this;

    if (!this.display) {
      return null;
    }

    return h('div', [h('p', ['[ ', h(LogFilter), ' | ', h(Export), ' ]']), h(MessageContainer, {
      ref: 'logArea'
    }, this.messages.reduce(function (acc, _ref, index) {
      var text = _ref.text,
          level = _ref.level,
          tstamp = _ref.tstamp;

      if (level >= _this.minLevel) {
        acc.push(h(Message, {
          props: {
            text: text,
            level: level,
            tstamp: tstamp,
            index: index
          }
        }));
      }

      return acc;
    }, []))]);
  },
  beforeUpdate: function beforeUpdate() {
    var logArea = this.$refs.logArea; // LogArea may not exist when the log is hidden

    if (logArea) {
      this.isScrolledToBottom = logArea.scrollTop + logArea.clientHeight === logArea.scrollHeight;
    }
  },
  updated: function updated() {
    if (this.isScrolledToBottom) {
      var logArea = this.$refs.logArea; // LogArea may not exist when the log is hidden

      if (logArea) {
        logArea.scrollTop = logArea.scrollHeight - logArea.clientHeight;
      }
    }
  }
};

/***/ }),

/***/ 47599:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    moment = _require.moment;

var LEVEL_TO_TAG = {
  5: 'HDN',
  8: 'JSN',
  10: 'DBG',
  20: 'INF',
  30: 'WRN',
  40: 'ERR'
};
module.exports = {
  namespaced: true,
  state: {
    display: true,
    minLevel: 10,
    messages: []
  },
  getters: {
    composeSaveLogText: function composeSaveLogText(state) {
      var text = state.messages.map(function (message) {
        return "".concat(moment(message.tstamp).format('HH:mm:ss'), "\t").concat(LEVEL_TO_TAG[message.level], "\t").concat(message.text);
      }).join('\n');
      return "data:text/plain;charset=utf-8,".concat(encodeURIComponent(text));
    }
  },
  mutations: {
    show: function show(state, _show) {
      state.display = _show == null ? true : _show;
    },
    hide: function hide(state) {
      state.display = false;
    },
    toggle: function toggle(state) {
      state.display = !state.display;
    },
    toggleMinLevel: function toggleMinLevel(state) {
      state.minLevel = state.minLevel === 10 ? 21 : 10;
    },
    hidden: function hidden(state, text) {
      return state.messages.push({
        text: text,
        level: 5,
        tstamp: new Date()
      });
    },
    json: function json(state, _ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          component = _ref2[0],
          data = _ref2[1];

      var text = JSON.stringify({
        component: component,
        data: data
      });
      return state.messages.push({
        text: text,
        level: 8,
        tstamp: new Date()
      });
    },
    debug: function debug(state, text) {
      return state.messages.push({
        text: text,
        level: 10,
        tstamp: new Date()
      });
    },
    info: function info(state, text) {
      return state.messages.push({
        text: text,
        level: 20,
        tstamp: new Date()
      });
    },
    warning: function warning(state, text) {
      return state.messages.push({
        text: text,
        level: 30,
        tstamp: new Date()
      });
    },
    error: function error(state, text) {
      return state.messages.push({
        text: text,
        level: 40,
        tstamp: new Date()
      });
    }
  }
};

/***/ }),

/***/ 9604:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex; // TODO: Adding a "cancel" button, waiting to close the popover until the
//       async operation has completed, and in general managing the 'visible'
//       state of the popover manually using the 'trigger:manual' prop is
//       tricky, especially because it breaks the default behavior of making
//       the popover disappear if clicking outside of it because I'm not using
//       the Vue templates, so I should reimplement the functionality by myself
//       https://github.com/ElemeFE/element/blob/dev/packages/popover/src/main.vue
//       https://vuejs.org/v2/guide/render-function.html#v-model
//       https://stackoverflow.com/questions/152975/how-do-i-detect-a-click-outside-an-element


module.exports.popoverConfirm = {
  name: 'popoverConfirm',
  // TODO: See note at the top of the file
  // data() {
  //   return {
  //     visible: false,
  //   }
  // },
  props: {
    question: {
      type: String,
      required: true
    },
    textConfirm: {
      type: String,
      required: true
    },
    onConfirm: {
      type: Function,
      required: true
    } // TODO: See note at the top of the file
    // textCancel: {
    //   type: String,
    //   required: true,
    // },

  },
  // TODO: See note at the top of the file
  // methods: {
  //   showPopper() {
  //     this.visible = true
  //   },
  //   hidePopper() {
  //     this.visible = false
  //   },
  // },
  render: function render(h) {
    var _this = this;

    return h('ElPopover', {// TODO: See note at the top of the file
      // props: {
      //   value: this.visible,
      //   trigger: 'manual',
      // },
    }, [h('div', [this.question]), h('div', ['[ ', h('a', {
      attrs: {
        href: '#'
      },
      on: {
        click: function click(event) {
          event.preventDefault();

          _this.onConfirm(); // TODO: See note at the top of the file
          // await this.onConfirm()
          // this.hidePopper(event)

        }
      }
    }, [this.textConfirm]), // TODO: See note at the top of the file
    // ' | ',
    // h('a', {
    //   attrs: {href: '#'},
    //   on: {click: (event) => {
    //     event.preventDefault()
    //     this.hidePopper()
    //   }},
    // }, [this.textCancel]),
    ' ]']), h('span', {
      slot: 'reference' // TODO: See note at the top of the file
      // on: {click: this.showPopper},

    }, this.$slots["default"])]);
  }
};

/***/ }),

/***/ 12590:
/***/ ((module) => {

module.exports = {
  whiteText: '#eee',
  greyBorder: '#ccc',
  greyText: '#666',
  blackBackground: '#111',
  redText: 'red',
  greenText: 'green',
  blueBorder: '#07b',
  blueText: 'cyan',
  yellowText: 'gold'
};

/***/ }),

/***/ 51504:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _require = __webpack_require__(78635),
    jssc = _require.jssc,
    styled = _require.styled;

var colors = __webpack_require__(12590);

jssc({
  // Keep editsection links styled consistently with the pageCommands
  // Also, bold is conventionally used to highlight links if needed
  '@global #bodyContent .mw-editsection a': {
    fontWeight: 'normal !important'
  }
});
module.exports.Flex = styled.div({
  display: 'flex'
}); // TODO: vue-styled-jss doesn't support composition yet

module.exports.FlexSpaced = styled.div({
  display: 'flex',
  '& > *+*': {
    marginLeft: '1em'
  }
});
module.exports.FlexColumn = styled.div({
  display: 'flex',
  flexDirection: 'column'
});
module.exports.Grid2C = styled.div({
  display: 'grid',
  gridTemplateColumns: 'auto auto',
  justifyContent: 'start',
  alignContent: 'start',
  '& > *:nth-child(odd)': {
    textAlign: 'right',
    paddingRight: '0.5em',
    borderRight: "1px solid ".concat(colors.greyBorder),
    marginRight: '0.5em'
  }
});
module.exports.SpacedVertical = styled.div({
  '& > *+*': {
    marginTop: '1em'
  }
});

/***/ }),

/***/ 78738:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(78635),
    jssc = _require.jssc;

var _jssc = jssc({
  pluginSelect: {
    width: '100%',
    marginBottom: '1em'
  },
  listSelect: {
    marginBottom: '1em'
  },
  botFilter: {
    height: '6em',
    marginBottom: '1em',
    resize: 'vertical'
  },
  botStartStop: {
    marginRight: '0.33em',
    marginBottom: '1em',
    fontWeight: 'bold'
  },
  botSelected: {
    backgroundColor: '#faa',
    padding: '0.2em 0.4em'
  },
  botProcessing: {
    backgroundColor: '#ff8',
    padding: '0.2em 0.4em'
  },
  botChanged: {
    backgroundColor: '#afa',
    padding: '0.2em 0.4em'
  },
  botUnchanged: {
    backgroundColor: '#aaf',
    padding: '0.2em 0.4em'
  },
  botBypassed: {
    backgroundColor: 'orangered',
    padding: '0.2em 0.4em'
  },
  botFailed: {
    backgroundColor: 'red',
    padding: '0.2em 0.4em'
  }
}),
    classes = _jssc.classes;

module.exports = /*#__PURE__*/function () {
  function _class(plugins, lists) {
    _classCallCheck(this, _class);

    this._previewFilter = this._previewFilter.bind(this);
    this._startAutomatic = this._startAutomatic.bind(this);
    this.configuration = {
      pluginName: null,
      function_: function function_() {},
      filters: [],
      list: {
        current: null,
        previous: null
      },
      visited: []
    }; // LocalStorage can only store strings

    this.botToken = '0';
    var fdiv = this.makeFunctionUI(plugins);
    this.elems = fdiv ? [fdiv, this.makeConfUI(lists)] : [];
  }

  _createClass(_class, [{
    key: "makeFunctionUI",
    value: function makeFunctionUI(plugins) {
      var self = this;
      var fieldset = document.createElement('fieldset');
      var legend = document.createElement('legend');
      legend.innerHTML = 'Plugin';
      var selectFunctions = document.createElement('select');
      selectFunctions.id = 'WikiMonkeyBot-PluginSelect';
      selectFunctions.className = classes.pluginSelect;
      var ffunctions = [];

      var _iterator = _createForOfIteratorHelper(plugins),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = _slicedToArray(_step.value, 3),
              pplugin = _step$value[0],
              _pluginRun = _step$value[1],
              _pluginMakeUI = _step$value[2];

          var pluginInst = pplugin.conf.bot_label; // This allows to disable an entry by giving it any second
          // parameter that evaluates to false

          if (!pluginInst || !pluginInst.length) {
            continue;
          }

          ffunctions.push([pplugin, _pluginRun, _pluginMakeUI]);
          var option = document.createElement('option');
          option.innerHTML = pluginInst;

          if (pplugin.constructor.pluginName === WM.conf.default_bot_plugin) {
            option.selected = true;
          }

          selectFunctions.appendChild(option);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      if (ffunctions.length) {
        selectFunctions.addEventListener('change', function (fffunctions) {
          return function () {
            var select = document.getElementById('WikiMonkeyBot-PluginSelect');
            var id = select.selectedIndex;
            var UI = document.getElementById('WikiMonkeyBotFunction');

            var _fffunctions$id = _slicedToArray(fffunctions[id], 3),
                plugin = _fffunctions$id[0],
                pluginRun = _fffunctions$id[1],
                pluginMakeUI = _fffunctions$id[2]; // [1] Note that this must also be executed immediately, see [2]


            if (pluginMakeUI instanceof Function) {
              UI.replaceChild(pluginMakeUI(), UI.firstChild);
            } else {
              // Don't removeChild, otherwise if another plugin with
              // interface is selected, replaceChild won't work
              UI.replaceChild(document.createElement('div'), UI.firstChild);
            }

            self.configuration.pluginName = plugin.constructor.pluginName;

            self.configuration.function_ = function (title, callContinue, chainArgs) {
              return pluginRun(title, callContinue, chainArgs);
            };
          };
        }(ffunctions), false);
        var divFunction = document.createElement('div');
        divFunction.id = 'WikiMonkeyBotFunction';

        var _ffunctions$selectFun = _slicedToArray(ffunctions[selectFunctions.selectedIndex], 3),
            plugin = _ffunctions$selectFun[0],
            pluginRun = _ffunctions$selectFun[1],
            pluginMakeUI = _ffunctions$selectFun[2]; // [2] Note that this is also executed onchange, see [1]


        if (pluginMakeUI instanceof Function) {
          divFunction.appendChild(pluginMakeUI());
        } else {
          divFunction.appendChild(document.createElement('div'));
        }

        this.configuration.pluginName = plugin.constructor.pluginName;

        this.configuration.function_ = function (title, callContinue, chainArgs) {
          pluginRun(title, callContinue, chainArgs);
        };

        fieldset.appendChild(legend);
        fieldset.appendChild(selectFunctions);
        fieldset.appendChild(divFunction);
        return fieldset;
      }

      return false;
    }
  }, {
    key: "makeListSelector",
    value: function makeListSelector(lists) {
      var self = this;
      var selectLists = document.createElement('select');
      selectLists.id = 'WikiMonkeyBot-ListSelect';
      selectLists.className = classes.listSelect;

      var _iterator2 = _createForOfIteratorHelper(lists),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var list = _step2.value;

          if (list[0]) {
            var option = document.createElement('option');
            option.innerHTML = list[2];
            selectLists.appendChild(option);

            if (!this.configuration.list.current) {
              // [1] Note that this is also executed onchange, see [2]
              this.configuration.list.current = list;
            }
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      selectLists.addEventListener('change', function (lss) {
        return function () {
          var select = document.getElementById('WikiMonkeyBot-ListSelect');
          var id = select.selectedIndex;
          self.configuration.list.previous = self.configuration.list.current; // [2] Note that this must also be executed immediately, see [1]

          self.configuration.list.current = lss[id];
        };
      }(lists), false);
      return selectLists;
    }
  }, {
    key: "makeConfUI",
    value: function makeConfUI(lists) {
      var self = this;
      var bot = document.createElement('div');
      var fieldset = document.createElement('fieldset');
      var legend = document.createElement('legend');
      legend.innerHTML = 'Filter';
      var listSelect = this.makeListSelector(lists);
      var filter = document.createElement('textarea');
      filter.id = 'WikiMonkeyBotFilter';
      filter.className = classes.botFilter;
      var preview = document.createElement('input');
      preview.id = 'WikiMonkeyBotPreview';
      preview.type = 'button';
      preview.value = 'Preview';
      var duplicates = document.createElement('input');
      duplicates.type = 'checkbox';
      duplicates.id = 'WikiMonkeyBotDuplicates';
      var inverse = document.createElement('input');
      inverse.type = 'checkbox';
      inverse.id = 'WikiMonkeyBotInverse';
      var elems = [filter, duplicates, inverse];

      for (var _i2 = 0, _elems = elems; _i2 < _elems.length; _i2++) {
        var elem = _elems[_i2];
        elem.addEventListener('change', function () {
          return self._disableStartBot('Filters have changed, preview the selection');
        }, false);
      }

      var duplicatestag = document.createElement('span');
      duplicatestag.innerHTML = 'Duplicates';
      var inversetag = document.createElement('span');
      inversetag.innerHTML = 'Inverse';
      preview.addEventListener('click', this._previewFilter, false);
      fieldset.appendChild(legend);

      if (listSelect.length > 1) {
        fieldset.appendChild(listSelect);
      }

      fieldset.appendChild(filter);
      fieldset.appendChild(preview);
      fieldset.appendChild(duplicates);
      fieldset.appendChild(duplicatestag);
      fieldset.appendChild(inverse);
      fieldset.appendChild(inversetag);
      var start = document.createElement('input');
      start.type = 'button';
      start.value = 'Start bot';
      start.id = 'WikiMonkeyBotStart';
      start.className = classes.botStartStop;
      start.addEventListener('click', this._startAutomatic, false);
      start.disabled = true;
      var startMsg = document.createElement('span');
      startMsg.innerHTML = 'Set and preview the filter first';
      startMsg.id = 'WikiMonkeyBotStartMsg';
      var forceStart = document.createElement('span');
      forceStart.id = 'WikiMonkeyBotForceStart';
      var forceStartCB = document.createElement('input');
      forceStartCB.type = 'checkbox';
      forceStartCB.disabled = true;
      var forceStartLabel = document.createElement('span');
      forceStartLabel.innerHTML = "Force start, stopping any other\n  currently running bots";
      forceStart.style.display = 'none';
      forceStart.appendChild(forceStartCB);
      forceStart.appendChild(forceStartLabel);
      bot.appendChild(fieldset);
      bot.appendChild(start);
      bot.appendChild(startMsg);
      bot.appendChild(forceStart);
      return bot;
    }
  }, {
    key: "_enableStartBot",
    value: function _enableStartBot() {
      document.getElementById('WikiMonkeyBotStartMsg').innerHTML = '';
      return document.getElementById('WikiMonkeyBotStart').disabled = false;
    }
  }, {
    key: "_disableStartBot",
    value: function _disableStartBot(message) {
      document.getElementById('WikiMonkeyBotStartMsg').innerHTML = message;
      return document.getElementById('WikiMonkeyBotStart').disabled = true;
    }
  }, {
    key: "_enableStopBot",
    value: function _enableStopBot(stopId) {
      var self = this;
      var stop = document.createElement('input');
      stop.type = 'button';
      stop.value = 'Stop bot';
      stop.id = 'WikiMonkeyBotStop';
      stop.className = classes.botStartStop;
      stop.addEventListener('click', function (id) {
        return function () {
          clearTimeout(id); // Run _disableStopBot() here, not in _endAutomatic()

          self._disableStopBot();

          self._endAutomatic(true);

          return WM.App.log.info('Bot stopped manually');
        };
      }(stopId), false);
      var start = document.getElementById('WikiMonkeyBotStart');
      start.parentNode.insertBefore(stop, start);
      start.style.display = 'none';
    }
  }, {
    key: "_disableStopBot",
    value: function _disableStopBot() {
      var stop = document.getElementById('WikiMonkeyBotStop');
      stop.parentNode.removeChild(stop);
      return document.getElementById('WikiMonkeyBotStart').style.display = 'inline';
    }
  }, {
    key: "_disableControls",
    value: function _disableControls() {
      return this._setEnableControls(true);
    }
  }, {
    key: "_reEnableControls",
    value: function _reEnableControls() {
      return this._setEnableControls(false);
    }
  }, {
    key: "_setEnableControls",
    value: function _setEnableControls(flag) {
      var fsets = document.getElementById('WikiMonkeyBot').getElementsByTagName('fieldset');
      return Array.from(fsets).map(function (fset) {
        return fset.disabled = flag;
      });
    }
  }, {
    key: "_enableForceStart",
    value: function _enableForceStart() {
      var force = document.getElementById('WikiMonkeyBotForceStart');
      force.getElementsByTagName('input')[0].disabled = false;
      return force.style.display = 'inline';
    }
  }, {
    key: "_disableForceStart",
    value: function _disableForceStart() {
      var force = document.getElementById('WikiMonkeyBotForceStart');
      force.getElementsByTagName('input')[0].checked = false;
      force.getElementsByTagName('input')[0].disabled = true;
      return force.style.display = 'none';
    }
  }, {
    key: "_canForceStart",
    value: function _canForceStart() {
      return document.getElementById('WikiMonkeyBotForceStart').getElementsByTagName('input')[0].checked;
    }
  }, {
    key: "makeFilters",
    value: function makeFilters() {
      this.configuration.filters = [];
      var filters = document.getElementById('WikiMonkeyBotFilter').value.split('\n');

      var _iterator3 = _createForOfIteratorHelper(filters),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var filter = _step3.value;

          // Filter could be an empty string
          if (filter) {
            var regexp;
            var firstSlash = filter.indexOf('/');
            var lastSlash = filter.lastIndexOf('/');
            var pattern = filter.substring(firstSlash + 1, lastSlash);
            var modifiers = filter.substring(lastSlash + 1);
            var negative = filter.charAt(0) === '!';

            try {
              regexp = new RegExp(pattern, modifiers);
            } catch (exc) {
              WM.App.log.error("Invalid regexp: ".concat(exc));
              return false;
            }

            this.configuration.filters.push([regexp, negative]);
          }
        } // Do not return nor break, so that if among the filters
        //   there's an invalid regexp the function returns false

      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      return true;
    }
  }, {
    key: "canProcessPage",
    value: function canProcessPage(link) {
      // Exclude red links (they can be found in some special pages)
      if (link.className.split(' ').indexOf('new') < 0) {
        // Don't use link.title because for example in Category pages all
        //   subpages would include "Category:", thus always matching
        //   filters like "/a/", "/t/" etc.
        var title = link.innerHTML;
        var duplicates = document.getElementById('WikiMonkeyBotDuplicates').checked;

        if (duplicates || this.configuration.visited.indexOf(title) < 0) {
          this.configuration.visited.push(title);
          var filters = this.configuration.filters;
          var inverse = document.getElementById('WikiMonkeyBotInverse').checked;

          if (filters.length > 0) {
            var _iterator4 = _createForOfIteratorHelper(filters),
                _step4;

            try {
              for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
                var filter = _step4.value;
                var regexp = filter[0];
                var negative = filter[1];
                var test = regexp.test(title);

                if (test !== negative) {
                  if (inverse) {
                    return false;
                  }

                  return true;
                }
              } // No (test != negative) condition has been met in the loop

            } catch (err) {
              _iterator4.e(err);
            } finally {
              _iterator4.f();
            }

            if (inverse) {
              return true;
            }

            return false;
          }

          if (inverse) {
            return false;
          }

          return true;
        }

        return false;
      }

      return false;
    }
  }, {
    key: "changeWikiMonkeyLinkClassName",
    value: function changeWikiMonkeyLinkClassName(className, newClass) {
      var elclasses = className.split(' ');
      var newClasses = [];

      var _iterator5 = _createForOfIteratorHelper(elclasses),
          _step5;

      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var cls = _step5.value;

          if (cls.indexOf('WikiMonkey') < 0) {
            newClasses.push(cls);
          }
        } // Don't push in an else block inside the loop, so that if there was
        // no WikiMonkey class set, it will be added

      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }

      newClasses.push(newClass);
      return newClasses.join(' ');
    }
  }, {
    key: "restoreOriginalLinkClassName",
    value: function restoreOriginalLinkClassName(className) {
      var elclasses = className.split(' ');
      var origClasses = [];

      var _iterator6 = _createForOfIteratorHelper(elclasses),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var cls = _step6.value;

          if (cls.indexOf('WikiMonkey') < 0) {
            origClasses.push(cls);
          }
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }

      return origClasses.join(' ');
    }
  }, {
    key: "_previewFilter",
    value: function _previewFilter() {
      var item;
      var items;
      var link;
      var linkId;
      WM.App.log.info('Updating filter preview, please wait ...');

      this._disableStartBot('Updating filter preview ...');

      if (this.configuration.list.previous) {
        if (this.configuration.list.current[0].nodeName === 'TBODY') {
          items = this.configuration.list.previous[0].getElementsByTagName('td');
        } else {
          items = this.configuration.list.previous[0].getElementsByTagName('li');
        }

        linkId = this.configuration.list.previous[1];

        var _iterator7 = _createForOfIteratorHelper(items),
            _step7;

        try {
          for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
            item = _step7.value;
            link = item.getElementsByTagName('a')[linkId]; // The list item could refer to an invalid title, represented
            // by e.g. <span class="mw-invalidtitle">Invalid title with
            // namespace "Category" and text ""</span>

            if (link) {
              link.className = this.restoreOriginalLinkClassName(link.className);
            }
          }
        } catch (err) {
          _iterator7.e(err);
        } finally {
          _iterator7.f();
        }
      }

      this.configuration.visited = [];
      linkId = this.configuration.list.current[1];
      var enable = false;
      var N = 0;

      if (this.makeFilters()) {
        if (this.configuration.list.current[0].nodeName === 'TBODY') {
          items = this.configuration.list.current[0].getElementsByTagName('td');
        } else {
          items = this.configuration.list.current[0].getElementsByTagName('li');
        }

        var _iterator8 = _createForOfIteratorHelper(items),
            _step8;

        try {
          for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
            item = _step8.value;
            link = item.getElementsByTagName('a')[linkId]; // Also test 'link' itself, because the list item could refer
            // to an invalid title, represented by e.g.
            // <span class="mw-invalidtitle">Invalid title with namespace
            // "Category" and text ""</span>

            if (link) {
              if (this.canProcessPage(link)) {
                link.className = this.changeWikiMonkeyLinkClassName(link.className, classes.botSelected);
                enable = true;
                N++;
              } else {
                link.className = this.restoreOriginalLinkClassName(link.className);
              }
            }
          }
        } catch (err) {
          _iterator8.e(err);
        } finally {
          _iterator8.f();
        }
      }

      WM.App.log.info("Preview updated (".concat(N, " pages selected)"));

      if (enable) {
        return this._enableStartBot();
      }

      return this._disableStartBot('No pages selected, reset and preview the filter');
    }
  }, {
    key: "_setBotToken",
    value: function _setBotToken() {
      var date = new Date();
      var token = "".concat(date.getTime());
      this.botToken = token;
      localStorage.setItem('WikiMonkeyBotToken', token);
    }
  }, {
    key: "_resetBotToken",
    value: function _resetBotToken(reset) {
      this.botToken = '0';

      if (reset) {
        localStorage.setItem('WikiMonkeyBotToken', '0');
      }
    }
  }, {
    key: "_getBotToken",
    value: function _getBotToken() {
      return this.botToken;
    }
  }, {
    key: "_checkOtherBotsRunning",
    value: function _checkOtherBotsRunning() {
      var value = localStorage.getItem('WikiMonkeyBotToken'); // Value may be null if it's never been stored in localStorage

      return value && value !== '0' && value !== this._getBotToken();
    }
  }, {
    key: "_startAutomatic",
    value: function _startAutomatic() {
      if (this._checkOtherBotsRunning() && !this._canForceStart()) {
        WM.App.log.error("It's not possible to start the bot (without\n  forcing it) for one of the following reasons:<br>\n  * another bot instance is currently running<br>\n  * a previously running bot has stopped due to a\n  page processing error<br>\n  * a previously running bot has stopped due to a\n  Javascript error<br>\n  * a previously running bot has been interrupted by\n  a browser page refresh");
        return this._enableForceStart();
      } else if (this.makeFilters()) {
        var itemsDOM;

        if (this.configuration.list.current[0].nodeName === 'TBODY') {
          itemsDOM = this.configuration.list.current[0].getElementsByTagName('td');
        } else {
          itemsDOM = this.configuration.list.current[0].getElementsByTagName('li');
        } // Passing the live collection with the callback function was
        //   causing it to be lost in an apparently random manner


        var items = [];

        var _iterator9 = _createForOfIteratorHelper(itemsDOM),
            _step9;

        try {
          for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
            var item = _step9.value;
            items.push(item);
          }
        } catch (err) {
          _iterator9.e(err);
        } finally {
          _iterator9.f();
        }

        var linkId = this.configuration.list.current[1];

        this._disableForceStart();

        this._setBotToken();

        WM.App.log.info('Starting bot ...');
        WM.App.log.hidden("Plugin: ".concat(this.configuration.pluginName));
        WM.App.log.hidden("Filter: ".concat(document.getElementById('WikiMonkeyBotFilter').value));

        this._disableStartBot('Bot is running ...');

        this._disableControls();

        this.configuration.visited = [];
        this.configuration.interval = WM.MW.isUserBot() ? 3000 : 30000;
        return this._processItem(0, items, 0, linkId, null);
      }
    }
  }, {
    key: "makeCallContinue",
    value: function makeCallContinue(lis, id, linkId, ln, article) {
      // eslint-disable-line max-params
      var self = this;
      return function (status, resArgs) {
        switch (status) {
          // The article hasn't been saved
          case 0:
            ln.className = self.changeWikiMonkeyLinkClassName(ln.className, classes.botUnchanged);
            WM.App.log.info("".concat(WM.App.log.WikiLink(article, article), " processed (unchanged)"));
            id++;

            self._processItem(status, lis, id, linkId, resArgs);

            break;
          // The article has been saved

          case 1:
            ln.className = self.changeWikiMonkeyLinkClassName(ln.className, classes.botChanged);
            WM.App.log.info("".concat(WM.App.log.WikiLink(article, article), " processed (changed)"));
            id++;

            self._processItem(status, lis, id, linkId, resArgs);

            break;
          // The plugin has encountered a protectedpage error

          case 'protectedpage':
            ln.className = self.changeWikiMonkeyLinkClassName(ln.className, classes.botBypassed);
            WM.App.log.warning("".concat('This user doesn\'t have the rights to ' + 'edit ').concat(WM.App.log.WikiLink(article, article), ", bypassing it ..."));
            id++; // Change status to 0 (page not changed)

            self._processItem(0, lis, id, linkId, resArgs);

            break;
          // The plugin has encountered a critical error

          default:
            ln.className = self.changeWikiMonkeyLinkClassName(ln.className, classes.botFailed);
            WM.App.log.error("Error processing ".concat(WM.App.log.WikiLink(article, article), ", stopping the bot"));
            return self._endAutomatic(true);
        }
      };
    }
  }, {
    key: "_processItem",
    value: function _processItem(status, items, index, linkId, chainArgs) {
      // eslint-disable-line max-params
      var self = this;

      if (items[index]) {
        var link = items[index].getElementsByTagName('a')[linkId]; // Also test 'link' itself, because the list item could refer to an
        // invalid title, represented by e.g.
        // <span class="mw-invalidtitle">Invalid title with namespace
        // "Category" and text ""</span>

        if (link && this.canProcessPage(link)) {
          var interval;
          var title = link.title;

          if (status === 0) {
            interval = 1000;
          } else {
            interval = this.configuration.interval;
          }

          WM.App.log.info("Waiting ".concat(interval / 1000) + ' seconds ...');
          var stopId = setTimeout(function (lis, id, ln, article, chainArgs) {
            return function () {
              // eslint-disable-line max-params
              // Stop must be disabled before any check is performed
              self._disableStopBot(); // Check here if other bots have been started,
              // _not_ before setTimeout!


              if (!self._checkOtherBotsRunning()) {
                ln.className = self.changeWikiMonkeyLinkClassName(ln.className, classes.botProcessing);
                WM.App.log.info("Processing ".concat(WM.App.log.WikiLink(article, article), " ..."));
                return self.configuration.function_(article, self.makeCallContinue(lis, id, linkId, ln, article), chainArgs);
              }

              WM.App.log.error('Another bot has been ' + 'force-started, stopping ...');
              return self._endAutomatic(false);
            };
          }(items, index, link, title, chainArgs), interval);
          return this._enableStopBot(stopId);
        }

        index++;
        return this._processItem(status, items, index, linkId, chainArgs);
      }

      return this._endAutomatic(true);
    }
  }, {
    key: "_endAutomatic",
    value: function _endAutomatic(reset) {
      this._resetBotToken(reset);

      WM.App.log.info('Bot operations completed (check the log for ' + 'warnings or errors)');

      this._disableStartBot('Bot operations completed, reset and preview ' + 'the filter');

      return this._reEnableControls();
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 48771:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex;

var Fieldset = __webpack_require__(82719);

var Bot = __webpack_require__(78738);

module.exports = (_temp = _class = /*#__PURE__*/function () {
  function _class(_ref) {
    var lists = _ref.lists,
        display = _ref.display,
        displayLog = _ref.displayLog,
        nextNode = _ref.nextNode;

    _classCallCheck(this, _class);

    WM.App.store.commit('fieldset/show', display);
    WM.App.store.commit('log/show', displayLog);
    var root = document.createElement('div');
    $(nextNode).before(root);
    var ui = new Bot(this.constructor.plugins, lists);
    return new Vue({
      el: root,
      store: WM.App.store,
      computed: Vuex.mapState('fieldset', {
        fieldsetDisplayed: 'display'
      }),
      render: function render(h) {
        // Referencing fieldsetDisplayed seems to be the only way to make
        // this component react to its changes
        this.fieldsetDisplayed;
        return h(Fieldset, [h('div', {
          attrs: {
            id: 'WikiMonkeyBot'
          },
          ref: 'container'
        })]);
      },
      mounted: function mounted() {
        return $(this.$refs.container).append(ui.elems);
      },
      updated: function updated() {
        // Needed when showing/hiding the main fieldset
        return $(this.$refs.container).append(ui.elems);
      }
    });
  }

  _createClass(_class, null, [{
    key: "installPlugin",
    value: function installPlugin(plugin, run, makeUI) {
      this.plugins.push([plugin, run, makeUI]);
    }
  }]);

  return _class;
}(), _defineProperty(_class, "plugins", []), _temp);

/***/ }),

/***/ 6658:
/***/ ((module) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports = {
  namespaced: true
};

/***/ }),

/***/ 21220:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _class, _temp;

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex,
    styled = _require.styled;

var Fieldset = __webpack_require__(82719);

var Commands = styled.div({
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'space-between'
});
var Select = styled.select({
  flex: 'auto',
  marginRight: '1em'
});
var Button = styled.button({
  marginRight: '1em'
});
var Checkbox = styled.input({
  marginRight: '0.4em'
});
module.exports = (_temp = _class = /*#__PURE__*/function () {
  function _class(_ref) {
    var pageType = _ref.pageType,
        display = _ref.display,
        displayLog = _ref.displayLog,
        nextNode = _ref.nextNode;

    _classCallCheck(this, _class);

    WM.App.store.commit('fieldset/show', display);
    WM.App.store.commit('log/show', displayLog);
    var plugins = {
      recentchanges: this.constructor.pluginsRecentChanges,
      newpages: this.constructor.pluginsNewPages
    }[pageType];
    var defaultPlugin = WM.conf[{
      recentchanges: 'default_recentchanges_plugin',
      newpages: 'default_newpages_plugin'
    }[pageType]];
    var pluginAutoexecute = WM.conf[{
      recentchanges: 'default_recentchanges_plugin_autoexecute',
      newpages: 'default_newpages_plugin_autoexecute'
    }[pageType]];
    var root = document.createElement('div');
    $(nextNode).before(root);
    return new Vue({
      el: root,
      store: WM.App.store,
      computed: _objectSpread(_objectSpread({}, Vuex.mapState('log', {
        logShown: 'display'
      })), Vuex.mapState('filter', ['selectedPluginIndex', 'selectedPluginInstance', 'selectedPluginRun', 'selectedPluginMakeUI', 'enabled'])),
      methods: _objectSpread(_objectSpread(_objectSpread(_objectSpread({}, Vuex.mapMutations('fieldset', {
        hideUI: 'hide'
      })), Vuex.mapMutations('log', {
        showLog: 'show',
        hideLog: 'hide'
      })), Vuex.mapMutations('filter', ['selectPlugin', 'disable'])), {}, {
        executePlugin: function executePlugin() {
          this.disable();
          this.selectedPluginRun();
        }
      }),
      created: function created() {
        var _this = this;

        plugins.some(function (_ref2, index) {
          var _ref3 = _slicedToArray(_ref2, 3),
              plugin = _ref3[0],
              run = _ref3[1],
              makeUI = _ref3[2];

          if (plugin.constructor.pluginName === defaultPlugin) {
            return _this.selectPlugin([index, plugin, run, makeUI]);
          }

          return false;
        }) || this.selectPlugin([0].concat(_toConsumableArray(plugins[0])));
      },
      render: function render(h) {
        var _this2 = this;

        var pluginUI;
        var selectFilter = h(Select, {
          attrs: {
            disabled: !this.enabled
          },
          on: {
            change: function change(event) {
              var index = event.target.selectedIndex;

              _this2.selectPlugin([index].concat(_toConsumableArray(plugins[index])));
            }
          }
        }, plugins.map(function (plugin, ii) {
          return h('option', {
            attrs: {
              selected: ii === _this2.selectedPluginIndex
            }
          }, [plugin[0].conf.filter_label]);
        }));
        var applyFilter = h(Button, {
          attrs: {
            disabled: !this.enabled
          },
          on: {
            click: this.executePlugin
          }
        }, ['Apply filter']);
        var toggleLog = h(Checkbox, {
          attrs: {
            type: 'checkbox',
            checked: this.logShown
          },
          on: {
            change: function change() {
              return _this2.logShown ? _this2.hideLog() : _this2.showLog();
            }
          }
        });
        var commandsFilterDiv = h(Commands, [selectFilter, applyFilter, toggleLog, h('span', ['Show log'])]);
        var makeUI = this.selectedPluginMakeUI;

        if (makeUI instanceof Function) {
          pluginUI = h('div', {
            ref: 'pluginUI'
          }, [h(makeUI())]);
        }

        return h(Fieldset, [h('div', [commandsFilterDiv, pluginUI])]);
      },
      mounted: function mounted() {
        // The component is remounted if the interface is hidden and then
        // shown again, but the plugin shouldn't be executed again if it's
        // disabled
        if (this.enabled && pluginAutoexecute) {
          this.executePlugin();

          if (!this.$refs.pluginUI) {
            this.hideUI();
          }
        }
      }
    });
  }

  _createClass(_class, null, [{
    key: "installRecentChangesPlugin",
    value: function installRecentChangesPlugin(plugin, run, makeUI) {
      this.pluginsRecentChanges.push([plugin, run, makeUI]);
    }
  }, {
    key: "installNewPagesPlugin",
    value: function installNewPagesPlugin(plugin, run, makeUI) {
      this.pluginsNewPages.push([plugin, run, makeUI]);
    }
  }]);

  return _class;
}(), _defineProperty(_class, "pluginsRecentChanges", []), _defineProperty(_class, "pluginsNewPages", []), _temp);

/***/ }),

/***/ 34066:
/***/ ((module) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports = {
  namespaced: true,
  state: {
    selectedPluginIndex: 0,
    selectedPluginInstance: null,
    selectedPluginRun: null,
    selectedPluginMakeUI: null,
    enabled: true
  },
  mutations: {
    selectPlugin: function selectPlugin(state, _ref) {
      var _ref2 = _slicedToArray(_ref, 4),
          index = _ref2[0],
          instance = _ref2[1],
          run = _ref2[2],
          makeUI = _ref2[3];

      state.selectedPluginIndex = index;
      state.selectedPluginInstance = instance;
      state.selectedPluginRun = run;
      state.selectedPluginMakeUI = makeUI;
    },
    disable: function disable(state) {
      state.enabled = false;
    }
  }
};

/***/ }),

/***/ 18206:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    moment = _require.moment;

var _require2 = __webpack_require__(60306),
    version = _require2.version; // Make sure to initialize the global style


__webpack_require__(51504);

var Store = __webpack_require__(18797);

var _require3 = __webpack_require__(30910),
    WikiLink = _require3.WikiLink;

var _require4 = __webpack_require__(88275),
    PageLink = _require4.PageLink;

var mods = __webpack_require__(10355);

var _require5 = __webpack_require__(89580),
    PersonalToolsCommands = _require5.PersonalToolsCommands;

var _require6 = __webpack_require__(56467),
    PageCommands = _require6.PageCommands;

var _require7 = __webpack_require__(14902),
    SectionCommands = _require7.SectionCommands;

var MainTabs = __webpack_require__(90011);

var Bot = __webpack_require__(48771);

var Filter = __webpack_require__(21220);

var Menu = __webpack_require__(53707);

var initTempLog = function initTempLog(store) {
  return {
    hidden: function hidden(text) {
      return store.commit('log/hidden', text);
    },
    json: function json(component, data) {
      return store.commit('log/json', [component, data]);
    },
    debug: function debug(text) {
      return store.commit('log/debug', text);
    },
    info: function info(text) {
      return store.commit('log/info', text);
    },
    warning: function warning(text) {
      return store.commit('log/warning', text);
    },
    error: function error(text) {
      return store.commit('log/error', text);
    },
    WikiLink: WikiLink,
    PageLink: PageLink
  };
};

module.exports.App = /*#__PURE__*/function () {
  function _class() {
    _classCallCheck(this, _class);

    this.store = new Store().vstore;
    this.log = initTempLog(this.store);
  }

  _createClass(_class, [{
    key: "run",
    value: function run() {
      // eslint-disable-line complexity
      var bodyContent = $('#bodyContent');
      if (bodyContent) new MainTabs(bodyContent);
      var personalTools = $('#p-personal');
      if (personalTools) new PersonalToolsCommands(personalTools);
      var indicators = $('.mw-indicators:first');
      if (indicators) new PageCommands(indicators);
      var editSections = $('.mw-editsection');
      if (editSections.length) new SectionCommands(editSections); // MW seems a bit unreliable with capitalization, e.g. it's
      // "SpecialPages" but "Recentchanges"

      var specialPage = function () {
        var spage = mw.config.get('wgCanonicalSpecialPageName');

        if (spage) {
          return spage.toLowerCase();
        }

        return spage;
      }(); // TODO: Recognize the editor with mw.config.get('wgAction')?


      if ($('#editform').length) {
        new Menu({
          pageType: 'editor',
          display: true,
          displayLog: true,
          nextNode: $('#wpSummaryLabel').parent().next()[0]
        });
        mods.modEditor();
      } else if (mw.config.get('wgDiffNewId')) {
        new Menu({
          pageType: 'diff',
          display: true,
          displayLog: true,
          nextNode: $('#bodyContent h2').first()[0]
        });
      } else if (mw.config.get('wgCanonicalNamespace') === 'Category') {
        new Bot({
          lists: [[$('#mw-pages')[0], 0, 'Pages'], [$('#mw-subcategories')[0], 0, 'Subcategories']],
          display: false,
          displayLog: true,
          nextNode: $('#contentSub')[0]
        });
      } else if (specialPage === 'whatlinkshere') {
        new Bot({
          lists: [[$('#mw-whatlinkshere-list')[0], 0, 'Pages']],
          display: false,
          displayLog: true,
          nextNode: $('#bodyContent form').first().next()[0]
        });
      } else if (specialPage === 'linksearch' && $('#mw-content-text div.mw-spcontent').length) {
        var nextNode = $('#mw-content-text div.mw-spcontent').first()[0];
        new Bot({
          lists: [[$(nextNode).first('ol.special').first()[0], 1, 'Pages']],
          display: false,
          displayLog: true,
          nextNode: nextNode
        });
      } else if (specialPage === 'prefixindex') {
        var _nextNode = $('#mw-content-text div.mw-prefixindex-body').first()[0];
        new Bot({
          lists: [[$(_nextNode).find('ul.mw-prefixindex-list').first()[0], 0, 'Pages']],
          display: false,
          displayLog: true,
          nextNode: _nextNode
        });
      } else if (specialPage === 'specialpages') {
        new Menu({
          pageType: 'special',
          display: true,
          displayLog: true,
          nextNode: $('#contentSub')[0]
        });
      } else if (specialPage === 'recentchanges') {
        new Filter({
          pageType: 'recentchanges',
          display: true,
          displayLog: false,
          nextNode: $('#mw-content-text h4').first()[0]
        });
        mods.modRecentChanges();
      } else if (specialPage === 'newpages') {
        new Filter({
          pageType: 'newpages',
          display: true,
          displayLog: false,
          nextNode: $('#mw-content-text ul').first()[0]
        });
      } else if (specialPage === 'protectedpages') {
        var _nextNode2 = $('#mw-content-text table.mw-protectedpages').first()[0];
        new Bot({
          lists: [[$(_nextNode2).find('tbody').first()[0], 0, 'Pages']],
          display: false,
          displayLog: true,
          nextNode: _nextNode2
        });
      } else if (specialPage === 'contributions') {
        mods.modContributions();
      } else if (['ancientpages', 'brokenredirects', 'deadendpages', 'doubleredirects', 'fewestrevisions', 'lonelypages', 'uncategorizedcategories', 'uncategorizedpages', 'uncategorizedtemplates', 'unusedcategories', 'unwatchedpages'].includes(specialPage)) {
        var _nextNode3 = $('#mw-content-text div.mw-spcontent').first()[0];
        new Bot({
          lists: [[$(_nextNode3).find('ol').first()[0], 0, 'Pages']],
          display: false,
          displayLog: true,
          nextNode: _nextNode3
        });
      } else if (['longpages', 'shortpages'].includes(specialPage)) {
        var _nextNode4 = $('#mw-content-text div.mw-spcontent').first()[0];
        new Bot({
          lists: [[$(_nextNode4).find('ol').first()[0], 1, 'Pages']],
          display: false,
          displayLog: true,
          nextNode: _nextNode4
        });
      } else if (specialPage === 'withoutinterwiki') {
        var _nextNode5 = $('#mw-content-text div.mw-spcontent > p').first()[0];
        new Bot({
          lists: [[$(_nextNode5).nextAll('ol').first()[0], 0, 'Pages']],
          display: false,
          displayLog: true,
          nextNode: _nextNode5
        });
      } else if (specialPage === 'allpages') {
        var _nextNode6 = $('#mw-content-text div.mw-allpages-nav').first()[0];
        new Bot({
          lists: [[$(_nextNode6).nextAll('div.mw-allpages-body').first().find('ul').first()[0], 0, 'Pages']],
          display: false,
          displayLog: true,
          nextNode: _nextNode6
        });
      }

      this.log.hidden("Wiki Monkey version: ".concat(version));
      this.log.hidden("Date: ".concat(moment().format('YYYY-MM-DD Z')));
      this.log.hidden("URL: ".concat(location.href));
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 90011:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _class, _temp;

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex,
    styled = _require.styled;

var WM = __webpack_require__(62352);

var About = __webpack_require__(53102);

var _require2 = __webpack_require__(51504),
    SpacedVertical = _require2.SpacedVertical; // TODO: Derive style from SpacedVertical


var sTabs = styled.div({
  '& > *+*': {
    marginTop: '1em'
  },
  '& a': {
    // Make sure that links are in normal weight
    fontWeight: 'normal'
  }
});
var SelectedTab = styled.a({
  fontWeight: 'bold !important'
});
module.exports = (_temp = _class = /*#__PURE__*/function () {
  function _class(bodyContent) {
    _classCallCheck(this, _class);

    var plugins = _objectSpread(_objectSpread({}, this.constructor.plugins), {}, {
      about: {
        plugin: null,
        tabTitle: 'Show the about interface',
        tabLabel: 'about',
        page: About
      }
    });

    var root = document.createElement('div');
    bodyContent.before(root);
    return new Vue({
      el: root,
      store: WM.App.store,
      computed: _objectSpread({}, Vuex.mapState('main', ['shown', 'selectedTab'])),
      methods: _objectSpread(_objectSpread({}, Vuex.mapMutations('main', ['selectTab'])), Vuex.mapActions('main', {
        closeMain: 'closeAlone'
      })),
      created: function created() {
        this.selectTab(Object.keys(plugins)[0]);
      },
      render: function render(h) {
        var _this = this;

        if (!this.shown) {
          return h('div');
        }

        return h(sTabs, {
          "class": {
            'mw-body-content': true
          }
        }, [h('div', ['[ '].concat(_toConsumableArray(Object.entries(plugins).reduce(function (acc, _ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              name = _ref2[0],
              plugin = _ref2[1];

          return acc.concat([' | ', h(name === _this.selectedTab ? SelectedTab : 'a', {
            attrs: {
              href: "#".concat(name),
              title: plugin.tabTitle
            },
            on: {
              click: function click(event) {
                event.preventDefault();

                _this.selectTab(name);
              }
            }
          }, [plugin.tabLabel])]);
        }, []).slice(1)), [' ]'])), h('div', [h(plugins[this.selectedTab].page)])]);
      }
    });
  }

  _createClass(_class, null, [{
    key: "installPlugin",
    value: function installPlugin(plugin, _ref3) {
      var name = _ref3.name,
          tabTitle = _ref3.tabTitle,
          tabLabel = _ref3.tabLabel,
          page = _ref3.page;

      if (name in this.plugins) {
        throw new Error("Duplicated tab plugin: ".concat(name));
      }

      this.plugins[name] = {
        plugin: plugin,
        tabTitle: tabTitle,
        tabLabel: tabLabel,
        page: page
      };
    }
  }]);

  return _class;
}(), _defineProperty(_class, "plugins", {}), _temp);

/***/ }),

/***/ 45297:
/***/ ((module) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports = {
  namespaced: true,
  state: {
    shown: false,
    selectedTab: null
  },
  mutations: {
    show: function show(state) {
      state.shown = true;
    },
    hide: function hide(state) {
      state.shown = false;
    },
    selectTab: function selectTab(state, tab) {
      state.selectedTab = tab;
    }
  },
  actions: {
    openAlone: function openAlone(_ref) {
      var commit = _ref.commit,
          dispatch = _ref.dispatch;
      dispatch('hideContent', null, {
        root: true
      });
      commit('show');
    },
    closeAlone: function closeAlone(_ref2) {
      var commit = _ref2.commit,
          dispatch = _ref2.dispatch;
      commit('hide');
      dispatch('showContent', null, {
        root: true
      });
    },
    toggleAlone: function toggleAlone(_ref3) {
      var state = _ref3.state,
          dispatch = _ref3.dispatch;
      dispatch(state.shown && 'closeAlone' || 'openAlone');
    }
  }
};

/***/ }),

/***/ 2901:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var makeChangeMenu = function makeChangeMenu(currentMenu, changeMenu) {
  return function (event) {
    currentMenu.hide();
    changeMenu.show();
  };
};

var executeGroupAction = function executeGroupAction(subGroupActions, id) {
  var nextId = id + 1;

  if (subGroupActions[nextId]) {
    var fid = subGroupActions[nextId];

    var callContinue = function callContinue() {
      return executeGroupAction(subGroupActions, nextId);
    };

    return fid[0].apply(fid, _toConsumableArray(fid.slice(1)).concat([callContinue]));
  }

  return false;
};

var makeGroupAction = function makeGroupAction(subGroupActions) {
  return function (event) {
    return executeGroupAction(subGroupActions, -1);
  };
};

module.exports = /*#__PURE__*/function () {
  function _class(plugins, confMenu) {
    var _this = this;

    _classCallCheck(this, _class);

    this.mainDiv = $('<div>');
    var groupActions = {};

    var _iterator = _createForOfIteratorHelper(plugins),
        _step;

    try {
      var _loop = function _loop() {
        var _step$value = _slicedToArray(_step.value, 3),
            plugin = _step$value[0],
            pluginRun = _step$value[1],
            pluginMakeUI = _step$value[2];

        var pluginInst = plugin.conf[confMenu].slice(); // This allows to disable an entry by giving it a menu_entry
        // parameter that evaluates to false

        if (!pluginInst || !pluginInst.length) {
          return "continue";
        }

        var pluginName = plugin.constructor.pluginName;
        var groupAction = void 0;

        if (pluginMakeUI) {
          groupAction = [_this.warnInputNeeded, pluginName];
        } else {
          groupAction = [_this.executeEntryAction, pluginName, pluginRun];
        }

        pluginInst.unshift('WikiMonkeyMenuRoot');
        var currId = false;
        var currMenu = void 0;
        pluginInst.slice(0, -1).forEach(function (label, m) {
          var parentId = currId;
          currId = pluginInst.slice(0, m + 1).join('-').replace(/ /g, '_'); // I can't simply do $("#" + currId) because mainDiv
          // hasn't been added to the DOM tree yet

          var menuSel = _this.mainDiv.children("div[id='".concat(currId, "']"));

          if (menuSel.length) {
            currMenu = menuSel.first();
          } else {
            currMenu = $('<div/>').attr('id', currId).hide().appendTo(_this.mainDiv);
            groupActions[currId] = [];

            if (m > 0) {
              // I can't simply do $("#" + currId) because mainDiv
              // hasn't been added to the DOM tree yet
              var parentMenu = _this.mainDiv.children("div[id='".concat(parentId, "']"));

              $('<input/>').attr('type', 'button').val('<').addClass('margin').click(makeChangeMenu(currMenu, parentMenu)).appendTo(currMenu);
              $('<input/>').attr('type', 'button').val(label).click(makeGroupAction(groupActions[currId])).appendTo(parentMenu);
              $('<input/>').attr('type', 'button').val('>').addClass('margin').click(makeChangeMenu(parentMenu, currMenu)).appendTo(parentMenu);
            }
          }

          groupActions[currId].push(groupAction);
        });
        var entry = $('<input/>').attr('type', 'button').val(pluginInst[pluginInst.length - 1]).addClass('margin').appendTo(currMenu);

        if (pluginMakeUI) {
          entry.click(_this.makeEntryUI(currMenu, pluginName, pluginRun, pluginMakeUI));
        } else {
          entry.click(_this.makeEntryAction(pluginName, pluginRun));
        }
      };

      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var _ret = _loop();

        if (_ret === "continue") continue;
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    var menus = this.mainDiv.children();

    if (menus.length) {
      var execAll = $('<input/>').attr('type', 'button').val('*').addClass('margin').click(makeGroupAction(groupActions.WikiMonkeyMenuRoot)); // I can't simply do $("#" + currId) because mainDiv
      // hasn't been added to the DOM tree yet

      this.mainDiv.children('div[id=\'WikiMonkeyMenuRoot\']').first().prepend(execAll);
      menus.first().show();
    }
  }

  _createClass(_class, [{
    key: "makeEntryUI",
    value: function makeEntryUI(currMenu, pluginName, pluginRun, pluginMakeUI) {
      var _this2 = this;

      return function (event) {
        currMenu.hide();
        var UIdiv = $('<div/>');
        $('<input/>').attr('type', 'button').val('<').addClass('margin').click(function (event2) {
          UIdiv.remove();
          return currMenu.show();
        }).appendTo(UIdiv);
        $('<input/>').attr('type', 'button').val('Execute').click(_this2.makeEntryAction(pluginName, pluginRun)).appendTo(UIdiv);
        var UI = pluginMakeUI();
        return UIdiv.append(UI).insertAfter(currMenu);
      };
    }
  }, {
    key: "makeEntryAction",
    value: function makeEntryAction(pluginName, pluginRun) {
      var _this3 = this;

      return function (event) {
        return _this3.executeEntryAction(pluginName, pluginRun, null);
      };
    }
  }, {
    key: "executeEntryAction",
    value: function executeEntryAction(pluginName, pluginRun, callNext) {
      // eslint-disable-line class-methods-use-this
      WM.App.log.hidden("Plugin: ".concat(pluginName));
      pluginRun(callNext);
    }
  }, {
    key: "warnInputNeeded",
    value: function warnInputNeeded(pluginName, callNext) {
      // eslint-disable-line class-methods-use-this
      WM.App.log.warning("Plugin ".concat(pluginName, "\n      was not executed because it requires input from its interface."));

      if (callNext) {
        callNext();
      }
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 53707:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex,
    styled = _require.styled;

var WM = __webpack_require__(62352);

var Fieldset = __webpack_require__(82719);

var Menu = __webpack_require__(2901);

var Container = styled.div({
  '& input.margin': {
    margin: '0 0.33em 0.33em 0'
  }
});
module.exports = (_temp = _class = /*#__PURE__*/function () {
  function _class(_ref) {
    var pageType = _ref.pageType,
        display = _ref.display,
        displayLog = _ref.displayLog,
        nextNode = _ref.nextNode;

    _classCallCheck(this, _class);

    WM.App.store.commit('fieldset/show', display);
    WM.App.store.commit('log/show', displayLog);
    var root = document.createElement('div');
    $(nextNode).before(root);
    var ui = new Menu({
      editor: this.constructor.pluginsEditor,
      diff: this.constructor.pluginsDiff,
      special: this.constructor.pluginsSpecial
    }[pageType], {
      editor: 'editor_menu',
      diff: 'diff_menu',
      special: 'special_menu'
    }[pageType]);
    return new Vue({
      el: root,
      store: WM.App.store,
      computed: Vuex.mapState('fieldset', {
        fieldsetDisplayed: 'display'
      }),
      render: function render(h) {
        // Referencing fieldsetDisplayed seems to be the only way to make
        // this component react to its changes
        this.fieldsetDisplayed;
        return h(Fieldset, [h(Container, {
          ref: 'container'
        })]);
      },
      mounted: function mounted() {
        return $(this.$refs.container).append(ui.mainDiv);
      },
      updated: function updated() {
        // Needed when showing/hiding the main fieldset
        return $(this.$refs.container).append(ui.mainDiv);
      }
    });
  }

  _createClass(_class, null, [{
    key: "installEditorPlugin",
    value: function installEditorPlugin(plugin, run, makeUI) {
      this.pluginsEditor.push([plugin, run, makeUI]);
    }
  }, {
    key: "installDiffPlugin",
    value: function installDiffPlugin(plugin, run, makeUI) {
      this.pluginsDiff.push([plugin, run, makeUI]);
    }
  }, {
    key: "installSpecialPlugin",
    value: function installSpecialPlugin(plugin, run, makeUI) {
      this.pluginsSpecial.push([plugin, run, makeUI]);
    }
  }]);

  return _class;
}(), _defineProperty(_class, "pluginsEditor", []), _defineProperty(_class, "pluginsDiff", []), _defineProperty(_class, "pluginsSpecial", []), _temp);

/***/ }),

/***/ 74769:
/***/ ((module) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports = {
  namespaced: true
};

/***/ }),

/***/ 10355:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    jssc = _require.jssc;

var WM = __webpack_require__(62352);

var disableEditSummarySubmitOnEnter = function disableEditSummarySubmitOnEnter() {
  return $('#wpSummary').keydown(function (event) {
    // 'keyCode' is deprecated, but not all browsers support 'key' yet
    if (event.key === 'Enter' || typeof event.key === 'undefined' && event.keyCode === 13) {
      event.preventDefault();
      return false;
    }
  });
};

var hideRollbackLinks = function hideRollbackLinks() {
  return jssc({
    '@global span.mw-rollback-link': {
      display: 'none'
    }
  });
};

var scrollToFirstHeading = function scrollToFirstHeading() {
  return window.scrollTo(0, $('#firstHeading').offset().top);
};

module.exports = {
  modEditor: function modEditor() {
    if (WM.conf.disable_edit_summary_submit_on_enter) {
      disableEditSummarySubmitOnEnter();
    }

    if (WM.conf.scroll_to_first_heading) {
      scrollToFirstHeading();
    }
  },
  modRecentChanges: function modRecentChanges() {
    if (WM.conf.hide_rollback_links) {
      hideRollbackLinks();
    }
  },
  modContributions: function modContributions() {
    if (WM.conf.hide_rollback_links) {
      hideRollbackLinks();
    }
  }
};

/***/ }),

/***/ 56467:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _class, _temp;

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex,
    styled = _require.styled;

var sCommands = styled.div({
  '& a': {
    // Make sure that links are in normal weight
    fontWeight: 'normal'
  }
});
var ActiveWM = styled.a({
  fontWeight: 'bold !important'
});
module.exports.PageCommands = (_temp = _class = /*#__PURE__*/function () {
  function _class(container) {
    _classCallCheck(this, _class);

    // Add as a "page status indicator"
    // https://www.mediawiki.org/wiki/Help:Page_status_indicators
    var plugins = this.constructor.plugins;
    var root = document.createElement('div');
    $(container).prepend(root);
    var articleLink = WM.Parser.squashContiguousWhitespace("[[".concat(mw.config.get('wgPageName'), "]]"));
    return new Vue({
      el: root,
      store: WM.App.store,
      computed: _objectSpread({}, Vuex.mapState('main', {
        mainIsShown: 'shown'
      })),
      mounted: function mounted() {
        return WM.Clipboard.enable(this.$refs.copyArticleWikiLink);
      },
      methods: _objectSpread({}, Vuex.mapActions('main', {
        toggleMain: 'toggleAlone'
      })),
      render: function render(h) {
        var _this = this;

        return h(sCommands, {
          "class": {
            'mw-indicator': true
          }
        }, ['[ ', h(this.mainIsShown ? ActiveWM : 'a', {
          attrs: {
            href: '#wiki-monkey',
            title: "".concat(this.mainIsShown && 'Close' || 'Open', " the main Wiki Monkey interface")
          },
          on: {
            click: function click(event) {
              event.preventDefault();
              return _this.toggleMain();
            }
          }
        }, ['WM']), ' | ', h('a', {
          attrs: {
            href: '#copy-article-wiki-link',
            title: "Copy \"".concat(articleLink, "\" to the clipboard"),
            'data-clipboard-text': articleLink
          },
          on: {
            click: function click(event) {
              return event.preventDefault();
            }
          },
          ref: 'copyArticleWikiLink'
        }, ['c'])].concat(_toConsumableArray(plugins.reduce(function (acc, _ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              plugin = _ref2[0],
              component = _ref2[1];

          return acc.concat([' | ', h(component)]);
        }, [])), [' ]']));
      }
    });
  }

  _createClass(_class, null, [{
    key: "installPlugin",
    value: function installPlugin(plugin, component) {
      this.plugins.push([plugin, component]);
    }
  }]);

  return _class;
}(), _defineProperty(_class, "plugins", []), _temp);

/***/ }),

/***/ 89580:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _class, _temp;

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex,
    styled = _require.styled;

module.exports.PersonalToolsCommands = (_temp = _class = /*#__PURE__*/function () {
  function _class(container) {
    _classCallCheck(this, _class);

    var plugins = this.constructor.plugins; // TODO[plugins]: For the moment this is hardcoded to work only on the
    //    watchlist link, keep it simple until more flexibility is needed

    var root = document.createElement('span');
    $('#pt-watchlist').append(' ', root); // eslint-disable-next-line no-new

    new Vue({
      el: root,
      store: WM.App.store,
      render: function render(h) {
        // Note the default ArchWiki skin doesn't support using <sup> here
        // The bracket style was discussed in https://github.com/kynikos/wiki-monkey/issues/238
        return h('span', ['['].concat(_toConsumableArray(plugins.reduce(function (acc, _ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              plugin = _ref2[0],
              component = _ref2[1];

          return acc.concat(['|', h(component)]);
        }, []).slice(1)), [']']));
      }
    });
  }

  _createClass(_class, null, [{
    key: "installPlugin",
    value: function installPlugin(plugin, component) {
      this.plugins.push([plugin, component]);
    }
  }]);

  return _class;
}(), _defineProperty(_class, "plugins", []), _temp);

/***/ }),

/***/ 14902:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _class, _temp;

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(78635),
    Vue = _require.Vue;

module.exports.SectionCommands = (_temp = _class = /*#__PURE__*/function () {
  function _class(editSections) {
    _classCallCheck(this, _class);

    var plugins = this.constructor.plugins;
    editSections.each(function () {
      SectionCommands_(this, plugins);
    });
  }

  _createClass(_class, null, [{
    key: "installPlugin",
    value: function installPlugin(plugin, component) {
      this.plugins.push([plugin, component]);
    }
  }]);

  return _class;
}(), _defineProperty(_class, "plugins", []), _temp);

function SectionCommands_(editSection0, plugins) {
  // eslint-disable-line vars-on-top,no-var
  var editSection = $(editSection0);
  var header = editSection.closest(':header');
  var headline = header.find('.mw-headline');
  var editLink = editSection.children("a:contains('edit')").first();
  var editUri = new mw.Uri(editLink.attr('href')); // Retrieve section's id, number and title now to make sure that their values
  // aren't affected by the following changes to the DOM

  var sectionId = headline[0].id;
  var sectionNumber = parseInt(editUri.query.section, 10);
  var sectionTitle = headline.contents().last().text().trim();
  var root = document.createElement('span');
  editLink.text('e');
  editSection.children().first().after(' ', root, ' | ');
  editSection.children().last().before(' ');
  var sectionLink = WM.Parser.squashContiguousWhitespace("[[#".concat(headline[0].id, "]]"));
  var articleLink = WM.Parser.squashContiguousWhitespace("[[".concat(mw.config.get('wgPageName'), "#").concat(headline[0].id, "]]"));
  return new Vue({
    el: root,
    store: WM.App.store,
    mounted: function mounted() {
      WM.Clipboard.enable(this.$refs.copyArticleWikiLink);
      return WM.Clipboard.enable(this.$refs.copySectionWikiLink);
    },
    render: function render(h) {
      return h('span', [h('a', {
        attrs: {
          // Don't use a fragment such as #scroll-to-top so that the link can
          // also be used to copy the link to the current page from any
          // section
          href: '',
          title: 'Scroll to the top of the page'
        },
        on: {
          click: function click(event) {
            event.preventDefault();
            return window.scrollTo(0, 0);
          }
        }
      }, ['∧']), ' | ', h('a', {
        attrs: {
          href: "#".concat(headline[0].id),
          title: 'Link to this section'
        }
      }, ['§']), ' | ', h('a', {
        attrs: {
          href: '#copy-article-wiki-link',
          title: "Copy \"".concat(articleLink, "\" to the clipboard"),
          'data-clipboard-text': articleLink
        },
        on: {
          click: function click(event) {
            return event.preventDefault();
          }
        },
        ref: 'copyArticleWikiLink'
      }, ['c']), ' | ', h('a', {
        attrs: {
          href: '#copy-section-wiki-link',
          title: "Copy \"".concat(sectionLink, "\" to the clipboard"),
          'data-clipboard-text': sectionLink
        },
        on: {
          click: function click(event) {
            return event.preventDefault();
          }
        },
        ref: 'copySectionWikiLink'
      }, ['#c'])].concat(_toConsumableArray(plugins.reduce(function (acc, _ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            plugin = _ref2[0],
            component = _ref2[1];

        return acc.concat([' | ', h(component, {
          props: {
            editSection: editSection,
            header: header,
            headline: headline,
            sectionId: sectionId,
            sectionNumber: sectionNumber,
            sectionTitle: sectionTitle
          }
        })]);
      }, []))));
    }
  });
}

/***/ }),

/***/ 18797:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex;

var fieldset = __webpack_require__(84762);

var log = __webpack_require__(47599);

var main = __webpack_require__(45297);

var bot = __webpack_require__(6658);

var filter = __webpack_require__(34066);

var menu = __webpack_require__(74769);

module.exports = (_temp = _class = /*#__PURE__*/function () {
  function Store() {
    _classCallCheck(this, Store);

    this.vstore = new Vuex.Store({
      actions: {
        hideContent: function hideContent() {
          return $('#bodyContent').hide();
        },
        showContent: function showContent() {
          return $('#bodyContent').show();
        }
      },
      modules: {
        fieldset: fieldset,
        log: log,
        main: main,
        bot: bot,
        filter: filter,
        menu: menu,
        plugins: {
          namespaced: true,
          modules: this.constructor.plugins
        }
      }
    });
  }

  _createClass(Store, null, [{
    key: "installPlugin",
    value: function installPlugin(pluginName, pluginStore) {
      if (pluginName in this.plugins) {
        throw new Error("Duplicated store module: ".concat(pluginName));
      }

      this.plugins[pluginName] = pluginStore;
    }
  }]);

  return Store;
}(), _defineProperty(_class, "plugins", {}), _temp);

/***/ }),

/***/ 62352:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var mwmodpromise = mw.loader.using(['mediawiki.api', 'mediawiki.notification', 'mediawiki.storage', 'mediawiki.Title', 'mediawiki.Uri', 'mediawiki.user']); // Initialize the libraries immediately (especially core-js and
// regenerator-runtime)

__webpack_require__(78635).init();

var _require = __webpack_require__(78635),
    hh = _require.h;

var _require2 = __webpack_require__(87839),
    upgradePeriodical = _require2.upgradePeriodical;

var _require3 = __webpack_require__(18206),
    App = _require3.App;

var Store = __webpack_require__(18797);

var _require4 = __webpack_require__(89580),
    PersonalToolsCommands = _require4.PersonalToolsCommands;

var _require5 = __webpack_require__(56467),
    PageCommands = _require5.PageCommands;

var _require6 = __webpack_require__(14902),
    SectionCommands = _require6.SectionCommands;

var MainTabs = __webpack_require__(90011);

var Menu = __webpack_require__(53707);

var Filter = __webpack_require__(21220);

var Bot = __webpack_require__(48771); // The ArchPackages module is currently unusable
// ArchPackages = require('./ArchPackages')


var ArchWiki = __webpack_require__(78885);

var Cat = __webpack_require__(86207);

var Clipboard = __webpack_require__(14941);

var DB = __webpack_require__(8563);

var Diff = __webpack_require__(18351);

var Editor = __webpack_require__(13836);

var Interlanguage = __webpack_require__(75559);

var MW = __webpack_require__(44442);

var Parser = __webpack_require__(24192);

var Tables = __webpack_require__(10314);

var WhatLinksHere = __webpack_require__(64781);

var _require7 = __webpack_require__(52313),
    _Plugin = _require7._Plugin;

module.exports.WikiMonkey = /*#__PURE__*/function () {
  function WikiMonkey(wikiName, installedPlugins) {
    var _this = this;

    _classCallCheck(this, WikiMonkey);

    _defineProperty(this, "conf", {
      default_bot_plugin: 'SimpleReplace',
      default_recentchanges_plugin: 'ArchWikiRCFilter',
      default_recentchanges_plugin_autoexecute: true,
      default_newpages_plugin: 'ArchWikiNPFilter',
      default_newpages_plugin_autoexecute: true,
      default_all_plugins_disabled: false,
      update_check_wdays: [6],
      update_check_branch: 'master',
      hide_rollback_links: true,
      disable_edit_summary_submit_on_enter: true,
      scroll_to_first_heading: false
    });

    this.wikiName = wikiName; // If this version of the client was downloaded from a Wiki Monkey server,
    // it will have been served patched with a _WIKI_MONKEY_SERVER_URL global
    // variable; for this same reason there's no need to check that the client
    // and server versions correspond

    this.serverUrl = window._WIKI_MONKEY_SERVER_URL || false; // Retrieving config.json separately from the main script allows to more
    // safely make up for problems such as malformed JSON

    var setup = (this.serverUrl ? this.storeServerConfig() : Promise.resolve()).then(function () {
      _this.setup(installedPlugins);
    });
    Promise.all([mwmodpromise, $.ready, setup]).then(function () {
      return _this.init();
    });
  }

  _createClass(WikiMonkey, [{
    key: "storeServerConfig",
    value: function () {
      var _storeServerConfig = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var data;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return $.getJSON("".concat(this.serverUrl, "config.json")) // Unfortunately $.getJSON() doesn't rethrow JSON-parsing error
                // messages, so I can't handle them in the catch block
                . // Unfortunately $.getJSON() doesn't rethrow JSON-parsing error
                // messages, so I can't handle them in the catch block
                fail(function (jqxhr, textStatus, error) {
                  console.warn('It was not possible to load the configuration from \
the server:', error);
                });

              case 3:
                data = _context.sent;
                _context.next = 9;
                break;

              case 6:
                _context.prev = 6;
                _context.t0 = _context["catch"](0);
                data = false;

              case 9:
                this.configFromServer = data;

              case 10:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 6]]);
      }));

      function storeServerConfig() {
        return _storeServerConfig.apply(this, arguments);
      }

      return storeServerConfig;
    }()
  }, {
    key: "makeServerConfig",
    value: function makeServerConfig() {
      // eslint-disable-line class-methods-use-this
      // I need to abstract this method because it's also used to generate a
      // basic configuration to export from the about screen
      var serverConfig = _defineProperty({
        // Use '#' in front of 'default' so also a possible user explicitly named
        // 'Default' is supported ('#' isn't allowed in user names)
        '#default': {}
      }, mw.config.get('wgUserName'), {});

      if (this.configFromServer) {
        serverConfig = _objectSpread(_objectSpread({}, serverConfig), this.configFromServer);
      }

      return serverConfig;
    }
  }, {
    key: "makeLocalConfig",
    value: function makeLocalConfig() {
      // eslint-disable-line class-methods-use-this
      // I need to abstract this method because it's also used to generate a
      // basic configuration to export from the about screen
      var localConfig = _defineProperty({
        // Use '#' in front of 'default' so also a possible user explicitly named
        // 'Default' is supported ('#' isn't allowed in user names)
        // Note that this is a convention also used on the database server to
        // initialize the default client.json file
        '#default': {}
      }, mw.config.get('wgUserName'), {});

      var localConfigRaw = localStorage.getItem('wikiMonkeyUserConfig');

      if (localConfigRaw) {
        localConfig = _objectSpread(_objectSpread({}, localConfig), JSON.parse(localConfigRaw));
      }

      return localConfig;
    }
  }, {
    key: "importLocalConfig",
    value: function importLocalConfig(config) {
      // eslint-disable-line class-methods-use-this
      // TODO: Validate the file, especially check that it has the root #default
      //       or UserName keys
      localStorage.setItem('wikiMonkeyUserConfig', JSON.stringify(config));
      mw.notification.notify(['The configurtaion was imported successfully, but it will be loaded \
only the next time that this page is ', hh('a', {
        // Using "href: '.'" sends to the Main page
        href: '#reload-page',
        title: 'Reload this page',
        onclick: function onclick(event) {
          event.preventDefault();
          location.reload();
        }
      }, 'reloaded'), ' (same for any other open wiki pages).'], {
        autoHide: false,
        tag: 'WikiMonkey-config-import',
        title: 'Wiki Monkey import configuration.',
        type: 'info'
      });
    }
  }, {
    key: "makeComputedConfig",
    value: function makeComputedConfig() {
      return _objectSpread(_objectSpread({}, this.conf), this.enabledPlugins.reduce(function (acc, plugin) {
        acc[plugin.constructor.pluginName] = plugin.conf;
        return acc;
      }, {}));
    }
  }, {
    key: "setup",
    value: function setup(installedPlugins) {
      var serverConfig = this.makeServerConfig();
      var localConfig = this.makeLocalConfig();
      var nameToUserConfig = {
        serverDefault: serverConfig['#default'],
        serverUser: serverConfig[mw.config.get('wgUserName')],
        localDefault: localConfig['#default'],
        localUser: localConfig[mw.config.get('wgUserName')],
        // mw.loader.load() doesn't return a promise nor support callbacks
        // mw.loader.using() only supports MW modules
        // $.getScript() ignores the cache by default
        // In the end using $.ajax() with setup parameters would be the only
        // option to configure WM in a callback, therefore use a global
        // configuration object for simplicity
        userScript: window.wikiMonkeyConfig || window.wikimonkey_config || {}
      };
      var userConfigs = [nameToUserConfig.serverDefault, nameToUserConfig.serverUser, // The configuration in localStorage is less "noticeable" and may be
      // "forgotten", so to prevent unexpected behavior it's better if the
      // configuration in the User's common.js page overrides the localStorage
      // one, i.e. process the localStorage configuration first
      nameToUserConfig.localDefault, nameToUserConfig.localUser, nameToUserConfig.userScript];

      for (var _i = 0, _userConfigs = userConfigs; _i < _userConfigs.length; _i++) {
        var userConfig = _userConfigs[_i];

        for (var option in userConfig) {
          var value = userConfig[option];

          if (option in this.conf) {
            this.conf[option] = value; // Remove the option from userConfig so at the end it's possible to
            // list the unused/unknown configuration options

            delete userConfig[option];
          }
        }
      }

      var enabledPlugins = [];
      var disabledPlugins = [];

      var _iterator = _createForOfIteratorHelper(installedPlugins),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var Plugin = _step.value;

          if (!(Plugin.prototype instanceof _Plugin)) {
            throw new Error('Plugins must extend _Plugin');
          }

          var plugin = void 0;

          try {
            plugin = new Plugin({
              wikiName: this.wikiName,
              serverUrl: this.serverUrl,
              userConfigs: userConfigs,
              defaultAllPluginsDisabled: this.conf.default_all_plugins_disabled
            });
          } catch (error) {
            // TODO: Properly extend Error, but beware that Babel
            //       doesn't like it without specific plugins
            if (error.message === 'Plugin disabled') {
              disabledPlugins.push(Plugin);
              continue;
            }

            throw error;
          }

          plugin.install({
            store: Store.installPlugin.bind(Store),
            personalToolsCommands: PersonalToolsCommands.installPlugin.bind(PersonalToolsCommands, plugin),
            pageCommands: PageCommands.installPlugin.bind(PageCommands, plugin),
            sectionCommands: SectionCommands.installPlugin.bind(SectionCommands, plugin),
            mainTabs: MainTabs.installPlugin.bind(MainTabs, plugin),
            editor: Menu.installEditorPlugin.bind(Menu, plugin),
            diff: Menu.installDiffPlugin.bind(Menu, plugin),
            special: Menu.installSpecialPlugin.bind(Menu, plugin),
            recentChanges: Filter.installRecentChangesPlugin.bind(Filter, plugin),
            newPages: Filter.installNewPagesPlugin.bind(Filter, plugin),
            bot: Bot.installPlugin.bind(Bot, plugin)
          });
          enabledPlugins.push(plugin);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      for (var _i2 = 0, _Object$entries = Object.entries(nameToUserConfig); _i2 < _Object$entries.length; _i2++) {
        var _Object$entries$_i = _slicedToArray(_Object$entries[_i2], 2),
            configName = _Object$entries$_i[0],
            _userConfig = _Object$entries$_i[1];

        if (!$.isEmptyObject(_userConfig)) {
          console.warn("Unknown ".concat(configName, " configuration options"), _userConfig);
        }
      }

      Object.assign(module.exports, {
        wikiName: this.wikiName,
        serverUrl: this.serverUrl,
        makeServerConfig: this.makeServerConfig,
        makeLocalConfig: this.makeLocalConfig,
        importLocalConfig: this.importLocalConfig,
        makeComputedConfig: this.makeComputedConfig,
        unknownConfig: nameToUserConfig,
        conf: this.conf,
        enabledPlugins: enabledPlugins,
        disabledPlugins: disabledPlugins
      });
    }
  }, {
    key: "init",
    value: function init() {
      Object.assign(module.exports, {
        // The ArchPackages module is currently unusable
        // ArchPackages: new ArchPackages()
        ArchWiki: new ArchWiki(),
        Cat: new Cat(),
        Clipboard: Clipboard,
        DB: this.serverUrl && new DB(this.serverUrl) || null,
        Diff: new Diff(),
        Editor: new Editor(),
        Interlanguage: new Interlanguage(),
        MW: new MW(),
        Parser: new Parser(),
        Tables: new Tables(),
        WhatLinksHere: new WhatLinksHere()
      });
      upgradePeriodical();
      var app = new App();
      module.exports.App = app;
      app.run();
    }
  }]);

  return WikiMonkey;
}();

/***/ }),

/***/ 78885:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var languages = {
  local: 'English',
  names: {
    العربية: {
      subtag: 'ar',
      english: 'Arabic'
    },
    Български: {
      subtag: 'bg',
      english: 'Bulgarian'
    },
    বাংলা: {
      subtag: 'bn',
      english: 'Bengali'
    },
    Bosanski: {
      subtag: 'bs',
      english: 'Bosnian'
    },
    Català: {
      subtag: 'ca',
      english: 'Catalan'
    },
    Čeština: {
      subtag: 'cs',
      english: 'Czech'
    },
    Dansk: {
      subtag: 'da',
      english: 'Danish'
    },
    Deutsch: {
      subtag: 'de',
      english: 'German'
    },
    Ελληνικά: {
      subtag: 'el',
      english: 'Greek'
    },
    English: {
      subtag: 'en',
      english: 'English'
    },
    Esperanto: {
      subtag: 'eo',
      english: 'Esperanto'
    },
    Español: {
      subtag: 'es',
      english: 'Spanish'
    },
    فارسی: {
      subtag: 'fa',
      english: 'Persian'
    },
    Suomi: {
      subtag: 'fi',
      english: 'Finnish'
    },
    Français: {
      subtag: 'fr',
      english: 'French'
    },
    עברית: {
      subtag: 'he',
      english: 'Hebrew'
    },
    Hrvatski: {
      subtag: 'hr',
      english: 'Croatian'
    },
    Magyar: {
      subtag: 'hu',
      english: 'Hungarian'
    },
    'Bahasa Indonesia': {
      subtag: 'id',
      english: 'Indonesian'
    },
    Italiano: {
      subtag: 'it',
      english: 'Italian'
    },
    日本語: {
      subtag: 'ja',
      english: 'Japanese'
    },
    한국어: {
      subtag: 'ko',
      english: 'Korean'
    },
    Lietuvių: {
      subtag: 'lt',
      english: 'Lithuanian'
    },
    'Bahasa Melayu': {
      subtag: 'ms',
      english: 'Malaysian'
    },
    'Norsk Bokmål': {
      subtag: 'nb',
      english: 'Norwegian (Bokmål)'
    },
    Nederlands: {
      subtag: 'nl',
      english: 'Dutch'
    },
    Polski: {
      subtag: 'pl',
      english: 'Polish'
    },
    Português: {
      subtag: 'pt',
      english: 'Portuguese'
    },
    Română: {
      subtag: 'ro',
      english: 'Romanian'
    },
    Русский: {
      subtag: 'ru',
      english: 'Russian'
    },
    Slovenčina: {
      subtag: 'sk',
      english: 'Slovak'
    },
    Српски: {
      subtag: 'sr',
      english: 'Serbian'
    },
    Svenska: {
      subtag: 'sv',
      english: 'Swedish'
    },
    ไทย: {
      subtag: 'th',
      english: 'Thai'
    },
    Türkçe: {
      subtag: 'tr',
      english: 'Turkish'
    },
    Українська: {
      subtag: 'uk',
      english: 'Ukrainian'
    },
    'Tiếng Việt': {
      subtag: 'vi',
      english: 'Vietnamese'
    },
    粵語: {
      subtag: 'yue',
      english: 'Cantonese'
    },
    文言文: {
      subtag: 'lzh',
      english: 'Chinese (Classical)'
    },
    简体中文: {
      subtag: 'zh-hans',
      english: 'Chinese (Simplified)'
    },
    正體中文: {
      subtag: 'zh-hant',
      english: 'Chinese (Traditional)'
    }
  },
  categories: ['العربية', 'Български', 'বাংলা', 'Bosanski', 'Català', 'Čeština', 'Dansk', 'Ελληνικά', 'English', 'Esperanto', 'Español', 'Suomi', 'עברית', 'Hrvatski', 'Magyar', 'Bahasa Indonesia', 'Italiano', '한국어', 'Lietuvių', 'Bahasa Melayu', 'Norsk Bokmål', 'Nederlands', 'Polski', 'Português', 'Română', 'Русский', 'Slovenčina', 'Српски', 'Svenska', 'ไทย', 'Türkçe', 'Українська', '粵語', '文言文', '简体中文', '正體中文'],
  interlanguage: {
    external: ['de', 'fa', 'fr', 'ja'],
    internal: ['ar', 'bg', 'bs', 'cs', 'da', 'el', 'en', 'es', 'fi', 'he', 'hr', 'hu', 'id', 'it', 'ko', 'lt', 'nl', 'pl', 'pt', 'ru', 'sk', 'sr', 'sv', 'th', 'tr', 'uk', 'zh-hans', 'zh-hant']
  }
};
var tablesOfContents = {
  ar: {
    page: 'Table of contents (العربية)',
    root: 'Category:العربية',
    alsoIn: 'also in',
    // TODO: Untranslated, Right-to-left problems
    indentType: ':',
    replace: ['[ _]\\(العربية\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: true
  },
  bg: {
    page: 'Table of contents (Български)',
    root: 'Category:Български',
    alsoIn: 'също в',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Български\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  bn: {
    page: 'Table of contents (বাংলা)',
    root: 'Category:বাংলা',
    alsoIn: 'also in',
    // TODO: Untranslated
    indentType: ':',
    replace: ['[ _]\\(বাংলা\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  bs: {
    page: 'Table of contents (Bosanski)',
    root: 'Category:Bosanski',
    alsoIn: 'also in',
    // TODO: Untranslated
    indentType: ':',
    replace: ['[ _]\\(Bosanski\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  cs: {
    page: 'Table of contents (Čeština)',
    root: 'Category:Čeština',
    alsoIn: 'také v',
    indentType: ':',
    replace: ['[ _]\\(Čeština\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  da: {
    page: 'Table of contents (Dansk)',
    root: 'Category:Dansk',
    alsoIn: 'også i',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Dansk\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  el: {
    page: 'Table of contents (Ελληνικά)',
    root: 'Category:Ελληνικά',
    alsoIn: 'επίσης σε',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Ελληνικά\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  en: {
    page: 'Table of contents',
    root: 'Category:English',
    alsoIn: 'also in',
    indentType: ':',
    replace: null,
    keepAltName: false,
    showIndices: true,
    rightToLeft: false
  },
  es: {
    page: 'Table of contents (Español)',
    root: 'Category:Español',
    alsoIn: 'también en',
    indentType: ':',
    replace: ['[ _]\\(Español\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  fi: {
    page: 'Table of contents (Suomi)',
    root: 'Category:Suomi',
    alsoIn: 'also in',
    // TODO: Untranslated
    indentType: ':',
    replace: ['[ _]\\(Suomi\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  he: {
    page: 'Table of contents (עברית)',
    root: 'Category:עברית',
    alsoIn: 'also in',
    // TODO: Untranslated, Right-to-left problems
    indentType: ':',
    replace: ['[ _]\\(עברית\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: true
  },
  hr: {
    page: 'Table of contents (Hrvatski)',
    root: 'Category:Hrvatski',
    alsoIn: 'također u',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Hrvatski\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  hu: {
    page: 'Table of contents (Magyar)',
    root: 'Category:Magyar',
    alsoIn: 'is',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Magyar\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  id: {
    page: 'Table of contents (Bahasa Indonesia)',
    root: 'Category:Bahasa Indonesia',
    alsoIn: 'juga di',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Bahasa Indonesia\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  it: {
    page: 'Table of contents (Italiano)',
    root: 'Category:Italiano',
    alsoIn: 'anche in',
    indentType: ':',
    replace: ['[ _]\\(Italiano\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  ko: {
    page: 'Table of contents (한국어)',
    root: 'Category:한국어',
    alsoIn: '또한 에',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(한국어\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  lt: {
    page: 'Table of contents (Lietuvių)',
    root: 'Category:Lietuvių',
    alsoIn: 'taip pat ir',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Lietuvių\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  ms: {
    page: 'Table of contents (Bahasa Melayu)',
    root: 'Category:Bahasa Melayu',
    alsoIn: 'juga di',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Bahasa Melayu\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  nl: {
    page: 'Table of contents (Nederlands)',
    root: 'Category:Nederlands',
    alsoIn: 'ook in',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Nederlands\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  pl: {
    page: 'Table of contents (Polski)',
    root: 'Category:Polski',
    alsoIn: 'również w',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Polski\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  pt: {
    page: 'Table of contents (Português)',
    root: 'Category:Português',
    alsoIn: 'também em',
    indentType: ':',
    replace: ['[ _]\\(Português\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  ru: {
    page: 'Table of contents (Русский)',
    root: 'Category:Русский',
    alsoIn: 'Также в',
    indentType: ':',
    replace: ['[ _]\\(Русский\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  sk: {
    page: 'Table of contents (Slovenčina)',
    root: 'Category:Slovenčina',
    alsoIn: 'tiež v',
    indentType: ':',
    replace: ['[ _]\\(Slovenčina\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  sr: {
    page: 'Table of contents (Српски)',
    root: 'Category:Српски',
    alsoIn: 'такође у',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Српски\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  sv: {
    page: 'Table of contents (Svenska)',
    root: 'Category:Svenska',
    alsoIn: 'also in',
    // TODO: Untranslated
    indentType: ':',
    replace: ['[ _]\\(Svenska\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  th: {
    page: 'Table of contents (ไทย)',
    root: 'Category:ไทย',
    alsoIn: 'ยังอยู่ใน',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(ไทย\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  tr: {
    page: 'Table of contents (Türkçe)',
    root: 'Category:Türkçe',
    alsoIn: 'ayrıca',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Türkçe\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  uk: {
    page: 'Table of contents (Українська)',
    root: 'Category:Українська',
    alsoIn: 'також в',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(Українська\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  'yue': {
    page: 'Table of contents (粵語)',
    root: 'Category:粵語',
    alsoIn: 'also in',
    // TODO: Untranslated
    indentType: ':',
    replace: ['[ _]\\(粵語\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  'lzh': {
    page: 'Table of contents (文言文)',
    root: 'Category:文言文',
    alsoIn: '也在',
    // TODO: Unconfirmed
    indentType: ':',
    replace: ['[ _]\\(文言文\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  'zh-hans': {
    page: 'Table of contents (简体中文)',
    root: 'Category:简体中文',
    alsoIn: '同时还属于',
    indentType: ':',
    replace: ['[ _]\\(简体中文\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  },
  'zh-hant': {
    page: 'Table of contents (正體中文)',
    root: 'Category:正體中文',
    // https://wiki.archlinux.org/index.php?title=Talk:Table_of_contents&diff=prev&oldid=663058
    alsoIn: '也在',
    indentType: ':',
    replace: ['[ _]\\(正體中文\\)', '', ''],
    keepAltName: true,
    showIndices: true,
    rightToLeft: false
  }
};

module.exports = /*#__PURE__*/function () {
  function ArchWiki() {
    _classCallCheck(this, ArchWiki);
  }

  _createClass(ArchWiki, [{
    key: "getLocalLanguage",
    value: function getLocalLanguage() {
      return languages.local;
    }
  }, {
    key: "getCategoryLanguages",
    value: function getCategoryLanguages() {
      return languages.categories;
    }
  }, {
    key: "isCategoryLanguage",
    value: function isCategoryLanguage(lang) {
      return languages.categories.indexOf(lang) > -1;
    }
  }, {
    key: "getInterwikiLanguages",
    value: function getInterwikiLanguages() {
      return languages.interlanguage.external.concat(languages.interlanguage.internal);
    }
  }, {
    key: "isInterwikiLanguage",
    value: function isInterwikiLanguage(lang) {
      return this.getInterwikiLanguages().indexOf(lang) > -1;
    }
  }, {
    key: "getInternalInterwikiLanguages",
    value: function getInternalInterwikiLanguages() {
      return languages.interlanguage.internal;
    }
  }, {
    key: "isInternalInterwikiLanguage",
    value: function isInternalInterwikiLanguage(lang) {
      return languages.interlanguage.internal.indexOf(lang) > -1;
    }
  }, {
    key: "getInterlanguageTag",
    value: function getInterlanguageTag(language) {
      return languages.names[language].subtag;
    }
  }, {
    key: "detectLanguage",
    value: function detectLanguage(title) {
      var matches = title.match(/^(.+?)(?:[ _]\(([^\(]+)\))?$/);
      var pureTitle = matches[1];
      var detectedLanguage = matches[2];

      if (!detectedLanguage || !this.isCategoryLanguage(detectedLanguage)) {
        // Language categories are exceptions
        // Don't just use /^[ _]*(.+?)[ _]*$/ but require the whole
        //   namespace+title to be passed as the argument (i.e. including
        //   "Category:")
        var testLangCat = matches[1].match(/^[ _]*[Cc]ategory[ _]*:[ _]*(.+?)[ _]*$/);

        if (testLangCat && this.isCategoryLanguage(testLangCat[1])) {
          detectedLanguage = testLangCat[1];
          pureTitle = matches[1];
        } else {
          detectedLanguage = this.getLocalLanguage();
          pureTitle = matches[0];
        }
      }

      return [pureTitle, detectedLanguage];
    }
  }, {
    key: "findAllInterlanguageLinks",
    value: function findAllInterlanguageLinks(source) {
      // See also WM.Parser.findInterlanguageLinks!!!
      return WM.Parser.findSpecialLinks(source, this.getInterwikiLanguages().join('|'));
    }
  }, {
    key: "findInternalInterlanguageLinks",
    value: function findInternalInterlanguageLinks(source) {
      // See also WM.Parser.findInterlanguageLinks!!!
      return WM.Parser.findSpecialLinks(source, this.getInternalInterwikiLanguages().join('|'));
    }
  }, {
    key: "getTableOfContents",
    value: function getTableOfContents(tag) {
      return tablesOfContents[tag];
    }
  }]);

  return ArchWiki;
}();

/***/ }),

/***/ 86207:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var Async = __webpack_require__(31901);

var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function Cat() {
    _classCallCheck(this, Cat);
  }

  _createClass(Cat, [{
    key: "recurseTree",
    value: function recurseTree(params) {
      params.callChildren = this._recurseTreeCallChildren;
      return Async.recurseTreeAsync(params);
    }
  }, {
    key: "recurseTreeContinue",
    value: function recurseTreeContinue(params) {
      return Async.recurseTreeAsync(params);
    }
  }, {
    key: "_recurseTreeCallChildren",
    value: function _recurseTreeCallChildren(params) {
      return this.getSubCategories(params.node, this._recurseTreeCallChildrenContinue, params);
    }
  }, {
    key: "_recurseTreeCallChildrenContinue",
    value: function _recurseTreeCallChildrenContinue(subCats, params) {
      var _iterator = _createForOfIteratorHelper(subCats),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var subCat = _step.value;
          params.children.push(subCat.title);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return Async.recurseTreeAsync(params);
    }
  }, {
    key: "getSubCategories",
    value: function getSubCategories(parent, call, callArgs) {
      return this._getMembers(parent, 'subcat', call, callArgs);
    }
  }, {
    key: "getAllMembers",
    value: function getAllMembers(parent, call, callArgs) {
      return this._getMembers(parent, null, call, callArgs);
    }
  }, {
    key: "_getMembers",
    value: function _getMembers(name, cmtype, call, callArgs) {
      var query = {
        action: 'query',
        list: 'categorymembers',
        cmtitle: name,
        cmlimit: 500
      };

      if (cmtype) {
        query.cmtype = cmtype;
      }

      return this._getMembersContinue(query, call, callArgs, []);
    }
  }, {
    key: "_getMembersContinue",
    value: function _getMembersContinue(query, call, callArgs, members) {
      return WM.MW.callAPIGet(query, function (res, args) {
        members = members.concat(res.query.categorymembers);

        if (res['query-continue']) {
          query.cmcontinue = res['query-continue'].categorymembers.cmcontinue;
          return this._getMembersContinue(query, call, args, members);
        }

        return call(members, args);
      }, callArgs, null);
    }
  }, {
    key: "getParentsAndInfo",
    value: function getParentsAndInfo(name, call, callArgs) {
      var query = {
        action: 'query',
        prop: 'categories|categoryinfo',
        titles: name,
        clprop: 'hidden',
        cllimit: 500
      };
      return this._getParentsAndInfoContinue(query, call, callArgs, [], null);
    }
  }, {
    key: "_getParentsAndInfoContinue",
    value: function _getParentsAndInfoContinue(query, call, callArgs, parents, info) {
      return WM.MW.callAPIGet(query, function (res, args) {
        var page = Object.values(res.query.pages)[0];

        if (page.categories) {
          parents = parents.concat(page.categories);
        }

        if (page.categoryinfo) {
          info = page.categoryinfo;
        }

        if (res['query-continue']) {
          // Request categoryinfo only once
          query.prop = 'categories';
          query.clcontinue = res['query-continue'].categories.clcontinue;
          return this._getParentsAndInfoContinue(query, call, args, parents, info);
        }

        return call(parents, info, args);
      }, callArgs, null);
    }
  }]);

  return Cat;
}();

/***/ }),

/***/ 14941:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    ClipboardJS = _require.ClipboardJS;

module.exports.enable = function (element) {
  var clipboard = new ClipboardJS(element);
  clipboard.on('success', function () {
    return mw.notification.notify("\"".concat(element.getAttribute('data-clipboard-text'), "\" successfully copied to the clipboard."), {
      title: 'Wiki Monkey',
      type: 'info'
    });
  });
  return clipboard.on('error', function () {
    return mw.notification.notify('Could not copy to the clipboard.', {
      title: 'Wiki Monkey',
      type: 'error'
    });
  });
};

/***/ }),

/***/ 8563:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var logError = function logError(error) {
  mw.notification.notify("The request to the database server failed, try again or inspect the \
error data in the browser's console.", {
    autoHide: false,
    tag: 'WikiMonkey-server-query',
    title: 'Wiki Monkey',
    type: 'error'
  });
};

module.exports = /*#__PURE__*/function () {
  function DB(serverUrl) {
    _classCallCheck(this, DB);

    this.dburl = serverUrl;

    if (!this.dburl.endsWith('/')) {
      this.dburl += '/';
    }
  }

  _createClass(DB, [{
    key: "_sendString",
    value: function _sendString(method, resource, data) {
      if (data == null) {
        data = {};
      }

      return $.ajax({
        method: method,
        url: "".concat(this.dburl).concat(resource, "?").concat($.param(data)),
        dataType: 'json'
      }).fail(logError);
    }
  }, {
    key: "_sendJson",
    value: function _sendJson(method, resource, data) {
      if (data == null) {
        data = {};
      }

      return $.ajax({
        method: method,
        url: this.dburl + resource,
        data: JSON.stringify(data),
        contentType: 'application/json',
        dataType: 'json'
      }).fail(logError);
    }
  }, {
    key: "delete",
    value: function _delete(resource, data) {
      return this._sendString('DELETE', resource, data);
    }
  }, {
    key: "get",
    value: function get(resource, data) {
      return this._sendString('GET', resource, data);
    }
  }, {
    key: "head",
    value: function head(resource, data) {
      return this._sendString('HEAD', resource, data);
    }
  }, {
    key: "options",
    value: function options(resource, data) {
      return this._sendString('OPTIONS', resource, data);
    }
  }, {
    key: "patch",
    value: function patch(resource, data) {
      return this._sendJson('PATCH', resource, data);
    }
  }, {
    key: "post",
    value: function post(resource, data) {
      return this._sendJson('POST', resource, data);
    }
  }, {
    key: "put",
    value: function put(resource, data) {
      return this._sendJson('PUT', resource, data);
    }
  }]);

  return DB;
}();

/***/ }),

/***/ 18351:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function Diff() {
    _classCallCheck(this, Diff);
  }

  _createClass(Diff, [{
    key: "getEndTimestamp",
    value: function getEndTimestamp(call, callArgs) {
      var title = mw.config.get('wgPageName');
      var diff = mw.config.get('wgDiffNewId');
      var oldid = mw.config.get('wgDiffOldId');

      var giveEndTimestamp = function giveEndTimestamp(page, id) {
        return call(page.revisions[id].timestamp, callArgs);
      };

      switch (diff) {
        case 'next':
          var pars = {
            prop: 'revisions',
            titles: title,
            rvlimit: '2',
            rvprop: 'timestamp',
            rvdir: 'newer',
            rvstartid: oldid
          };
          return WM.MW.callQuery(pars, giveEndTimestamp, 1, null);

        case 'prev':
          pars = {
            prop: 'revisions',
            revids: oldid,
            rvprop: 'timestamp'
          };
          return WM.MW.callQuery(pars, giveEndTimestamp, 0, null);

        default:
          pars = {
            prop: 'revisions',
            revids: diff,
            rvprop: 'timestamp'
          };
          return WM.MW.callQuery(pars, giveEndTimestamp, 0, null);
      }
    }
  }]);

  return Diff;
}();

/***/ }),

/***/ 13836:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function Editor() {
    _classCallCheck(this, Editor);
  }

  _createClass(Editor, [{
    key: "getTitle",
    value: function getTitle() {
      return WM.Parser.squashContiguousWhitespace(mw.config.get('wgPageName'));
    }
  }, {
    key: "isSection",
    value: function isSection() {
      if ($('[name=wpSection]').eq(0).val()) {
        return true;
      }

      return false;
    }
  }, {
    key: "readSource",
    value: function readSource() {
      return $('#wpTextbox1').val();
    }
  }, {
    key: "writeSource",
    value: function writeSource(text) {
      return $('#wpTextbox1').val(text);
    }
  }, {
    key: "readSummary",
    value: function readSummary() {
      return $('#wpSummary').val();
    }
  }, {
    key: "writeSummary",
    value: function writeSummary(text) {
      return $('#wpSummary').val(text);
    }
  }, {
    key: "appendToSummary",
    value: function appendToSummary(text) {
      return $('#wpSummary').val(this.readSummary() + text);
    }
  }]);

  return Editor;
}();

/***/ }),

/***/ 75559:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function Interlanguage() {
    _classCallCheck(this, Interlanguage);

    this.parseLinks = this.parseLinks.bind(this);
    this.queryLinks = this.queryLinks.bind(this);
    this.createNewLink = this.createNewLink.bind(this);
    this.createVisitedLink = this.createVisitedLink.bind(this);
    this.collectLinks = this.collectLinks.bind(this);
    this._collectLinksContinue = this._collectLinksContinue.bind(this);
    this.updateLinks = this.updateLinks.bind(this);
  }

  _createClass(Interlanguage, [{
    key: "parseLinks",
    value: function parseLinks(supportedLangs, source, iwmap) {
      var parsedLinks = WM.Parser.findSpecialLinks(source, supportedLangs.join('|'));
      var langlinks = [];

      var _iterator = _createForOfIteratorHelper(parsedLinks),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var link = _step.value;
          // Do not store the tag lowercased, since it should be kept as
          // original
          var lurl;
          var ltag = link.namespace;
          var ltitle = link.title + (link.fragment ? "#".concat(link.fragment) : '');

          var _iterator2 = _createForOfIteratorHelper(iwmap),
              _step2;

          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var iw = _step2.value;

              if (iw.prefix.toLowerCase() === ltag.toLowerCase()) {
                // Fix the url _before_ replacing $1
                lurl = WM.MW.fixInterwikiUrl(iw.url);
                lurl = lurl.replace('$1', encodeURIComponent(WM.Parser.squashContiguousWhitespace(ltitle)));
                break;
              }
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }

          langlinks.push({
            lang: ltag,
            title: ltitle,
            url: lurl,
            index: link.index,
            length: link.length
          });
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return langlinks;
    }
  }, {
    key: "queryLinks",
    value: function queryLinks(queryTitle, title, supportedLangs, whitelist, firstPage, callEnd, callArgs) {
      var _this = this;

      var query = {
        action: 'query',
        prop: 'info|revisions',
        rvprop: 'content|timestamp',
        titles: queryTitle,
        meta: 'siteinfo',
        siprop: 'interwikimap',
        sifilteriw: 'local'
      }; // When called by the bot, if the start page is a redirect itself, it
      // shoudln't be resolved

      if (!firstPage) {
        query.redirects = '1';
      }

      return WM.MW.callAPIGet(query, /*#__PURE__*/function () {
        var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(res, args) {
          var edittoken, error, iwmap, langlinks, source, timestamp, page;
          return regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  if (!res.query.pages) {
                    _context.next = 21;
                    break;
                  }

                  page = Object.values(res.query.pages)[0];

                  if (!page.revisions) {
                    _context.next = 13;
                    break;
                  }

                  error = null;
                  source = page.revisions[0]['*'];
                  timestamp = page.revisions[0].timestamp;
                  _context.next = 8;
                  return WM.MW.getCsrfToken();

                case 8:
                  edittoken = _context.sent;
                  iwmap = res.query.interwikimap;
                  langlinks = _this.parseLinks(supportedLangs, source, iwmap);
                  _context.next = 19;
                  break;

                case 13:
                  // The requested article doesn't exist
                  error = 'nonexisting';
                  source = false;
                  timestamp = false;
                  edittoken = false;
                  iwmap = res.query.interwikimap;
                  langlinks = false;

                case 19:
                  _context.next = 22;
                  break;

                case 21:
                  if (res.query.redirects) {
                    // The requested article is an unsolved redirect
                    // (redirect over interwiki link?)
                    error = 'unsolvedredirect';
                    source = false;
                    timestamp = false;
                    edittoken = false;
                    iwmap = res.query.interwikimap;
                    langlinks = false;
                  } else {
                    // Unknown error
                    error = 'unknown';
                    source = false;
                    timestamp = false;
                    edittoken = false;
                    iwmap = res.query.interwikimap;
                    langlinks = false;
                  }

                case 22:
                  return _context.abrupt("return", callEnd(title, supportedLangs, whitelist, false, error, langlinks, iwmap, source, timestamp, edittoken, args));

                case 23:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }));

        return function (_x, _x2) {
          return _ref.apply(this, arguments);
        };
      }(), callArgs, function (args) {
        return callEnd(title, supportedLangs, whitelist, false, 'unknown', false, false, false, false, false, args);
      });
    }
  }, {
    key: "createNewLink",
    value: function createNewLink(origTag, title, url) {
      return {
        origTag: origTag,
        title: title,
        url: url
      };
    }
  }, {
    key: "createVisitedLink",
    value: function createVisitedLink(origTag, title, url, iwmap, source, timestamp, edittoken, links) {
      var entry = {
        origTag: origTag,
        title: title,
        url: url,
        iwmap: iwmap,
        source: source,
        timestamp: timestamp,
        edittoken: edittoken,
        links: []
      };

      var _iterator3 = _createForOfIteratorHelper(links),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var link = _step3.value;
          entry.links.push(link);
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      return entry;
    }
  }, {
    key: "collectLinks",
    value: function collectLinks(visitedlinks, newlinks, supportedLangs, whitelist, firstPage, callEnd, callArgs) {
      var link;

      for (var tag in newlinks) {
        link = newlinks[tag];
        break;
      }

      if (link) {
        delete newlinks[tag];
        var _link = link,
            url = _link.url;
        var queryTitle = WM.MW.getTitleFromWikiUrl(url);

        if (queryTitle) {
          var _link2 = link,
              origTag = _link2.origTag;
          var _link3 = link,
              title = _link3.title; // If this is the first processed page, it's local for sure, so
          //   query its links in any case. This e.g. prevents the
          //   application from crashing in case the local page is in a
          //   language whose language tag is not in the white list
          // tag is already lower-cased

          if (firstPage || whitelist.indexOf(tag) > -1) {
            WM.App.log.info("Reading ".concat(WM.App.log.PageLink(url, "[[".concat(origTag, ":").concat(title, "]]")), " ..."));
            return this.queryLinks(queryTitle, title, supportedLangs, whitelist, firstPage, this._collectLinksContinue, [url, tag, origTag, visitedlinks, newlinks, callEnd, callArgs]);
          }

          return this._collectLinksContinue(title, supportedLangs, whitelist, firstPage, 'notinwhitelist', [], false, null, null, null, [url, tag, origTag, visitedlinks, newlinks, callEnd, callArgs]);
        }

        WM.App.log.warning("Cannot extract the page title from ".concat(WM.App.log.PageLink(url, decodeURI(url)), ", removing it if it was linked from the processed article"));
        return this.collectLinks(visitedlinks, newlinks, supportedLangs, whitelist, firstPage, callEnd, callArgs);
      }

      return callEnd(visitedlinks, callArgs);
    }
  }, {
    key: "_collectLinksContinue",
    value: function _collectLinksContinue(title, supportedLangs, whitelist, firstPage, error, langlinks, iwmap, source, timestamp, edittoken, args) {
      var url = args[0];
      var tag = args[1];
      var origTag = args[2];
      var visitedlinks = args[3];
      var newlinks = args[4];
      var callEnd = args[5];
      var callArgs = args[6];

      if (error === 'nonexisting') {
        WM.App.log.warning("".concat(WM.App.log.PageLink(url, "[[".concat(origTag, ":").concat(title, "]]")), " seems to point to a non-existing article: removing it if it was linked from the processed article"));
      } else {
        if (error === 'unsolvedredirect') {
          WM.App.log.warning("".concat(WM.App.log.PageLink(url, "[[".concat(origTag, ":").concat(title, "]]")), " will not be checked because it points to an external redirect"));
        } else if (error === 'unknown') {
          WM.App.log.warning("".concat(WM.App.log.PageLink(url, "[[".concat(origTag, ":").concat(title, "]]")), " will not be checked because of an unspecified problem"));
        } else if (error === 'notinwhitelist') {
          WM.App.log.warning("".concat(WM.App.log.PageLink(url, "[[".concat(origTag, ":").concat(title, "]]")), " will not be checked because ").concat(tag, " is not included in the whitelist defined in the configuration"));
        }

        visitedlinks[tag] = this.createVisitedLink(origTag, title, url, iwmap, source, timestamp, edittoken, langlinks);

        var _iterator4 = _createForOfIteratorHelper(langlinks),
            _step4;

        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var link = _step4.value;
            var nlink = newlinks[link.lang.toLowerCase()];
            var vlink = visitedlinks[link.lang.toLowerCase()];

            if (!vlink && !nlink) {
              newlinks[link.lang.toLowerCase()] = this.createNewLink(link.lang, link.title, link.url);
            } else if (vlink && vlink.url !== link.url) {
              // Just ignore any conflicting links and warn the user:
              // if it's a real conflict, the user will investigate it,
              // otherwise the user will ignore it
              WM.App.log.warning("Possibly conflicting interlanguage links: ".concat(WM.App.log.PageLink(link.url, "[[".concat(link.lang, ":").concat(link.title, "]]")), " and ").concat(WM.App.log.PageLink(vlink.url, "[[".concat(link.lang, ":").concat(visitedlinks[link.lang.toLowerCase()].title, "]]"))));
            } else if (nlink && nlink.url !== link.url) {
              // Just ignore any conflicting links and warn the user:
              // if it's a real conflict, the user will investigate it,
              // otherwise the user will ignore it
              WM.App.log.warning("Possibly conflicting interlanguage links: ".concat(WM.App.log.PageLink(link.url, "[[".concat(link.lang, ":").concat(link.title, "]]")), " and ").concat(WM.App.log.PageLink(nlink.url, "[[".concat(link.lang, ":").concat(newlinks[link.lang.toLowerCase()].title, "]]"))));
            }
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      }

      return this.collectLinks(visitedlinks, newlinks, supportedLangs, whitelist, firstPage, callEnd, callArgs);
    }
  }, {
    key: "updateLinks",
    value: function updateLinks(lang, url, iwmap, source, oldlinks, newlinks) {
      var firstLink;
      var link;
      lang = lang.toLowerCase();
      var linkList = [];

      for (var tag in newlinks) {
        if (tag !== lang) {
          link = newlinks[tag];
          var tagFound = false; // New links that were not in the white list will have the
          // "iwmap" attribute false, "timestamp" and "edittoken" null
          // and "links" as an empty array
          // Note the difference between 'iwmap' and 'link.iwmap'

          var _iterator5 = _createForOfIteratorHelper(iwmap),
              _step5;

          try {
            for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
              var iw = _step5.value;

              if (iw.prefix.toLowerCase() === tag.toLowerCase()) {
                linkList.push("[[".concat(link.origTag, ":").concat(link.title, "]]"));
                tagFound = true;
                break;
              }
            }
          } catch (err) {
            _iterator5.e(err);
          } finally {
            _iterator5.f();
          }

          if (!tagFound) {
            WM.App.log.warning("".concat(tag, " interlanguage links are not supported in ").concat(WM.App.log.PageLink(url, "[[".concat(link.origTag, ":").concat(link.title, "]]")), " , ignoring them"));
          }
        }
      }

      linkList.sort(function (a, b) {
        // Sorting is case sensitive by default
        if (a.toLowerCase() > b.toLowerCase()) {
          return 1;
        }

        if (b.toLowerCase() > a.toLowerCase()) {
          return -1;
        }

        return 0;
      });
      var cleanText = '';
      var textId = 0;

      var _iterator6 = _createForOfIteratorHelper(oldlinks),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          link = _step6.value;
          cleanText += source.substring(textId, link.index);
          textId = link.index + link.length;
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }

      cleanText += source.substring(textId);

      if (oldlinks.length) {
        // Insert the new links at the index of the first previous link
        firstLink = oldlinks[0].index;
      } else {
        firstLink = 0;
      }

      var parts = []; // Do not add empty strings to parts, otherwise when it's joined
      //   unnecessary line breaks will be added

      var head = cleanText.substring(0, firstLink).trim();

      if (head) {
        parts.push(head);
      }

      var links = linkList.join('\n');

      if (links) {
        parts.push(links);
      }

      var body = cleanText.substr(firstLink).trim();

      if (body) {
        parts.push(body);
      } // Make sure to preserve the original white space at the end, otherwise
      //   the final (newText != source) may return true even when no actual
      //   change has been made
      // Note that /\s+$/ would return null in the absence of trailing
      //   whitespace, so a further check should be made, while /\s*$/
      //   safely returns an empty string in that case


      var trailws = /\s*$/;
      return parts.join('\n') + trailws.exec(source);
    }
  }]);

  return Interlanguage;
}();

/***/ }),

/***/ 44442:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(78635),
    h = _require.h;

var wikiPaths = {
  known: {
    '^https?://[^\.]+\.wikipedia\.org': {
      "short": '/wiki/',
      full: '/w/index.php',
      api: '/w/api.php'
    },
    '^https?://wiki\.archlinux\.org': {
      "short": '/title/',
      full: '/index.php',
      api: '/api.php'
    },
    '^https?://wiki\.archlinux\.de': {
      "short": '/title/',
      full: '/index.php',
      api: '/api.php'
    },
    '^https?://wiki\.archlinux\.fr': {
      "short": '/',
      full: '/index.php',
      api: '/api.php'
    },
    '^https?://wiki\.archlinux\.jp': {
      "short": '/index.php/',
      full: '/index.php',
      api: '/api.php'
    },
    '^https?://wiki\.archlinux\.ro': {
      "short": '/index.php/',
      full: '/index.php',
      api: '/api.php'
    },
    '^https?://wiki\.archusers\.ir': {
      "short": '/index.php/',
      full: '/index.php',
      api: '/api.php'
    }
  },
  default_: {
    "short": '/index.php?title=',
    full: '/index.php',
    api: '/api.php'
  }
};
var interwikiFixes = [['https://wiki.archlinux.org/index.php/$1_(', 'https://wiki.archlinux.org/index.php/$1%20(']];

module.exports = /*#__PURE__*/function () {
  function MW() {
    _classCallCheck(this, MW);

    this.api = new mw.Api();

    var wpaths = this._getWikiPaths(location.href);

    var hostname = wpaths[0];
    this.localWikiPaths = wpaths[1];
    this.localWikiUrls = {};

    for (var key in this.localWikiPaths) {
      this.localWikiUrls[key] = hostname + this.localWikiPaths[key];
    }
  }

  _createClass(MW, [{
    key: "_getWikiPaths",
    value: function _getWikiPaths(href) {
      // It's necessary to keep this function in a private attribute,
      // otherwise localWikiPaths and localWikiUrls cannot be initialized
      var hostname;
      var p;
      var paths;

      for (var r in wikiPaths.known) {
        var re = new RegExp(r, 'i');
        var match = re.exec(href);

        if (match) {
          hostname = match[0];
          paths = {};

          for (p in wikiPaths.known[r]) {
            paths[p] = wikiPaths.known[r][p];
          }

          break;
        }
      }

      if (!paths) {
        var uri = new mw.Uri(href);
        hostname = uri.host;
        paths = {};

        for (p in wikiPaths.default_) {
          paths[p] = wikiPaths.default_[p];
        }
      }

      return [hostname, paths];
    }
  }, {
    key: "getWikiPaths",
    value: function getWikiPaths(href) {
      if (href) {
        return this._getWikiPaths(href)[1];
      }

      return this.localWikiPaths;
    }
  }, {
    key: "linkArticle",
    value: function linkArticle(page, label) {
      return h('a', {
        href: mw.util.getUrl(page)
      }, label || page);
    }
  }, {
    key: "getWikiUrls",
    value: function getWikiUrls(href) {
      if (href) {
        var wpaths = this._getWikiPaths(href);

        var hostname = wpaths[0];
        var paths = wpaths[1];
        var urls = {};

        for (var key in paths) {
          urls[key] = hostname + paths[key];
        }

        return urls;
      }

      return this.localWikiUrls;
    } // eslint-disable-next-line class-methods-use-this

  }, {
    key: "getTitleFromWikiUrl",
    value: function getTitleFromWikiUrl(url) {
      // Don't use decodeURI(url) because it wouldn't decode some characters like
      // colons, which are required to be decoded instead when making an API call
      var uri = new mw.Uri(url);
      var title = uri.query.title; // Test this *before* the short paths, in fact a short path may just be
      // the full one with the "title" parameter pre-added

      if (!title) {
        var pathname = uri.path;

        for (var r in wikiPaths.known) {
          var re = new RegExp(r, 'iu');
          var match = re.exec(url);

          if (match) {
            if (pathname.indexOf(wikiPaths.known[r]["short"]) === 0) {
              title = pathname.substr(wikiPaths.known[r]["short"].length);
            } else {
              title = false;
            }

            break;
          }
        }

        if (!title) {
          if (pathname.indexOf(wikiPaths.default_["short"]) === 0) {
            title = pathname.substr(wikiPaths.default_["short"].length);
          } else {
            title = false;
          }
        }
      }

      return title === false ? title : decodeURIComponent(title);
    }
  }, {
    key: "failedQueryError",
    value: function failedQueryError(url) {
      if (url) {
        return "Failed query: ".concat(WM.App.log.PageLink(url, url));
      }

      return 'Failed query';
    }
  }, {
    key: "callAPIGet",
    value: function callAPIGet(params, call, callArgs, callError) {
      var _this = this;

      params.format = 'json';
      return this.api.get(params).done(function (data, textStatus, jqXHR) {
        if (call) {
          return call(data, callArgs);
        }
      }).fail(function (jqXHR, textStatus, errorThrown) {
        console.error(jqXHR, textStatus, errorThrown);
        WM.App.log.error(_this.failedQueryError());

        if (confirm('Wiki Monkey error: Failed query\n\nDo you want ' + 'to retry?')) {
          WM.App.log.info('Retrying ...');
          return _this.callAPIGet(params, call, callArgs, callError);
        } else if (callError) {
          return callError(callArgs);
        }
      });
    }
  }, {
    key: "callAPIPost",
    value: function callAPIPost(params, call, callArgs, callError) {
      var _this2 = this;

      params.format = 'json';
      return this.api.post(params).done(function (data, textStatus, jqXHR) {
        if (call) {
          return call(data, callArgs);
        }
      }).fail(function (jqXHR, textStatus, errorThrown) {
        console.error(jqXHR, textStatus, errorThrown);
        WM.App.log.error(_this2.failedQueryError());

        if (confirm('Wiki Monkey error: Failed query\n\nDo you want ' + 'to retry?')) {
          WM.App.log.info('Retrying ...');
          return _this2.callAPIPost(params, call, callArgs, callError);
        } else if (callError) {
          return callError(callArgs);
        }
      });
    }
  }, {
    key: "getCsrfToken",
    value: function () {
      var _getCsrfToken = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return this.callAPIGet({
                  action: 'query',
                  meta: 'tokens',
                  type: 'csrf'
                });

              case 2:
                return _context.abrupt("return", _context.sent.query.tokens.csrftoken);

              case 3:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function getCsrfToken() {
        return _getCsrfToken.apply(this, arguments);
      }

      return getCsrfToken;
    }()
  }, {
    key: "callQuery",
    value: function () {
      var _callQuery = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(params, call, callArgs, callError) {
        var res, error, page;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                params.action = 'query';
                _context2.prev = 1;
                _context2.next = 4;
                return this.callAPIGet(params);

              case 4:
                res = _context2.sent;
                _context2.next = 13;
                break;

              case 7:
                _context2.prev = 7;
                _context2.t0 = _context2["catch"](1);
                error = _context2.t0;

                if (!callError) {
                  _context2.next = 12;
                  break;
                }

                return _context2.abrupt("return", callError(callArgs));

              case 12:
                throw error;

              case 13:
                page = Object.values(res.query.pages)[0];

                if (!call) {
                  _context2.next = 16;
                  break;
                }

                return _context2.abrupt("return", call(page, callArgs));

              case 16:
                return _context2.abrupt("return", page);

              case 17:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this, [[1, 7]]);
      }));

      function callQuery(_x, _x2, _x3, _x4) {
        return _callQuery.apply(this, arguments);
      }

      return callQuery;
    }()
  }, {
    key: "callQueryEdit",
    value: function () {
      var _callQueryEdit = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(title, call, callArgs) {
        var _yield$Promise$all, _yield$Promise$all2, page, edittoken, source, timestamp;

        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.next = 2;
                return Promise.all([this.callQuery({
                  prop: 'info|revisions',
                  rvprop: 'content|timestamp',
                  titles: title
                }), // TODO: Optimize how/when the token is queried; originally it was queried
                //    together with the info|revisions query above through the deprecated
                //    intoken:'edit' flag
                WM.MW.getCsrfToken()]);

              case 2:
                _yield$Promise$all = _context3.sent;
                _yield$Promise$all2 = _slicedToArray(_yield$Promise$all, 2);
                page = _yield$Promise$all2[0];
                edittoken = _yield$Promise$all2[1];
                source = page.revisions[0]['*'];
                timestamp = page.revisions[0].timestamp;

                if (!call) {
                  _context3.next = 10;
                  break;
                }

                return _context3.abrupt("return", call(title, source, timestamp, edittoken, callArgs));

              case 10:
                return _context3.abrupt("return", {
                  source: source,
                  timestamp: timestamp,
                  edittoken: edittoken
                });

              case 11:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function callQueryEdit(_x5, _x6, _x7) {
        return _callQueryEdit.apply(this, arguments);
      }

      return callQueryEdit;
    }()
  }, {
    key: "isUserBot",
    value: function isUserBot() {
      var needle;
      return needle = 'bot', mw.config.get('wgUserGroups').includes(needle);
    }
  }, {
    key: "getBacklinks",
    value: function getBacklinks(bltitle, blnamespace, call, callArgs) {
      var query = {
        action: 'query',
        list: 'backlinks',
        bltitle: bltitle,
        bllimit: 500
      };

      if (blnamespace) {
        query.blnamespace = blnamespace;
      }

      return this._getBacklinksContinue(query, call, callArgs, []);
    }
  }, {
    key: "_getBacklinksContinue",
    value: function _getBacklinksContinue(query, call, callArgs, backlinks) {
      var _this3 = this;

      return this.callAPIGet(query, function (res, args) {
        backlinks = backlinks.concat(res.query.backlinks);

        if (res['query-continue']) {
          query.blcontinue = res['query-continue'].backlinks.blcontinue;
          return _this3._getBacklinksContinue(query, call, args, backlinks);
        }

        return call(backlinks, args);
      }, callArgs, null);
    }
  }, {
    key: "getLanglinks",
    value: function getLanglinks(title, iwmap, call, callArgs) {
      var query = {
        action: 'query',
        prop: 'langlinks',
        titles: title,
        lllimit: 500,
        llurl: '1',
        redirects: '1'
      };

      if (iwmap) {
        query.meta = 'siteinfo';
        query.siprop = 'interwikimap';
        query.sifilteriw = 'local';
      }

      return this._getLanglinksContinue(query, call, callArgs, [], null);
    }
  }, {
    key: "_getLanglinksContinue",
    value: function _getLanglinksContinue(query, call, callArgs, langlinks, iwmap) {
      var _this4 = this;

      return this.callAPIGet(query, function (res, args) {
        var page = Object.values(res.query.pages)[0];
        langlinks = langlinks.concat(page.langlinks);

        if (res.query.interwikimap) {
          iwmap = res.query.interwikimap;
        }

        if (query.meta) {
          delete query.meta;
          delete query.siprop;
          delete query.sifilteriw;
        }

        if (res['query-continue']) {
          query.llcontinue = res['query-continue'].langlinks.llcontinue;
          return _this4._getLanglinksContinue(query, call, args, langlinks, iwmap);
        }

        return call(langlinks, iwmap, args);
      }, callArgs, null);
    }
  }, {
    key: "getInterwikiMap",
    value: function getInterwikiMap(title) {
      return this.callAPIGet({
        action: 'query',
        meta: 'siteinfo',
        siprop: 'interwikimap'
      });
    }
  }, {
    key: "getLocalInterwikiMap",
    value: function getLocalInterwikiMap(title, call, callArgs) {
      return this.callAPIGet({
        action: 'query',
        meta: 'siteinfo',
        siprop: 'interwikimap',
        sifilteriw: 'local'
      }, function (res, args) {
        return call(res.query.interwikimap, args);
      }, callArgs, null);
    }
  }, {
    key: "fixInterwikiUrl",
    value: function fixInterwikiUrl(url) {
      for (var f = 0, end = interwikiFixes.length, asc = end >= 0; asc ? f < end : f > end; asc ? f++ : f--) {
        var furl = url.replace(interwikiFixes[f][0], interwikiFixes[f][1]);

        if (furl !== url) {
          return furl;
        }
      } // Return the unmodified url if no replacement has been done


      return url;
    }
  }, {
    key: "getSpecialList",
    value: function () {
      var _getSpecialList = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(qppage, siprop) {
        var query, results, siteinfo, res, key, info;
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                query = {
                  action: 'query',
                  list: 'querypage',
                  qppage: qppage,
                  qplimit: 500
                };

                if (siprop) {
                  query.meta = 'siteinfo';
                  query.siprop = siprop;
                }

                results = [];
                siteinfo = {};

              case 4:
                if (false) {}

                _context4.next = 7;
                return this.callAPIGet(query);

              case 7:
                res = _context4.sent;
                results = results.concat(res.query.querypage.results);

                for (key in res.query) {
                  info = res.query[key];

                  if (key !== 'querypage') {
                    siteinfo[key] = info;
                  }
                }

                delete query.meta;
                delete query.siprop;

                if (!res['query-continue']) {
                  _context4.next = 15;
                  break;
                }

                query.qpoffset = res['query-continue'].querypage.qpoffset;
                return _context4.abrupt("continue", 4);

              case 15:
                return _context4.abrupt("return", {
                  results: results,
                  siteinfo: siteinfo
                });

              case 18:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function getSpecialList(_x8, _x9) {
        return _getSpecialList.apply(this, arguments);
      }

      return getSpecialList;
    }()
  }, {
    key: "getUserContribs",
    value: function getUserContribs(ucuser, ucstart, ucend, call, callArgs) {
      var query = {
        action: 'query',
        list: 'usercontribs',
        ucuser: ucuser,
        ucprop: '',
        ucstart: ucstart,
        ucend: ucend,
        uclimit: 500
      };
      return this._getUserContribsContinue(query, call, callArgs, []);
    }
  }, {
    key: "_getUserContribsContinue",
    value: function _getUserContribsContinue(query, call, callArgs, results) {
      var _this5 = this;

      return this.callAPIGet(query, function (res, args) {
        results = results.concat(res.query.usercontribs);

        if (res['query-continue']) {
          query.uccontinue = res['query-continue'].usercontribs.uccontinue;
          return _this5._getUserContribsContinue(query, call, args, results);
        }

        return call(results, args);
      }, callArgs, null);
    }
  }]);

  return MW;
}();

/***/ }),

/***/ 24192:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/* eslint-disable max-lines */
// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var RegEx = __webpack_require__(25565);

var Str = __webpack_require__(6368);

var prepareRegexpWhitespace = function prepareRegexpWhitespace(title) {
  return title.replace(/[ _]+/g, '[_ ]+');
};

function prepareTitleCasing(pattern) {
  var firstChar = pattern.charAt(0);
  var fcUpper = firstChar.toUpperCase();
  var fcLower = firstChar.toLowerCase();
  var newPattern = pattern;

  if (fcUpper !== fcLower) {
    newPattern = "[".concat(fcUpper).concat(fcLower, "]").concat(pattern.substr(1));
  }

  return newPattern;
}

module.exports = /*#__PURE__*/function () {
  function Parser() {
    _classCallCheck(this, Parser);
  }

  _createClass(Parser, [{
    key: "squashContiguousWhitespace",
    value: // eslint-disable-next-line class-methods-use-this
    function squashContiguousWhitespace(title) {
      // MediaWiki treats consecutive whitespace characters in titles and
      //   section names as one
      // For example [[Main __ Page#First _ _section]] is the same as
      //   [[Main Page#First section]]
      // Consider trimming the returned text
      return title.replace(/[ _]+/g, ' ');
    } // eslint-disable-next-line class-methods-use-this

  }, {
    key: "neutralizeNowikiTags",
    value: function neutralizeNowikiTags(source) {
      // Empty nowiki tags (<nowiki></nowiki>) must be neutralized as well,
      //   otherwise Tampermonkey will hang, see also
      //   https://github.com/kynikos/wiki-monkey/issues/133
      // Note that the concept of "nesting" doesn't make sense with <nowiki>
      //   tags, so do *not* use Str.findNestedEnclosures
      var OPENLENGTH = 8;
      var CLOSELENGTH = 9;
      var tags = Str.findSimpleEnclosures(source, /<nowi[k\u212A]i>/i, OPENLENGTH, /<\/nowi[k\u212A]i>/i, CLOSELENGTH);
      var maskedText = '';
      var prevId = 0;

      var _iterator = _createForOfIteratorHelper(tags),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var tag = _step.value;
          var maskLength = void 0;
          var maskString = void 0;

          if (tag[1]) {
            maskLength = tag[1] - tag[0] + CLOSELENGTH;
            maskString = Str.padRight('', 'x', maskLength);
            maskedText += source.substring(prevId, tag[0]) + maskString;
            prevId = tag[1] + CLOSELENGTH;
            continue;
          } else {
            // If a <nowiki> tag is left open (no closing tag is found), it
            //   does its job until the end of the text
            // This also neutralizes the final \n, but it shouldn't matter
            maskLength = source.substr(tag[0]).length;
            maskString = Str.padRight('', 'x', maskLength);
            maskedText += source.substring(prevId, tag[0]) + maskString;
            prevId = source.length;
            break;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      maskedText += source.substring(prevId);
      return maskedText;
    } // eslint-disable-next-line class-methods-use-this

  }, {
    key: "dotEncode",
    value: function dotEncode(text) {
      return encodeURIComponent(text).replace(/%/g, '.');
    } // eslint-disable-next-line class-methods-use-this

  }, {
    key: "dotEncodeLinkBreakingFragmentCharacters",
    value: function dotEncodeLinkBreakingFragmentCharacters(fragment) {
      // These characters are known to break internal links if found in
      //   fragments
      // This function is not tested on link paths or anchors!
      var newFragment = fragment;
      newFragment = newFragment.replace(/\[/g, '.5B');
      newFragment = newFragment.replace(/\]/g, '.5D');
      newFragment = newFragment.replace(/\{/g, '.7B');
      newFragment = newFragment.replace(/\}/g, '.7D');
      newFragment = newFragment.replace(/\|/g, '.7C');
      return newFragment;
    }
  }, {
    key: "compareArticleTitles",
    value: function compareArticleTitles(title1, title2) {
      // Actually also namespaces should be kept into account,
      // e.g. 'Help:Title' and 'Help:title' should return true
      var t1 = prepareTitleCasing(this.squashContiguousWhitespace(title1).trim());
      var t2 = prepareTitleCasing(this.squashContiguousWhitespace(title2).trim());
      return t1 === t2;
    }
  }, {
    key: "findBehaviorSwitches",
    value: function findBehaviorSwitches(source, word) {
      var regExp;
      var newSource = this.neutralizeNowikiTags(source);

      if (word) {
        // Behavior switches aren't case-sensitive
        regExp = new RegExp("__".concat(mw.util.escapeRegExp(word), "__"), 'giu');
      } else {
        // Behavior switches aren't case-sensitive
        // eslint-disable-next-line prefer-named-capture-group
        regExp = new RegExp('__(TOC|NOTOC|FORCETOC|NOEDITSECTION|' + 'NEWSECTIONLINK|NONEWSECTIONLINK|NOGALLERY|HIDDENCAT|' + 'NOCONTENTCONVERT|NOCC|NOTITLECONVERT|NOTC|INDEX|' + 'NOINDEX|STATICREDIRECT|START|END)__', 'giu');
      }

      return RegEx.matchAll(newSource, regExp);
    } // eslint-disable-next-line max-params

  }, {
    key: "findLinksEngine",
    value: function findLinksEngine(source, titlePattern, specialOnly, caseSensitive) {
      // Links cannot contain other links, not even in the alternative text
      //   (only the innermost links are valid)
      // Make sure to prepare whitespace in titlePattern like in
      //   prepareRegexpWhitespace
      // Do *not* use the g flag, or when using RegExp.exec the index will
      //   have to be reset at every loop
      var flags = caseSensitive ? '' : 'i'; // The following colon/space combinations are valid
      //   "[[a:b#c|d]]"
      //   "[[ a:b#c|d]]"
      //   "[[ :a:b#c|d]]"
      //   "[[ : a:b#c|d]]"
      //   "[[:a:b#c|d]]"
      //   "[[: a:b#c|d]]"
      //   "[[::a:b#c|d]]"
      //   "[[: :a:b#c|d]]"
      //   "[[:: a:b#c|d]]"
      //   "[[: : a:b#c|d]]"
      // A link like "[[ ::a:b#c|d]]" isn't valid, but it would still be
      //   found when specialOnly is false (bug #166)

      var special = specialOnly ? '(?:[ _]+:)?[ _]*' : '(?:\\:?[ _]*){0,2}';
      var regExp = new RegExp("^".concat(special, "(").concat(titlePattern, ")") + '[ _]*(?:\\|[_\\s]*([\\s\\S]+?)[_\\s]*)?[_\\s]*$', flags);
      var nSource = this.neutralizeNowikiTags(source);
      var links = [];
      var dbraces = Str.findInnermostEnclosures(nSource, '[[', ']]');

      var _iterator2 = _createForOfIteratorHelper(dbraces),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var dbrace = _step2.value;
          var inText = source.substring(dbrace[0] + 2, dbrace[1]);
          var match = regExp.exec(inText);

          if (match) {
            var push = true;

            if (match[6]) {
              // Incomplete templates in the alternative text have an
              //   apparently weird behaviour, hard to reverse-engineer,
              //   so issue a warning when one is found
              //   See also the examples in findTransclusionArguments
              // Note that the title already doesn't allow "{" or "}"
              var nText = this.neutralizeNowikiTags(match[6]); // eslint-disable-next-line prefer-destructuring

              var maskedText = Str.findNestedEnclosures(nText, '{{', '}}', 'x')[1]; // eslint-disable-next-line prefer-named-capture-group

              if (maskedText.search(/(\{\{|\}\})/) > -1) {
                WM.App.log.warning("[[".concat(match[0], "]] seems to contain part of a template, and the resulting behaviour cannot be predicted by this function, so the link will be ignored altogether"));
                push = false;
              }
            }

            if (push) {
              links.push({
                rawLink: "[[".concat(match[0], "]]"),
                link: match[1],
                rawTitle: match[2],
                namespace: match[3],
                title: match[4],
                fragment: match[5],
                anchor: match[6],
                index: dbrace[0],
                length: dbrace[1] + 2 - dbrace[0]
              });
            }
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return links;
    }
  }, {
    key: "findSectionLinks",
    value: function findSectionLinks(source) {
      // Keep the capturing groups as required by findLinksEngine
      var fragmentChars = '[^\\n\\{\\}\\[\\]\\|]*?';
      var titlePattern = "(()())#(".concat(fragmentChars, ")");
      return this.findLinksEngine(source, titlePattern, false, true);
    }
  }, {
    key: "findInternalLinks",
    value: function findInternalLinks(source, namespace, title) {
      // Keep the capturing groups as required by findLinksEngine
      var caseSensitive;
      var retitle;
      var titlePattern;
      var namespaceChars = '[^\\n\\{\\}\\[\\]\\|\\:\\#]+?';
      var titleChars = '[^\\n\\{\\}\\[\\]\\|\\#]+?';
      var fragmentChars = '[^\\n\\{\\}\\[\\]\\|]*?';

      if (namespace) {
        var rens = prepareRegexpWhitespace(mw.util.escapeRegExp(namespace));

        if (title) {
          retitle = prepareRegexpWhitespace(mw.util.escapeRegExp(title));
          titlePattern = "".concat("((".concat(rens, ")[ _]*:[ _]*") + '(').concat(retitle, "))") + "(?:[ _]*#(".concat(fragmentChars, "))?"); // Namespaces wouldn't be case-sensitive, but titles are, so be
          //   safe and don't use the i flag

          caseSensitive = true;
        } else {
          titlePattern = "".concat("((".concat(rens, ")[ _]*:[ _]*") + '(').concat(titleChars, "))") + "(?:[ _]*#(".concat(fragmentChars, "))?"); // Namespaces aren't case-sensitive

          caseSensitive = false;
        }
      } else if (title) {
        retitle = prepareRegexpWhitespace(mw.util.escapeRegExp(title)); // Keep the capturing groups as required by findLinksEngine

        titlePattern = "".concat("(()(".concat(retitle, "))") + '(?:[ _]*#(').concat(fragmentChars, "))?"); // Titles are case-sensitive

        caseSensitive = true;
      } else {
        titlePattern = "".concat("((?:(".concat(namespaceChars, ")[ _]*:[ _]*)?") + '(').concat(titleChars, "))") + "(?:[ _]*#(".concat(fragmentChars, "))?");
        caseSensitive = true;
      }

      return this.findLinksEngine(source, titlePattern, false, caseSensitive);
    }
  }, {
    key: "findInterwikiLinks",
    value: function findInterwikiLinks(source, wiki) {
      return this.findInternalLinks(source, wiki);
    }
  }, {
    key: "findSpecialLinks",
    value: function findSpecialLinks(source, pattern) {
      // Make sure to prepare whitespace in pattern like in
      //   prepareRegexpWhitespace
      // Keep the capturing groups as required by findLinksEngine
      // See also WM.ArchWiki.findAllInterlanguageLinks
      var titleChars = '[^\\n\\{\\}\\[\\]\\|\\#]+?';
      var fragmentChars = '[^\\n\\{\\}\\[\\]\\|]*?';
      var titlePattern = "".concat("((".concat(pattern, ")[ _]*:[ _]*") + '(').concat(titleChars, "))") + "(?:[ _]*#(".concat(fragmentChars, "))?"); // Categories and language tags aren't case-sensitive

      return this.findLinksEngine(source, titlePattern, true, false);
    }
  }, {
    key: "findCategories",
    value: function findCategories(source) {
      return this.findSpecialLinks(source, 'Category');
    }
  }, {
    key: "findInterlanguageLinks",
    value: function findInterlanguageLinks(source, language) {
      // See also WM.ArchWiki.findAllInterlanguageLinks
      return this.findSpecialLinks(source, mw.util.escapeRegExp(language));
    }
  }, {
    key: "findVariables",
    value: function findVariables(source, variable) {
      // There don't seem to exist variable names with whitespace, applying
      //   prepareRegexpWhitespace could be dangerous in this case
      var pattern = mw.util.escapeRegExp(variable);
      return this.findVariablesPattern(source, pattern);
    }
  }, {
    key: "findVariablesPattern",
    value: function findVariablesPattern(source, pattern) {
      // Pattern must be a string and IT MUST NOT HAVE ANY CAPTURING
      //   GROUPS
      // There can't be an underscore before the variable name
      // There can't be a whitespace between the variable name and the colon
      var nSource = this.neutralizeNowikiTags(source);
      var results = [];

      var _Str$findNestedEnclos = Str.findNestedEnclosures(nSource, '{{', '}}', 'x'),
          _Str$findNestedEnclos2 = _slicedToArray(_Str$findNestedEnclos, 1),
          dbrackets = _Str$findNestedEnclos2[0];

      var _iterator3 = _createForOfIteratorHelper(dbrackets),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var dbracket = _step3.value;
          var inText = source.substring(dbracket[0] + 2, dbracket[1]); // Variables are case-sensitive
          // Do *not* use the g flag, or when using RegExp.exec the index
          //   will have to be reset at every loop
          // BUG[upstream]: As at May 2021 at least Firefox doesn't support the 'u'
          //    flag here
          // eslint-disable-next-line require-unicode-regexp

          var regExp = new RegExp("^\\s*(".concat(pattern, ")(?:\\:\\s*([\\s\\S]*?))?\\s*$"), '');
          var match = regExp.exec(inText);

          if (match) {
            results.push({
              rawVariable: "{{".concat(match[0], "}}"),
              name: match[1],
              value: match[2],
              index: dbracket[0],
              length: dbracket[1] + 2 - dbracket[0]
            });
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      return results;
    }
  }, {
    key: "findTransclusionsEngine",
    value: function findTransclusionsEngine(source, pattern, templatesOnly) {
      // Pattern must be a string and IT MUST NOT HAVE ANY CAPTURING
      //   GROUPS
      // Make sure to prepare whitespace in pattern like in
      //   prepareRegexpWhitespace
      // The difference between generic transclusions and templates is the
      //   possibility of a colon before the title which forces the
      //   transclusion of a page instead of a template
      // There can't be an underscore before the colon
      // The title must not be broken by new line characters; any underscores
      //   must be in the same line as the title, even though then they are
      //   considered as whitespace
      // Template names are case-sensitive, just make sure to prepare them
      //   with prepareTitleCasing
      // Do *not* use the g flag, or when using RegExp.exec the index will
      //   have to be reset at every loop
      var regExp = new RegExp("".concat("^(\\s*".concat(templatesOnly ? '' : ':?', "[_ ]*("), pattern, ")[_ ]*\\s*)(?:\\|([\\s\\S]*))?$"), 'u');
      var nSource = this.neutralizeNowikiTags(source);
      var transclusions = [];

      var _Str$findNestedEnclos3 = Str.findNestedEnclosures(nSource, '{{', '}}', 'x'),
          _Str$findNestedEnclos4 = _slicedToArray(_Str$findNestedEnclos3, 1),
          dbrackets = _Str$findNestedEnclos4[0];

      var _iterator4 = _createForOfIteratorHelper(dbrackets),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var dbracket = _step4.value;
          var inText = source.substring(dbracket[0] + 2, dbracket[1]);
          var match = regExp.exec(inText);

          if (match) {
            // 3 is the length of "{{" + the first "|"
            var argIndex = dbracket[0] + match[1].length + 3;
            transclusions.push({
              rawTransclusion: "{{".concat(match[0], "}}"),
              title: match[2],
              index: dbracket[0],
              length: dbracket[1] - dbracket[0] + 2,
              arguments: this.findTransclusionArguments(match, argIndex)
            });
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }

      return transclusions;
    }
  }, {
    key: "findTransclusionArguments",
    value: function findTransclusionArguments(match, argIndex) {
      // eslint-disable-next-line prefer-destructuring
      var rawArguments = match[3];
      var args = [];

      if (rawArguments) {
        var nArgs = this.neutralizeNowikiTags(rawArguments); // Mask any inner links, so that their "|" characters won't be
        //   interpreted as belonging to the template
        //   Note that double braces ("[[]]") "escape" a pipe in a template
        //   argument even if a link is not correctly formed, e.g. [[|]] or
        //   using unallowed characters etc.
        // eslint-disable-next-line prefer-destructuring

        var maskedArgs = Str.findNestedEnclosures(nArgs, '[[', ']]', 'x')[1]; // Mask any inner templates, so that their "|" characters won't be
        //   interpreted as belonging to the outer template
        // eslint-disable-next-line prefer-destructuring

        maskedArgs = Str.findNestedEnclosures(maskedArgs, '{{', '}}', 'x')[1]; // Also tables would have pipes, but using tables inside templates
        //   doesn't seem to be supported by MediaWiki, except if enclosing
        //   them in special parser functions, e.g.
        //   http://www.mediawiki.org/wiki/Extension:Pipe_Escape which
        //   would then be safely masked by the function above
        // Incomplete links and templates in the arguments text have an
        //   apparently weird behaviour, hard to reverse-engineer, so issue
        //   a warning when one is found
        //   Try for example the following cases:
        //     000{{hc|BBB[[AAA|ZZZ}}CCC]]111
        //     000{{hc|BBB[[AAA}}CCC|ZZZ]]111
        //     000[[BBB{{hc|AAA|ZZZ]]CCC}}111
        //     000{{hc|BBB[[AAA|ZZZ}}[[KKK]]111000{{hc|AAA|BBB}}111
        //     {{bc|{{Accuracy|[[test}}]]}}
        //     {{bc|{{Accuracy|[[test|}}]]}}
        //     {{Accuracy|[[}}]]
        //     {{Accuracy|[[test|}}]]
        //     [[{{Accuracy|]]}}
        //     [[test|{{Accuracy|]]}}
        //     [[test|{{Accuracy|]]
        //     [[test|{{ic|aaa]]}}
        //   Note that the title already doesn't allow "{", "}", "[" nor
        //     "]"
        // eslint-disable-next-line prefer-named-capture-group

        if (maskedArgs.search(/(\{\{|\}\}|\[\[|\]\])/) > -1) {
          WM.App.log.warning("{{".concat(match[0], "}} seems to contain part of a link or template, and the resulting behaviour cannot be predicted by this function, so the whole template will be ignored altogether"));
        } else {
          var mArgs = maskedArgs.split('|');
          var relIndex = 0;

          var _iterator5 = _createForOfIteratorHelper(mArgs),
              _step5;

          try {
            for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
              var mArgument = _step5.value;
              var key = void 0;
              var keyIndex = void 0;
              var value = void 0;
              var valueIndex = void 0;
              var argL = mArgument.length;
              var argument = rawArguments.substr(relIndex, argL);
              var eqIndex = mArgument.indexOf('='); // EqIndex must be > 0, not -1, in fact the key must not be
              //   empty

              if (eqIndex > 0) {
                var rawKey = argument.substring(0, eqIndex); // eslint-disable-next-line prefer-named-capture-group

                var reKey = /^([\t-\r \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF]*)((?:[\0-\t\x0B\f\x0E-\u2027\u202A-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+?)[\t-\r \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF]*$/;
                var keyMatches = reKey.exec(rawKey); // eslint-disable-next-line prefer-destructuring

                key = keyMatches[2];
                keyIndex = argIndex + (keyMatches[1] ? keyMatches[1].length : 0); // 1 is the length of "="

                value = argument.substr(eqIndex + 1);
                valueIndex = argIndex + keyMatches[0].length + 1;
              } else {
                key = null;
                keyIndex = null;
                value = argument;
                valueIndex = argIndex;
              }

              args.push({
                key: key,
                key_index: keyIndex,
                value: value,
                value_index: valueIndex
              }); // 1 is the length of "|"

              relIndex += argL + 1;
            }
          } catch (err) {
            _iterator5.e(err);
          } finally {
            _iterator5.f();
          }
        }
      }

      return args;
    }
  }, {
    key: "findTemplates",
    value: function findTemplates(source, template) {
      var pattern;

      if (template) {
        pattern = mw.util.escapeRegExp(template);
        pattern = prepareRegexpWhitespace(pattern);
        pattern = prepareTitleCasing(pattern);
      } else {
        pattern = '[^\\n\\{\\}\\[\\]\\||\\#]+?';
      }

      return this.findTemplatesPattern(source, pattern);
    }
  }, {
    key: "findTemplatesPattern",
    value: function findTemplatesPattern(source, pattern) {
      // Pattern must be a string and IT MUST NOT HAVE ANY CAPTURING
      //   GROUPS
      // Make sure to prepare whitespace in pattern like in
      //   prepareRegexpWhitespace
      // Templates can't be transcluded with a colon before the title
      // The title must not be broken by new line characters; any underscores
      //   must be in the same line as the title, even though then they are
      //   considered as whitespace
      return this.findTransclusionsEngine(source, pattern, true);
    }
  }, {
    key: "findTransclusions",
    value: function findTransclusions(source, namespace, title) {
      // The difference from templates is the possibility of a colon before
      //   the title which forces the transclusion of a page instead of a
      //   template
      // There can't be an underscore before the colon
      // The title must not be broken by new line characters; any underscores
      //   must be in the same line as the title, even though then they are
      //   considered as whitespace
      var namespacePattern;
      var pattern;
      var titlePattern;
      var titleChars = '[^\\n\\{\\}\\[\\]\\||\\#]+?';

      if (namespace) {
        namespacePattern = mw.util.escapeRegExp(namespace);
        namespacePattern = prepareRegexpWhitespace(namespacePattern);
        namespacePattern = prepareTitleCasing(namespacePattern);
      }

      if (title) {
        titlePattern = mw.util.escapeRegExp(title);
        titlePattern = prepareRegexpWhitespace(titlePattern);
        titlePattern = prepareTitleCasing(titlePattern);
      }

      if (namespacePattern && titlePattern) {
        pattern = "".concat(namespacePattern, "[ _]*:[ _]*").concat(titlePattern);
      } else if (!namespacePattern && titlePattern) {
        pattern = titlePattern;
      } else if (namespacePattern && !titlePattern) {
        pattern = "".concat(namespacePattern, "[ _]*:").concat(titleChars);
      } else {
        pattern = titleChars;
      }

      return this.findTransclusionsEngine(source, pattern, false);
    }
  }, {
    key: "findSectionHeadings",
    value: function findSectionHeadings(source) {
      // ======Title====== is the deepest level supported
      var MAXLEVEL = 6;
      var sections = [];
      var minLevel = MAXLEVEL;
      var maxTocLevel = 0;
      var tocLevel = 1; // eslint-disable-next-line prefer-named-capture-group

      var regExp = /^(=+([ _]*((?:[\0-\t\x0B\f\x0E-\u2027\u202A-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+?)[ _]*)=+)[\t ]*$/gm;
      var prevLevels; // eslint-disable-next-line no-constant-condition

      while (true) {
        var match = regExp.exec(source);

        if (match) {
          var L0 = match[0].length; // eslint-disable-next-line prefer-destructuring

          var line = match[1]; // eslint-disable-next-line prefer-destructuring

          var rawheading = match[2]; // eslint-disable-next-line prefer-destructuring

          var heading = match[3];
          var cleanheading = this.squashContiguousWhitespace(heading);
          var L1 = line.length;
          var level = 1;
          var start = '=';
          var end = '='; // ==Title=== and ===Title== are both 2nd levels and so on
          // (the shortest sequence of = between the two sides is
          //  considered)
          // = and == are not titles
          // === is read as =(=)=, ==== is read as =(==)= (both 1st
          //                                               levels)
          // ===== is read as ==(=)== (2nd level) and so on
          // eslint-disable-next-line no-constant-condition

          while (true) {
            start = line.substr(level, 1);
            end = line.substr(L1 - level - 1, 1);

            if (L1 - level * 2 > 2 && start === '=' && end === '=') {
              level++;
            } else {
              // eslint-disable-next-line max-depth
              if (level > MAXLEVEL) {
                level = MAXLEVEL;
              } else if (level < minLevel) {
                minLevel = level;
              }

              break;
            }
          }

          if (level === minLevel) {
            tocLevel = 1;
            prevLevels = {};
            prevLevels[level.toString()] = 1;
            prevLevels.relMax = level;

            if (maxTocLevel === 0) {
              maxTocLevel = tocLevel;
            }
          } else if (level > prevLevels.relMax) {
            tocLevel++;
            prevLevels[level.toString()] = tocLevel;
            prevLevels.relMax = level;

            if (tocLevel > maxTocLevel) {
              maxTocLevel = tocLevel;
            }
          } else if (level < prevLevels.relMax) {
            if (prevLevels[level.toString()]) {
              tocLevel = prevLevels[level.toString()];
            } else {
              // TocPeer is the level immediately greater than the
              // current one, and it should have the same tocLevel
              // I must reset tocPeer here to the relative maximum
              var tocPeer = prevLevels.relMax;

              for (var _i2 = 0, _Object$keys = Object.keys(prevLevels); _i2 < _Object$keys.length; _i2++) {
                var pLevelStr = _Object$keys[_i2];
                var pLevel = parseInt(pLevelStr, 10); // eslint-disable-next-line max-depth

                if (pLevel && pLevel > level && pLevel < tocPeer) {
                  tocPeer = pLevel;
                }
              }

              tocLevel = prevLevels[tocPeer.toString()];
              prevLevels[level.toString()] = tocLevel;
            }

            prevLevels.relMax = level;
          }

          sections.push({
            line: line,
            rawheading: rawheading,
            heading: heading,
            cleanheading: cleanheading,
            level: level,
            tocLevel: tocLevel,
            index: regExp.lastIndex - L0,
            length0: L0,
            length1: L1
          });
        } else {
          break;
        }
      } // Articles without sections


      if (maxTocLevel === 0) {
        minLevel = 0;
      }

      return {
        sections: sections,
        minLevel: minLevel,
        maxTocLevel: maxTocLevel
      };
    }
  }]);

  return Parser;
}();

/***/ }),

/***/ 31096:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports = function PreInit(wikiName, installPlugins) {
  if (localStorage.getItem('wikiMonkeyNoAuto') === 'true') {
    var noAuto = $('<div>').append('[ ', $('<a href="#" title="Launch Wiki Monkey">WM</a>').click(function (event) {
      event.preventDefault();
      noAuto.remove();
      initWM(wikiName, installPlugins);
    }), ' ]');
    $('.mw-indicators:first').prepend(noAuto);
  } else {
    initWM(wikiName, installPlugins);
  }
};

function initWM(wikiName, installPlugins) {
  var _require = __webpack_require__(62352),
      WikiMonkey = _require.WikiMonkey; // eslint-disable-line global-require


  new WikiMonkey(wikiName, installPlugins()); // eslint-disable-line no-new
}

/***/ }),

/***/ 10314:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var Str = __webpack_require__(6368);

module.exports = /*#__PURE__*/function () {
  function Tables() {
    _classCallCheck(this, Tables);
  }

  _createClass(Tables, [{
    key: "appendRow",
    value: function appendRow(source, mark, values) {
      var lastId = source.lastIndexOf("|}".concat(mark));
      var endtable = lastId > -1 ? lastId : source.lastIndexOf('|}');
      var row = "|-\n|".concat(values.join('\n|'), "\n");
      var newText = Str.insert(source, row, endtable);
      return newText;
    }
  }]);

  return Tables;
}();

/***/ }),

/***/ 87839:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    moment = _require.moment,
    h = _require.h;

var _require2 = __webpack_require__(60306),
    version = _require2.version;

var WM = __webpack_require__(62352);

var REPO_RAW_URL = 'https://raw.githubusercontent.com/kynikos/wiki-monkey';

module.exports.upgradePeriodical = function () {
  checkObsoleteConfig();

  if (shouldCheck()) {
    checkAndNotify(false);
  }
};

module.exports.upgradeNow = function () {
  return checkAndNotify(true);
};

function checkAndNotify(_x) {
  return _checkAndNotify.apply(this, arguments);
}

function _checkAndNotify() {
  _checkAndNotify = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(alwaysNotify) {
    var upstreamPackage, notification;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return $.getJSON("".concat(REPO_RAW_URL, "/").concat(WM.conf.update_check_branch, "/package.json"));

          case 2:
            upstreamPackage = _context.sent;

            // Well, ok, this is assuming that if the versions are
            // different, upstream has the latest
            if (version === upstreamPackage.version) {
              mw.storage.set('WikiMonkey-last-update-check', moment().format('YYYY-MM-DD'));

              if (alwaysNotify) {
                displayNotification(["Up to date (version ".concat(version, ").")]);
              }
            } else {
              notification = displayNotification(["Version ".concat(upstreamPackage.version, " is available."), h('br'), h('a', {
                href: 'https://github.com/kynikos/wiki-monkey/wiki/Changelog'
              }, 'Changelog'), h('br')].concat(_toConsumableArray(WM.serverUrl ? ['This version of Wiki Monkey is provided by a server installed on \
the local machine; upgrade the server according to how it is installed/run; \
consult the ', h('a', {
                href: 'https://github.com/kynikos/wiki-monkey/wiki'
              }, 'documentation'), ' for more information.', h('br'), h('a', 'Remind later', {
                onclick: function onclick() {
                  mw.storage.set('WikiMonkey-last-update-check', moment().format('YYYY-MM-DD'));
                  notification.close();
                }
              })] : [h('a', 'Run upgrade', {
                onclick: function onclick() {
                  upgrade(upstreamPackage.version);
                }
              })])));
            }

          case 4:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _checkAndNotify.apply(this, arguments);
}

function shouldCheck() {
  if (!WM.conf.update_check_wdays) return false;
  var lastupdcheck = mw.storage.get('WikiMonkey-last-update-check');

  if (!lastupdcheck) {
    return true;
  }

  var diff = moment().diff(moment(lastupdcheck), 'days'); // Preferably check on the configured day of the week, but don't let
  // more than 7 days pass without checking in any case

  if (diff >= 1 && WM.conf.update_check_wdays.includes(moment().day()) || diff >= 7) {
    return true;
  }

  return false;
}

function displayNotification(content, optionsoverride) {
  var options = {
    autoHide: false,
    tag: 'WikiMonkey-upgrade',
    title: 'Wiki Monkey',
    type: 'info'
  };
  $.extend(options, optionsoverride);
  return mw.notification.notify(content, options);
}

function upgrade(upstreamVersion) {
  var page = "User:".concat(mw.user.getName(), "/common.js");
  var pagelink = WM.MW.linkArticle(page);
  displayNotification("Upgrading to version ".concat(upstreamVersion, "...")); // This regular expression must support all versions, including the
  // .min.js
  // TODO: Allow preventing upgrades per-line with //noupgrade comments?
  //       Don't upgrade commented lines?

  var regex = new RegExp("([\"']https?://.+?/kynikos/wiki-monkey/v)".concat(mw.util.escapeRegExp(version), "(/dist/WikiMonkey-[^/]+\\.js[\"'])"), 'gu');
  return WM.MW.api.edit(page, function (revision) {
    var newtext = revision.content.replace(regex, "$1".concat(upstreamVersion, "$2"));

    if (newtext === revision.content) {
      // Executing the query would return a 'nochange:true' result,
      // but we can test it before sending it
      return Promise.reject(new Error('Could not find Wiki Monkey loader line'));
    }

    return {
      text: newtext,
      summary: "Update Wiki Monkey to version ".concat(upstreamVersion),
      bot: true
    };
  }).done(function (result) {
    console.log(result);
    return displayNotification(['Upgrade successful: you need to refresh the open wiki page(s) \
in order to use the new version.', h('br'), h('a', {
      href: 'https://github.com/kynikos/wiki-monkey/wiki/Changelog'
    }, 'Changelog')]);
  }).fail(function (code, error) {
    console.error(code, error);
    return displayNotification(["Could not complete the upgrade to version ".concat(upstreamVersion, ": "), h('a', {
      onclick: function onclick() {
        return upgrade(upstreamVersion);
      }
    }, 'retry'), ' in case it was a temporary problem; it is also possible \
that Wiki Monkey is installed in a non-standard way in ', pagelink, ' and the upgrade should be executed manually; \
finally, it is possible that the upgrade was already launched \
and completed from another page: in this case refresh the page \
to verify.'], {
      type: 'error'
    });
  });
}

function checkObsoleteConfig() {
  // TODO: Remove in a later version
  var oldconf = localStorage.getItem('WikiMonkey');

  if (oldconf !== null) {
    var blob = new Blob([oldconf], {
      type: 'application/json'
    });
    var confhref = window.URL.createObjectURL(blob);
    displayNotification(['Since version 4.0.0, Wiki Monkey uses a completely rewritten \
configuration system. After updating, your old configuration was not \
automatically imported, but it is still saved in your browser\'s \
localStorage. You can decide to export it and then merge it \
manually, or simply remove it and use the default configuration \
options.', h('br'), h('a', {
      href: 'https://github.com/kynikos/wiki-monkey/wiki/Configuration'
    }, 'New configuration instructions'), h('br'), h('a', {
      href: confhref
    }, 'View old configuration'), h('br'), h('a', {
      href: confhref,
      download: 'wikimonkey_oldconf.json'
    }, 'Export old configuration'), h('br'), h('a', {
      onclick: function onclick() {
        localStorage.removeItem('WikiMonkey');
        displayNotification('The old configuration was successfully removed.', {
          autoHide: true
        });
      }
    }, 'Delete old configuration')]);
  }
}

/***/ }),

/***/ 64781:
/***/ ((module) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports = /*#__PURE__*/function () {
  function WhatLinksHere() {
    _classCallCheck(this, WhatLinksHere);
  }

  _createClass(WhatLinksHere, [{
    key: "isWhatLinksHerePage",
    value: function isWhatLinksHerePage() {
      if (document.getElementById('mw-whatlinkshere-list')) {
        return true;
      }

      return false;
    }
  }, {
    key: "getTitle",
    value: function getTitle() {
      return document.getElementById('contentSub').getElementsByTagName('a')[0].title;
    }
  }]);

  return WhatLinksHere;
}();

/***/ }),

/***/ 78635:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
// These replace the obsolete @babel/polyfill
// https://babeljs.io/docs/en/babel-polyfill
__webpack_require__(28594);

__webpack_require__(35666); // JQuery is provided globally by MediaWiki


module.exports.init = function () {
  /* eslint-disable global-require */
  var Vue = __webpack_require__(20144).default;

  var Vuex = __webpack_require__(20629)/* .default */ .ZP;

  Vue.use(Vuex);
  module.exports = {
    Vue: Vue,
    Vuex: Vuex
  };
  module.exports.h = __webpack_require__(48789);
  module.exports.moment = __webpack_require__(30381);

  var jss = __webpack_require__(24474)/* .default */ .ZP;

  jss.setup(__webpack_require__(98016)/* .default */ .Z());
  var jssopts = {
    classNamePrefix: 'WikiMonkey-'
  };

  module.exports.jssc = function (style) {
    return jss.createStyleSheet(style, jssopts).attach();
  };

  module.exports.styled = __webpack_require__(75079)(jss, jssopts); // Clipboard.js doesn't import well with Browserify
  // https://github.com/zenorocha/clipboard.js/issues/535
  // module.exports.ClipboardJS = require('clipboard')

  module.exports.ClipboardJS = __webpack_require__(81653);

  var language = __webpack_require__(39903)/* .default */ .Z;

  var locale = __webpack_require__(1802).default;

  locale.use(language);

  __webpack_require__(84744);

  Vue.use(__webpack_require__(80950).default);
  Vue.use(__webpack_require__(26426).default);
  Vue.use(__webpack_require__(7626).default);
  Vue.use(__webpack_require__(73591).default);
  Vue.use(__webpack_require__(45614).default);
  Vue.use(__webpack_require__(24650).default);
  Vue.use(__webpack_require__(67186).default);
  Vue.use(__webpack_require__(63364).default);
  Vue.use(__webpack_require__(35034).default);
  /* eslint-enable global-require */
};

/***/ }),

/***/ 28557:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class(conf, callNext) {
    _classCallCheck(this, _class);

    // eslint-disable-line complexity
    var source = WM.Editor.readSource();
    var language = WM.ArchWiki.detectLanguage(WM.Editor.getTitle())[1];
    var header = '';
    var content = source; // <noinclude>

    content = content.replace(/^[\t-\r \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF]*<noinclude>/, '');

    if (content !== source) {
      header += '<noinclude>\n';
    } // DISPLAYTITLE and Template:Lowercase_title


    var displaytitle = WM.Parser.findVariables(content, 'DISPLAYTITLE');
    var lowercasetitle = WM.Parser.findTemplates(content, 'Lowercase title');
    var titlemods = displaytitle.concat(lowercasetitle);
    titlemods.sort(function (a, b) {
      return a.index - b.index;
    });
    var tempcontent = '';
    var contentId = 0;

    var _iterator = _createForOfIteratorHelper(titlemods),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var titlemod = _step.value;
        tempcontent += content.substring(contentId, titlemod.index);
        contentId = titlemod.index + titlemod.length;
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    tempcontent += content.substring(contentId);
    content = tempcontent;
    var dt = displaytitle.pop();
    var lct = lowercasetitle.pop();
    var dlct = '';

    if (dt && !lct) {
      dlct = "{{DISPLAYTITLE:".concat(dt.value, "}}");
    } else if (!dt && lct) {
      dlct = '{{Lowercase title}}';
    } else if (dt && lct) {
      dlct = dt.index < lct.index ? '{{Lowercase title}}' : "{{DISPLAYTITLE:".concat(dt.value, "}}");
    }

    if (displaytitle.length || lowercasetitle.length) {
      WM.App.log.warning('Found multiple instances of \
{{DISPLAYTITLE:...}} or {{Lowercase title}}: only the last \
one has been used, the others have been deleted');
    } // Behavior switches


    var behaviorswitches = WM.Parser.findBehaviorSwitches(content);
    var bslist = [];
    tempcontent = '';
    contentId = 0;

    for (var b = 0; b < behaviorswitches.length; b++) {
      var bswitch = behaviorswitches[b];

      if (['TOC', 'START', 'END'].includes(bswitch.match[1])) {
        behaviorswitches.splice(b, 1);
      } else {
        if (bslist.includes(bswitch.match[0])) {
          WM.App.log.warning("Removed duplicate of ".concat(bswitch.match[0]));
        } else {
          bslist.push(bswitch.match[0]);
        }

        tempcontent += content.substring(contentId, bswitch.index);
        contentId = bswitch.index + bswitch.length;
      }
    }

    tempcontent += content.substring(contentId);
    content = tempcontent;

    if (!dlct && bslist.length) {
      header += "".concat(bslist.join(' '), "\n");
    } else if (dlct && !bslist.length) {
      header += "".concat(dlct, "\n");
    } else if (dlct && bslist.length) {
      header += "".concat(dlct, " ").concat(bslist.join(' '), "\n");
    } // Categories


    var categories = WM.Parser.findCategories(content);
    var catlist = [];
    var catlinks = [];
    tempcontent = '';
    contentId = 0;

    var _iterator2 = _createForOfIteratorHelper(categories),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var cat = _step2.value;

        if (cat.fragment) {
          WM.App.log.warning("".concat(WM.App.log.WikiLink(cat.link, cat.rawLink), " contains a fragment reference, but it doesn't make sense in categories and will be removed"));
        }

        var cleantitle = WM.Parser.squashContiguousWhitespace(cat.title);
        var cattext = "Category:".concat(cleantitle); // Don't just pass cleantitle here, otherwise the language of
        //   root language categories won't be properly detected

        var catlang = WM.ArchWiki.detectLanguage(cattext)[1];
        var catlink = "[[".concat(cattext).concat(cat.anchor ? "|".concat(cat.anchor) : '', "]]");

        if (language !== catlang) {
          WM.App.log.warning("".concat(WM.App.log.WikiLink(cat.link, cattext), " belongs to a different language than the one of the title (").concat(language, ")"));
        }

        if (catlist.indexOf(cattext) < 0) {
          catlist.push(cattext);
          catlinks.push(catlink);
        } else {
          WM.App.log.warning("Removed duplicate of ".concat(WM.App.log.WikiLink(cat.link, cattext)));
        }

        tempcontent += content.substring(contentId, cat.index);
        contentId = cat.index + cat.length;
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }

    if (catlist.length) {
      header += "".concat(catlinks.join('\n'), "\n");
    } else {
      WM.App.log.warning('The article is not categorized');
    }

    tempcontent += content.substring(contentId);
    content = tempcontent; // Interlanguage links

    var interlanguage = WM.ArchWiki.findAllInterlanguageLinks(content);
    var iwlist = [];
    var iwlinks = [];
    tempcontent = '';
    contentId = 0;

    var _iterator3 = _createForOfIteratorHelper(interlanguage),
        _step3;

    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var link = _step3.value;

        if (link.anchor) {
          // Cannot use WM.App.log.WikiLink because local interlanguage
          //   links would not resolved correctly; PageLink would need
          //   to find the URL instead, which seems too complicated for
          //   the purpose of this plugin
          WM.App.log.warning("".concat(link.rawLink, " contains an alternative text, but it doesn't make sense in interlanguage links and will be removed"));
        } // Applying WM.Parser.squashContiguousWhitespace is dangerous here
        //   because we don't know how the target server handles whitespace


        var linktitle = link.title;
        var linklang = link.namespace;
        var linktext = "".concat(linklang, ":").concat(linktitle);
        var fulllink = "[[".concat(linktext).concat(link.fragment ? "#".concat(link.fragment) : '', "]]");

        if (iwlist.indexOf(linktext) < 0) {
          iwlist.push(linktext);
          iwlinks.push(fulllink);
        } else {
          // Cannot use WM.App.log.WikiLink because local interlanguage
          //   links would not resolved correctly; PageLink would need
          //   to find the URL instead, which seems too complicated for
          //   the purpose of this plugin
          WM.App.log.warning("Removed duplicate of ".concat(linktext));
        }

        tempcontent += content.substring(contentId, link.index);
        contentId = link.index + link.length;
      }
    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }

    if (iwlist.length) {
      iwlinks.sort();
      header += "".concat(iwlinks.join('\n'), "\n");
    }

    tempcontent += content.substring(contentId);
    content = tempcontent;
    var firstChar = content.search(/(?:(?![\t-\r \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF])[\s\S])/);
    content = content.substr(firstChar);
    var newText = header + content;

    if (newText !== source) {
      WM.Editor.writeSource(newText);
      WM.App.log.info('Fixed header');
    }

    if (callNext) {
      return callNext();
    }
  }

  return _class;
}();

/***/ }),

/***/ 54424:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(28557);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(ArchWikiFixHeader, _Plugin2);

  var _super = _createSuper(ArchWikiFixHeader);

  function ArchWikiFixHeader() {
    _classCallCheck(this, ArchWikiFixHeader);

    return _super.apply(this, arguments);
  }

  _createClass(ArchWikiFixHeader, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var editor = _ref.editor;
      editor(function (callNext) {
        return new Run(_this.conf, callNext);
      });
    }
  }]);

  return ArchWikiFixHeader;
}(_Plugin), _defineProperty(_class, "pluginName", 'ArchWikiFixHeader'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  editor_menu: ['Text plugins', 'Fix header']
}), _temp);

/***/ }),

/***/ 38896:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class(conf, callNext) {
    _classCallCheck(this, _class);

    var increaseLevel;
    var source = WM.Editor.readSource();
    var info = WM.Parser.findSectionHeadings(source);

    if (WM.Editor.isSection()) {
      increaseLevel = info.minLevel - 1;
    } else if (info.maxTocLevel < 6) {
      increaseLevel = 1;
    } else {
      increaseLevel = 0;
      WM.App.log.warning('There are 6 levels of headings, it has ' + 'been necessary to start creating them from level 1 ' + 'although usually it is suggested to start from level 2');
    } // Do not trim any white space at the start of the first line that contains
    // non-white-space characters, as it's meaningful in MediaWiki (a code
    // block)
    // eslint-disable-next-line prefer-named-capture-group


    var trimRe = /^[\t-\r \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF]*?((?:(?![\0-\x08\n\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])[\s\S])*(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])(?:[\0-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*?)[\t-\r \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF]*$/;
    var newtext = '';
    var prevId = 0;

    var _iterator = _createForOfIteratorHelper(info.sections),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var section = _step.value;
        var content = source.substring(prevId, section.index);

        if (!/^[\t-\r \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF]*$/.test(content)) {
          newtext += "".concat(content.replace(trimRe, '$1'), "\n\n");
        }

        newtext += "".concat(new Array(section.tocLevel + increaseLevel + 1).join('='), " ").concat(section.rawheading.trim(), " ").concat(new Array(section.tocLevel + increaseLevel + 1).join('='), "\n\n");
        prevId = section.index + section.length0;
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    newtext += "".concat(source.substr(prevId).replace(trimRe, '$1'), "\n");

    if (newtext !== source) {
      WM.Editor.writeSource(newtext);
      WM.App.log.info('Fixed section headings');
    }

    if (callNext) {
      return callNext();
    }
  }

  return _class;
}();

/***/ }),

/***/ 89872:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(38896);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(ArchWikiFixHeadings, _Plugin2);

  var _super = _createSuper(ArchWikiFixHeadings);

  function ArchWikiFixHeadings() {
    _classCallCheck(this, ArchWikiFixHeadings);

    return _super.apply(this, arguments);
  }

  _createClass(ArchWikiFixHeadings, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var editor = _ref.editor;
      editor(function (callNext) {
        return new Run(_this.conf, callNext);
      });
    }
  }]);

  return ArchWikiFixHeadings;
}(_Plugin), _defineProperty(_class, "pluginName", 'ArchWikiFixHeadings'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  editor_menu: ['Text plugins', 'Fix headings']
}), _temp);

/***/ }),

/***/ 8143:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class(conf, callNext) {
    _classCallCheck(this, _class);

    var source = WM.Editor.readSource();
    var newtext = this.doReplace(source);

    if (newtext !== source) {
      WM.Editor.writeSource(newtext);
      WM.App.log.info('Fixed links');
    } else {
      WM.App.log.info('No fixable links found');
    }

    if (callNext) {
      return callNext();
    }
  }

  _createClass(_class, [{
    key: "doReplace",
    value: function doReplace(txt) {
      // Archlinux.org HTTP -> HTTPS
      var L;
      var match;
      var re = /http:\/\/([a-z]+\.)?archlinux\.org(?!\.[a-z])/ig;
      txt = txt.replace(re, 'https://$1archlinux.org'); // Wiki.archlinux.org -> Internal link

      re = /\[https?:\/\/wiki\.archlinux\.org\/index\.php\/Category:([^\]]+?) (.+?)\]/ig;
      txt = txt.replace(re, '[[:Category:$1|$2]]');
      re = /\[https?:\/\/wiki\.archlinux\.org\/index\.php\/Category:(.+?)\]/ig;
      txt = txt.replace(re, '[[:Category:$1]]');
      re = /https?:\/\/wiki\.archlinux\.org\/index\.php\/Category:([^\s]+)/ig;
      txt = txt.replace(re, '[[:Category:$1]]');
      re = /\[https?:\/\/wiki\.archlinux\.org\/index\.php\/([^\]]+?) (.+?)\]/ig;
      txt = txt.replace(re, '[[$1|$2]]');
      re = /\[https?:\/\/wiki\.archlinux\.org\/index\.php\/(.+?)\]/ig;
      txt = txt.replace(re, '[[$1]]');
      re = /https?:\/\/wiki\.archlinux\.org\/index\.php\/([^\s]+)/ig;
      txt = txt.replace(re, '[[$1]]');
      re = /https?:\/\/wiki\.archlinux\.org(?!\.)/ig;

      if (re.test(txt)) {
        WM.App.log.warning('It hasn\'t been possible to convert some ' + 'links to wiki.archlinux.org');
      } // Wikipedia -> wikipedia: interlink


      re = /\[https?:\/\/en\.wikipedia\.org\/wiki\/([^\]]+?) (.+?)\]/ig;
      txt = txt.replace(re, '[[wikipedia:$1|$2]]');
      re = /\[https?:\/\/en\.wikipedia\.org\/wiki\/(.+?)\]/ig;
      txt = txt.replace(re, '[[wikipedia:$1]]');
      re = /https?:\/\/en\.wikipedia\.org\/wiki\/([^\s]+)/ig;
      txt = txt.replace(re, '[[wikipedia:$1]]');
      re = /https?:\/\/([a-z]+?)\.wikipedia\.org(?!\.)/ig;

      if (re.test(txt)) {
        WM.App.log.warning('It hasn\'t been possible to convert some ' + 'links to Wikipedia');
      } // Official package links -> Pkg template


      re = /\[https?:\/\/(?:www\.)?archlinux\.org\/packages\/(?:community|community-testing|core|extra|multilib|multilib-testing|testing)\/(?:any|i686|x86_64)\/([^\s]+?)\/? +(.+?)?\]/ig;
      var newText = '';
      var prevId = 0;

      while (true) {
        match = re.exec(txt);

        if (match) {
          // Don't join these two conditions
          if (match[1] === match[2]) {
            L = match[0].length;
            newText += "".concat(txt.substring(prevId, re.lastIndex - L), "{{Pkg|").concat(match[1], "}}");
            prevId = re.lastIndex;
          }
        } else {
          break;
        }
      }

      newText += txt.substr(prevId);
      txt = newText;
      re = /\[https?:\/\/(?:www\.)?archlinux\.org\/packages\/(?:community|community-testing|core|extra|multilib|multilib-testing|testing)\/(?:any|i686|x86_64)\/([^\s]+?)\/?\]/ig;
      txt = txt.replace(re, '{{Pkg|$1}}');
      re = /([^\[])https?:\/\/(?:www\.)?archlinux\.org\/packages\/(?:community|community-testing|core|extra|multilib|multilib-testing|testing)\/(?:any|i686|x86_64)\/([^\s\/]+)\/?/ig;
      txt = txt.replace(re, '$1{{Pkg|$2}}');
      re = /https?:\/\/(?:www\.)?archlinux\.org\/packages(?!\/?\s)/ig;

      if (re.test(txt)) {
        WM.App.log.warning('It hasn\'t been possible to convert some ' + 'links to archlinux.org/packages');
      } // AUR package links -> AUR template


      re = /\[https?:\/\/aur\.archlinux\.org\/packages\/([^\s]+?)\/? +(.+?)?\]/ig;
      newText = '';
      prevId = 0;

      while (true) {
        match = re.exec(txt);

        if (match) {
          // Don't join these two conditions
          if (match[1] === match[2]) {
            L = match[0].length;
            newText += "".concat(txt.substring(prevId, re.lastIndex - L), "{{AUR|").concat(match[1], "}}");
            prevId = re.lastIndex;
          }
        } else {
          break;
        }
      }

      newText += txt.substr(prevId);
      txt = newText;
      re = /\[https?:\/\/aur\.archlinux\.org\/packages\/([^\s]+?)\/?\]/ig;
      txt = txt.replace(re, '{{AUR|$1}}');
      re = /([^\[])https?:\/\/aur\.archlinux\.org\/packages\/([^\s\/]+)\/?/ig;
      txt = txt.replace(re, '$1{{AUR|$2}}');
      re = /https?:\/\/aur\.archlinux\.org(?!(?:\.|(?:\/?packages)?\/?\s))/ig;

      if (re.test(txt)) {
        WM.App.log.warning("It hasn't been possible to convert some " + 'links to aur.archlinux.org');
      } // Bug links -> Bug template


      re = /\[https?:\/\/bugs\.archlinux\.org\/task\/([^\s]+?)\/? +(.+?)?\]/ig;
      newText = '';
      prevId = 0;

      while (true) {
        match = re.exec(txt);

        if (match) {
          // Don't join these two conditions
          if (match[1] === match[2]) {
            L = match[0].length;
            newText += "".concat(txt.substring(prevId, re.lastIndex - L), "{{Bug|").concat(match[1], "}}");
            prevId = re.lastIndex;
          }
        } else {
          break;
        }
      }

      newText += txt.substr(prevId);
      txt = newText;
      re = /\[https?:\/\/bugs\.archlinux\.org\/task\/([^\s]+?)\/?\]/ig;
      txt = txt.replace(re, '{{Bug|$1}}');
      re = /([^\[])https?:\/\/bugs\.archlinux\.org\/task\/([^\s\/]+)\/?/ig;
      txt = txt.replace(re, '$1{{Bug|$2}}');
      re = /https?:\/\/bugs\.archlinux\.org\/task/ig;

      if (re.test(txt)) {
        WM.App.log.warning('It hasn\'t been possible to convert some ' + 'links to bugs.archlinux.org/task');
      }

      return txt;
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 59174:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(8143);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(ArchWikiFixLinks, _Plugin2);

  var _super = _createSuper(ArchWikiFixLinks);

  function ArchWikiFixLinks() {
    _classCallCheck(this, ArchWikiFixLinks);

    return _super.apply(this, arguments);
  }

  _createClass(ArchWikiFixLinks, [{
    key: "install",
    value: // Note that it's too dangerous to use this plugin with the bot, in fact
    // some full URLs are correctly used in code blocks (e.g. wget lines)
    function install(_ref) {
      var _this = this;

      var editor = _ref.editor;
      editor(function (callNext) {
        return new Run(_this.conf, callNext);
      });
    }
  }]);

  return ArchWikiFixLinks;
}(_Plugin), _defineProperty(_class, "pluginName", 'ArchWikiFixLinks'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  editor_menu: ['Text plugins', 'Fix external links']
}), _temp);

/***/ }),

/***/ 92738:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    jssc = _require.jssc;

var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class(conf) {
    _classCallCheck(this, _class);

    this.conf = conf;
    jssc({
      '@global #mw-content-text > h5': {
        backgroundColor: '#afa'
      }
    });
    var contentDiv = $('#mw-content-text');
    var ul = contentDiv.find('ul').first();
    var liList = ul.children('li');

    var _iterator = _createForOfIteratorHelper(liList),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var li = _step.value;
        var link = $(li).find('a.mw-newpages-pagename').first();

        var _WM$ArchWiki$detectLa = WM.ArchWiki.detectLanguage(link[0].title),
            _WM$ArchWiki$detectLa2 = _slicedToArray(_WM$ArchWiki$detectLa, 2),
            pureTitle = _WM$ArchWiki$detectLa2[0],
            language = _WM$ArchWiki$detectLa2[1];

        if (language !== this.conf.default_language) {
          this.moveArticle(contentDiv, li, language);
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    return WM.App.log.info('Grouped articles by language');
  }

  _createClass(_class, [{
    key: "moveArticle",
    value: function moveArticle(contentDiv, li, language) {
      var langHs = contentDiv.children('h5');
      var langFound = false;

      var _iterator2 = _createForOfIteratorHelper(langHs),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var HLang = _step2.value;

          if (HLang.innerHTML === language) {
            var ul = $(HLang).next().append(li);
            langFound = true;
            break;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      if (!langFound) {
        return contentDiv.append($('<h5>').text(language), $('<ul>').append(li));
      }
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 38854:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(92738);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(ArchWikiNPFilter, _Plugin2);

  var _super = _createSuper(ArchWikiNPFilter);

  function ArchWikiNPFilter() {
    _classCallCheck(this, ArchWikiNPFilter);

    return _super.apply(this, arguments);
  }

  _createClass(ArchWikiNPFilter, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var newPages = _ref.newPages;
      newPages(function () {
        return new Run(_this.conf);
      });
    }
  }]);

  return ArchWikiNPFilter;
}(_Plugin), _defineProperty(_class, "pluginName", 'ArchWikiNPFilter'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  filter_label: 'Default filter',
  default_language: 'English'
}), _temp);

/***/ }),

/***/ 10431:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class(conf, callNext) {
    _classCallCheck(this, _class);

    var source = WM.Editor.readSource();
    var newtext = source;
    var re8 = /<pre>(((?!<(pre|nowiki)>)[^\=\|])*?((?!<(pre|nowiki)>)[^\=\|\}]))<\/pre>/ig;
    var re9 = /<pre>(((?!<(pre|nowiki)>)[^\|])*?((?!<(pre|nowiki)>)[^\|\}]))<\/pre>/ig;
    var re10 = /<pre>(\n*((?!<(pre|nowiki)>).\n*)+?)<\/pre>/ig;
    var re11 = /<code>(((?!<(code|nowiki)>)[^\=\|\n])*?((?!<(code|nowiki)>)[^\=\|\}\n]))<\/code>/ig;
    var re12 = /<code>(((?!<(code|nowiki)>)[^\|\n])*?((?!<(code|nowiki)>)[^\|\}\n]))<\/code>/ig;
    var re13 = /<code>(((?!<(code|nowiki)>)[^\n])+?)<\/code>/ig;
    var re14 = /<tt>(((?!<(tt|nowiki)>)[^\=\|\n])*?((?!<(tt|nowiki)>)[^\=\|\}\n]))<\/tt>/ig;
    var re15 = /<tt>(((?!<(tt|nowiki)>)[^\|\n])*?((?!<(tt|nowiki)>)[^\|\}\n]))<\/tt>/ig;
    var re16 = /<tt>(((?!<(tt|nowiki)>)[^\n])+?)<\/tt>/ig;
    newtext = newtext.replace(re8, '{{bc|$1}}');
    newtext = newtext.replace(re9, '{{bc|1=$1}}'); // Must come after re8

    newtext = newtext.replace(re10, '{{bc|<nowiki>$1</nowiki>}}'); // Must come after re9

    newtext = newtext.replace(re11, '{{ic|$1}}');
    newtext = newtext.replace(re12, '{{ic|1=$1}}'); // Must come after re11

    newtext = newtext.replace(re13, '{{ic|<nowiki>$1</nowiki>}}'); // Must come after re12

    newtext = newtext.replace(re14, '{{ic|$1}}');
    newtext = newtext.replace(re15, '{{ic|1=$1}}'); // Must come after re14

    newtext = newtext.replace(re16, '{{ic|<nowiki>$1</nowiki>}}'); // Must come after re15

    if (newtext !== source) {
      WM.Editor.writeSource(newtext);
      WM.App.log.info('Turned HTML tags into proper templates');
    }

    var tests = [['&lt;pre>', newtext.match(/<pre/ig)], ['&lt;code>', newtext.match(/<code/ig)], ['&lt;tt>', newtext.match(/<tt/ig)]];

    for (var _i = 0, _tests = tests; _i < _tests.length; _i++) {
      var test = _tests[_i];

      if (test[1]) {
        WM.App.log.warning("".concat(test[1].length, " ").concat(test[0], " instances require manual intervention"));
      }
    }

    if (callNext) {
      return callNext();
    }
  }

  return _class;
}();

/***/ }),

/***/ 99731:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(10431);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(ArchWikiNewTemplates, _Plugin2);

  var _super = _createSuper(ArchWikiNewTemplates);

  function ArchWikiNewTemplates() {
    _classCallCheck(this, ArchWikiNewTemplates);

    return _super.apply(this, arguments);
  }

  _createClass(ArchWikiNewTemplates, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var editor = _ref.editor;
      editor(function (callNext) {
        return new Run(_this.conf, callNext);
      });
    }
  }]);

  return ArchWikiNewTemplates;
}(_Plugin), _defineProperty(_class, "pluginName", 'ArchWikiNewTemplates'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  editor_menu: ['Text plugins', 'Use code templates']
}), _temp);

/***/ }),

/***/ 15444:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    jssc = _require.jssc;

var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class(conf) {
    _classCallCheck(this, _class);

    this.conf = conf;
    var h4s = $('#mw-content-text .mw-changeslist > h4');

    if (h4s.eq(0).next()[0].localName.toLowerCase() !== 'div') {
      return WM.App.log.error('This filter is designed to work on top of \
MediaWiki\'s filter, which you can \
enable in your user preferences.');
    }

    jssc({
      '@global': {
        '#mw-content-text': {
          '& > div > h4': {
            backgroundColor: '#aaf'
          },
          '& > div > div > h5': {
            backgroundColor: '#afa'
          }
        }
      }
    });

    var _iterator = _createForOfIteratorHelper(h4s),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var h4 = _step.value;
        var groupDiv = $(h4).next();

        var _iterator2 = _createForOfIteratorHelper(groupDiv.children('table')),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var articleTable = _step2.value;
            var link = $(articleTable).find('a.mw-changeslist-title').first();

            if (link[0]) {
              var _WM$ArchWiki$detectLa = WM.ArchWiki.detectLanguage(link[0].title),
                  _WM$ArchWiki$detectLa2 = _slicedToArray(_WM$ArchWiki$detectLa, 2),
                  pureTitle = _WM$ArchWiki$detectLa2[0],
                  language = _WM$ArchWiki$detectLa2[1];

              if (language !== this.conf.default_language) {
                this.moveArticle(groupDiv, articleTable, language);
              }
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    return WM.App.log.info('Grouped articles by language');
  }

  _createClass(_class, [{
    key: "moveArticle",
    value: function moveArticle(groupDiv, articleTable, language) {
      var langHs = groupDiv.children('h5');
      var langFound = false;

      for (var i = 0; i < langHs.length; i++) {
        var HLang = langHs[i];

        if (HLang.innerHTML === language) {
          if (i + 1 < langHs.length) {
            langHs.eq(i + 1).before(articleTable);
          } else {
            groupDiv.append(articleTable);
          }

          langFound = true;
          break;
        }
      }

      if (!langFound) {
        return groupDiv.append($('<h5>').text(language), articleTable);
      }
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 77132:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(15444);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(ArchWikiRCFilter, _Plugin2);

  var _super = _createSuper(ArchWikiRCFilter);

  function ArchWikiRCFilter() {
    _classCallCheck(this, ArchWikiRCFilter);

    return _super.apply(this, arguments);
  }

  _createClass(ArchWikiRCFilter, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var recentChanges = _ref.recentChanges;
      recentChanges(function () {
        return new Run(_this.conf);
      });
    }
  }]);

  return ArchWikiRCFilter;
}(_Plugin), _defineProperty(_class, "pluginName", 'ArchWikiRCFilter'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  filter_label: 'Default filter',
  default_language: 'English'
}), _temp);

/***/ }),

/***/ 38746:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var startMark = 'START AUTO LIST - DO NOT REMOVE OR MODIFY THIS MARK-->';
var endMark = '<!--END AUTO LIST - DO NOT REMOVE OR MODIFY THIS MARK'; // Don't do "(?: <!-- associated bot: (.+?) -->)?.*$"

var regExp = /^\*(?:[\0-\t\x0B\f\x0E-\u2027\u202A-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*?\[\[User:((?:[\0-\t\x0B\f\x0E-\u2027\u202A-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+?)\|(?:[\0-\t\x0B\f\x0E-\u2027\u202A-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+?(?: <!\x2D\x2D associated bot: ((?:[\0-\t\x0B\f\x0E-\u2027\u202A-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+?) \x2D\x2D>(?:[\0-\t\x0B\f\x0E-\u2027\u202A-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/;

module.exports = /*#__PURE__*/function () {
  function _class2(conf, _callNext) {
    var _this = this;

    _classCallCheck(this, _class2);

    _defineProperty(this, "iteratePages", function (pageid, callNext) {
      pageid++;
      var pconf = _this.conf.pages[pageid];

      if (pconf) {
        var page = pconf.title;
        var recentDays = pconf.recent_days;
        var inactiveLimit = pconf.inactive_limit;
        var inactiveIntro = pconf.inactive_message;
        var summary = _this.conf.edit_summary;
        WM.App.log.info("Sorting ".concat(WM.App.log.WikiLink(page, page), " ..."));
        return WM.MW.callQueryEdit(page, _this.parseList, [recentDays, inactiveLimit, inactiveIntro, summary, callNext, pageid]);
      } else if (callNext) {
        return callNext();
      }
    });

    _defineProperty(this, "parseList", function ( // eslint-disable-line max-params
    title, source, timestamp, edittoken, _ref) {
      var _ref2 = _slicedToArray(_ref, 6),
          recentDays = _ref2[0],
          inactiveLimit = _ref2[1],
          inactiveIntro = _ref2[2],
          summary = _ref2[3],
          callNext = _ref2[4],
          pageid = _ref2[5];

      var startList = source.indexOf(startMark);
      var endList = source.indexOf(endMark);

      if (startList > -1 && endList > -1) {
        startList += startMark.length;
        var date = new Date();
        var ucstart = Math.floor(Date.now() / 1000);
        var ucend = ucstart - 86400 * recentDays;
        var users = {
          active: [],
          inactive: []
        };
        var usersArray = source.substring(startList, endList).split('\n');
        return _this.iterateUsers(usersArray, -1, ucstart, ucend, users, title, source, startList, endList, timestamp, edittoken, inactiveLimit, inactiveIntro, summary, callNext, pageid);
      }

      return WM.App.log.error('Cannot find the needed marks');
    });

    _defineProperty(this, "storeUserContribs", function (results, args) {
      var usersArray = args[0];
      var index = args[1];
      var ucstart = args[2];
      var ucend = args[3];
      var users = args[4];
      var title = args[5];
      var source = args[6];
      var startList = args[7];
      var endList = args[8];
      var timestamp = args[9];
      var edittoken = args[10];
      var inactiveLimit = args[11];
      var inactiveIntro = args[12];
      var summary = args[13];
      var callNext = args[14];
      var pageid = args[15];
      var edits = results.length;

      if (edits < inactiveLimit) {
        users.inactive.push({
          text: usersArray[index],
          edits: edits
        });
      } else {
        users.active.push({
          text: usersArray[index],
          edits: edits
        });
      }

      return _this.iterateUsers(usersArray, index, ucstart, ucend, users, title, source, startList, endList, timestamp, edittoken, inactiveLimit, inactiveIntro, summary, callNext, pageid);
    });

    _defineProperty(this, "writePage", function (res, _ref3) {
      var _ref4 = _slicedToArray(_ref3, 3),
          title = _ref4[0],
          callNext = _ref4[1],
          pageid = _ref4[2];

      if (res.edit && res.edit.result === 'Success') {
        WM.App.log.info("".concat(WM.App.log.WikiLink(title, title), " was correctly updated"));
        return _this.iteratePages(pageid, callNext);
      }

      return WM.App.log.error("".concat(res.error.info, " (").concat(res.error.code, ")"));
    });

    this.conf = conf;
    return this.iteratePages(-1, _callNext);
  }

  _createClass(_class2, [{
    key: "iterateUsers",
    value: function iterateUsers( // eslint-disable-line max-params
    usersArray, index, ucstart, ucend, users, title, source, startList, endList, timestamp, edittoken, inactiveLimit, inactiveIntro, summary, callNext, pageid) {
      index++;

      if (index < usersArray.length) {
        var userString = usersArray[index];
        var match = regExp.exec(userString);

        if (match) {
          var ucuser = match[1].charAt(0).toUpperCase() + match[1].substr(1);

          if (match[2]) {
            ucuser += "|".concat(match[2].charAt(0).toUpperCase()).concat(match[2].substr(1));
          }

          WM.App.log.info("Querying ".concat(ucuser, " ..."));
          return WM.MW.getUserContribs(ucuser, ucstart, ucend, this.storeUserContribs, [usersArray, index, ucstart, ucend, users, title, source, startList, endList, timestamp, edittoken, inactiveLimit, inactiveIntro, summary, callNext, pageid]);
        } else if (userString !== '' && userString.indexOf(inactiveIntro) !== 0) {
          return WM.App.log.error('An entry in the list may not be correctly ' + 'formatted');
        }

        return this.iterateUsers(usersArray, index, ucstart, ucend, users, title, source, startList, endList, timestamp, edittoken, inactiveLimit, inactiveIntro, summary, callNext, pageid);
      }

      return this.updateList(users, title, source, startList, endList, timestamp, edittoken, inactiveIntro, summary, callNext, pageid);
    }
  }, {
    key: "updateList",
    value: function updateList( // eslint-disable-line max-params
    users, title, source, startList, endList, timestamp, edittoken, inactiveIntro, summary, callNext, pageid) {
      var sorter = function sorter(a, b) {
        // Users must be sorted in descending order
        if (a.edits < b.edits) {
          return 1;
        } else if (a.edits > b.edits) {
          return -1;
        }

        return 0;
      };

      users.active.sort(sorter);
      users.inactive.sort(sorter);
      var newList = '\n';

      var _iterator = _createForOfIteratorHelper(users.active),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var user = _step.value;
          newList += "".concat(user.text, "\n");
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      if (users.inactive.length > 0) {
        newList += "\n".concat(inactiveIntro, "\n\n");

        var _iterator2 = _createForOfIteratorHelper(users.inactive),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            user = _step2.value;
            newList += "".concat(user.text, "\n");
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      }

      var newText = source.substring(0, startList) + newList + source.substring(endList);

      if (newText !== source) {
        return WM.MW.callAPIPost({
          action: 'edit',
          bot: '1',
          minor: '1',
          title: title,
          summary: summary,
          text: newText,
          b1asetimestamp: timestamp,
          token: edittoken
        }, this.writePage, [title, callNext, pageid], null);
      }

      WM.App.log.info("".concat(WM.App.log.WikiLink(title, title), " was already up to date"));
      return this.iteratePages(pageid, callNext);
    }
  }]);

  return _class2;
}();

/***/ }),

/***/ 1745:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(38746);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(ArchWikiSortContacts, _Plugin2);

  var _super = _createSuper(ArchWikiSortContacts);

  function ArchWikiSortContacts() {
    _classCallCheck(this, ArchWikiSortContacts);

    return _super.apply(this, arguments);
  }

  _createClass(ArchWikiSortContacts, [{
    key: "install",
    value: // This plugin was originally based on list=allusers, but because of bug
    //  #208 it can't rely on that anymore, so it was rewritten with
    //  60bb2ac2a2dcd0b15b7aac80725c83151173eeb3
    // See also https://bbs.archlinux.org/viewtopic.php?id=192389 and
    //  https://lists.wikimedia.org/pipermail/mediawiki-l/2015-January/043850.html
    function install(_ref) {
      var _this = this;

      var special = _ref.special;
      special(function (callNext) {
        return new Run(_this.conf, callNext);
      });
    }
  }]);

  return ArchWikiSortContacts;
}(_Plugin), _defineProperty(_class, "pluginName", 'ArchWikiSortContacts'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: false,
  special_menu: ['Sort staff contacts'],
  edit_summary: 'automatically sort list according to recent activity',
  pages: [{
    title: 'ArchWiki:Administrators',
    recent_days: 30,
    inactive_limit: 30,
    inactive_message: 'The following Administrators are currently \
inactive (less than 30 edits in the last 30 days):'
  }, {
    title: 'ArchWiki:Maintainers',
    recent_days: 30,
    inactive_limit: 10,
    inactive_message: 'The following Maintainers are currently \
inactive (less than 10 edits in the last 30 days):'
  }]
}), _temp);

/***/ }),

/***/ 60089:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex;

var _require2 = __webpack_require__(51504),
    FlexColumn = _require2.FlexColumn;

module.exports.Editor = {
  name: 'BookmarksEditor',
  props: {
    sectionId: {
      type: String,
      required: false
    },
    sectionNumber: {
      type: Number,
      required: false
    },
    sectionTitle: {
      type: String,
      required: false
    },
    bookmarkId: {
      type: Number,
      required: false
    },
    bookmarkActionDue: {
      type: String,
      required: false
    },
    bookmarkNotes: {
      type: String,
      required: false
    }
  },
  data: function data() {
    return {
      action: this.bookmarkActionDue || 'reply',
      // 'delay' is initialized in created()
      delay: null,
      notes: this.bookmarkNotes
    };
  },
  computed: _objectSpread({}, Vuex.mapState('plugins/bookmarks', ['conf'])),
  methods: _objectSpread({}, Vuex.mapActions('plugins/bookmarks', ['saveBookmark'])),
  created: function created() {
    this.delay = this.conf.defaultBookmarkDelay;
  },
  render: function render(h) {
    var _this = this;

    return h(FlexColumn, [// TODO: I haven't been able to make fetchSuggestions work yet...
    // h('ElAutocomplete', {
    //   props: {
    //     placeholder: 'action',
    //     autocomplete: 'on',
    //     fetchSuggestions: (queryString, callback) => {
    //       console.debug('ElAutocomplete queryString:', queryString)
    //       callback(['abcde', 'fghij', 'klmno'])
    //     },
    //   },
    //   on: {
    //     change: (value) => console.debug('ElAutocomplete onChange:', value),
    //     select: (value) => console.debug('ElAutocomplete onSelect', value),
    //   },
    // }),
    h('ElSelect', {
      props: {
        placeholder: 'action',
        value: this.action,
        filterable: true,
        allowCreate: true,
        defaultFirstOption: true
      },
      on: {
        change: function change(value) {
          _this.action = value;
        }
      }
    }, this.conf.bookmarkActionChoices.map(function (value) {
      return h('ElOption', {
        props: {
          value: value,
          label: value
        }
      });
    })), h('ElSelect', {
      props: {
        placeholder: 'delay',
        value: this.delay,
        filterable: true,
        allowCreate: true,
        defaultFirstOption: true
      },
      on: {
        change: function change(value) {
          _this.delay = value;
        }
      }
    }, this.conf.bookmarkDelayChoices.map(function (value) {
      return h('ElOption', {
        props: {
          value: value,
          label: value
        }
      });
    })), h('ElInput', {
      props: {
        placeholder: 'notes',
        value: this.notes,
        type: 'textarea',
        autosize: {
          minRows: 2
        }
      },
      on: {
        change: function change(value) {
          _this.notes = value;
        }
      }
    }), h('div', ['[ ', h('a', {
      on: {
        click: function click(event) {
          event.preventDefault();

          _this.saveBookmark({
            sectionId: _this.sectionId,
            sectionNumber: _this.sectionNumber,
            sectionTitle: _this.sectionTitle,
            bookmarkId: _this.bookmarkId,
            action: _this.action,
            delay: _this.delay,
            notes: _this.notes
          });
        }
      }
    }, ['save']), ' ]'])]);
  }
};

/***/ }),

/***/ 34674:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex;

var _require2 = __webpack_require__(51504),
    Grid2C = _require2.Grid2C;

module.exports.ExpandedCell = {
  name: 'BookmarksExpandedCell',
  props: {
    row: {
      type: Object,
      required: true
    }
  },
  render: function render(h) {
    // eslint-disable-line complexity
    return h(Grid2C, [['id', this.row.id], ['url', this.row.url], ['section_id', this.row.section_id], ['section_number', this.row.section_number], ['section_title', this.row.section_title], ['wgPageName', this.row.wgPageName], ['wgRelevantPageName', this.row.wgRelevantPageName], ['wgCanonicalSpecialPageName', this.row.wgCanonicalSpecialPageName], ['wgCanonicalNamespace', this.row.wgCanonicalNamespace], ['wgTitle', this.row.wgTitle], ['wgAction', this.row.wgAction], ['wgIsArticle', this.row.wgIsArticle], ['wgIsProbablyEditable', this.row.wgIsProbablyEditable], ['wgRelevantPageIsProbablyEditable', this.row.wgRelevantPageIsProbablyEditable], ['wgPageContentLanguage', this.row.wgPageContentLanguage], ['wgPageContentModel', this.row.wgPageContentModel], ['wgArticleId', this.row.wgArticleId], ['wgNamespaceNumber', this.row.wgNamespaceNumber], ['wgRevisionId', this.row.wgRevisionId], ['wgCurRevisionId', this.row.wgCurRevisionId], ['wgDiffOldId', this.row.wgDiffOldId], ['wgDiffNewId', this.row.wgDiffNewId], ['time_created', this.row.time_created], ['time_updated', this.row.time_updated], ['action_due', this.row.action_due], ['time_due', this.row.time_due], ['notes', this.row.notes]].reduce(function (acc, _ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          name = _ref2[0],
          value = _ref2[1];

      return acc.concat([h('div', [name]), h('div', [value])]);
    }, []));
  }
};

/***/ }),

/***/ 82773:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex; // TODO: Even better would be to have a small button/icon to add/select the
//       fields to show, and each column header would have a button to hide it


module.exports.FieldSelect = {
  name: 'BookmarksFieldSelect',
  props: {
    shownFields: {
      type: Array,
      required: true
    },
    updateShownFields: {
      type: Function,
      required: true
    }
  },
  render: function render(h) {
    var _this = this;

    return h('div', [h('ElSelect', {
      attrs: {
        title: "Select which fields to show in the table (the \
remaining ones will be listed in each row's expanded panel)"
      },
      props: {
        size: 'mini',
        multiple: true,
        // Re-enable collapseTags if width is no longer 100%
        // collapseTags: true,
        value: this.shownFields
      },
      style: {
        // Re-enable collapseTags if width is no longer 100%
        width: '100%'
      },
      on: {
        change: function change(values) {
          _this.updateShownFields(values);
        }
      }
    }, [['id', 'id'], ['url', 'url'], ['section_id', 'section_id'], ['section_number', 'section_number'], ['section_title', 'section_title'], ['wgPageName', 'wgPageName'], ['wgRelevantPageName', 'wgRelevantPageName'], ['wgCanonicalSpecialPageName', 'wgCanonicalSpecialPageName'], ['wgCanonicalNamespace', 'wgCanonicalNamespace'], ['wgTitle', 'wgTitle'], ['wgAction', 'wgAction'], ['wgIsArticle', 'wgIsArticle'], ['wgIsProbablyEditable', 'wgIsProbablyEditable'], ['wgRelevantPageIsProbablyEditable', 'wgRelevantPageIsProbablyEditable'], ['wgPageContentLanguage', 'wgPageContentLanguage'], ['wgPageContentModel', 'wgPageContentModel'], ['wgArticleId', 'wgArticleId'], ['wgNamespaceNumber', 'wgNamespaceNumber'], ['wgRevisionId', 'wgRevisionId'], ['wgCurRevisionId', 'wgCurRevisionId'], ['wgDiffOldId', 'wgDiffOldId'], ['wgDiffNewId', 'wgDiffNewId'], ['time_created', 'time_created'], ['time_updated', 'time_updated'], ['action_due', 'action_due'], ['time_due', 'time_due'], ['notes', 'notes']].map(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          key = _ref2[0],
          label = _ref2[1];

      return h('ElOption', {
        props: {
          key: key,
          label: label,
          value: key
        }
      });
    }))]);
  }
};

/***/ }),

/***/ 94035:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex;

var _require2 = __webpack_require__(51504),
    SpacedVertical = _require2.SpacedVertical;

var _require3 = __webpack_require__(82773),
    FieldSelect = _require3.FieldSelect;

var _require4 = __webpack_require__(90791),
    Table = _require4.Table; // TODO: Show how many bookmarks are due in the next hour, day etc.


module.exports.Manager = {
  name: 'BookmarksManager',
  props: {
    shownFields: {
      type: Array,
      required: true
    },
    bookmarks: {
      type: Array,
      required: true
    },
    updateShownFields: {
      type: Function,
      required: true
    },
    sectionId: {
      type: String,
      required: false
    },
    sectionNumber: {
      type: Number,
      required: false
    },
    sectionTitle: {
      type: String,
      required: false
    }
  },
  render: function render(h) {
    return h(SpacedVertical, [h(FieldSelect, {
      props: {
        shownFields: this.shownFields,
        updateShownFields: this.updateShownFields
      }
    }), h(Table, {
      props: {
        shownFields: this.shownFields,
        bookmarks: this.bookmarks,
        sectionId: this.sectionId,
        sectionNumber: this.sectionNumber,
        sectionTitle: this.sectionTitle
      }
    })]);
  }
};

/***/ }),

/***/ 25315:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex;

var _require2 = __webpack_require__(69279),
    PopoverManager = _require2.PopoverManager;

var _require3 = __webpack_require__(16775),
    PopoverEdit = _require3.PopoverEdit;

module.exports.PageCommand = function (conf) {
  return {
    name: 'BookmarksPageCommand',
    computed: _objectSpread({}, Vuex.mapState('plugins/bookmarks', ['pageShownFields', 'pageBookmarks'])),
    methods: _objectSpread(_objectSpread({}, Vuex.mapMutations('plugins/bookmarks', ['updatePageShownFields'])), Vuex.mapActions('plugins/bookmarks', ['queryPageBookmarks'])),
    created: function created() {
      this.queryPageBookmarks();
    },
    render: function render(h) {
      return this.pageBookmarks.length ? h(PopoverManager, {
        props: {
          href: '#manage-page-bookmarks',
          title: "Manage this page's bookmarks",
          bookmarks: this.pageBookmarks,
          shownFields: this.pageShownFields,
          updateShownFields: this.updatePageShownFields
        }
      }) : h(PopoverEdit, {
        props: {
          href: '#new-page-bookmark',
          title: 'Bookmark this page'
        }
      }, ['b']);
    }
  };
};

/***/ }),

/***/ 16775:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex;

var _require2 = __webpack_require__(47969),
    asciiSpinner = _require2.asciiSpinner;

var _require3 = __webpack_require__(60089),
    Editor = _require3.Editor;

module.exports.PopoverEdit = {
  name: 'BookmarksPopoverEdit',
  props: {
    sectionId: {
      type: String,
      required: false
    },
    sectionNumber: {
      type: Number,
      required: false
    },
    sectionTitle: {
      type: String,
      required: false
    },
    href: {
      type: String,
      required: true
    },
    title: {
      type: String,
      required: true
    },
    bookmarkId: {
      type: Number,
      required: false
    },
    bookmarkActionDue: {
      type: String,
      required: false
    },
    bookmarkNotes: {
      type: String,
      required: false
    }
  },
  computed: _objectSpread({}, Vuex.mapState('plugins/bookmarks', ['loading'])),
  render: function render(h) {
    if (this.loading) return h(asciiSpinner);
    return h('ElPopover', [h(Editor, {
      props: {
        sectionId: this.sectionId,
        sectionNumber: this.sectionNumber,
        sectionTitle: this.sectionTitle,
        bookmarkId: this.bookmarkId,
        bookmarkActionDue: this.bookmarkActionDue,
        bookmarkNotes: this.bookmarkNotes
      }
    }), h('a', {
      slot: 'reference',
      attrs: {
        href: this.href,
        title: this.title
      },
      on: {
        click: function click(event) {
          event.preventDefault();
        }
      }
    }, this.$slots["default"])]);
  }
};

/***/ }),

/***/ 69279:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vue = _require.Vue,
    Vuex = _require.Vuex;

var _require2 = __webpack_require__(47969),
    asciiSpinner = _require2.asciiSpinner;

var _require3 = __webpack_require__(94035),
    Manager = _require3.Manager;

module.exports.PopoverManager = {
  name: 'BookmarksPopoverManager',
  props: {
    href: {
      type: String,
      required: true
    },
    title: {
      type: String,
      required: true
    },
    bookmarks: {
      type: Array,
      required: true
    },
    shownFields: {
      type: Array,
      required: true
    },
    updateShownFields: {
      type: Function,
      required: true
    },
    sectionId: {
      type: String,
      required: false
    },
    sectionNumber: {
      type: Number,
      required: false
    },
    sectionTitle: {
      type: String,
      required: false
    }
  },
  computed: _objectSpread({}, Vuex.mapState('plugins/bookmarks', ['loading'])),
  render: function render(h) {
    if (this.loading) return h(asciiSpinner);
    return h('ElPopover', {
      attrs: {
        // TODO: Only absolute values are accepted apparently, make it more
        //       responsive
        width: 800
      }
    }, [h(Manager, {
      props: {
        shownFields: this.shownFields,
        bookmarks: this.bookmarks,
        updateShownFields: this.updateShownFields,
        sectionId: this.sectionId,
        sectionNumber: this.sectionNumber,
        sectionTitle: this.sectionTitle
      }
    }), h('a', {
      slot: 'reference',
      attrs: {
        href: this.href,
        title: this.title
      },
      on: {
        click: function click(event) {
          event.preventDefault();
        }
      }
    }, ['b', this.bookmarks.length ? h('sup', [this.bookmarks.length]) : null])]);
  }
};

/***/ }),

/***/ 6067:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex;

var _require2 = __webpack_require__(69279),
    PopoverManager = _require2.PopoverManager;

var _require3 = __webpack_require__(16775),
    PopoverEdit = _require3.PopoverEdit;

module.exports.SectionCommand = function (conf) {
  return {
    name: 'BookmarksSectionCommand',
    props: {
      editSection: {
        type: Object,
        required: true
      },
      header: {
        type: Object,
        required: true
      },
      headline: {
        type: Object,
        required: true
      },
      sectionId: {
        type: String,
        required: true
      },
      sectionNumber: {
        type: Number,
        required: true
      },
      sectionTitle: {
        type: String,
        required: true
      }
    },
    computed: _objectSpread({}, Vuex.mapState('plugins/bookmarks', ['sectionShownFields', 'sectionBookmarks'])),
    methods: _objectSpread(_objectSpread({}, Vuex.mapMutations('plugins/bookmarks', ['updateSectionShownFields'])), Vuex.mapActions('plugins/bookmarks', ['querySectionBookmarks'])),
    created: function created() {
      this.querySectionBookmarks(this.sectionId);
    },
    render: function render(h) {
      return this.sectionId in this.sectionBookmarks && this.sectionBookmarks[this.sectionId].length ? h(PopoverManager, {
        props: {
          href: '#manage-section-bookmarks',
          title: "Manage this section's bookmarks",
          bookmarks: this.sectionBookmarks[this.sectionId],
          shownFields: this.sectionShownFields,
          updateShownFields: this.updateSectionShownFields,
          sectionId: this.sectionId,
          sectionNumber: this.sectionNumber,
          sectionTitle: this.sectionTitle
        }
      }) : h(PopoverEdit, {
        props: {
          sectionId: this.sectionId,
          sectionNumber: this.sectionNumber,
          sectionTitle: this.sectionTitle,
          href: '#new-section-bookmark',
          title: 'Bookmark this section'
        }
      }, ['b']);
    }
  };
};

/***/ }),

/***/ 56173:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex;

var _require2 = __webpack_require__(94035),
    Manager = _require2.Manager;

module.exports.TabPage = function (conf) {
  return {
    name: 'BookmarksTabPage',
    computed: _objectSpread({}, Vuex.mapState('plugins/bookmarks', ['allShownFields', 'allBookmarks'])),
    methods: _objectSpread(_objectSpread({}, Vuex.mapMutations('plugins/bookmarks', ['updateAllShownFields'])), Vuex.mapActions('plugins/bookmarks', ['queryAllBookmarks'])),
    created: function created() {
      this.queryAllBookmarks();
    },
    render: function render(h) {
      return h(Manager, {
        props: {
          shownFields: this.allShownFields,
          bookmarks: this.allBookmarks,
          updateShownFields: this.updateAllShownFields
        }
      });
    }
  };
};

/***/ }),

/***/ 90791:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex,
    moment = _require.moment;

var _require2 = __webpack_require__(9604),
    popoverConfirm = _require2.popoverConfirm;

var _require3 = __webpack_require__(34674),
    ExpandedCell = _require3.ExpandedCell;

var _require4 = __webpack_require__(16775),
    PopoverEdit = _require4.PopoverEdit;

module.exports.Table = {
  name: 'BookmarksTable',
  props: {
    shownFields: {
      type: Array,
      required: true
    },
    bookmarks: {
      type: Array,
      required: true
    },
    sectionId: {
      type: String,
      required: false
    },
    sectionNumber: {
      type: Number,
      required: false
    },
    sectionTitle: {
      type: String,
      required: false
    }
  },
  computed: _objectSpread({}, Vuex.mapState('plugins/bookmarks', ['loading'])),
  methods: _objectSpread({}, Vuex.mapActions('plugins/bookmarks', ['deleteBookmark'])),
  render: function render(h) {
    var _this = this;

    // eslint-disable-line complexity
    // TODO: The thead and tbody are put in separate tables, so columns are
    //       given static sizes and it feels too weird...
    return h('div', [h('ElTable', {
      ref: 'table',
      props: {
        rowKey: 'id',
        data: this.bookmarks,
        stripe: true,
        border: true,
        // maxHeight: 1000, // TODO: Fixed header?
        defaultSort: {
          prop: 'time_due',
          order: 'ascending'
        }
      },
      attrs: {
        'element-loading-text': 'Loading...'
      },
      directives: [{
        name: 'loading',
        value: this.loading
      }]
    }, [// TODO: Also enable select checkboxes to delete/move multiple rows at
    //       once? In that case remove the individual deleve/move controls
    //       per row
    h('ElTableColumn', {
      props: {
        type: 'expand',
        minWidth: '10px'
      },
      scopedSlots: {
        "default": function _default(props) {
          return h(ExpandedCell, {
            props: {
              row: props.row
            }
          });
        }
      }
    }), this.shownFields.includes('id') && h('ElTableColumn', {
      props: {
        prop: 'id',
        label: 'id',
        minWidth: '10px',
        sortable: true
      }
    }), this.shownFields.includes('url') && h('ElTableColumn', {
      props: {
        prop: 'url',
        label: 'url',
        minWidth: '60px',
        sortable: true,
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          return h('a', {
            attrs: {
              href: cellValue
            }
          }, [cellValue]);
        }
      }
    }), this.shownFields.includes('wgCanonicalSpecialPageName') && h('ElTableColumn', {
      props: {
        prop: 'wgCanonicalSpecialPageName',
        label: 'wgCanonicalSpecialPageName',
        minWidth: '20px',
        sortable: true
      }
    }), this.shownFields.includes('wgCanonicalNamespace') && h('ElTableColumn', {
      props: {
        prop: 'wgCanonicalNamespace',
        label: 'wgCanonicalNamespace',
        minWidth: '20px',
        sortable: true
      }
    }), this.shownFields.includes('wgPageName') && h('ElTableColumn', {
      props: {
        prop: 'wgPageName',
        label: 'wgPageName',
        minWidth: '20px',
        sortable: true,
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          var title = new mw.Title(cellValue);
          return h('a', {
            attrs: {
              href: row.url
            }
          }, [title.toText()]);
        }
      }
    }), this.shownFields.includes('wgRelevantPageName') && h('ElTableColumn', {
      props: {
        prop: 'wgRelevantPageName',
        label: 'wgRelevantPageName',
        minWidth: '20px',
        sortable: true,
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          var title = new mw.Title(cellValue);
          return h('a', {
            attrs: {
              href: row.url
            }
          }, [title.toText()]);
        }
      }
    }), this.shownFields.includes('wgTitle') && h('ElTableColumn', {
      props: {
        prop: 'wgTitle',
        label: 'wgTitle',
        minWidth: '20px',
        sortable: true,
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          return h('a', {
            attrs: {
              href: row.url
            }
          }, [cellValue]);
        }
      }
    }), this.shownFields.includes('wgAction') && h('ElTableColumn', {
      props: {
        prop: 'wgAction',
        label: 'wgAction',
        minWidth: '20px',
        sortable: true
      }
    }), this.shownFields.includes('wgIsArticle') && h('ElTableColumn', {
      props: {
        prop: 'wgIsArticle',
        label: 'wgIsArticle',
        minWidth: '10px',
        sortable: true
      }
    }), this.shownFields.includes('wgIsProbablyEditable') && h('ElTableColumn', {
      props: {
        prop: 'wgIsProbablyEditable',
        label: 'wgIsProbablyEditable',
        minWidth: '20px',
        sortable: true
      }
    }), this.shownFields.includes('wgRelevantPageIsProbablyEditable') && h('ElTableColumn', {
      props: {
        prop: 'wgRelevantPageIsProbablyEditable',
        label: 'wgRelevantPageIsProbablyEditable',
        minWidth: '20px',
        sortable: true
      }
    }), this.shownFields.includes('wgPageContentLanguage') && h('ElTableColumn', {
      props: {
        prop: 'wgPageContentLanguage',
        label: 'wgPageContentLanguage',
        minWidth: '20px',
        sortable: true
      }
    }), this.shownFields.includes('wgPageContentModel') && h('ElTableColumn', {
      props: {
        prop: 'wgPageContentModel',
        label: 'wgPageContentModel',
        minWidth: '20px',
        sortable: true
      }
    }), this.shownFields.includes('wgArticleId') && h('ElTableColumn', {
      props: {
        prop: 'wgArticleId',
        label: 'wgArticleId',
        minWidth: '10px',
        sortable: true
      }
    }), this.shownFields.includes('wgNamespaceNumber') && h('ElTableColumn', {
      props: {
        prop: 'wgNamespaceNumber',
        label: 'wgNamespaceNumber',
        minWidth: '10px',
        sortable: true
      }
    }), this.shownFields.includes('wgRevisionId') && h('ElTableColumn', {
      props: {
        prop: 'wgRevisionId',
        label: 'wgRevisionId',
        minWidth: '10px',
        sortable: true
      }
    }), this.shownFields.includes('wgCurRevisionId') && h('ElTableColumn', {
      props: {
        prop: 'wgCurRevisionId',
        label: 'wgCurRevisionId',
        minWidth: '10px',
        sortable: true
      }
    }), this.shownFields.includes('wgDiffOldId') && h('ElTableColumn', {
      props: {
        prop: 'wgDiffOldId',
        label: 'wgDiffOldId',
        minWidth: '10px',
        sortable: true
      }
    }), this.shownFields.includes('wgDiffNewId') && h('ElTableColumn', {
      props: {
        prop: 'wgDiffNewId',
        label: 'wgDiffNewId',
        minWidth: '10px',
        sortable: true
      }
    }), this.shownFields.includes('section_id') && h('ElTableColumn', {
      props: {
        prop: 'section_id',
        label: 'section_id',
        minWidth: '20px',
        sortable: true,
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          return h('a', {
            attrs: {
              href: "#".concat(cellValue)
            }
          }, [cellValue]);
        }
      }
    }), this.shownFields.includes('section_number') && h('ElTableColumn', {
      props: {
        prop: 'section_number',
        label: 'section_number',
        minWidth: '20px',
        sortable: true,
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          return h('a', {
            attrs: {
              href: "#".concat(row.section_id)
            }
          }, [cellValue]);
        }
      }
    }), this.shownFields.includes('section_title') && h('ElTableColumn', {
      props: {
        prop: 'section_title',
        label: 'section_title',
        minWidth: '60px',
        sortable: true,
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          return h('a', {
            attrs: {
              href: "#".concat(row.section_id)
            }
          }, [cellValue]);
        }
      }
    }), this.shownFields.includes('time_created') && h('ElTableColumn', {
      props: {
        prop: 'time_created',
        label: 'time_created',
        minWidth: '20px',
        sortable: true,
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          return moment(cellValue).format('YYYY-MM-DD dd HH:mm');
        }
      }
    }), this.shownFields.includes('time_updated') && h('ElTableColumn', {
      props: {
        prop: 'time_updated',
        label: 'time_updated',
        minWidth: '20px',
        sortable: true,
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          return moment(cellValue).format('YYYY-MM-DD dd HH:mm');
        }
      }
    }), this.shownFields.includes('action_due') && h('ElTableColumn', {
      props: {
        prop: 'action_due',
        label: 'action_due',
        minWidth: '20px',
        sortable: true
      }
    }), this.shownFields.includes('time_due') && h('ElTableColumn', {
      props: {
        prop: 'time_due',
        label: 'time_due',
        minWidth: '20px',
        sortable: true,
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          return h('span', {
            attrs: {
              title: moment(cellValue).format('YYYY-MM-DD dd HH:mm')
            }
          }, [moment(cellValue).fromNow()]);
        }
      }
    }), this.shownFields.includes('notes') && h('ElTableColumn', {
      props: {
        prop: 'notes',
        label: 'notes',
        minWidth: '60px',
        sortable: true
      }
    }), h('ElTableColumn', {
      props: {
        minWidth: '20px',
        // Element UI complains that renderHeader is deprecated in favor of
        // the 'header' scoped slot, but I couldn't make it work...
        // https://element.eleme.io/#/en-US/component/table#table-with-custom-header
        // https://github.com/ElemeFE/element/blob/9c32f55892bf15a7287a57b9ec78fe1f138ef64a/packages/table/src/table-column.js#L299
        // scopedSlots: {
        //   header: (props) => [
        renderHeader: function renderHeader(hh, _ref) {
          var column = _ref.column,
              index = _ref.index;
          return ['[ ', // h(PopoverEdit, {
          hh(PopoverEdit, {
            props: {
              sectionId: _this.sectionId,
              sectionNumber: _this.sectionNumber,
              sectionTitle: _this.sectionTitle,
              href: '#new-section-bookmark',
              title: _this.sectionId == null ? 'Add a bookmark for this page' : 'Add a bookmark for this section'
            }
          }, ['+']), ' ]' // ]},
          ];
        },
        formatter: function formatter(row, column, cellValue, index) {
          // eslint-disable-line max-params
          // TODO: Besides the due date, introduce a numeric priority and allow
          //       moving bookmarks up/down?
          //       Maybe each row has a button to start a "move" operation;
          //       After selecting the row to be moved, all the other rows
          //       receive "move above" and "move below" options
          // TODO: Allow changing the page/section that a bookmark refers to e.g.
          //       by copy-pasting its ID (or the new url?); this is useful to
          //       update bookmarks to pages/sections that have been moved
          // TODO: Support searching and filtering
          return ['[\xa0', h(PopoverEdit, {
            props: {
              sectionId: _this.sectionId,
              sectionNumber: _this.sectionNumber,
              sectionTitle: _this.sectionTitle,
              href: '#edit-bookmark',
              title: 'Edit bookmark',
              bookmarkId: row.id,
              bookmarkActionDue: row.action_due,
              bookmarkNotes: row.notes
            }
          }, ['e']), '\xa0|\xa0', h(popoverConfirm, {
            props: {
              question: 'Really delete this bookmark?',
              textConfirm: 'delete',
              // Do *not* use the index from the table's field formatter
              // function, since in general it's different from the bookmark's
              // index in the bookmarks array, which is never resorted and
              // keeps the original sort order
              onConfirm: function onConfirm() {
                _this.deleteBookmark(row);
              }
            }
          }, [h('a', {
            attrs: {
              href: '#delete-bookmark',
              title: 'Delete bookmark'
            },
            on: {
              click: function click(event) {
                event.preventDefault();
              }
            }
          }, ['d'])]), '\xa0]'];
        }
      }
    })])]);
  }
};

/***/ }),

/***/ 27218:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var storeModule = __webpack_require__(97364);

var _require2 = __webpack_require__(25315),
    PageCommand = _require2.PageCommand;

var _require3 = __webpack_require__(6067),
    SectionCommand = _require3.SectionCommand;

var _require4 = __webpack_require__(56173),
    TabPage = _require4.TabPage;

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(Bookmarks, _Plugin2);

  var _super = _createSuper(Bookmarks);

  function Bookmarks() {
    _classCallCheck(this, Bookmarks);

    return _super.apply(this, arguments);
  }

  _createClass(Bookmarks, [{
    key: "install",
    value: function install(_ref) {
      var store = _ref.store,
          pageCommands = _ref.pageCommands,
          sectionCommands = _ref.sectionCommands,
          mainTabs = _ref.mainTabs;
      store('bookmarks', storeModule(this.conf));
      pageCommands(PageCommand(this.conf));
      sectionCommands(SectionCommand(this.conf));
      mainTabs({
        name: 'bookmarks',
        tabTitle: 'Show the bookmarks interface',
        tabLabel: 'bookmarks',
        page: TabPage(this.conf)
      });
    }
  }]);

  return Bookmarks;
}(_Plugin), _defineProperty(_class, "pluginName", 'Bookmarks'), _defineProperty(_class, "requiresServer", true), _defineProperty(_class, "confDefault", {
  enabled: true,
  bookmarkActionChoices: ['reply', 'check for reply', 'watch abuse', 'review edit', 'fix style', 'fix content'],
  defaultBookmarkDelay: '1 day',
  bookmarkDelayChoices: ['15 minutes', '1 hour', '6 hours', '1 day', '2 days', '3 days', '1 week', '2 weeks', '1 month'],
  allTableShownFields: ['wgCanonicalNamespace', 'wgTitle', 'section_title', 'action_due', 'time_due'],
  pageTableShownFields: ['section_title', 'action_due', 'time_due', 'notes'],
  sectionTableShownFields: ['action_due', 'time_due', 'notes']
}), _temp);

/***/ }),

/***/ 97364:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _require = __webpack_require__(78635),
    moment = _require.moment;

function mapIdToIndex(bookmarks) {
  return bookmarks.reduce(function (acc, bm, index) {
    acc[bm.id] = index;
    return acc;
  }, {});
}

module.exports = function storeModule(conf) {
  return {
    namespaced: true,
    state: {
      conf: conf,
      allShownFields: conf.allTableShownFields,
      pageShownFields: conf.pageTableShownFields,
      sectionShownFields: conf.sectionTableShownFields,
      allBookmarks: [],
      pageBookmarks: [],
      sectionBookmarks: {},
      // NOTE how the bookmarks array is left with the original sorting even
      // after sorting of filtering the table rows; this has also the consequence
      // that the index passed to the table's field formatter functions is
      // different in general from the bookmark indexes in the bookmarks array
      // Also don't use a computed value in the component because it could
      // generate race bugs
      allBookmarkIdToIndex: {},
      pageBookmarkIdToIndex: {},
      sectionBookmarkIdToIndex: {},
      loading: false
    },
    mutations: {
      updateAllShownFields: function updateAllShownFields(state, shownFields) {
        state.allShownFields = shownFields;
      },
      updatePageShownFields: function updatePageShownFields(state, shownFields) {
        state.pageShownFields = shownFields;
      },
      updateSectionShownFields: function updateSectionShownFields(state, shownFields) {
        state.sectionShownFields = shownFields;
      },
      setLoading: function setLoading(state) {
        state.loading = true;
      },
      storeAllBookmarks: function storeAllBookmarks(state, allBookmarks) {
        state.allBookmarks = allBookmarks;
        state.allBookmarkIdToIndex = mapIdToIndex(allBookmarks);
        state.loading = false;
      },
      storePageBookmarks: function storePageBookmarks(state, pageBookmarks) {
        state.pageBookmarks = pageBookmarks;
        state.pageBookmarkIdToIndex = mapIdToIndex(pageBookmarks);
        state.loading = false;
      },
      storeSectionBookmarks: function storeSectionBookmarks(state, _ref) {
        var sectionId = _ref.sectionId,
            bookmarks = _ref.bookmarks;
        state.sectionBookmarks = _objectSpread(_objectSpread({}, state.sectionBookmarks), {}, _defineProperty({}, sectionId, bookmarks));
        state.sectionBookmarkIdToIndex = _objectSpread(_objectSpread({}, state.sectionBookmarkIdToIndex), {}, _defineProperty({}, sectionId, mapIdToIndex(bookmarks)));
        state.loading = false;
      },
      upsertBookmark: function upsertBookmark(state, bookmark) {
        var allIndex = state.allBookmarkIdToIndex[bookmark.id];

        if (allIndex == null) {
          // The bookmark is not in allBookmarks (it's new)
          // Just append the new bookmark and let the table's sorter functions
          // visualize its row where it should be; note that the bookmarks array
          // always keeps the original sorting
          state.allBookmarks = state.allBookmarks.concat(bookmark); // Because the new bookmark has only been appended, I can just add the
          // new index to the mapping object, without having to update any others

          state.allBookmarkIdToIndex = _objectSpread(_objectSpread({}, state.allBookmarkIdToIndex), {}, _defineProperty({}, bookmark.id, state.allBookmarks.length - 1));
        } else {
          // The bookmark is already in allBookmarks, no need to update
          // allBookmarkIdToIndex
          state.allBookmarks = state.allBookmarks.slice(0, allIndex).concat(bookmark).concat(state.allBookmarks.slice(allIndex + 1));
        } // Don't merge the following blocks with that for allBookmarks above,
        // since allBookmarks is only queried the first time that the table is
        // visualised, so it may be still empty


        var wgArticleId = mw.config.get('wgArticleId');
        var wgPageName = mw.config.get('wgPageName');
        var pageIndex = state.pageBookmarkIdToIndex[bookmark.id];

        if (pageIndex == null) {
          // The bookmark is not in pageBookmarks (nor in sectionBookmarks,
          // but deal with it separately for clarity, don't optimize for the
          // sake of it)
          if (bookmark.wgArticleId === wgArticleId || bookmark.wgPageName === wgPageName) {
            // The bookmark does refer to this page
            // [analogous comment as for allBookmarks above]
            state.pageBookmarks = state.pageBookmarks.concat(bookmark); // [analogous comment as for allBookmarkIdToIndex above]

            state.pageBookmarkIdToIndex = _objectSpread(_objectSpread({}, state.pageBookmarkIdToIndex), {}, _defineProperty({}, bookmark.id, state.pageBookmarks.length - 1));
          }
        } else {
          // The bookmark is already in pageBookmarks (so it's already proved
          // that it refers to this page), no need to update
          // pageBookmarkIdToIndex
          state.pageBookmarks = state.pageBookmarks.slice(0, pageIndex).concat(bookmark).concat(state.pageBookmarks.slice(pageIndex + 1));
        }

        if (bookmark.section_id in state.sectionBookmarkIdToIndex) {
          // The section ID is in sectionBookmarks (so it's already proved that
          // the bookmark refers to this page)
          var sectionIndex = state.sectionBookmarkIdToIndex[bookmark.section_id][bookmark.id];

          if (sectionIndex == null) {
            // The bookmark is not in sectionBookmarks
            // [analogous comment as for allBookmarks above]
            state.sectionBookmarks[bookmark.section_id] = state.sectionBookmarks[bookmark.section_id].concat(bookmark); // [analogous comment as for allBookmarkIdToIndex above]

            state.sectionBookmarkIdToIndex[bookmark.section_id] = _objectSpread(_objectSpread({}, state.sectionBookmarkIdToIndex[bookmark.section_id]), {}, _defineProperty({}, bookmark.id, state.sectionBookmarks[bookmark.section_id].length - 1));
          } else {
            // The bookmark is already in sectionBookmarks, no need to update
            // sectionBookmarkIdToIndex
            state.sectionBookmarks[bookmark.section_id] = state.sectionBookmarks[bookmark.section_id].slice(0, sectionIndex).concat(bookmark).concat(state.sectionBookmarks[bookmark.section_id].slice(sectionIndex + 1));
          }
        } else if (bookmark.wgArticleId === wgArticleId || bookmark.wgPageName === wgPageName) {
          // Neither the section ID nor the bookmark are in sectionBookmarks
          // The bookmark does refer to this page
          state.sectionBookmarks[bookmark.section_id] = [bookmark];
          state.sectionBookmarkIdToIndex[bookmark.section_id] = _defineProperty({}, bookmark.id, 0);
        }

        state.loading = false;
      },
      // Do *not* use the index from the table's field formatter function, since
      // in general it's different from the bookmark's index in the bookmarks
      // array, which is never resorted and keeps the original sort order
      removeBookmark: function removeBookmark(state, bookmark) {
        var allIndex = state.allBookmarkIdToIndex[bookmark.id];
        var allBookmarks = state.allBookmarks.slice(0, allIndex).concat(state.allBookmarks.slice(allIndex + 1));
        state.allBookmarks = allBookmarks; // Of course don't just remove the key from allBookmarkIdToIndex, since
        // all the subsequent indices must be updated too, so just keep it simple
        // and update them all

        state.allBookmarkIdToIndex = mapIdToIndex(allBookmarks);
        var pageIndex = state.pageBookmarkIdToIndex[bookmark.id];

        if (pageIndex != null) {
          var pageBookmarks = state.pageBookmarks.slice(0, pageIndex).concat(state.pageBookmarks.slice(pageIndex + 1));
          state.pageBookmarks = pageBookmarks; // [analogous comment as for allBookmarkIdToIndex above]

          state.pageBookmarkIdToIndex = mapIdToIndex(pageBookmarks);
        }

        if (bookmark.section_id in state.sectionBookmarkIdToIndex) {
          var sectionIndex = state.sectionBookmarkIdToIndex[bookmark.section_id][bookmark.id];

          if (sectionIndex != null) {
            var sectionBookmarks = state.sectionBookmarks[bookmark.section_id].slice(0, sectionIndex).concat(state.sectionBookmarks[bookmark.section_id].slice(sectionIndex + 1));
            state.sectionBookmarks[bookmark.section_id] = sectionBookmarks; // [analogous comment as for allBookmarkIdToIndex above]

            state.sectionBookmarkIdToIndex[bookmark.section_id] = mapIdToIndex(sectionBookmarks);
          }
        }

        state.loading = false;
      }
    },
    actions: {
      queryAllBookmarks: function queryAllBookmarks(_ref2) {
        return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
          var commit, res;
          return regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  commit = _ref2.commit;
                  commit('setLoading');
                  _context.next = 4;
                  return WM.DB.get('bookmark');

                case 4:
                  res = _context.sent;
                  commit('storeAllBookmarks', res);

                case 6:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }))();
      },
      queryPageBookmarks: function queryPageBookmarks(_ref3) {
        return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
          var commit, res;
          return regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  commit = _ref3.commit;
                  commit('setLoading');
                  _context2.next = 4;
                  return WM.DB.get('bookmark/page', {
                    // Currently the criterion to identify bookmarks belonging to the page
                    // is to match the wgArticleId or the wgPageName (see also on the
                    // server); if changing this, also the criteria in the mutations must
                    // be changed accordingly, e.g. in upsertBookmark and removeBookmark
                    wgArticleId: mw.config.get('wgArticleId'),
                    wgPageName: mw.config.get('wgPageName')
                  });

                case 4:
                  res = _context2.sent;
                  commit('storePageBookmarks', res);

                case 6:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2);
        }))();
      },
      querySectionBookmarks: function querySectionBookmarks(_ref4, sectionId) {
        return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
          var commit, res;
          return regeneratorRuntime.wrap(function _callee3$(_context3) {
            while (1) {
              switch (_context3.prev = _context3.next) {
                case 0:
                  commit = _ref4.commit;
                  commit('setLoading');
                  _context3.next = 4;
                  return WM.DB.get('bookmark/section', {
                    // Currently the criterion to identify bookmarks belonging to the
                    // section is to match the wgArticleId or the wgPageName, and the
                    // section_id (see also on the server); if changing this, also the
                    // criteria in the mutations must be changed accordingly, e.g. in
                    // upsertBookmark and removeBookmark
                    wgArticleId: mw.config.get('wgArticleId'),
                    wgPageName: mw.config.get('wgPageName'),
                    section_id: sectionId
                  });

                case 4:
                  res = _context3.sent;
                  commit('storeSectionBookmarks', {
                    sectionId: sectionId,
                    bookmarks: res
                  });

                case 6:
                case "end":
                  return _context3.stop();
              }
            }
          }, _callee3);
        }))();
      },
      saveBookmark: function saveBookmark(_ref5, _ref6) {
        return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
          var commit, _ref6$sectionId, sectionId, _ref6$sectionNumber, sectionNumber, _ref6$sectionTitle, sectionTitle, _ref6$bookmarkId, bookmarkId, _ref6$action, action, _ref6$delay, delay, _ref6$notes, notes, data, uri, _delay$match, _delay$match2, _, durationNumber, durationUnit, res;

          return regeneratorRuntime.wrap(function _callee4$(_context4) {
            while (1) {
              switch (_context4.prev = _context4.next) {
                case 0:
                  commit = _ref5.commit;
                  _ref6$sectionId = _ref6.sectionId, sectionId = _ref6$sectionId === void 0 ? null : _ref6$sectionId, _ref6$sectionNumber = _ref6.sectionNumber, sectionNumber = _ref6$sectionNumber === void 0 ? null : _ref6$sectionNumber, _ref6$sectionTitle = _ref6.sectionTitle, sectionTitle = _ref6$sectionTitle === void 0 ? null : _ref6$sectionTitle, _ref6$bookmarkId = _ref6.bookmarkId, bookmarkId = _ref6$bookmarkId === void 0 ? null : _ref6$bookmarkId, _ref6$action = _ref6.action, action = _ref6$action === void 0 ? null : _ref6$action, _ref6$delay = _ref6.delay, delay = _ref6$delay === void 0 ? null : _ref6$delay, _ref6$notes = _ref6.notes, notes = _ref6$notes === void 0 ? null : _ref6$notes;
                  commit('setLoading');

                  if (bookmarkId == null) {
                    data = ['wgArticleId', 'wgPageName', 'wgRelevantPageName', 'wgCanonicalSpecialPageName', 'wgCanonicalNamespace', 'wgNamespaceNumber', 'wgTitle', 'wgRevisionId', 'wgCurRevisionId', 'wgDiffOldId', 'wgDiffNewId', 'wgAction', 'wgIsArticle', 'wgIsProbablyEditable', 'wgRelevantPageIsProbablyEditable', 'wgPageContentLanguage', 'wgPageContentModel' // 'wgCategories'  # TODO
                    ].reduce(function (acc, item) {
                      acc[item] = mw.config.get(item);
                      return acc;
                    }, {}); // Don't rely on the current url's fragment

                    uri = new mw.Uri();
                    uri.fragment = sectionId || null;
                    data.url = uri.toString();
                    data.section_id = sectionId;
                    data.section_number = sectionNumber;
                    data.section_title = sectionTitle;
                  } else {
                    data = {
                      id: bookmarkId
                    };
                  }

                  data.action_due = action; // Duration units must comply with https://momentjs.com/docs/#/durations/
                  // TODO: Return an error for invalid strings

                  _delay$match = delay.match(/([0-9]+) ?((?:[\0-\t\x0B\f\x0E-\u2027\u202A-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)/), _delay$match2 = _slicedToArray(_delay$match, 3), _ = _delay$match2[0], durationNumber = _delay$match2[1], durationUnit = _delay$match2[2];
                  data.time_due = moment().add(parseInt(durationNumber, 10), durationUnit).toISOString();
                  data.notes = notes;

                  if (!(bookmarkId == null)) {
                    _context4.next = 14;
                    break;
                  }

                  _context4.next = 11;
                  return WM.DB.post('bookmark', data);

                case 11:
                  res = _context4.sent;
                  _context4.next = 17;
                  break;

                case 14:
                  _context4.next = 16;
                  return WM.DB.patch('bookmark', data);

                case 16:
                  res = _context4.sent;

                case 17:
                  commit('upsertBookmark', res.bookmark);
                  mw.notification.notify('Bookmark successfully saved.', {
                    tag: 'WikiMonkey-Bookmarks',
                    title: 'Wiki Monkey',
                    type: 'info'
                  });

                case 19:
                case "end":
                  return _context4.stop();
              }
            }
          }, _callee4);
        }))();
      },
      // Do *not* use the index from the table's field formatter function, since
      // in general it's different from the bookmark's index in the bookmarks
      // array, which is never resorted and keeps the original sort order
      deleteBookmark: function deleteBookmark(_ref7, bookmark) {
        return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
          var commit;
          return regeneratorRuntime.wrap(function _callee5$(_context5) {
            while (1) {
              switch (_context5.prev = _context5.next) {
                case 0:
                  commit = _ref7.commit;
                  commit('setLoading');
                  _context5.next = 4;
                  return WM.DB["delete"]('bookmark', {
                    id: bookmark.id
                  });

                case 4:
                  commit('removeBookmark', bookmark);
                  mw.notification.notify('Bookmark successfully deleted.', {
                    tag: 'WikiMonkey-Bookmarks',
                    title: 'Wiki Monkey',
                    type: 'info'
                  });

                case 6:
                case "end":
                  return _context5.stop();
              }
            }
          }, _callee5);
        }))();
      }
    }
  };
};

/***/ }),

/***/ 24106:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class(conf, callNext) {
    _classCallCheck(this, _class);

    var source = WM.Editor.readSource();
    var newtext = source; // Ignoring "I" since writing in 1st person isn't formal anyway
    // Note that JavaScript doesn't support look behind :(
    // Pay attention to preserve the original capitalization

    newtext = this.replace(newtext, /([a-z])'re/ig, '$1 are', '\'re', ['are']);
    newtext = this.replace(newtext, /([a-z])'ve/ig, '$1 have', '\'ve', ['have']);
    newtext = this.replace(newtext, /([a-z])'ll/ig, '$1 will', '\'ll', ['will', 'shall']);
    newtext = this.replace(newtext, /([a-z])'d/ig, '$1 would', '\'d', ['would', 'had']);
    newtext = this.replace(newtext, /(c)an't/ig, '$1annot', 'can\'t', ['cannot']);
    newtext = this.replace(newtext, /(w)on't/ig, '$1ill not', 'won\'t', ['will not']);
    newtext = this.replace(newtext, /([a-z])n't/ig, '$1 not', 'n\'t', ['not']);
    newtext = this.replace(newtext, /(here|there)'s/ig, '$1 is', 'here/there\'s', ['here/there is', 'here/there has']);
    newtext = this.replace(newtext, /(g)onna/ig, '$1oing to', 'gonna', ['going to']); // Replacing he's, she's, that's, what's, where's, who's ... may be too
    //   dangerous

    newtext = this.replace(newtext, /([a-z])'s (been)/ig, '$1 has $2', '\'s been', ['has been']);
    newtext = this.replace(newtext, /(let)'s/ig, '$1 us', 'let\'s', ['let us']);
    newtext = this.replace(newtext, /(it)'(s own)/ig, '$1$2', 'it\'s own', ['its own']);
    var ss = newtext.match(/[a-z]'s/gi);

    if (ss) {
      WM.App.log.warning("Found ".concat(ss.length, " instances of \"'s\": ") + 'check if they can be replaced with "is", "has", ...');
    }

    if (newtext !== source) {
      WM.Editor.writeSource(newtext);
      WM.App.log.info('Expanded contractions');
    }

    if (callNext) {
      return callNext();
    }
  }

  _createClass(_class, [{
    key: "replace",
    value: function replace(source, regExp, newString, checkString, checkStrings) {
      var newtext = source.replace(regExp, newString);

      if (checkStrings.length > 1 && newtext !== source) {
        WM.App.log.warning("Replaced some \"".concat(checkString, "\" with \"").concat(checkStrings[0], "\": check that it didn't mean \"").concat(checkStrings.slice(1).join('\" or \"'), "\" instead"));
      }

      return newtext;
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 73695:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(24106);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(ExpandContractions, _Plugin2);

  var _super = _createSuper(ExpandContractions);

  function ExpandContractions() {
    _classCallCheck(this, ExpandContractions);

    return _super.apply(this, arguments);
  }

  _createClass(ExpandContractions, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var editor = _ref.editor;
      editor(function (callNext) {
        return new Run(_this.conf, callNext);
      });
    }
  }]);

  return ExpandContractions;
}(_Plugin), _defineProperty(_class, "pluginName", 'ExpandContractions'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  editor_menu: ['Text plugins', 'Expand contractions']
}), _temp);

/***/ }),

/***/ 96147:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var readTarget = function readTarget() {
  return document.getElementById('WikiMonkey-FixBacklinkFragments-Target').value;
};

module.exports = /*#__PURE__*/function () {
  function _class(conf, title, callBot, chainArgs) {
    _classCallCheck(this, _class);

    this.conf = conf;
    var summary = this.conf.edit_summary;
    var target = readTarget();
    WM.App.log.hidden("Target page: ".concat(target));

    if (target) {
      if (chainArgs === null) {
        var params = {
          action: 'parse',
          prop: 'sections',
          page: target,
          redirects: 1
        };
        WM.App.log.warning('If some articles in the list are \
linking to the target article \
through a redirect, you should process the backlinks \
of that redirect page separately through its \
Special:WhatLinksHere page, as this plugin can only \
fix links that exactly match the title of the target \
article.\nIn order to save time you are advised to \
hide the redirects in the page lists that allow to do \
so.');
        return WM.MW.callAPIGet(params, this.mainAutoFindSections, [title, target, summary, callBot], null);
      }

      return this.mainAutoRead(target, chainArgs, title, summary, callBot);
    }

    WM.App.log.error('The target page cannot be empty');
    return callBot(false, null);
  }

  _createClass(_class, [{
    key: "fixLinks",
    value: function fixLinks(source, target, sections) {
      // Note that it's impossible to recognize any namespaces in the title
      //   without querying the server
      // Alternatively, a list of the known namespaces could be maintained
      //   for each wiki
      // Recognizing namespaces would let recognize more liberal link
      //   syntaxes (e.g. spaces around the colon)
      var links = WM.Parser.findInternalLinks(source, null, target);
      var newText = '';
      var prevId = 0;

      var _iterator = _createForOfIteratorHelper(links),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var link = _step.value;
          newText += source.substring(prevId, link.index);
          var newlink = link.rawLink;
          var rawfragment = link.fragment;

          if (rawfragment) {
            var fixedFragment = this.fixFragment(rawfragment, sections);

            if (fixedFragment === true) {
              null;
            } else if (fixedFragment) {
              var oldlink = newlink;
              newlink = "[[".concat(target, "#").concat(fixedFragment).concat(link.anchor ? "|".concat(link.anchor) : '', "]]");
              WM.App.log.info("".concat("Fixed broken link fragment: ".concat(oldlink) + ' -> ').concat(WM.App.log.WikiLink(link.link, newlink)));
            } else {
              WM.App.log.warning("Cannot fix broken link fragment: ".concat(WM.App.log.WikiLink(link.link, newlink)));
            }
          }

          newText += newlink;
          prevId = link.index + link.length;
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      newText += source.substr(prevId); // Without this check this plugin would be specific to ArchWiki

      if (location.hostname === 'wiki.archlinux.org') {
        newText = this.fixArchWikiLinks(newText, target, sections);
      }

      return newText;
    }
  }, {
    key: "fixArchWikiLinks",
    value: function fixArchWikiLinks(source, target, sections) {
      var links = WM.Parser.findTemplates(source, 'Related');
      var newText1 = '';
      var prevId = 0;

      var _iterator2 = _createForOfIteratorHelper(links),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var link = _step2.value;
          newText1 += source.substring(prevId, link.index);
          newText1 += this.fixArchWikiLink(target, sections, link, 1);
          prevId = link.index + link.length;
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      newText1 += source.substr(prevId);
      var links2 = WM.Parser.findTemplates(newText1, 'Related2');
      var newText2 = '';
      prevId = 0;

      var _iterator3 = _createForOfIteratorHelper(links2),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var link2 = _step3.value;
          newText2 += newText1.substring(prevId, link2.index);
          newText2 += this.fixArchWikiLink(target, sections, link2, 2);
          prevId = link2.index + link2.length;
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      newText2 += newText1.substr(prevId);
      return newText2;
    }
  }, {
    key: "fixArchWikiLink",
    value: function fixArchWikiLink(target, sections, template, expectedArgs) {
      var args = template.arguments; // Don't crash in case of malformed templates

      if (args.length === expectedArgs) {
        var link = args[0].value;
        var fragId = link.indexOf('#');

        if (fragId > -1) {
          var ltitle = link.substring(0, fragId); // Note that it's impossible to recognize any namespaces in the
          //   title without querying the server
          // Alternatively, a list of the known namespaces could be
          //   maintained for each wiki
          // Recognizing namespaces would let recognize more liberal link
          //   syntaxes (e.g. spaces around the colon)

          if (WM.Parser.compareArticleTitles(ltitle, target)) {
            var rawfragment = link.substr(fragId + 1);
            var fixedFragment = this.fixFragment(rawfragment, sections);

            if (fixedFragment === true) {
              null;
            } else if (fixedFragment) {
              var anchor = args[1] ? "|".concat(args[1].value) : '';
              var newlink = "".concat("{{".concat(template.title, "|").concat(target) + '#').concat(fixedFragment).concat(anchor, "}}");
              WM.App.log.info("Fixed broken link fragment: ".concat(template.rawTransclusion, " -> ").concat(WM.App.log.WikiLink(link, newlink)));
              return newlink;
            } else {
              WM.App.log.warning("Cannot fix broken link fragment: ".concat(WM.App.log.WikiLink(link, template.rawTransclusion)));
            }
          }
        }
      } else {
        WM.App.log.warning("Template:".concat(template.title, " must have ").concat(expectedArgs, " and only ").concat(expectedArgs).concat(expectedArgs > 1 ? ' arguments: ' : ' argument: ').concat(template.rawTransclusion));
      }

      return template.rawTransclusion;
    }
  }, {
    key: "fixFragment",
    value: function fixFragment(rawfragment, sections) {
      if (rawfragment) {
        var fragment = WM.Parser.squashContiguousWhitespace(rawfragment).trim();

        if (sections.indexOf(fragment) < 0) {
          var _iterator4 = _createForOfIteratorHelper(sections),
              _step4;

          try {
            for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
              var section = _step4.value;

              // The FixFragments and FixLinkFragments plugins also try
              // to fix dot-encoded fragments however it's too dangerous
              // to do it with this bot plugin, have the user fix
              // fragments manually
              if (section.toLowerCase() === fragment.toLowerCase()) {
                return section;
              }
            }
          } catch (err) {
            _iterator4.e(err);
          } finally {
            _iterator4.f();
          }

          return false;
        }

        return true;
      }

      return true;
    }
  }, {
    key: "mainAutoFindSections",
    value: function mainAutoFindSections(res, args) {
      var title = args[0];
      var target = args[1];
      var summary = args[2];
      var callBot = args[3];
      var sections = [];

      if (res.parse) {
        var _iterator5 = _createForOfIteratorHelper(res.parse.sections),
            _step5;

        try {
          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
            var section = _step5.value;
            sections.push(WM.Parser.squashContiguousWhitespace(section.line).trim());
          }
        } catch (err) {
          _iterator5.e(err);
        } finally {
          _iterator5.f();
        }

        return this.mainAutoRead(target, sections, title, summary, callBot);
      }

      WM.App.log.error("The set target page, ".concat(target) + ', seems not to exist');

      if (res.error) {
        return callBot(res.error.code, sections);
      }

      return callBot(false, sections);
    }
  }, {
    key: "mainAutoRead",
    value: function mainAutoRead(target, sections, title, summary, callBot) {
      return WM.MW.callQueryEdit(title, this.mainAutoWrite, [target, summary, callBot, sections]);
    }
  }, {
    key: "mainAutoWrite",
    value: function mainAutoWrite(title, source, timestamp, edittoken, args) {
      var target = args[0];
      var summary = args[1];
      var callBot = args[2];
      var sections = args[3];
      var newtext = this.fixLinks(source, target, sections);

      if (newtext !== source) {
        return WM.MW.callAPIPost({
          action: 'edit',
          bot: '1',
          title: title,
          summary: summary,
          text: newtext,
          basetimestamp: timestamp,
          token: edittoken
        }, this.mainAutoEnd, [callBot, sections], null);
      }

      return callBot(0, sections);
    }
  }, {
    key: "mainAutoEnd",
    value: function mainAutoEnd(res, args) {
      var callBot = args[0];
      var sections = args[1];

      if (res.edit && res.edit.result === 'Success') {
        return callBot(1, sections);
      } else if (res.error) {
        WM.App.log.error("".concat(res.error.info, " (").concat(res.error.code, ")"));
        return callBot(res.error.code, sections);
      }

      return callBot(false, sections);
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 82495:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    jssc = _require.jssc;

var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class(conf) {
    _classCallCheck(this, _class);

    var _jssc = jssc({
      fixBacklinkFragments: {
        '& input[type=\'text\']': {
          marginLeft: '0.33em'
        }
      }
    }),
        classes = _jssc.classes;

    var divMain = document.createElement('div');
    divMain.id = 'WikiMonkey-FixBacklinkFragments';
    divMain.className = classes.fixBacklinkFragments;
    var label = document.createElement('span');
    label.innerHTML = 'Target page:';
    divMain.appendChild(label);
    var target = document.createElement('input');
    target.setAttribute('type', 'text');
    target.id = 'WikiMonkey-FixBacklinkFragments-Target';

    if (WM.WhatLinksHere.isWhatLinksHerePage()) {
      target.value = WM.WhatLinksHere.getTitle();
    }

    divMain.appendChild(target);
    return divMain;
  }

  return _class;
}();

/***/ }),

/***/ 13374:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(96147);

var UI = __webpack_require__(82495);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(FixBacklinkFragments, _Plugin2);

  var _super = _createSuper(FixBacklinkFragments);

  function FixBacklinkFragments() {
    _classCallCheck(this, FixBacklinkFragments);

    return _super.apply(this, arguments);
  }

  _createClass(FixBacklinkFragments, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var bot = _ref.bot;
      bot(function (title, callBot, chainArgs) {
        return new Run(_this.conf, title, callBot, chainArgs);
      }, function () {
        return new UI(_this.conf);
      });
    }
  }]);

  return FixBacklinkFragments;
}(_Plugin), _defineProperty(_class, "pluginName", 'FixBacklinkFragments'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  bot_label: 'Fix links to specific sections of a target page',
  edit_summary: 'fix links to specific sections'
}), _temp);

/***/ }),

/***/ 75472:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var Str = __webpack_require__(6368);

module.exports = /*#__PURE__*/function () {
  function _class(conf, callNext) {
    _classCallCheck(this, _class);

    this.conf = conf;
    this.main_special(callNext);
  }

  _createClass(_class, [{
    key: "main_special",
    value: function () {
      var _main_special = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(callNext) {
        var _yield$WM$MW$getSpeci, results, siteinfo, namespaces, _iterator, _step, doubleRedirect, error;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                WM.App.log.info('Fixing double redirects ...');
                _context.next = 3;
                return WM.MW.getSpecialList('DoubleRedirects', 'namespaces');

              case 3:
                _yield$WM$MW$getSpeci = _context.sent;
                results = _yield$WM$MW$getSpeci.results;
                siteinfo = _yield$WM$MW$getSpeci.siteinfo;
                namespaces = siteinfo.namespaces;
                results.reverse();
                _context.prev = 8;
                _iterator = _createForOfIteratorHelper(results);
                _context.prev = 10;

                _iterator.s();

              case 12:
                if ((_step = _iterator.n()).done) {
                  _context.next = 18;
                  break;
                }

                doubleRedirect = _step.value;
                _context.next = 16;
                return this.process_redirect(doubleRedirect, namespaces);

              case 16:
                _context.next = 12;
                break;

              case 18:
                _context.next = 23;
                break;

              case 20:
                _context.prev = 20;
                _context.t0 = _context["catch"](10);

                _iterator.e(_context.t0);

              case 23:
                _context.prev = 23;

                _iterator.f();

                return _context.finish(23);

              case 26:
                _context.next = 33;
                break;

              case 28:
                _context.prev = 28;
                _context.t1 = _context["catch"](8);
                error = _context.t1;
                WM.App.log.error(error.message);
                return _context.abrupt("return", false);

              case 33:
                WM.App.log.info('Fixed double redirects');

                if (!callNext) {
                  _context.next = 36;
                  break;
                }

                return _context.abrupt("return", callNext());

              case 36:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[8, 28], [10, 20, 23, 26]]);
      }));

      function main_special(_x) {
        return _main_special.apply(this, arguments);
      }

      return main_special;
    }()
  }, {
    key: "process_redirect",
    value: function () {
      var _process_redirect = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(doubleRedirect, namespaces) {
        var _yield$WM$MW$callQuer, source, timestamp, edittoken, doubleRedirectSource, middleRedirectTitle, middleRedirect, middleRedirectSource, rawOldTarget, oldTarget, rawMiddleTarget, middleTarget, newTargetFragment, newTargetAltAnchor, newTargetInterlanguage, newTargetNamespace, newTargetTitle, newTarget, newText, res;

        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return WM.MW.callQueryEdit(doubleRedirect.title);

              case 2:
                _yield$WM$MW$callQuer = _context2.sent;
                source = _yield$WM$MW$callQuer.source;
                timestamp = _yield$WM$MW$callQuer.timestamp;
                edittoken = _yield$WM$MW$callQuer.edittoken;
                doubleRedirectSource = source;
                middleRedirectTitle = [namespaces[doubleRedirect.databaseResult.b_namespace]['*'], doubleRedirect.databaseResult.b_title].join(':');
                _context2.next = 10;
                return WM.MW.callQuery({
                  prop: 'revisions',
                  rvprop: 'content',
                  titles: middleRedirectTitle
                });

              case 10:
                middleRedirect = _context2.sent;
                middleRedirectSource = middleRedirect.revisions[0]['*'];
                WM.App.log.info("Processing ".concat(WM.App.log.WikiLink(doubleRedirect.title, doubleRedirect.title), " ..."));
                rawOldTarget = doubleRedirectSource.match(/\s*#redirect\s*[^\n]+/i);
                oldTarget = WM.Parser.findInternalLinks(rawOldTarget[0], null)[0];
                rawMiddleTarget = middleRedirectSource.match(/\s*#redirect\s*[^\n]+/i);
                middleTarget = WM.Parser.findInternalLinks(rawMiddleTarget[0], null)[0];

                newTargetFragment = function () {
                  if (oldTarget.fragment) {
                    return "#".concat(oldTarget.fragment);
                  } else if (middleTarget.fragment) {
                    return "#".concat(middleTarget.fragment);
                  }

                  return '';
                }();

                newTargetAltAnchor = function () {
                  if (oldTarget.anchor) {
                    return "|".concat(oldTarget.anchor);
                  } else if (middleTarget.anchor) {
                    return "|".concat(middleTarget.anchor);
                  }

                  return '';
                }();

                newTargetInterlanguage = doubleRedirect.databaseResult.c_interwiki ? "".concat(doubleRedirect.databaseResult.c_interwiki, ":") : '';

                newTargetNamespace = function () {
                  var cns = namespaces[doubleRedirect.databaseResult.c_namespace]['*'];

                  if (cns) {
                    return "".concat(WM.Parser.squashContiguousWhitespace(cns), ":");
                  }

                  return '';
                }();

                newTargetTitle = WM.Parser.squashContiguousWhitespace(doubleRedirect.databaseResult.c_title);
                newTarget = "[[".concat(newTargetInterlanguage).concat(newTargetNamespace) + "".concat(newTargetTitle).concat(newTargetFragment).concat(newTargetAltAnchor, "]]");
                newText = Str.overwriteFor(doubleRedirectSource, newTarget, oldTarget.index, oldTarget.length);

                if (!(newText !== doubleRedirectSource)) {
                  _context2.next = 32;
                  break;
                }

                _context2.next = 27;
                return WM.MW.callAPIPost({
                  action: 'edit',
                  bot: '1',
                  title: doubleRedirect.title,
                  summary: this.conf.edit_summary,
                  text: newText,
                  b1asetimestamp: timestamp,
                  token: edittoken
                });

              case 27:
                res = _context2.sent;

                if (!(!res.edit || res.edit.result !== 'Success')) {
                  _context2.next = 30;
                  break;
                }

                throw new Error("".concat(res.error.info, " (").concat(res.error.code, ")"));

              case 30:
                _context2.next = 33;
                break;

              case 32:
                return _context2.abrupt("return", WM.App.log.warning("Could not fix ".concat(WM.App.log.WikiLink(doubleRedirect.title, doubleRedirect.title))));

              case 33:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function process_redirect(_x2, _x3) {
        return _process_redirect.apply(this, arguments);
      }

      return process_redirect;
    }()
  }]);

  return _class;
}();

/***/ }),

/***/ 29818:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(75472);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(FixDoubleRedirects, _Plugin2);

  var _super = _createSuper(FixDoubleRedirects);

  function FixDoubleRedirects() {
    _classCallCheck(this, FixDoubleRedirects);

    return _super.apply(this, arguments);
  }

  _createClass(FixDoubleRedirects, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var special = _ref.special;
      special(function (callNext) {
        return new Run(_this.conf, callNext);
      });
    }
  }]);

  return FixDoubleRedirects;
}(_Plugin), _defineProperty(_class, "pluginName", 'FixDoubleRedirects'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  special_menu: ['Fix double redirects'],
  edit_summary: 'fix double redirect'
}), _temp);

/***/ }),

/***/ 4661:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class(conf, callNext) {
    _classCallCheck(this, _class);

    var source = WM.Editor.readSource();
    var newtext = this.fixLinks(source);

    if (newtext !== source) {
      WM.Editor.writeSource(newtext);
      WM.App.log.info('Fixed section links');
    } else {
      WM.App.log.info('No fixable section links found');
    }

    if (callNext) {
      return callNext();
    }
  }

  _createClass(_class, [{
    key: "fixLinks",
    value: function fixLinks(source) {
      var title = WM.Editor.getTitle();

      var _WM$Parser$findSectio = WM.Parser.findSectionHeadings(source),
          sections = _WM$Parser$findSectio.sections;

      var slinks = WM.Parser.findSectionLinks(source);
      var newtext1 = '';
      var prevId = 0;

      var _iterator = _createForOfIteratorHelper(slinks),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var link = _step.value;
          newtext1 += source.substring(prevId, link.index);
          newtext1 += this.fixLink(source, sections, link.rawLink, link.fragment, link.anchor);
          prevId = link.index + link.length;
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      newtext1 += source.substr(prevId); // Note that it's impossible to recognize any namespaces in the title
      //   without querying the server
      // Alternatively, a list of the known namespaces could be maintained
      //   for each wiki
      // Recognizing namespaces would let recognize more liberal link
      //   syntaxes (e.g. spaces around the colon)

      var ilinks = WM.Parser.findInternalLinks(newtext1, null, title);
      var newtext2 = '';
      prevId = 0;

      var _iterator2 = _createForOfIteratorHelper(ilinks),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          link = _step2.value;
          newtext2 += newtext1.substring(prevId, link.index);
          var rawfragment = link.fragment;

          if (rawfragment) {
            newtext2 += this.fixLink(newtext1, sections, link.rawLink, rawfragment, link.anchor);
          } else {
            newtext2 += link.rawLink;
          }

          prevId = link.index + link.length;
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      newtext2 += newtext1.substr(prevId);
      return newtext2;
    }
  }, {
    key: "fixLink",
    value: function fixLink(source, sections, rawlink, rawfragment, lalt) {
      var fragment = WM.Parser.squashContiguousWhitespace(rawfragment).trim();

      var _iterator3 = _createForOfIteratorHelper(sections),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var section = _step3.value;
          var heading = section.cleanheading;
          var dotHeading = WM.Parser.dotEncode(heading);
          var dotFragment = WM.Parser.dotEncode(fragment);

          if (dotHeading.toLowerCase() === dotFragment.toLowerCase()) {
            if (fragment === dotFragment) {
              // If the fragment was encoded, re-encode it because it
              // could contain link-breaking characters (e.g. []|{})
              // The condition would also be true if the fragment doesn't
              // contain any encodable characters, but since heading and
              // fragment at most differ by capitalization, encoding the
              // heading won't have any effect
              return "[[#".concat(dotHeading).concat(lalt ? "|".concat(lalt) : '', "]]");
            } // If the fragment was not encoded, if the fragment
            // contained link-breaking characters the link was already
            // broken, and replacing it with heading wouldn't make
            // things worse; if the fragment didn't contain
            // link-breaking characters, the heading doesn't either,
            // since heading and fragment at most differ by
            // capitalization, so it's safe to replace it
            // If the fragment was *partially* encoded instead, a
            // link-breaking character may have been encoded, so all
            // link-breaking characters must be re-encoded here!


            var escHeading = WM.Parser.dotEncodeLinkBreakingFragmentCharacters(heading);
            return "[[#".concat(escHeading).concat(lalt ? "|".concat(lalt) : '', "]]");
          }
        } // It's not easy to use WM.App.log.WikiLink because pure fragments
        //   are not supported yet

      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      WM.App.log.warning("Cannot fix broken section link: ".concat(rawlink));
      return rawlink;
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 80551:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(4661);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(FixFragments, _Plugin2);

  var _super = _createSuper(FixFragments);

  function FixFragments() {
    _classCallCheck(this, FixFragments);

    return _super.apply(this, arguments);
  }

  _createClass(FixFragments, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var editor = _ref.editor;
      editor(function (callNext) {
        return new Run(_this.conf, callNext);
      });
    }
  }]);

  return FixFragments;
}(_Plugin), _defineProperty(_class, "pluginName", 'FixFragments'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  editor_menu: ['Text plugins', 'Fix section links']
}), _temp);

/***/ }),

/***/ 76744:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ FixLinkFragments)
});

// EXTERNAL MODULE: ./src/plugins/_Plugin.js
var _Plugin = __webpack_require__(52313);
// EXTERNAL MODULE: ./src/index.js
var src = __webpack_require__(62352);
var src_default = /*#__PURE__*/__webpack_require__.n(src);
;// CONCATENATED MODULE: ./src/plugins/FixLinkFragments/fixFragment.js
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.

function fixFragment(rawfragment, sections) {
  var fragment = src_default().Parser.squashContiguousWhitespace(rawfragment).trim();

  if (sections.indexOf(fragment) < 0) {
    var _iterator = _createForOfIteratorHelper(sections),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var section = _step.value;
        var dotSection = src_default().Parser.dotEncode(section);
        var dotFragment = src_default().Parser.dotEncode(fragment);

        if (dotSection.toLowerCase() === dotFragment.toLowerCase()) {
          if (fragment === dotFragment) {
            // If the fragment was encoded, re-encode it because it
            // could contain link-breaking characters (e.g. []|{})
            // The condition would also be true if the fragment
            // doesn't contain any encodable characters, but since
            // section and fragment at most differ by
            // capitalization, encoding the section won't have any
            // effect
            return dotSection;
          } // If the fragment was not encoded, if the fragment
          // contained link-breaking characters the link was
          // already broken, and replacing it with section
          // wouldn't make things worse; if the fragment didn't
          // contain link-breaking characters, the section
          // doesn't either, since section and fragment at most
          // differ by capitalization, so it's safe to replace it
          // If the fragment was *partially* encoded instead, a
          // link-breaking character may have been encoded, so
          // all link-breaking characters must be re-encoded
          // here!


          return src_default().Parser.dotEncodeLinkBreakingFragmentCharacters(section);
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    return false;
  }

  return true;
}
;// CONCATENATED MODULE: ./src/plugins/FixLinkFragments/processLink.js
function processLink_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = processLink_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function processLink_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return processLink_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return processLink_arrayLikeToArray(o, minLen); }

function processLink_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var Str = __webpack_require__(6368);



function processLink(_x) {
  return _processLink.apply(this, arguments);
}

function _processLink() {
  _processLink = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref) {
    var title, iwprefixes, link, newText, rawfragment, target, res;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            title = _ref.title, iwprefixes = _ref.iwprefixes, link = _ref.link, newText = _ref.newText;
            rawfragment = link.fragment;

            if (!((link.namespace == null || !iwprefixes.includes(link.namespace.toLowerCase())) && rawfragment)) {
              _context.next = 11;
              break;
            }

            src_default().App.log.info("Processing ".concat(src_default().App.log.WikiLink(link.link, link.rawLink), " ..."));
            target = (link.namespace ? "".concat(link.namespace, ":") : '') + link.title; // Note that it's impossible to recognize any namespaces in the
            //   title without querying the server
            // Alternatively, a list of the known namespaces could be
            //   maintained for each wiki
            // Recognizing namespaces would let recognize more liberal link
            //   syntaxes (e.g. spaces around the colon)

            if (src_default().Parser.compareArticleTitles(target, title)) {
              _context.next = 11;
              break;
            }

            _context.next = 8;
            return src_default().MW.callAPIGet({
              action: 'parse',
              prop: 'sections',
              page: target,
              redirects: 1
            });

          case 8:
            res = _context.sent;

            if (!res.parse) {
              _context.next = 11;
              break;
            }

            return _context.abrupt("return", processLinkContinue({
              res: res,
              link: link,
              target: target,
              rawfragment: rawfragment,
              newText: newText
            }));

          case 11:
            return _context.abrupt("return", newText);

          case 12:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _processLink.apply(this, arguments);
}

function processLinkContinue(_ref2) {
  var res = _ref2.res,
      link = _ref2.link,
      target = _ref2.target,
      rawfragment = _ref2.rawfragment,
      newText = _ref2.newText;
  var sections = [];

  var _iterator = processLink_createForOfIteratorHelper(res.parse.sections),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var section = _step.value;
      sections.push(src_default().Parser.squashContiguousWhitespace(section.line).trim());
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  var fixedFragment = fixFragment(rawfragment, sections);
  var newLink;

  if (fixedFragment === true) {
    newLink = link.rawLink;
  } else if (fixedFragment) {
    newLink = "[[".concat(target, "#").concat(fixedFragment).concat(link.anchor ? "|".concat(link.anchor) : '', "]]");
  } else {
    src_default().App.log.warning("Cannot fix broken link fragment: ".concat(src_default().App.log.WikiLink(link.link, link.rawLink)));
    newLink = link.rawLink;
  }

  return Str.overwriteFor(newText, newLink, link.index, link.length);
}
;// CONCATENATED MODULE: ./src/plugins/FixLinkFragments/processArchWikiLink.js
function processArchWikiLink_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = processArchWikiLink_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function processArchWikiLink_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return processArchWikiLink_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return processArchWikiLink_arrayLikeToArray(o, minLen); }

function processArchWikiLink_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function processArchWikiLink_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function processArchWikiLink_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { processArchWikiLink_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { processArchWikiLink_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var processArchWikiLink_Str = __webpack_require__(6368);



function processArchWikiLink(_x) {
  return _processArchWikiLink.apply(this, arguments);
}

function _processArchWikiLink() {
  _processArchWikiLink = processArchWikiLink_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref) {
    var title, template, expectedArgs, newText, args, link, fragId, rawtarget, target, rawfragment, res;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            title = _ref.title, template = _ref.template, expectedArgs = _ref.expectedArgs, newText = _ref.newText;
            args = template.arguments; // Don't crash in case of malformed templates

            if (!(args.length === expectedArgs)) {
              _context.next = 19;
              break;
            }

            link = args[0].value;
            fragId = link.indexOf('#');

            if (!(fragId > -1)) {
              _context.next = 17;
              break;
            }

            rawtarget = link.substring(0, fragId);
            target = src_default().Parser.squashContiguousWhitespace(rawtarget).trim();
            rawfragment = link.substr(fragId + 1);

            if (!rawfragment) {
              _context.next = 17;
              break;
            }

            if (src_default().Parser.compareArticleTitles(target, title)) {
              _context.next = 17;
              break;
            }

            src_default().App.log.info("Processing ".concat(src_default().App.log.WikiLink(link, template.rawTransclusion), " ..."));
            _context.next = 14;
            return src_default().MW.callAPIGet({
              action: 'parse',
              prop: 'sections',
              page: target,
              redirects: 1
            });

          case 14:
            res = _context.sent;

            if (!res.parse) {
              _context.next = 17;
              break;
            }

            return _context.abrupt("return", processArchWikiLinkContinue({
              res: res,
              template: template,
              target: target,
              rawfragment: rawfragment,
              newText: newText
            }));

          case 17:
            _context.next = 20;
            break;

          case 19:
            src_default().App.log.warning("Template:".concat(template.title, " must have ").concat(expectedArgs, " and\nonly ").concat(expectedArgs, " ").concat(expectedArgs > 1 ? 'arguments' : 'argument', ":\n").concat(template.rawTransclusion));

          case 20:
            return _context.abrupt("return", newText);

          case 21:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _processArchWikiLink.apply(this, arguments);
}

function processArchWikiLinkContinue(_ref2) {
  var res = _ref2.res,
      template = _ref2.template,
      target = _ref2.target,
      rawfragment = _ref2.rawfragment,
      newText = _ref2.newText;
  var sections = [];

  var _iterator = processArchWikiLink_createForOfIteratorHelper(res.parse.sections),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var section = _step.value;
      sections.push(src_default().Parser.squashContiguousWhitespace(section.line).trim());
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  var fixedFragment = fixFragment(rawfragment, sections);
  var newTemplate;

  if (fixedFragment === true) {
    newTemplate = template.rawTransclusion;
  } else if (fixedFragment) {
    var anchor = template.arguments[1] ? "|".concat(template.arguments[1].value) : '';
    newTemplate = "{{".concat(template.title, "|").concat(target, "#").concat(fixedFragment).concat(anchor, "}}");
  } else {
    src_default().App.log.warning("Cannot fix broken link fragment: ".concat(src_default().App.log.WikiLink(target, template.rawTransclusion)));
    newTemplate = template.rawTransclusion;
  }

  return processArchWikiLink_Str.overwriteFor(newText, newTemplate, template.index, template.length);
}
;// CONCATENATED MODULE: ./src/plugins/FixLinkFragments/run.js
function run_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = run_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function run_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return run_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return run_arrayLikeToArray(o, minLen); }

function run_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function run_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function run_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { run_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { run_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.

/* eslint-disable no-await-in-loop */



function run(_x, _x2) {
  return _run.apply(this, arguments);
}

function _run() {
  _run = run_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(conf, callNext) {
    var source, title, res, iwprefixes, links, newText, _iterator, _step, link, _iterator2, _step2, template, _iterator3, _step3, _template;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            source = src_default().Editor.readSource();
            src_default().App.log.info('Fixing links to sections of other articles ...');
            title = src_default().Editor.getTitle();
            _context.next = 5;
            return src_default().MW.getInterwikiMap(title);

          case 5:
            res = _context.sent;
            iwprefixes = res.query.interwikimap.map(function (iw) {
              return iw.prefix;
            });
            links = src_default().Parser.findInternalLinks(source, null, null);
            newText = source;
            _iterator = run_createForOfIteratorHelper(links);
            _context.prev = 10;

            _iterator.s();

          case 12:
            if ((_step = _iterator.n()).done) {
              _context.next = 19;
              break;
            }

            link = _step.value;
            _context.next = 16;
            return processLink({
              title: title,
              iwprefixes: iwprefixes,
              link: link,
              newText: newText
            });

          case 16:
            newText = _context.sent;

          case 17:
            _context.next = 12;
            break;

          case 19:
            _context.next = 24;
            break;

          case 21:
            _context.prev = 21;
            _context.t0 = _context["catch"](10);

            _iterator.e(_context.t0);

          case 24:
            _context.prev = 24;

            _iterator.f();

            return _context.finish(24);

          case 27:
            if (!(location.hostname === 'wiki.archlinux.org')) {
              _context.next = 64;
              break;
            }

            _iterator2 = run_createForOfIteratorHelper(src_default().Parser.findTemplates(newText, 'Related'));
            _context.prev = 29;

            _iterator2.s();

          case 31:
            if ((_step2 = _iterator2.n()).done) {
              _context.next = 38;
              break;
            }

            template = _step2.value;
            _context.next = 35;
            return processArchWikiLink({
              title: title,
              template: template,
              expectedArgs: 1,
              newText: newText
            });

          case 35:
            newText = _context.sent;

          case 36:
            _context.next = 31;
            break;

          case 38:
            _context.next = 43;
            break;

          case 40:
            _context.prev = 40;
            _context.t1 = _context["catch"](29);

            _iterator2.e(_context.t1);

          case 43:
            _context.prev = 43;

            _iterator2.f();

            return _context.finish(43);

          case 46:
            _iterator3 = run_createForOfIteratorHelper(src_default().Parser.findTemplates(newText, 'Related2'));
            _context.prev = 47;

            _iterator3.s();

          case 49:
            if ((_step3 = _iterator3.n()).done) {
              _context.next = 56;
              break;
            }

            _template = _step3.value;
            _context.next = 53;
            return processArchWikiLink({
              title: title,
              template: _template,
              expectedArgs: 2,
              newText: newText
            });

          case 53:
            newText = _context.sent;

          case 54:
            _context.next = 49;
            break;

          case 56:
            _context.next = 61;
            break;

          case 58:
            _context.prev = 58;
            _context.t2 = _context["catch"](47);

            _iterator3.e(_context.t2);

          case 61:
            _context.prev = 61;

            _iterator3.f();

            return _context.finish(61);

          case 64:
            if (newText === source) {
              src_default().App.log.info('No fixable links to sections of other articles found');
            } else {
              src_default().Editor.writeSource(newText);
              src_default().App.log.info('Replaced links to sections of other articles');
            }

            return _context.abrupt("return", callNext && callNext());

          case 66:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[10, 21, 24, 27], [29, 40, 43, 46], [47, 58, 61, 64]]);
  }));
  return _run.apply(this, arguments);
}
;// CONCATENATED MODULE: ./src/plugins/FixLinkFragments/index.js
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.



var FixLinkFragments = /*#__PURE__*/function (_Plugin2) {
  _inherits(FixLinkFragments, _Plugin2);

  var _super = _createSuper(FixLinkFragments);

  function FixLinkFragments() {
    _classCallCheck(this, FixLinkFragments);

    return _super.apply(this, arguments);
  }

  _createClass(FixLinkFragments, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var editor = _ref.editor;
      editor(function (callNext) {
        return run(_this.conf, callNext);
      });
    }
  }]);

  return FixLinkFragments;
}(_Plugin._Plugin);

_defineProperty(FixLinkFragments, "pluginName", 'FixLinkFragments');

_defineProperty(FixLinkFragments, "requiresServer", false);

_defineProperty(FixLinkFragments, "confDefault", {
  enabled: true,
  editor_menu: ['Query plugins', 'Fix external section links']
});



/***/ }),

/***/ 53193:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class(conf, callNext) {
    _classCallCheck(this, _class);

    var source = WM.Editor.readSource();
    var newtext = source;
    newtext = newtext.replace(/[\n]{3,}/g, '\n\n');

    if (newtext !== source) {
      WM.Editor.writeSource(newtext);
      WM.App.log.info('Removed multiple line breaks');
    }

    if (callNext) {
      return callNext();
    }
  }

  return _class;
}();

/***/ }),

/***/ 61658:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(53193);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(MultipleLineBreaks, _Plugin2);

  var _super = _createSuper(MultipleLineBreaks);

  function MultipleLineBreaks() {
    _classCallCheck(this, MultipleLineBreaks);

    return _super.apply(this, arguments);
  }

  _createClass(MultipleLineBreaks, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var editor = _ref.editor;
      editor(function (callNext) {
        return new Run(_this.conf, callNext);
      });
    }
  }]);

  return MultipleLineBreaks;
}(_Plugin), _defineProperty(_class, "pluginName", 'MultipleLineBreaks'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  editor_menu: ['Text plugins', 'Squash multiple line breaks']
}), _temp);

/***/ }),

/***/ 44316:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _UI = __webpack_require__(84911);

module.exports = /*#__PURE__*/function (_UI2) {
  _inherits(_class, _UI2);

  var _super = _createSuper(_class);

  function _class(conf) {
    var _this;

    _classCallCheck(this, _class);

    _this = _super.call(this);

    var divMain = _this.makeUI();

    var par3 = document.createElement('div');
    var summaryLabel = document.createElement('span');
    summaryLabel.innerHTML = 'Edit summary:';
    var summary = document.createElement('input');
    summary.setAttribute('type', 'text');
    summary.id = 'WikiMonkey-SimpleReplace-Summary';
    par3.appendChild(summaryLabel);
    par3.appendChild(summary);
    divMain.appendChild(par3);
    return _possibleConstructorReturn(_this, divMain);
  }

  return _class;
}(_UI);

/***/ }),

/***/ 24478:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _UI = __webpack_require__(84911);

module.exports = /*#__PURE__*/function (_UI2) {
  _inherits(_class, _UI2);

  var _super = _createSuper(_class);

  function _class(conf) {
    var _this;

    _classCallCheck(this, _class);

    _this = _super.call(this);
    return _possibleConstructorReturn(_this, _this.makeUI());
  }

  return _class;
}(_UI);

/***/ }),

/***/ 25210:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _Run = __webpack_require__(48168);

module.exports = /*#__PURE__*/function (_Run2) {
  _inherits(SimpleReplace, _Run2);

  var _super = _createSuper(SimpleReplace);

  function SimpleReplace(conf, title, callBot, chainArgs) {
    var _this;

    _classCallCheck(this, SimpleReplace);

    _this = _super.call(this);

    _this.storeConfiguration();

    try {
      _this.storeRegExp();
    } catch (exc) {
      WM.App.log.error("Invalid pattern: ".concat(exc));
      callBot(false, null); // Block the execution of this function

      return _possibleConstructorReturn(_this, false);
    }

    var summary = document.getElementById('WikiMonkey-SimpleReplace-Summary').value;

    if (summary !== '') {
      return _possibleConstructorReturn(_this, WM.MW.callQueryEdit(title, _this.mainAutoWrite.bind(_assertThisInitialized(_this)), [summary, callBot]));
    }

    WM.App.log.error('The edit summary cannot be empty');
    return _possibleConstructorReturn(_this, callBot(false, null));
  }

  _createClass(SimpleReplace, [{
    key: "mainAutoWrite",
    value: function mainAutoWrite(title, source, timestamp, edittoken, args) {
      var summary = args[0];
      var callBot = args[1];
      var newtext = source.replace(this.configuration.regExp, this.configuration.newString);

      if (newtext !== source) {
        return WM.MW.callAPIPost({
          action: 'edit',
          bot: '1',
          title: title,
          summary: summary,
          text: newtext,
          basetimestamp: timestamp,
          token: edittoken
        }, this.mainAutoEnd, callBot, null);
      }

      return callBot(0, null);
    }
  }, {
    key: "mainAutoEnd",
    value: function mainAutoEnd(res, callBot) {
      if (res.edit && res.edit.result === 'Success') {
        return callBot(1, null);
      } else if (res.error) {
        WM.App.log.error("".concat(res.error.info, " (").concat(res.error.code, ")"));
        return callBot(res.error.code, null);
      }

      return callBot(false, null);
    }
  }]);

  return SimpleReplace;
}(_Run);

/***/ }),

/***/ 67661:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _Run = __webpack_require__(48168);

module.exports = /*#__PURE__*/function (_Run2) {
  _inherits(SimpleReplace, _Run2);

  var _super = _createSuper(SimpleReplace);

  function SimpleReplace(conf, callNext) {
    var _this;

    _classCallCheck(this, SimpleReplace);

    _this = _super.call(this);

    _this.storeConfiguration();

    try {
      _this.storeRegExp();
    } catch (exc) {
      WM.App.log.error("Invalid pattern: ".concat(exc)); // Block the execution of this function

      return _possibleConstructorReturn(_this, false);
    }

    var source = WM.Editor.readSource();
    var newtext = source.replace(_this.configuration.regExp, _this.configuration.newString);

    if (newtext !== source) {
      WM.Editor.writeSource(newtext);
      WM.App.log.info('Text substituted');
    }

    if (callNext) {
      return _possibleConstructorReturn(_this, callNext());
    }

    return _this;
  }

  return SimpleReplace;
}(_Run);

/***/ }),

/***/ 48168:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class2() {
    _classCallCheck(this, _class2);

    _defineProperty(this, "configuration", null);
  }

  _createClass(_class2, [{
    key: "storeRegExp",
    value: function storeRegExp() {
      this.configuration.regExp = new RegExp(this.configuration.pattern, "g".concat(this.configuration.ignoreCase ? 'i' : ''));
    }
  }, {
    key: "storeConfiguration",
    value: function storeConfiguration() {
      this.configuration = {
        pattern: document.getElementById('WikiMonkey-SimpleReplace-RegExp').value,
        ignoreCase: document.getElementById('WikiMonkey-SimpleReplace-IgnoreCase').checked,
        newString: document.getElementById('WikiMonkey-SimpleReplace-NewString').value
      };
      WM.App.log.hidden("Pattern: ".concat(this.configuration.pattern));
      WM.App.log.hidden("Ignore case: ".concat(this.configuration.ignoreCase));
      WM.App.log.hidden("New string: ".concat(this.configuration.newString));
    }
  }]);

  return _class2;
}();

/***/ }),

/***/ 84911:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    jssc = _require.jssc;

module.exports = /*#__PURE__*/function () {
  function _class() {
    _classCallCheck(this, _class);
  }

  _createClass(_class, [{
    key: "makeUI",
    value: function makeUI() {
      var _jssc = jssc({
        simpleReplace: {
          '& div': {
            marginBottom: '0.33em'
          },
          '& input[type=\'text\']': {
            marginLeft: '0.33em',
            width: '60%'
          }
        }
      }),
          classes = _jssc.classes;

      var divMain = document.createElement('div');
      divMain.id = 'WikiMonkey-SimpleReplace';
      divMain.className = classes.simpleReplace;
      var par1 = document.createElement('div');
      var regexpLabel = document.createElement('span');
      regexpLabel.innerHTML = 'RegExp pattern:';
      var regexp = document.createElement('input');
      regexp.setAttribute('type', 'text');
      regexp.id = 'WikiMonkey-SimpleReplace-RegExp';
      var ignoreCase = document.createElement('input');
      ignoreCase.setAttribute('type', 'checkbox');
      ignoreCase.id = 'WikiMonkey-SimpleReplace-IgnoreCase';
      var ignoreCaseLabel = document.createElement('span');
      ignoreCaseLabel.innerHTML = 'i';
      par1.appendChild(regexpLabel);
      par1.appendChild(regexp);
      par1.appendChild(ignoreCase);
      par1.appendChild(ignoreCaseLabel);
      var par2 = document.createElement('div');
      var newStringLabel = document.createElement('span');
      newStringLabel.innerHTML = 'New string:';
      var newString = document.createElement('input');
      newString.setAttribute('type', 'text');
      newString.id = 'WikiMonkey-SimpleReplace-NewString';
      par2.appendChild(newStringLabel);
      par2.appendChild(newString);
      divMain.appendChild(par1);
      divMain.appendChild(par2);
      return divMain;
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 47132:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var EditorUI = __webpack_require__(24478);

var BotUI = __webpack_require__(44316);

var RunEditor = __webpack_require__(67661);

var RunBot = __webpack_require__(25210);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(SimpleReplace, _Plugin2);

  var _super = _createSuper(SimpleReplace);

  function SimpleReplace() {
    _classCallCheck(this, SimpleReplace);

    return _super.apply(this, arguments);
  }

  _createClass(SimpleReplace, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var editor = _ref.editor,
          bot = _ref.bot;
      editor(function (callNext) {
        return new RunEditor(_this.conf, callNext);
      }, function () {
        return new EditorUI(_this.conf);
      });
      bot(function (title, callBot, chainArgs) {
        return new RunBot(_this.conf, title, callBot, chainArgs);
      }, function () {
        return new BotUI(_this.conf);
      });
    }
  }]);

  return SimpleReplace;
}(_Plugin), _defineProperty(_class, "pluginName", 'SimpleReplace'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  editor_menu: ['RegExp substitution'],
  bot_label: 'RegExp substitution'
}), _temp);

/***/ }),

/***/ 23105:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _Run = __webpack_require__(67193);

module.exports = /*#__PURE__*/function (_Run2) {
  _inherits(SynchronizeInterlanguageLinks, _Run2);

  var _super = _createSuper(SynchronizeInterlanguageLinks);

  function SynchronizeInterlanguageLinks(conf, title, callBot, chainArgs) {
    var _this;

    _classCallCheck(this, SynchronizeInterlanguageLinks);

    _this = _super.call(this);
    _this.conf = conf;

    var detect = _this.detectLang(title, _this.conf.language_tag);

    var pureTitle = detect[0];
    var tag = detect[1];

    var whitelist = _this.computeWhiteList(_this.conf.tag_whitelist);

    var supportedLangs = _this.computeSupportedLangs(_this.conf.supported_tags);

    var summary = _this.conf.edit_summary;
    var wikiUrls = WM.MW.getWikiUrls();
    var url = wikiUrls["short"] + encodeURIComponent(WM.Parser.squashContiguousWhitespace(title));
    var visitedlinks = {};
    var newlinks = {};
    newlinks[tag.toLowerCase()] = WM.Interlanguage.createNewLink(tag, pureTitle, url);
    return _possibleConstructorReturn(_this, WM.Interlanguage.collectLinks(visitedlinks, newlinks, supportedLangs, whitelist, true, _this.mainAutoWrite, [title, url, tag, summary, callBot]));
  }

  _createClass(SynchronizeInterlanguageLinks, [{
    key: "mainAutoWrite",
    value: function mainAutoWrite(links, args) {
      var title = args[0];
      var url = args[1];
      var tag = args[2];
      var summary = args[3];
      var callBot = args[4];
      var lcTag = tag.toLowerCase(); // New links that were not in the white list will have the "iwmap"
      // attribute false, "timestamp" and "edittoken" null and "links" as an
      // empty array, however links[lcTag] should always be safe

      var iwmap = links[lcTag].iwmap;
      var source = links[lcTag].source;
      var langlinks = links[lcTag].links;
      var timestamp = links[lcTag].timestamp;
      var edittoken = links[lcTag].edittoken;
      var newText = WM.Interlanguage.updateLinks(tag, url, iwmap, source, langlinks, links);

      if (newText !== source) {
        return WM.MW.callAPIPost({
          action: 'edit',
          bot: '1',
          title: title,
          summary: summary,
          text: newText,
          basetimestamp: timestamp,
          token: edittoken
        }, this.mainAutoEnd, callBot, null);
      }

      return callBot(0, null);
    }
  }, {
    key: "mainAutoEnd",
    value: function mainAutoEnd(res, callBot) {
      if (res.edit && res.edit.result === 'Success') {
        return callBot(1, null);
      } else if (res.error) {
        WM.App.log.error("".concat(res.error.info, " (").concat(res.error.code, ")"));
        return callBot(res.error.code, null);
      }

      return callBot(false, null);
    }
  }]);

  return SynchronizeInterlanguageLinks;
}(_Run);

/***/ }),

/***/ 54482:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var _Run = __webpack_require__(67193);

module.exports = /*#__PURE__*/function (_Run2) {
  _inherits(SynchronizeInterlanguageLinks, _Run2);

  var _super = _createSuper(SynchronizeInterlanguageLinks);

  function SynchronizeInterlanguageLinks(conf, _callNext) {
    var _this;

    _classCallCheck(this, SynchronizeInterlanguageLinks);

    _this = _super.call(this);

    _defineProperty(_assertThisInitialized(_this), "mainContinue", function (iwmap, args) {
      var tag = args[0];
      var pureTitle = args[1];
      var supportedLangs = args[2];
      var whitelist = args[3];
      var title = args[4];
      var callNext = args[5];
      var source = WM.Editor.readSource();
      var langlinks = WM.Interlanguage.parseLinks(supportedLangs, source, iwmap);
      var wikiUrls = WM.MW.getWikiUrls();
      var url = wikiUrls["short"] + encodeURIComponent(WM.Parser.squashContiguousWhitespace(title));
      var visitedlinks = {};
      visitedlinks[tag.toLowerCase()] = WM.Interlanguage.createVisitedLink(tag, pureTitle, url, iwmap, source, null, null, langlinks);
      var newlinks = {}; // BUG[log]: "Reading edited article" looks quite weird in the log

      WM.App.log.info("Reading ".concat(WM.App.log.PageLink(url, 'edited article')) + ' ...');

      if (langlinks) {
        var _iterator = _createForOfIteratorHelper(langlinks),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var link = _step.value;
            var nlink = newlinks[link.lang.toLowerCase()];
            var vlink = visitedlinks[link.lang.toLowerCase()];

            if (!vlink && !nlink) {
              newlinks[link.lang.toLowerCase()] = WM.Interlanguage.createNewLink(link.lang, link.title, link.url);
            } else if (vlink && vlink.url !== link.url) {
              // Just ignore any conflicting links and warn the user:
              // if it's a real conflict, the user will investigate it,
              // otherwise the user will ignore it
              WM.App.log.warning("".concat('Possibly conflicting interlanguage ' + 'links: ').concat(WM.App.log.PageLink(link.url, "[[".concat(link.lang, ":").concat(link.title, "]]")), " and ").concat(WM.App.log.PageLink(vlink.url, "[[".concat(link.lang, ":").concat(visitedlinks[link.lang.toLowerCase()].title, "]]"))));
            } else if (nlink && nlink.url !== link.url) {
              // Just ignore any conflicting links and warn the user:
              // if it's a real conflict, the user will investigate it,
              // otherwise the user will ignore it
              WM.App.log.warning("".concat('Possibly conflicting interlanguage ' + 'links: ').concat(WM.App.log.PageLink(link.url, "[[".concat(link.lang, ":").concat(link.title, "]]")), " and ").concat(WM.App.log.PageLink(nlink.url, "[[".concat(link.lang, ":").concat(newlinks[link.lang.toLowerCase()].title, "]]"))));
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        return WM.Interlanguage.collectLinks(visitedlinks, newlinks, supportedLangs, whitelist, false, _this.mainEnd, [tag, url, source, langlinks, iwmap, callNext]);
      }

      WM.App.log.info('No interlanguage links found');

      if (callNext) {
        return callNext();
      }
    });

    _this.conf = conf;

    var _title = WM.Editor.getTitle();

    var detect = _this.detectLang(_title, _this.conf.language_tag);

    var _pureTitle = detect[0];
    var _tag = detect[1];

    var _whitelist = _this.computeWhiteList(_this.conf.tag_whitelist);

    var _supportedLangs = _this.computeSupportedLangs(_this.conf.supported_tags);

    WM.App.log.info('Synchronizing interlanguage links ...');
    return _possibleConstructorReturn(_this, WM.MW.getLocalInterwikiMap(_title, _this.mainContinue, [_tag, _pureTitle, _supportedLangs, _whitelist, _title, _callNext]));
  }

  _createClass(SynchronizeInterlanguageLinks, [{
    key: "mainEnd",
    value: function mainEnd(links, args) {
      var tag = args[0];
      var url = args[1];
      var source = args[2];
      var langlinks = args[3];
      var iwmap = args[4];
      var callNext = args[5];
      var newText = WM.Interlanguage.updateLinks(tag, url, iwmap, source, langlinks, links);

      if (newText !== source) {
        WM.Editor.writeSource(newText);
        WM.App.log.info('Synchronized interlanguage links');
      } else {
        WM.App.log.info('Interlanguage links were already synchronized');
      }

      if (callNext) {
        return callNext();
      }
    }
  }]);

  return SynchronizeInterlanguageLinks;
}(_Run);

/***/ }),

/***/ 67193:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

module.exports = /*#__PURE__*/function () {
  function _class() {
    _classCallCheck(this, _class);
  }

  _createClass(_class, [{
    key: "detectLang",
    value: function detectLang(title, tag) {
      // Without this check this plugin would be specific to ArchWiki
      var pureTitle;

      if (tag === 'ArchWiki') {
        var detect = WM.ArchWiki.detectLanguage(title);
        pureTitle = detect[0];
        tag = WM.ArchWiki.getInterlanguageTag(detect[1]);
      } else {
        pureTitle = title;
      }

      return [pureTitle, tag];
    }
  }, {
    key: "computeWhiteList",
    value: function computeWhiteList(whitelist) {
      // Without this check this plugin would be specific to ArchWiki
      if (whitelist === 'ArchWiki') {
        return WM.ArchWiki.getInternalInterwikiLanguages();
      }

      return whitelist;
    }
  }, {
    key: "computeSupportedLangs",
    value: function computeSupportedLangs(supportedLangs) {
      // Without this check this plugin would be specific to ArchWiki
      if (supportedLangs === 'ArchWiki') {
        return WM.ArchWiki.getInterwikiLanguages();
      }

      return supportedLangs;
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 14500:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var RunEditor = __webpack_require__(54482);

var RunBot = __webpack_require__(23105);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(SynchronizeInterlanguageLinks, _Plugin2);

  var _super = _createSuper(SynchronizeInterlanguageLinks);

  function SynchronizeInterlanguageLinks() {
    _classCallCheck(this, SynchronizeInterlanguageLinks);

    return _super.apply(this, arguments);
  }

  _createClass(SynchronizeInterlanguageLinks, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var editor = _ref.editor,
          bot = _ref.bot;
      editor(function (callNext) {
        return new RunEditor(_this.conf, callNext);
      });
      bot(function (title, callBot, chainArgs) {
        return new RunBot(_this.conf, title, callBot, chainArgs);
      });
    }
  }]);

  return SynchronizeInterlanguageLinks;
}(_Plugin), _defineProperty(_class, "pluginName", 'SynchronizeInterlanguageLinks'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  editor_menu: ['Query plugins', 'Sync interlanguage links'],
  bot_label: 'Synchronize interlanguage links',
  language_tag: 'en',
  tag_whitelist: ['en'],
  supported_tags: ['en'],
  edit_summary: 'synchronized interlanguage links with the other wikis'
}), _defineProperty(_class, "wikiToConfDefault", {
  ArchWiki: {
    language_tag: 'ArchWiki',
    tag_whitelist: 'ArchWiki',
    supported_tags: 'ArchWiki'
  },
  Wikipedia: {
    enabled: false
  }
}), _temp);

/***/ }),

/***/ 17035:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var WM = __webpack_require__(62352);

var Str = __webpack_require__(6368);

module.exports = /*#__PURE__*/function () {
  function _class(conf, callNext) {
    _classCallCheck(this, _class);

    this.conf = conf;
    return this.iteratePages(-1, callNext);
  }

  _createClass(_class, [{
    key: "iteratePages",
    value: function iteratePages(pageid, callNext) {
      pageid++;
      var summary = this.conf.edit_summary;
      var showRootAlsoIn = this.conf.show_root_also_in;
      var pconf = this.conf.pages[pageid];

      if (pconf) {
        var params;

        if ($.type(pconf) === 'string') {
          params = WM.ArchWiki.getTableOfContents(pconf);
        } else {
          // This should be a custom configuration object
          params = pconf;
        }

        return this.readToC({
          params: params,
          minInterval: WM.MW.isUserBot() ? 60000 : 21600000,
          edittoken: '',
          timestamp: '',
          source: '',
          startId: 0,
          endId: 0,
          treeText: '',
          startMark: 'START AUTO TOC - DO NOT REMOVE OR MODIFY THIS MARK-->',
          endMark: '<!--END AUTO TOC - DO NOT REMOVE OR MODIFY THIS MARK',
          altNames: {},
          showRootAlsoIn: showRootAlsoIn,
          summary: summary,
          callNext: callNext,
          pageid: pageid
        });
      } else if (callNext) {
        return callNext();
      }
    }
  }, {
    key: "readToC",
    value: function readToC(args) {
      WM.App.log.info("Updating ".concat(WM.App.log.WikiLink(args.params.page, args.params.page), " ..."));
      return WM.MW.callQueryEdit(args.params.page, this.processToC, args);
    }
  }, {
    key: "processToC",
    value: function processToC(title, source, timestamp, edittoken, args) {
      args.source = source;
      args.timestamp = timestamp;
      args.edittoken = edittoken;
      var now = new Date();
      var msTimestamp = Date.parse(args.timestamp);

      if (now.getTime() - msTimestamp >= args.minInterval) {
        var start = args.source.indexOf(args.startMark);
        var end = args.source.lastIndexOf(args.endMark);

        if (start > -1 && end > -1) {
          args.startId = start + args.startMark.length;
          args.endId = end;
          args.treeText = '';
          args.altNames = args.params.keepAltName ? this.storeAlternativeNames(args.source) : {};
          return WM.Cat.recurseTree({
            node: args.params.root,
            callNode: this.processCategory,
            callEnd: this.writeToC,
            callArgs: args
          });
        }

        WM.App.log.error("Cannot find insertion marks in ".concat(WM.App.log.WikiLink(args.params.page, args.params.page)));
        return this.iteratePages(args.pageid, args.callNext);
      }

      WM.App.log.warning("".concat(WM.App.log.WikiLink(args.params.page, args.params.page), " has been updated too recently"));
      return this.iteratePages(args.pageid, args.callNext);
    }
  }, {
    key: "storeAlternativeNames",
    value: function storeAlternativeNames(source) {
      var dict = {};
      var regExp = /\[\[\:([Cc]ategory\:.+?)\|(.+?)\]\]/gm;

      while (true) {
        var match = regExp.exec(source);

        if (match) {
          dict[match[1].toLowerCase()] = match[2];
        } else {
          break;
        }
      }

      return dict;
    }
  }, {
    key: "processCategory",
    value: function processCategory(params) {
      var node;
      var args = params.callArgs;
      WM.App.log.info("Processing ".concat(WM.App.log.WikiLink(params.node, params.node), " ..."));
      var text = '';

      for (var i = 0, end = params.ancestors.length, asc = end >= 0; asc ? i < end : i > end; asc ? i++ : i--) {
        text += args.params.indentType;
      }

      if (args.params.showIndices) {
        var indices = [];
        node = params;

        while (node.parentIndex !== null) {
          indices.push(node.siblingIndex + 1);
          node = params.nodesList[node.parentIndex];
        }

        if (indices.length) {
          text += "<small>".concat(indices.reverse().join('.'), ".</small> ");
        }
      }

      var altName = args.altNames[params.node.toLowerCase()] ? args.altNames[params.node.toLowerCase()] : null;
      text += this.createCatLink(params.node, args.params.replace, altName);
      text += args.params.rightToLeft ? '&lrm; ' : ' ';

      if (params.children === 'loop') {
        text += '\'\'\'[LOOP]\'\'\'\n';
        WM.App.log.warning("Loop in ".concat(WM.App.log.WikiLink(params.node, params.node)));
        return this.processCategoryEnd(params, args, text);
      }

      return WM.Cat.getParentsAndInfo(params.node, this.processCategoryAddSuffix, [params, args, text, altName]);
    }
  }, {
    key: "processCategoryAddSuffix",
    value: function processCategoryAddSuffix(parents, info, args_) {
      var params = args_[0];
      var args = args_[1];
      var text = args_[2];
      var altName = args_[3];
      var currParent = params.ancestors[params.ancestors.length - 1];
      var alsoParents = [];
      text += "<small>(".concat(info ? info.pages : 0, ")"); // Allow hiding the "also in" (whose currParent is undefined) links for
      // the root item, since the root's parent category would be displayed
      // there

      if (currParent || args.showRootAlsoIn) {
        var _iterator = _createForOfIteratorHelper(parents),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var par = _step.value;

            if (currParent !== par.title && !par.includes('hidden')) {
              alsoParents.push(par);
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        if (alsoParents.length) {
          var parentTitles = [];

          var _iterator2 = _createForOfIteratorHelper(alsoParents),
              _step2;

          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var i = _step2.value;
              altName = args.altNames[alsoParents[i].title.toLowerCase()] ? args.altNames[alsoParents[i].title.toLowerCase()] : null;
              parentTitles.push(this.createCatLink(alsoParents[i].title, args.params.replace, altName));
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }

          text += " (".concat(args.params.alsoIn, " ").concat(parentTitles.join(', '), ")");
        }
      }

      text += '</small>\n';
      return this.processCategoryEnd(params, args, text);
    }
  }, {
    key: "processCategoryEnd",
    value: function processCategoryEnd(params, args, text) {
      args.treeText += text;
      params.callArgs = args;
      return WM.Cat.recurseTreeContinue(params);
    }
  }, {
    key: "createCatLink",
    value: function createCatLink(cat, replace, altName) {
      var catName;

      if (altName) {
        catName = altName;
      } else if (replace) {
        var regExp = new RegExp(replace[0], replace[1]);
        catName = cat.substr(9).replace(regExp, replace[2]);
      } else {
        catName = cat.substr(9);
      }

      return "[[:".concat(cat, "|").concat(catName, "]]");
    }
  }, {
    key: "writeToC",
    value: function writeToC(params) {
      var args = params.callArgs;
      args.treeText = "\n".concat(args.treeText);
      var newtext = Str.overwriteBetween(args.source, args.treeText, args.startId, args.endId);

      if (newtext !== args.source) {
        return WM.MW.callAPIPost({
          action: 'edit',
          bot: '1',
          minor: '1',
          title: args.params.page,
          summary: args.summary,
          text: newtext,
          basetimestamp: args.timestamp,
          token: args.edittoken
        }, this.checkWrite, args, null);
      }

      WM.App.log.info("".concat(WM.App.log.WikiLink(args.params.page, args.params.page), " is already up to date"));
      return this.iteratePages(args.pageid, args.callNext);
    }
  }, {
    key: "checkWrite",
    value: function checkWrite(res, args) {
      if (res.edit && res.edit.result === 'Success') {
        WM.App.log.info("".concat(WM.App.log.WikiLink(args.params.page, args.params.page), " correctly updated"));
        return this.iteratePages(args.pageid, args.callNext);
      }

      return WM.App.log.error("".concat(WM.App.log.WikiLink(args.params.page, args.params.page), " has not been updated!\n").concat(res.error.info, " (").concat(res.error.code, ")"));
    }
  }]);

  return _class;
}();

/***/ }),

/***/ 79328:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var Run = __webpack_require__(17035);

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(UpdateCategoryTree, _Plugin2);

  var _super = _createSuper(UpdateCategoryTree);

  function UpdateCategoryTree() {
    _classCallCheck(this, UpdateCategoryTree);

    return _super.apply(this, arguments);
  }

  _createClass(UpdateCategoryTree, [{
    key: "install",
    value: function install(_ref) {
      var _this = this;

      var special = _ref.special;
      special(function (callNext) {
        return new Run(_this.conf, callNext);
      });
    }
  }]);

  return UpdateCategoryTree;
}(_Plugin), _defineProperty(_class, "pluginName", 'UpdateCategoryTree'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: false,
  special_menu: ['Update category trees'],
  edit_summary: 'automatic update',
  show_root_also_in: false,
  pages: []
}), _defineProperty(_class, "wikiToConfDefault", {
  ArchWiki: {
    pages: ['ar', 'bg', 'cs', 'da', 'el', 'en', 'es', 'fi', 'he', 'hr', 'hu', 'id', 'it', 'ko', 'lt', 'nl', 'pl', 'pt', 'ru', 'sk', 'sr', 'sv', 'th', 'tr', 'uk', 'zh-hans', 'zh-hant']
  },
  Wikipedia: {}
}), _temp);

/***/ }),

/***/ 33860:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    Vuex = _require.Vuex;

var _require2 = __webpack_require__(47969),
    asciiSpinner = _require2.asciiSpinner;

module.exports.PersonalToolsCommand = function (conf) {
  return {
    name: 'WatchListPersonalToolsCommandCommand',
    computed: _objectSpread({}, Vuex.mapState('plugins/watchlist', ['loading', 'watchlistUnreadCount'])),
    methods: _objectSpread({}, Vuex.mapActions('plugins/watchlist', ['countWatchlistUnread', 'markWatchlistAllRead'])),
    created: function created() {
      this.countWatchlistUnread({});
    },
    render: function render(h) {
      var _this = this;

      return h('ElPopover', [h('div', [h('div', [h('a', {
        attrs: {
          href: '#refresh-watchlist-unread-count',
          title: 'Refresh unread pages count'
        },
        on: {
          click: function click(event) {
            event.preventDefault();

            _this.countWatchlistUnread({
              forceRefresh: true
            });
          }
        }
      }, ['refresh count'])]), h('div', [h('a', {
        attrs: {
          href: '#mark-all-watchlist-pages-visited',
          title: 'Mark all pages visited'
        },
        on: {
          click: function click(event) {
            event.preventDefault();

            _this.markWatchlistAllRead();
          }
        }
      }, ['mark all read'])])]), h('a', {
        slot: 'reference',
        attrs: {
          href: '#watchlist-commands',
          title: 'Show watchlist commands'
        },
        on: {
          click: function click(event) {
            return event.preventDefault();
          }
        }
      }, [this.loading ? h(asciiSpinner) : this.watchlistUnreadCount])]);
    }
  };
};

/***/ }),

/***/ 59675:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _class, _temp;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(52313),
    _Plugin = _require._Plugin;

var storeModule = __webpack_require__(64006);

var _require2 = __webpack_require__(33860),
    PersonalToolsCommand = _require2.PersonalToolsCommand;

module.exports = (_temp = _class = /*#__PURE__*/function (_Plugin2) {
  _inherits(Watchlist, _Plugin2);

  var _super = _createSuper(Watchlist);

  function Watchlist() {
    _classCallCheck(this, Watchlist);

    return _super.apply(this, arguments);
  }

  _createClass(Watchlist, [{
    key: "install",
    value: function install(_ref) {
      var store = _ref.store,
          personalToolsCommands = _ref.personalToolsCommands;
      store('watchlist', storeModule(this.conf));
      personalToolsCommands(PersonalToolsCommand(this.conf));
    }
  }]);

  return Watchlist;
}(_Plugin), _defineProperty(_class, "pluginName", 'Watchlist'), _defineProperty(_class, "requiresServer", false), _defineProperty(_class, "confDefault", {
  enabled: true,
  minQueryInterval: 1800 // 30 minutes

}), _temp);

/***/ }),

/***/ 64006:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
var _require = __webpack_require__(78635),
    moment = _require.moment;

var WM = __webpack_require__(62352);

module.exports = function storeModule(conf) {
  return {
    namespaced: true,
    state: {
      conf: conf,
      loading: false,
      watchlistUnreadCount: null
    },
    mutations: {
      setLoading: function setLoading(state) {
        state.loading = true;
      },
      storeWatchlistUnreadCount: function storeWatchlistUnreadCount(state, watchlistUnread) {
        state.watchlistUnreadCount = watchlistUnread;
        state.loading = false;
      }
    },
    actions: {
      countWatchlistUnread: function countWatchlistUnread(_ref, _ref2) {
        return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
          var state, commit, forceRefresh, count, cached, _JSON$parse, ccount, tstamp;

          return regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  state = _ref.state, commit = _ref.commit;
                  forceRefresh = _ref2.forceRefresh;
                  commit('setLoading');

                  if (!forceRefresh) {
                    cached = localStorage.getItem('wikiMonkeyWatchlistUnreadCount');

                    if (cached) {
                      _JSON$parse = JSON.parse(cached), ccount = _JSON$parse.count, tstamp = _JSON$parse.tstamp;

                      if (moment().diff(moment(tstamp), 'seconds') < state.conf.minQueryInterval) {
                        // eslint-disable-next-line prefer-destructuring
                        count = ccount;
                      }
                    }
                  }

                  if (!(count == null)) {
                    _context.next = 9;
                    break;
                  }

                  _context.next = 7;
                  return WM.MW.callAPIGet({
                    list: 'watchlist',
                    wllimit: 'max',
                    wlnamespace: '*',
                    wlprop: 'ids',
                    wlshow: 'unread'
                  });

                case 7:
                  count = _context.sent.query.watchlist.length;
                  localStorage.setItem('wikiMonkeyWatchlistUnreadCount', JSON.stringify({
                    count: count,
                    tstamp: moment().toISOString()
                  }));

                case 9:
                  commit('storeWatchlistUnreadCount', count);

                case 10:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }))();
      },
      markWatchlistAllRead: function markWatchlistAllRead(_ref3) {
        return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
          var dispatch, token;
          return regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  dispatch = _ref3.dispatch;
                  _context2.next = 3;
                  return WM.MW.getCsrfToken();

                case 3:
                  token = _context2.sent;
                  _context2.next = 6;
                  return WM.MW.callAPIPost({
                    action: 'setnotificationtimestamp',
                    entirewatchlist: 'true',
                    token: token
                  });

                case 6:
                  dispatch('countWatchlistUnread', {
                    forceRefresh: true
                  });

                case 7:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2);
        }))();
      }
    }
  };
};

/***/ }),

/***/ 52313:
/***/ ((module) => {

var _class, _temp;

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Wiki Monkey - MediaWiki bot and editor-assistant user script
// Copyright (C) 2011 Dario Giovannetti <dev@dariogiovannetti.net>
//
// This file is part of Wiki Monkey.
//
// Wiki Monkey is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Wiki Monkey is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Wiki Monkey.  If not, see <http://www.gnu.org/licenses/>.
module.exports._Plugin = (_temp = _class = /*#__PURE__*/function () {
  function _Plugin(_ref) {
    var wikiName = _ref.wikiName,
        serverUrl = _ref.serverUrl,
        userConfigs = _ref.userConfigs,
        defaultAllPluginsDisabled = _ref.defaultAllPluginsDisabled;

    _classCallCheck(this, _Plugin);

    // requiresServer must be explicitly defined as true or false by each
    // plugin
    if (this.constructor.requiresServer == null) {
      throw new Error("Plugin ".concat(this.constructor.pluginName, " does not define 'requiresServer'."));
    } // Do generate a new object for each plugin


    this.conf = {};

    if (this.constructor.confDefault != null) {
      $.extend(this.conf, this.constructor.confDefault);
    }

    if (this.constructor.wikiToConfDefault != null && wikiName in this.constructor.wikiToConfDefault) {
      $.extend(this.conf, this.constructor.wikiToConfDefault[wikiName]);
    }

    if (defaultAllPluginsDisabled) {
      this.conf.enabled = false;
    }

    var _iterator = _createForOfIteratorHelper(userConfigs),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var _userConfig = _step.value;

        if (this.constructor.pluginName in _userConfig) {
          // Don't just use $.extend() so it's possible to see if there are
          // unknown options and possibly warn the user
          for (var option in _userConfig[this.constructor.pluginName]) {
            var value = _userConfig[this.constructor.pluginName][option];

            if (option in this.conf) {
              this.conf[option] = value; // Remove the option from userConfig so at the end it's possible to
              // list the unused/unknown configuration options

              delete _userConfig[this.constructor.pluginName][option];
            }
          }
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    if (!this.conf.enabled || !serverUrl && this.constructor.requiresServer) {
      var _iterator2 = _createForOfIteratorHelper(userConfigs),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var userConfig = _step2.value;
          // Remove the option from userConfig so at the end it's possible to
          // list the unused/unknown configuration options
          delete userConfig[this.constructor.pluginName];
        } // TODO: Properly extend Error, but beware that Babel doesn't like
        //       it without specific plugins

      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      throw new Error('Plugin disabled');
    }

    var _iterator3 = _createForOfIteratorHelper(userConfigs),
        _step3;

    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var _userConfig2 = _step3.value;

        if ($.isEmptyObject(_userConfig2[this.constructor.pluginName])) {
          // Remove the plugin from userConfig so at the end it's possible to
          // list the unused/unknown configuration options
          delete _userConfig2[this.constructor.pluginName];
        }
      }
    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }
  }

  _createClass(_Plugin, [{
    key: "install",
    value: // I can't rely on the class name because it gets mangled when building and
    // minifying
    // Don't create default objects here, or they'll be shared among the
    // subclasses unless overridden
    // static confDefault = {}
    // static wikiToConfDefault = {}
    // conf = {}
    function install(_install) {
      // eslint-disable-line class-methods-use-this
      throw Error('Not implemented');
    }
  }]);

  return _Plugin;
}(), _defineProperty(_class, "pluginName", null), _defineProperty(_class, "requiresServer", null), _temp);

/***/ }),

/***/ 66824:
/***/ ((module) => {

/*!
 * Cross-Browser Split 1.1.1
 * Copyright 2007-2012 Steven Levithan <stevenlevithan.com>
 * Available under the MIT License
 * ECMAScript compliant, uniform cross-browser split method
 */

/**
 * Splits a string into an array of strings using a regex or string separator. Matches of the
 * separator are not included in the result array. However, if `separator` is a regex that contains
 * capturing groups, backreferences are spliced into the result each time `separator` is matched.
 * Fixes browser bugs compared to the native `String.prototype.split` and can be used reliably
 * cross-browser.
 * @param {String} str String to split.
 * @param {RegExp|String} separator Regex or string to use for separating the string.
 * @param {Number} [limit] Maximum number of items to include in the result array.
 * @returns {Array} Array of substrings.
 * @example
 *
 * // Basic use
 * split('a b c d', ' ');
 * // -> ['a', 'b', 'c', 'd']
 *
 * // With limit
 * split('a b c d', ' ', 2);
 * // -> ['a', 'b']
 *
 * // Backreferences in result array
 * split('..word1 word2..', /([a-z]+)(\d+)/i);
 * // -> ['..', 'word', '1', ' ', 'word', '2', '..']
 */
module.exports = (function split(undef) {

  var nativeSplit = String.prototype.split,
    compliantExecNpcg = /()??/.exec("")[1] === undef,
    // NPCG: nonparticipating capturing group
    self;

  self = function(str, separator, limit) {
    // If `separator` is not a regex, use `nativeSplit`
    if (Object.prototype.toString.call(separator) !== "[object RegExp]") {
      return nativeSplit.call(str, separator, limit);
    }
    var output = [],
      flags = (separator.ignoreCase ? "i" : "") + (separator.multiline ? "m" : "") + (separator.extended ? "x" : "") + // Proposed for ES6
      (separator.sticky ? "y" : ""),
      // Firefox 3+
      lastLastIndex = 0,
      // Make `global` and avoid `lastIndex` issues by working with a copy
      separator = new RegExp(separator.source, flags + "g"),
      separator2, match, lastIndex, lastLength;
    str += ""; // Type-convert
    if (!compliantExecNpcg) {
      // Doesn't need flags gy, but they don't hurt
      separator2 = new RegExp("^" + separator.source + "$(?!\\s)", flags);
    }
    /* Values for `limit`, per the spec:
     * If undefined: 4294967295 // Math.pow(2, 32) - 1
     * If 0, Infinity, or NaN: 0
     * If positive number: limit = Math.floor(limit); if (limit > 4294967295) limit -= 4294967296;
     * If negative number: 4294967296 - Math.floor(Math.abs(limit))
     * If other: Type-convert, then use the above rules
     */
    limit = limit === undef ? -1 >>> 0 : // Math.pow(2, 32) - 1
    limit >>> 0; // ToUint32(limit)
    while (match = separator.exec(str)) {
      // `separator.lastIndex` is not reliable cross-browser
      lastIndex = match.index + match[0].length;
      if (lastIndex > lastLastIndex) {
        output.push(str.slice(lastLastIndex, match.index));
        // Fix browsers whose `exec` methods don't consistently return `undefined` for
        // nonparticipating capturing groups
        if (!compliantExecNpcg && match.length > 1) {
          match[0].replace(separator2, function() {
            for (var i = 1; i < arguments.length - 2; i++) {
              if (arguments[i] === undef) {
                match[i] = undef;
              }
            }
          });
        }
        if (match.length > 1 && match.index < str.length) {
          Array.prototype.push.apply(output, match.slice(1));
        }
        lastLength = match[0].length;
        lastLastIndex = lastIndex;
        if (output.length >= limit) {
          break;
        }
      }
      if (separator.lastIndex === match.index) {
        separator.lastIndex++; // Avoid an infinite loop
      }
    }
    if (lastLastIndex === str.length) {
      if (lastLength || !separator.test("")) {
        output.push("");
      }
    } else {
      output.push(str.slice(lastLastIndex));
    }
    return output.length > limit ? output.slice(0, limit) : output;
  };

  return self;
})();


/***/ }),

/***/ 68071:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// contains, add, remove, toggle
var indexof = __webpack_require__(87355)

module.exports = ClassList

function ClassList(elem) {
    var cl = elem.classList

    if (cl) {
        return cl
    }

    var classList = {
        add: add
        , remove: remove
        , contains: contains
        , toggle: toggle
        , toString: $toString
        , length: 0
        , item: item
    }

    return classList

    function add(token) {
        var list = getTokens()
        if (indexof(list, token) > -1) {
            return
        }
        list.push(token)
        setTokens(list)
    }

    function remove(token) {
        var list = getTokens()
            , index = indexof(list, token)

        if (index === -1) {
            return
        }

        list.splice(index, 1)
        setTokens(list)
    }

    function contains(token) {
        return indexof(getTokens(), token) > -1
    }

    function toggle(token) {
        if (contains(token)) {
            remove(token)
            return false
        } else {
            add(token)
            return true
        }
    }

    function $toString() {
        return elem.className
    }

    function item(index) {
        var tokens = getTokens()
        return tokens[index] || null
    }

    function getTokens() {
        var className = elem.className

        return filter(className.split(" "), isTruthy)
    }

    function setTokens(list) {
        var length = list.length

        elem.className = list.join(" ")
        classList.length = length

        for (var i = 0; i < list.length; i++) {
            classList[i] = list[i]
        }

        delete list[length]
    }
}

function filter (arr, fn) {
    var ret = []
    for (var i = 0; i < arr.length; i++) {
        if (fn(arr[i])) ret.push(arr[i])
    }
    return ret
}

function isTruthy(value) {
    return !!value
}


/***/ }),

/***/ 81653:
/***/ (function(module) {

/*!
 * clipboard.js v2.0.8
 * https://clipboardjs.com/
 *
 * Licensed MIT © Zeno Rocha
 */
!function(t,e){ true?module.exports=e():0}(this,function(){return n={134:function(t,e,n){"use strict";n.d(e,{default:function(){return r}});var e=n(279),i=n.n(e),e=n(370),a=n.n(e),e=n(817),o=n.n(e);function c(t){return(c="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function u(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}var l=function(){function e(t){!function(t){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}(this),this.resolveOptions(t),this.initSelection()}var t,n,r;return t=e,(n=[{key:"resolveOptions",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};this.action=t.action,this.container=t.container,this.emitter=t.emitter,this.target=t.target,this.text=t.text,this.trigger=t.trigger,this.selectedText=""}},{key:"initSelection",value:function(){this.text?this.selectFake():this.target&&this.selectTarget()}},{key:"createFakeElement",value:function(){var t="rtl"===document.documentElement.getAttribute("dir");this.fakeElem=document.createElement("textarea"),this.fakeElem.style.fontSize="12pt",this.fakeElem.style.border="0",this.fakeElem.style.padding="0",this.fakeElem.style.margin="0",this.fakeElem.style.position="absolute",this.fakeElem.style[t?"right":"left"]="-9999px";t=window.pageYOffset||document.documentElement.scrollTop;return this.fakeElem.style.top="".concat(t,"px"),this.fakeElem.setAttribute("readonly",""),this.fakeElem.value=this.text,this.fakeElem}},{key:"selectFake",value:function(){var t=this,e=this.createFakeElement();this.fakeHandlerCallback=function(){return t.removeFake()},this.fakeHandler=this.container.addEventListener("click",this.fakeHandlerCallback)||!0,this.container.appendChild(e),this.selectedText=o()(e),this.copyText(),this.removeFake()}},{key:"removeFake",value:function(){this.fakeHandler&&(this.container.removeEventListener("click",this.fakeHandlerCallback),this.fakeHandler=null,this.fakeHandlerCallback=null),this.fakeElem&&(this.container.removeChild(this.fakeElem),this.fakeElem=null)}},{key:"selectTarget",value:function(){this.selectedText=o()(this.target),this.copyText()}},{key:"copyText",value:function(){var e;try{e=document.execCommand(this.action)}catch(t){e=!1}this.handleResult(e)}},{key:"handleResult",value:function(t){this.emitter.emit(t?"success":"error",{action:this.action,text:this.selectedText,trigger:this.trigger,clearSelection:this.clearSelection.bind(this)})}},{key:"clearSelection",value:function(){this.trigger&&this.trigger.focus(),document.activeElement.blur(),window.getSelection().removeAllRanges()}},{key:"destroy",value:function(){this.removeFake()}},{key:"action",set:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:"copy";if(this._action=t,"copy"!==this._action&&"cut"!==this._action)throw new Error('Invalid "action" value, use either "copy" or "cut"')},get:function(){return this._action}},{key:"target",set:function(t){if(void 0!==t){if(!t||"object"!==c(t)||1!==t.nodeType)throw new Error('Invalid "target" value, use a valid Element');if("copy"===this.action&&t.hasAttribute("disabled"))throw new Error('Invalid "target" attribute. Please use "readonly" instead of "disabled" attribute');if("cut"===this.action&&(t.hasAttribute("readonly")||t.hasAttribute("disabled")))throw new Error('Invalid "target" attribute. You can\'t cut text from elements with "readonly" or "disabled" attributes');this._target=t}},get:function(){return this._target}}])&&u(t.prototype,n),r&&u(t,r),e}();function s(t){return(s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function f(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}function h(t,e){return(h=Object.setPrototypeOf||function(t,e){return t.__proto__=e,t})(t,e)}function d(n){var r=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(t){return!1}}();return function(){var t,e=p(n);return t=r?(t=p(this).constructor,Reflect.construct(e,arguments,t)):e.apply(this,arguments),e=this,!(t=t)||"object"!==s(t)&&"function"!=typeof t?function(t){if(void 0!==t)return t;throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}(e):t}}function p(t){return(p=Object.setPrototypeOf?Object.getPrototypeOf:function(t){return t.__proto__||Object.getPrototypeOf(t)})(t)}function y(t,e){t="data-clipboard-".concat(t);if(e.hasAttribute(t))return e.getAttribute(t)}var r=function(){!function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function");t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,writable:!0,configurable:!0}}),e&&h(t,e)}(o,i());var t,e,n,r=d(o);function o(t,e){var n;return function(t){if(!(t instanceof o))throw new TypeError("Cannot call a class as a function")}(this),(n=r.call(this)).resolveOptions(e),n.listenClick(t),n}return t=o,n=[{key:"isSupported",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:["copy","cut"],t="string"==typeof t?[t]:t,e=!!document.queryCommandSupported;return t.forEach(function(t){e=e&&!!document.queryCommandSupported(t)}),e}}],(e=[{key:"resolveOptions",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{};this.action="function"==typeof t.action?t.action:this.defaultAction,this.target="function"==typeof t.target?t.target:this.defaultTarget,this.text="function"==typeof t.text?t.text:this.defaultText,this.container="object"===s(t.container)?t.container:document.body}},{key:"listenClick",value:function(t){var e=this;this.listener=a()(t,"click",function(t){return e.onClick(t)})}},{key:"onClick",value:function(t){t=t.delegateTarget||t.currentTarget;this.clipboardAction&&(this.clipboardAction=null),this.clipboardAction=new l({action:this.action(t),target:this.target(t),text:this.text(t),container:this.container,trigger:t,emitter:this})}},{key:"defaultAction",value:function(t){return y("action",t)}},{key:"defaultTarget",value:function(t){t=y("target",t);if(t)return document.querySelector(t)}},{key:"defaultText",value:function(t){return y("text",t)}},{key:"destroy",value:function(){this.listener.destroy(),this.clipboardAction&&(this.clipboardAction.destroy(),this.clipboardAction=null)}}])&&f(t.prototype,e),n&&f(t,n),o}()},828:function(t){var e;"undefined"==typeof Element||Element.prototype.matches||((e=Element.prototype).matches=e.matchesSelector||e.mozMatchesSelector||e.msMatchesSelector||e.oMatchesSelector||e.webkitMatchesSelector),t.exports=function(t,e){for(;t&&9!==t.nodeType;){if("function"==typeof t.matches&&t.matches(e))return t;t=t.parentNode}}},438:function(t,e,n){var a=n(828);function i(t,e,n,r,o){var i=function(e,n,t,r){return function(t){t.delegateTarget=a(t.target,n),t.delegateTarget&&r.call(e,t)}}.apply(this,arguments);return t.addEventListener(n,i,o),{destroy:function(){t.removeEventListener(n,i,o)}}}t.exports=function(t,e,n,r,o){return"function"==typeof t.addEventListener?i.apply(null,arguments):"function"==typeof n?i.bind(null,document).apply(null,arguments):("string"==typeof t&&(t=document.querySelectorAll(t)),Array.prototype.map.call(t,function(t){return i(t,e,n,r,o)}))}},879:function(t,n){n.node=function(t){return void 0!==t&&t instanceof HTMLElement&&1===t.nodeType},n.nodeList=function(t){var e=Object.prototype.toString.call(t);return void 0!==t&&("[object NodeList]"===e||"[object HTMLCollection]"===e)&&"length"in t&&(0===t.length||n.node(t[0]))},n.string=function(t){return"string"==typeof t||t instanceof String},n.fn=function(t){return"[object Function]"===Object.prototype.toString.call(t)}},370:function(t,e,n){var l=n(879),s=n(438);t.exports=function(t,e,n){if(!t&&!e&&!n)throw new Error("Missing required arguments");if(!l.string(e))throw new TypeError("Second argument must be a String");if(!l.fn(n))throw new TypeError("Third argument must be a Function");if(l.node(t))return c=e,u=n,(a=t).addEventListener(c,u),{destroy:function(){a.removeEventListener(c,u)}};if(l.nodeList(t))return r=t,o=e,i=n,Array.prototype.forEach.call(r,function(t){t.addEventListener(o,i)}),{destroy:function(){Array.prototype.forEach.call(r,function(t){t.removeEventListener(o,i)})}};if(l.string(t))return t=t,e=e,n=n,s(document.body,t,e,n);throw new TypeError("First argument must be a String, HTMLElement, HTMLCollection, or NodeList");var r,o,i,a,c,u}},817:function(t){t.exports=function(t){var e,n="SELECT"===t.nodeName?(t.focus(),t.value):"INPUT"===t.nodeName||"TEXTAREA"===t.nodeName?((e=t.hasAttribute("readonly"))||t.setAttribute("readonly",""),t.select(),t.setSelectionRange(0,t.value.length),e||t.removeAttribute("readonly"),t.value):(t.hasAttribute("contenteditable")&&t.focus(),n=window.getSelection(),(e=document.createRange()).selectNodeContents(t),n.removeAllRanges(),n.addRange(e),n.toString());return n}},279:function(t){function e(){}e.prototype={on:function(t,e,n){var r=this.e||(this.e={});return(r[t]||(r[t]=[])).push({fn:e,ctx:n}),this},once:function(t,e,n){var r=this;function o(){r.off(t,o),e.apply(n,arguments)}return o._=e,this.on(t,o,n)},emit:function(t){for(var e=[].slice.call(arguments,1),n=((this.e||(this.e={}))[t]||[]).slice(),r=0,o=n.length;r<o;r++)n[r].fn.apply(n[r].ctx,e);return this},off:function(t,e){var n=this.e||(this.e={}),r=n[t],o=[];if(r&&e)for(var i=0,a=r.length;i<a;i++)r[i].fn!==e&&r[i].fn._!==e&&o.push(r[i]);return o.length?n[t]=o:delete n[t],this}},t.exports=e,t.exports.TinyEmitter=e}},o={},r.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return r.d(e,{a:e}),e},r.d=function(t,e){for(var n in e)r.o(e,n)&&!r.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},r.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},r(134).default;function r(t){if(o[t])return o[t].exports;var e=o[t]={exports:{}};return n[t](e,e.exports,r),e.exports}var n,o});

/***/ }),

/***/ 13099:
/***/ ((module) => {

module.exports = function (it) {
  if (typeof it != 'function') {
    throw TypeError(String(it) + ' is not a function');
  } return it;
};


/***/ }),

/***/ 96077:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(70111);

module.exports = function (it) {
  if (!isObject(it) && it !== null) {
    throw TypeError("Can't set " + String(it) + ' as a prototype');
  } return it;
};


/***/ }),

/***/ 51223:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var wellKnownSymbol = __webpack_require__(5112);
var create = __webpack_require__(70030);
var definePropertyModule = __webpack_require__(3070);

var UNSCOPABLES = wellKnownSymbol('unscopables');
var ArrayPrototype = Array.prototype;

// Array.prototype[@@unscopables]
// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
if (ArrayPrototype[UNSCOPABLES] == undefined) {
  definePropertyModule.f(ArrayPrototype, UNSCOPABLES, {
    configurable: true,
    value: create(null)
  });
}

// add a key to Array.prototype[@@unscopables]
module.exports = function (key) {
  ArrayPrototype[UNSCOPABLES][key] = true;
};


/***/ }),

/***/ 31530:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var charAt = __webpack_require__(28710).charAt;

// `AdvanceStringIndex` abstract operation
// https://tc39.es/ecma262/#sec-advancestringindex
module.exports = function (S, index, unicode) {
  return index + (unicode ? charAt(S, index).length : 1);
};


/***/ }),

/***/ 25787:
/***/ ((module) => {

module.exports = function (it, Constructor, name) {
  if (!(it instanceof Constructor)) {
    throw TypeError('Incorrect ' + (name ? name + ' ' : '') + 'invocation');
  } return it;
};


/***/ }),

/***/ 19670:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(70111);

module.exports = function (it) {
  if (!isObject(it)) {
    throw TypeError(String(it) + ' is not an object');
  } return it;
};


/***/ }),

/***/ 24019:
/***/ ((module) => {

// eslint-disable-next-line es/no-typed-arrays -- safe
module.exports = typeof ArrayBuffer !== 'undefined' && typeof DataView !== 'undefined';


/***/ }),

/***/ 90260:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var NATIVE_ARRAY_BUFFER = __webpack_require__(24019);
var DESCRIPTORS = __webpack_require__(19781);
var global = __webpack_require__(17854);
var isObject = __webpack_require__(70111);
var has = __webpack_require__(86656);
var classof = __webpack_require__(70648);
var createNonEnumerableProperty = __webpack_require__(68880);
var redefine = __webpack_require__(31320);
var defineProperty = __webpack_require__(3070).f;
var getPrototypeOf = __webpack_require__(79518);
var setPrototypeOf = __webpack_require__(27674);
var wellKnownSymbol = __webpack_require__(5112);
var uid = __webpack_require__(69711);

var Int8Array = global.Int8Array;
var Int8ArrayPrototype = Int8Array && Int8Array.prototype;
var Uint8ClampedArray = global.Uint8ClampedArray;
var Uint8ClampedArrayPrototype = Uint8ClampedArray && Uint8ClampedArray.prototype;
var TypedArray = Int8Array && getPrototypeOf(Int8Array);
var TypedArrayPrototype = Int8ArrayPrototype && getPrototypeOf(Int8ArrayPrototype);
var ObjectPrototype = Object.prototype;
var isPrototypeOf = ObjectPrototype.isPrototypeOf;

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var TYPED_ARRAY_TAG = uid('TYPED_ARRAY_TAG');
// Fixing native typed arrays in Opera Presto crashes the browser, see #595
var NATIVE_ARRAY_BUFFER_VIEWS = NATIVE_ARRAY_BUFFER && !!setPrototypeOf && classof(global.opera) !== 'Opera';
var TYPED_ARRAY_TAG_REQIRED = false;
var NAME;

var TypedArrayConstructorsList = {
  Int8Array: 1,
  Uint8Array: 1,
  Uint8ClampedArray: 1,
  Int16Array: 2,
  Uint16Array: 2,
  Int32Array: 4,
  Uint32Array: 4,
  Float32Array: 4,
  Float64Array: 8
};

var BigIntArrayConstructorsList = {
  BigInt64Array: 8,
  BigUint64Array: 8
};

var isView = function isView(it) {
  if (!isObject(it)) return false;
  var klass = classof(it);
  return klass === 'DataView'
    || has(TypedArrayConstructorsList, klass)
    || has(BigIntArrayConstructorsList, klass);
};

var isTypedArray = function (it) {
  if (!isObject(it)) return false;
  var klass = classof(it);
  return has(TypedArrayConstructorsList, klass)
    || has(BigIntArrayConstructorsList, klass);
};

var aTypedArray = function (it) {
  if (isTypedArray(it)) return it;
  throw TypeError('Target is not a typed array');
};

var aTypedArrayConstructor = function (C) {
  if (setPrototypeOf) {
    if (isPrototypeOf.call(TypedArray, C)) return C;
  } else for (var ARRAY in TypedArrayConstructorsList) if (has(TypedArrayConstructorsList, NAME)) {
    var TypedArrayConstructor = global[ARRAY];
    if (TypedArrayConstructor && (C === TypedArrayConstructor || isPrototypeOf.call(TypedArrayConstructor, C))) {
      return C;
    }
  } throw TypeError('Target is not a typed array constructor');
};

var exportTypedArrayMethod = function (KEY, property, forced) {
  if (!DESCRIPTORS) return;
  if (forced) for (var ARRAY in TypedArrayConstructorsList) {
    var TypedArrayConstructor = global[ARRAY];
    if (TypedArrayConstructor && has(TypedArrayConstructor.prototype, KEY)) try {
      delete TypedArrayConstructor.prototype[KEY];
    } catch (error) { /* empty */ }
  }
  if (!TypedArrayPrototype[KEY] || forced) {
    redefine(TypedArrayPrototype, KEY, forced ? property
      : NATIVE_ARRAY_BUFFER_VIEWS && Int8ArrayPrototype[KEY] || property);
  }
};

var exportTypedArrayStaticMethod = function (KEY, property, forced) {
  var ARRAY, TypedArrayConstructor;
  if (!DESCRIPTORS) return;
  if (setPrototypeOf) {
    if (forced) for (ARRAY in TypedArrayConstructorsList) {
      TypedArrayConstructor = global[ARRAY];
      if (TypedArrayConstructor && has(TypedArrayConstructor, KEY)) try {
        delete TypedArrayConstructor[KEY];
      } catch (error) { /* empty */ }
    }
    if (!TypedArray[KEY] || forced) {
      // V8 ~ Chrome 49-50 `%TypedArray%` methods are non-writable non-configurable
      try {
        return redefine(TypedArray, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && TypedArray[KEY] || property);
      } catch (error) { /* empty */ }
    } else return;
  }
  for (ARRAY in TypedArrayConstructorsList) {
    TypedArrayConstructor = global[ARRAY];
    if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
      redefine(TypedArrayConstructor, KEY, property);
    }
  }
};

for (NAME in TypedArrayConstructorsList) {
  if (!global[NAME]) NATIVE_ARRAY_BUFFER_VIEWS = false;
}

// WebKit bug - typed arrays constructors prototype is Object.prototype
if (!NATIVE_ARRAY_BUFFER_VIEWS || typeof TypedArray != 'function' || TypedArray === Function.prototype) {
  // eslint-disable-next-line no-shadow -- safe
  TypedArray = function TypedArray() {
    throw TypeError('Incorrect invocation');
  };
  if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME in TypedArrayConstructorsList) {
    if (global[NAME]) setPrototypeOf(global[NAME], TypedArray);
  }
}

if (!NATIVE_ARRAY_BUFFER_VIEWS || !TypedArrayPrototype || TypedArrayPrototype === ObjectPrototype) {
  TypedArrayPrototype = TypedArray.prototype;
  if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME in TypedArrayConstructorsList) {
    if (global[NAME]) setPrototypeOf(global[NAME].prototype, TypedArrayPrototype);
  }
}

// WebKit bug - one more object in Uint8ClampedArray prototype chain
if (NATIVE_ARRAY_BUFFER_VIEWS && getPrototypeOf(Uint8ClampedArrayPrototype) !== TypedArrayPrototype) {
  setPrototypeOf(Uint8ClampedArrayPrototype, TypedArrayPrototype);
}

if (DESCRIPTORS && !has(TypedArrayPrototype, TO_STRING_TAG)) {
  TYPED_ARRAY_TAG_REQIRED = true;
  defineProperty(TypedArrayPrototype, TO_STRING_TAG, { get: function () {
    return isObject(this) ? this[TYPED_ARRAY_TAG] : undefined;
  } });
  for (NAME in TypedArrayConstructorsList) if (global[NAME]) {
    createNonEnumerableProperty(global[NAME], TYPED_ARRAY_TAG, NAME);
  }
}

module.exports = {
  NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS,
  TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQIRED && TYPED_ARRAY_TAG,
  aTypedArray: aTypedArray,
  aTypedArrayConstructor: aTypedArrayConstructor,
  exportTypedArrayMethod: exportTypedArrayMethod,
  exportTypedArrayStaticMethod: exportTypedArrayStaticMethod,
  isView: isView,
  isTypedArray: isTypedArray,
  TypedArray: TypedArray,
  TypedArrayPrototype: TypedArrayPrototype
};


/***/ }),

/***/ 13331:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var global = __webpack_require__(17854);
var DESCRIPTORS = __webpack_require__(19781);
var NATIVE_ARRAY_BUFFER = __webpack_require__(24019);
var createNonEnumerableProperty = __webpack_require__(68880);
var redefineAll = __webpack_require__(12248);
var fails = __webpack_require__(47293);
var anInstance = __webpack_require__(25787);
var toInteger = __webpack_require__(99958);
var toLength = __webpack_require__(17466);
var toIndex = __webpack_require__(57067);
var IEEE754 = __webpack_require__(11179);
var getPrototypeOf = __webpack_require__(79518);
var setPrototypeOf = __webpack_require__(27674);
var getOwnPropertyNames = __webpack_require__(8006).f;
var defineProperty = __webpack_require__(3070).f;
var arrayFill = __webpack_require__(21285);
var setToStringTag = __webpack_require__(58003);
var InternalStateModule = __webpack_require__(29909);

var getInternalState = InternalStateModule.get;
var setInternalState = InternalStateModule.set;
var ARRAY_BUFFER = 'ArrayBuffer';
var DATA_VIEW = 'DataView';
var PROTOTYPE = 'prototype';
var WRONG_LENGTH = 'Wrong length';
var WRONG_INDEX = 'Wrong index';
var NativeArrayBuffer = global[ARRAY_BUFFER];
var $ArrayBuffer = NativeArrayBuffer;
var $DataView = global[DATA_VIEW];
var $DataViewPrototype = $DataView && $DataView[PROTOTYPE];
var ObjectPrototype = Object.prototype;
var RangeError = global.RangeError;

var packIEEE754 = IEEE754.pack;
var unpackIEEE754 = IEEE754.unpack;

var packInt8 = function (number) {
  return [number & 0xFF];
};

var packInt16 = function (number) {
  return [number & 0xFF, number >> 8 & 0xFF];
};

var packInt32 = function (number) {
  return [number & 0xFF, number >> 8 & 0xFF, number >> 16 & 0xFF, number >> 24 & 0xFF];
};

var unpackInt32 = function (buffer) {
  return buffer[3] << 24 | buffer[2] << 16 | buffer[1] << 8 | buffer[0];
};

var packFloat32 = function (number) {
  return packIEEE754(number, 23, 4);
};

var packFloat64 = function (number) {
  return packIEEE754(number, 52, 8);
};

var addGetter = function (Constructor, key) {
  defineProperty(Constructor[PROTOTYPE], key, { get: function () { return getInternalState(this)[key]; } });
};

var get = function (view, count, index, isLittleEndian) {
  var intIndex = toIndex(index);
  var store = getInternalState(view);
  if (intIndex + count > store.byteLength) throw RangeError(WRONG_INDEX);
  var bytes = getInternalState(store.buffer).bytes;
  var start = intIndex + store.byteOffset;
  var pack = bytes.slice(start, start + count);
  return isLittleEndian ? pack : pack.reverse();
};

var set = function (view, count, index, conversion, value, isLittleEndian) {
  var intIndex = toIndex(index);
  var store = getInternalState(view);
  if (intIndex + count > store.byteLength) throw RangeError(WRONG_INDEX);
  var bytes = getInternalState(store.buffer).bytes;
  var start = intIndex + store.byteOffset;
  var pack = conversion(+value);
  for (var i = 0; i < count; i++) bytes[start + i] = pack[isLittleEndian ? i : count - i - 1];
};

if (!NATIVE_ARRAY_BUFFER) {
  $ArrayBuffer = function ArrayBuffer(length) {
    anInstance(this, $ArrayBuffer, ARRAY_BUFFER);
    var byteLength = toIndex(length);
    setInternalState(this, {
      bytes: arrayFill.call(new Array(byteLength), 0),
      byteLength: byteLength
    });
    if (!DESCRIPTORS) this.byteLength = byteLength;
  };

  $DataView = function DataView(buffer, byteOffset, byteLength) {
    anInstance(this, $DataView, DATA_VIEW);
    anInstance(buffer, $ArrayBuffer, DATA_VIEW);
    var bufferLength = getInternalState(buffer).byteLength;
    var offset = toInteger(byteOffset);
    if (offset < 0 || offset > bufferLength) throw RangeError('Wrong offset');
    byteLength = byteLength === undefined ? bufferLength - offset : toLength(byteLength);
    if (offset + byteLength > bufferLength) throw RangeError(WRONG_LENGTH);
    setInternalState(this, {
      buffer: buffer,
      byteLength: byteLength,
      byteOffset: offset
    });
    if (!DESCRIPTORS) {
      this.buffer = buffer;
      this.byteLength = byteLength;
      this.byteOffset = offset;
    }
  };

  if (DESCRIPTORS) {
    addGetter($ArrayBuffer, 'byteLength');
    addGetter($DataView, 'buffer');
    addGetter($DataView, 'byteLength');
    addGetter($DataView, 'byteOffset');
  }

  redefineAll($DataView[PROTOTYPE], {
    getInt8: function getInt8(byteOffset) {
      return get(this, 1, byteOffset)[0] << 24 >> 24;
    },
    getUint8: function getUint8(byteOffset) {
      return get(this, 1, byteOffset)[0];
    },
    getInt16: function getInt16(byteOffset /* , littleEndian */) {
      var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
      return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
    },
    getUint16: function getUint16(byteOffset /* , littleEndian */) {
      var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
      return bytes[1] << 8 | bytes[0];
    },
    getInt32: function getInt32(byteOffset /* , littleEndian */) {
      return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined));
    },
    getUint32: function getUint32(byteOffset /* , littleEndian */) {
      return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined)) >>> 0;
    },
    getFloat32: function getFloat32(byteOffset /* , littleEndian */) {
      return unpackIEEE754(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 23);
    },
    getFloat64: function getFloat64(byteOffset /* , littleEndian */) {
      return unpackIEEE754(get(this, 8, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 52);
    },
    setInt8: function setInt8(byteOffset, value) {
      set(this, 1, byteOffset, packInt8, value);
    },
    setUint8: function setUint8(byteOffset, value) {
      set(this, 1, byteOffset, packInt8, value);
    },
    setInt16: function setInt16(byteOffset, value /* , littleEndian */) {
      set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
    },
    setUint16: function setUint16(byteOffset, value /* , littleEndian */) {
      set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
    },
    setInt32: function setInt32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
    },
    setUint32: function setUint32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
    },
    setFloat32: function setFloat32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packFloat32, value, arguments.length > 2 ? arguments[2] : undefined);
    },
    setFloat64: function setFloat64(byteOffset, value /* , littleEndian */) {
      set(this, 8, byteOffset, packFloat64, value, arguments.length > 2 ? arguments[2] : undefined);
    }
  });
} else {
  /* eslint-disable no-new -- required for testing */
  if (!fails(function () {
    NativeArrayBuffer(1);
  }) || !fails(function () {
    new NativeArrayBuffer(-1);
  }) || fails(function () {
    new NativeArrayBuffer();
    new NativeArrayBuffer(1.5);
    new NativeArrayBuffer(NaN);
    return NativeArrayBuffer.name != ARRAY_BUFFER;
  })) {
  /* eslint-enable no-new -- required for testing */
    $ArrayBuffer = function ArrayBuffer(length) {
      anInstance(this, $ArrayBuffer);
      return new NativeArrayBuffer(toIndex(length));
    };
    var ArrayBufferPrototype = $ArrayBuffer[PROTOTYPE] = NativeArrayBuffer[PROTOTYPE];
    for (var keys = getOwnPropertyNames(NativeArrayBuffer), j = 0, key; keys.length > j;) {
      if (!((key = keys[j++]) in $ArrayBuffer)) {
        createNonEnumerableProperty($ArrayBuffer, key, NativeArrayBuffer[key]);
      }
    }
    ArrayBufferPrototype.constructor = $ArrayBuffer;
  }

  // WebKit bug - the same parent prototype for typed arrays and data view
  if (setPrototypeOf && getPrototypeOf($DataViewPrototype) !== ObjectPrototype) {
    setPrototypeOf($DataViewPrototype, ObjectPrototype);
  }

  // iOS Safari 7.x bug
  var testView = new $DataView(new $ArrayBuffer(2));
  var $setInt8 = $DataViewPrototype.setInt8;
  testView.setInt8(0, 2147483648);
  testView.setInt8(1, 2147483649);
  if (testView.getInt8(0) || !testView.getInt8(1)) redefineAll($DataViewPrototype, {
    setInt8: function setInt8(byteOffset, value) {
      $setInt8.call(this, byteOffset, value << 24 >> 24);
    },
    setUint8: function setUint8(byteOffset, value) {
      $setInt8.call(this, byteOffset, value << 24 >> 24);
    }
  }, { unsafe: true });
}

setToStringTag($ArrayBuffer, ARRAY_BUFFER);
setToStringTag($DataView, DATA_VIEW);

module.exports = {
  ArrayBuffer: $ArrayBuffer,
  DataView: $DataView
};


/***/ }),

/***/ 1048:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toObject = __webpack_require__(47908);
var toAbsoluteIndex = __webpack_require__(51400);
var toLength = __webpack_require__(17466);

var min = Math.min;

// `Array.prototype.copyWithin` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.copywithin
// eslint-disable-next-line es/no-array-prototype-copywithin -- safe
module.exports = [].copyWithin || function copyWithin(target /* = 0 */, start /* = 0, end = @length */) {
  var O = toObject(this);
  var len = toLength(O.length);
  var to = toAbsoluteIndex(target, len);
  var from = toAbsoluteIndex(start, len);
  var end = arguments.length > 2 ? arguments[2] : undefined;
  var count = min((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);
  var inc = 1;
  if (from < to && to < from + count) {
    inc = -1;
    from += count - 1;
    to += count - 1;
  }
  while (count-- > 0) {
    if (from in O) O[to] = O[from];
    else delete O[to];
    to += inc;
    from += inc;
  } return O;
};


/***/ }),

/***/ 21285:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toObject = __webpack_require__(47908);
var toAbsoluteIndex = __webpack_require__(51400);
var toLength = __webpack_require__(17466);

// `Array.prototype.fill` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.fill
module.exports = function fill(value /* , start = 0, end = @length */) {
  var O = toObject(this);
  var length = toLength(O.length);
  var argumentsLength = arguments.length;
  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
  var end = argumentsLength > 2 ? arguments[2] : undefined;
  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
  while (endPos > index) O[index++] = value;
  return O;
};


/***/ }),

/***/ 18533:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $forEach = __webpack_require__(42092).forEach;
var arrayMethodIsStrict = __webpack_require__(9341);

var STRICT_METHOD = arrayMethodIsStrict('forEach');

// `Array.prototype.forEach` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.foreach
module.exports = !STRICT_METHOD ? function forEach(callbackfn /* , thisArg */) {
  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
// eslint-disable-next-line es/no-array-prototype-foreach -- safe
} : [].forEach;


/***/ }),

/***/ 48457:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var bind = __webpack_require__(49974);
var toObject = __webpack_require__(47908);
var callWithSafeIterationClosing = __webpack_require__(53411);
var isArrayIteratorMethod = __webpack_require__(97659);
var toLength = __webpack_require__(17466);
var createProperty = __webpack_require__(86135);
var getIteratorMethod = __webpack_require__(71246);

// `Array.from` method implementation
// https://tc39.es/ecma262/#sec-array.from
module.exports = function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
  var O = toObject(arrayLike);
  var C = typeof this == 'function' ? this : Array;
  var argumentsLength = arguments.length;
  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
  var mapping = mapfn !== undefined;
  var iteratorMethod = getIteratorMethod(O);
  var index = 0;
  var length, result, step, iterator, next, value;
  if (mapping) mapfn = bind(mapfn, argumentsLength > 2 ? arguments[2] : undefined, 2);
  // if the target is not iterable or it's an array with the default iterator - use a simple case
  if (iteratorMethod != undefined && !(C == Array && isArrayIteratorMethod(iteratorMethod))) {
    iterator = iteratorMethod.call(O);
    next = iterator.next;
    result = new C();
    for (;!(step = next.call(iterator)).done; index++) {
      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
      createProperty(result, index, value);
    }
  } else {
    length = toLength(O.length);
    result = new C(length);
    for (;length > index; index++) {
      value = mapping ? mapfn(O[index], index) : O[index];
      createProperty(result, index, value);
    }
  }
  result.length = index;
  return result;
};


/***/ }),

/***/ 41318:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toIndexedObject = __webpack_require__(45656);
var toLength = __webpack_require__(17466);
var toAbsoluteIndex = __webpack_require__(51400);

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

module.exports = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod(false)
};


/***/ }),

/***/ 42092:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var bind = __webpack_require__(49974);
var IndexedObject = __webpack_require__(68361);
var toObject = __webpack_require__(47908);
var toLength = __webpack_require__(17466);
var arraySpeciesCreate = __webpack_require__(65417);

var push = [].push;

// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterOut }` methods implementation
var createMethod = function (TYPE) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var IS_FILTER_OUT = TYPE == 7;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  return function ($this, callbackfn, that, specificCreate) {
    var O = toObject($this);
    var self = IndexedObject(O);
    var boundFunction = bind(callbackfn, that, 3);
    var length = toLength(self.length);
    var index = 0;
    var create = specificCreate || arraySpeciesCreate;
    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_OUT ? create($this, 0) : undefined;
    var value, result;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (TYPE) {
        if (IS_MAP) target[index] = result; // map
        else if (result) switch (TYPE) {
          case 3: return true;              // some
          case 5: return value;             // find
          case 6: return index;             // findIndex
          case 2: push.call(target, value); // filter
        } else switch (TYPE) {
          case 4: return false;             // every
          case 7: push.call(target, value); // filterOut
        }
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
  };
};

module.exports = {
  // `Array.prototype.forEach` method
  // https://tc39.es/ecma262/#sec-array.prototype.foreach
  forEach: createMethod(0),
  // `Array.prototype.map` method
  // https://tc39.es/ecma262/#sec-array.prototype.map
  map: createMethod(1),
  // `Array.prototype.filter` method
  // https://tc39.es/ecma262/#sec-array.prototype.filter
  filter: createMethod(2),
  // `Array.prototype.some` method
  // https://tc39.es/ecma262/#sec-array.prototype.some
  some: createMethod(3),
  // `Array.prototype.every` method
  // https://tc39.es/ecma262/#sec-array.prototype.every
  every: createMethod(4),
  // `Array.prototype.find` method
  // https://tc39.es/ecma262/#sec-array.prototype.find
  find: createMethod(5),
  // `Array.prototype.findIndex` method
  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
  findIndex: createMethod(6),
  // `Array.prototype.filterOut` method
  // https://github.com/tc39/proposal-array-filtering
  filterOut: createMethod(7)
};


/***/ }),

/***/ 86583:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-disable es/no-array-prototype-lastindexof -- safe */
var toIndexedObject = __webpack_require__(45656);
var toInteger = __webpack_require__(99958);
var toLength = __webpack_require__(17466);
var arrayMethodIsStrict = __webpack_require__(9341);

var min = Math.min;
var $lastIndexOf = [].lastIndexOf;
var NEGATIVE_ZERO = !!$lastIndexOf && 1 / [1].lastIndexOf(1, -0) < 0;
var STRICT_METHOD = arrayMethodIsStrict('lastIndexOf');
var FORCED = NEGATIVE_ZERO || !STRICT_METHOD;

// `Array.prototype.lastIndexOf` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.lastindexof
module.exports = FORCED ? function lastIndexOf(searchElement /* , fromIndex = @[*-1] */) {
  // convert -0 to +0
  if (NEGATIVE_ZERO) return $lastIndexOf.apply(this, arguments) || 0;
  var O = toIndexedObject(this);
  var length = toLength(O.length);
  var index = length - 1;
  if (arguments.length > 1) index = min(index, toInteger(arguments[1]));
  if (index < 0) index = length + index;
  for (;index >= 0; index--) if (index in O && O[index] === searchElement) return index || 0;
  return -1;
} : $lastIndexOf;


/***/ }),

/***/ 81194:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(47293);
var wellKnownSymbol = __webpack_require__(5112);
var V8_VERSION = __webpack_require__(7392);

var SPECIES = wellKnownSymbol('species');

module.exports = function (METHOD_NAME) {
  // We can't use this feature detection in V8 since it causes
  // deoptimization and serious performance degradation
  // https://github.com/zloirock/core-js/issues/677
  return V8_VERSION >= 51 || !fails(function () {
    var array = [];
    var constructor = array.constructor = {};
    constructor[SPECIES] = function () {
      return { foo: 1 };
    };
    return array[METHOD_NAME](Boolean).foo !== 1;
  });
};


/***/ }),

/***/ 9341:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(47293);

module.exports = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !!method && fails(function () {
    // eslint-disable-next-line no-useless-call,no-throw-literal -- required for testing
    method.call(null, argument || function () { throw 1; }, 1);
  });
};


/***/ }),

/***/ 53671:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var aFunction = __webpack_require__(13099);
var toObject = __webpack_require__(47908);
var IndexedObject = __webpack_require__(68361);
var toLength = __webpack_require__(17466);

// `Array.prototype.{ reduce, reduceRight }` methods implementation
var createMethod = function (IS_RIGHT) {
  return function (that, callbackfn, argumentsLength, memo) {
    aFunction(callbackfn);
    var O = toObject(that);
    var self = IndexedObject(O);
    var length = toLength(O.length);
    var index = IS_RIGHT ? length - 1 : 0;
    var i = IS_RIGHT ? -1 : 1;
    if (argumentsLength < 2) while (true) {
      if (index in self) {
        memo = self[index];
        index += i;
        break;
      }
      index += i;
      if (IS_RIGHT ? index < 0 : length <= index) {
        throw TypeError('Reduce of empty array with no initial value');
      }
    }
    for (;IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
      memo = callbackfn(memo, self[index], index, O);
    }
    return memo;
  };
};

module.exports = {
  // `Array.prototype.reduce` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduce
  left: createMethod(false),
  // `Array.prototype.reduceRight` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
  right: createMethod(true)
};


/***/ }),

/***/ 65417:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(70111);
var isArray = __webpack_require__(43157);
var wellKnownSymbol = __webpack_require__(5112);

var SPECIES = wellKnownSymbol('species');

// `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate
module.exports = function (originalArray, length) {
  var C;
  if (isArray(originalArray)) {
    C = originalArray.constructor;
    // cross-realm fallback
    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;
    else if (isObject(C)) {
      C = C[SPECIES];
      if (C === null) C = undefined;
    }
  } return new (C === undefined ? Array : C)(length === 0 ? 0 : length);
};


/***/ }),

/***/ 53411:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var anObject = __webpack_require__(19670);
var iteratorClose = __webpack_require__(99212);

// call something on iterator step with safe closing on error
module.exports = function (iterator, fn, value, ENTRIES) {
  try {
    return ENTRIES ? fn(anObject(value)[0], value[1]) : fn(value);
  // 7.4.6 IteratorClose(iterator, completion)
  } catch (error) {
    iteratorClose(iterator);
    throw error;
  }
};


/***/ }),

/***/ 17072:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var wellKnownSymbol = __webpack_require__(5112);

var ITERATOR = wellKnownSymbol('iterator');
var SAFE_CLOSING = false;

try {
  var called = 0;
  var iteratorWithReturn = {
    next: function () {
      return { done: !!called++ };
    },
    'return': function () {
      SAFE_CLOSING = true;
    }
  };
  iteratorWithReturn[ITERATOR] = function () {
    return this;
  };
  // eslint-disable-next-line es/no-array-from, no-throw-literal -- required for testing
  Array.from(iteratorWithReturn, function () { throw 2; });
} catch (error) { /* empty */ }

module.exports = function (exec, SKIP_CLOSING) {
  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
  var ITERATION_SUPPORT = false;
  try {
    var object = {};
    object[ITERATOR] = function () {
      return {
        next: function () {
          return { done: ITERATION_SUPPORT = true };
        }
      };
    };
    exec(object);
  } catch (error) { /* empty */ }
  return ITERATION_SUPPORT;
};


/***/ }),

/***/ 84326:
/***/ ((module) => {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),

/***/ 70648:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var TO_STRING_TAG_SUPPORT = __webpack_require__(51694);
var classofRaw = __webpack_require__(84326);
var wellKnownSymbol = __webpack_require__(5112);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
// ES3 wrong here
var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) { /* empty */ }
};

// getting tag from ES6+ `Object.prototype.toString`
module.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG)) == 'string' ? tag
    // builtinTag case
    : CORRECT_ARGUMENTS ? classofRaw(O)
    // ES3 arguments fallback
    : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
};


/***/ }),

/***/ 95631:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var defineProperty = __webpack_require__(3070).f;
var create = __webpack_require__(70030);
var redefineAll = __webpack_require__(12248);
var bind = __webpack_require__(49974);
var anInstance = __webpack_require__(25787);
var iterate = __webpack_require__(20408);
var defineIterator = __webpack_require__(70654);
var setSpecies = __webpack_require__(96340);
var DESCRIPTORS = __webpack_require__(19781);
var fastKey = __webpack_require__(62423).fastKey;
var InternalStateModule = __webpack_require__(29909);

var setInternalState = InternalStateModule.set;
var internalStateGetterFor = InternalStateModule.getterFor;

module.exports = {
  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
    var C = wrapper(function (that, iterable) {
      anInstance(that, C, CONSTRUCTOR_NAME);
      setInternalState(that, {
        type: CONSTRUCTOR_NAME,
        index: create(null),
        first: undefined,
        last: undefined,
        size: 0
      });
      if (!DESCRIPTORS) that.size = 0;
      if (iterable != undefined) iterate(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
    });

    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

    var define = function (that, key, value) {
      var state = getInternalState(that);
      var entry = getEntry(that, key);
      var previous, index;
      // change existing entry
      if (entry) {
        entry.value = value;
      // create new entry
      } else {
        state.last = entry = {
          index: index = fastKey(key, true),
          key: key,
          value: value,
          previous: previous = state.last,
          next: undefined,
          removed: false
        };
        if (!state.first) state.first = entry;
        if (previous) previous.next = entry;
        if (DESCRIPTORS) state.size++;
        else that.size++;
        // add to index
        if (index !== 'F') state.index[index] = entry;
      } return that;
    };

    var getEntry = function (that, key) {
      var state = getInternalState(that);
      // fast case
      var index = fastKey(key);
      var entry;
      if (index !== 'F') return state.index[index];
      // frozen object case
      for (entry = state.first; entry; entry = entry.next) {
        if (entry.key == key) return entry;
      }
    };

    redefineAll(C.prototype, {
      // 23.1.3.1 Map.prototype.clear()
      // 23.2.3.2 Set.prototype.clear()
      clear: function clear() {
        var that = this;
        var state = getInternalState(that);
        var data = state.index;
        var entry = state.first;
        while (entry) {
          entry.removed = true;
          if (entry.previous) entry.previous = entry.previous.next = undefined;
          delete data[entry.index];
          entry = entry.next;
        }
        state.first = state.last = undefined;
        if (DESCRIPTORS) state.size = 0;
        else that.size = 0;
      },
      // 23.1.3.3 Map.prototype.delete(key)
      // 23.2.3.4 Set.prototype.delete(value)
      'delete': function (key) {
        var that = this;
        var state = getInternalState(that);
        var entry = getEntry(that, key);
        if (entry) {
          var next = entry.next;
          var prev = entry.previous;
          delete state.index[entry.index];
          entry.removed = true;
          if (prev) prev.next = next;
          if (next) next.previous = prev;
          if (state.first == entry) state.first = next;
          if (state.last == entry) state.last = prev;
          if (DESCRIPTORS) state.size--;
          else that.size--;
        } return !!entry;
      },
      // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)
      // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)
      forEach: function forEach(callbackfn /* , that = undefined */) {
        var state = getInternalState(this);
        var boundFunction = bind(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
        var entry;
        while (entry = entry ? entry.next : state.first) {
          boundFunction(entry.value, entry.key, this);
          // revert to the last existing entry
          while (entry && entry.removed) entry = entry.previous;
        }
      },
      // 23.1.3.7 Map.prototype.has(key)
      // 23.2.3.7 Set.prototype.has(value)
      has: function has(key) {
        return !!getEntry(this, key);
      }
    });

    redefineAll(C.prototype, IS_MAP ? {
      // 23.1.3.6 Map.prototype.get(key)
      get: function get(key) {
        var entry = getEntry(this, key);
        return entry && entry.value;
      },
      // 23.1.3.9 Map.prototype.set(key, value)
      set: function set(key, value) {
        return define(this, key === 0 ? 0 : key, value);
      }
    } : {
      // 23.2.3.1 Set.prototype.add(value)
      add: function add(value) {
        return define(this, value = value === 0 ? 0 : value, value);
      }
    });
    if (DESCRIPTORS) defineProperty(C.prototype, 'size', {
      get: function () {
        return getInternalState(this).size;
      }
    });
    return C;
  },
  setStrong: function (C, CONSTRUCTOR_NAME, IS_MAP) {
    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
    var getInternalCollectionState = internalStateGetterFor(CONSTRUCTOR_NAME);
    var getInternalIteratorState = internalStateGetterFor(ITERATOR_NAME);
    // add .keys, .values, .entries, [@@iterator]
    // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11
    defineIterator(C, CONSTRUCTOR_NAME, function (iterated, kind) {
      setInternalState(this, {
        type: ITERATOR_NAME,
        target: iterated,
        state: getInternalCollectionState(iterated),
        kind: kind,
        last: undefined
      });
    }, function () {
      var state = getInternalIteratorState(this);
      var kind = state.kind;
      var entry = state.last;
      // revert to the last existing entry
      while (entry && entry.removed) entry = entry.previous;
      // get next entry
      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
        // or finish the iteration
        state.target = undefined;
        return { value: undefined, done: true };
      }
      // return step by kind
      if (kind == 'keys') return { value: entry.key, done: false };
      if (kind == 'values') return { value: entry.value, done: false };
      return { value: [entry.key, entry.value], done: false };
    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

    // add [@@species], 23.1.2.2, 23.2.2.2
    setSpecies(CONSTRUCTOR_NAME);
  }
};


/***/ }),

/***/ 29320:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var redefineAll = __webpack_require__(12248);
var getWeakData = __webpack_require__(62423).getWeakData;
var anObject = __webpack_require__(19670);
var isObject = __webpack_require__(70111);
var anInstance = __webpack_require__(25787);
var iterate = __webpack_require__(20408);
var ArrayIterationModule = __webpack_require__(42092);
var $has = __webpack_require__(86656);
var InternalStateModule = __webpack_require__(29909);

var setInternalState = InternalStateModule.set;
var internalStateGetterFor = InternalStateModule.getterFor;
var find = ArrayIterationModule.find;
var findIndex = ArrayIterationModule.findIndex;
var id = 0;

// fallback for uncaught frozen keys
var uncaughtFrozenStore = function (store) {
  return store.frozen || (store.frozen = new UncaughtFrozenStore());
};

var UncaughtFrozenStore = function () {
  this.entries = [];
};

var findUncaughtFrozen = function (store, key) {
  return find(store.entries, function (it) {
    return it[0] === key;
  });
};

UncaughtFrozenStore.prototype = {
  get: function (key) {
    var entry = findUncaughtFrozen(this, key);
    if (entry) return entry[1];
  },
  has: function (key) {
    return !!findUncaughtFrozen(this, key);
  },
  set: function (key, value) {
    var entry = findUncaughtFrozen(this, key);
    if (entry) entry[1] = value;
    else this.entries.push([key, value]);
  },
  'delete': function (key) {
    var index = findIndex(this.entries, function (it) {
      return it[0] === key;
    });
    if (~index) this.entries.splice(index, 1);
    return !!~index;
  }
};

module.exports = {
  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
    var C = wrapper(function (that, iterable) {
      anInstance(that, C, CONSTRUCTOR_NAME);
      setInternalState(that, {
        type: CONSTRUCTOR_NAME,
        id: id++,
        frozen: undefined
      });
      if (iterable != undefined) iterate(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
    });

    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

    var define = function (that, key, value) {
      var state = getInternalState(that);
      var data = getWeakData(anObject(key), true);
      if (data === true) uncaughtFrozenStore(state).set(key, value);
      else data[state.id] = value;
      return that;
    };

    redefineAll(C.prototype, {
      // 23.3.3.2 WeakMap.prototype.delete(key)
      // 23.4.3.3 WeakSet.prototype.delete(value)
      'delete': function (key) {
        var state = getInternalState(this);
        if (!isObject(key)) return false;
        var data = getWeakData(key);
        if (data === true) return uncaughtFrozenStore(state)['delete'](key);
        return data && $has(data, state.id) && delete data[state.id];
      },
      // 23.3.3.4 WeakMap.prototype.has(key)
      // 23.4.3.4 WeakSet.prototype.has(value)
      has: function has(key) {
        var state = getInternalState(this);
        if (!isObject(key)) return false;
        var data = getWeakData(key);
        if (data === true) return uncaughtFrozenStore(state).has(key);
        return data && $has(data, state.id);
      }
    });

    redefineAll(C.prototype, IS_MAP ? {
      // 23.3.3.3 WeakMap.prototype.get(key)
      get: function get(key) {
        var state = getInternalState(this);
        if (isObject(key)) {
          var data = getWeakData(key);
          if (data === true) return uncaughtFrozenStore(state).get(key);
          return data ? data[state.id] : undefined;
        }
      },
      // 23.3.3.5 WeakMap.prototype.set(key, value)
      set: function set(key, value) {
        return define(this, key, value);
      }
    } : {
      // 23.4.3.1 WeakSet.prototype.add(value)
      add: function add(value) {
        return define(this, value, true);
      }
    });

    return C;
  }
};


/***/ }),

/***/ 77710:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var global = __webpack_require__(17854);
var isForced = __webpack_require__(54705);
var redefine = __webpack_require__(31320);
var InternalMetadataModule = __webpack_require__(62423);
var iterate = __webpack_require__(20408);
var anInstance = __webpack_require__(25787);
var isObject = __webpack_require__(70111);
var fails = __webpack_require__(47293);
var checkCorrectnessOfIteration = __webpack_require__(17072);
var setToStringTag = __webpack_require__(58003);
var inheritIfRequired = __webpack_require__(79587);

module.exports = function (CONSTRUCTOR_NAME, wrapper, common) {
  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
  var ADDER = IS_MAP ? 'set' : 'add';
  var NativeConstructor = global[CONSTRUCTOR_NAME];
  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
  var Constructor = NativeConstructor;
  var exported = {};

  var fixMethod = function (KEY) {
    var nativeMethod = NativePrototype[KEY];
    redefine(NativePrototype, KEY,
      KEY == 'add' ? function add(value) {
        nativeMethod.call(this, value === 0 ? 0 : value);
        return this;
      } : KEY == 'delete' ? function (key) {
        return IS_WEAK && !isObject(key) ? false : nativeMethod.call(this, key === 0 ? 0 : key);
      } : KEY == 'get' ? function get(key) {
        return IS_WEAK && !isObject(key) ? undefined : nativeMethod.call(this, key === 0 ? 0 : key);
      } : KEY == 'has' ? function has(key) {
        return IS_WEAK && !isObject(key) ? false : nativeMethod.call(this, key === 0 ? 0 : key);
      } : function set(key, value) {
        nativeMethod.call(this, key === 0 ? 0 : key, value);
        return this;
      }
    );
  };

  var REPLACE = isForced(
    CONSTRUCTOR_NAME,
    typeof NativeConstructor != 'function' || !(IS_WEAK || NativePrototype.forEach && !fails(function () {
      new NativeConstructor().entries().next();
    }))
  );

  if (REPLACE) {
    // create collection constructor
    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
    InternalMetadataModule.REQUIRED = true;
  } else if (isForced(CONSTRUCTOR_NAME, true)) {
    var instance = new Constructor();
    // early implementations not supports chaining
    var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance;
    // V8 ~ Chromium 40- weak-collections throws on primitives, but should return false
    var THROWS_ON_PRIMITIVES = fails(function () { instance.has(1); });
    // most early implementations doesn't supports iterables, most modern - not close it correctly
    // eslint-disable-next-line no-new -- required for testing
    var ACCEPT_ITERABLES = checkCorrectnessOfIteration(function (iterable) { new NativeConstructor(iterable); });
    // for early implementations -0 and +0 not the same
    var BUGGY_ZERO = !IS_WEAK && fails(function () {
      // V8 ~ Chromium 42- fails only with 5+ elements
      var $instance = new NativeConstructor();
      var index = 5;
      while (index--) $instance[ADDER](index, index);
      return !$instance.has(-0);
    });

    if (!ACCEPT_ITERABLES) {
      Constructor = wrapper(function (dummy, iterable) {
        anInstance(dummy, Constructor, CONSTRUCTOR_NAME);
        var that = inheritIfRequired(new NativeConstructor(), dummy, Constructor);
        if (iterable != undefined) iterate(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
        return that;
      });
      Constructor.prototype = NativePrototype;
      NativePrototype.constructor = Constructor;
    }

    if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
      fixMethod('delete');
      fixMethod('has');
      IS_MAP && fixMethod('get');
    }

    if (BUGGY_ZERO || HASNT_CHAINING) fixMethod(ADDER);

    // weak collections should not contains .clear method
    if (IS_WEAK && NativePrototype.clear) delete NativePrototype.clear;
  }

  exported[CONSTRUCTOR_NAME] = Constructor;
  $({ global: true, forced: Constructor != NativeConstructor }, exported);

  setToStringTag(Constructor, CONSTRUCTOR_NAME);

  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);

  return Constructor;
};


/***/ }),

/***/ 99920:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var has = __webpack_require__(86656);
var ownKeys = __webpack_require__(53887);
var getOwnPropertyDescriptorModule = __webpack_require__(31236);
var definePropertyModule = __webpack_require__(3070);

module.exports = function (target, source) {
  var keys = ownKeys(source);
  var defineProperty = definePropertyModule.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!has(target, key)) defineProperty(target, key, getOwnPropertyDescriptor(source, key));
  }
};


/***/ }),

/***/ 84964:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var wellKnownSymbol = __webpack_require__(5112);

var MATCH = wellKnownSymbol('match');

module.exports = function (METHOD_NAME) {
  var regexp = /./;
  try {
    '/./'[METHOD_NAME](regexp);
  } catch (error1) {
    try {
      regexp[MATCH] = false;
      return '/./'[METHOD_NAME](regexp);
    } catch (error2) { /* empty */ }
  } return false;
};


/***/ }),

/***/ 49920:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(47293);

module.exports = !fails(function () {
  function F() { /* empty */ }
  F.prototype.constructor = null;
  // eslint-disable-next-line es/no-object-getprototypeof -- required for testing
  return Object.getPrototypeOf(new F()) !== F.prototype;
});


/***/ }),

/***/ 14230:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var requireObjectCoercible = __webpack_require__(84488);

var quot = /"/g;

// B.2.3.2.1 CreateHTML(string, tag, attribute, value)
// https://tc39.es/ecma262/#sec-createhtml
module.exports = function (string, tag, attribute, value) {
  var S = String(requireObjectCoercible(string));
  var p1 = '<' + tag;
  if (attribute !== '') p1 += ' ' + attribute + '="' + String(value).replace(quot, '&quot;') + '"';
  return p1 + '>' + S + '</' + tag + '>';
};


/***/ }),

/***/ 24994:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var IteratorPrototype = __webpack_require__(13383).IteratorPrototype;
var create = __webpack_require__(70030);
var createPropertyDescriptor = __webpack_require__(79114);
var setToStringTag = __webpack_require__(58003);
var Iterators = __webpack_require__(97497);

var returnThis = function () { return this; };

module.exports = function (IteratorConstructor, NAME, next) {
  var TO_STRING_TAG = NAME + ' Iterator';
  IteratorConstructor.prototype = create(IteratorPrototype, { next: createPropertyDescriptor(1, next) });
  setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
  Iterators[TO_STRING_TAG] = returnThis;
  return IteratorConstructor;
};


/***/ }),

/***/ 68880:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(19781);
var definePropertyModule = __webpack_require__(3070);
var createPropertyDescriptor = __webpack_require__(79114);

module.exports = DESCRIPTORS ? function (object, key, value) {
  return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),

/***/ 79114:
/***/ ((module) => {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),

/***/ 86135:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toPrimitive = __webpack_require__(57593);
var definePropertyModule = __webpack_require__(3070);
var createPropertyDescriptor = __webpack_require__(79114);

module.exports = function (object, key, value) {
  var propertyKey = toPrimitive(key);
  if (propertyKey in object) definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
  else object[propertyKey] = value;
};


/***/ }),

/***/ 85573:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(47293);
var padStart = __webpack_require__(76650).start;

var abs = Math.abs;
var DatePrototype = Date.prototype;
var getTime = DatePrototype.getTime;
var nativeDateToISOString = DatePrototype.toISOString;

// `Date.prototype.toISOString` method implementation
// https://tc39.es/ecma262/#sec-date.prototype.toisostring
// PhantomJS / old WebKit fails here:
module.exports = (fails(function () {
  return nativeDateToISOString.call(new Date(-5e13 - 1)) != '0385-07-25T07:06:39.999Z';
}) || !fails(function () {
  nativeDateToISOString.call(new Date(NaN));
})) ? function toISOString() {
  if (!isFinite(getTime.call(this))) throw RangeError('Invalid time value');
  var date = this;
  var year = date.getUTCFullYear();
  var milliseconds = date.getUTCMilliseconds();
  var sign = year < 0 ? '-' : year > 9999 ? '+' : '';
  return sign + padStart(abs(year), sign ? 6 : 4, 0) +
    '-' + padStart(date.getUTCMonth() + 1, 2, 0) +
    '-' + padStart(date.getUTCDate(), 2, 0) +
    'T' + padStart(date.getUTCHours(), 2, 0) +
    ':' + padStart(date.getUTCMinutes(), 2, 0) +
    ':' + padStart(date.getUTCSeconds(), 2, 0) +
    '.' + padStart(milliseconds, 3, 0) +
    'Z';
} : nativeDateToISOString;


/***/ }),

/***/ 38709:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var anObject = __webpack_require__(19670);
var toPrimitive = __webpack_require__(57593);

module.exports = function (hint) {
  if (hint !== 'string' && hint !== 'number' && hint !== 'default') {
    throw TypeError('Incorrect hint');
  } return toPrimitive(anObject(this), hint !== 'number');
};


/***/ }),

/***/ 70654:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var createIteratorConstructor = __webpack_require__(24994);
var getPrototypeOf = __webpack_require__(79518);
var setPrototypeOf = __webpack_require__(27674);
var setToStringTag = __webpack_require__(58003);
var createNonEnumerableProperty = __webpack_require__(68880);
var redefine = __webpack_require__(31320);
var wellKnownSymbol = __webpack_require__(5112);
var IS_PURE = __webpack_require__(31913);
var Iterators = __webpack_require__(97497);
var IteratorsCore = __webpack_require__(13383);

var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR = wellKnownSymbol('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var returnThis = function () { return this; };

module.exports = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  createIteratorConstructor(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
    switch (KIND) {
      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
    } return function () { return new IteratorConstructor(this); };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[ITERATOR]
    || IterablePrototype['@@iterator']
    || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY;

  // fix native
  if (anyNativeIterator) {
    CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
    if (IteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
      if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
        if (setPrototypeOf) {
          setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
        } else if (typeof CurrentIteratorPrototype[ITERATOR] != 'function') {
          createNonEnumerableProperty(CurrentIteratorPrototype, ITERATOR, returnThis);
        }
      }
      // Set @@toStringTag to native iterators
      setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
      if (IS_PURE) Iterators[TO_STRING_TAG] = returnThis;
    }
  }

  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    INCORRECT_VALUES_NAME = true;
    defaultIterator = function values() { return nativeIterator.call(this); };
  }

  // define iterator
  if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
    createNonEnumerableProperty(IterablePrototype, ITERATOR, defaultIterator);
  }
  Iterators[NAME] = defaultIterator;

  // export additional methods
  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        redefine(IterablePrototype, KEY, methods[KEY]);
      }
    } else $({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
  }

  return methods;
};


/***/ }),

/***/ 97235:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var path = __webpack_require__(40857);
var has = __webpack_require__(86656);
var wrappedWellKnownSymbolModule = __webpack_require__(6061);
var defineProperty = __webpack_require__(3070).f;

module.exports = function (NAME) {
  var Symbol = path.Symbol || (path.Symbol = {});
  if (!has(Symbol, NAME)) defineProperty(Symbol, NAME, {
    value: wrappedWellKnownSymbolModule.f(NAME)
  });
};


/***/ }),

/***/ 19781:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(47293);

// Detect IE8's incomplete defineProperty implementation
module.exports = !fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] != 7;
});


/***/ }),

/***/ 80317:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var isObject = __webpack_require__(70111);

var document = global.document;
// typeof document.createElement is 'object' in old IE
var EXISTS = isObject(document) && isObject(document.createElement);

module.exports = function (it) {
  return EXISTS ? document.createElement(it) : {};
};


/***/ }),

/***/ 48324:
/***/ ((module) => {

// iterable DOM collections
// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
module.exports = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};


/***/ }),

/***/ 7871:
/***/ ((module) => {

module.exports = typeof window == 'object';


/***/ }),

/***/ 6833:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var userAgent = __webpack_require__(88113);

module.exports = /(?:iphone|ipod|ipad).*applewebkit/i.test(userAgent);


/***/ }),

/***/ 35268:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var classof = __webpack_require__(84326);
var global = __webpack_require__(17854);

module.exports = classof(global.process) == 'process';


/***/ }),

/***/ 71036:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var userAgent = __webpack_require__(88113);

module.exports = /web0s(?!.*chrome)/i.test(userAgent);


/***/ }),

/***/ 88113:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getBuiltIn = __webpack_require__(35005);

module.exports = getBuiltIn('navigator', 'userAgent') || '';


/***/ }),

/***/ 7392:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var userAgent = __webpack_require__(88113);

var process = global.process;
var versions = process && process.versions;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  version = match[0] < 4 ? 1 : match[0] + match[1];
} else if (userAgent) {
  match = userAgent.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent.match(/Chrome\/(\d+)/);
    if (match) version = match[1];
  }
}

module.exports = version && +version;


/***/ }),

/***/ 80748:
/***/ ((module) => {

// IE8- don't enum bug keys
module.exports = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];


/***/ }),

/***/ 82109:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var getOwnPropertyDescriptor = __webpack_require__(31236).f;
var createNonEnumerableProperty = __webpack_require__(68880);
var redefine = __webpack_require__(31320);
var setGlobal = __webpack_require__(83505);
var copyConstructorProperties = __webpack_require__(99920);
var isForced = __webpack_require__(54705);

/*
  options.target      - name of the target object
  options.global      - target is the global object
  options.stat        - export as static methods of target
  options.proto       - export as prototype methods of target
  options.real        - real prototype method for the `pure` version
  options.forced      - export even if the native feature is available
  options.bind        - bind methods to the target, required for the `pure` version
  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
  options.sham        - add a flag to not completely full polyfills
  options.enumerable  - export as enumerable property
  options.noTargetGet - prevent calling a getter on target
*/
module.exports = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
  if (GLOBAL) {
    target = global;
  } else if (STATIC) {
    target = global[TARGET] || setGlobal(TARGET, {});
  } else {
    target = (global[TARGET] || {}).prototype;
  }
  if (target) for (key in source) {
    sourceProperty = source[key];
    if (options.noTargetGet) {
      descriptor = getOwnPropertyDescriptor(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contained in target
    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty === typeof targetProperty) continue;
      copyConstructorProperties(sourceProperty, targetProperty);
    }
    // add a flag to not completely full polyfills
    if (options.sham || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty(sourceProperty, 'sham', true);
    }
    // extend global
    redefine(target, key, sourceProperty, options);
  }
};


/***/ }),

/***/ 47293:
/***/ ((module) => {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};


/***/ }),

/***/ 27007:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// TODO: Remove from `core-js@4` since it's moved to entry points
__webpack_require__(74916);
var redefine = __webpack_require__(31320);
var regexpExec = __webpack_require__(22261);
var fails = __webpack_require__(47293);
var wellKnownSymbol = __webpack_require__(5112);
var createNonEnumerableProperty = __webpack_require__(68880);

var SPECIES = wellKnownSymbol('species');
var RegExpPrototype = RegExp.prototype;

var REPLACE_SUPPORTS_NAMED_GROUPS = !fails(function () {
  // #replace needs built-in support for named groups.
  // #match works fine because it just return the exec results, even if it has
  // a "grops" property.
  var re = /./;
  re.exec = function () {
    var result = [];
    result.groups = { a: '7' };
    return result;
  };
  return ''.replace(re, '$<a>') !== '7';
});

// IE <= 11 replaces $0 with the whole match, as if it was $&
// https://stackoverflow.com/questions/6024666/getting-ie-to-replace-a-regex-with-the-literal-string-0
var REPLACE_KEEPS_$0 = (function () {
  // eslint-disable-next-line regexp/prefer-escape-replacement-dollar-char -- required for testing
  return 'a'.replace(/./, '$0') === '$0';
})();

var REPLACE = wellKnownSymbol('replace');
// Safari <= 13.0.3(?) substitutes nth capture where n>m with an empty string
var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = (function () {
  if (/./[REPLACE]) {
    return /./[REPLACE]('a', '$0') === '';
  }
  return false;
})();

// Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
// Weex JS has frozen built-in prototypes, so use try / catch wrapper
var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails(function () {
  // eslint-disable-next-line regexp/no-empty-group -- required for testing
  var re = /(?:)/;
  var originalExec = re.exec;
  re.exec = function () { return originalExec.apply(this, arguments); };
  var result = 'ab'.split(re);
  return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
});

module.exports = function (KEY, length, exec, sham) {
  var SYMBOL = wellKnownSymbol(KEY);

  var DELEGATES_TO_SYMBOL = !fails(function () {
    // String methods call symbol-named RegEp methods
    var O = {};
    O[SYMBOL] = function () { return 7; };
    return ''[KEY](O) != 7;
  });

  var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails(function () {
    // Symbol-named RegExp methods call .exec
    var execCalled = false;
    var re = /a/;

    if (KEY === 'split') {
      // We can't use real regex here since it causes deoptimization
      // and serious performance degradation in V8
      // https://github.com/zloirock/core-js/issues/306
      re = {};
      // RegExp[@@split] doesn't call the regex's exec method, but first creates
      // a new one. We need to return the patched regex when creating the new one.
      re.constructor = {};
      re.constructor[SPECIES] = function () { return re; };
      re.flags = '';
      re[SYMBOL] = /./[SYMBOL];
    }

    re.exec = function () { execCalled = true; return null; };

    re[SYMBOL]('');
    return !execCalled;
  });

  if (
    !DELEGATES_TO_SYMBOL ||
    !DELEGATES_TO_EXEC ||
    (KEY === 'replace' && !(
      REPLACE_SUPPORTS_NAMED_GROUPS &&
      REPLACE_KEEPS_$0 &&
      !REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE
    )) ||
    (KEY === 'split' && !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC)
  ) {
    var nativeRegExpMethod = /./[SYMBOL];
    var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
      var $exec = regexp.exec;
      if ($exec === regexpExec || $exec === RegExpPrototype.exec) {
        if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
          // The native String method already delegates to @@method (this
          // polyfilled function), leasing to infinite recursion.
          // We avoid it by directly calling the native @@method method.
          return { done: true, value: nativeRegExpMethod.call(regexp, str, arg2) };
        }
        return { done: true, value: nativeMethod.call(str, regexp, arg2) };
      }
      return { done: false };
    }, {
      REPLACE_KEEPS_$0: REPLACE_KEEPS_$0,
      REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE: REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE
    });
    var stringMethod = methods[0];
    var regexMethod = methods[1];

    redefine(String.prototype, KEY, stringMethod);
    redefine(RegExpPrototype, SYMBOL, length == 2
      // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)
      // 21.2.5.11 RegExp.prototype[@@split](string, limit)
      ? function (string, arg) { return regexMethod.call(string, this, arg); }
      // 21.2.5.6 RegExp.prototype[@@match](string)
      // 21.2.5.9 RegExp.prototype[@@search](string)
      : function (string) { return regexMethod.call(string, this); }
    );
  }

  if (sham) createNonEnumerableProperty(RegExpPrototype[SYMBOL], 'sham', true);
};


/***/ }),

/***/ 6790:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isArray = __webpack_require__(43157);
var toLength = __webpack_require__(17466);
var bind = __webpack_require__(49974);

// `FlattenIntoArray` abstract operation
// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray
var flattenIntoArray = function (target, original, source, sourceLen, start, depth, mapper, thisArg) {
  var targetIndex = start;
  var sourceIndex = 0;
  var mapFn = mapper ? bind(mapper, thisArg, 3) : false;
  var element;

  while (sourceIndex < sourceLen) {
    if (sourceIndex in source) {
      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

      if (depth > 0 && isArray(element)) {
        targetIndex = flattenIntoArray(target, original, element, toLength(element.length), targetIndex, depth - 1) - 1;
      } else {
        if (targetIndex >= 0x1FFFFFFFFFFFFF) throw TypeError('Exceed the acceptable array length');
        target[targetIndex] = element;
      }

      targetIndex++;
    }
    sourceIndex++;
  }
  return targetIndex;
};

module.exports = flattenIntoArray;


/***/ }),

/***/ 76677:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(47293);

module.exports = !fails(function () {
  // eslint-disable-next-line es/no-object-isextensible, es/no-object-preventextensions -- required for testing
  return Object.isExtensible(Object.preventExtensions({}));
});


/***/ }),

/***/ 49974:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var aFunction = __webpack_require__(13099);

// optional / simple context binding
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 0: return function () {
      return fn.call(that);
    };
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),

/***/ 27065:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var aFunction = __webpack_require__(13099);
var isObject = __webpack_require__(70111);

var slice = [].slice;
var factories = {};

var construct = function (C, argsLength, args) {
  if (!(argsLength in factories)) {
    for (var list = [], i = 0; i < argsLength; i++) list[i] = 'a[' + i + ']';
    // eslint-disable-next-line no-new-func -- we have no proper alternatives, IE8- only
    factories[argsLength] = Function('C,a', 'return new C(' + list.join(',') + ')');
  } return factories[argsLength](C, args);
};

// `Function.prototype.bind` method implementation
// https://tc39.es/ecma262/#sec-function.prototype.bind
module.exports = Function.bind || function bind(that /* , ...args */) {
  var fn = aFunction(this);
  var partArgs = slice.call(arguments, 1);
  var boundFunction = function bound(/* args... */) {
    var args = partArgs.concat(slice.call(arguments));
    return this instanceof boundFunction ? construct(fn, args.length, args) : fn.apply(that, args);
  };
  if (isObject(fn.prototype)) boundFunction.prototype = fn.prototype;
  return boundFunction;
};


/***/ }),

/***/ 35005:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var path = __webpack_require__(40857);
var global = __webpack_require__(17854);

var aFunction = function (variable) {
  return typeof variable == 'function' ? variable : undefined;
};

module.exports = function (namespace, method) {
  return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global[namespace])
    : path[namespace] && path[namespace][method] || global[namespace] && global[namespace][method];
};


/***/ }),

/***/ 71246:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var classof = __webpack_require__(70648);
var Iterators = __webpack_require__(97497);
var wellKnownSymbol = __webpack_require__(5112);

var ITERATOR = wellKnownSymbol('iterator');

module.exports = function (it) {
  if (it != undefined) return it[ITERATOR]
    || it['@@iterator']
    || Iterators[classof(it)];
};


/***/ }),

/***/ 18554:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var anObject = __webpack_require__(19670);
var getIteratorMethod = __webpack_require__(71246);

module.exports = function (it) {
  var iteratorMethod = getIteratorMethod(it);
  if (typeof iteratorMethod != 'function') {
    throw TypeError(String(it) + ' is not iterable');
  } return anObject(iteratorMethod.call(it));
};


/***/ }),

/***/ 10647:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toObject = __webpack_require__(47908);

var floor = Math.floor;
var replace = ''.replace;
var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d{1,2}|<[^>]*>)/g;
var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d{1,2})/g;

// https://tc39.es/ecma262/#sec-getsubstitution
module.exports = function (matched, str, position, captures, namedCaptures, replacement) {
  var tailPos = position + matched.length;
  var m = captures.length;
  var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
  if (namedCaptures !== undefined) {
    namedCaptures = toObject(namedCaptures);
    symbols = SUBSTITUTION_SYMBOLS;
  }
  return replace.call(replacement, symbols, function (match, ch) {
    var capture;
    switch (ch.charAt(0)) {
      case '$': return '$';
      case '&': return matched;
      case '`': return str.slice(0, position);
      case "'": return str.slice(tailPos);
      case '<':
        capture = namedCaptures[ch.slice(1, -1)];
        break;
      default: // \d\d?
        var n = +ch;
        if (n === 0) return match;
        if (n > m) {
          var f = floor(n / 10);
          if (f === 0) return match;
          if (f <= m) return captures[f - 1] === undefined ? ch.charAt(1) : captures[f - 1] + ch.charAt(1);
          return match;
        }
        capture = captures[n - 1];
    }
    return capture === undefined ? '' : capture;
  });
};


/***/ }),

/***/ 17854:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var check = function (it) {
  return it && it.Math == Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
module.exports =
  // eslint-disable-next-line es/no-global-this -- safe
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  // eslint-disable-next-line no-restricted-globals -- safe
  check(typeof self == 'object' && self) ||
  check(typeof __webpack_require__.g == 'object' && __webpack_require__.g) ||
  // eslint-disable-next-line no-new-func -- fallback
  (function () { return this; })() || Function('return this')();


/***/ }),

/***/ 86656:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toObject = __webpack_require__(47908);

var hasOwnProperty = {}.hasOwnProperty;

module.exports = function hasOwn(it, key) {
  return hasOwnProperty.call(toObject(it), key);
};


/***/ }),

/***/ 3501:
/***/ ((module) => {

module.exports = {};


/***/ }),

/***/ 842:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);

module.exports = function (a, b) {
  var console = global.console;
  if (console && console.error) {
    arguments.length === 1 ? console.error(a) : console.error(a, b);
  }
};


/***/ }),

/***/ 60490:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getBuiltIn = __webpack_require__(35005);

module.exports = getBuiltIn('document', 'documentElement');


/***/ }),

/***/ 64664:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(19781);
var fails = __webpack_require__(47293);
var createElement = __webpack_require__(80317);

// Thank's IE8 for his funny defineProperty
module.exports = !DESCRIPTORS && !fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- requied for testing
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () { return 7; }
  }).a != 7;
});


/***/ }),

/***/ 11179:
/***/ ((module) => {

// IEEE754 conversions based on https://github.com/feross/ieee754
var abs = Math.abs;
var pow = Math.pow;
var floor = Math.floor;
var log = Math.log;
var LN2 = Math.LN2;

var pack = function (number, mantissaLength, bytes) {
  var buffer = new Array(bytes);
  var exponentLength = bytes * 8 - mantissaLength - 1;
  var eMax = (1 << exponentLength) - 1;
  var eBias = eMax >> 1;
  var rt = mantissaLength === 23 ? pow(2, -24) - pow(2, -77) : 0;
  var sign = number < 0 || number === 0 && 1 / number < 0 ? 1 : 0;
  var index = 0;
  var exponent, mantissa, c;
  number = abs(number);
  // eslint-disable-next-line no-self-compare -- NaN check
  if (number != number || number === Infinity) {
    // eslint-disable-next-line no-self-compare -- NaN check
    mantissa = number != number ? 1 : 0;
    exponent = eMax;
  } else {
    exponent = floor(log(number) / LN2);
    if (number * (c = pow(2, -exponent)) < 1) {
      exponent--;
      c *= 2;
    }
    if (exponent + eBias >= 1) {
      number += rt / c;
    } else {
      number += rt * pow(2, 1 - eBias);
    }
    if (number * c >= 2) {
      exponent++;
      c /= 2;
    }
    if (exponent + eBias >= eMax) {
      mantissa = 0;
      exponent = eMax;
    } else if (exponent + eBias >= 1) {
      mantissa = (number * c - 1) * pow(2, mantissaLength);
      exponent = exponent + eBias;
    } else {
      mantissa = number * pow(2, eBias - 1) * pow(2, mantissaLength);
      exponent = 0;
    }
  }
  for (; mantissaLength >= 8; buffer[index++] = mantissa & 255, mantissa /= 256, mantissaLength -= 8);
  exponent = exponent << mantissaLength | mantissa;
  exponentLength += mantissaLength;
  for (; exponentLength > 0; buffer[index++] = exponent & 255, exponent /= 256, exponentLength -= 8);
  buffer[--index] |= sign * 128;
  return buffer;
};

var unpack = function (buffer, mantissaLength) {
  var bytes = buffer.length;
  var exponentLength = bytes * 8 - mantissaLength - 1;
  var eMax = (1 << exponentLength) - 1;
  var eBias = eMax >> 1;
  var nBits = exponentLength - 7;
  var index = bytes - 1;
  var sign = buffer[index--];
  var exponent = sign & 127;
  var mantissa;
  sign >>= 7;
  for (; nBits > 0; exponent = exponent * 256 + buffer[index], index--, nBits -= 8);
  mantissa = exponent & (1 << -nBits) - 1;
  exponent >>= -nBits;
  nBits += mantissaLength;
  for (; nBits > 0; mantissa = mantissa * 256 + buffer[index], index--, nBits -= 8);
  if (exponent === 0) {
    exponent = 1 - eBias;
  } else if (exponent === eMax) {
    return mantissa ? NaN : sign ? -Infinity : Infinity;
  } else {
    mantissa = mantissa + pow(2, mantissaLength);
    exponent = exponent - eBias;
  } return (sign ? -1 : 1) * mantissa * pow(2, exponent - mantissaLength);
};

module.exports = {
  pack: pack,
  unpack: unpack
};


/***/ }),

/***/ 68361:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(47293);
var classof = __webpack_require__(84326);

var split = ''.split;

// fallback for non-array-like ES3 and non-enumerable old V8 strings
module.exports = fails(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof(it) == 'String' ? split.call(it, '') : Object(it);
} : Object;


/***/ }),

/***/ 79587:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(70111);
var setPrototypeOf = __webpack_require__(27674);

// makes subclassing work correct for wrapped built-ins
module.exports = function ($this, dummy, Wrapper) {
  var NewTarget, NewTargetPrototype;
  if (
    // it can work only with native `setPrototypeOf`
    setPrototypeOf &&
    // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
    typeof (NewTarget = dummy.constructor) == 'function' &&
    NewTarget !== Wrapper &&
    isObject(NewTargetPrototype = NewTarget.prototype) &&
    NewTargetPrototype !== Wrapper.prototype
  ) setPrototypeOf($this, NewTargetPrototype);
  return $this;
};


/***/ }),

/***/ 42788:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var store = __webpack_require__(5465);

var functionToString = Function.toString;

// this helper broken in `3.4.1-3.4.4`, so we can't use `shared` helper
if (typeof store.inspectSource != 'function') {
  store.inspectSource = function (it) {
    return functionToString.call(it);
  };
}

module.exports = store.inspectSource;


/***/ }),

/***/ 62423:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var hiddenKeys = __webpack_require__(3501);
var isObject = __webpack_require__(70111);
var has = __webpack_require__(86656);
var defineProperty = __webpack_require__(3070).f;
var uid = __webpack_require__(69711);
var FREEZING = __webpack_require__(76677);

var METADATA = uid('meta');
var id = 0;

// eslint-disable-next-line es/no-object-isextensible -- safe
var isExtensible = Object.isExtensible || function () {
  return true;
};

var setMetadata = function (it) {
  defineProperty(it, METADATA, { value: {
    objectID: 'O' + ++id, // object ID
    weakData: {}          // weak collections IDs
  } });
};

var fastKey = function (it, create) {
  // return a primitive with prefix
  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!has(it, METADATA)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMetadata(it);
  // return object ID
  } return it[METADATA].objectID;
};

var getWeakData = function (it, create) {
  if (!has(it, METADATA)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMetadata(it);
  // return the store of weak collections IDs
  } return it[METADATA].weakData;
};

// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZING && meta.REQUIRED && isExtensible(it) && !has(it, METADATA)) setMetadata(it);
  return it;
};

var meta = module.exports = {
  REQUIRED: false,
  fastKey: fastKey,
  getWeakData: getWeakData,
  onFreeze: onFreeze
};

hiddenKeys[METADATA] = true;


/***/ }),

/***/ 29909:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var NATIVE_WEAK_MAP = __webpack_require__(68536);
var global = __webpack_require__(17854);
var isObject = __webpack_require__(70111);
var createNonEnumerableProperty = __webpack_require__(68880);
var objectHas = __webpack_require__(86656);
var shared = __webpack_require__(5465);
var sharedKey = __webpack_require__(6200);
var hiddenKeys = __webpack_require__(3501);

var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var WeakMap = global.WeakMap;
var set, get, has;

var enforce = function (it) {
  return has(it) ? get(it) : set(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject(it) || (state = get(it)).type !== TYPE) {
      throw TypeError('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP || shared.state) {
  var store = shared.state || (shared.state = new WeakMap());
  var wmget = store.get;
  var wmhas = store.has;
  var wmset = store.set;
  set = function (it, metadata) {
    if (wmhas.call(store, it)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    wmset.call(store, it, metadata);
    return metadata;
  };
  get = function (it) {
    return wmget.call(store, it) || {};
  };
  has = function (it) {
    return wmhas.call(store, it);
  };
} else {
  var STATE = sharedKey('state');
  hiddenKeys[STATE] = true;
  set = function (it, metadata) {
    if (objectHas(it, STATE)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return objectHas(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return objectHas(it, STATE);
  };
}

module.exports = {
  set: set,
  get: get,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};


/***/ }),

/***/ 97659:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var wellKnownSymbol = __webpack_require__(5112);
var Iterators = __webpack_require__(97497);

var ITERATOR = wellKnownSymbol('iterator');
var ArrayPrototype = Array.prototype;

// check on default Array iterator
module.exports = function (it) {
  return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
};


/***/ }),

/***/ 43157:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var classof = __webpack_require__(84326);

// `IsArray` abstract operation
// https://tc39.es/ecma262/#sec-isarray
// eslint-disable-next-line es/no-array-isarray -- safe
module.exports = Array.isArray || function isArray(arg) {
  return classof(arg) == 'Array';
};


/***/ }),

/***/ 54705:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(47293);

var replacement = /#|\.prototype\./;

var isForced = function (feature, detection) {
  var value = data[normalize(feature)];
  return value == POLYFILL ? true
    : value == NATIVE ? false
    : typeof detection == 'function' ? fails(detection)
    : !!detection;
};

var normalize = isForced.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced.data = {};
var NATIVE = isForced.NATIVE = 'N';
var POLYFILL = isForced.POLYFILL = 'P';

module.exports = isForced;


/***/ }),

/***/ 18730:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(70111);

var floor = Math.floor;

// `Number.isInteger` method implementation
// https://tc39.es/ecma262/#sec-number.isinteger
module.exports = function isInteger(it) {
  return !isObject(it) && isFinite(it) && floor(it) === it;
};


/***/ }),

/***/ 70111:
/***/ ((module) => {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),

/***/ 31913:
/***/ ((module) => {

module.exports = false;


/***/ }),

/***/ 47850:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(70111);
var classof = __webpack_require__(84326);
var wellKnownSymbol = __webpack_require__(5112);

var MATCH = wellKnownSymbol('match');

// `IsRegExp` abstract operation
// https://tc39.es/ecma262/#sec-isregexp
module.exports = function (it) {
  var isRegExp;
  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : classof(it) == 'RegExp');
};


/***/ }),

/***/ 20408:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var anObject = __webpack_require__(19670);
var isArrayIteratorMethod = __webpack_require__(97659);
var toLength = __webpack_require__(17466);
var bind = __webpack_require__(49974);
var getIteratorMethod = __webpack_require__(71246);
var iteratorClose = __webpack_require__(99212);

var Result = function (stopped, result) {
  this.stopped = stopped;
  this.result = result;
};

module.exports = function (iterable, unboundFunction, options) {
  var that = options && options.that;
  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
  var INTERRUPTED = !!(options && options.INTERRUPTED);
  var fn = bind(unboundFunction, that, 1 + AS_ENTRIES + INTERRUPTED);
  var iterator, iterFn, index, length, result, next, step;

  var stop = function (condition) {
    if (iterator) iteratorClose(iterator);
    return new Result(true, condition);
  };

  var callFn = function (value) {
    if (AS_ENTRIES) {
      anObject(value);
      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
    } return INTERRUPTED ? fn(value, stop) : fn(value);
  };

  if (IS_ITERATOR) {
    iterator = iterable;
  } else {
    iterFn = getIteratorMethod(iterable);
    if (typeof iterFn != 'function') throw TypeError('Target is not iterable');
    // optimisation for array iterators
    if (isArrayIteratorMethod(iterFn)) {
      for (index = 0, length = toLength(iterable.length); length > index; index++) {
        result = callFn(iterable[index]);
        if (result && result instanceof Result) return result;
      } return new Result(false);
    }
    iterator = iterFn.call(iterable);
  }

  next = iterator.next;
  while (!(step = next.call(iterator)).done) {
    try {
      result = callFn(step.value);
    } catch (error) {
      iteratorClose(iterator);
      throw error;
    }
    if (typeof result == 'object' && result && result instanceof Result) return result;
  } return new Result(false);
};


/***/ }),

/***/ 99212:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var anObject = __webpack_require__(19670);

module.exports = function (iterator) {
  var returnMethod = iterator['return'];
  if (returnMethod !== undefined) {
    return anObject(returnMethod.call(iterator)).value;
  }
};


/***/ }),

/***/ 13383:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(47293);
var getPrototypeOf = __webpack_require__(79518);
var createNonEnumerableProperty = __webpack_require__(68880);
var has = __webpack_require__(86656);
var wellKnownSymbol = __webpack_require__(5112);
var IS_PURE = __webpack_require__(31913);

var ITERATOR = wellKnownSymbol('iterator');
var BUGGY_SAFARI_ITERATORS = false;

var returnThis = function () { return this; };

// `%IteratorPrototype%` object
// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

/* eslint-disable es/no-array-prototype-keys -- safe */
if ([].keys) {
  arrayIterator = [].keys();
  // Safari 8 has buggy iterators w/o `next`
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
  else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = IteratorPrototype == undefined || fails(function () {
  var test = {};
  // FF44- legacy iterators case
  return IteratorPrototype[ITERATOR].call(test) !== test;
});

if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype = {};

// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
if ((!IS_PURE || NEW_ITERATOR_PROTOTYPE) && !has(IteratorPrototype, ITERATOR)) {
  createNonEnumerableProperty(IteratorPrototype, ITERATOR, returnThis);
}

module.exports = {
  IteratorPrototype: IteratorPrototype,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
};


/***/ }),

/***/ 97497:
/***/ ((module) => {

module.exports = {};


/***/ }),

/***/ 66736:
/***/ ((module) => {

// eslint-disable-next-line es/no-math-expm1 -- safe
var $expm1 = Math.expm1;
var exp = Math.exp;

// `Math.expm1` method implementation
// https://tc39.es/ecma262/#sec-math.expm1
module.exports = (!$expm1
  // Old FF bug
  || $expm1(10) > 22025.465794806719 || $expm1(10) < 22025.4657948067165168
  // Tor Browser bug
  || $expm1(-2e-17) != -2e-17
) ? function expm1(x) {
  return (x = +x) == 0 ? x : x > -1e-6 && x < 1e-6 ? x + x * x / 2 : exp(x) - 1;
} : $expm1;


/***/ }),

/***/ 26130:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var sign = __webpack_require__(64310);

var abs = Math.abs;
var pow = Math.pow;
var EPSILON = pow(2, -52);
var EPSILON32 = pow(2, -23);
var MAX32 = pow(2, 127) * (2 - EPSILON32);
var MIN32 = pow(2, -126);

var roundTiesToEven = function (n) {
  return n + 1 / EPSILON - 1 / EPSILON;
};

// `Math.fround` method implementation
// https://tc39.es/ecma262/#sec-math.fround
// eslint-disable-next-line es/no-math-fround -- safe
module.exports = Math.fround || function fround(x) {
  var $abs = abs(x);
  var $sign = sign(x);
  var a, result;
  if ($abs < MIN32) return $sign * roundTiesToEven($abs / MIN32 / EPSILON32) * MIN32 * EPSILON32;
  a = (1 + EPSILON32 / EPSILON) * $abs;
  result = a - (a - $abs);
  // eslint-disable-next-line no-self-compare -- NaN check
  if (result > MAX32 || result != result) return $sign * Infinity;
  return $sign * result;
};


/***/ }),

/***/ 26513:
/***/ ((module) => {

var log = Math.log;

// `Math.log1p` method implementation
// https://tc39.es/ecma262/#sec-math.log1p
// eslint-disable-next-line es/no-math-log1p -- safe
module.exports = Math.log1p || function log1p(x) {
  return (x = +x) > -1e-8 && x < 1e-8 ? x - x * x / 2 : log(1 + x);
};


/***/ }),

/***/ 64310:
/***/ ((module) => {

// `Math.sign` method implementation
// https://tc39.es/ecma262/#sec-math.sign
// eslint-disable-next-line es/no-math-sign -- safe
module.exports = Math.sign || function sign(x) {
  // eslint-disable-next-line no-self-compare -- NaN check
  return (x = +x) == 0 || x != x ? x : x < 0 ? -1 : 1;
};


/***/ }),

/***/ 95948:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var getOwnPropertyDescriptor = __webpack_require__(31236).f;
var macrotask = __webpack_require__(20261).set;
var IS_IOS = __webpack_require__(6833);
var IS_WEBOS_WEBKIT = __webpack_require__(71036);
var IS_NODE = __webpack_require__(35268);

var MutationObserver = global.MutationObserver || global.WebKitMutationObserver;
var document = global.document;
var process = global.process;
var Promise = global.Promise;
// Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`
var queueMicrotaskDescriptor = getOwnPropertyDescriptor(global, 'queueMicrotask');
var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;

var flush, head, last, notify, toggle, node, promise, then;

// modern engines have queueMicrotask method
if (!queueMicrotask) {
  flush = function () {
    var parent, fn;
    if (IS_NODE && (parent = process.domain)) parent.exit();
    while (head) {
      fn = head.fn;
      head = head.next;
      try {
        fn();
      } catch (error) {
        if (head) notify();
        else last = undefined;
        throw error;
      }
    } last = undefined;
    if (parent) parent.enter();
  };

  // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339
  // also except WebOS Webkit https://github.com/zloirock/core-js/issues/898
  if (!IS_IOS && !IS_NODE && !IS_WEBOS_WEBKIT && MutationObserver && document) {
    toggle = true;
    node = document.createTextNode('');
    new MutationObserver(flush).observe(node, { characterData: true });
    notify = function () {
      node.data = toggle = !toggle;
    };
  // environments with maybe non-completely correct, but existent Promise
  } else if (Promise && Promise.resolve) {
    // Promise.resolve without an argument throws an error in LG WebOS 2
    promise = Promise.resolve(undefined);
    // workaround of WebKit ~ iOS Safari 10.1 bug
    promise.constructor = Promise;
    then = promise.then;
    notify = function () {
      then.call(promise, flush);
    };
  // Node.js without promises
  } else if (IS_NODE) {
    notify = function () {
      process.nextTick(flush);
    };
  // for other environments - macrotask based on:
  // - setImmediate
  // - MessageChannel
  // - window.postMessag
  // - onreadystatechange
  // - setTimeout
  } else {
    notify = function () {
      // strange IE + webpack dev server bug - use .call(global)
      macrotask.call(global, flush);
    };
  }
}

module.exports = queueMicrotask || function (fn) {
  var task = { fn: fn, next: undefined };
  if (last) last.next = task;
  if (!head) {
    head = task;
    notify();
  } last = task;
};


/***/ }),

/***/ 13366:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);

module.exports = global.Promise;


/***/ }),

/***/ 30133:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* eslint-disable es/no-symbol -- required for testing */
var V8_VERSION = __webpack_require__(7392);
var fails = __webpack_require__(47293);

// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
  return !String(Symbol()) ||
    // Chrome 38 Symbol has incorrect toString conversion
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});


/***/ }),

/***/ 590:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(47293);
var wellKnownSymbol = __webpack_require__(5112);
var IS_PURE = __webpack_require__(31913);

var ITERATOR = wellKnownSymbol('iterator');

module.exports = !fails(function () {
  var url = new URL('b?a=1&b=2&c=3', 'http://a');
  var searchParams = url.searchParams;
  var result = '';
  url.pathname = 'c%20d';
  searchParams.forEach(function (value, key) {
    searchParams['delete']('b');
    result += key + value;
  });
  return (IS_PURE && !url.toJSON)
    || !searchParams.sort
    || url.href !== 'http://a/c%20d?a=1&c=3'
    || searchParams.get('c') !== '3'
    || String(new URLSearchParams('?a=1')) !== 'a=1'
    || !searchParams[ITERATOR]
    // throws in Edge
    || new URL('https://a@b').username !== 'a'
    || new URLSearchParams(new URLSearchParams('a=b')).get('a') !== 'b'
    // not punycoded in Edge
    || new URL('http://тест').host !== 'xn--e1aybc'
    // not escaped in Chrome 62-
    || new URL('http://a#б').hash !== '#%D0%B1'
    // fails in Chrome 66-
    || result !== 'a1c3'
    // throws in Safari
    || new URL('http://x', undefined).host !== 'x';
});


/***/ }),

/***/ 68536:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var inspectSource = __webpack_require__(42788);

var WeakMap = global.WeakMap;

module.exports = typeof WeakMap === 'function' && /native code/.test(inspectSource(WeakMap));


/***/ }),

/***/ 78523:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var aFunction = __webpack_require__(13099);

var PromiseCapability = function (C) {
  var resolve, reject;
  this.promise = new C(function ($$resolve, $$reject) {
    if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
    resolve = $$resolve;
    reject = $$reject;
  });
  this.resolve = aFunction(resolve);
  this.reject = aFunction(reject);
};

// 25.4.1.5 NewPromiseCapability(C)
module.exports.f = function (C) {
  return new PromiseCapability(C);
};


/***/ }),

/***/ 3929:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isRegExp = __webpack_require__(47850);

module.exports = function (it) {
  if (isRegExp(it)) {
    throw TypeError("The method doesn't accept regular expressions");
  } return it;
};


/***/ }),

/***/ 77023:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);

var globalIsFinite = global.isFinite;

// `Number.isFinite` method
// https://tc39.es/ecma262/#sec-number.isfinite
// eslint-disable-next-line es/no-number-isfinite -- safe
module.exports = Number.isFinite || function isFinite(it) {
  return typeof it == 'number' && globalIsFinite(it);
};


/***/ }),

/***/ 2814:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var trim = __webpack_require__(53111).trim;
var whitespaces = __webpack_require__(81361);

var $parseFloat = global.parseFloat;
var FORCED = 1 / $parseFloat(whitespaces + '-0') !== -Infinity;

// `parseFloat` method
// https://tc39.es/ecma262/#sec-parsefloat-string
module.exports = FORCED ? function parseFloat(string) {
  var trimmedString = trim(String(string));
  var result = $parseFloat(trimmedString);
  return result === 0 && trimmedString.charAt(0) == '-' ? -0 : result;
} : $parseFloat;


/***/ }),

/***/ 83009:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var trim = __webpack_require__(53111).trim;
var whitespaces = __webpack_require__(81361);

var $parseInt = global.parseInt;
var hex = /^[+-]?0[Xx]/;
var FORCED = $parseInt(whitespaces + '08') !== 8 || $parseInt(whitespaces + '0x16') !== 22;

// `parseInt` method
// https://tc39.es/ecma262/#sec-parseint-string-radix
module.exports = FORCED ? function parseInt(string, radix) {
  var S = trim(String(string));
  return $parseInt(S, (radix >>> 0) || (hex.test(S) ? 16 : 10));
} : $parseInt;


/***/ }),

/***/ 21574:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(19781);
var fails = __webpack_require__(47293);
var objectKeys = __webpack_require__(81956);
var getOwnPropertySymbolsModule = __webpack_require__(25181);
var propertyIsEnumerableModule = __webpack_require__(55296);
var toObject = __webpack_require__(47908);
var IndexedObject = __webpack_require__(68361);

// eslint-disable-next-line es/no-object-assign -- safe
var $assign = Object.assign;
// eslint-disable-next-line es/no-object-defineproperty -- required for testing
var defineProperty = Object.defineProperty;

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
module.exports = !$assign || fails(function () {
  // should have correct order of operations (Edge bug)
  if (DESCRIPTORS && $assign({ b: 1 }, $assign(defineProperty({}, 'a', {
    enumerable: true,
    get: function () {
      defineProperty(this, 'b', {
        value: 3,
        enumerable: false
      });
    }
  }), { b: 2 })).b !== 1) return true;
  // should work with symbols and should have deterministic property order (V8 bug)
  var A = {};
  var B = {};
  // eslint-disable-next-line es/no-symbol -- safe
  var symbol = Symbol();
  var alphabet = 'abcdefghijklmnopqrst';
  A[symbol] = 7;
  alphabet.split('').forEach(function (chr) { B[chr] = chr; });
  return $assign({}, A)[symbol] != 7 || objectKeys($assign({}, B)).join('') != alphabet;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars -- required for `.length`
  var T = toObject(target);
  var argumentsLength = arguments.length;
  var index = 1;
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  var propertyIsEnumerable = propertyIsEnumerableModule.f;
  while (argumentsLength > index) {
    var S = IndexedObject(arguments[index++]);
    var keys = getOwnPropertySymbols ? objectKeys(S).concat(getOwnPropertySymbols(S)) : objectKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS || propertyIsEnumerable.call(S, key)) T[key] = S[key];
    }
  } return T;
} : $assign;


/***/ }),

/***/ 70030:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var anObject = __webpack_require__(19670);
var defineProperties = __webpack_require__(36048);
var enumBugKeys = __webpack_require__(80748);
var hiddenKeys = __webpack_require__(3501);
var html = __webpack_require__(60490);
var documentCreateElement = __webpack_require__(80317);
var sharedKey = __webpack_require__(6200);

var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = sharedKey('IE_PROTO');

var EmptyConstructor = function () { /* empty */ };

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};

// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  activeXDocument = null; // avoid memory leak
  return temp;
};

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html.appendChild(iframe);
  // https://github.com/zloirock/core-js/issues/475
  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
};

// Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug
var activeXDocument;
var NullProtoObject = function () {
  try {
    /* global ActiveXObject -- old IE */
    activeXDocument = document.domain && new ActiveXObject('htmlfile');
  } catch (error) { /* ignore */ }
  NullProtoObject = activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame();
  var length = enumBugKeys.length;
  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
  return NullProtoObject();
};

hiddenKeys[IE_PROTO] = true;

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    EmptyConstructor[PROTOTYPE] = anObject(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = NullProtoObject();
  return Properties === undefined ? result : defineProperties(result, Properties);
};


/***/ }),

/***/ 36048:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(19781);
var definePropertyModule = __webpack_require__(3070);
var anObject = __webpack_require__(19670);
var objectKeys = __webpack_require__(81956);

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es/no-object-defineproperties -- safe
module.exports = DESCRIPTORS ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var keys = objectKeys(Properties);
  var length = keys.length;
  var index = 0;
  var key;
  while (length > index) definePropertyModule.f(O, key = keys[index++], Properties[key]);
  return O;
};


/***/ }),

/***/ 3070:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(19781);
var IE8_DOM_DEFINE = __webpack_require__(64664);
var anObject = __webpack_require__(19670);
var toPrimitive = __webpack_require__(57593);

// eslint-disable-next-line es/no-object-defineproperty -- safe
var $defineProperty = Object.defineProperty;

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
exports.f = DESCRIPTORS ? $defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return $defineProperty(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),

/***/ 31236:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(19781);
var propertyIsEnumerableModule = __webpack_require__(55296);
var createPropertyDescriptor = __webpack_require__(79114);
var toIndexedObject = __webpack_require__(45656);
var toPrimitive = __webpack_require__(57593);
var has = __webpack_require__(86656);
var IE8_DOM_DEFINE = __webpack_require__(64664);

// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject(O);
  P = toPrimitive(P, true);
  if (IE8_DOM_DEFINE) try {
    return $getOwnPropertyDescriptor(O, P);
  } catch (error) { /* empty */ }
  if (has(O, P)) return createPropertyDescriptor(!propertyIsEnumerableModule.f.call(O, P), O[P]);
};


/***/ }),

/***/ 1156:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* eslint-disable es/no-object-getownpropertynames -- safe */
var toIndexedObject = __webpack_require__(45656);
var $getOwnPropertyNames = __webpack_require__(8006).f;

var toString = {}.toString;

var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
  ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return $getOwnPropertyNames(it);
  } catch (error) {
    return windowNames.slice();
  }
};

// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
module.exports.f = function getOwnPropertyNames(it) {
  return windowNames && toString.call(it) == '[object Window]'
    ? getWindowNames(it)
    : $getOwnPropertyNames(toIndexedObject(it));
};


/***/ }),

/***/ 8006:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var internalObjectKeys = __webpack_require__(16324);
var enumBugKeys = __webpack_require__(80748);

var hiddenKeys = enumBugKeys.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es/no-object-getownpropertynames -- safe
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys);
};


/***/ }),

/***/ 25181:
/***/ ((__unused_webpack_module, exports) => {

// eslint-disable-next-line es/no-object-getownpropertysymbols -- safe
exports.f = Object.getOwnPropertySymbols;


/***/ }),

/***/ 79518:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var has = __webpack_require__(86656);
var toObject = __webpack_require__(47908);
var sharedKey = __webpack_require__(6200);
var CORRECT_PROTOTYPE_GETTER = __webpack_require__(49920);

var IE_PROTO = sharedKey('IE_PROTO');
var ObjectPrototype = Object.prototype;

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es/no-object-getprototypeof -- safe
module.exports = CORRECT_PROTOTYPE_GETTER ? Object.getPrototypeOf : function (O) {
  O = toObject(O);
  if (has(O, IE_PROTO)) return O[IE_PROTO];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectPrototype : null;
};


/***/ }),

/***/ 16324:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var has = __webpack_require__(86656);
var toIndexedObject = __webpack_require__(45656);
var indexOf = __webpack_require__(41318).indexOf;
var hiddenKeys = __webpack_require__(3501);

module.exports = function (object, names) {
  var O = toIndexedObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !has(hiddenKeys, key) && has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~indexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),

/***/ 81956:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var internalObjectKeys = __webpack_require__(16324);
var enumBugKeys = __webpack_require__(80748);

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es/no-object-keys -- safe
module.exports = Object.keys || function keys(O) {
  return internalObjectKeys(O, enumBugKeys);
};


/***/ }),

/***/ 55296:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

var $propertyIsEnumerable = {}.propertyIsEnumerable;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;


/***/ }),

/***/ 69026:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var IS_PURE = __webpack_require__(31913);
var global = __webpack_require__(17854);
var fails = __webpack_require__(47293);

// Forced replacement object prototype accessors methods
module.exports = IS_PURE || !fails(function () {
  var key = Math.random();
  // In FF throws only define methods
  // eslint-disable-next-line no-undef, no-useless-call -- required for testing
  __defineSetter__.call(null, key, function () { /* empty */ });
  delete global[key];
});


/***/ }),

/***/ 27674:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* eslint-disable no-proto -- safe */
var anObject = __webpack_require__(19670);
var aPossiblePrototype = __webpack_require__(96077);

// `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
// Works with __proto__ only. Old v8 can't work with null proto objects.
// eslint-disable-next-line es/no-object-setprototypeof -- safe
module.exports = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;
  try {
    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
    setter = Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set;
    setter.call(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) { /* empty */ }
  return function setPrototypeOf(O, proto) {
    anObject(O);
    aPossiblePrototype(proto);
    if (CORRECT_SETTER) setter.call(O, proto);
    else O.__proto__ = proto;
    return O;
  };
}() : undefined);


/***/ }),

/***/ 44699:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(19781);
var objectKeys = __webpack_require__(81956);
var toIndexedObject = __webpack_require__(45656);
var propertyIsEnumerable = __webpack_require__(55296).f;

// `Object.{ entries, values }` methods implementation
var createMethod = function (TO_ENTRIES) {
  return function (it) {
    var O = toIndexedObject(it);
    var keys = objectKeys(O);
    var length = keys.length;
    var i = 0;
    var result = [];
    var key;
    while (length > i) {
      key = keys[i++];
      if (!DESCRIPTORS || propertyIsEnumerable.call(O, key)) {
        result.push(TO_ENTRIES ? [key, O[key]] : O[key]);
      }
    }
    return result;
  };
};

module.exports = {
  // `Object.entries` method
  // https://tc39.es/ecma262/#sec-object.entries
  entries: createMethod(true),
  // `Object.values` method
  // https://tc39.es/ecma262/#sec-object.values
  values: createMethod(false)
};


/***/ }),

/***/ 90288:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var TO_STRING_TAG_SUPPORT = __webpack_require__(51694);
var classof = __webpack_require__(70648);

// `Object.prototype.toString` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.tostring
module.exports = TO_STRING_TAG_SUPPORT ? {}.toString : function toString() {
  return '[object ' + classof(this) + ']';
};


/***/ }),

/***/ 53887:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getBuiltIn = __webpack_require__(35005);
var getOwnPropertyNamesModule = __webpack_require__(8006);
var getOwnPropertySymbolsModule = __webpack_require__(25181);
var anObject = __webpack_require__(19670);

// all object keys, includes non-enumerable and symbols
module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
};


/***/ }),

/***/ 40857:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);

module.exports = global;


/***/ }),

/***/ 12534:
/***/ ((module) => {

module.exports = function (exec) {
  try {
    return { error: false, value: exec() };
  } catch (error) {
    return { error: true, value: error };
  }
};


/***/ }),

/***/ 69478:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var anObject = __webpack_require__(19670);
var isObject = __webpack_require__(70111);
var newPromiseCapability = __webpack_require__(78523);

module.exports = function (C, x) {
  anObject(C);
  if (isObject(x) && x.constructor === C) return x;
  var promiseCapability = newPromiseCapability.f(C);
  var resolve = promiseCapability.resolve;
  resolve(x);
  return promiseCapability.promise;
};


/***/ }),

/***/ 12248:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var redefine = __webpack_require__(31320);

module.exports = function (target, src, options) {
  for (var key in src) redefine(target, key, src[key], options);
  return target;
};


/***/ }),

/***/ 31320:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var createNonEnumerableProperty = __webpack_require__(68880);
var has = __webpack_require__(86656);
var setGlobal = __webpack_require__(83505);
var inspectSource = __webpack_require__(42788);
var InternalStateModule = __webpack_require__(29909);

var getInternalState = InternalStateModule.get;
var enforceInternalState = InternalStateModule.enforce;
var TEMPLATE = String(String).split('String');

(module.exports = function (O, key, value, options) {
  var unsafe = options ? !!options.unsafe : false;
  var simple = options ? !!options.enumerable : false;
  var noTargetGet = options ? !!options.noTargetGet : false;
  var state;
  if (typeof value == 'function') {
    if (typeof key == 'string' && !has(value, 'name')) {
      createNonEnumerableProperty(value, 'name', key);
    }
    state = enforceInternalState(value);
    if (!state.source) {
      state.source = TEMPLATE.join(typeof key == 'string' ? key : '');
    }
  }
  if (O === global) {
    if (simple) O[key] = value;
    else setGlobal(key, value);
    return;
  } else if (!unsafe) {
    delete O[key];
  } else if (!noTargetGet && O[key]) {
    simple = true;
  }
  if (simple) O[key] = value;
  else createNonEnumerableProperty(O, key, value);
// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
})(Function.prototype, 'toString', function toString() {
  return typeof this == 'function' && getInternalState(this).source || inspectSource(this);
});


/***/ }),

/***/ 97651:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var classof = __webpack_require__(84326);
var regexpExec = __webpack_require__(22261);

// `RegExpExec` abstract operation
// https://tc39.es/ecma262/#sec-regexpexec
module.exports = function (R, S) {
  var exec = R.exec;
  if (typeof exec === 'function') {
    var result = exec.call(R, S);
    if (typeof result !== 'object') {
      throw TypeError('RegExp exec method returned something other than an Object or null');
    }
    return result;
  }

  if (classof(R) !== 'RegExp') {
    throw TypeError('RegExp#exec called on incompatible receiver');
  }

  return regexpExec.call(R, S);
};



/***/ }),

/***/ 22261:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-disable regexp/no-assertion-capturing-group, regexp/no-empty-group, regexp/no-lazy-ends -- testing */
/* eslint-disable regexp/no-useless-quantifier -- testing */
var regexpFlags = __webpack_require__(67066);
var stickyHelpers = __webpack_require__(52999);
var shared = __webpack_require__(72309);

var nativeExec = RegExp.prototype.exec;
var nativeReplace = shared('native-string-replace', String.prototype.replace);

var patchedExec = nativeExec;

var UPDATES_LAST_INDEX_WRONG = (function () {
  var re1 = /a/;
  var re2 = /b*/g;
  nativeExec.call(re1, 'a');
  nativeExec.call(re2, 'a');
  return re1.lastIndex !== 0 || re2.lastIndex !== 0;
})();

var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y || stickyHelpers.BROKEN_CARET;

// nonparticipating capturing group, copied from es5-shim's String#split patch.
var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;

var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y;

if (PATCH) {
  patchedExec = function exec(str) {
    var re = this;
    var lastIndex, reCopy, match, i;
    var sticky = UNSUPPORTED_Y && re.sticky;
    var flags = regexpFlags.call(re);
    var source = re.source;
    var charsAdded = 0;
    var strCopy = str;

    if (sticky) {
      flags = flags.replace('y', '');
      if (flags.indexOf('g') === -1) {
        flags += 'g';
      }

      strCopy = String(str).slice(re.lastIndex);
      // Support anchored sticky behavior.
      if (re.lastIndex > 0 && (!re.multiline || re.multiline && str[re.lastIndex - 1] !== '\n')) {
        source = '(?: ' + source + ')';
        strCopy = ' ' + strCopy;
        charsAdded++;
      }
      // ^(? + rx + ) is needed, in combination with some str slicing, to
      // simulate the 'y' flag.
      reCopy = new RegExp('^(?:' + source + ')', flags);
    }

    if (NPCG_INCLUDED) {
      reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
    }
    if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;

    match = nativeExec.call(sticky ? reCopy : re, strCopy);

    if (sticky) {
      if (match) {
        match.input = match.input.slice(charsAdded);
        match[0] = match[0].slice(charsAdded);
        match.index = re.lastIndex;
        re.lastIndex += match[0].length;
      } else re.lastIndex = 0;
    } else if (UPDATES_LAST_INDEX_WRONG && match) {
      re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
    }
    if (NPCG_INCLUDED && match && match.length > 1) {
      // Fix browsers whose `exec` methods don't consistently return `undefined`
      // for NPCG, like IE8. NOTE: This doesn' work for /(.?)?/
      nativeReplace.call(match[0], reCopy, function () {
        for (i = 1; i < arguments.length - 2; i++) {
          if (arguments[i] === undefined) match[i] = undefined;
        }
      });
    }

    return match;
  };
}

module.exports = patchedExec;


/***/ }),

/***/ 67066:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var anObject = __webpack_require__(19670);

// `RegExp.prototype.flags` getter implementation
// https://tc39.es/ecma262/#sec-get-regexp.prototype.flags
module.exports = function () {
  var that = anObject(this);
  var result = '';
  if (that.global) result += 'g';
  if (that.ignoreCase) result += 'i';
  if (that.multiline) result += 'm';
  if (that.dotAll) result += 's';
  if (that.unicode) result += 'u';
  if (that.sticky) result += 'y';
  return result;
};


/***/ }),

/***/ 52999:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var fails = __webpack_require__(47293);

// babel-minify transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError,
// so we use an intermediate function.
function RE(s, f) {
  return RegExp(s, f);
}

exports.UNSUPPORTED_Y = fails(function () {
  // babel-minify transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
  var re = RE('a', 'y');
  re.lastIndex = 2;
  return re.exec('abcd') != null;
});

exports.BROKEN_CARET = fails(function () {
  // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
  var re = RE('^r', 'gy');
  re.lastIndex = 2;
  return re.exec('str') != null;
});


/***/ }),

/***/ 84488:
/***/ ((module) => {

// `RequireObjectCoercible` abstract operation
// https://tc39.es/ecma262/#sec-requireobjectcoercible
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on " + it);
  return it;
};


/***/ }),

/***/ 81150:
/***/ ((module) => {

// `SameValue` abstract operation
// https://tc39.es/ecma262/#sec-samevalue
// eslint-disable-next-line es/no-object-is -- safe
module.exports = Object.is || function is(x, y) {
  // eslint-disable-next-line no-self-compare -- NaN check
  return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;
};


/***/ }),

/***/ 83505:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var createNonEnumerableProperty = __webpack_require__(68880);

module.exports = function (key, value) {
  try {
    createNonEnumerableProperty(global, key, value);
  } catch (error) {
    global[key] = value;
  } return value;
};


/***/ }),

/***/ 96340:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var getBuiltIn = __webpack_require__(35005);
var definePropertyModule = __webpack_require__(3070);
var wellKnownSymbol = __webpack_require__(5112);
var DESCRIPTORS = __webpack_require__(19781);

var SPECIES = wellKnownSymbol('species');

module.exports = function (CONSTRUCTOR_NAME) {
  var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
  var defineProperty = definePropertyModule.f;

  if (DESCRIPTORS && Constructor && !Constructor[SPECIES]) {
    defineProperty(Constructor, SPECIES, {
      configurable: true,
      get: function () { return this; }
    });
  }
};


/***/ }),

/***/ 58003:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var defineProperty = __webpack_require__(3070).f;
var has = __webpack_require__(86656);
var wellKnownSymbol = __webpack_require__(5112);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');

module.exports = function (it, TAG, STATIC) {
  if (it && !has(it = STATIC ? it : it.prototype, TO_STRING_TAG)) {
    defineProperty(it, TO_STRING_TAG, { configurable: true, value: TAG });
  }
};


/***/ }),

/***/ 6200:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var shared = __webpack_require__(72309);
var uid = __webpack_require__(69711);

var keys = shared('keys');

module.exports = function (key) {
  return keys[key] || (keys[key] = uid(key));
};


/***/ }),

/***/ 5465:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var setGlobal = __webpack_require__(83505);

var SHARED = '__core-js_shared__';
var store = global[SHARED] || setGlobal(SHARED, {});

module.exports = store;


/***/ }),

/***/ 72309:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var IS_PURE = __webpack_require__(31913);
var store = __webpack_require__(5465);

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.12.1',
  mode: IS_PURE ? 'pure' : 'global',
  copyright: '© 2021 Denis Pushkarev (zloirock.ru)'
});


/***/ }),

/***/ 36707:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var anObject = __webpack_require__(19670);
var aFunction = __webpack_require__(13099);
var wellKnownSymbol = __webpack_require__(5112);

var SPECIES = wellKnownSymbol('species');

// `SpeciesConstructor` abstract operation
// https://tc39.es/ecma262/#sec-speciesconstructor
module.exports = function (O, defaultConstructor) {
  var C = anObject(O).constructor;
  var S;
  return C === undefined || (S = anObject(C)[SPECIES]) == undefined ? defaultConstructor : aFunction(S);
};


/***/ }),

/***/ 43429:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(47293);

// check the existence of a method, lowercase
// of a tag and escaping quotes in arguments
module.exports = function (METHOD_NAME) {
  return fails(function () {
    var test = ''[METHOD_NAME]('"');
    return test !== test.toLowerCase() || test.split('"').length > 3;
  });
};


/***/ }),

/***/ 28710:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toInteger = __webpack_require__(99958);
var requireObjectCoercible = __webpack_require__(84488);

// `String.prototype.{ codePointAt, at }` methods implementation
var createMethod = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = String(requireObjectCoercible($this));
    var position = toInteger(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = S.charCodeAt(position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size
      || (second = S.charCodeAt(position + 1)) < 0xDC00 || second > 0xDFFF
        ? CONVERT_TO_STRING ? S.charAt(position) : first
        : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

module.exports = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod(true)
};


/***/ }),

/***/ 54986:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// https://github.com/zloirock/core-js/issues/280
var userAgent = __webpack_require__(88113);

// eslint-disable-next-line unicorn/no-unsafe-regex -- safe
module.exports = /Version\/10(?:\.\d+){1,2}(?: [\w./]+)?(?: Mobile\/\w+)? Safari\//.test(userAgent);


/***/ }),

/***/ 76650:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// https://github.com/tc39/proposal-string-pad-start-end
var toLength = __webpack_require__(17466);
var repeat = __webpack_require__(38415);
var requireObjectCoercible = __webpack_require__(84488);

var ceil = Math.ceil;

// `String.prototype.{ padStart, padEnd }` methods implementation
var createMethod = function (IS_END) {
  return function ($this, maxLength, fillString) {
    var S = String(requireObjectCoercible($this));
    var stringLength = S.length;
    var fillStr = fillString === undefined ? ' ' : String(fillString);
    var intMaxLength = toLength(maxLength);
    var fillLen, stringFiller;
    if (intMaxLength <= stringLength || fillStr == '') return S;
    fillLen = intMaxLength - stringLength;
    stringFiller = repeat.call(fillStr, ceil(fillLen / fillStr.length));
    if (stringFiller.length > fillLen) stringFiller = stringFiller.slice(0, fillLen);
    return IS_END ? S + stringFiller : stringFiller + S;
  };
};

module.exports = {
  // `String.prototype.padStart` method
  // https://tc39.es/ecma262/#sec-string.prototype.padstart
  start: createMethod(false),
  // `String.prototype.padEnd` method
  // https://tc39.es/ecma262/#sec-string.prototype.padend
  end: createMethod(true)
};


/***/ }),

/***/ 33197:
/***/ ((module) => {

"use strict";

// based on https://github.com/bestiejs/punycode.js/blob/master/punycode.js
var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1
var base = 36;
var tMin = 1;
var tMax = 26;
var skew = 38;
var damp = 700;
var initialBias = 72;
var initialN = 128; // 0x80
var delimiter = '-'; // '\x2D'
var regexNonASCII = /[^\0-\u007E]/; // non-ASCII chars
var regexSeparators = /[.\u3002\uFF0E\uFF61]/g; // RFC 3490 separators
var OVERFLOW_ERROR = 'Overflow: input needs wider integers to process';
var baseMinusTMin = base - tMin;
var floor = Math.floor;
var stringFromCharCode = String.fromCharCode;

/**
 * Creates an array containing the numeric code points of each Unicode
 * character in the string. While JavaScript uses UCS-2 internally,
 * this function will convert a pair of surrogate halves (each of which
 * UCS-2 exposes as separate characters) into a single code point,
 * matching UTF-16.
 */
var ucs2decode = function (string) {
  var output = [];
  var counter = 0;
  var length = string.length;
  while (counter < length) {
    var value = string.charCodeAt(counter++);
    if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
      // It's a high surrogate, and there is a next character.
      var extra = string.charCodeAt(counter++);
      if ((extra & 0xFC00) == 0xDC00) { // Low surrogate.
        output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
      } else {
        // It's an unmatched surrogate; only append this code unit, in case the
        // next code unit is the high surrogate of a surrogate pair.
        output.push(value);
        counter--;
      }
    } else {
      output.push(value);
    }
  }
  return output;
};

/**
 * Converts a digit/integer into a basic code point.
 */
var digitToBasic = function (digit) {
  //  0..25 map to ASCII a..z or A..Z
  // 26..35 map to ASCII 0..9
  return digit + 22 + 75 * (digit < 26);
};

/**
 * Bias adaptation function as per section 3.4 of RFC 3492.
 * https://tools.ietf.org/html/rfc3492#section-3.4
 */
var adapt = function (delta, numPoints, firstTime) {
  var k = 0;
  delta = firstTime ? floor(delta / damp) : delta >> 1;
  delta += floor(delta / numPoints);
  for (; delta > baseMinusTMin * tMax >> 1; k += base) {
    delta = floor(delta / baseMinusTMin);
  }
  return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
};

/**
 * Converts a string of Unicode symbols (e.g. a domain name label) to a
 * Punycode string of ASCII-only symbols.
 */
// eslint-disable-next-line max-statements -- TODO
var encode = function (input) {
  var output = [];

  // Convert the input in UCS-2 to an array of Unicode code points.
  input = ucs2decode(input);

  // Cache the length.
  var inputLength = input.length;

  // Initialize the state.
  var n = initialN;
  var delta = 0;
  var bias = initialBias;
  var i, currentValue;

  // Handle the basic code points.
  for (i = 0; i < input.length; i++) {
    currentValue = input[i];
    if (currentValue < 0x80) {
      output.push(stringFromCharCode(currentValue));
    }
  }

  var basicLength = output.length; // number of basic code points.
  var handledCPCount = basicLength; // number of code points that have been handled;

  // Finish the basic string with a delimiter unless it's empty.
  if (basicLength) {
    output.push(delimiter);
  }

  // Main encoding loop:
  while (handledCPCount < inputLength) {
    // All non-basic code points < n have been handled already. Find the next larger one:
    var m = maxInt;
    for (i = 0; i < input.length; i++) {
      currentValue = input[i];
      if (currentValue >= n && currentValue < m) {
        m = currentValue;
      }
    }

    // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>, but guard against overflow.
    var handledCPCountPlusOne = handledCPCount + 1;
    if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
      throw RangeError(OVERFLOW_ERROR);
    }

    delta += (m - n) * handledCPCountPlusOne;
    n = m;

    for (i = 0; i < input.length; i++) {
      currentValue = input[i];
      if (currentValue < n && ++delta > maxInt) {
        throw RangeError(OVERFLOW_ERROR);
      }
      if (currentValue == n) {
        // Represent delta as a generalized variable-length integer.
        var q = delta;
        for (var k = base; /* no condition */; k += base) {
          var t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
          if (q < t) break;
          var qMinusT = q - t;
          var baseMinusT = base - t;
          output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT)));
          q = floor(qMinusT / baseMinusT);
        }

        output.push(stringFromCharCode(digitToBasic(q)));
        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
        delta = 0;
        ++handledCPCount;
      }
    }

    ++delta;
    ++n;
  }
  return output.join('');
};

module.exports = function (input) {
  var encoded = [];
  var labels = input.toLowerCase().replace(regexSeparators, '\u002E').split('.');
  var i, label;
  for (i = 0; i < labels.length; i++) {
    label = labels[i];
    encoded.push(regexNonASCII.test(label) ? 'xn--' + encode(label) : label);
  }
  return encoded.join('.');
};


/***/ }),

/***/ 38415:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toInteger = __webpack_require__(99958);
var requireObjectCoercible = __webpack_require__(84488);

// `String.prototype.repeat` method implementation
// https://tc39.es/ecma262/#sec-string.prototype.repeat
module.exports = function repeat(count) {
  var str = String(requireObjectCoercible(this));
  var result = '';
  var n = toInteger(count);
  if (n < 0 || n == Infinity) throw RangeError('Wrong number of repetitions');
  for (;n > 0; (n >>>= 1) && (str += str)) if (n & 1) result += str;
  return result;
};


/***/ }),

/***/ 76091:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(47293);
var whitespaces = __webpack_require__(81361);

var non = '\u200B\u0085\u180E';

// check that a method works with the correct list
// of whitespaces and has a correct name
module.exports = function (METHOD_NAME) {
  return fails(function () {
    return !!whitespaces[METHOD_NAME]() || non[METHOD_NAME]() != non || whitespaces[METHOD_NAME].name !== METHOD_NAME;
  });
};


/***/ }),

/***/ 53111:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var requireObjectCoercible = __webpack_require__(84488);
var whitespaces = __webpack_require__(81361);

var whitespace = '[' + whitespaces + ']';
var ltrim = RegExp('^' + whitespace + whitespace + '*');
var rtrim = RegExp(whitespace + whitespace + '*$');

// `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
var createMethod = function (TYPE) {
  return function ($this) {
    var string = String(requireObjectCoercible($this));
    if (TYPE & 1) string = string.replace(ltrim, '');
    if (TYPE & 2) string = string.replace(rtrim, '');
    return string;
  };
};

module.exports = {
  // `String.prototype.{ trimLeft, trimStart }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
  start: createMethod(1),
  // `String.prototype.{ trimRight, trimEnd }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimend
  end: createMethod(2),
  // `String.prototype.trim` method
  // https://tc39.es/ecma262/#sec-string.prototype.trim
  trim: createMethod(3)
};


/***/ }),

/***/ 20261:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var fails = __webpack_require__(47293);
var bind = __webpack_require__(49974);
var html = __webpack_require__(60490);
var createElement = __webpack_require__(80317);
var IS_IOS = __webpack_require__(6833);
var IS_NODE = __webpack_require__(35268);

var location = global.location;
var set = global.setImmediate;
var clear = global.clearImmediate;
var process = global.process;
var MessageChannel = global.MessageChannel;
var Dispatch = global.Dispatch;
var counter = 0;
var queue = {};
var ONREADYSTATECHANGE = 'onreadystatechange';
var defer, channel, port;

var run = function (id) {
  // eslint-disable-next-line no-prototype-builtins -- safe
  if (queue.hasOwnProperty(id)) {
    var fn = queue[id];
    delete queue[id];
    fn();
  }
};

var runner = function (id) {
  return function () {
    run(id);
  };
};

var listener = function (event) {
  run(event.data);
};

var post = function (id) {
  // old engines have not location.origin
  global.postMessage(id + '', location.protocol + '//' + location.host);
};

// Node.js 0.9+ & IE10+ has setImmediate, otherwise:
if (!set || !clear) {
  set = function setImmediate(fn) {
    var args = [];
    var i = 1;
    while (arguments.length > i) args.push(arguments[i++]);
    queue[++counter] = function () {
      // eslint-disable-next-line no-new-func -- spec requirement
      (typeof fn == 'function' ? fn : Function(fn)).apply(undefined, args);
    };
    defer(counter);
    return counter;
  };
  clear = function clearImmediate(id) {
    delete queue[id];
  };
  // Node.js 0.8-
  if (IS_NODE) {
    defer = function (id) {
      process.nextTick(runner(id));
    };
  // Sphere (JS game engine) Dispatch API
  } else if (Dispatch && Dispatch.now) {
    defer = function (id) {
      Dispatch.now(runner(id));
    };
  // Browsers with MessageChannel, includes WebWorkers
  // except iOS - https://github.com/zloirock/core-js/issues/624
  } else if (MessageChannel && !IS_IOS) {
    channel = new MessageChannel();
    port = channel.port2;
    channel.port1.onmessage = listener;
    defer = bind(port.postMessage, port, 1);
  // Browsers with postMessage, skip WebWorkers
  // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
  } else if (
    global.addEventListener &&
    typeof postMessage == 'function' &&
    !global.importScripts &&
    location && location.protocol !== 'file:' &&
    !fails(post)
  ) {
    defer = post;
    global.addEventListener('message', listener, false);
  // IE8-
  } else if (ONREADYSTATECHANGE in createElement('script')) {
    defer = function (id) {
      html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
        html.removeChild(this);
        run(id);
      };
    };
  // Rest old browsers
  } else {
    defer = function (id) {
      setTimeout(runner(id), 0);
    };
  }
}

module.exports = {
  set: set,
  clear: clear
};


/***/ }),

/***/ 50863:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var classof = __webpack_require__(84326);

// `thisNumberValue` abstract operation
// https://tc39.es/ecma262/#sec-thisnumbervalue
module.exports = function (value) {
  if (typeof value != 'number' && classof(value) != 'Number') {
    throw TypeError('Incorrect invocation');
  }
  return +value;
};


/***/ }),

/***/ 51400:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toInteger = __webpack_require__(99958);

var max = Math.max;
var min = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
module.exports = function (index, length) {
  var integer = toInteger(index);
  return integer < 0 ? max(integer + length, 0) : min(integer, length);
};


/***/ }),

/***/ 57067:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toInteger = __webpack_require__(99958);
var toLength = __webpack_require__(17466);

// `ToIndex` abstract operation
// https://tc39.es/ecma262/#sec-toindex
module.exports = function (it) {
  if (it === undefined) return 0;
  var number = toInteger(it);
  var length = toLength(number);
  if (number !== length) throw RangeError('Wrong length or index');
  return length;
};


/***/ }),

/***/ 45656:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// toObject with fallback for non-array-like ES3 strings
var IndexedObject = __webpack_require__(68361);
var requireObjectCoercible = __webpack_require__(84488);

module.exports = function (it) {
  return IndexedObject(requireObjectCoercible(it));
};


/***/ }),

/***/ 99958:
/***/ ((module) => {

var ceil = Math.ceil;
var floor = Math.floor;

// `ToInteger` abstract operation
// https://tc39.es/ecma262/#sec-tointeger
module.exports = function (argument) {
  return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor : ceil)(argument);
};


/***/ }),

/***/ 17466:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toInteger = __webpack_require__(99958);

var min = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
module.exports = function (argument) {
  return argument > 0 ? min(toInteger(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};


/***/ }),

/***/ 47908:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var requireObjectCoercible = __webpack_require__(84488);

// `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject
module.exports = function (argument) {
  return Object(requireObjectCoercible(argument));
};


/***/ }),

/***/ 84590:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toPositiveInteger = __webpack_require__(73002);

module.exports = function (it, BYTES) {
  var offset = toPositiveInteger(it);
  if (offset % BYTES) throw RangeError('Wrong offset');
  return offset;
};


/***/ }),

/***/ 73002:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toInteger = __webpack_require__(99958);

module.exports = function (it) {
  var result = toInteger(it);
  if (result < 0) throw RangeError("The argument can't be less than 0");
  return result;
};


/***/ }),

/***/ 57593:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(70111);

// `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (input, PREFERRED_STRING) {
  if (!isObject(input)) return input;
  var fn, val;
  if (PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
  if (typeof (fn = input.valueOf) == 'function' && !isObject(val = fn.call(input))) return val;
  if (!PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),

/***/ 51694:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var wellKnownSymbol = __webpack_require__(5112);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var test = {};

test[TO_STRING_TAG] = 'z';

module.exports = String(test) === '[object z]';


/***/ }),

/***/ 19843:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var global = __webpack_require__(17854);
var DESCRIPTORS = __webpack_require__(19781);
var TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS = __webpack_require__(63832);
var ArrayBufferViewCore = __webpack_require__(90260);
var ArrayBufferModule = __webpack_require__(13331);
var anInstance = __webpack_require__(25787);
var createPropertyDescriptor = __webpack_require__(79114);
var createNonEnumerableProperty = __webpack_require__(68880);
var toLength = __webpack_require__(17466);
var toIndex = __webpack_require__(57067);
var toOffset = __webpack_require__(84590);
var toPrimitive = __webpack_require__(57593);
var has = __webpack_require__(86656);
var classof = __webpack_require__(70648);
var isObject = __webpack_require__(70111);
var create = __webpack_require__(70030);
var setPrototypeOf = __webpack_require__(27674);
var getOwnPropertyNames = __webpack_require__(8006).f;
var typedArrayFrom = __webpack_require__(97321);
var forEach = __webpack_require__(42092).forEach;
var setSpecies = __webpack_require__(96340);
var definePropertyModule = __webpack_require__(3070);
var getOwnPropertyDescriptorModule = __webpack_require__(31236);
var InternalStateModule = __webpack_require__(29909);
var inheritIfRequired = __webpack_require__(79587);

var getInternalState = InternalStateModule.get;
var setInternalState = InternalStateModule.set;
var nativeDefineProperty = definePropertyModule.f;
var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
var round = Math.round;
var RangeError = global.RangeError;
var ArrayBuffer = ArrayBufferModule.ArrayBuffer;
var DataView = ArrayBufferModule.DataView;
var NATIVE_ARRAY_BUFFER_VIEWS = ArrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;
var TYPED_ARRAY_TAG = ArrayBufferViewCore.TYPED_ARRAY_TAG;
var TypedArray = ArrayBufferViewCore.TypedArray;
var TypedArrayPrototype = ArrayBufferViewCore.TypedArrayPrototype;
var aTypedArrayConstructor = ArrayBufferViewCore.aTypedArrayConstructor;
var isTypedArray = ArrayBufferViewCore.isTypedArray;
var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
var WRONG_LENGTH = 'Wrong length';

var fromList = function (C, list) {
  var index = 0;
  var length = list.length;
  var result = new (aTypedArrayConstructor(C))(length);
  while (length > index) result[index] = list[index++];
  return result;
};

var addGetter = function (it, key) {
  nativeDefineProperty(it, key, { get: function () {
    return getInternalState(this)[key];
  } });
};

var isArrayBuffer = function (it) {
  var klass;
  return it instanceof ArrayBuffer || (klass = classof(it)) == 'ArrayBuffer' || klass == 'SharedArrayBuffer';
};

var isTypedArrayIndex = function (target, key) {
  return isTypedArray(target)
    && typeof key != 'symbol'
    && key in target
    && String(+key) == String(key);
};

var wrappedGetOwnPropertyDescriptor = function getOwnPropertyDescriptor(target, key) {
  return isTypedArrayIndex(target, key = toPrimitive(key, true))
    ? createPropertyDescriptor(2, target[key])
    : nativeGetOwnPropertyDescriptor(target, key);
};

var wrappedDefineProperty = function defineProperty(target, key, descriptor) {
  if (isTypedArrayIndex(target, key = toPrimitive(key, true))
    && isObject(descriptor)
    && has(descriptor, 'value')
    && !has(descriptor, 'get')
    && !has(descriptor, 'set')
    // TODO: add validation descriptor w/o calling accessors
    && !descriptor.configurable
    && (!has(descriptor, 'writable') || descriptor.writable)
    && (!has(descriptor, 'enumerable') || descriptor.enumerable)
  ) {
    target[key] = descriptor.value;
    return target;
  } return nativeDefineProperty(target, key, descriptor);
};

if (DESCRIPTORS) {
  if (!NATIVE_ARRAY_BUFFER_VIEWS) {
    getOwnPropertyDescriptorModule.f = wrappedGetOwnPropertyDescriptor;
    definePropertyModule.f = wrappedDefineProperty;
    addGetter(TypedArrayPrototype, 'buffer');
    addGetter(TypedArrayPrototype, 'byteOffset');
    addGetter(TypedArrayPrototype, 'byteLength');
    addGetter(TypedArrayPrototype, 'length');
  }

  $({ target: 'Object', stat: true, forced: !NATIVE_ARRAY_BUFFER_VIEWS }, {
    getOwnPropertyDescriptor: wrappedGetOwnPropertyDescriptor,
    defineProperty: wrappedDefineProperty
  });

  module.exports = function (TYPE, wrapper, CLAMPED) {
    var BYTES = TYPE.match(/\d+$/)[0] / 8;
    var CONSTRUCTOR_NAME = TYPE + (CLAMPED ? 'Clamped' : '') + 'Array';
    var GETTER = 'get' + TYPE;
    var SETTER = 'set' + TYPE;
    var NativeTypedArrayConstructor = global[CONSTRUCTOR_NAME];
    var TypedArrayConstructor = NativeTypedArrayConstructor;
    var TypedArrayConstructorPrototype = TypedArrayConstructor && TypedArrayConstructor.prototype;
    var exported = {};

    var getter = function (that, index) {
      var data = getInternalState(that);
      return data.view[GETTER](index * BYTES + data.byteOffset, true);
    };

    var setter = function (that, index, value) {
      var data = getInternalState(that);
      if (CLAMPED) value = (value = round(value)) < 0 ? 0 : value > 0xFF ? 0xFF : value & 0xFF;
      data.view[SETTER](index * BYTES + data.byteOffset, value, true);
    };

    var addElement = function (that, index) {
      nativeDefineProperty(that, index, {
        get: function () {
          return getter(this, index);
        },
        set: function (value) {
          return setter(this, index, value);
        },
        enumerable: true
      });
    };

    if (!NATIVE_ARRAY_BUFFER_VIEWS) {
      TypedArrayConstructor = wrapper(function (that, data, offset, $length) {
        anInstance(that, TypedArrayConstructor, CONSTRUCTOR_NAME);
        var index = 0;
        var byteOffset = 0;
        var buffer, byteLength, length;
        if (!isObject(data)) {
          length = toIndex(data);
          byteLength = length * BYTES;
          buffer = new ArrayBuffer(byteLength);
        } else if (isArrayBuffer(data)) {
          buffer = data;
          byteOffset = toOffset(offset, BYTES);
          var $len = data.byteLength;
          if ($length === undefined) {
            if ($len % BYTES) throw RangeError(WRONG_LENGTH);
            byteLength = $len - byteOffset;
            if (byteLength < 0) throw RangeError(WRONG_LENGTH);
          } else {
            byteLength = toLength($length) * BYTES;
            if (byteLength + byteOffset > $len) throw RangeError(WRONG_LENGTH);
          }
          length = byteLength / BYTES;
        } else if (isTypedArray(data)) {
          return fromList(TypedArrayConstructor, data);
        } else {
          return typedArrayFrom.call(TypedArrayConstructor, data);
        }
        setInternalState(that, {
          buffer: buffer,
          byteOffset: byteOffset,
          byteLength: byteLength,
          length: length,
          view: new DataView(buffer)
        });
        while (index < length) addElement(that, index++);
      });

      if (setPrototypeOf) setPrototypeOf(TypedArrayConstructor, TypedArray);
      TypedArrayConstructorPrototype = TypedArrayConstructor.prototype = create(TypedArrayPrototype);
    } else if (TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS) {
      TypedArrayConstructor = wrapper(function (dummy, data, typedArrayOffset, $length) {
        anInstance(dummy, TypedArrayConstructor, CONSTRUCTOR_NAME);
        return inheritIfRequired(function () {
          if (!isObject(data)) return new NativeTypedArrayConstructor(toIndex(data));
          if (isArrayBuffer(data)) return $length !== undefined
            ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES), $length)
            : typedArrayOffset !== undefined
              ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES))
              : new NativeTypedArrayConstructor(data);
          if (isTypedArray(data)) return fromList(TypedArrayConstructor, data);
          return typedArrayFrom.call(TypedArrayConstructor, data);
        }(), dummy, TypedArrayConstructor);
      });

      if (setPrototypeOf) setPrototypeOf(TypedArrayConstructor, TypedArray);
      forEach(getOwnPropertyNames(NativeTypedArrayConstructor), function (key) {
        if (!(key in TypedArrayConstructor)) {
          createNonEnumerableProperty(TypedArrayConstructor, key, NativeTypedArrayConstructor[key]);
        }
      });
      TypedArrayConstructor.prototype = TypedArrayConstructorPrototype;
    }

    if (TypedArrayConstructorPrototype.constructor !== TypedArrayConstructor) {
      createNonEnumerableProperty(TypedArrayConstructorPrototype, 'constructor', TypedArrayConstructor);
    }

    if (TYPED_ARRAY_TAG) {
      createNonEnumerableProperty(TypedArrayConstructorPrototype, TYPED_ARRAY_TAG, CONSTRUCTOR_NAME);
    }

    exported[CONSTRUCTOR_NAME] = TypedArrayConstructor;

    $({
      global: true, forced: TypedArrayConstructor != NativeTypedArrayConstructor, sham: !NATIVE_ARRAY_BUFFER_VIEWS
    }, exported);

    if (!(BYTES_PER_ELEMENT in TypedArrayConstructor)) {
      createNonEnumerableProperty(TypedArrayConstructor, BYTES_PER_ELEMENT, BYTES);
    }

    if (!(BYTES_PER_ELEMENT in TypedArrayConstructorPrototype)) {
      createNonEnumerableProperty(TypedArrayConstructorPrototype, BYTES_PER_ELEMENT, BYTES);
    }

    setSpecies(CONSTRUCTOR_NAME);
  };
} else module.exports = function () { /* empty */ };


/***/ }),

/***/ 63832:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* eslint-disable no-new -- required for testing */
var global = __webpack_require__(17854);
var fails = __webpack_require__(47293);
var checkCorrectnessOfIteration = __webpack_require__(17072);
var NATIVE_ARRAY_BUFFER_VIEWS = __webpack_require__(90260).NATIVE_ARRAY_BUFFER_VIEWS;

var ArrayBuffer = global.ArrayBuffer;
var Int8Array = global.Int8Array;

module.exports = !NATIVE_ARRAY_BUFFER_VIEWS || !fails(function () {
  Int8Array(1);
}) || !fails(function () {
  new Int8Array(-1);
}) || !checkCorrectnessOfIteration(function (iterable) {
  new Int8Array();
  new Int8Array(null);
  new Int8Array(1.5);
  new Int8Array(iterable);
}, true) || fails(function () {
  // Safari (11+) bug - a reason why even Safari 13 should load a typed array polyfill
  return new Int8Array(new ArrayBuffer(2), 1, undefined).length !== 1;
});


/***/ }),

/***/ 43074:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var aTypedArrayConstructor = __webpack_require__(90260).aTypedArrayConstructor;
var speciesConstructor = __webpack_require__(36707);

module.exports = function (instance, list) {
  var C = speciesConstructor(instance, instance.constructor);
  var index = 0;
  var length = list.length;
  var result = new (aTypedArrayConstructor(C))(length);
  while (length > index) result[index] = list[index++];
  return result;
};


/***/ }),

/***/ 97321:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toObject = __webpack_require__(47908);
var toLength = __webpack_require__(17466);
var getIteratorMethod = __webpack_require__(71246);
var isArrayIteratorMethod = __webpack_require__(97659);
var bind = __webpack_require__(49974);
var aTypedArrayConstructor = __webpack_require__(90260).aTypedArrayConstructor;

module.exports = function from(source /* , mapfn, thisArg */) {
  var O = toObject(source);
  var argumentsLength = arguments.length;
  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
  var mapping = mapfn !== undefined;
  var iteratorMethod = getIteratorMethod(O);
  var i, length, result, step, iterator, next;
  if (iteratorMethod != undefined && !isArrayIteratorMethod(iteratorMethod)) {
    iterator = iteratorMethod.call(O);
    next = iterator.next;
    O = [];
    while (!(step = next.call(iterator)).done) {
      O.push(step.value);
    }
  }
  if (mapping && argumentsLength > 2) {
    mapfn = bind(mapfn, arguments[2], 2);
  }
  length = toLength(O.length);
  result = new (aTypedArrayConstructor(this))(length);
  for (i = 0; length > i; i++) {
    result[i] = mapping ? mapfn(O[i], i) : O[i];
  }
  return result;
};


/***/ }),

/***/ 69711:
/***/ ((module) => {

var id = 0;
var postfix = Math.random();

module.exports = function (key) {
  return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
};


/***/ }),

/***/ 43307:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* eslint-disable es/no-symbol -- required for testing */
var NATIVE_SYMBOL = __webpack_require__(30133);

module.exports = NATIVE_SYMBOL
  && !Symbol.sham
  && typeof Symbol.iterator == 'symbol';


/***/ }),

/***/ 6061:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var wellKnownSymbol = __webpack_require__(5112);

exports.f = wellKnownSymbol;


/***/ }),

/***/ 5112:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var shared = __webpack_require__(72309);
var has = __webpack_require__(86656);
var uid = __webpack_require__(69711);
var NATIVE_SYMBOL = __webpack_require__(30133);
var USE_SYMBOL_AS_UID = __webpack_require__(43307);

var WellKnownSymbolsStore = shared('wks');
var Symbol = global.Symbol;
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol : Symbol && Symbol.withoutSetter || uid;

module.exports = function (name) {
  if (!has(WellKnownSymbolsStore, name) || !(NATIVE_SYMBOL || typeof WellKnownSymbolsStore[name] == 'string')) {
    if (NATIVE_SYMBOL && has(Symbol, name)) {
      WellKnownSymbolsStore[name] = Symbol[name];
    } else {
      WellKnownSymbolsStore[name] = createWellKnownSymbol('Symbol.' + name);
    }
  } return WellKnownSymbolsStore[name];
};


/***/ }),

/***/ 81361:
/***/ ((module) => {

// a string of all valid unicode whitespaces
module.exports = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
  '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';


/***/ }),

/***/ 9170:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var getPrototypeOf = __webpack_require__(79518);
var setPrototypeOf = __webpack_require__(27674);
var create = __webpack_require__(70030);
var createNonEnumerableProperty = __webpack_require__(68880);
var createPropertyDescriptor = __webpack_require__(79114);
var iterate = __webpack_require__(20408);

var $AggregateError = function AggregateError(errors, message) {
  var that = this;
  if (!(that instanceof $AggregateError)) return new $AggregateError(errors, message);
  if (setPrototypeOf) {
    // eslint-disable-next-line unicorn/error-message -- expected
    that = setPrototypeOf(new Error(undefined), getPrototypeOf(that));
  }
  if (message !== undefined) createNonEnumerableProperty(that, 'message', String(message));
  var errorsArray = [];
  iterate(errors, errorsArray.push, { that: errorsArray });
  createNonEnumerableProperty(that, 'errors', errorsArray);
  return that;
};

$AggregateError.prototype = create(Error.prototype, {
  constructor: createPropertyDescriptor(5, $AggregateError),
  message: createPropertyDescriptor(5, ''),
  name: createPropertyDescriptor(5, 'AggregateError')
});

// `AggregateError` constructor
// https://tc39.es/ecma262/#sec-aggregate-error-constructor
$({ global: true }, {
  AggregateError: $AggregateError
});


/***/ }),

/***/ 18264:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var global = __webpack_require__(17854);
var arrayBufferModule = __webpack_require__(13331);
var setSpecies = __webpack_require__(96340);

var ARRAY_BUFFER = 'ArrayBuffer';
var ArrayBuffer = arrayBufferModule[ARRAY_BUFFER];
var NativeArrayBuffer = global[ARRAY_BUFFER];

// `ArrayBuffer` constructor
// https://tc39.es/ecma262/#sec-arraybuffer-constructor
$({ global: true, forced: NativeArrayBuffer !== ArrayBuffer }, {
  ArrayBuffer: ArrayBuffer
});

setSpecies(ARRAY_BUFFER);


/***/ }),

/***/ 76938:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var ArrayBufferViewCore = __webpack_require__(90260);

var NATIVE_ARRAY_BUFFER_VIEWS = ArrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;

// `ArrayBuffer.isView` method
// https://tc39.es/ecma262/#sec-arraybuffer.isview
$({ target: 'ArrayBuffer', stat: true, forced: !NATIVE_ARRAY_BUFFER_VIEWS }, {
  isView: ArrayBufferViewCore.isView
});


/***/ }),

/***/ 39575:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var ArrayBufferModule = __webpack_require__(13331);
var anObject = __webpack_require__(19670);
var toAbsoluteIndex = __webpack_require__(51400);
var toLength = __webpack_require__(17466);
var speciesConstructor = __webpack_require__(36707);

var ArrayBuffer = ArrayBufferModule.ArrayBuffer;
var DataView = ArrayBufferModule.DataView;
var nativeArrayBufferSlice = ArrayBuffer.prototype.slice;

var INCORRECT_SLICE = fails(function () {
  return !new ArrayBuffer(2).slice(1, undefined).byteLength;
});

// `ArrayBuffer.prototype.slice` method
// https://tc39.es/ecma262/#sec-arraybuffer.prototype.slice
$({ target: 'ArrayBuffer', proto: true, unsafe: true, forced: INCORRECT_SLICE }, {
  slice: function slice(start, end) {
    if (nativeArrayBufferSlice !== undefined && end === undefined) {
      return nativeArrayBufferSlice.call(anObject(this), start); // FF fix
    }
    var length = anObject(this).byteLength;
    var first = toAbsoluteIndex(start, length);
    var fin = toAbsoluteIndex(end === undefined ? length : end, length);
    var result = new (speciesConstructor(this, ArrayBuffer))(toLength(fin - first));
    var viewSource = new DataView(this);
    var viewTarget = new DataView(result);
    var index = 0;
    while (first < fin) {
      viewTarget.setUint8(index++, viewSource.getUint8(first++));
    } return result;
  }
});


/***/ }),

/***/ 92222:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var isArray = __webpack_require__(43157);
var isObject = __webpack_require__(70111);
var toObject = __webpack_require__(47908);
var toLength = __webpack_require__(17466);
var createProperty = __webpack_require__(86135);
var arraySpeciesCreate = __webpack_require__(65417);
var arrayMethodHasSpeciesSupport = __webpack_require__(81194);
var wellKnownSymbol = __webpack_require__(5112);
var V8_VERSION = __webpack_require__(7392);

var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded';

// We can't use this feature detection in V8 since it causes
// deoptimization and serious performance degradation
// https://github.com/zloirock/core-js/issues/679
var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails(function () {
  var array = [];
  array[IS_CONCAT_SPREADABLE] = false;
  return array.concat()[0] !== array;
});

var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('concat');

var isConcatSpreadable = function (O) {
  if (!isObject(O)) return false;
  var spreadable = O[IS_CONCAT_SPREADABLE];
  return spreadable !== undefined ? !!spreadable : isArray(O);
};

var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT;

// `Array.prototype.concat` method
// https://tc39.es/ecma262/#sec-array.prototype.concat
// with adding support of @@isConcatSpreadable and @@species
$({ target: 'Array', proto: true, forced: FORCED }, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  concat: function concat(arg) {
    var O = toObject(this);
    var A = arraySpeciesCreate(O, 0);
    var n = 0;
    var i, k, length, len, E;
    for (i = -1, length = arguments.length; i < length; i++) {
      E = i === -1 ? O : arguments[i];
      if (isConcatSpreadable(E)) {
        len = toLength(E.length);
        if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
        for (k = 0; k < len; k++, n++) if (k in E) createProperty(A, n, E[k]);
      } else {
        if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
        createProperty(A, n++, E);
      }
    }
    A.length = n;
    return A;
  }
});


/***/ }),

/***/ 50545:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var copyWithin = __webpack_require__(1048);
var addToUnscopables = __webpack_require__(51223);

// `Array.prototype.copyWithin` method
// https://tc39.es/ecma262/#sec-array.prototype.copywithin
$({ target: 'Array', proto: true }, {
  copyWithin: copyWithin
});

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('copyWithin');


/***/ }),

/***/ 26541:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $every = __webpack_require__(42092).every;
var arrayMethodIsStrict = __webpack_require__(9341);

var STRICT_METHOD = arrayMethodIsStrict('every');

// `Array.prototype.every` method
// https://tc39.es/ecma262/#sec-array.prototype.every
$({ target: 'Array', proto: true, forced: !STRICT_METHOD }, {
  every: function every(callbackfn /* , thisArg */) {
    return $every(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 43290:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var fill = __webpack_require__(21285);
var addToUnscopables = __webpack_require__(51223);

// `Array.prototype.fill` method
// https://tc39.es/ecma262/#sec-array.prototype.fill
$({ target: 'Array', proto: true }, {
  fill: fill
});

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('fill');


/***/ }),

/***/ 57327:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $filter = __webpack_require__(42092).filter;
var arrayMethodHasSpeciesSupport = __webpack_require__(81194);

var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter');

// `Array.prototype.filter` method
// https://tc39.es/ecma262/#sec-array.prototype.filter
// with adding support of @@species
$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
  filter: function filter(callbackfn /* , thisArg */) {
    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 34553:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $findIndex = __webpack_require__(42092).findIndex;
var addToUnscopables = __webpack_require__(51223);

var FIND_INDEX = 'findIndex';
var SKIPS_HOLES = true;

// Shouldn't skip holes
if (FIND_INDEX in []) Array(1)[FIND_INDEX](function () { SKIPS_HOLES = false; });

// `Array.prototype.findIndex` method
// https://tc39.es/ecma262/#sec-array.prototype.findindex
$({ target: 'Array', proto: true, forced: SKIPS_HOLES }, {
  findIndex: function findIndex(callbackfn /* , that = undefined */) {
    return $findIndex(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables(FIND_INDEX);


/***/ }),

/***/ 69826:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $find = __webpack_require__(42092).find;
var addToUnscopables = __webpack_require__(51223);

var FIND = 'find';
var SKIPS_HOLES = true;

// Shouldn't skip holes
if (FIND in []) Array(1)[FIND](function () { SKIPS_HOLES = false; });

// `Array.prototype.find` method
// https://tc39.es/ecma262/#sec-array.prototype.find
$({ target: 'Array', proto: true, forced: SKIPS_HOLES }, {
  find: function find(callbackfn /* , that = undefined */) {
    return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables(FIND);


/***/ }),

/***/ 86535:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var flattenIntoArray = __webpack_require__(6790);
var toObject = __webpack_require__(47908);
var toLength = __webpack_require__(17466);
var aFunction = __webpack_require__(13099);
var arraySpeciesCreate = __webpack_require__(65417);

// `Array.prototype.flatMap` method
// https://tc39.es/ecma262/#sec-array.prototype.flatmap
$({ target: 'Array', proto: true }, {
  flatMap: function flatMap(callbackfn /* , thisArg */) {
    var O = toObject(this);
    var sourceLen = toLength(O.length);
    var A;
    aFunction(callbackfn);
    A = arraySpeciesCreate(O, 0);
    A.length = flattenIntoArray(A, O, O, sourceLen, 0, 1, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
    return A;
  }
});


/***/ }),

/***/ 84944:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var flattenIntoArray = __webpack_require__(6790);
var toObject = __webpack_require__(47908);
var toLength = __webpack_require__(17466);
var toInteger = __webpack_require__(99958);
var arraySpeciesCreate = __webpack_require__(65417);

// `Array.prototype.flat` method
// https://tc39.es/ecma262/#sec-array.prototype.flat
$({ target: 'Array', proto: true }, {
  flat: function flat(/* depthArg = 1 */) {
    var depthArg = arguments.length ? arguments[0] : undefined;
    var O = toObject(this);
    var sourceLen = toLength(O.length);
    var A = arraySpeciesCreate(O, 0);
    A.length = flattenIntoArray(A, O, O, sourceLen, 0, depthArg === undefined ? 1 : toInteger(depthArg));
    return A;
  }
});


/***/ }),

/***/ 89554:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var forEach = __webpack_require__(18533);

// `Array.prototype.forEach` method
// https://tc39.es/ecma262/#sec-array.prototype.foreach
// eslint-disable-next-line es/no-array-prototype-foreach -- safe
$({ target: 'Array', proto: true, forced: [].forEach != forEach }, {
  forEach: forEach
});


/***/ }),

/***/ 91038:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var from = __webpack_require__(48457);
var checkCorrectnessOfIteration = __webpack_require__(17072);

var INCORRECT_ITERATION = !checkCorrectnessOfIteration(function (iterable) {
  // eslint-disable-next-line es/no-array-from -- required for testing
  Array.from(iterable);
});

// `Array.from` method
// https://tc39.es/ecma262/#sec-array.from
$({ target: 'Array', stat: true, forced: INCORRECT_ITERATION }, {
  from: from
});


/***/ }),

/***/ 26699:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $includes = __webpack_require__(41318).includes;
var addToUnscopables = __webpack_require__(51223);

// `Array.prototype.includes` method
// https://tc39.es/ecma262/#sec-array.prototype.includes
$({ target: 'Array', proto: true }, {
  includes: function includes(el /* , fromIndex = 0 */) {
    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
  }
});

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('includes');


/***/ }),

/***/ 82772:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-disable es/no-array-prototype-indexof -- required for testing */
var $ = __webpack_require__(82109);
var $indexOf = __webpack_require__(41318).indexOf;
var arrayMethodIsStrict = __webpack_require__(9341);

var nativeIndexOf = [].indexOf;

var NEGATIVE_ZERO = !!nativeIndexOf && 1 / [1].indexOf(1, -0) < 0;
var STRICT_METHOD = arrayMethodIsStrict('indexOf');

// `Array.prototype.indexOf` method
// https://tc39.es/ecma262/#sec-array.prototype.indexof
$({ target: 'Array', proto: true, forced: NEGATIVE_ZERO || !STRICT_METHOD }, {
  indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {
    return NEGATIVE_ZERO
      // convert -0 to +0
      ? nativeIndexOf.apply(this, arguments) || 0
      : $indexOf(this, searchElement, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 79753:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var isArray = __webpack_require__(43157);

// `Array.isArray` method
// https://tc39.es/ecma262/#sec-array.isarray
$({ target: 'Array', stat: true }, {
  isArray: isArray
});


/***/ }),

/***/ 66992:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toIndexedObject = __webpack_require__(45656);
var addToUnscopables = __webpack_require__(51223);
var Iterators = __webpack_require__(97497);
var InternalStateModule = __webpack_require__(29909);
var defineIterator = __webpack_require__(70654);

var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);

// `Array.prototype.entries` method
// https://tc39.es/ecma262/#sec-array.prototype.entries
// `Array.prototype.keys` method
// https://tc39.es/ecma262/#sec-array.prototype.keys
// `Array.prototype.values` method
// https://tc39.es/ecma262/#sec-array.prototype.values
// `Array.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
// `CreateArrayIterator` internal method
// https://tc39.es/ecma262/#sec-createarrayiterator
module.exports = defineIterator(Array, 'Array', function (iterated, kind) {
  setInternalState(this, {
    type: ARRAY_ITERATOR,
    target: toIndexedObject(iterated), // target
    index: 0,                          // next index
    kind: kind                         // kind
  });
// `%ArrayIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
}, function () {
  var state = getInternalState(this);
  var target = state.target;
  var kind = state.kind;
  var index = state.index++;
  if (!target || index >= target.length) {
    state.target = undefined;
    return { value: undefined, done: true };
  }
  if (kind == 'keys') return { value: index, done: false };
  if (kind == 'values') return { value: target[index], done: false };
  return { value: [index, target[index]], done: false };
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values%
// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
// https://tc39.es/ecma262/#sec-createmappedargumentsobject
Iterators.Arguments = Iterators.Array;

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');


/***/ }),

/***/ 69600:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var IndexedObject = __webpack_require__(68361);
var toIndexedObject = __webpack_require__(45656);
var arrayMethodIsStrict = __webpack_require__(9341);

var nativeJoin = [].join;

var ES3_STRINGS = IndexedObject != Object;
var STRICT_METHOD = arrayMethodIsStrict('join', ',');

// `Array.prototype.join` method
// https://tc39.es/ecma262/#sec-array.prototype.join
$({ target: 'Array', proto: true, forced: ES3_STRINGS || !STRICT_METHOD }, {
  join: function join(separator) {
    return nativeJoin.call(toIndexedObject(this), separator === undefined ? ',' : separator);
  }
});


/***/ }),

/***/ 94986:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var lastIndexOf = __webpack_require__(86583);

// `Array.prototype.lastIndexOf` method
// https://tc39.es/ecma262/#sec-array.prototype.lastindexof
// eslint-disable-next-line es/no-array-prototype-lastindexof -- required for testing
$({ target: 'Array', proto: true, forced: lastIndexOf !== [].lastIndexOf }, {
  lastIndexOf: lastIndexOf
});


/***/ }),

/***/ 21249:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $map = __webpack_require__(42092).map;
var arrayMethodHasSpeciesSupport = __webpack_require__(81194);

var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('map');

// `Array.prototype.map` method
// https://tc39.es/ecma262/#sec-array.prototype.map
// with adding support of @@species
$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
  map: function map(callbackfn /* , thisArg */) {
    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 26572:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var createProperty = __webpack_require__(86135);

var ISNT_GENERIC = fails(function () {
  function F() { /* empty */ }
  // eslint-disable-next-line es/no-array-of -- required for testing
  return !(Array.of.call(F) instanceof F);
});

// `Array.of` method
// https://tc39.es/ecma262/#sec-array.of
// WebKit Array.of isn't generic
$({ target: 'Array', stat: true, forced: ISNT_GENERIC }, {
  of: function of(/* ...args */) {
    var index = 0;
    var argumentsLength = arguments.length;
    var result = new (typeof this == 'function' ? this : Array)(argumentsLength);
    while (argumentsLength > index) createProperty(result, index, arguments[index++]);
    result.length = argumentsLength;
    return result;
  }
});


/***/ }),

/***/ 96644:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $reduceRight = __webpack_require__(53671).right;
var arrayMethodIsStrict = __webpack_require__(9341);
var CHROME_VERSION = __webpack_require__(7392);
var IS_NODE = __webpack_require__(35268);

var STRICT_METHOD = arrayMethodIsStrict('reduceRight');
// Chrome 80-82 has a critical bug
// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83;

// `Array.prototype.reduceRight` method
// https://tc39.es/ecma262/#sec-array.prototype.reduceright
$({ target: 'Array', proto: true, forced: !STRICT_METHOD || CHROME_BUG }, {
  reduceRight: function reduceRight(callbackfn /* , initialValue */) {
    return $reduceRight(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 85827:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $reduce = __webpack_require__(53671).left;
var arrayMethodIsStrict = __webpack_require__(9341);
var CHROME_VERSION = __webpack_require__(7392);
var IS_NODE = __webpack_require__(35268);

var STRICT_METHOD = arrayMethodIsStrict('reduce');
// Chrome 80-82 has a critical bug
// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83;

// `Array.prototype.reduce` method
// https://tc39.es/ecma262/#sec-array.prototype.reduce
$({ target: 'Array', proto: true, forced: !STRICT_METHOD || CHROME_BUG }, {
  reduce: function reduce(callbackfn /* , initialValue */) {
    return $reduce(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 65069:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var isArray = __webpack_require__(43157);

var nativeReverse = [].reverse;
var test = [1, 2];

// `Array.prototype.reverse` method
// https://tc39.es/ecma262/#sec-array.prototype.reverse
// fix for Safari 12.0 bug
// https://bugs.webkit.org/show_bug.cgi?id=188794
$({ target: 'Array', proto: true, forced: String(test) === String(test.reverse()) }, {
  reverse: function reverse() {
    // eslint-disable-next-line no-self-assign -- dirty hack
    if (isArray(this)) this.length = this.length;
    return nativeReverse.call(this);
  }
});


/***/ }),

/***/ 47042:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var isObject = __webpack_require__(70111);
var isArray = __webpack_require__(43157);
var toAbsoluteIndex = __webpack_require__(51400);
var toLength = __webpack_require__(17466);
var toIndexedObject = __webpack_require__(45656);
var createProperty = __webpack_require__(86135);
var wellKnownSymbol = __webpack_require__(5112);
var arrayMethodHasSpeciesSupport = __webpack_require__(81194);

var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('slice');

var SPECIES = wellKnownSymbol('species');
var nativeSlice = [].slice;
var max = Math.max;

// `Array.prototype.slice` method
// https://tc39.es/ecma262/#sec-array.prototype.slice
// fallback for not array-like ES3 strings and DOM objects
$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
  slice: function slice(start, end) {
    var O = toIndexedObject(this);
    var length = toLength(O.length);
    var k = toAbsoluteIndex(start, length);
    var fin = toAbsoluteIndex(end === undefined ? length : end, length);
    // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible
    var Constructor, result, n;
    if (isArray(O)) {
      Constructor = O.constructor;
      // cross-realm fallback
      if (typeof Constructor == 'function' && (Constructor === Array || isArray(Constructor.prototype))) {
        Constructor = undefined;
      } else if (isObject(Constructor)) {
        Constructor = Constructor[SPECIES];
        if (Constructor === null) Constructor = undefined;
      }
      if (Constructor === Array || Constructor === undefined) {
        return nativeSlice.call(O, k, fin);
      }
    }
    result = new (Constructor === undefined ? Array : Constructor)(max(fin - k, 0));
    for (n = 0; k < fin; k++, n++) if (k in O) createProperty(result, n, O[k]);
    result.length = n;
    return result;
  }
});


/***/ }),

/***/ 5212:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $some = __webpack_require__(42092).some;
var arrayMethodIsStrict = __webpack_require__(9341);

var STRICT_METHOD = arrayMethodIsStrict('some');

// `Array.prototype.some` method
// https://tc39.es/ecma262/#sec-array.prototype.some
$({ target: 'Array', proto: true, forced: !STRICT_METHOD }, {
  some: function some(callbackfn /* , thisArg */) {
    return $some(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 2707:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var aFunction = __webpack_require__(13099);
var toObject = __webpack_require__(47908);
var fails = __webpack_require__(47293);
var arrayMethodIsStrict = __webpack_require__(9341);

var test = [];
var nativeSort = test.sort;

// IE8-
var FAILS_ON_UNDEFINED = fails(function () {
  test.sort(undefined);
});
// V8 bug
var FAILS_ON_NULL = fails(function () {
  test.sort(null);
});
// Old WebKit
var STRICT_METHOD = arrayMethodIsStrict('sort');

var FORCED = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD;

// `Array.prototype.sort` method
// https://tc39.es/ecma262/#sec-array.prototype.sort
$({ target: 'Array', proto: true, forced: FORCED }, {
  sort: function sort(comparefn) {
    return comparefn === undefined
      ? nativeSort.call(toObject(this))
      : nativeSort.call(toObject(this), aFunction(comparefn));
  }
});


/***/ }),

/***/ 38706:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var setSpecies = __webpack_require__(96340);

// `Array[@@species]` getter
// https://tc39.es/ecma262/#sec-get-array-@@species
setSpecies('Array');


/***/ }),

/***/ 40561:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var toAbsoluteIndex = __webpack_require__(51400);
var toInteger = __webpack_require__(99958);
var toLength = __webpack_require__(17466);
var toObject = __webpack_require__(47908);
var arraySpeciesCreate = __webpack_require__(65417);
var createProperty = __webpack_require__(86135);
var arrayMethodHasSpeciesSupport = __webpack_require__(81194);

var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('splice');

var max = Math.max;
var min = Math.min;
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
var MAXIMUM_ALLOWED_LENGTH_EXCEEDED = 'Maximum allowed length exceeded';

// `Array.prototype.splice` method
// https://tc39.es/ecma262/#sec-array.prototype.splice
// with adding support of @@species
$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
  splice: function splice(start, deleteCount /* , ...items */) {
    var O = toObject(this);
    var len = toLength(O.length);
    var actualStart = toAbsoluteIndex(start, len);
    var argumentsLength = arguments.length;
    var insertCount, actualDeleteCount, A, k, from, to;
    if (argumentsLength === 0) {
      insertCount = actualDeleteCount = 0;
    } else if (argumentsLength === 1) {
      insertCount = 0;
      actualDeleteCount = len - actualStart;
    } else {
      insertCount = argumentsLength - 2;
      actualDeleteCount = min(max(toInteger(deleteCount), 0), len - actualStart);
    }
    if (len + insertCount - actualDeleteCount > MAX_SAFE_INTEGER) {
      throw TypeError(MAXIMUM_ALLOWED_LENGTH_EXCEEDED);
    }
    A = arraySpeciesCreate(O, actualDeleteCount);
    for (k = 0; k < actualDeleteCount; k++) {
      from = actualStart + k;
      if (from in O) createProperty(A, k, O[from]);
    }
    A.length = actualDeleteCount;
    if (insertCount < actualDeleteCount) {
      for (k = actualStart; k < len - actualDeleteCount; k++) {
        from = k + actualDeleteCount;
        to = k + insertCount;
        if (from in O) O[to] = O[from];
        else delete O[to];
      }
      for (k = len; k > len - actualDeleteCount + insertCount; k--) delete O[k - 1];
    } else if (insertCount > actualDeleteCount) {
      for (k = len - actualDeleteCount; k > actualStart; k--) {
        from = k + actualDeleteCount - 1;
        to = k + insertCount - 1;
        if (from in O) O[to] = O[from];
        else delete O[to];
      }
    }
    for (k = 0; k < insertCount; k++) {
      O[k + actualStart] = arguments[k + 2];
    }
    O.length = len - actualDeleteCount + insertCount;
    return A;
  }
});


/***/ }),

/***/ 99244:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// this method was added to unscopables after implementation
// in popular engines, so it's moved to a separate module
var addToUnscopables = __webpack_require__(51223);

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('flatMap');


/***/ }),

/***/ 33792:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// this method was added to unscopables after implementation
// in popular engines, so it's moved to a separate module
var addToUnscopables = __webpack_require__(51223);

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('flat');


/***/ }),

/***/ 16716:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var ArrayBufferModule = __webpack_require__(13331);
var NATIVE_ARRAY_BUFFER = __webpack_require__(24019);

// `DataView` constructor
// https://tc39.es/ecma262/#sec-dataview-constructor
$({ global: true, forced: !NATIVE_ARRAY_BUFFER }, {
  DataView: ArrayBufferModule.DataView
});


/***/ }),

/***/ 3843:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

// `Date.now` method
// https://tc39.es/ecma262/#sec-date.now
$({ target: 'Date', stat: true }, {
  now: function now() {
    return new Date().getTime();
  }
});


/***/ }),

/***/ 28733:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var toISOString = __webpack_require__(85573);

// `Date.prototype.toISOString` method
// https://tc39.es/ecma262/#sec-date.prototype.toisostring
// PhantomJS / old WebKit has a broken implementations
$({ target: 'Date', proto: true, forced: Date.prototype.toISOString !== toISOString }, {
  toISOString: toISOString
});


/***/ }),

/***/ 5735:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var toObject = __webpack_require__(47908);
var toPrimitive = __webpack_require__(57593);

var FORCED = fails(function () {
  return new Date(NaN).toJSON() !== null
    || Date.prototype.toJSON.call({ toISOString: function () { return 1; } }) !== 1;
});

// `Date.prototype.toJSON` method
// https://tc39.es/ecma262/#sec-date.prototype.tojson
$({ target: 'Date', proto: true, forced: FORCED }, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  toJSON: function toJSON(key) {
    var O = toObject(this);
    var pv = toPrimitive(O);
    return typeof pv == 'number' && !isFinite(pv) ? null : O.toISOString();
  }
});


/***/ }),

/***/ 96078:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var createNonEnumerableProperty = __webpack_require__(68880);
var dateToPrimitive = __webpack_require__(38709);
var wellKnownSymbol = __webpack_require__(5112);

var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
var DatePrototype = Date.prototype;

// `Date.prototype[@@toPrimitive]` method
// https://tc39.es/ecma262/#sec-date.prototype-@@toprimitive
if (!(TO_PRIMITIVE in DatePrototype)) {
  createNonEnumerableProperty(DatePrototype, TO_PRIMITIVE, dateToPrimitive);
}


/***/ }),

/***/ 83710:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var redefine = __webpack_require__(31320);

var DatePrototype = Date.prototype;
var INVALID_DATE = 'Invalid Date';
var TO_STRING = 'toString';
var nativeDateToString = DatePrototype[TO_STRING];
var getTime = DatePrototype.getTime;

// `Date.prototype.toString` method
// https://tc39.es/ecma262/#sec-date.prototype.tostring
if (new Date(NaN) + '' != INVALID_DATE) {
  redefine(DatePrototype, TO_STRING, function toString() {
    var value = getTime.call(this);
    // eslint-disable-next-line no-self-compare -- NaN check
    return value === value ? nativeDateToString.call(this) : INVALID_DATE;
  });
}


/***/ }),

/***/ 24812:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var bind = __webpack_require__(27065);

// `Function.prototype.bind` method
// https://tc39.es/ecma262/#sec-function.prototype.bind
$({ target: 'Function', proto: true }, {
  bind: bind
});


/***/ }),

/***/ 4855:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isObject = __webpack_require__(70111);
var definePropertyModule = __webpack_require__(3070);
var getPrototypeOf = __webpack_require__(79518);
var wellKnownSymbol = __webpack_require__(5112);

var HAS_INSTANCE = wellKnownSymbol('hasInstance');
var FunctionPrototype = Function.prototype;

// `Function.prototype[@@hasInstance]` method
// https://tc39.es/ecma262/#sec-function.prototype-@@hasinstance
if (!(HAS_INSTANCE in FunctionPrototype)) {
  definePropertyModule.f(FunctionPrototype, HAS_INSTANCE, { value: function (O) {
    if (typeof this != 'function' || !isObject(O)) return false;
    if (!isObject(this.prototype)) return O instanceof this;
    // for environment w/o native `@@hasInstance` logic enough `instanceof`, but add this:
    while (O = getPrototypeOf(O)) if (this.prototype === O) return true;
    return false;
  } });
}


/***/ }),

/***/ 68309:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(19781);
var defineProperty = __webpack_require__(3070).f;

var FunctionPrototype = Function.prototype;
var FunctionPrototypeToString = FunctionPrototype.toString;
var nameRE = /^\s*function ([^ (]*)/;
var NAME = 'name';

// Function instances `.name` property
// https://tc39.es/ecma262/#sec-function-instances-name
if (DESCRIPTORS && !(NAME in FunctionPrototype)) {
  defineProperty(FunctionPrototype, NAME, {
    configurable: true,
    get: function () {
      try {
        return FunctionPrototypeToString.call(this).match(nameRE)[1];
      } catch (error) {
        return '';
      }
    }
  });
}


/***/ }),

/***/ 35837:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var global = __webpack_require__(17854);

// `globalThis` object
// https://tc39.es/ecma262/#sec-globalthis
$({ global: true }, {
  globalThis: global
});


/***/ }),

/***/ 38862:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var getBuiltIn = __webpack_require__(35005);
var fails = __webpack_require__(47293);

var $stringify = getBuiltIn('JSON', 'stringify');
var re = /[\uD800-\uDFFF]/g;
var low = /^[\uD800-\uDBFF]$/;
var hi = /^[\uDC00-\uDFFF]$/;

var fix = function (match, offset, string) {
  var prev = string.charAt(offset - 1);
  var next = string.charAt(offset + 1);
  if ((low.test(match) && !hi.test(next)) || (hi.test(match) && !low.test(prev))) {
    return '\\u' + match.charCodeAt(0).toString(16);
  } return match;
};

var FORCED = fails(function () {
  return $stringify('\uDF06\uD834') !== '"\\udf06\\ud834"'
    || $stringify('\uDEAD') !== '"\\udead"';
});

if ($stringify) {
  // `JSON.stringify` method
  // https://tc39.es/ecma262/#sec-json.stringify
  // https://github.com/tc39/proposal-well-formed-stringify
  $({ target: 'JSON', stat: true, forced: FORCED }, {
    // eslint-disable-next-line no-unused-vars -- required for `.length`
    stringify: function stringify(it, replacer, space) {
      var result = $stringify.apply(null, arguments);
      return typeof result == 'string' ? result.replace(re, fix) : result;
    }
  });
}


/***/ }),

/***/ 73706:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(17854);
var setToStringTag = __webpack_require__(58003);

// JSON[@@toStringTag] property
// https://tc39.es/ecma262/#sec-json-@@tostringtag
setToStringTag(global.JSON, 'JSON', true);


/***/ }),

/***/ 51532:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var collection = __webpack_require__(77710);
var collectionStrong = __webpack_require__(95631);

// `Map` constructor
// https://tc39.es/ecma262/#sec-map-objects
module.exports = collection('Map', function (init) {
  return function Map() { return init(this, arguments.length ? arguments[0] : undefined); };
}, collectionStrong);


/***/ }),

/***/ 99752:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var log1p = __webpack_require__(26513);

// eslint-disable-next-line es/no-math-acosh -- required for testing
var $acosh = Math.acosh;
var log = Math.log;
var sqrt = Math.sqrt;
var LN2 = Math.LN2;

var FORCED = !$acosh
  // V8 bug: https://code.google.com/p/v8/issues/detail?id=3509
  || Math.floor($acosh(Number.MAX_VALUE)) != 710
  // Tor Browser bug: Math.acosh(Infinity) -> NaN
  || $acosh(Infinity) != Infinity;

// `Math.acosh` method
// https://tc39.es/ecma262/#sec-math.acosh
$({ target: 'Math', stat: true, forced: FORCED }, {
  acosh: function acosh(x) {
    return (x = +x) < 1 ? NaN : x > 94906265.62425156
      ? log(x) + LN2
      : log1p(x - 1 + sqrt(x - 1) * sqrt(x + 1));
  }
});


/***/ }),

/***/ 82376:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

// eslint-disable-next-line es/no-math-asinh -- required for testing
var $asinh = Math.asinh;
var log = Math.log;
var sqrt = Math.sqrt;

function asinh(x) {
  return !isFinite(x = +x) || x == 0 ? x : x < 0 ? -asinh(-x) : log(x + sqrt(x * x + 1));
}

// `Math.asinh` method
// https://tc39.es/ecma262/#sec-math.asinh
// Tor Browser bug: Math.asinh(0) -> -0
$({ target: 'Math', stat: true, forced: !($asinh && 1 / $asinh(0) > 0) }, {
  asinh: asinh
});


/***/ }),

/***/ 73181:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

// eslint-disable-next-line es/no-math-atanh -- required for testing
var $atanh = Math.atanh;
var log = Math.log;

// `Math.atanh` method
// https://tc39.es/ecma262/#sec-math.atanh
// Tor Browser bug: Math.atanh(-0) -> 0
$({ target: 'Math', stat: true, forced: !($atanh && 1 / $atanh(-0) < 0) }, {
  atanh: function atanh(x) {
    return (x = +x) == 0 ? x : log((1 + x) / (1 - x)) / 2;
  }
});


/***/ }),

/***/ 23484:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var sign = __webpack_require__(64310);

var abs = Math.abs;
var pow = Math.pow;

// `Math.cbrt` method
// https://tc39.es/ecma262/#sec-math.cbrt
$({ target: 'Math', stat: true }, {
  cbrt: function cbrt(x) {
    return sign(x = +x) * pow(abs(x), 1 / 3);
  }
});


/***/ }),

/***/ 2388:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

var floor = Math.floor;
var log = Math.log;
var LOG2E = Math.LOG2E;

// `Math.clz32` method
// https://tc39.es/ecma262/#sec-math.clz32
$({ target: 'Math', stat: true }, {
  clz32: function clz32(x) {
    return (x >>>= 0) ? 31 - floor(log(x + 0.5) * LOG2E) : 32;
  }
});


/***/ }),

/***/ 88621:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var expm1 = __webpack_require__(66736);

// eslint-disable-next-line es/no-math-cosh -- required for testing
var $cosh = Math.cosh;
var abs = Math.abs;
var E = Math.E;

// `Math.cosh` method
// https://tc39.es/ecma262/#sec-math.cosh
$({ target: 'Math', stat: true, forced: !$cosh || $cosh(710) === Infinity }, {
  cosh: function cosh(x) {
    var t = expm1(abs(x) - 1) + 1;
    return (t + 1 / (t * E * E)) * (E / 2);
  }
});


/***/ }),

/***/ 60403:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var expm1 = __webpack_require__(66736);

// `Math.expm1` method
// https://tc39.es/ecma262/#sec-math.expm1
// eslint-disable-next-line es/no-math-expm1 -- required for testing
$({ target: 'Math', stat: true, forced: expm1 != Math.expm1 }, { expm1: expm1 });


/***/ }),

/***/ 84755:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var fround = __webpack_require__(26130);

// `Math.fround` method
// https://tc39.es/ecma262/#sec-math.fround
$({ target: 'Math', stat: true }, { fround: fround });


/***/ }),

/***/ 25438:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

// eslint-disable-next-line es/no-math-hypot -- required for testing
var $hypot = Math.hypot;
var abs = Math.abs;
var sqrt = Math.sqrt;

// Chrome 77 bug
// https://bugs.chromium.org/p/v8/issues/detail?id=9546
var BUGGY = !!$hypot && $hypot(Infinity, NaN) !== Infinity;

// `Math.hypot` method
// https://tc39.es/ecma262/#sec-math.hypot
$({ target: 'Math', stat: true, forced: BUGGY }, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  hypot: function hypot(value1, value2) {
    var sum = 0;
    var i = 0;
    var aLen = arguments.length;
    var larg = 0;
    var arg, div;
    while (i < aLen) {
      arg = abs(arguments[i++]);
      if (larg < arg) {
        div = larg / arg;
        sum = sum * div * div + 1;
        larg = arg;
      } else if (arg > 0) {
        div = arg / larg;
        sum += div * div;
      } else sum += arg;
    }
    return larg === Infinity ? Infinity : larg * sqrt(sum);
  }
});


/***/ }),

/***/ 90332:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);

// eslint-disable-next-line es/no-math-imul -- required for testing
var $imul = Math.imul;

var FORCED = fails(function () {
  return $imul(0xFFFFFFFF, 5) != -5 || $imul.length != 2;
});

// `Math.imul` method
// https://tc39.es/ecma262/#sec-math.imul
// some WebKit versions fails with big numbers, some has wrong arity
$({ target: 'Math', stat: true, forced: FORCED }, {
  imul: function imul(x, y) {
    var UINT16 = 0xFFFF;
    var xn = +x;
    var yn = +y;
    var xl = UINT16 & xn;
    var yl = UINT16 & yn;
    return 0 | xl * yl + ((UINT16 & xn >>> 16) * yl + xl * (UINT16 & yn >>> 16) << 16 >>> 0);
  }
});


/***/ }),

/***/ 40658:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

var log = Math.log;
var LOG10E = Math.LOG10E;

// `Math.log10` method
// https://tc39.es/ecma262/#sec-math.log10
$({ target: 'Math', stat: true }, {
  log10: function log10(x) {
    return log(x) * LOG10E;
  }
});


/***/ }),

/***/ 40197:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var log1p = __webpack_require__(26513);

// `Math.log1p` method
// https://tc39.es/ecma262/#sec-math.log1p
$({ target: 'Math', stat: true }, { log1p: log1p });


/***/ }),

/***/ 44914:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

var log = Math.log;
var LN2 = Math.LN2;

// `Math.log2` method
// https://tc39.es/ecma262/#sec-math.log2
$({ target: 'Math', stat: true }, {
  log2: function log2(x) {
    return log(x) / LN2;
  }
});


/***/ }),

/***/ 52420:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var sign = __webpack_require__(64310);

// `Math.sign` method
// https://tc39.es/ecma262/#sec-math.sign
$({ target: 'Math', stat: true }, {
  sign: sign
});


/***/ }),

/***/ 60160:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var expm1 = __webpack_require__(66736);

var abs = Math.abs;
var exp = Math.exp;
var E = Math.E;

var FORCED = fails(function () {
  // eslint-disable-next-line es/no-math-sinh -- required for testing
  return Math.sinh(-2e-17) != -2e-17;
});

// `Math.sinh` method
// https://tc39.es/ecma262/#sec-math.sinh
// V8 near Chromium 38 has a problem with very small numbers
$({ target: 'Math', stat: true, forced: FORCED }, {
  sinh: function sinh(x) {
    return abs(x = +x) < 1 ? (expm1(x) - expm1(-x)) / 2 : (exp(x - 1) - exp(-x - 1)) * (E / 2);
  }
});


/***/ }),

/***/ 60970:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var expm1 = __webpack_require__(66736);

var exp = Math.exp;

// `Math.tanh` method
// https://tc39.es/ecma262/#sec-math.tanh
$({ target: 'Math', stat: true }, {
  tanh: function tanh(x) {
    var a = expm1(x = +x);
    var b = expm1(-x);
    return a == Infinity ? 1 : b == Infinity ? -1 : (a - b) / (exp(x) + exp(-x));
  }
});


/***/ }),

/***/ 10408:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var setToStringTag = __webpack_require__(58003);

// Math[@@toStringTag] property
// https://tc39.es/ecma262/#sec-math-@@tostringtag
setToStringTag(Math, 'Math', true);


/***/ }),

/***/ 73689:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

var ceil = Math.ceil;
var floor = Math.floor;

// `Math.trunc` method
// https://tc39.es/ecma262/#sec-math.trunc
$({ target: 'Math', stat: true }, {
  trunc: function trunc(it) {
    return (it > 0 ? floor : ceil)(it);
  }
});


/***/ }),

/***/ 9653:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(19781);
var global = __webpack_require__(17854);
var isForced = __webpack_require__(54705);
var redefine = __webpack_require__(31320);
var has = __webpack_require__(86656);
var classof = __webpack_require__(84326);
var inheritIfRequired = __webpack_require__(79587);
var toPrimitive = __webpack_require__(57593);
var fails = __webpack_require__(47293);
var create = __webpack_require__(70030);
var getOwnPropertyNames = __webpack_require__(8006).f;
var getOwnPropertyDescriptor = __webpack_require__(31236).f;
var defineProperty = __webpack_require__(3070).f;
var trim = __webpack_require__(53111).trim;

var NUMBER = 'Number';
var NativeNumber = global[NUMBER];
var NumberPrototype = NativeNumber.prototype;

// Opera ~12 has broken Object#toString
var BROKEN_CLASSOF = classof(create(NumberPrototype)) == NUMBER;

// `ToNumber` abstract operation
// https://tc39.es/ecma262/#sec-tonumber
var toNumber = function (argument) {
  var it = toPrimitive(argument, false);
  var first, third, radix, maxCode, digits, length, index, code;
  if (typeof it == 'string' && it.length > 2) {
    it = trim(it);
    first = it.charCodeAt(0);
    if (first === 43 || first === 45) {
      third = it.charCodeAt(2);
      if (third === 88 || third === 120) return NaN; // Number('+0x1') should be NaN, old V8 fix
    } else if (first === 48) {
      switch (it.charCodeAt(1)) {
        case 66: case 98: radix = 2; maxCode = 49; break; // fast equal of /^0b[01]+$/i
        case 79: case 111: radix = 8; maxCode = 55; break; // fast equal of /^0o[0-7]+$/i
        default: return +it;
      }
      digits = it.slice(2);
      length = digits.length;
      for (index = 0; index < length; index++) {
        code = digits.charCodeAt(index);
        // parseInt parses a string to a first unavailable symbol
        // but ToNumber should return NaN if a string contains unavailable symbols
        if (code < 48 || code > maxCode) return NaN;
      } return parseInt(digits, radix);
    }
  } return +it;
};

// `Number` constructor
// https://tc39.es/ecma262/#sec-number-constructor
if (isForced(NUMBER, !NativeNumber(' 0o1') || !NativeNumber('0b1') || NativeNumber('+0x1'))) {
  var NumberWrapper = function Number(value) {
    var it = arguments.length < 1 ? 0 : value;
    var dummy = this;
    return dummy instanceof NumberWrapper
      // check on 1..constructor(foo) case
      && (BROKEN_CLASSOF ? fails(function () { NumberPrototype.valueOf.call(dummy); }) : classof(dummy) != NUMBER)
        ? inheritIfRequired(new NativeNumber(toNumber(it)), dummy, NumberWrapper) : toNumber(it);
  };
  for (var keys = DESCRIPTORS ? getOwnPropertyNames(NativeNumber) : (
    // ES3:
    'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' +
    // ES2015 (in case, if modules with ES2015 Number statics required before):
    'EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,' +
    'MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger,' +
    // ESNext
    'fromString,range'
  ).split(','), j = 0, key; keys.length > j; j++) {
    if (has(NativeNumber, key = keys[j]) && !has(NumberWrapper, key)) {
      defineProperty(NumberWrapper, key, getOwnPropertyDescriptor(NativeNumber, key));
    }
  }
  NumberWrapper.prototype = NumberPrototype;
  NumberPrototype.constructor = NumberWrapper;
  redefine(global, NUMBER, NumberWrapper);
}


/***/ }),

/***/ 93299:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

// `Number.EPSILON` constant
// https://tc39.es/ecma262/#sec-number.epsilon
$({ target: 'Number', stat: true }, {
  EPSILON: Math.pow(2, -52)
});


/***/ }),

/***/ 35192:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var numberIsFinite = __webpack_require__(77023);

// `Number.isFinite` method
// https://tc39.es/ecma262/#sec-number.isfinite
$({ target: 'Number', stat: true }, { isFinite: numberIsFinite });


/***/ }),

/***/ 33161:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var isInteger = __webpack_require__(18730);

// `Number.isInteger` method
// https://tc39.es/ecma262/#sec-number.isinteger
$({ target: 'Number', stat: true }, {
  isInteger: isInteger
});


/***/ }),

/***/ 44048:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

// `Number.isNaN` method
// https://tc39.es/ecma262/#sec-number.isnan
$({ target: 'Number', stat: true }, {
  isNaN: function isNaN(number) {
    // eslint-disable-next-line no-self-compare -- NaN check
    return number != number;
  }
});


/***/ }),

/***/ 78285:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var isInteger = __webpack_require__(18730);

var abs = Math.abs;

// `Number.isSafeInteger` method
// https://tc39.es/ecma262/#sec-number.issafeinteger
$({ target: 'Number', stat: true }, {
  isSafeInteger: function isSafeInteger(number) {
    return isInteger(number) && abs(number) <= 0x1FFFFFFFFFFFFF;
  }
});


/***/ }),

/***/ 44363:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

// `Number.MAX_SAFE_INTEGER` constant
// https://tc39.es/ecma262/#sec-number.max_safe_integer
$({ target: 'Number', stat: true }, {
  MAX_SAFE_INTEGER: 0x1FFFFFFFFFFFFF
});


/***/ }),

/***/ 55994:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

// `Number.MIN_SAFE_INTEGER` constant
// https://tc39.es/ecma262/#sec-number.min_safe_integer
$({ target: 'Number', stat: true }, {
  MIN_SAFE_INTEGER: -0x1FFFFFFFFFFFFF
});


/***/ }),

/***/ 61874:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var parseFloat = __webpack_require__(2814);

// `Number.parseFloat` method
// https://tc39.es/ecma262/#sec-number.parseFloat
// eslint-disable-next-line es/no-number-parsefloat -- required for testing
$({ target: 'Number', stat: true, forced: Number.parseFloat != parseFloat }, {
  parseFloat: parseFloat
});


/***/ }),

/***/ 9494:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var parseInt = __webpack_require__(83009);

// `Number.parseInt` method
// https://tc39.es/ecma262/#sec-number.parseint
// eslint-disable-next-line es/no-number-parseint -- required for testing
$({ target: 'Number', stat: true, forced: Number.parseInt != parseInt }, {
  parseInt: parseInt
});


/***/ }),

/***/ 56977:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var toInteger = __webpack_require__(99958);
var thisNumberValue = __webpack_require__(50863);
var repeat = __webpack_require__(38415);
var fails = __webpack_require__(47293);

var nativeToFixed = 1.0.toFixed;
var floor = Math.floor;

var pow = function (x, n, acc) {
  return n === 0 ? acc : n % 2 === 1 ? pow(x, n - 1, acc * x) : pow(x * x, n / 2, acc);
};

var log = function (x) {
  var n = 0;
  var x2 = x;
  while (x2 >= 4096) {
    n += 12;
    x2 /= 4096;
  }
  while (x2 >= 2) {
    n += 1;
    x2 /= 2;
  } return n;
};

var multiply = function (data, n, c) {
  var index = -1;
  var c2 = c;
  while (++index < 6) {
    c2 += n * data[index];
    data[index] = c2 % 1e7;
    c2 = floor(c2 / 1e7);
  }
};

var divide = function (data, n) {
  var index = 6;
  var c = 0;
  while (--index >= 0) {
    c += data[index];
    data[index] = floor(c / n);
    c = (c % n) * 1e7;
  }
};

var dataToString = function (data) {
  var index = 6;
  var s = '';
  while (--index >= 0) {
    if (s !== '' || index === 0 || data[index] !== 0) {
      var t = String(data[index]);
      s = s === '' ? t : s + repeat.call('0', 7 - t.length) + t;
    }
  } return s;
};

var FORCED = nativeToFixed && (
  0.00008.toFixed(3) !== '0.000' ||
  0.9.toFixed(0) !== '1' ||
  1.255.toFixed(2) !== '1.25' ||
  1000000000000000128.0.toFixed(0) !== '1000000000000000128'
) || !fails(function () {
  // V8 ~ Android 4.3-
  nativeToFixed.call({});
});

// `Number.prototype.toFixed` method
// https://tc39.es/ecma262/#sec-number.prototype.tofixed
$({ target: 'Number', proto: true, forced: FORCED }, {
  toFixed: function toFixed(fractionDigits) {
    var number = thisNumberValue(this);
    var fractDigits = toInteger(fractionDigits);
    var data = [0, 0, 0, 0, 0, 0];
    var sign = '';
    var result = '0';
    var e, z, j, k;

    if (fractDigits < 0 || fractDigits > 20) throw RangeError('Incorrect fraction digits');
    // eslint-disable-next-line no-self-compare -- NaN check
    if (number != number) return 'NaN';
    if (number <= -1e21 || number >= 1e21) return String(number);
    if (number < 0) {
      sign = '-';
      number = -number;
    }
    if (number > 1e-21) {
      e = log(number * pow(2, 69, 1)) - 69;
      z = e < 0 ? number * pow(2, -e, 1) : number / pow(2, e, 1);
      z *= 0x10000000000000;
      e = 52 - e;
      if (e > 0) {
        multiply(data, 0, z);
        j = fractDigits;
        while (j >= 7) {
          multiply(data, 1e7, 0);
          j -= 7;
        }
        multiply(data, pow(10, j, 1), 0);
        j = e - 1;
        while (j >= 23) {
          divide(data, 1 << 23);
          j -= 23;
        }
        divide(data, 1 << j);
        multiply(data, 1, 1);
        divide(data, 2);
        result = dataToString(data);
      } else {
        multiply(data, 0, z);
        multiply(data, 1 << -e, 0);
        result = dataToString(data) + repeat.call('0', fractDigits);
      }
    }
    if (fractDigits > 0) {
      k = result.length;
      result = sign + (k <= fractDigits
        ? '0.' + repeat.call('0', fractDigits - k) + result
        : result.slice(0, k - fractDigits) + '.' + result.slice(k - fractDigits));
    } else {
      result = sign + result;
    } return result;
  }
});


/***/ }),

/***/ 55147:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var thisNumberValue = __webpack_require__(50863);

var nativeToPrecision = 1.0.toPrecision;

var FORCED = fails(function () {
  // IE7-
  return nativeToPrecision.call(1, undefined) !== '1';
}) || !fails(function () {
  // V8 ~ Android 4.3-
  nativeToPrecision.call({});
});

// `Number.prototype.toPrecision` method
// https://tc39.es/ecma262/#sec-number.prototype.toprecision
$({ target: 'Number', proto: true, forced: FORCED }, {
  toPrecision: function toPrecision(precision) {
    return precision === undefined
      ? nativeToPrecision.call(thisNumberValue(this))
      : nativeToPrecision.call(thisNumberValue(this), precision);
  }
});


/***/ }),

/***/ 19601:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var assign = __webpack_require__(21574);

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
// eslint-disable-next-line es/no-object-assign -- required for testing
$({ target: 'Object', stat: true, forced: Object.assign !== assign }, {
  assign: assign
});


/***/ }),

/***/ 78011:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var DESCRIPTORS = __webpack_require__(19781);
var create = __webpack_require__(70030);

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
$({ target: 'Object', stat: true, sham: !DESCRIPTORS }, {
  create: create
});


/***/ }),

/***/ 59595:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var DESCRIPTORS = __webpack_require__(19781);
var FORCED = __webpack_require__(69026);
var toObject = __webpack_require__(47908);
var aFunction = __webpack_require__(13099);
var definePropertyModule = __webpack_require__(3070);

// `Object.prototype.__defineGetter__` method
// https://tc39.es/ecma262/#sec-object.prototype.__defineGetter__
if (DESCRIPTORS) {
  $({ target: 'Object', proto: true, forced: FORCED }, {
    __defineGetter__: function __defineGetter__(P, getter) {
      definePropertyModule.f(toObject(this), P, { get: aFunction(getter), enumerable: true, configurable: true });
    }
  });
}


/***/ }),

/***/ 33321:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var DESCRIPTORS = __webpack_require__(19781);
var defineProperties = __webpack_require__(36048);

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
$({ target: 'Object', stat: true, forced: !DESCRIPTORS, sham: !DESCRIPTORS }, {
  defineProperties: defineProperties
});


/***/ }),

/***/ 69070:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var DESCRIPTORS = __webpack_require__(19781);
var objectDefinePropertyModile = __webpack_require__(3070);

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
$({ target: 'Object', stat: true, forced: !DESCRIPTORS, sham: !DESCRIPTORS }, {
  defineProperty: objectDefinePropertyModile.f
});


/***/ }),

/***/ 35500:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var DESCRIPTORS = __webpack_require__(19781);
var FORCED = __webpack_require__(69026);
var toObject = __webpack_require__(47908);
var aFunction = __webpack_require__(13099);
var definePropertyModule = __webpack_require__(3070);

// `Object.prototype.__defineSetter__` method
// https://tc39.es/ecma262/#sec-object.prototype.__defineSetter__
if (DESCRIPTORS) {
  $({ target: 'Object', proto: true, forced: FORCED }, {
    __defineSetter__: function __defineSetter__(P, setter) {
      definePropertyModule.f(toObject(this), P, { set: aFunction(setter), enumerable: true, configurable: true });
    }
  });
}


/***/ }),

/***/ 69720:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var $entries = __webpack_require__(44699).entries;

// `Object.entries` method
// https://tc39.es/ecma262/#sec-object.entries
$({ target: 'Object', stat: true }, {
  entries: function entries(O) {
    return $entries(O);
  }
});


/***/ }),

/***/ 43371:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var FREEZING = __webpack_require__(76677);
var fails = __webpack_require__(47293);
var isObject = __webpack_require__(70111);
var onFreeze = __webpack_require__(62423).onFreeze;

// eslint-disable-next-line es/no-object-freeze -- safe
var $freeze = Object.freeze;
var FAILS_ON_PRIMITIVES = fails(function () { $freeze(1); });

// `Object.freeze` method
// https://tc39.es/ecma262/#sec-object.freeze
$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES, sham: !FREEZING }, {
  freeze: function freeze(it) {
    return $freeze && isObject(it) ? $freeze(onFreeze(it)) : it;
  }
});


/***/ }),

/***/ 38559:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var iterate = __webpack_require__(20408);
var createProperty = __webpack_require__(86135);

// `Object.fromEntries` method
// https://github.com/tc39/proposal-object-from-entries
$({ target: 'Object', stat: true }, {
  fromEntries: function fromEntries(iterable) {
    var obj = {};
    iterate(iterable, function (k, v) {
      createProperty(obj, k, v);
    }, { AS_ENTRIES: true });
    return obj;
  }
});


/***/ }),

/***/ 38880:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var toIndexedObject = __webpack_require__(45656);
var nativeGetOwnPropertyDescriptor = __webpack_require__(31236).f;
var DESCRIPTORS = __webpack_require__(19781);

var FAILS_ON_PRIMITIVES = fails(function () { nativeGetOwnPropertyDescriptor(1); });
var FORCED = !DESCRIPTORS || FAILS_ON_PRIMITIVES;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
$({ target: 'Object', stat: true, forced: FORCED, sham: !DESCRIPTORS }, {
  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
    return nativeGetOwnPropertyDescriptor(toIndexedObject(it), key);
  }
});


/***/ }),

/***/ 49337:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var DESCRIPTORS = __webpack_require__(19781);
var ownKeys = __webpack_require__(53887);
var toIndexedObject = __webpack_require__(45656);
var getOwnPropertyDescriptorModule = __webpack_require__(31236);
var createProperty = __webpack_require__(86135);

// `Object.getOwnPropertyDescriptors` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
$({ target: 'Object', stat: true, sham: !DESCRIPTORS }, {
  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
    var O = toIndexedObject(object);
    var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
    var keys = ownKeys(O);
    var result = {};
    var index = 0;
    var key, descriptor;
    while (keys.length > index) {
      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
      if (descriptor !== undefined) createProperty(result, key, descriptor);
    }
    return result;
  }
});


/***/ }),

/***/ 36210:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var getOwnPropertyNames = __webpack_require__(1156).f;

// eslint-disable-next-line es/no-object-getownpropertynames -- required for testing
var FAILS_ON_PRIMITIVES = fails(function () { return !Object.getOwnPropertyNames(1); });

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES }, {
  getOwnPropertyNames: getOwnPropertyNames
});


/***/ }),

/***/ 30489:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var toObject = __webpack_require__(47908);
var nativeGetPrototypeOf = __webpack_require__(79518);
var CORRECT_PROTOTYPE_GETTER = __webpack_require__(49920);

var FAILS_ON_PRIMITIVES = fails(function () { nativeGetPrototypeOf(1); });

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES, sham: !CORRECT_PROTOTYPE_GETTER }, {
  getPrototypeOf: function getPrototypeOf(it) {
    return nativeGetPrototypeOf(toObject(it));
  }
});



/***/ }),

/***/ 41825:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var isObject = __webpack_require__(70111);

// eslint-disable-next-line es/no-object-isextensible -- safe
var $isExtensible = Object.isExtensible;
var FAILS_ON_PRIMITIVES = fails(function () { $isExtensible(1); });

// `Object.isExtensible` method
// https://tc39.es/ecma262/#sec-object.isextensible
$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES }, {
  isExtensible: function isExtensible(it) {
    return isObject(it) ? $isExtensible ? $isExtensible(it) : true : false;
  }
});


/***/ }),

/***/ 98410:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var isObject = __webpack_require__(70111);

// eslint-disable-next-line es/no-object-isfrozen -- safe
var $isFrozen = Object.isFrozen;
var FAILS_ON_PRIMITIVES = fails(function () { $isFrozen(1); });

// `Object.isFrozen` method
// https://tc39.es/ecma262/#sec-object.isfrozen
$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES }, {
  isFrozen: function isFrozen(it) {
    return isObject(it) ? $isFrozen ? $isFrozen(it) : false : true;
  }
});


/***/ }),

/***/ 72200:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var fails = __webpack_require__(47293);
var isObject = __webpack_require__(70111);

// eslint-disable-next-line es/no-object-issealed -- safe
var $isSealed = Object.isSealed;
var FAILS_ON_PRIMITIVES = fails(function () { $isSealed(1); });

// `Object.isSealed` method
// https://tc39.es/ecma262/#sec-object.issealed
$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES }, {
  isSealed: function isSealed(it) {
    return isObject(it) ? $isSealed ? $isSealed(it) : false : true;
  }
});


/***/ }),

/***/ 43304:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var is = __webpack_require__(81150);

// `Object.is` method
// https://tc39.es/ecma262/#sec-object.is
$({ target: 'Object', stat: true }, {
  is: is
});


/***/ }),

/***/ 47941:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var toObject = __webpack_require__(47908);
var nativeKeys = __webpack_require__(81956);
var fails = __webpack_require__(47293);

var FAILS_ON_PRIMITIVES = fails(function () { nativeKeys(1); });

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES }, {
  keys: function keys(it) {
    return nativeKeys(toObject(it));
  }
});


/***/ }),

/***/ 94869:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var DESCRIPTORS = __webpack_require__(19781);
var FORCED = __webpack_require__(69026);
var toObject = __webpack_require__(47908);
var toPrimitive = __webpack_require__(57593);
var getPrototypeOf = __webpack_require__(79518);
var getOwnPropertyDescriptor = __webpack_require__(31236).f;

// `Object.prototype.__lookupGetter__` method
// https://tc39.es/ecma262/#sec-object.prototype.__lookupGetter__
if (DESCRIPTORS) {
  $({ target: 'Object', proto: true, forced: FORCED }, {
    __lookupGetter__: function __lookupGetter__(P) {
      var O = toObject(this);
      var key = toPrimitive(P, true);
      var desc;
      do {
        if (desc = getOwnPropertyDescriptor(O, key)) return desc.get;
      } while (O = getPrototypeOf(O));
    }
  });
}


/***/ }),

/***/ 33952:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var DESCRIPTORS = __webpack_require__(19781);
var FORCED = __webpack_require__(69026);
var toObject = __webpack_require__(47908);
var toPrimitive = __webpack_require__(57593);
var getPrototypeOf = __webpack_require__(79518);
var getOwnPropertyDescriptor = __webpack_require__(31236).f;

// `Object.prototype.__lookupSetter__` method
// https://tc39.es/ecma262/#sec-object.prototype.__lookupSetter__
if (DESCRIPTORS) {
  $({ target: 'Object', proto: true, forced: FORCED }, {
    __lookupSetter__: function __lookupSetter__(P) {
      var O = toObject(this);
      var key = toPrimitive(P, true);
      var desc;
      do {
        if (desc = getOwnPropertyDescriptor(O, key)) return desc.set;
      } while (O = getPrototypeOf(O));
    }
  });
}


/***/ }),

/***/ 57227:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var isObject = __webpack_require__(70111);
var onFreeze = __webpack_require__(62423).onFreeze;
var FREEZING = __webpack_require__(76677);
var fails = __webpack_require__(47293);

// eslint-disable-next-line es/no-object-preventextensions -- safe
var $preventExtensions = Object.preventExtensions;
var FAILS_ON_PRIMITIVES = fails(function () { $preventExtensions(1); });

// `Object.preventExtensions` method
// https://tc39.es/ecma262/#sec-object.preventextensions
$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES, sham: !FREEZING }, {
  preventExtensions: function preventExtensions(it) {
    return $preventExtensions && isObject(it) ? $preventExtensions(onFreeze(it)) : it;
  }
});


/***/ }),

/***/ 60514:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var isObject = __webpack_require__(70111);
var onFreeze = __webpack_require__(62423).onFreeze;
var FREEZING = __webpack_require__(76677);
var fails = __webpack_require__(47293);

// eslint-disable-next-line es/no-object-seal -- safe
var $seal = Object.seal;
var FAILS_ON_PRIMITIVES = fails(function () { $seal(1); });

// `Object.seal` method
// https://tc39.es/ecma262/#sec-object.seal
$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES, sham: !FREEZING }, {
  seal: function seal(it) {
    return $seal && isObject(it) ? $seal(onFreeze(it)) : it;
  }
});


/***/ }),

/***/ 68304:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var setPrototypeOf = __webpack_require__(27674);

// `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
$({ target: 'Object', stat: true }, {
  setPrototypeOf: setPrototypeOf
});


/***/ }),

/***/ 41539:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var TO_STRING_TAG_SUPPORT = __webpack_require__(51694);
var redefine = __webpack_require__(31320);
var toString = __webpack_require__(90288);

// `Object.prototype.toString` method
// https://tc39.es/ecma262/#sec-object.prototype.tostring
if (!TO_STRING_TAG_SUPPORT) {
  redefine(Object.prototype, 'toString', toString, { unsafe: true });
}


/***/ }),

/***/ 26833:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var $values = __webpack_require__(44699).values;

// `Object.values` method
// https://tc39.es/ecma262/#sec-object.values
$({ target: 'Object', stat: true }, {
  values: function values(O) {
    return $values(O);
  }
});


/***/ }),

/***/ 54678:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var parseFloatImplementation = __webpack_require__(2814);

// `parseFloat` method
// https://tc39.es/ecma262/#sec-parsefloat-string
$({ global: true, forced: parseFloat != parseFloatImplementation }, {
  parseFloat: parseFloatImplementation
});


/***/ }),

/***/ 91058:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var parseIntImplementation = __webpack_require__(83009);

// `parseInt` method
// https://tc39.es/ecma262/#sec-parseint-string-radix
$({ global: true, forced: parseInt != parseIntImplementation }, {
  parseInt: parseIntImplementation
});


/***/ }),

/***/ 17922:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var aFunction = __webpack_require__(13099);
var newPromiseCapabilityModule = __webpack_require__(78523);
var perform = __webpack_require__(12534);
var iterate = __webpack_require__(20408);

// `Promise.allSettled` method
// https://tc39.es/ecma262/#sec-promise.allsettled
$({ target: 'Promise', stat: true }, {
  allSettled: function allSettled(iterable) {
    var C = this;
    var capability = newPromiseCapabilityModule.f(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = perform(function () {
      var promiseResolve = aFunction(C.resolve);
      var values = [];
      var counter = 0;
      var remaining = 1;
      iterate(iterable, function (promise) {
        var index = counter++;
        var alreadyCalled = false;
        values.push(undefined);
        remaining++;
        promiseResolve.call(C, promise).then(function (value) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = { status: 'fulfilled', value: value };
          --remaining || resolve(values);
        }, function (error) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = { status: 'rejected', reason: error };
          --remaining || resolve(values);
        });
      });
      --remaining || resolve(values);
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});


/***/ }),

/***/ 34668:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var aFunction = __webpack_require__(13099);
var getBuiltIn = __webpack_require__(35005);
var newPromiseCapabilityModule = __webpack_require__(78523);
var perform = __webpack_require__(12534);
var iterate = __webpack_require__(20408);

var PROMISE_ANY_ERROR = 'No one promise resolved';

// `Promise.any` method
// https://tc39.es/ecma262/#sec-promise.any
$({ target: 'Promise', stat: true }, {
  any: function any(iterable) {
    var C = this;
    var capability = newPromiseCapabilityModule.f(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = perform(function () {
      var promiseResolve = aFunction(C.resolve);
      var errors = [];
      var counter = 0;
      var remaining = 1;
      var alreadyResolved = false;
      iterate(iterable, function (promise) {
        var index = counter++;
        var alreadyRejected = false;
        errors.push(undefined);
        remaining++;
        promiseResolve.call(C, promise).then(function (value) {
          if (alreadyRejected || alreadyResolved) return;
          alreadyResolved = true;
          resolve(value);
        }, function (error) {
          if (alreadyRejected || alreadyResolved) return;
          alreadyRejected = true;
          errors[index] = error;
          --remaining || reject(new (getBuiltIn('AggregateError'))(errors, PROMISE_ANY_ERROR));
        });
      });
      --remaining || reject(new (getBuiltIn('AggregateError'))(errors, PROMISE_ANY_ERROR));
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});


/***/ }),

/***/ 17727:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var IS_PURE = __webpack_require__(31913);
var NativePromise = __webpack_require__(13366);
var fails = __webpack_require__(47293);
var getBuiltIn = __webpack_require__(35005);
var speciesConstructor = __webpack_require__(36707);
var promiseResolve = __webpack_require__(69478);
var redefine = __webpack_require__(31320);

// Safari bug https://bugs.webkit.org/show_bug.cgi?id=200829
var NON_GENERIC = !!NativePromise && fails(function () {
  NativePromise.prototype['finally'].call({ then: function () { /* empty */ } }, function () { /* empty */ });
});

// `Promise.prototype.finally` method
// https://tc39.es/ecma262/#sec-promise.prototype.finally
$({ target: 'Promise', proto: true, real: true, forced: NON_GENERIC }, {
  'finally': function (onFinally) {
    var C = speciesConstructor(this, getBuiltIn('Promise'));
    var isFunction = typeof onFinally == 'function';
    return this.then(
      isFunction ? function (x) {
        return promiseResolve(C, onFinally()).then(function () { return x; });
      } : onFinally,
      isFunction ? function (e) {
        return promiseResolve(C, onFinally()).then(function () { throw e; });
      } : onFinally
    );
  }
});

// makes sure that native promise-based APIs `Promise#finally` properly works with patched `Promise#then`
if (!IS_PURE && typeof NativePromise == 'function') {
  var method = getBuiltIn('Promise').prototype['finally'];
  if (NativePromise.prototype['finally'] !== method) {
    redefine(NativePromise.prototype, 'finally', method, { unsafe: true });
  }
}


/***/ }),

/***/ 88674:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var IS_PURE = __webpack_require__(31913);
var global = __webpack_require__(17854);
var getBuiltIn = __webpack_require__(35005);
var NativePromise = __webpack_require__(13366);
var redefine = __webpack_require__(31320);
var redefineAll = __webpack_require__(12248);
var setPrototypeOf = __webpack_require__(27674);
var setToStringTag = __webpack_require__(58003);
var setSpecies = __webpack_require__(96340);
var isObject = __webpack_require__(70111);
var aFunction = __webpack_require__(13099);
var anInstance = __webpack_require__(25787);
var inspectSource = __webpack_require__(42788);
var iterate = __webpack_require__(20408);
var checkCorrectnessOfIteration = __webpack_require__(17072);
var speciesConstructor = __webpack_require__(36707);
var task = __webpack_require__(20261).set;
var microtask = __webpack_require__(95948);
var promiseResolve = __webpack_require__(69478);
var hostReportErrors = __webpack_require__(842);
var newPromiseCapabilityModule = __webpack_require__(78523);
var perform = __webpack_require__(12534);
var InternalStateModule = __webpack_require__(29909);
var isForced = __webpack_require__(54705);
var wellKnownSymbol = __webpack_require__(5112);
var IS_BROWSER = __webpack_require__(7871);
var IS_NODE = __webpack_require__(35268);
var V8_VERSION = __webpack_require__(7392);

var SPECIES = wellKnownSymbol('species');
var PROMISE = 'Promise';
var getInternalState = InternalStateModule.get;
var setInternalState = InternalStateModule.set;
var getInternalPromiseState = InternalStateModule.getterFor(PROMISE);
var NativePromisePrototype = NativePromise && NativePromise.prototype;
var PromiseConstructor = NativePromise;
var PromiseConstructorPrototype = NativePromisePrototype;
var TypeError = global.TypeError;
var document = global.document;
var process = global.process;
var newPromiseCapability = newPromiseCapabilityModule.f;
var newGenericPromiseCapability = newPromiseCapability;
var DISPATCH_EVENT = !!(document && document.createEvent && global.dispatchEvent);
var NATIVE_REJECTION_EVENT = typeof PromiseRejectionEvent == 'function';
var UNHANDLED_REJECTION = 'unhandledrejection';
var REJECTION_HANDLED = 'rejectionhandled';
var PENDING = 0;
var FULFILLED = 1;
var REJECTED = 2;
var HANDLED = 1;
var UNHANDLED = 2;
var SUBCLASSING = false;
var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;

var FORCED = isForced(PROMISE, function () {
  var GLOBAL_CORE_JS_PROMISE = inspectSource(PromiseConstructor) !== String(PromiseConstructor);
  // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
  // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
  // We can't detect it synchronously, so just check versions
  if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66) return true;
  // We need Promise#finally in the pure version for preventing prototype pollution
  if (IS_PURE && !PromiseConstructorPrototype['finally']) return true;
  // We can't use @@species feature detection in V8 since it causes
  // deoptimization and performance degradation
  // https://github.com/zloirock/core-js/issues/679
  if (V8_VERSION >= 51 && /native code/.test(PromiseConstructor)) return false;
  // Detect correctness of subclassing with @@species support
  var promise = new PromiseConstructor(function (resolve) { resolve(1); });
  var FakePromise = function (exec) {
    exec(function () { /* empty */ }, function () { /* empty */ });
  };
  var constructor = promise.constructor = {};
  constructor[SPECIES] = FakePromise;
  SUBCLASSING = promise.then(function () { /* empty */ }) instanceof FakePromise;
  if (!SUBCLASSING) return true;
  // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test
  return !GLOBAL_CORE_JS_PROMISE && IS_BROWSER && !NATIVE_REJECTION_EVENT;
});

var INCORRECT_ITERATION = FORCED || !checkCorrectnessOfIteration(function (iterable) {
  PromiseConstructor.all(iterable)['catch'](function () { /* empty */ });
});

// helpers
var isThenable = function (it) {
  var then;
  return isObject(it) && typeof (then = it.then) == 'function' ? then : false;
};

var notify = function (state, isReject) {
  if (state.notified) return;
  state.notified = true;
  var chain = state.reactions;
  microtask(function () {
    var value = state.value;
    var ok = state.state == FULFILLED;
    var index = 0;
    // variable length - can't use forEach
    while (chain.length > index) {
      var reaction = chain[index++];
      var handler = ok ? reaction.ok : reaction.fail;
      var resolve = reaction.resolve;
      var reject = reaction.reject;
      var domain = reaction.domain;
      var result, then, exited;
      try {
        if (handler) {
          if (!ok) {
            if (state.rejection === UNHANDLED) onHandleUnhandled(state);
            state.rejection = HANDLED;
          }
          if (handler === true) result = value;
          else {
            if (domain) domain.enter();
            result = handler(value); // can throw
            if (domain) {
              domain.exit();
              exited = true;
            }
          }
          if (result === reaction.promise) {
            reject(TypeError('Promise-chain cycle'));
          } else if (then = isThenable(result)) {
            then.call(result, resolve, reject);
          } else resolve(result);
        } else reject(value);
      } catch (error) {
        if (domain && !exited) domain.exit();
        reject(error);
      }
    }
    state.reactions = [];
    state.notified = false;
    if (isReject && !state.rejection) onUnhandled(state);
  });
};

var dispatchEvent = function (name, promise, reason) {
  var event, handler;
  if (DISPATCH_EVENT) {
    event = document.createEvent('Event');
    event.promise = promise;
    event.reason = reason;
    event.initEvent(name, false, true);
    global.dispatchEvent(event);
  } else event = { promise: promise, reason: reason };
  if (!NATIVE_REJECTION_EVENT && (handler = global['on' + name])) handler(event);
  else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
};

var onUnhandled = function (state) {
  task.call(global, function () {
    var promise = state.facade;
    var value = state.value;
    var IS_UNHANDLED = isUnhandled(state);
    var result;
    if (IS_UNHANDLED) {
      result = perform(function () {
        if (IS_NODE) {
          process.emit('unhandledRejection', value, promise);
        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
      });
      // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
      state.rejection = IS_NODE || isUnhandled(state) ? UNHANDLED : HANDLED;
      if (result.error) throw result.value;
    }
  });
};

var isUnhandled = function (state) {
  return state.rejection !== HANDLED && !state.parent;
};

var onHandleUnhandled = function (state) {
  task.call(global, function () {
    var promise = state.facade;
    if (IS_NODE) {
      process.emit('rejectionHandled', promise);
    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
  });
};

var bind = function (fn, state, unwrap) {
  return function (value) {
    fn(state, value, unwrap);
  };
};

var internalReject = function (state, value, unwrap) {
  if (state.done) return;
  state.done = true;
  if (unwrap) state = unwrap;
  state.value = value;
  state.state = REJECTED;
  notify(state, true);
};

var internalResolve = function (state, value, unwrap) {
  if (state.done) return;
  state.done = true;
  if (unwrap) state = unwrap;
  try {
    if (state.facade === value) throw TypeError("Promise can't be resolved itself");
    var then = isThenable(value);
    if (then) {
      microtask(function () {
        var wrapper = { done: false };
        try {
          then.call(value,
            bind(internalResolve, wrapper, state),
            bind(internalReject, wrapper, state)
          );
        } catch (error) {
          internalReject(wrapper, error, state);
        }
      });
    } else {
      state.value = value;
      state.state = FULFILLED;
      notify(state, false);
    }
  } catch (error) {
    internalReject({ done: false }, error, state);
  }
};

// constructor polyfill
if (FORCED) {
  // 25.4.3.1 Promise(executor)
  PromiseConstructor = function Promise(executor) {
    anInstance(this, PromiseConstructor, PROMISE);
    aFunction(executor);
    Internal.call(this);
    var state = getInternalState(this);
    try {
      executor(bind(internalResolve, state), bind(internalReject, state));
    } catch (error) {
      internalReject(state, error);
    }
  };
  PromiseConstructorPrototype = PromiseConstructor.prototype;
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  Internal = function Promise(executor) {
    setInternalState(this, {
      type: PROMISE,
      done: false,
      notified: false,
      parent: false,
      reactions: [],
      rejection: false,
      state: PENDING,
      value: undefined
    });
  };
  Internal.prototype = redefineAll(PromiseConstructorPrototype, {
    // `Promise.prototype.then` method
    // https://tc39.es/ecma262/#sec-promise.prototype.then
    then: function then(onFulfilled, onRejected) {
      var state = getInternalPromiseState(this);
      var reaction = newPromiseCapability(speciesConstructor(this, PromiseConstructor));
      reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;
      reaction.fail = typeof onRejected == 'function' && onRejected;
      reaction.domain = IS_NODE ? process.domain : undefined;
      state.parent = true;
      state.reactions.push(reaction);
      if (state.state != PENDING) notify(state, false);
      return reaction.promise;
    },
    // `Promise.prototype.catch` method
    // https://tc39.es/ecma262/#sec-promise.prototype.catch
    'catch': function (onRejected) {
      return this.then(undefined, onRejected);
    }
  });
  OwnPromiseCapability = function () {
    var promise = new Internal();
    var state = getInternalState(promise);
    this.promise = promise;
    this.resolve = bind(internalResolve, state);
    this.reject = bind(internalReject, state);
  };
  newPromiseCapabilityModule.f = newPromiseCapability = function (C) {
    return C === PromiseConstructor || C === PromiseWrapper
      ? new OwnPromiseCapability(C)
      : newGenericPromiseCapability(C);
  };

  if (!IS_PURE && typeof NativePromise == 'function' && NativePromisePrototype !== Object.prototype) {
    nativeThen = NativePromisePrototype.then;

    if (!SUBCLASSING) {
      // make `Promise#then` return a polyfilled `Promise` for native promise-based APIs
      redefine(NativePromisePrototype, 'then', function then(onFulfilled, onRejected) {
        var that = this;
        return new PromiseConstructor(function (resolve, reject) {
          nativeThen.call(that, resolve, reject);
        }).then(onFulfilled, onRejected);
      // https://github.com/zloirock/core-js/issues/640
      }, { unsafe: true });

      // makes sure that native promise-based APIs `Promise#catch` properly works with patched `Promise#then`
      redefine(NativePromisePrototype, 'catch', PromiseConstructorPrototype['catch'], { unsafe: true });
    }

    // make `.constructor === Promise` work for native promise-based APIs
    try {
      delete NativePromisePrototype.constructor;
    } catch (error) { /* empty */ }

    // make `instanceof Promise` work for native promise-based APIs
    if (setPrototypeOf) {
      setPrototypeOf(NativePromisePrototype, PromiseConstructorPrototype);
    }
  }
}

$({ global: true, wrap: true, forced: FORCED }, {
  Promise: PromiseConstructor
});

setToStringTag(PromiseConstructor, PROMISE, false, true);
setSpecies(PROMISE);

PromiseWrapper = getBuiltIn(PROMISE);

// statics
$({ target: PROMISE, stat: true, forced: FORCED }, {
  // `Promise.reject` method
  // https://tc39.es/ecma262/#sec-promise.reject
  reject: function reject(r) {
    var capability = newPromiseCapability(this);
    capability.reject.call(undefined, r);
    return capability.promise;
  }
});

$({ target: PROMISE, stat: true, forced: IS_PURE || FORCED }, {
  // `Promise.resolve` method
  // https://tc39.es/ecma262/#sec-promise.resolve
  resolve: function resolve(x) {
    return promiseResolve(IS_PURE && this === PromiseWrapper ? PromiseConstructor : this, x);
  }
});

$({ target: PROMISE, stat: true, forced: INCORRECT_ITERATION }, {
  // `Promise.all` method
  // https://tc39.es/ecma262/#sec-promise.all
  all: function all(iterable) {
    var C = this;
    var capability = newPromiseCapability(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = perform(function () {
      var $promiseResolve = aFunction(C.resolve);
      var values = [];
      var counter = 0;
      var remaining = 1;
      iterate(iterable, function (promise) {
        var index = counter++;
        var alreadyCalled = false;
        values.push(undefined);
        remaining++;
        $promiseResolve.call(C, promise).then(function (value) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = value;
          --remaining || resolve(values);
        }, reject);
      });
      --remaining || resolve(values);
    });
    if (result.error) reject(result.value);
    return capability.promise;
  },
  // `Promise.race` method
  // https://tc39.es/ecma262/#sec-promise.race
  race: function race(iterable) {
    var C = this;
    var capability = newPromiseCapability(C);
    var reject = capability.reject;
    var result = perform(function () {
      var $promiseResolve = aFunction(C.resolve);
      iterate(iterable, function (promise) {
        $promiseResolve.call(C, promise).then(capability.resolve, reject);
      });
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});


/***/ }),

/***/ 36535:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var getBuiltIn = __webpack_require__(35005);
var aFunction = __webpack_require__(13099);
var anObject = __webpack_require__(19670);
var fails = __webpack_require__(47293);

var nativeApply = getBuiltIn('Reflect', 'apply');
var functionApply = Function.apply;

// MS Edge argumentsList argument is optional
var OPTIONAL_ARGUMENTS_LIST = !fails(function () {
  nativeApply(function () { /* empty */ });
});

// `Reflect.apply` method
// https://tc39.es/ecma262/#sec-reflect.apply
$({ target: 'Reflect', stat: true, forced: OPTIONAL_ARGUMENTS_LIST }, {
  apply: function apply(target, thisArgument, argumentsList) {
    aFunction(target);
    anObject(argumentsList);
    return nativeApply
      ? nativeApply(target, thisArgument, argumentsList)
      : functionApply.call(target, thisArgument, argumentsList);
  }
});


/***/ }),

/***/ 12419:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var getBuiltIn = __webpack_require__(35005);
var aFunction = __webpack_require__(13099);
var anObject = __webpack_require__(19670);
var isObject = __webpack_require__(70111);
var create = __webpack_require__(70030);
var bind = __webpack_require__(27065);
var fails = __webpack_require__(47293);

var nativeConstruct = getBuiltIn('Reflect', 'construct');

// `Reflect.construct` method
// https://tc39.es/ecma262/#sec-reflect.construct
// MS Edge supports only 2 arguments and argumentsList argument is optional
// FF Nightly sets third argument as `new.target`, but does not create `this` from it
var NEW_TARGET_BUG = fails(function () {
  function F() { /* empty */ }
  return !(nativeConstruct(function () { /* empty */ }, [], F) instanceof F);
});
var ARGS_BUG = !fails(function () {
  nativeConstruct(function () { /* empty */ });
});
var FORCED = NEW_TARGET_BUG || ARGS_BUG;

$({ target: 'Reflect', stat: true, forced: FORCED, sham: FORCED }, {
  construct: function construct(Target, args /* , newTarget */) {
    aFunction(Target);
    anObject(args);
    var newTarget = arguments.length < 3 ? Target : aFunction(arguments[2]);
    if (ARGS_BUG && !NEW_TARGET_BUG) return nativeConstruct(Target, args, newTarget);
    if (Target == newTarget) {
      // w/o altered newTarget, optimization for 0-4 arguments
      switch (args.length) {
        case 0: return new Target();
        case 1: return new Target(args[0]);
        case 2: return new Target(args[0], args[1]);
        case 3: return new Target(args[0], args[1], args[2]);
        case 4: return new Target(args[0], args[1], args[2], args[3]);
      }
      // w/o altered newTarget, lot of arguments case
      var $args = [null];
      $args.push.apply($args, args);
      return new (bind.apply(Target, $args))();
    }
    // with altered newTarget, not support built-in constructors
    var proto = newTarget.prototype;
    var instance = create(isObject(proto) ? proto : Object.prototype);
    var result = Function.apply.call(Target, instance, args);
    return isObject(result) ? result : instance;
  }
});


/***/ }),

/***/ 69596:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var DESCRIPTORS = __webpack_require__(19781);
var anObject = __webpack_require__(19670);
var toPrimitive = __webpack_require__(57593);
var definePropertyModule = __webpack_require__(3070);
var fails = __webpack_require__(47293);

// MS Edge has broken Reflect.defineProperty - throwing instead of returning false
var ERROR_INSTEAD_OF_FALSE = fails(function () {
  // eslint-disable-next-line es/no-reflect -- required for testing
  Reflect.defineProperty(definePropertyModule.f({}, 1, { value: 1 }), 1, { value: 2 });
});

// `Reflect.defineProperty` method
// https://tc39.es/ecma262/#sec-reflect.defineproperty
$({ target: 'Reflect', stat: true, forced: ERROR_INSTEAD_OF_FALSE, sham: !DESCRIPTORS }, {
  defineProperty: function defineProperty(target, propertyKey, attributes) {
    anObject(target);
    var key = toPrimitive(propertyKey, true);
    anObject(attributes);
    try {
      definePropertyModule.f(target, key, attributes);
      return true;
    } catch (error) {
      return false;
    }
  }
});


/***/ }),

/***/ 52586:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var anObject = __webpack_require__(19670);
var getOwnPropertyDescriptor = __webpack_require__(31236).f;

// `Reflect.deleteProperty` method
// https://tc39.es/ecma262/#sec-reflect.deleteproperty
$({ target: 'Reflect', stat: true }, {
  deleteProperty: function deleteProperty(target, propertyKey) {
    var descriptor = getOwnPropertyDescriptor(anObject(target), propertyKey);
    return descriptor && !descriptor.configurable ? false : delete target[propertyKey];
  }
});


/***/ }),

/***/ 95683:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var DESCRIPTORS = __webpack_require__(19781);
var anObject = __webpack_require__(19670);
var getOwnPropertyDescriptorModule = __webpack_require__(31236);

// `Reflect.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-reflect.getownpropertydescriptor
$({ target: 'Reflect', stat: true, sham: !DESCRIPTORS }, {
  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(target, propertyKey) {
    return getOwnPropertyDescriptorModule.f(anObject(target), propertyKey);
  }
});


/***/ }),

/***/ 39361:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var anObject = __webpack_require__(19670);
var objectGetPrototypeOf = __webpack_require__(79518);
var CORRECT_PROTOTYPE_GETTER = __webpack_require__(49920);

// `Reflect.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-reflect.getprototypeof
$({ target: 'Reflect', stat: true, sham: !CORRECT_PROTOTYPE_GETTER }, {
  getPrototypeOf: function getPrototypeOf(target) {
    return objectGetPrototypeOf(anObject(target));
  }
});


/***/ }),

/***/ 74819:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var isObject = __webpack_require__(70111);
var anObject = __webpack_require__(19670);
var has = __webpack_require__(86656);
var getOwnPropertyDescriptorModule = __webpack_require__(31236);
var getPrototypeOf = __webpack_require__(79518);

// `Reflect.get` method
// https://tc39.es/ecma262/#sec-reflect.get
function get(target, propertyKey /* , receiver */) {
  var receiver = arguments.length < 3 ? target : arguments[2];
  var descriptor, prototype;
  if (anObject(target) === receiver) return target[propertyKey];
  if (descriptor = getOwnPropertyDescriptorModule.f(target, propertyKey)) return has(descriptor, 'value')
    ? descriptor.value
    : descriptor.get === undefined
      ? undefined
      : descriptor.get.call(receiver);
  if (isObject(prototype = getPrototypeOf(target))) return get(prototype, propertyKey, receiver);
}

$({ target: 'Reflect', stat: true }, {
  get: get
});


/***/ }),

/***/ 51037:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);

// `Reflect.has` method
// https://tc39.es/ecma262/#sec-reflect.has
$({ target: 'Reflect', stat: true }, {
  has: function has(target, propertyKey) {
    return propertyKey in target;
  }
});


/***/ }),

/***/ 5898:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var anObject = __webpack_require__(19670);

// eslint-disable-next-line es/no-object-isextensible -- safe
var objectIsExtensible = Object.isExtensible;

// `Reflect.isExtensible` method
// https://tc39.es/ecma262/#sec-reflect.isextensible
$({ target: 'Reflect', stat: true }, {
  isExtensible: function isExtensible(target) {
    anObject(target);
    return objectIsExtensible ? objectIsExtensible(target) : true;
  }
});


/***/ }),

/***/ 67556:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var ownKeys = __webpack_require__(53887);

// `Reflect.ownKeys` method
// https://tc39.es/ecma262/#sec-reflect.ownkeys
$({ target: 'Reflect', stat: true }, {
  ownKeys: ownKeys
});


/***/ }),

/***/ 14361:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var getBuiltIn = __webpack_require__(35005);
var anObject = __webpack_require__(19670);
var FREEZING = __webpack_require__(76677);

// `Reflect.preventExtensions` method
// https://tc39.es/ecma262/#sec-reflect.preventextensions
$({ target: 'Reflect', stat: true, sham: !FREEZING }, {
  preventExtensions: function preventExtensions(target) {
    anObject(target);
    try {
      var objectPreventExtensions = getBuiltIn('Object', 'preventExtensions');
      if (objectPreventExtensions) objectPreventExtensions(target);
      return true;
    } catch (error) {
      return false;
    }
  }
});


/***/ }),

/***/ 39532:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var anObject = __webpack_require__(19670);
var aPossiblePrototype = __webpack_require__(96077);
var objectSetPrototypeOf = __webpack_require__(27674);

// `Reflect.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-reflect.setprototypeof
if (objectSetPrototypeOf) $({ target: 'Reflect', stat: true }, {
  setPrototypeOf: function setPrototypeOf(target, proto) {
    anObject(target);
    aPossiblePrototype(proto);
    try {
      objectSetPrototypeOf(target, proto);
      return true;
    } catch (error) {
      return false;
    }
  }
});


/***/ }),

/***/ 83593:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var anObject = __webpack_require__(19670);
var isObject = __webpack_require__(70111);
var has = __webpack_require__(86656);
var fails = __webpack_require__(47293);
var definePropertyModule = __webpack_require__(3070);
var getOwnPropertyDescriptorModule = __webpack_require__(31236);
var getPrototypeOf = __webpack_require__(79518);
var createPropertyDescriptor = __webpack_require__(79114);

// `Reflect.set` method
// https://tc39.es/ecma262/#sec-reflect.set
function set(target, propertyKey, V /* , receiver */) {
  var receiver = arguments.length < 4 ? target : arguments[3];
  var ownDescriptor = getOwnPropertyDescriptorModule.f(anObject(target), propertyKey);
  var existingDescriptor, prototype;
  if (!ownDescriptor) {
    if (isObject(prototype = getPrototypeOf(target))) {
      return set(prototype, propertyKey, V, receiver);
    }
    ownDescriptor = createPropertyDescriptor(0);
  }
  if (has(ownDescriptor, 'value')) {
    if (ownDescriptor.writable === false || !isObject(receiver)) return false;
    if (existingDescriptor = getOwnPropertyDescriptorModule.f(receiver, propertyKey)) {
      if (existingDescriptor.get || existingDescriptor.set || existingDescriptor.writable === false) return false;
      existingDescriptor.value = V;
      definePropertyModule.f(receiver, propertyKey, existingDescriptor);
    } else definePropertyModule.f(receiver, propertyKey, createPropertyDescriptor(0, V));
    return true;
  }
  return ownDescriptor.set === undefined ? false : (ownDescriptor.set.call(receiver, V), true);
}

// MS Edge 17-18 Reflect.set allows setting the property to object
// with non-writable property on the prototype
var MS_EDGE_BUG = fails(function () {
  var Constructor = function () { /* empty */ };
  var object = definePropertyModule.f(new Constructor(), 'a', { configurable: true });
  // eslint-disable-next-line es/no-reflect -- required for testing
  return Reflect.set(Constructor.prototype, 'a', 1, object) !== false;
});

$({ target: 'Reflect', stat: true, forced: MS_EDGE_BUG }, {
  set: set
});


/***/ }),

/***/ 81299:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var global = __webpack_require__(17854);
var setToStringTag = __webpack_require__(58003);

$({ global: true }, { Reflect: {} });

// Reflect[@@toStringTag] property
// https://tc39.es/ecma262/#sec-reflect-@@tostringtag
setToStringTag(global.Reflect, 'Reflect', true);


/***/ }),

/***/ 24603:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(19781);
var global = __webpack_require__(17854);
var isForced = __webpack_require__(54705);
var inheritIfRequired = __webpack_require__(79587);
var defineProperty = __webpack_require__(3070).f;
var getOwnPropertyNames = __webpack_require__(8006).f;
var isRegExp = __webpack_require__(47850);
var getFlags = __webpack_require__(67066);
var stickyHelpers = __webpack_require__(52999);
var redefine = __webpack_require__(31320);
var fails = __webpack_require__(47293);
var enforceInternalState = __webpack_require__(29909).enforce;
var setSpecies = __webpack_require__(96340);
var wellKnownSymbol = __webpack_require__(5112);

var MATCH = wellKnownSymbol('match');
var NativeRegExp = global.RegExp;
var RegExpPrototype = NativeRegExp.prototype;
var re1 = /a/g;
var re2 = /a/g;

// "new" should create a new object, old webkit bug
var CORRECT_NEW = new NativeRegExp(re1) !== re1;

var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;

var FORCED = DESCRIPTORS && isForced('RegExp', (!CORRECT_NEW || UNSUPPORTED_Y || fails(function () {
  re2[MATCH] = false;
  // RegExp constructor can alter flags and IsRegExp works correct with @@match
  return NativeRegExp(re1) != re1 || NativeRegExp(re2) == re2 || NativeRegExp(re1, 'i') != '/a/i';
})));

// `RegExp` constructor
// https://tc39.es/ecma262/#sec-regexp-constructor
if (FORCED) {
  var RegExpWrapper = function RegExp(pattern, flags) {
    var thisIsRegExp = this instanceof RegExpWrapper;
    var patternIsRegExp = isRegExp(pattern);
    var flagsAreUndefined = flags === undefined;
    var sticky;

    if (!thisIsRegExp && patternIsRegExp && pattern.constructor === RegExpWrapper && flagsAreUndefined) {
      return pattern;
    }

    if (CORRECT_NEW) {
      if (patternIsRegExp && !flagsAreUndefined) pattern = pattern.source;
    } else if (pattern instanceof RegExpWrapper) {
      if (flagsAreUndefined) flags = getFlags.call(pattern);
      pattern = pattern.source;
    }

    if (UNSUPPORTED_Y) {
      sticky = !!flags && flags.indexOf('y') > -1;
      if (sticky) flags = flags.replace(/y/g, '');
    }

    var result = inheritIfRequired(
      CORRECT_NEW ? new NativeRegExp(pattern, flags) : NativeRegExp(pattern, flags),
      thisIsRegExp ? this : RegExpPrototype,
      RegExpWrapper
    );

    if (UNSUPPORTED_Y && sticky) {
      var state = enforceInternalState(result);
      state.sticky = true;
    }

    return result;
  };
  var proxy = function (key) {
    key in RegExpWrapper || defineProperty(RegExpWrapper, key, {
      configurable: true,
      get: function () { return NativeRegExp[key]; },
      set: function (it) { NativeRegExp[key] = it; }
    });
  };
  var keys = getOwnPropertyNames(NativeRegExp);
  var index = 0;
  while (keys.length > index) proxy(keys[index++]);
  RegExpPrototype.constructor = RegExpWrapper;
  RegExpWrapper.prototype = RegExpPrototype;
  redefine(global, 'RegExp', RegExpWrapper);
}

// https://tc39.es/ecma262/#sec-get-regexp-@@species
setSpecies('RegExp');


/***/ }),

/***/ 74916:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var exec = __webpack_require__(22261);

// `RegExp.prototype.exec` method
// https://tc39.es/ecma262/#sec-regexp.prototype.exec
$({ target: 'RegExp', proto: true, forced: /./.exec !== exec }, {
  exec: exec
});


/***/ }),

/***/ 92087:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(19781);
var objectDefinePropertyModule = __webpack_require__(3070);
var regExpFlags = __webpack_require__(67066);
var UNSUPPORTED_Y = __webpack_require__(52999).UNSUPPORTED_Y;

// `RegExp.prototype.flags` getter
// https://tc39.es/ecma262/#sec-get-regexp.prototype.flags
// eslint-disable-next-line es/no-regexp-prototype-flags -- required for testing
if (DESCRIPTORS && (/./g.flags != 'g' || UNSUPPORTED_Y)) {
  objectDefinePropertyModule.f(RegExp.prototype, 'flags', {
    configurable: true,
    get: regExpFlags
  });
}


/***/ }),

/***/ 88386:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(19781);
var UNSUPPORTED_Y = __webpack_require__(52999).UNSUPPORTED_Y;
var defineProperty = __webpack_require__(3070).f;
var getInternalState = __webpack_require__(29909).get;
var RegExpPrototype = RegExp.prototype;

// `RegExp.prototype.sticky` getter
// https://tc39.es/ecma262/#sec-get-regexp.prototype.sticky
if (DESCRIPTORS && UNSUPPORTED_Y) {
  defineProperty(RegExp.prototype, 'sticky', {
    configurable: true,
    get: function () {
      if (this === RegExpPrototype) return undefined;
      // We can't use InternalStateModule.getterFor because
      // we don't add metadata for regexps created by a literal.
      if (this instanceof RegExp) {
        return !!getInternalState(this).sticky;
      }
      throw TypeError('Incompatible receiver, RegExp required');
    }
  });
}


/***/ }),

/***/ 77601:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// TODO: Remove from `core-js@4` since it's moved to entry points
__webpack_require__(74916);
var $ = __webpack_require__(82109);
var isObject = __webpack_require__(70111);

var DELEGATES_TO_EXEC = function () {
  var execCalled = false;
  var re = /[ac]/;
  re.exec = function () {
    execCalled = true;
    return /./.exec.apply(this, arguments);
  };
  return re.test('abc') === true && execCalled;
}();

var nativeTest = /./.test;

// `RegExp.prototype.test` method
// https://tc39.es/ecma262/#sec-regexp.prototype.test
$({ target: 'RegExp', proto: true, forced: !DELEGATES_TO_EXEC }, {
  test: function (str) {
    if (typeof this.exec !== 'function') {
      return nativeTest.call(this, str);
    }
    var result = this.exec(str);
    if (result !== null && !isObject(result)) {
      throw new Error('RegExp exec method returned something other than an Object or null');
    }
    return !!result;
  }
});


/***/ }),

/***/ 39714:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var redefine = __webpack_require__(31320);
var anObject = __webpack_require__(19670);
var fails = __webpack_require__(47293);
var flags = __webpack_require__(67066);

var TO_STRING = 'toString';
var RegExpPrototype = RegExp.prototype;
var nativeToString = RegExpPrototype[TO_STRING];

var NOT_GENERIC = fails(function () { return nativeToString.call({ source: 'a', flags: 'b' }) != '/a/b'; });
// FF44- RegExp#toString has a wrong name
var INCORRECT_NAME = nativeToString.name != TO_STRING;

// `RegExp.prototype.toString` method
// https://tc39.es/ecma262/#sec-regexp.prototype.tostring
if (NOT_GENERIC || INCORRECT_NAME) {
  redefine(RegExp.prototype, TO_STRING, function toString() {
    var R = anObject(this);
    var p = String(R.source);
    var rf = R.flags;
    var f = String(rf === undefined && R instanceof RegExp && !('flags' in RegExpPrototype) ? flags.call(R) : rf);
    return '/' + p + '/' + f;
  }, { unsafe: true });
}


/***/ }),

/***/ 70189:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var collection = __webpack_require__(77710);
var collectionStrong = __webpack_require__(95631);

// `Set` constructor
// https://tc39.es/ecma262/#sec-set-objects
module.exports = collection('Set', function (init) {
  return function Set() { return init(this, arguments.length ? arguments[0] : undefined); };
}, collectionStrong);


/***/ }),

/***/ 15218:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var createHTML = __webpack_require__(14230);
var forcedStringHTMLMethod = __webpack_require__(43429);

// `String.prototype.anchor` method
// https://tc39.es/ecma262/#sec-string.prototype.anchor
$({ target: 'String', proto: true, forced: forcedStringHTMLMethod('anchor') }, {
  anchor: function anchor(name) {
    return createHTML(this, 'a', 'name', name);
  }
});


/***/ }),

/***/ 74475:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var createHTML = __webpack_require__(14230);
var forcedStringHTMLMethod = __webpack_require__(43429);

// `String.prototype.big` method
// https://tc39.es/ecma262/#sec-string.prototype.big
$({ target: 'String', proto: true, forced: forcedStringHTMLMethod('big') }, {
  big: function big() {
    return createHTML(this, 'big', '', '');
  }
});


/***/ }),

/***/ 57929:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var createHTML = __webpack_require__(14230);
var forcedStringHTMLMethod = __webpack_require__(43429);

// `String.prototype.blink` method
// https://tc39.es/ecma262/#sec-string.prototype.blink
$({ target: 'String', proto: true, forced: forcedStringHTMLMethod('blink') }, {
  blink: function blink() {
    return createHTML(this, 'blink', '', '');
  }
});


/***/ }),

/***/ 50915:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var createHTML = __webpack_require__(14230);
var forcedStringHTMLMethod = __webpack_require__(43429);

// `String.prototype.bold` method
// https://tc39.es/ecma262/#sec-string.prototype.bold
$({ target: 'String', proto: true, forced: forcedStringHTMLMethod('bold') }, {
  bold: function bold() {
    return createHTML(this, 'b', '', '');
  }
});


/***/ }),

/***/ 79841:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var codeAt = __webpack_require__(28710).codeAt;

// `String.prototype.codePointAt` method
// https://tc39.es/ecma262/#sec-string.prototype.codepointat
$({ target: 'String', proto: true }, {
  codePointAt: function codePointAt(pos) {
    return codeAt(this, pos);
  }
});


/***/ }),

/***/ 27852:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var getOwnPropertyDescriptor = __webpack_require__(31236).f;
var toLength = __webpack_require__(17466);
var notARegExp = __webpack_require__(3929);
var requireObjectCoercible = __webpack_require__(84488);
var correctIsRegExpLogic = __webpack_require__(84964);
var IS_PURE = __webpack_require__(31913);

// eslint-disable-next-line es/no-string-prototype-endswith -- safe
var $endsWith = ''.endsWith;
var min = Math.min;

var CORRECT_IS_REGEXP_LOGIC = correctIsRegExpLogic('endsWith');
// https://github.com/zloirock/core-js/pull/702
var MDN_POLYFILL_BUG = !IS_PURE && !CORRECT_IS_REGEXP_LOGIC && !!function () {
  var descriptor = getOwnPropertyDescriptor(String.prototype, 'endsWith');
  return descriptor && !descriptor.writable;
}();

// `String.prototype.endsWith` method
// https://tc39.es/ecma262/#sec-string.prototype.endswith
$({ target: 'String', proto: true, forced: !MDN_POLYFILL_BUG && !CORRECT_IS_REGEXP_LOGIC }, {
  endsWith: function endsWith(searchString /* , endPosition = @length */) {
    var that = String(requireObjectCoercible(this));
    notARegExp(searchString);
    var endPosition = arguments.length > 1 ? arguments[1] : undefined;
    var len = toLength(that.length);
    var end = endPosition === undefined ? len : min(toLength(endPosition), len);
    var search = String(searchString);
    return $endsWith
      ? $endsWith.call(that, search, end)
      : that.slice(end - search.length, end) === search;
  }
});


/***/ }),

/***/ 29253:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var createHTML = __webpack_require__(14230);
var forcedStringHTMLMethod = __webpack_require__(43429);

// `String.prototype.fixed` method
// https://tc39.es/ecma262/#sec-string.prototype.fixed
$({ target: 'String', proto: true, forced: forcedStringHTMLMethod('fixed') }, {
  fixed: function fixed() {
    return createHTML(this, 'tt', '', '');
  }
});


/***/ }),

/***/ 42125:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var createHTML = __webpack_require__(14230);
var forcedStringHTMLMethod = __webpack_require__(43429);

// `String.prototype.fontcolor` method
// https://tc39.es/ecma262/#sec-string.prototype.fontcolor
$({ target: 'String', proto: true, forced: forcedStringHTMLMethod('fontcolor') }, {
  fontcolor: function fontcolor(color) {
    return createHTML(this, 'font', 'color', color);
  }
});


/***/ }),

/***/ 78830:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var createHTML = __webpack_require__(14230);
var forcedStringHTMLMethod = __webpack_require__(43429);

// `String.prototype.fontsize` method
// https://tc39.es/ecma262/#sec-string.prototype.fontsize
$({ target: 'String', proto: true, forced: forcedStringHTMLMethod('fontsize') }, {
  fontsize: function fontsize(size) {
    return createHTML(this, 'font', 'size', size);
  }
});


/***/ }),

/***/ 94953:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var toAbsoluteIndex = __webpack_require__(51400);

var fromCharCode = String.fromCharCode;
// eslint-disable-next-line es/no-string-fromcodepoint -- required for testing
var $fromCodePoint = String.fromCodePoint;

// length should be 1, old FF problem
var INCORRECT_LENGTH = !!$fromCodePoint && $fromCodePoint.length != 1;

// `String.fromCodePoint` method
// https://tc39.es/ecma262/#sec-string.fromcodepoint
$({ target: 'String', stat: true, forced: INCORRECT_LENGTH }, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  fromCodePoint: function fromCodePoint(x) {
    var elements = [];
    var length = arguments.length;
    var i = 0;
    var code;
    while (length > i) {
      code = +arguments[i++];
      if (toAbsoluteIndex(code, 0x10FFFF) !== code) throw RangeError(code + ' is not a valid code point');
      elements.push(code < 0x10000
        ? fromCharCode(code)
        : fromCharCode(((code -= 0x10000) >> 10) + 0xD800, code % 0x400 + 0xDC00)
      );
    } return elements.join('');
  }
});


/***/ }),

/***/ 32023:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var notARegExp = __webpack_require__(3929);
var requireObjectCoercible = __webpack_require__(84488);
var correctIsRegExpLogic = __webpack_require__(84964);

// `String.prototype.includes` method
// https://tc39.es/ecma262/#sec-string.prototype.includes
$({ target: 'String', proto: true, forced: !correctIsRegExpLogic('includes') }, {
  includes: function includes(searchString /* , position = 0 */) {
    return !!~String(requireObjectCoercible(this))
      .indexOf(notARegExp(searchString), arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 58734:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var createHTML = __webpack_require__(14230);
var forcedStringHTMLMethod = __webpack_require__(43429);

// `String.prototype.italics` method
// https://tc39.es/ecma262/#sec-string.prototype.italics
$({ target: 'String', proto: true, forced: forcedStringHTMLMethod('italics') }, {
  italics: function italics() {
    return createHTML(this, 'i', '', '');
  }
});


/***/ }),

/***/ 78783:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var charAt = __webpack_require__(28710).charAt;
var InternalStateModule = __webpack_require__(29909);
var defineIterator = __webpack_require__(70654);

var STRING_ITERATOR = 'String Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);

// `String.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-string.prototype-@@iterator
defineIterator(String, 'String', function (iterated) {
  setInternalState(this, {
    type: STRING_ITERATOR,
    string: String(iterated),
    index: 0
  });
// `%StringIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
}, function next() {
  var state = getInternalState(this);
  var string = state.string;
  var index = state.index;
  var point;
  if (index >= string.length) return { value: undefined, done: true };
  point = charAt(string, index);
  state.index += point.length;
  return { value: point, done: false };
});


/***/ }),

/***/ 29254:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var createHTML = __webpack_require__(14230);
var forcedStringHTMLMethod = __webpack_require__(43429);

// `String.prototype.link` method
// https://tc39.es/ecma262/#sec-string.prototype.link
$({ target: 'String', proto: true, forced: forcedStringHTMLMethod('link') }, {
  link: function link(url) {
    return createHTML(this, 'a', 'href', url);
  }
});


/***/ }),

/***/ 76373:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-disable es/no-string-prototype-matchall -- safe */
var $ = __webpack_require__(82109);
var createIteratorConstructor = __webpack_require__(24994);
var requireObjectCoercible = __webpack_require__(84488);
var toLength = __webpack_require__(17466);
var aFunction = __webpack_require__(13099);
var anObject = __webpack_require__(19670);
var classof = __webpack_require__(84326);
var isRegExp = __webpack_require__(47850);
var getRegExpFlags = __webpack_require__(67066);
var createNonEnumerableProperty = __webpack_require__(68880);
var fails = __webpack_require__(47293);
var wellKnownSymbol = __webpack_require__(5112);
var speciesConstructor = __webpack_require__(36707);
var advanceStringIndex = __webpack_require__(31530);
var InternalStateModule = __webpack_require__(29909);
var IS_PURE = __webpack_require__(31913);

var MATCH_ALL = wellKnownSymbol('matchAll');
var REGEXP_STRING = 'RegExp String';
var REGEXP_STRING_ITERATOR = REGEXP_STRING + ' Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(REGEXP_STRING_ITERATOR);
var RegExpPrototype = RegExp.prototype;
var regExpBuiltinExec = RegExpPrototype.exec;
var nativeMatchAll = ''.matchAll;

var WORKS_WITH_NON_GLOBAL_REGEX = !!nativeMatchAll && !fails(function () {
  'a'.matchAll(/./);
});

var regExpExec = function (R, S) {
  var exec = R.exec;
  var result;
  if (typeof exec == 'function') {
    result = exec.call(R, S);
    if (typeof result != 'object') throw TypeError('Incorrect exec result');
    return result;
  } return regExpBuiltinExec.call(R, S);
};

// eslint-disable-next-line max-len -- ignore
var $RegExpStringIterator = createIteratorConstructor(function RegExpStringIterator(regexp, string, global, fullUnicode) {
  setInternalState(this, {
    type: REGEXP_STRING_ITERATOR,
    regexp: regexp,
    string: string,
    global: global,
    unicode: fullUnicode,
    done: false
  });
}, REGEXP_STRING, function next() {
  var state = getInternalState(this);
  if (state.done) return { value: undefined, done: true };
  var R = state.regexp;
  var S = state.string;
  var match = regExpExec(R, S);
  if (match === null) return { value: undefined, done: state.done = true };
  if (state.global) {
    if (String(match[0]) == '') R.lastIndex = advanceStringIndex(S, toLength(R.lastIndex), state.unicode);
    return { value: match, done: false };
  }
  state.done = true;
  return { value: match, done: false };
});

var $matchAll = function (string) {
  var R = anObject(this);
  var S = String(string);
  var C, flagsValue, flags, matcher, global, fullUnicode;
  C = speciesConstructor(R, RegExp);
  flagsValue = R.flags;
  if (flagsValue === undefined && R instanceof RegExp && !('flags' in RegExpPrototype)) {
    flagsValue = getRegExpFlags.call(R);
  }
  flags = flagsValue === undefined ? '' : String(flagsValue);
  matcher = new C(C === RegExp ? R.source : R, flags);
  global = !!~flags.indexOf('g');
  fullUnicode = !!~flags.indexOf('u');
  matcher.lastIndex = toLength(R.lastIndex);
  return new $RegExpStringIterator(matcher, S, global, fullUnicode);
};

// `String.prototype.matchAll` method
// https://tc39.es/ecma262/#sec-string.prototype.matchall
$({ target: 'String', proto: true, forced: WORKS_WITH_NON_GLOBAL_REGEX }, {
  matchAll: function matchAll(regexp) {
    var O = requireObjectCoercible(this);
    var flags, S, matcher, rx;
    if (regexp != null) {
      if (isRegExp(regexp)) {
        flags = String(requireObjectCoercible('flags' in RegExpPrototype
          ? regexp.flags
          : getRegExpFlags.call(regexp)
        ));
        if (!~flags.indexOf('g')) throw TypeError('`.matchAll` does not allow non-global regexes');
      }
      if (WORKS_WITH_NON_GLOBAL_REGEX) return nativeMatchAll.apply(O, arguments);
      matcher = regexp[MATCH_ALL];
      if (matcher === undefined && IS_PURE && classof(regexp) == 'RegExp') matcher = $matchAll;
      if (matcher != null) return aFunction(matcher).call(regexp, O);
    } else if (WORKS_WITH_NON_GLOBAL_REGEX) return nativeMatchAll.apply(O, arguments);
    S = String(O);
    rx = new RegExp(regexp, 'g');
    return IS_PURE ? $matchAll.call(rx, S) : rx[MATCH_ALL](S);
  }
});

IS_PURE || MATCH_ALL in RegExpPrototype || createNonEnumerableProperty(RegExpPrototype, MATCH_ALL, $matchAll);


/***/ }),

/***/ 4723:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fixRegExpWellKnownSymbolLogic = __webpack_require__(27007);
var anObject = __webpack_require__(19670);
var toLength = __webpack_require__(17466);
var requireObjectCoercible = __webpack_require__(84488);
var advanceStringIndex = __webpack_require__(31530);
var regExpExec = __webpack_require__(97651);

// @@match logic
fixRegExpWellKnownSymbolLogic('match', 1, function (MATCH, nativeMatch, maybeCallNative) {
  return [
    // `String.prototype.match` method
    // https://tc39.es/ecma262/#sec-string.prototype.match
    function match(regexp) {
      var O = requireObjectCoercible(this);
      var matcher = regexp == undefined ? undefined : regexp[MATCH];
      return matcher !== undefined ? matcher.call(regexp, O) : new RegExp(regexp)[MATCH](String(O));
    },
    // `RegExp.prototype[@@match]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@match
    function (regexp) {
      var res = maybeCallNative(nativeMatch, regexp, this);
      if (res.done) return res.value;

      var rx = anObject(regexp);
      var S = String(this);

      if (!rx.global) return regExpExec(rx, S);

      var fullUnicode = rx.unicode;
      rx.lastIndex = 0;
      var A = [];
      var n = 0;
      var result;
      while ((result = regExpExec(rx, S)) !== null) {
        var matchStr = String(result[0]);
        A[n] = matchStr;
        if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
        n++;
      }
      return n === 0 ? null : A;
    }
  ];
});


/***/ }),

/***/ 66528:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $padEnd = __webpack_require__(76650).end;
var WEBKIT_BUG = __webpack_require__(54986);

// `String.prototype.padEnd` method
// https://tc39.es/ecma262/#sec-string.prototype.padend
$({ target: 'String', proto: true, forced: WEBKIT_BUG }, {
  padEnd: function padEnd(maxLength /* , fillString = ' ' */) {
    return $padEnd(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 83112:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var $padStart = __webpack_require__(76650).start;
var WEBKIT_BUG = __webpack_require__(54986);

// `String.prototype.padStart` method
// https://tc39.es/ecma262/#sec-string.prototype.padstart
$({ target: 'String', proto: true, forced: WEBKIT_BUG }, {
  padStart: function padStart(maxLength /* , fillString = ' ' */) {
    return $padStart(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 38992:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var toIndexedObject = __webpack_require__(45656);
var toLength = __webpack_require__(17466);

// `String.raw` method
// https://tc39.es/ecma262/#sec-string.raw
$({ target: 'String', stat: true }, {
  raw: function raw(template) {
    var rawTemplate = toIndexedObject(template.raw);
    var literalSegments = toLength(rawTemplate.length);
    var argumentsLength = arguments.length;
    var elements = [];
    var i = 0;
    while (literalSegments > i) {
      elements.push(String(rawTemplate[i++]));
      if (i < argumentsLength) elements.push(String(arguments[i]));
    } return elements.join('');
  }
});


/***/ }),

/***/ 82481:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(82109);
var repeat = __webpack_require__(38415);

// `String.prototype.repeat` method
// https://tc39.es/ecma262/#sec-string.prototype.repeat
$({ target: 'String', proto: true }, {
  repeat: repeat
});


/***/ }),

/***/ 68757:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(82109);
var requireObjectCoercible = __webpack_require__(84488);
var isRegExp = __webpack_require__(47850);
var getRegExpFlags = __webpack_require__(67066);
var getSubstitution = __webpack_require__(10647);
var wellKnownSymbol = __webpack_require__(5112);
var IS_PURE = __webpack_require__(31913);

var REPLACE = wellKnownSymbol('replace');
var RegExpPrototype = RegExp.prototype;
var max = Math.max;

var stringIndexOf = function (string, searchValue, fromIndex) {
  if (fromIndex > string.length) return -1;
  if (searchValue === '') return fromIndex;
  return string.indexOf(searchValue, fromIndex);
};

// `String.prototype.replaceAll` method
// https://tc39.es/ecma262/#sec-string.prototype.replaceall
$({ target: 'String', proto: true }, {
  replaceAll: function replaceAll(searchValue, replaceValue) {
    var O = requireObjectCoercible(this);
    var IS_REG_EXP, flags, replacer, string, searchString, functionalReplace, searchLength, advanceBy, replacement;
    var position = 0;
    var endOfLastMatch = 0;
    var result = '';
    if (searchValue != null) {
      IS_REG_EXP = isRegExp(searchValue);
      if (IS_REG_EXP) {
        flags = String(requireObjectCoercible('flags' in RegExpPrototype
          ? searchValue.flags
          : getRegExpFlags.call(searchValue)
        ));
        if (!~flags.indexOf('g')) throw TypeError('`.replaceAll` does not allow non-global regexes');
      }
      replacer = searchValue[REPLACE];
      if (replacer !== undefined) {
        return replacer.call(searchValue, O, replaceValue);
      } else if (IS_PURE && IS_REG_EXP) {
        return String(O).replace(searchValue, replaceValue);
      }
    }
    string = String(O);
    searchString = String(searchValue);
    functionalReplace = typeof replaceValue === 'function';
    if (!functionalReplace) replaceValue = String(replaceValue);
    searchLength = searchString.length;
    advanceBy = max(1, searchLength);
    position = stringIndexOf(string, searchString, 0);
    while (position !== -1) {
      if (functionalReplace) {
        replacement = String(replaceValue(searchString, position, string));
      } else {
        replacement = getSubstitution(searchString, string, position, [], undefined, replaceValue);
      }
      result += string.slice(endOfLastMatch, position) + replacement;
      endOfLastMatch = position + searc