# AUTOGENERATED! DO NOT EDIT! File to edit: ../201_CutOutRandom.ipynb.

# %% auto 0
__all__ = ['CutOutRandom']

# %% ../201_CutOutRandom.ipynb 2
# library
from .holemakertechnique import HoleMakerTechnique
from .regionmodifier import RegionModifier
from .iholesfilling import HolesFilling

# others
import random
import torch
import numpy as np

# %% ../201_CutOutRandom.ipynb 4
class CutOutRandom(HolesFilling):
    "Defines the amount of holes, the technique used to make them and the probability of apply the technique."
    def __init__(self,
                 holes_num: int = 1, # The amount of holes to make.
                 modifier: "RegionModifier" = None, # The modifier that defines the traditional augments to apply to the selected regions.
                 hole_maker: "HoleMakerTechnique" = None, # The strategy used to make the holes.
                 p = 0.5): # The probability of applying this technique.
        super().__init__(modifier, hole_maker)
        self.holes_num = holes_num
        self.p = p

    def before_batch(self):
        "Applies the CutOut technique."
        
        if not self.training:
            return
        
        for image, mask in zip(self.x, self.y):
            if random.random() < self.p:
                for _ in range(self.holes_num):
                    xhole, yhole = self.make_hole(mask)
                    self.fill_hole(image, mask, xhole, yhole, [torch.min(image), 0])
