"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallDomainList = exports.FirewallDomains = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_s3_assets_1 = require("@aws-cdk/aws-s3-assets");
const core_1 = require("@aws-cdk/core");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * (experimental) A list of domains.
 *
 * @experimental
 */
class FirewallDomains {
    /**
     * (experimental) Firewall domains created from a list of domains.
     *
     * @param list the list of domains.
     * @experimental
     */
    static fromList(list) {
        for (const domain of list) {
            if (!/^([\w-.]{1,255}|\*[\w-.]{1,254})$/.test(domain)) {
                throw new Error(`Invalid domain: ${domain}. Domain can optionally start with *. Max length of 255. Valid characters: A-Z, a-z, 0-9, _, -, .`);
            }
        }
        return {
            bind(_scope) {
                return { domains: list };
            },
        };
    }
    /**
     * (experimental) Firewall domains created from the URL of a file stored in Amazon S3.
     *
     * The file must be a text file and must contain a single domain per line.
     * The content type of the S3 object must be `plain/text`.
     *
     * @param url S3 bucket url (s3://bucket/prefix/objet).
     * @experimental
     */
    static fromS3Url(url) {
        if (!core_1.Token.isUnresolved(url) && !url.startsWith('s3://')) {
            throw new Error(`The S3 URL must start with s3://, got ${url}`);
        }
        return {
            bind(_scope) {
                return { domainFileUrl: url };
            },
        };
    }
    /**
     * (experimental) Firewall domains created from a file stored in Amazon S3.
     *
     * The file must be a text file and must contain a single domain per line.
     * The content type of the S3 object must be `plain/text`.
     *
     * @param bucket S3 bucket.
     * @param key S3 key.
     * @experimental
     */
    static fromS3(bucket, key) {
        return this.fromS3Url(bucket.s3UrlForObject(key));
    }
    /**
     * (experimental) Firewall domains created from a local disk path to a text file.
     *
     * The file must be a text file (`.txt` extension) and must contain a single
     * domain per line. It will be uploaded to S3.
     *
     * @param assetPath path to the text file.
     * @experimental
     */
    static fromAsset(assetPath) {
        // cdk-assets will correctly set the content type for the S3 object
        // if the file has the correct extension
        if (path.extname(assetPath) !== '.txt') {
            throw new Error(`FirewallDomains.fromAsset() expects a file with the .txt extension, got ${assetPath}`);
        }
        return {
            bind(scope) {
                const asset = new aws_s3_assets_1.Asset(scope, 'Domains', { path: assetPath });
                if (!asset.isFile) {
                    throw new Error('FirewallDomains.fromAsset() expects a file');
                }
                return { domainFileUrl: asset.s3ObjectUrl };
            },
        };
    }
}
exports.FirewallDomains = FirewallDomains;
_a = JSII_RTTI_SYMBOL_1;
FirewallDomains[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallDomains", version: "1.140.0" };
/**
 * (experimental) A Firewall Domain List.
 *
 * @experimental
 */
class FirewallDomainList extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallDomainListProps(props);
        if (props.name && !core_1.Token.isUnresolved(props.name) && !/^[\w-.]{1,128}$/.test(props.name)) {
            throw new Error(`Invalid domain list name: ${props.name}. The name must have 1-128 characters. Valid characters: A-Z, a-z, 0-9, _, -, .`);
        }
        const domainsConfig = props.domains.bind(this);
        const domainList = new route53resolver_generated_1.CfnFirewallDomainList(this, 'Resource', {
            name: props.name,
            domainFileUrl: domainsConfig.domainFileUrl,
            domains: domainsConfig.domains,
        });
        this.firewallDomainListId = domainList.attrId;
        this.firewallDomainListArn = domainList.attrArn;
        this.firewallDomainListCreationTime = domainList.attrCreationTime;
        this.firewallDomainListCreatorRequestId = domainList.attrCreatorRequestId;
        this.firewallDomainListDomainCount = domainList.attrDomainCount;
        this.firewallDomainListManagedOwnerName = domainList.attrManagedOwnerName;
        this.firewallDomainListModificationTime = domainList.attrModificationTime;
        this.firewallDomainListStatus = domainList.attrStatus;
        this.firewallDomainListStatusMessage = domainList.attrStatusMessage;
    }
    /**
     * (experimental) Import an existing Firewall Rule Group.
     *
     * @experimental
     */
    static fromFirewallDomainListId(scope, id, firewallDomainListId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.firewallDomainListId = firewallDomainListId;
            }
        }
        return new Import(scope, id);
    }
}
exports.FirewallDomainList = FirewallDomainList;
_b = JSII_RTTI_SYMBOL_1;
FirewallDomainList[_b] = { fqn: "@aws-cdk/aws-route53resolver.FirewallDomainList", version: "1.140.0" };
//# sourceMappingURL=data:application/json;base64,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