# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/lib_nbs/methods/01_transforms.ipynb.

# %% auto 0
__all__ = []

# %% ../../nbs/lib_nbs/methods/01_transforms.ipynb 2
import numpy as np
def _softmax(beta, x):
        """
        Given an input, calculates the normalized exponential function.
        """
        # rescale exponential to avoid large numbers
        rescale = max(x)
        exp_x = np.exp(beta *(x-rescale))
        # get normalization
        norm = sum(exp_x)
        # calculate normalized exponential
        softmax_x = exp_x/norm

        return softmax_x

def _logistic(x, L:float = 1,k:float = 1,x_shift = 0,y_shift:float = 0):
    return [L/(1 + np.exp(-k*(xi-x_shift))) + y_shift for xi in x]
