"""Description"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/lib_nbs/methods/00_preprocessors.ipynb.

# %% auto 0
__all__ = ['get_percept', 'factorizor', 'action_factorizor']

# %% ../../nbs/lib_nbs/methods/00_preprocessors.ipynb 2
def get_percept(observation):
    percept = str(observation)
    return(percept)

# %% ../../nbs/lib_nbs/methods/00_preprocessors.ipynb 4
import numpy as np

class factorizor():
    def __init__(self, percept_dict = {}):
        self.percept_dict = percept_dict
    '''
    This preprocessor maintains a dictionary of all sensory elements and the order of their appearance.
    This order can be used to index the corresponding sensory representation in an ECM with factorized percepts such as the episodic ECM
    The dictionary keys a subdictionary for each dimension of an observational vector. Realized values key the sub-dictionary, and values of these subdictiories give the index of the relevant sensory representation
    '''

    def get_percept(self, observation):
        percept_indices = [None] * len(observation)
        for i in range(len(observation)):
            if not str(i) in self.percept_dict.keys(): #add new dictionary for any new dimensions in observation
                self.percept_dict[str(i)] = {}
            if not str(observation[i]) in self.percept_dict[str(i)].keys():
                self.percept_dict[str(i)][str(observation[i])] = sum([len(x) for x in self.percept_dict.values()]) #gets total number of entries. First entry is 0, so no need to add 1
            percept_indices[i] = self.percept_dict[str(i)][str(observation[i])] #get index of sensory representation for observed element
        percept = np.zeros(sum([len(x) for x in self.percept_dict.values()])) #initialize percept
        percept[percept_indices] = np.ones(len(observation))
        return percept  
    

# %% ../../nbs/lib_nbs/methods/00_preprocessors.ipynb 5
class action_factorizor(factorizor):
    '''
    This preprocessor acts like factorizor, except it assumes an agent treats a predefined number of actions as a dimension of its percept
    It thus intialize its percept dictionary with a dictionary of these n actions that label the first n sensory representations of the agent
    It also handles the addition of the observed action to the percept when get_percept is called
    '''
    def __init__(self, percept_dict = {},num_actions=None):
        self.percept_dict = percept_dict
        assert 'actions' in self.percept_dict.keys() or num_actions is not None
        if num_actions is not None:
            self.percept_dict['actions'] = {}
            for i in range(num_actions):
                self.percept_dict['actions'][str(i)] = i

    def get_percept(self, observation, action):
        percept = super().get_percept(observation)
        action_index = self.percept_dict['actions'][str(action)]
        percept[action_index] = 1
        return percept
