# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/lib_nbs/envs/01_core.ipynb.

# %% auto 0
__all__ = ['Abstract_Env', 'RLGL', 'Invader_Game_Env', 'Grid_World_Env']

# %% ../../nbs/lib_nbs/envs/01_core.ipynb 2
import numpy as np
from abc import ABC, abstractmethod

# %% ../../nbs/lib_nbs/envs/01_core.ipynb 4
class Abstract_Env(ABC):
    """
    Abstract environment from which other environments can de derived.
    """

    def __init__(self, 
                 state: object):
        """
        Args:
            state: an object that defines the state of the environment            
        """
        self.state = state

    @abstractmethod
    def transition(self, action):
        """
        Args:
            action: an action (or actions) to process
        """
        raise NotImplementedError

    @abstractmethod
    def get_observation(self):
        """
        should determine and return an observation for an agent or agents as a function of self.state
        """
        raise NotImplementedError

# %% ../../nbs/lib_nbs/envs/01_core.ipynb 6
class RLGL(Abstract_Env):
    def __init__(self, state = 0, transition_matrix = None):
        self.state = state
        self.state_labels = {0: "red", 1: "green"}
        if transition_matrix is None:
            #create random uniform transition probabilities
            transition_matrix = np.array([[0.5,0.5],[0.5,0.5]])
        assert np.shape(transition_matrix) == (2,2)
        self.transition_matrix = transition_matrix            

    def transition(self, action):
        '''
        In this environment the agents action determines the reward but does not determine the state
        '''
        self.state = np.random.choice(range(2), p = self.transition_matrix[self.state,])

    def get_observation(self):
        return self.state_labels[self.state]

    def get_reward(self, action):
        if action == self.state:
            return 1
        else:
            return 0

# %% ../../nbs/lib_nbs/envs/01_core.ipynb 10
class Invader_Game_Env(Abstract_Env):
    def __init__(self, 
                 state = None, 
                 transition_matrix = None):
        """
        Args:
            state: defines the direction of the sign of the invader, either right (0) or left (1)
            transition_matrix: a 2x2 matrix with the probabilities of transitioning from one state to another.
        If None, a random uniform transition matrix is created.  
        """
        self.state = state
        self.state_labels = {0: "right", 1: "left"}
        #transition_matrix is a 2x2 matrix with the probabilities of transitioning from one state
        if transition_matrix is None:
            #create random uniform transition probabilities
            transition_matrix = np.array([[0.5,0.5],[0.5,0.5]])
        assert np.shape(transition_matrix) == (2,2)
        self.transition_matrix = transition_matrix

    def transition(self, action):
        '''
        In this environment the agents action determines the reward but does not determine the state.
        '''
        self.state = np.random.choice(range(2), p = self.transition_matrix[self.state,])

    def get_observation(self):
        if self.state is None:
            self.state = np.random.choice(range(2))
        return self.state_labels[self.state]
    
    def get_reward(self, action, liar = False):
        """ Args:
            action: the action taken by the agent
            liar: if True, the agent is lying and the reward is always 0
        """
        if not liar:
            if action == self.state:
                return 1
            else:
                return 0
        else:
            if action != self.state:
                return 1
            else:
                return 0

# %% ../../nbs/lib_nbs/envs/01_core.ipynb 12
class Grid_World_Env(Abstract_Env):

    def __init__(self, 
                 dimensions = (10, 10),
                 N_obstacles = 10,
                 obstacle_locations = None,
                 reward_location = None,
                 state = None):
        """
        Args:
            dimensions: a tuple defining the dimensions of the grid world (rows, columns)
            N_obstacles: number of obstacles in the grid world
            state: defines the current position of the agent in the grid world as a tuple (row, column)
        """
        self.state = state
        self.dimensions = dimensions
        self.N_obstacles = N_obstacles

        self.action_labels = {0: "up",
                              1: "down", 
                              2: "left", 
                              3: "right"}
        # Place the reward at a random location in the grid world
        if reward_location is None:
            reward_location = (np.random.randint(0, dimensions[0]), np.random.randint(0, dimensions[1]))
        self.reward_location = reward_location

        # Generate random obstacle locations
        if obstacle_locations is None:
            obstacle_locations = set()
            while len(obstacle_locations) < N_obstacles:
                loc = (np.random.randint(0, dimensions[0]), np.random.randint(0, dimensions[1]))
                if loc != reward_location:  # Ensure the obstacle is not placed on the reward location
                    obstacle_locations.add(loc)
        self.obstacle_locations = list(obstacle_locations)
    
    def reset_position(self, initial_state=None):
        """
        Reset the agent's position to a random location in the grid world.
        """
        if initial_state is None:
            self.state = (np.random.randint(0, self.dimensions[0]), np.random.randint(0, self.dimensions[1]))
            while self.state in self.obstacle_locations:
                self.state = (np.random.randint(0, self.dimensions[0]), np.random.randint(0, self.dimensions[1]))
        else:
            self.state = initial_state

    def transition(self, action, periodic = False):
        '''
        Move the agent in the grid world based on the action taken.
        '''
        action = self.action_labels[action]
        if periodic:
            if action == "right":
                new_state = ((self.state[0])%self.dimensions[0] + 1, self.state[1])
            elif action == "left":
                new_state = ((self.state[0]-1)%self.dimensions[0], self.state[1])
            elif action == "down":
                new_state = (self.state[0], (self.state[1]-1)%self.dimensions[1])
            elif action == "up":
                new_state = (self.state[0], (self.state[1]+1)%self.dimensions[1])
        else:
            if action == "right":
                new_state = (min(self.state[0] + 1, self.dimensions[0] - 1), self.state[1])
            elif action == "left":
                new_state = (max(self.state[0] - 1, 0), self.state[1])
            elif action == "down":
                new_state = (self.state[0], max(self.state[1] - 1, 0))
            elif action == "up":
                new_state = (self.state[0], min(self.state[1] + 1, self.dimensions[1] - 1))
        # Change the state only if the new state is not an obstacle
        if new_state not in self.obstacle_locations:# and new_state != self.reward_location:
            self.state = new_state

    def get_observation(self):
        return str(self.state)
    
    def get_reward(self):
        if self.state == self.reward_location:
            return 1
        else:
            return 0
