# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/lib_nbs/agents/01_core.ipynb.

# %% auto 0
__all__ = ['Abstract_Agent', 'Basic_Agent', 'Basic_2Layer_Agent']

# %% ../../nbs/lib_nbs/agents/01_core.ipynb 5
from ..methods.lib_helpers import CustomABCMeta
from abc import abstractmethod

class Abstract_Agent(metaclass = CustomABCMeta):

    def __init__(self, 
                 ECM = None, #The compulsory ECM Object to use. If kept Nonem raises error.
                 percept_processor = None, #An optional object for transforming observations prior to passing to ECM as a percept. Must have method "preprocess" 
                 action_processor = None #An optional object for transforming actions prior to passing to Environment as an actuator state. Must have method "postprocess" 
                ):
        
        """
        Abstract agent class any PS agent should be derived from. 
        Asserts that the necessary methods are implemented. 
        """
        self.ECM = ECM
        assert ECM is not None

        self.percept_processor = percept_processor
        if percept_processor is not None:
            assert hasattr(percept_processor, "preproccess")

        self.action_processor = action_processor
        if action_processor is not None:
            assert hasattr(action_processor, "postprocess")  

    @abstractmethod
    def update(self):
        ''' Updates the internal structure of the agent, typically by updating its ECM.'''
        pass
    
    @abstractmethod
    def deliberate(self):
        ''' Returns the action to be taken by the agent. Typically, this would involve getting a state from the environment, 
        passing it through the percept processor, passing it to the ECM, and then passing the output through the action processor if needed.'''
        pass
    
    

# %% ../../nbs/lib_nbs/agents/01_core.ipynb 12
class Basic_Agent(Abstract_Agent):
    
    def __init__(self, 
                 ECM : object = None, # ECM object
                 percept_processor : object = None # Preprocessor object for transforming observations prior to passing to ECM as a percept. Must have method "preprocess"
                ):
        """
        Simple, projective simulation (PS) with arbitrary ECM.
        Uses the typical ECM structure (see module ECMs).
        Percepts are added to the ECM as new obsevations are encountered
        
        """
        self.ECM = ECM

        if percept_processor is not None:
            self.percept_processor = percept_processor
            assert hasattr(self.percept_processor, "preprocess")    
        else:
            self.percept_processor = None  

        super().__init__(ECM = self.ECM, percept_processor = percept_processor)  
        
        
    def deliberate(self, 
                observation: object # Data object passed from the environment/sensors
               )-> int : # Action to be performed.
        """
        Given an observation, returns an action. 
        """
        if self.percept_processor is not None:
            percept = self.percept_processor(observation)
        else:
            percept = observation

        action = self.ECM.sample(percept)

        return action

    def update(self, 
               reward #Value used for reinforcement. Likely a float
              ):
        """
        Given a reward, updates the ECM parameters
        """
        self.ECM.learn(reward)

# %% ../../nbs/lib_nbs/agents/01_core.ipynb 17
from ..ECMs.core import Two_Layer

class Basic_2Layer_Agent(Basic_Agent):
    def __init__(self, 
                 num_actions : int, # The number of available actions. If ECM = is not given, must be int
                 glow: float = 0.1, # The glow (or eta) parameter. Won't be used if ECM is given
                 damp: float = 0., # The damping (or gamma) parameter. Won't be used if ECM is given
                 glow_method: str = 'sum', # The method for updating the glow. See ECMs.Two_Layer for details
                 policy : str = 'greedy', # The policy to use. See ECMs.Two_Layer for details
                 policy_parameters : dict = None, # The parameters for the policy. See ECMs.Two_Layer for details
                 percept_processor = None
                ):
        """
        Basic PS agent with a two layer ECM. Percepts are added to the ECM as new obsevations are encountered.        
        """

        self.ECM = Two_Layer(num_actions = num_actions, 
                            g_damp = glow,
                            h_damp =  damp,
                            glow_method = glow_method,
                            policy = policy, 
                            policy_parameters = policy_parameters)
        
        super().__init__(ECM = self.ECM, percept_processor = percept_processor)
