# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/lib_nbs/ECMs/02_priming.ipynb.

# %% auto 0
__all__ = ['Priming_ECM']

# %% ../../nbs/lib_nbs/ECMs/02_priming.ipynb 3
from ..methods import transforms
from .core import Two_Layer
import numpy as np

class Priming_ECM(Two_Layer):
    def __init__(self, 
                 num_actions: int, # The number of available actions.                 
                 glow: float = 0.1, # The glow (or eta) parameter. 
                 damp: float = 0.01, # The damping (or gamma) parameter. 
                 softmax: float = 0.5, # The softmax (or beta) parameter.
                 action_primes: list = None, #weights on the probability that deliberation steps into each action. Defaults to 0 for each action 
                ):
        
        '''
        This sub-class of the Two-Layer ECM adds a variable for action priming.
        This variable should be a list of floats, each element of which corresponds to an action in the ECM.
        These "priming values" are summed with h-values of any edge connected to the associated action node prior to calculating walk probabilites with the softmax function
        '''
        if action_primes is None:
            action_primes = [0.] * num_actions
        assert len(action_primes) == num_actions

        self.softmax = softmax
        super().__init__(num_actions, glow, damp, 
                         policy = None) # Here I made explicit that the policy is None, as we override the sample method
        self.action_primes = action_primes
        

    def sample(self, percept):
        '''
        Almost identical to the sample function of Two-Layer parent class, but sums h-values and action primes prior to calculating walk probabilities
        '''
        self.add_percept(percept)
        #Perform Random Walk
        # get index from dictionary entry
        percept_index = self.percepts[percept]
        # get h-values
        h_values = self.hmatrix[percept_index]
        #~~~Differences from two-layer sample function within
        assert len(h_values) == len (self.action_primes)
        # get probabilities from h-values and primes through a softmax function
        prob = transforms._softmax(self.softmax, h_values + self.action_primes)
        #~~~~~~~
        # get action
        action = np.random.choice(range(self.num_actions), p=prob)        
        #pdate g-matrix
        self.gmatrix[int(percept_index),int(action)] = 1.
        return action
