Projective Simulation
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->
<p align="center">
<img width="250" src="figs/ps_logo.png">
</p>
<h3 align="center">
<em>Agency • Learning • Physics</em>
</h3>
<p align="center">
<a href="https://badge.fury.io/py/projective_simulation"><img src="https://badge.fury.io/py/projective_simulation.svg" alt="PyPI version"></a>
<a href="https://badge.fury.io/py/projective_simulation"><img src="https://img.shields.io/badge/python-3.10-red" alt="Python version"></a>
</p>
<p align="center">
<a href="https://qic-ibk.github.io/projective_simulation/">Get
started</a> \|
<a href="https://qic-ibk.github.io/projective_simulation/lib_nbs/index_docs.html">Documentation</a>
\|
<a href="https://qic-ibk.github.io/projective_simulation/tutorials/index_tutorials.html">Tutorials</a>
</p>

Projective Simulation (PS) is a framework for studying agency from a
physical perspective. PS agents learn from interaction with their
environment and base their decisions on **episodic memory**. Internally,
their deliberation corresponds to **random walks on a clip network
(graph)**, which provides an interpretable route to physical
realizations and analysis.

This library all the necessary tools to develop, deploy and train PS
agents in a variety of environments. Its content spans from entry-level
[tutorials](tutorials/index_tutorials.ipynb) that introduce the core
principles of PS to cutting-edge [research](webpage/research.ipynb) on
the latest developments and applications. It is actively developed by
the [QIC group at UIBK](https://www.uibk.ac.at/en/th-physik/qic-group/).

## Installation

Projective simulation is available for `python>=3.10` via

``` python
pip install projective_simulation
```

This will also install the necessary library requirements.

## Getting Started

To begin exploring Projective Simulation, we recommend to start with the
[tutorials](tutorials/index_tutorials.ipynb), which contain from the
basics to more advance applications.

If you want to develop or deploy PS agents, please check the
[documetation](lib_nbs/index_docs.ipynb).

## Citing

If you found this package useful and used it in your projects, you can
either the particular PS paper that you found most useful (see a list
[here](figs/PS_mindmap.html)) or use the following to cite the whole
library:

``` python
here will be some zenodo link
```
